# Warning: 0072

An Array field in the package.json was defined with another type.

## Description

The package.json additions that Piral brings to the table are all well-defined. As such
using unexpected types such as a string in case of an array will be ignored and will lead
to warnings.

## Example

In case of, e.g., "externals" an array needs to be supplied. So given the following snippet
of a package.json

```json
{
  "name": "my-app-shell",
  "version": "1.0.0",
  "app": "src/index.html",
  "pilets": {
    "externals": true
  }
}
```

the value needs to be a valid array. It could be also dismissed or presented as an empty array.

The following would work:

```json
{
  "name": "my-app-shell",
  "version": "1.0.0",
  "app": "src/index.html",
  "pilets": {
    "externals": []
  }
}
```

## Further Reading

 - [JavaScript Types](https://javascript.info/types)
- [JSON Types](https://cswr.github.io/JsonSchema/spec/basic_types/)
