# Error: 0071

The package.json of the Piral instance is missing the "app" field.

## Description

A Piral instance needs to be a valid Node.js project. Valid Node.js projects contain a
package.json file in their root directory. This file is used by the Piral CLI to get
relevant meta data for the Piral instance.

Among other meta data the file requires a special field "app". The field is used to
indicate what file to be used as entry point for the bundler. It is usually set to an
HTML file containing a reference to the entry script(s) and style sheet(s).

## Example

The following shows a valid package.json of a Piral instance:

```json
{
  "name": "my-app-shell",
  "version": "1.0.0",
  "app": "src/index.html",
  "dependencies": {
    "piral": "0.11.0"
  },
  "devDependencies": {
    "piral-cli": "0.11.0"
  },
  "pilets": {}
}
```

The app field indicates what file to use as entry point.

## Further Reading

 - [Parcel Bundling](https://codeburst.io/bundle-your-web-application-with-parceljs-b4eee99bdb55)
