# Error: 0070

The package.json containing a valid entry point for the Piral instance is missing.

## Description

A Piral instance needs to be a valid Node.js project. Valid Node.js projects contain a
package.json file in their root directory. This file is used by the Piral CLI to get
relevant meta data for the Piral instance.

The relevant meta data includes information such as the name of the Piral instance, the
additional typings, what dependencies are shared with the pilets, and what is the entry
point for bundling.

The entry point for bundling refers to the index.html file that should act as the file
containing all references for scripts, stylesheets, and other resources.

## Example

The following shows a valid package.json of a Piral instance:

```json
{
  "name": "my-app-shell",
  "version": "1.0.0",
  "app": "src/index.html",
  "dependencies": {
    "piral": "0.11.0"
  },
  "devDependencies": {
    "piral-cli": "0.11.0"
  },
  "pilets": {}
}
```

The app field indicates what file to use as entry point.

## Further Reading

 - [Parcel Bundling](https://codeburst.io/bundle-your-web-application-with-parceljs-b4eee99bdb55)
