# Error: 0064

Did finish uploading the pilet(s) with errors.

## Description

The Piral CLI tries to upload all matched .tgz files. In case of
multiple hits all files are published. This may not be the behavior you
look for as it will lead to errors in case of already published pilets.

To avoid uploading already published pilets either perform a fresh
build omitting any tgz inputs at all or specify the tgz file directly.

## Example

To perform a fresh build use the following command:

```sh
pilet publish --fresh --url sample
```

In order to specify the file explicitly just use a positional argument.

```sh
pilet publish my-pilet-1.0.0.tgz --url sample
```

Make sure that the specified file exists.

Additionally, you can use globs to match multiple files.

## Further Reading

 - [Semantic Versioning](https://semver.org)
