# Warning: 0062

Could not upload the pilet to the pilet feed.

## Description

Uploading to the pilet feed service API failed. This could have various reasons:

- Loss of connectivity
- The provided authentication was invalid or missing
- The URL was invalid
- The feed service does not follow the specification
- A custom condition from the feed service was rejected
- The given pilet was already available at the feed service

The Piral CLI will print the error response from the feed service. Please contact
your feed service admin if nothing was printed.

## Example

Make sure that you are connected to the internet and that the desired feed service URL
can be reached from your computer.

Run

```sh
pilet publish --fresh --url https://myfeedservice.com/api/pilet
```

Look at the error response. Make sure that your version is not yet published. If other
conditions (e.g., a certain naming convention for your pilet) need to be followed adjust
the package.json accordingly.

## Further Reading

 - [Feed API Specification](https://docs.piral.io/reference/specifications/feed-api-specification)
