# Error: 0061

Could not find a valid pilet to upload to the pilet feed.

## Description

The `pilet publish` commands works against an already created pilet package.
If no pilet package is yet available the command will ultimately fail.

There are a couple of options. For instance, using the `--fresh` flag it is
possible to trigger a `pilet build` and `pilet pack` process implicitly.

Otherwise, make sure to have a `.tgz` file in the directory or specify it
directly.

## Example

Make sure to have build a pilet beforehand:

```sh
pilet build
```

Then you should pack the current contents:

```sh
pilet pack
```

Finally, you can publish it:

```sh
pilet publish --url sample
```

To do these three commands in one sweep just use `--fresh`:

```sh
pilet publish --fresh --url sample
```

Using multiple commands is preferred if you use custom options, otherwise
just go for the single command.

## Further Reading

 - [npm Pack](https://docs.npmjs.com/cli-commands/pack.html)
