# Warning: 0053

Reported when a dependency cannot be resolved.

## Description

When a pilet is scaffolded from a Piral instance special dev tools may be installed
as specified from the "devDependencies" section in the "pilets" section.

The default version resolution falls back to the version specified already in the
standard "devDependencies" of the Piral instance's package.json.

Under some conditions no version of the specified dependency can be determined.

The conditions may be:

- Missing dev dependencies
- Invalid dev dependencies
- Disk failures

## Example

The primary example hits when a dev dependency was specified that is otherwise not given.

Consider the following package.json:

```json
{
  "name": "my-piral",
  "devDependencies": {},
  "pilets": {
    "devDependencies": {
      "prettier": true
    }
  }
}
```

Just make sure that `prettier` is already available on the standard `devDependencies`.

```json
{
  "name": "my-piral",
  "devDependencies": {
    "prettier": "^1.0.0"
  },
  "pilets": {
    "devDependencies": {
      "prettier": true
    }
  }
}
```

## Further Reading

 - [Piral Instance Package Definition](https://docs.piral.io/reference/documentation/C21-piral-metadata)
