# Warning: 0051

Reported when the Piral instance is resolved via git, but an invalid version was specified.

## Description

The Piral instance is currently resolved via Git, but latest was not used to try a direct update.

Right now we only support "latest" for Git resolved Piral instances. In this scenario we obtain the
current head from the repository's default branch and update accordingly.

Potentially, you wanted to switch / resolve the module from npm instead. Therefore, we are then trying to
obtain the Piral instance from npm instead using the known name.

## Example

You may have set up the pilet using a locally available tgz file. In this case your original command may
have looked similar to:

```json
pilet new https://github.com/foo/my-app-shell.git
```

To run an upgrade in such a scenario a command such as

```sh
pilet upgrade latest
```

needs to be used.

Since "latest" is the default version the specifier can actually be omitted, too.

## Further Reading

 - [Git Dependencies in npm](https://medium.com/@jonchurch/use-github-branch-as-dependency-in-package-json-5eb609c81f1a)
