# Warning: 0050

Reported when the Piral instance is locally resolved, but no location for the upgrade is known.

## Description

The Piral instance is currently resolved locally, but no local file for the upgrade has been specified.

Since the local resolution only works against a filename the update process has also to be triggered with
a file location. Otherwise, there is no chance to know a different file location.

Potentially, you wanted to switch / resolve the module from npm instead. Therefore, we are then trying to
obtain the Piral instance from npm instead using the known name.

## Example

You may have set up the pilet using a locally available tgz file. In this case your original command may
have looked similar to:

```json
pilet new ../../my-app-shell/dist/emulator/my-app-shell-1.0.0.tgz
```

To run an upgrade in such a scenario a command such as

```sh
pilet upgrade ../../my-app-shell/dist/emulator/my-app-shell-1.1.0.tgz
```

needs to be used.

## Further Reading

 - [Local File Dependencies](https://stackoverflow.com/questions/14381898/local-dependency-in-package-json)
