# Warning: 0045

Reported when a file could not be overwritten.

## Description

Usually, this only indicates that a file already existed and was not overwritten.
There are three modes concerning the overwrite policy:

- Do not overwrite (usually the default)
- Ask before overwriting
- Always overwrite

In the first mode the warning is produced to indicate an operation was not
performed due to the integrated overwrite protection.

## Example

Many commands allow setting the overwrite mode. For instance, when performing an
upgrade of a pilet we can set it.

To ask before overwriting the following command works:

```sh
pilet upgrade --force-overwrite prompt
```

If you want to always overwrite use:

```sh
pilet upgrade --force-overwrite yes
```

## Further Reading

 - [File System Permissions](https://en.wikipedia.org/wiki/File_system_permissions)
