# Error: 0044

The desired target directory could not be created.

## Description

When a non-existing target directory is specified the Piral CLI needs to create it first. This,
however, can lead to problems if

- the file system is corrupted
- necessary privileges are missing
- the given path is invalid

If one of these cases is hit the Piral CLI needs to stop the action.

## Example

On nix systems the easiest way to ensure ownership of a folder is using the `chmod` command.
Make sure, however, to only expand permissions when overall security is still ensured.

Ideally, you'd select a folder that is below your home directory. That way the necessary
permissions are there by definition.

On nix systems you can change to your home directory via:

```sh
cd ~
```

On Windows you can use:

```sh
cd %HOMEPATH%
```

## Further Reading

 - [File System Permissions](https://en.wikipedia.org/wiki/File_system_permissions)
