# Error: 0043

The reference to the Piral instance in the "package.json" file is invalid.

## Description

Even though everything seems to be correct on the first glance it may be that the
actual reference is broken. This could be due to various reasons.

- npm linking is broken
- The dependencies have not been installed yet (run `npm i`)
- The Piral instance's name is invalid (e.g., due to a typo)

## Example

Let's say you just cloned the pilet via

```sh
git clone https://myhub.com/mypilet
```

Right now the dependencies should still be missing as dependencies are usually not
checked in. Under these circumstances the Piral instance reference is invalid.

Make sure to resolve the dependencies correctly by running

```sh
npm i
```

## Further Reading

 - [Pilet Package Definition](https://docs.piral.io/reference/documentation/C31-pilet-metadata)
- [Node Modules Loading](https://nodejs.org/api/modules.html#modules_loading_from_node_modules_folders)
