# Error: 0042

The field "name" in the "piral" section of the "package.json" file is missing.

## Description

The Piral CLI has to get some meta information for a pilet from its package.json.
The meta information include its name, version, which Piral instance to use, as well
as other relevant infos.

Make sure that you modified the package.json correctly using the specification for
pilets or that the pilet was initially created / scaffolded by the Piral CLI using
the

```sh
pilet new
```

command.

Specifically, the package.json needs to contain a special section called `piral`, which
should contain (among others) a field `name` pointing to the Piral instance to use.

## Example

If your Piral instance is called `my-piral` then the package.json may look similar to
the following snippet:

```json
{
  "name": "my-pilet",
  "version": "1.0.0",
  "devDependencies": {
    "my-piral": "1.0.0",
    "piral-cli": "0.11.0"
  },
  "piral": {
    "name": "my-piral",
    "tooling": "0.11.0"
  }
}
```

## Further Reading

 - [Pilet Package Definition](https://docs.piral.io/reference/documentation/C31-pilet-metadata)
