# Error: 0028

The provided importmap file could not be found.

## Description

The importmap can be referenced in a file from the package.json. If the named
file cannot be found the build process has to be stopped. Make sure that the
file has been specified relative to the package.json where it was referenced
from.

## Example

Check the contents of the available package.json:

```sh
cat package.json
```

The displayed content should look similar to (i.e., contain an importmap such as):

```json
{
  "importmap": "./import-map.json"
}
```

If the importmap has instead been (re)named "importmap.json" then this will not work.
Likewise, with the reference above the file is expected to be in the same directory
as the package.json. If it is, e.g., in the "src" subfolder you'd should reference it
as "./src/import-map.json" instead.

## Further Reading

 - [import-maps specification](https://github.com/WICG/import-maps)
