# Error: 0027

The provided importmap reference could not be resolved.

## Description

The importmap consists of keys and values. The keys represent the packages names and optional
version specifiers to demand at runtime. The values represent the entry point or URL to use
when the dependency is not yet loaded.

In case of a non-URL value the reference has either to be a valid package name or a file path
that leads to either a package or valid JS module. Either way, it needs to exist. If the path
is invalid an error will be emitted.

## Example

Check the contents of the available package.json:

```sh
cat package.json
```

The displayed content should look similar to (i.e., contain an importmap such as):

```json
{
  "importmap": {
    "imports": {
      "foo@bar": "./node_modules/prect"
    }
  }
}
```

Note the potential misspelling. It maybe should have been "./node_modules/preact". In such
cases the reference may not be resolved locally. If everything was written correctly the
node modules are most likely not installed (correctly).

## Further Reading

 - [npm Install](https://docs.npmjs.com/cli/install)
