# Error: 0026

The version spec part of the importmap identifer is invalid.

## Description

The importmap definition allows you to define a version specifier separated with
the '@' character. This part has to follow the semver convention and rules.

Check your specifier via online tools such as "Semver check" to verify it is
valid and follows the semver specification.

## Example

Check the contents of the available package.json:

```sh
cat package.json
```

The displayed content should look similar to (i.e., contain an importmap such as):

```json
{
  "importmap": {
    "imports": {
      "foo@bar": "foo"
    }
  }
}
```

For the error to occur the specifier (bar) is not following the semver specification.

One way is to remove the version spec, which will resolve to an exact version specifier
and therefore always works:

```json
{
  "importmap": {
    "imports": {
      "foo": "foo"
    }
  }
}
```

The best way, however, is to look at the used version and adjust the specifier to be correct again,
such as "^1.2.3" or "1.x" or "3" etc.

## Further Reading

 - [Online Checker](https://jubianchi.github.io/semver-check/)
