# Error: 0025

Cannot add the shared dependency since its version constraint is not satisfied.

## Description

The importmap definition allows you to define a version specifier separated with
the '@' character. If you write down a version specifier then it has to be
fulfilled already from the local version, otherwise the packaged version can
potentially not be resolved at runtime. This would resolve in a pilet that fails
when running in isolation and most likely fails when running with other pilets.

## Example

Check the contents of the available package.json:

```sh
cat package.json
```

The displayed content should look similar to (i.e., contain an importmap such as):

```json
{
  "importmap": {
    "imports": {
      "foo@^3.2.1": "foo"
    }
  }
}
```

For the error to occur the specifier (^3.2.1) potentially does not match the version (e.g., if
the version of the dependency is 3.1.2).

One strategy is to remove the specifier, which will automatically use the exact current version
as specifier:

```json
{
  "importmap": {
    "imports": {
      "foo": "foo"
    }
  }
}
```

The best way, however, is to look at the used version and adjust the specifier to be correct again.
Alternatively, change the used version to satisfy the constraint again.

## Further Reading

 - [import-maps specification](https://github.com/WICG/import-maps)
