# Error: 0022

Cannot pack the pilet - missing version.

## Description

For performing this action on the pilet the piral-cli needs to know the version of the pilet.
The version of the pilet is provided by the version field specified in its package.json.

A valid package.json file requires a valid version. The version has to follow standard semver
specification.

## Example

Check the contents of the available package.json:

```sh
cat package.json
```

The displayed content should look similar to:

```json
{
  "name": "my-pilet",
  "version": "1.0.0",
  "dependencies": {},
  "devDependencies": {
    "piral-cli": "^0.11.0",
    "my-piral": "1.0.0"
  },
  "piral": {
    "name": "my-piral",
    "tooling": "0.11.0"
  }
}
```

The exact values do not matter much, but rather the general structure.

## Further Reading

 - [npm on Semantic Versioning](https://docs.npmjs.com/about-semantic-versioning)
