# Error: 0021

Cannot pack the pilet - missing name.

## Description

For performing this action on the pilet the piral-cli needs to know the name of the pilet.
The name of the pilet is provided by the name field specified in its package.json.

A valid package.json file requires a valid name. The name has to follow standard naming
conventions of the npm system.

## Example

Check the contents of the available package.json:

```sh
cat package.json
```

The displayed content should look similar to:

```json
{
  "name": "my-pilet",
  "version": "1.0.0",
  "dependencies": {},
  "devDependencies": {
    "piral-cli": "^0.11.0",
    "my-piral": "1.0.0"
  },
  "piral": {
    "name": "my-piral",
    "tooling": "0.11.0"
  }
}
```

The exact values do not matter much, but rather the general structure.

## Further Reading

 - [Package Naming Guidelines](https://docs.npmjs.com/package-name-guidelines)
