# Error: 0012

Reported when no valid Piral instance was specified.

## Description

The Piral instance is defined either in the package.json or in the pilet.json.

The resolution of the Piral instance is done via the `require.resolve` function of Node.js. Thus, if the defined module is simply not yet installed this error will be shown.

## Example

Assuming that the available pilet.json of your pilet contains content such as:

```json
{
  // ...
  "piralInstances": {
    "my-app-shell": {}
  }
}
```

However, running

```sh
ls node_modules/my-app-shell
```

returns an error.

To mitigate it try running

```sh
npm i
```

which will install all dependencies.

## Further Reading

 - [npm i](https://docs.npmjs.com/cli/install)
- [npm install is missing modules](https://stackoverflow.com/questions/24652681/npm-install-is-missing-modules)
