# Error: 0010

Reported when the Piral instance defined in the package.json could not be found.

## Description

The Piral instance is defined in the package.json via an object set as value of the "piral" key.

The resolution of the Piral instance is done via the `require.resolve` function of Node.js. Thus, if the defined module is simply not yet installed this error will be shown.

## Example

Assuming that the available package.json of your pilet contains content such as:

```json
{
  "name": "my-pilet",
  // ...
  "piral": {
    "name": "my-app-shell"
  }
}
```

However, running

```sh
ls node_modules/my-app-shell
```

returns an error.

To mitigate it try running

```sh
npm i
```

which will install all dependencies.

## Further Reading

 - [npm i](https://docs.npmjs.com/cli/install)
- [npm install is missing modules](https://stackoverflow.com/questions/24652681/npm-install-is-missing-modules)
