---
title: History
---

# History

## Large Web Apps

In the past, we developed several "grand scale web apps", which have been deployed not only on the web but also packaged as apps.

The requirements and essential feature set of these apps were always the same (as viewed from a high-level perspective):

- React as a core layer
- Extensibility from the ground up
- Rich common API for these modules
- Support for multiple languages
- Enhanced developer experience

## Portal Applications

This kind of "grand scale web app" is labeled by us as a "portal application". The reason is simple: The individual feature modules, which we call "pilets" are nothing more than a window to see/interact with parts of the backend. Like a portal, Piral itself just connects all these different modules.

After developing (or refining) the same solution over and over again the need for a generic (FOSS) solution became obvious. With Piral we want to reach that goal to provide a layer that boosts the development of such applications. Our goal is to reduce the development need to only require setting up the domain-specific parts and needed customizations (e.g., having a custom design, wording, ...).

## Goals of Piral

In a nutshell, Piral tries to allow you to

> easily build a next-generation portal application.

We want to provide the full end-to-end experience, from development to release in production.

In the Fall of 2018, we began planning the project. In February 2019 the first code was written. The first real applications using Piral have been released in the second half of 2019. The first fully production-ready version was anticipated for 2020. It was released in December 2020.
