<?php
require '../conn/conn.php';
require '../conn/function.php';
require 'member_check.php';

$D_domain=splitx($_SERVER["HTTP_HOST"].$_SERVER["PHP_SELF"],"/member",0);

?>
<!DOCTYPE html>
<html lang="zh">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" />
<title>API文档 - 会员中心</title>
<link rel="icon" href="../media/<?php echo $C_ico?>" type="image/ico">
<link href="../css/bootstrap.min.css" rel="stylesheet">
<link href="../css/materialdesignicons.min.css" rel="stylesheet">
<link href="../css/style.min.css" rel="stylesheet">
<link rel="stylesheet" href="../js/jconfirm/jquery-confirm.min.css">
<style type="text/css">
.pagination{margin: 0px;}
</style>
</head>
  
<body>
<div class="lyear-layout-web">
  <div class="lyear-layout-container">
  <?php require 'nav.php';?>
    <main class="lyear-layout-content">
      <div class="container-fluid">
        <div class="row">

          <div class="col-md-6">
            <div class="card">
              <div class="card-header"><h4>生成短链</h4></div>
              <div class="card-body">
              	<p><b>请求地址：</b><?php echo gethttp().$D_domain?>/api</p>
              	<p><b>请求方式：</b>GET <b>返回方式：</b>JSON</p>
              	<p><table class="table">
              		<tr><th>请求参数</th><th>解释</th><th>示例</th></tr>
              		<tr><td>method</td><td>请求方法</td><td>add</td></tr>
              		<tr><td>key</td><td>会员key，从会员中心获取</td><td>0cc175b9c0f1b6a831c399e269772661</td></tr>
              		<tr><td>url</td><td>原网址（多个用|隔开）</td><td>http://www.baidu.com|http://www.qq.com</td></tr>
                  <tr><td>vip</td><td>短链是否永久，0：一个月，1：永久</td><td>1</td></tr>
              	</table></p>
                <hr>
                说明：（1）url传入前需要用urlencode转码（2）如果生成永久链接，请保证账户余额充足
                <p><table class="table">
                  <tr><th>返回参数</th><th>解释</th><th>示例</th></tr>
                  <tr><td>code</td><td>返回码</td><td>success：成功，error：错误</td></tr>
                  <tr><td>id</td><td>短链编号</td><td>1</td></tr>
                  <tr><td>vip</td><td>短链是否永久，0：一个月，1：永久</td><td>123</td></tr>
                  <tr><td>short</td><td>短链接</td><td><?php echo gethttp().$D_domain?>/s/d</td></tr>
                  <tr><td>long</td><td>原网址</td><td>http://www.baidu.com</td></tr>
                  <tr><td>time</td><td>短链接生成时间</td><td>2021-01-18 15:38:52</td></tr>
                </table></p>
                <hr>
                <p style="word-break:break-all;"><b>请求示例</b>：<br><?php echo gethttp().$D_domain?>/api?method=add&key=0cc175b9c0f1b6a831c399e269772661&vip=1&url=http%3a%2f%2fwww.baidu.com%7chttp%3a%2f%2fwww.qq.com%7c222</p>
                <hr>
                <p style="word-break:break-all;"><b>返回示例：</b><br>[{"code":"success","id":"1","vip":"1","short":"<?php echo gethttp().$D_domain?>/s/d","long":"http://www.baidu.com","time":"2021-01-18 15:38:52"},{"code":"success","id":"2","vip":"1","short":"<?php echo gethttp().$D_domain?>/s/d","long":"http://www.qq.com","time":"2021-01-18 15:38:52"},{"code":"error","msg":"网址格式不正确！","long":"222","time":"2021-01-18 15:38:52"}]</p>
                <hr>

              </div>
            </div>
          </div>

          <div class="col-md-6">
            <div class="card">
              <div class="card-header"><h4>获取短链列表</h4></div>
              <div class="card-body">
                <p><b>请求地址：</b><?php echo gethttp().$D_domain?>/api</p>
                <p><b>请求方式：</b>GET <b>返回方式：</b>JSON</p>
                <p><table class="table">
                  <tr><th>请求参数</th><th>解释</th><th>示例</th></tr>
                  <tr><td>method</td><td>请求方法</td><td>list</td></tr>
                  <tr><td>key</td><td>会员key，从会员中心获取</td><td>0cc175b9c0f1b6a831c399e269772661</td></tr>

                </table></p>


                <p><table class="table">
                  <tr><th>返回参数</th><th>解释</th><th>示例</th></tr>
                  <tr><td>code</td><td>返回码</td><td>success：成功，error：错误</td></tr>
                  <tr><td>id</td><td>短链编号</td><td>1</td></tr>
                  <tr><td>vip</td><td>短链是否永久，0：一个月，1：永久</td><td>123</td></tr>
                  <tr><td>short</td><td>短链接</td><td><?php echo gethttp().$D_domain?>/s/d</td></tr>
                  <tr><td>long</td><td>原网址</td><td>http://www.baidu.com</td></tr>
                  <tr><td>time</td><td>短链接生成时间</td><td>2021-01-18 15:38:52</td></tr>
                </table></p>
                <hr>
                <p style="word-break:break-all;"><b>请求示例</b>：<br><?php echo gethttp().$D_domain?>/api?method=list&key=0cc175b9c0f1b6a831c399e269772661</p>
                <hr>
                <p style="word-break:break-all;"><b>返回示例：</b><br>[{"code":"success","id":"1","vip":"1","short":"<?php echo gethttp().$D_domain?>/s/d","long":"http://www.baidu.com","time":"2021-01-18 15:38:52"},{"code":"success","id":"2","vip":"1","short":"<?php echo gethttp().$D_domain?>/s/d","long":"http://www.qq.com","time":"2021-01-18 15:38:52"}]</p>
                <hr>

              </div>
            </div>
          </div>
        </div>
      </div>
    </main>
    <!--End 页面主要内容-->
  </div>
</div>

<script type="text/javascript" src="../js/jquery.min.js"></script>
<script type="text/javascript" src="../js/bootstrap.min.js"></script>
<script type="text/javascript" src="../js/perfect-scrollbar.min.js"></script>
<script type="text/javascript" src="../js/main.min.js"></script>
<script src="../js/jconfirm/jquery-confirm.min.js"></script>

<script type="text/javascript">
	  var path=window.location.pathname;
  $("a").each(function(){
    if(path.indexOf($(this).attr("href"))!=-1){
      console.log($(this).attr("href"));
      $(this).parent("li").addClass("active");
      $(this).parent("li").parent("ul").parent("li").addClass("open active");
    }
  });
</script>
</body>
</html>