<?php
require 'conn/conn.php';
require 'conn/function.php';

if(isMobile()){
    Header("Location:wap_custom.php");
    die();
}

if($C_rewrite==1){
    $r="/";
}else{
    $r="?";
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>自定义后缀 - <?php echo $C_title?></title>
    <meta name="description" content="<?php echo $C_description?>" />
    <meta name="keywords" content="<?php echo $C_keyword?>" />
    <link href="media/<?php echo $C_ico?>" rel="shortcut icon" />
    <link href="css/main.css" rel="stylesheet">
    <script src="lib/jquery-3.4.1.min.js"></script>
    <script src="lib/layer.js"></script>
    <script src="lib/clipboard.min.js"></script>
</head>
<body>
    <div class="header">
        <div class="main">
            <a href="./"><img src="media/<?php echo $C_logo?>" alt="<?php echo $C_title?>" class="logo"></a>
            <div class="menu">
                <a href="./">首页</a>
                <a href="urls.php" >批量生成</a>
                <a href="custom.php" class="active">自定义后缀</a>
                <a href="api.php" >API文档</a>
                <?php
                if(checkauth()==2){
                    if($_SESSION["M_id"]==""){
                        echo "<button id=\"goLogin\">注册 / 登录</button>";
                    }else{
                        echo "<button id=\"goLogin\">".$_SESSION["M_login"]."</button>";
                    }
                }
                ?>
            </div>
        </div>
    </div>
    <div class="banner" style="background: url('img/features_15.jpg');">
        <img src="img/index_title.png" style="margin-top:80px">
        <div class="input">
            <form id="form2">
                <input type="text" name="url" class="url2" placeholder="请输入 http:// 或 https:// 开头的网址">
                <div class="search-view" style="margin-top:20px">
                    <div style="display: inline-block;vertical-align: top;">
                        <select name="type" style="background: #fff;height: 60px;text-align: center;line-height: 60px;color: #4587FF;border:none;font-size: 20px;border-radius: 10px 0 0 10px;padding: 0 10px;">
                            <option value="0">普通跳转</option>
                            <option value="1">防红跳转</option>
                            <option value="2">强开直链</option>
                        </select><select name="domain" style="background: #fff;height: 60px;text-align: center;line-height: 60px;color: #4587FF;border:none;font-size: 20px;padding: 0 10px;">
                            <?php 
                            if(strpos($C_dwzon,"-2")!==false){
                                echo "<option value=\"".gethttp().$_SERVER["HTTP_HOST"]."\">".gethttp().$_SERVER["HTTP_HOST"].$r."</option>";
                            }

                            $sql="select D_id,D_http,D_domain from sl_domain where D_show=1";
                            $result = mysqli_query($conn,  $sql);
                            if (mysqli_num_rows($result) > 0) {
                            while($row = mysqli_fetch_assoc($result)) {
                                    echo "<option value=\"".$row["D_http"].$row["D_domain"]."\">".$row["D_http"].$row["D_domain"].$r."</option>";
                                }
                            }
                            ?>
                        </select>
                    </div><input type="text" name="attach" placeholder="自定义后缀（字母或数字）" class="url3"><div class="search-btn" onclick="creat(2)">生成短链接</div>
                </div>
            </form>
        </div>

        <div class="short_box" style="margin-top:20px">
            <div>
                <img src="" id="qrcode">
                <div class="urlinfo">
                    <div class="creat_time">生成时间：<span id="time"></span></div>
                    <div>短链接：<span style="color:#4587FF" id="short"></span> <div class="copy-button">复制</div> <span id="type"></span></div>
                    <p class="long_url" id="long"></p>
                </div>
            </div>
            <div style="margin-top:20px">
                <p>注意：此短链接有效期 <span style="color:#4587FF">30天</span> ，登录后永久有效并可查看完整访问数据</p>
                <div class="login_btn" id="login_btn">立即登录</div>
            </div>
        </div>

    </div>

    <div class="main">
        <div class="title" style="margin-top:20px">· 特色功能 ·</div>
        <div class="intro">八大基础功能特性，让连接管理、数据统计、AB测试更方便</div>
        <div style="margin-bottom: 50px;">
            <div class="box">
                <img src="img/scene1-1.png">
                <div class="btitle">链接缩短</div>
                <div class="bintro">将原始链接快速转为短链接</div>
            </div><div class="box">
                <img src="img/scene1-2.png">
                <div class="btitle">永久有效</div>
                <div class="bintro">生成短连接永久有效</div>
            </div><div class="box">
                <img src="img/scene1-3.png">
                <div class="btitle">智能跳转</div>
                <div class="bintro">同一段链接自定义跳转不同地址</div>
            </div><div class="box">
                <img src="img/scene1-4.png">
                <div class="btitle">访问统计</div>
                <div class="bintro">多维度数据统计，一键生成报表</div>
            </div><div class="box">
                <img src="img/scene1-5.png">
                <div class="btitle">随时修改</div>
                <div class="bintro">随时修改短链接跳转地址</div>
            </div><div class="box">
                <img src="img/scene1-6.png">
                <div class="btitle">批量创建</div>
                <div class="bintro">批量创建操作让连接生产更高效</div>
            </div><div class="box">
                <img src="img/scene1-7.png">
                <div class="btitle">分组管理</div>
                <div class="bintro">分组让短链接管理更方便</div>
            </div><div class="box">
                <img src="img/scene1-8.png">
                <div class="btitle">推广模板</div>
                <div class="bintro">极简生成各类推广模板</div>
            </div>
        </div>
    </div>

    <div class="footer">
        <div class="main">
            <div class="l1">
                <p style="font-size: 17px;color:#fff">产品及服务</p>
                <p>链接缩短·永久有效</p>
                <p>访问统计·报表分享</p>
                <p>随机跳转·分组管理</p>
                <p>批量创建·随时修改</p>
            </div><div class="l2">
                <p style="font-size: 17px;color:#fff">在线客服</p>
                <div style="font-size:40px;color:#fff;font-weight: bold;">QQ<?php echo $C_qq?></div>
                <p><img src="img/phone.png"> <?php echo $C_mobile?></p>
                <p>( 咨询时间：9:00 - 22:00 )</p>
            </div><div class="l3">
                <p style="font-size: 17px;color:#fff">微信公众号</p>
                <p><img src="media/<?php echo $C_qrcode?>" style="width:150px"></p>
            </div>
            <div class="logos">
                <?php
$sql="select * from sl_link order by L_order,L_id desc";
                $result = mysqli_query($conn,  $sql);
                if (mysqli_num_rows($result) > 0) {
                while($row = mysqli_fetch_assoc($result)) {
                    echo " <a href=\"".$row["L_url"]."\" target=\"_blank\"><img src=\"media/".$row["L_pic"]."\" alt=\"".$row["L_title"]."\"></a> ";
                    }
                } 
?>
            </div>
            <div class="copyright"><?php 
                    echo $C_copyright;
                    echo " <u><a href=\"https://beian.miit.gov.cn/\" target=\"blank\">".$C_beian."</a></u> ";
                    echo $C_code;
                    ?></div>
        </div>
    </div>
<script src="js/main.js?v=0928"></script>
<script>
    $("#d").find("label input:first").attr("checked","checked");
</script>
</body>
</html>