<?php
require 'conn/conn.php';
require 'conn/function.php';

$D_domain=splitx($_SERVER["HTTP_HOST"].$_SERVER["PHP_SELF"],"/api.php",0);

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>API文档 - <?php echo $C_title?></title>
    <meta name="description" content="<?php echo $C_description?>" />
    <meta name="keywords" content="<?php echo $C_keyword?>" />
    <link href="media/<?php echo $C_ico?>" rel="shortcut icon" />
    <link href="css/main.css" rel="stylesheet">
    <script src="lib/jquery-3.4.1.min.js"></script>
    <script src="lib/layer.js"></script>
    <script src="lib/clipboard.min.js"></script>
    <style>
    .main{font-size: 15px;}
    </style>
</head>
<body>
    <div class="header">
        <div class="main">
            <a href="./"><img src="media/<?php echo $C_logo?>" alt="<?php echo $C_title?>" class="logo"></a>
            <div class="menu">
                <a href="./">首页</a>
                <a href="urls.php" >批量生成</a>
                <a href="custom.php" >自定义后缀</a>
                <a href="api.php" class="active">API文档</a>
                <?php
                if(checkauth()==2){
                    if($_SESSION["M_id"]==""){
                        echo "<button id=\"goLogin\">注册 / 登录</button>";
                    }else{
                        echo "<button id=\"goLogin\">".$_SESSION["M_login"]."</button>";
                    }
                }
                ?>
            </div>
        </div>
    </div>
    <div class="banner" style="height: 300px;">
        <img src="img/news-title.png" style="padding-top:100px">
    </div>
    <div style="background: #f7f7f7;padding: 50px 0;">
    <div class="main" style="background:#fff;padding: 20px;">
        <div style="font-size: 40px;font-weight: bold;margin: 30px 0;color: #333;">API文档</div>
        
            <div class="card">
              <div class="card-header"><h4>1.生成短链</h4></div>
              <div class="card-body">
                <p><b>请求地址：</b><?php echo gethttp().$D_domain?>/api/</p>
                <p><b>请求方式：</b>GET <b>返回方式：</b>JSON</p>
                <p><table class="table">
                    <tr><th>请求参数</th><th>解释</th><th>类型</th><th>示例</th></tr>
                    <tr><td>method</td><td>请求方法</td><td>文本</td><td>add</td></tr>
                    <tr><td>key</td><td>会员key，从会员中心获取</td><td>文本</td><td>0cc175b9c0f1b6a831c399e269772661</td></tr>
                    <tr><td>url</td><td>原网址</td><td>文本</td><td>http://www.baidu.com</td></tr>
                    <tr><td>vip</td><td>短链是否永久，0：临时（<?php echo  $C_day?>天），1：永久</td><td>数字</td><td>1</td></tr>
                    <tr><td>domain</td><td><p>选择生成短链的域名</p><?php
                    if(strpos($C_dwzon,"-2")!==false){
                        echo "<p>0：".$_SERVER["HTTP_HOST"]."</p>";
                    }
                    $sql="select D_id,D_domain from sl_domain where D_show=1";
                    $result = mysqli_query($conn,  $sql);
                    if (mysqli_num_rows($result) > 0) {
                    while($row = mysqli_fetch_assoc($result)) {
                            echo "<p>".$row["D_id"]."：".$row["D_domain"]."</p>";
                        }
                    }

                    if(strpos($C_extra,"1")!==false){echo "<p>-101: 微信随机通道</p> ";}
                    if(strpos($C_extra,"2")!==false){echo "<p>-102: QQ随机通道</p> ";}

                    ?></td><td>数字</td><td>1</td></tr>
                </table></p>
                
                说明：（1）url传入前需要用urlencode转码（2）如果生成永久链接，请保证账户余额充足
                
                
                <p style="word-break:break-all;"><b>请求示例</b>：<br><?php echo gethttp().$D_domain?>/api/?method=add&key=0cc175b9c0f1b6a831c399e269772661&domain=1&vip=1&url=http%3a%2f%2fwww.baidu.com</p>
                <p><table class="table">
                  <tr><th>返回参数</th><th>解释</th><th>示例</th></tr>
                  <tr><td>code</td><td>返回码</td><td>success：成功，error：错误</td></tr>
                  <tr><td>id</td><td>短链编号</td><td>1</td></tr>
                  <tr><td>vip</td><td>短链是否永久，0：临时（<?php echo  $C_day?>天），1：永久</td><td>123</td></tr>
                  <tr><td>short</td><td>短链接</td><td><?php echo gethttp().$D_domain?>/s/d</td></tr>
                  <tr><td>long</td><td>原网址</td><td>http://www.baidu.com</td></tr>
                  <tr><td>time</td><td>短链接生成时间</td><td>2021-01-18 15:38:52</td></tr>
                </table></p>
                <p style="word-break:break-all;"><b>返回示例：</b><br>{"code":"success","id":"1","vip":"1","short":"<?php echo gethttp().$D_domain?>/s/d","long":"http://www.baidu.com","time":"2021-01-18 15:38:52"}</p>
                
              </div>
            </div>

            <div class="card">
              <div class="card-header"><h4>2.获取短链列表</h4></div>
              <div class="card-body">
                <p><b>请求地址：</b><?php echo gethttp().$D_domain?>/api/</p>
                <p><b>请求方式：</b>GET <b>返回方式：</b>JSON</p>
                <p><table class="table">
                  <tr><th>请求参数</th><th>解释</th><th>示例</th></tr>
                  <tr><td>method</td><td>请求方法</td><td>list</td></tr>
                  <tr><td>key</td><td>会员key，从会员中心获取</td><td>0cc175b9c0f1b6a831c399e269772661</td></tr>

                </table></p>

                <p style="word-break:break-all;"><b>请求示例</b>：<br><?php echo gethttp().$D_domain?>/api/?method=list&key=0cc175b9c0f1b6a831c399e269772661</p>

                <p><table class="table">
                  <tr><th>返回参数</th><th>解释</th><th>示例</th></tr>
                  <tr><td>S_vip</td><td>短链是否永久，0：临时（<?php echo  $C_day?>天），1：永久</td><td>123</td></tr>
                  <tr><td>S_short</td><td>短链接</td><td><?php echo gethttp().$D_domain?>/s/d</td></tr>
                  <tr><td>S_url</td><td>原网址</td><td>http://www.baidu.com</td></tr>
                  <tr><td>S_time</td><td>短链接生成时间</td><td>2021-01-18 15:38:52</td></tr>
                </table></p>
                
                <p style="word-break:break-all;"><b>返回示例：</b><br>[{"S_vip":"1","S_short":"<?php echo gethttp().$D_domain?>/d","S_url":"http://www.baidu.com","S_time":"2021-01-18 15:38:52"},{"S_vip":"1","S_short":"<?php echo gethttp().$D_domain?>/e","S_url":"http://www.qq.com","S_time":"2021-01-18 15:38:52"}]</p>

              </div>
            </div>
          </div>

    </div>
    
    <div class="banner2">
        <div class="ntitle">私人管家般的专属服务，只为您的使用更放心！</div>
        <div class="bbutton" onclick="contact_btn('<img src=media/<?php echo $C_qrcode?>>')">立即咨询</div>
    </div>
    <div class="footer">
        <div class="main">
            <div class="l1">
                <p style="font-size: 17px;color:#fff">产品及服务</p>
                <p>链接缩短·永久有效</p>
                <p>访问统计·报表分享</p>
                <p>随机跳转·分组管理</p>
                <p>批量创建·随时修改</p>
            </div><div class="l2">
                <p style="font-size: 17px;color:#fff">在线客服</p>
                <div style="font-size:40px;color:#fff;font-weight: bold;">QQ<?php echo $C_qq?></div>
                <p><img src="img/phone.png"> <?php echo $C_mobile?></p>
                <p>( 咨询时间：9:00 - 22:00 )</p>
            </div><div class="l3">
                <p style="font-size: 17px;color:#fff">微信公众号</p>
                <p><img src="media/<?php echo $C_qrcode?>" style="width:150px"></p>
            </div>
            <div class="logos">
                <?php
$sql="select * from sl_link order by L_order,L_id desc";
                $result = mysqli_query($conn,  $sql);
                if (mysqli_num_rows($result) > 0) {
                while($row = mysqli_fetch_assoc($result)) {
                    echo " <a href=\"".$row["L_url"]."\" target=\"_blank\"><img src=\"media/".$row["L_pic"]."\" alt=\"".$row["L_title"]."\"></a> ";
                    }
                } 
?>
            </div>
            <div class="copyright"><?php 
                    echo $C_copyright;
                    echo " <u><a href=\"https://beian.miit.gov.cn/\" target=\"blank\">".$C_beian."</a></u> ";
                    echo $C_code;
                    ?></div>
        </div>
    </div>
<script src="js/main.js"></script>
<script>
    $("#d").find("label input:first").attr("checked","checked");
</script>
</body>
</html>