# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

# [4.0.0-alpha.38](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.37...v4.0.0-alpha.38) (2025-01-04)

### Bug Fixes

* **deps:** update all non-major dependencies ([#519](https://github.com/skyra-project/discord-components/issues/519)) ([32cb659](https://github.com/skyra-project/discord-components/commit/32cb6594cd1275d62ecc0bd0705ac21212a05b28)) (@renovate[bot])
* **deps:** update dependency astro to v5 ([#515](https://github.com/skyra-project/discord-components/issues/515)) ([966f03a](https://github.com/skyra-project/discord-components/commit/966f03a568fc1ab3ea11bdfbca786f7020c346e4)) (@renovate[bot])
* **deps:** update dependency astro to v5.0.8 [security] ([#518](https://github.com/skyra-project/discord-components/issues/518)) ([30b9725](https://github.com/skyra-project/discord-components/commit/30b972564fbb2190370609f473046483e638eef0)) (@renovate[bot])

### Features

* added option to add the channel name above discord messages ([#520](https://github.com/skyra-project/discord-components/issues/520)) ([716f72e](https://github.com/skyra-project/discord-components/commit/716f72edf0b57269b1b30b2d42b226c7e7385cd2)) (@TheBv)

# [4.0.0-alpha.37](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.36...v4.0.0-alpha.37) (2024-12-01)

### Bug Fixes

* **deps:** update all non-major dependencies ([98cfc1f](https://github.com/skyra-project/discord-components/commit/98cfc1f7c012a18e689bc67ea810e7cafe141ca5)) (@renovate[bot])
* **deps:** update all non-major dependencies ([#505](https://github.com/skyra-project/discord-components/issues/505)) ([00e646f](https://github.com/skyra-project/discord-components/commit/00e646f61c00ce1a12d872d49c5c92e1a9695bb3)) (@renovate[bot])
* **deps:** update all non-major dependencies ([#510](https://github.com/skyra-project/discord-components/issues/510)) ([f499bb7](https://github.com/skyra-project/discord-components/commit/f499bb714060012c9d7786c089413dc340417fd2)) (@renovate[bot])
* inline field bug in Discord embed ([#511](https://github.com/skyra-project/discord-components/issues/511)) ([5b40150](https://github.com/skyra-project/discord-components/commit/5b40150c6f29760cc16ef6ab755f81598d512c99)), closes [#509](https://github.com/skyra-project/discord-components/issues/509) (@favna)
* style discord attachment audio ([#504](https://github.com/skyra-project/discord-components/issues/504)) ([e5296e4](https://github.com/skyra-project/discord-components/commit/e5296e4499a9672ee12158a087e76b8c82a211d4)) (@eumarciel404)

# [4.0.0-alpha.36](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.35...v4.0.0-alpha.36) (2024-11-02)

### Bug Fixes

* **attachment:** adding button download ([#499](https://github.com/skyra-project/discord-components/issues/499)) ([056368b](https://github.com/skyra-project/discord-components/commit/056368bdaf47f13d18bcca8c7897f257855f7bb9)) (@eumarciel404)
* **discordcommand:** fixed boolean types and add ifDefined ([4352655](https://github.com/skyra-project/discord-components/commit/4352655b0879de6b43479494f8097c1cf5848212)) (@favna)
* **DiscordReply:** add missing attributes ([38ee6e8](https://github.com/skyra-project/discord-components/commit/38ee6e86b4c0c43c8d17970176d7a5a396e65e66)), closes [#500](https://github.com/skyra-project/discord-components/issues/500) (@favna)
* **embed-image:** fix max-width and max-height ([#498](https://github.com/skyra-project/discord-components/issues/498)) ([c7f3584](https://github.com/skyra-project/discord-components/commit/c7f35848424c38c2600d16fb9ac15cf2e7a34508)) (@eumarciel404)
* style message ([#496](https://github.com/skyra-project/discord-components/issues/496)) ([c796dbc](https://github.com/skyra-project/discord-components/commit/c796dbc4a064a2d2e22adb70f60c97aa31436fdb)) (@eumarciel404)

### Features

* add polls ([#492](https://github.com/skyra-project/discord-components/issues/492)) ([61a1105](https://github.com/skyra-project/discord-components/commit/61a11055d8eb70795939d29299436af0c07c9f78)) (@eumarciel404)
* adding the possibility to use emoji default of system ([#497](https://github.com/skyra-project/discord-components/issues/497)) ([1b206b1](https://github.com/skyra-project/discord-components/commit/1b206b19cc7f46dc0e7257ba1d4ba14477554e37)) (@eumarciel404)

# [4.0.0-alpha.35](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.34...v4.0.0-alpha.35) (2024-10-27)

### Bug Fixes

* **audio-attachment:** add optional chaining for `this.name.replaceAll` ([aece350](https://github.com/skyra-project/discord-components/commit/aece3504ba41600af37db0a9f4a90e304efaaf26)) (@favna)
* **command:** updating style ([#468](https://github.com/skyra-project/discord-components/issues/468)) ([d41e346](https://github.com/skyra-project/discord-components/commit/d41e3469eaa7618a72dbf630d4461aa4d76c239f)) (@eumarciel404)
* correcting context-user-name-color ([#489](https://github.com/skyra-project/discord-components/issues/489)) ([55531f9](https://github.com/skyra-project/discord-components/commit/55531f9e0de290e77e45661e97c2bbb7c4d96028)) (@eumarciel404)
* **deps:** update all non-major dependencies ([bd0d80b](https://github.com/skyra-project/discord-components/commit/bd0d80b1a2fa66c7252871eeabfb134d742ab4f1)) (@renovate[bot])
* **deps:** update all non-major dependencies ([061f9f7](https://github.com/skyra-project/discord-components/commit/061f9f74234c32f3140b10e0a3a4d4b62b6e64d9)) (@renovate[bot])
* **deps:** update all non-major dependencies ([#473](https://github.com/skyra-project/discord-components/issues/473)) ([b217e95](https://github.com/skyra-project/discord-components/commit/b217e95cdbd43291b6e28d86867e7219e3682a65)) (@renovate[bot])
* **deps:** update all non-major dependencies ([#480](https://github.com/skyra-project/discord-components/issues/480)) ([869647b](https://github.com/skyra-project/discord-components/commit/869647ba7662e848acc88ba1c669e64d93a3a38c)) (@renovate[bot])
* **discord-string-select-menu-option:** Correcting style ([#484](https://github.com/skyra-project/discord-components/issues/484)) ([3750abf](https://github.com/skyra-project/discord-components/commit/3750abf1c5d06e253637216850ffcc904c55da29)) (@eumarciel404)
* **string-select-menu:** fixing clickable area ([#488](https://github.com/skyra-project/discord-components/issues/488)) ([9f60afc](https://github.com/skyra-project/discord-components/commit/9f60afc26c39844f9ad9340b8df9a55ed9cac389)) (@eumarciel404)
* **string-select:** set correct slot height ([#467](https://github.com/skyra-project/discord-components/issues/467)) ([303ca37](https://github.com/skyra-project/discord-components/commit/303ca374505f4096cbea3f4f9475d8e3d89d44bf)) (@Marciel404)

### Features

* add context_menu command ([#485](https://github.com/skyra-project/discord-components/issues/485)) ([1f853cc](https://github.com/skyra-project/discord-components/commit/1f853cce30f7a6f6237fc8b2672339ac0ca9b2ec)) (@eumarciel404)
* add official app ([#493](https://github.com/skyra-project/discord-components/issues/493)) ([c6baff1](https://github.com/skyra-project/discord-components/commit/c6baff164b2aba224fa98434459113b4378e6643)) (@eumarciel404)

# [4.0.0-alpha.34](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.33...v4.0.0-alpha.34) (2024-08-29)

**Note:** Version bump only for package root

# [4.0.0-alpha.33](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.32...v4.0.0-alpha.33) (2024-08-24)

### Bug Fixes

* fixed clan tags not showing up properly ([de183c0](https://github.com/skyra-project/discord-components/commit/de183c0523947c38dfbcea8a8aaa911849a22d77)) (@favna)

# [4.0.0-alpha.32](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.31...v4.0.0-alpha.32) (2024-08-24)

### Bug Fixes

* correct the line style that indicates the thread ([#457](https://github.com/skyra-project/discord-components/issues/457)) ([5fe063a](https://github.com/skyra-project/discord-components/commit/5fe063aa50b560b21d6a9beb0805b827c6874057)) (@eumarciel404)
* fixed borders in :before and :after for tailwindcss users ([#454](https://github.com/skyra-project/discord-components/issues/454)) ([f857ec4](https://github.com/skyra-project/discord-components/commit/f857ec425a3f55ffea22ec66c7b50bfb70945d23)) (@favna)
* prevent timestamp wrapping ([#462](https://github.com/skyra-project/discord-components/issues/462)) ([7ce20a7](https://github.com/skyra-project/discord-components/commit/7ce20a75312aae6b85b825caaeea120358cdd7b5)) (@dpaulos6)
* remove border on modal input ([#455](https://github.com/skyra-project/discord-components/issues/455)) ([900afa4](https://github.com/skyra-project/discord-components/commit/900afa4f126f8cdd237e02d84d0d3f9bbf4c5765)) (@mezotv)
* update the ephemeral eye icon ([#460](https://github.com/skyra-project/discord-components/issues/460)) ([62b1294](https://github.com/skyra-project/discord-components/commit/62b1294fa09d46b0e0db831fc6aae82543dfc695)) (@mezotv)

### Features

* add clan tags ([#463](https://github.com/skyra-project/discord-components/issues/463)) ([afe7ee9](https://github.com/skyra-project/discord-components/commit/afe7ee9e66cb4e68fad22ffe866a27a9ff884d4f)), closes [#453](https://github.com/skyra-project/discord-components/issues/453) (@favna)
* adding function if you click an option ([#461](https://github.com/skyra-project/discord-components/issues/461)) ([930a691](https://github.com/skyra-project/discord-components/commit/930a691eae60db82ea5fbd25abd7d51b439e3d50)) (@eumarciel404)

# [4.0.0-alpha.31](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.30...v4.0.0-alpha.31) (2024-08-19)

### Bug Fixes

* remove accidental console log ([fc047a6](https://github.com/skyra-project/discord-components/commit/fc047a6b5707a29ae2de8c413120ff2f49032eb7)) (@favna)

### Features

* **system-message:** add upgrade type ([#450](https://github.com/skyra-project/discord-components/issues/450)) ([39b5ad0](https://github.com/skyra-project/discord-components/commit/39b5ad094c8866a27688d9a5d637d3bbf88748c3)) (@mezotv)

# [4.0.0-alpha.30](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.29...v4.0.0-alpha.30) (2024-08-19)

### Bug Fixes

* **deps:** update all non-major dependencies ([#447](https://github.com/skyra-project/discord-components/issues/447)) ([fbd21f1](https://github.com/skyra-project/discord-components/commit/fbd21f1b18f0cfb74d59822be7c724b146c7744d)) (@renovate[bot])
* **deps:** update dependency astro to v4.13.3 ([2bb50d6](https://github.com/skyra-project/discord-components/commit/2bb50d6e84cfed3b0d25b05481580ee46b42075a)) (@renovate[bot])

### Features

* add modals ([#443](https://github.com/skyra-project/discord-components/issues/443)) ([ea87670](https://github.com/skyra-project/discord-components/commit/ea87670fc98601ca68127714c77a4e20b38d5f15)) (@eumarciel404)
* **emoji:** add support for `jumbo` size emojis ([95b2b19](https://github.com/skyra-project/discord-components/commit/95b2b19699d05414caad2b5f411249c3fe5f4fd4)) (@favna)

# [4.0.0-alpha.29](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.28...v4.0.0-alpha.29) (2024-08-10)

### Bug Fixes

* bold and italic in list items proper indenting ([#445](https://github.com/skyra-project/discord-components/issues/445)) ([629bbea](https://github.com/skyra-project/discord-components/commit/629bbea0b8b416e9f3366623adeb616905e50fb9)), closes [#444](https://github.com/skyra-project/discord-components/issues/444) (@favna)

# [4.0.0-alpha.28](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.27...v4.0.0-alpha.28) (2024-08-07)

### Bug Fixes

* add prepack scripts ([acadd12](https://github.com/skyra-project/discord-components/commit/acadd12fc6bf71c1a3042ff636006d04007f0b5f)) (@favna)

# [4.0.0-alpha.27](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.26...v4.0.0-alpha.27) (2024-08-07)

### Bug Fixes

* Adding Light Theme in string select menu and correcting the text size ([#439](https://github.com/skyra-project/discord-components/issues/439)) ([c40f6c0](https://github.com/skyra-project/discord-components/commit/c40f6c0efe5e2efa51fc3129c2dffb57592b7098)) (@eumarciel404)
* **discord-action-row:** wrap using "flex-wrap" ([#440](https://github.com/skyra-project/discord-components/issues/440)) ([24163fc](https://github.com/skyra-project/discord-components/commit/24163fce52d7932d8f428ecc56976127af675760)) (@eumarciel404)
* **discord-invite:** improve styling ([#441](https://github.com/skyra-project/discord-components/issues/441)) ([9b910d1](https://github.com/skyra-project/discord-components/commit/9b910d107ef623c31f28de0be04b80046fd4bbf5)) (@eumarciel404)

# [4.0.0-alpha.26](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.25...v4.0.0-alpha.26) (2024-08-03)

### Bug Fixes

* fixes order of message slots ([827ef64](https://github.com/skyra-project/discord-components/commit/827ef6409f3d0c34d1a51eb78b319f8eeb994c8d)), closes [#435](https://github.com/skyra-project/discord-components/issues/435) (@favna)

# [4.0.0-alpha.25](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.24...v4.0.0-alpha.25) (2024-08-03)

### Bug Fixes

* **discord-reply:** Removed rouge closing curly brace ([#437](https://github.com/skyra-project/discord-components/issues/437)) ([e88e963](https://github.com/skyra-project/discord-components/commit/e88e9637b40b2a32d781d6aafba4ac5230df6ffa)) (@DanPlayz0)
* fixed meta tags ([bf54ac1](https://github.com/skyra-project/discord-components/commit/bf54ac1939a31c59e50bd20857a8e8cab8f1f864)) (@favna)
* fixed og:image ([81f1bc9](https://github.com/skyra-project/discord-components/commit/81f1bc9a2f65835cbc63475b39bd0060c14e0586)) (@favna)
* smooth out the hero image ([b40bae9](https://github.com/skyra-project/discord-components/commit/b40bae9a17d8555d8dfa9bdea8c8dc4aabe732c2)) (@favna)
* update background on opengraph ([49764a9](https://github.com/skyra-project/discord-components/commit/49764a9ed7f6fc128d6300eef444f4f7b4fe2ec8)) (@favna)
* update favicon urls ([252fad7](https://github.com/skyra-project/discord-components/commit/252fad77ca5fefe571f36fe70d7fe8d315af11eb)) (@favna)

### Features

* add string select menu ([#436](https://github.com/skyra-project/discord-components/issues/436)) ([9f3744a](https://github.com/skyra-project/discord-components/commit/9f3744a9505653470fc3efd47d37b791944baebc)), closes [#185](https://github.com/skyra-project/discord-components/issues/185) (@eumarciel404)

# [4.0.0-alpha.24](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.23...v4.0.0-alpha.24) (2024-07-31)

### Bug Fixes

* add skiping one line ([#427](https://github.com/skyra-project/discord-components/issues/427)) ([0de39d7](https://github.com/skyra-project/discord-components/commit/0de39d7437e088f8c227359ec2a0c102cb9ef4bd)) (@eumarciel404)
* added the possibility of skipping lines for discord-embed titles ([#426](https://github.com/skyra-project/discord-components/issues/426)) ([bc62ed5](https://github.com/skyra-project/discord-components/commit/bc62ed58b21b06270aff7c633f461bb01103c94b)) (@favna)
* added the possibility of skipping lines for discord-embed-field titles ([#428](https://github.com/skyra-project/discord-components/issues/428)) ([67b0ab9](https://github.com/skyra-project/discord-components/commit/67b0ab9229307c6423b91c7b8f28479d36aba0ba)) (@eumarciel404)
* **discord-button:** fixed button type checking to be null safe ([7d99d99](https://github.com/skyra-project/discord-components/commit/7d99d99cb6ff9f3d2ad060b49305da4049958e19)) (@favna)
* **discord-embed-field:** fixed inline-index checking to be null safe ([84e5bc4](https://github.com/skyra-project/discord-components/commit/84e5bc46305abb880fd6243c028c8dfa23295390)) (@favna)

### Features

* add `dismissMessageClicked` to `discord-message` ([c7f6b51](https://github.com/skyra-project/discord-components/commit/c7f6b51dc5d3079ae9e9e31417cdb8068b6e9d60)) (@favna)

# [4.0.0-alpha.23](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.22...v4.0.0-alpha.23) (2024-07-18)

### Bug Fixes

* **button:** ensure disabled buttons have proper cursor ([5f28110](https://github.com/skyra-project/discord-components/commit/5f28110a2ac8e3549b73021add7dc97675fc7252)) (@favna)
* **message:** fixed misaligned author info ([8480702](https://github.com/skyra-project/discord-components/commit/848070259daecc8072f1e8ebbb2f4f4f8fcbf92e)) (@favna)

# [4.0.0-alpha.22](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.21...v4.0.0-alpha.22) (2024-07-13)

### Bug Fixes

* **regression:** ensure compact-mode and message-body-only work well together ([f7ac627](https://github.com/skyra-project/discord-components/commit/f7ac6272eda324ca7fb4d8a1bc2211eaa0401a5a)) (@favna)

### Features

* add on-hover timestamps for message-body-only messages ([db9df40](https://github.com/skyra-project/discord-components/commit/db9df40cc2c0ecf519521861abac171cd93183dc)), closes [#418](https://github.com/skyra-project/discord-components/issues/418) (@favna)

# [4.0.0-alpha.21](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.20...v4.0.0-alpha.21) (2024-07-12)

### Bug Fixes

* **embed-description:** remove `white-space: pre-line` to make sure text stays on the same line ([1e9ea73](https://github.com/skyra-project/discord-components/commit/1e9ea73c1ce293d5952fc44b9780354e7797e187)) (@favna)
* **embed:** resolve the remaining todo, lit covers this functionality automatically yay ([12ed6b4](https://github.com/skyra-project/discord-components/commit/12ed6b4150672fb8195e94f5df129007c72bff8c)) (@favna)
* **file-attachment:** add attribute for bytesUnit ([c23f7d1](https://github.com/skyra-project/discord-components/commit/c23f7d1edeb6f7fd35d2c33e8e280a8cbe9f2b0c)) (@favna)
* **media:** add missing ARIA roles ([75a57db](https://github.com/skyra-project/discord-components/commit/75a57db29af32acfbb79ed5b6ed90c6b76a0493f)) (@favna)
* **tenor-video:** properly match discord gifs and restore autoplay on chromium browsers ([558b851](https://github.com/skyra-project/discord-components/commit/558b851b240613b334dd3186f7fc08cc6ca52533)) (@favna)

### Features

* add `discord-subscript` component ([e1b7db6](https://github.com/skyra-project/discord-components/commit/e1b7db6146685a82437018d815b868b5b59eeac3)) (@favna)
* add audio attachment component ([#411](https://github.com/skyra-project/discord-components/issues/411)) ([d970765](https://github.com/skyra-project/discord-components/commit/d970765b4929c8836c3af191f435b474794ad593)) (@favna)
* add video attachment component ([#413](https://github.com/skyra-project/discord-components/issues/413)) ([b308580](https://github.com/skyra-project/discord-components/commit/b3085802bc7407403bdec707266ea2a239eacfbc)) (@favna)
* **media:** add restart icon and functionality ([584a438](https://github.com/skyra-project/discord-components/commit/584a4383ac5a44a639a09e28bbd34cb1503d80ba)) (@favna)

# [4.0.0-alpha.20](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.19...v4.0.0-alpha.20) (2024-06-15)

### Bug Fixes

* **image-attachment:** fixed incorrect properties and add ifDefined directive ([c2ba255](https://github.com/skyra-project/discord-components/commit/c2ba255efda74065c754976a09973744d789facf)) (@favna)
* use slot for custom image element ([e373c3a](https://github.com/skyra-project/discord-components/commit/e373c3ac438457055f6abaccb98c4bab82c220fd)) (@favna)

### Features

* add file attachment support ([9e4bebd](https://github.com/skyra-project/discord-components/commit/9e4bebd50078ca2b0cc2a1fb1d6c6ae99da4065d)), closes [#258](https://github.com/skyra-project/discord-components/issues/258) (@favna)
* add support for custom image attachments ([dc95f8b](https://github.com/skyra-project/discord-components/commit/dc95f8b2c5726665d9d26180eb83dd89dedc5c88)), closes [#251](https://github.com/skyra-project/discord-components/issues/251) (@favna)

# [4.0.0-alpha.19](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.18...v4.0.0-alpha.19) (2024-06-15)

### Features

* **discord-message:** add `message-body-only` to allow for chained messages from same author ([0381bee](https://github.com/skyra-project/discord-components/commit/0381bee2dfa5b83fb8f9dc7e9c30423defe0bd2c)), closes [#407](https://github.com/skyra-project/discord-components/issues/407) (@favna)

# [4.0.0-alpha.18](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.17...v4.0.0-alpha.18) (2024-04-20)

### Bug Fixes

* change `bot` to `app` following Discord's change of the label ([#394](https://github.com/skyra-project/discord-components/issues/394)) ([ec034d3](https://github.com/skyra-project/discord-components/commit/ec034d3992977a62a2f85865c1e74a4e0dfcd512))
* **deps:** update all non-major dependencies ([77d3451](https://github.com/skyra-project/discord-components/commit/77d345176e30975c4ebed170f8367185e15797a1))
* fixed custom emojis mapping support for Nuxt 3 ([f11c074](https://github.com/skyra-project/discord-components/commit/f11c074adec983b6bc12ea7e81f5da44accc9c8d))
* fixed emojis in embeds and add support for Nuxt 3 ([7965fd3](https://github.com/skyra-project/discord-components/commit/7965fd3c6e7397b4fae4b4e3fe4666823160f1e9))

# [4.0.0-alpha.17](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.16...v4.0.0-alpha.17) (2024-02-18)

### Bug Fixes

* add list-style-image initial to discord-unordered-list ([0c9cd70](https://github.com/skyra-project/discord-components/commit/0c9cd7048fd9891dc9057b719bdd4fa6dfca5877))

### Features

* add `DiscordComponentsError` to signify errors ([b072bea](https://github.com/skyra-project/discord-components/commit/b072beabe04895b7a778724d94b60c7adce7de74))
* add discord-ordered-list ([42f8b49](https://github.com/skyra-project/discord-components/commit/42f8b4901a969a5c988db43974ffa0766a175577))
* add discord-unordered-list and discord-list-item ([71d483d](https://github.com/skyra-project/discord-components/commit/71d483d4bd4a1865c2c9b296a97a70797b3a4b27))

# [4.0.0-alpha.16](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.15...v4.0.0-alpha.16) (2024-02-17)

### Features

* add `deleted` property to `discord-reply` ([d5d4159](https://github.com/skyra-project/discord-components/commit/d5d4159fb088590f7d7bb4c0dead6e1d415aec23)), closes [#371](https://github.com/skyra-project/discord-components/issues/371)

# [4.0.0-alpha.15](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.14...v4.0.0-alpha.15) (2024-02-17)

### Bug Fixes

* **DiscordHeader:** ensure that the level property is a number ([a97a969](https://github.com/skyra-project/discord-components/commit/a97a969ab12aa3470a8d9d48c29493512813422a))

# [4.0.0-alpha.14](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.13...v4.0.0-alpha.14) (2024-02-11)

### Bug Fixes

* fixed import for util ([a4d3be7](https://github.com/skyra-project/discord-components/commit/a4d3be72c7a04720338afc2add04b6bc76eb6112))
* properly code config functions ([b537f97](https://github.com/skyra-project/discord-components/commit/b537f979c4399558fc81946f00870c08b4894b94))

# [4.0.0-alpha.13](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.12...v4.0.0-alpha.13) (2024-02-11)

### Features

* add `getConfig` and `setConfig` methods ([5a26c41](https://github.com/skyra-project/discord-components/commit/5a26c41de03fdc4c2e3434220fd9b2c69b131beb))

# [4.0.0-alpha.12](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.11...v4.0.0-alpha.12) (2024-02-10)

### Bug Fixes

* **code:** remove language class, it aint working chief ([325d188](https://github.com/skyra-project/discord-components/commit/325d1883e028d75482ff2e03341fc0013db53538))

# [4.0.0-alpha.11](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.10...v4.0.0-alpha.11) (2024-02-10)

### Bug Fixes

* only apply embed styling when required ([36b3b7a](https://github.com/skyra-project/discord-components/commit/36b3b7a267f265ebcc865a0efa032ac71a9fb1f0))

# [4.0.0-alpha.10](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.9...v4.0.0-alpha.10) (2024-02-10)

### Features

* **code:** add `language` property for multiline and add a PrismJS language class when set ([c72c9b8](https://github.com/skyra-project/discord-components/commit/c72c9b85c22519f2e1864ff3ea99f59b87141c3d))

# [4.0.0-alpha.9](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.8...v4.0.0-alpha.9) (2024-02-10)

### Bug Fixes

* **link:** remove `font-weight: normal` which prevents weight styled when nested ([caca673](https://github.com/skyra-project/discord-components/commit/caca67322b89ea6f8c23e2573797879da2f43dbd))

# [4.0.0-alpha.8](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.7...v4.0.0-alpha.8) (2024-02-10)

### Bug Fixes

* proper header styling ([d2ccc26](https://github.com/skyra-project/discord-components/commit/d2ccc268fd9c1110f5309bb5d13905ef4df217ee))

# [4.0.0-alpha.7](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.6...v4.0.0-alpha.7) (2024-02-10)

### Bug Fixes

* **button:** call checkType at render ([5ad7ecf](https://github.com/skyra-project/discord-components/commit/5ad7ecf74e24e90c2ed60a9c1af354e1ba327b7b))

### Features

* add discord-header component ([5552c6a](https://github.com/skyra-project/discord-components/commit/5552c6ad443c8250e43245d14537d0752864e609))

# [4.0.0-alpha.6](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.5...v4.0.0-alpha.6) (2024-02-03)

**Note:** Version bump only for package root

# [4.0.0-alpha.5](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.4...v4.0.0-alpha.5) (2024-02-03)

### Bug Fixes

* **core:** bump transitive dependencies ([366d06e](https://github.com/skyra-project/discord-components/commit/366d06e0b954e5647abb16e67fe840bf078cf1d8))
* **react:** add `use client;` header to react output for NextJS ([bf8f421](https://github.com/skyra-project/discord-components/commit/bf8f421b03cc38a1104d294379f94c901bb3abbd))
* **react:** bump transitive dependencies ([74c0224](https://github.com/skyra-project/discord-components/commit/74c0224c5e08c5cba9e1936b7923ca9c2b8069ba))

# [4.0.0-alpha.4](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.3...v4.0.0-alpha.4) (2024-01-28)

### Bug Fixes

* fix reflection and attribute binding of properties for the React bundle ([8512909](https://github.com/skyra-project/discord-components/commit/8512909868f00b5cbda06bd451102a4169e159b2))

# [4.0.0-alpha.3](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.2...v4.0.0-alpha.3) (2024-01-24)

### Bug Fixes

* fixed transitive dependencies ([8ffebe2](https://github.com/skyra-project/discord-components/commit/8ffebe2db78094ca9f461e62d8206bdb6318e756))

# [4.0.0-alpha.2](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.1...v4.0.0-alpha.2) (2024-01-24)

### Bug Fixes

* added cjs exports to react package for NextJS projects ([2278a56](https://github.com/skyra-project/discord-components/commit/2278a563d919e05f9bd21bad90a8eb39d67d5567))

# [4.0.0-alpha.1](https://github.com/skyra-project/discord-components/compare/v4.0.0-alpha.0...v4.0.0-alpha.1) (2024-01-23)

**Note:** Version bump only for package root

# [4.0.0-alpha.0](https://github.com/skyra-project/discord-components/compare/v3.6.1...v4.0.0-alpha.0) (2024-01-23)

### Bug Fixes

* **react:** use proper export mapping for ESM ([0bbfc1c](https://github.com/skyra-project/discord-components/commit/0bbfc1cd95e56b3da602aa513f3e02559a73fe01))

* feat!: rewrite to lit (#367) ([8b31f45](https://github.com/skyra-project/discord-components/commit/8b31f455be0aba1f93e6ed2188a704448b624020)), closes [#367](https://github.com/skyra-project/discord-components/issues/367)

### BREAKING CHANGES

* This project has been rewritten from [StencilJS](https://stenciljs.com) to [Lit](https://lit.dev). See the [Upgrading to v4 document](https://github.com/skyra-project/discord-components/blob/main/packages/core/UPGRADING-TO-V4.md) for more details.

Co-authored-by: TheBv <bv939@web.de>

## [3.6.1](https://github.com/skyra-project/discord-components/compare/v3.6.0...v3.6.1) (2023-08-18)

### Bug Fixes

-   **core:** add types to export mapping ([b2e72d4](https://github.com/skyra-project/discord-components/commit/b2e72d4281f0b471ef8ffed0cc037dbb66522e18))
-   **deps:** update all non-major dependencies ([#318](https://github.com/skyra-project/discord-components/issues/318)) ([2c2f2f4](https://github.com/skyra-project/discord-components/commit/2c2f2f4a9e82949c20b34950ae1854752c6a709b))
-   **deps:** update all non-major dependencies ([#346](https://github.com/skyra-project/discord-components/issues/346)) ([9890111](https://github.com/skyra-project/discord-components/commit/989011165ff39e44bff44915cabc5622974b1b31))
-   **deps:** update all non-major dependencies ([#350](https://github.com/skyra-project/discord-components/issues/350)) ([2c3d827](https://github.com/skyra-project/discord-components/commit/2c3d827a9e39bf6419b0c074573a0923aa5c5eb4))
-   **deps:** update all non-major dependencies ([#352](https://github.com/skyra-project/discord-components/issues/352)) ([1674e2a](https://github.com/skyra-project/discord-components/commit/1674e2ad9275f4bea45cc4b3d60c8e9f3512ea95))
-   **deps:** update dependency @stencil/core to v3 ([#319](https://github.com/skyra-project/discord-components/issues/319)) ([2ed3e53](https://github.com/skyra-project/discord-components/commit/2ed3e53766b7827a9bdb75491a33392df283b381))
-   **react:** add types to export mapping ([bba1772](https://github.com/skyra-project/discord-components/commit/bba17727447104fcb01757afd1912c2ad630ac8b))
-   update generated react code ([1d3161b](https://github.com/skyra-project/discord-components/commit/1d3161bf6a436ed9a6c63c953189a208d29c5717))

# [3.6.0](https://github.com/skyra-project/discord-components/compare/v3.5.0...v3.6.0) (2023-01-23)

### Bug Fixes

-   update @stencil/core dependency ([df07642](https://github.com/skyra-project/discord-components/commit/df07642b48debf1ecbc05cceaeafd5cfed081c9a))
-   update name in LICENSE ([139caa5](https://github.com/skyra-project/discord-components/commit/139caa5e2798fd0d32258d532822b4b4ff8c0696))

### Features

-   add pin icon to system messages ([#317](https://github.com/skyra-project/discord-components/issues/317)) ([b34d635](https://github.com/skyra-project/discord-components/commit/b34d6357e02467ad4843a64591897e6b5ea99b22))

# [3.5.0](https://github.com/skyra-project/discord-components/compare/v3.4.1...v3.5.0) (2022-12-27)

### Bug Fixes

-   change to bunny font cdn and update font families ([10184ab](https://github.com/skyra-project/discord-components/commit/10184abd60de16977f9e88c595b93a44ac3521a4)), closes [#308](https://github.com/skyra-project/discord-components/issues/308)
-   **deps:** update all non-major dependencies ([#283](https://github.com/skyra-project/discord-components/issues/283)) ([8c225c4](https://github.com/skyra-project/discord-components/commit/8c225c4630b68d58f87d71250cc3aa984e623458))
-   **deps:** update all non-major dependencies ([#290](https://github.com/skyra-project/discord-components/issues/290)) ([185ef07](https://github.com/skyra-project/discord-components/commit/185ef075f614d00e3e5a0f6be375f28bd6496721))
-   **deps:** update all non-major dependencies ([#296](https://github.com/skyra-project/discord-components/issues/296)) ([58a4aa2](https://github.com/skyra-project/discord-components/commit/58a4aa2794d9241d85a7a071a3c46a74d0a3460f))
-   **deps:** update all non-major dependencies ([#302](https://github.com/skyra-project/discord-components/issues/302)) ([7642c51](https://github.com/skyra-project/discord-components/commit/7642c51868c557c0b8145cf26a040e726204a875))
-   **deps:** update all non-major dependencies ([#305](https://github.com/skyra-project/discord-components/issues/305)) ([68ae3f6](https://github.com/skyra-project/discord-components/commit/68ae3f63dc61e06f449805e4829e2eaa30e11541))
-   resolved typo in `ChannelForum` ([#289](https://github.com/skyra-project/discord-components/issues/289)) ([c30908d](https://github.com/skyra-project/discord-components/commit/c30908d5395561e0b77cfebaad7822c98ef8b0fe))

### Features

-   mention for slash commands ([#288](https://github.com/skyra-project/discord-components/issues/288)) ([294d0b5](https://github.com/skyra-project/discord-components/commit/294d0b5c926a96f0759bff5dfd703432cf6791d8))

## [3.4.1](https://github.com/skyra-project/discord-components/compare/v3.4.0...v3.4.1) (2022-08-06)

### Bug Fixes

-   **core:** enable `experimentalImportInjection` to ensure compatibility with Vite/NextJS builds ([053c8eb](https://github.com/skyra-project/discord-components/commit/053c8eb52ecf9cb763afd39441f11fdf81e76e21))
-   **deps:** update all non-major dependencies ([#271](https://github.com/skyra-project/discord-components/issues/271)) ([7896b9c](https://github.com/skyra-project/discord-components/commit/7896b9cfa081cbfa746bf9714db6cac31dfdc9bd))

# [3.4.0](https://github.com/skyra-project/discord-components/compare/v3.3.1...v3.4.0) (2022-05-10)

### Features

-   add forum mention icon ([#244](https://github.com/skyra-project/discord-components/issues/244)) ([eea0ee7](https://github.com/skyra-project/discord-components/commit/eea0ee70698637054f2685ea03179ad9a126f451))
-   add OP tag to profiles (+ author info style fixes) ([#245](https://github.com/skyra-project/discord-components/issues/245)) ([9206d4f](https://github.com/skyra-project/discord-components/commit/9206d4f5e7cca47a3f1c6df4e2854519ff3dada0))
-   add role icons ([#243](https://github.com/skyra-project/discord-components/issues/243)) ([b2a4dd0](https://github.com/skyra-project/discord-components/commit/b2a4dd077a49bfa8a032e13eeea9c871c5c3ebd4))

## [3.3.1](https://github.com/skyra-project/discord-components/compare/v3.3.0...v3.3.1) (2022-04-25)

### Bug Fixes

-   **core:** emit `[@vite-ignore](https://github.com/vite-ignore)` comments on dynamic imports ([ba84b9e](https://github.com/skyra-project/discord-components/commit/ba84b9ec4e8fe81ec452aba4c89b7b481b00ccaa))
-   **deps:** update all non-major dependencies ([#240](https://github.com/skyra-project/discord-components/issues/240)) ([e0e22fe](https://github.com/skyra-project/discord-components/commit/e0e22fe72158f1e9f92d61a5b04c58b7bf546de5))

# [3.3.0](https://github.com/skyra-project/discord-components/compare/v3.2.0...v3.3.0) (2022-04-06)

### Features

-   add `discord-time` component ([#229](https://github.com/skyra-project/discord-components/issues/229)) ([cdf0810](https://github.com/skyra-project/discord-components/commit/cdf08108e9a54e11c75e050ff176a42715aceb49))
-   add ephemeral messages and highlight fixes ([#230](https://github.com/skyra-project/discord-components/issues/230)) ([c5fc8f3](https://github.com/skyra-project/discord-components/commit/c5fc8f39bdecc54ad9daca1eb69115c9402e9da3))

# [3.2.0](https://github.com/skyra-project/discord-components/compare/v3.1.1...v3.2.0) (2022-04-04)

### Bug Fixes

-   **deps:** update all non-major dependencies ([#217](https://github.com/skyra-project/discord-components/issues/217)) ([3c391b6](https://github.com/skyra-project/discord-components/commit/3c391b68a28084ba514d9e5a8c3666fb7d456166))
-   **deps:** update all non-major dependencies ([#225](https://github.com/skyra-project/discord-components/issues/225)) ([87349f3](https://github.com/skyra-project/discord-components/commit/87349f3355c89c9c055ced1be7750f0251085132))

### Features

-   add new components to react bundle ([3055336](https://github.com/skyra-project/discord-components/commit/3055336043d0e80c106f13ca05377759383ec36a))
-   added multiple style specific components ([80ed132](https://github.com/skyra-project/discord-components/commit/80ed1326ea075cbe142cc8bc400d2f54a5bfaf30)), closes [#220](https://github.com/skyra-project/discord-components/issues/220)

## [3.1.1](https://github.com/skyra-project/discord-components/compare/v3.1.0...v3.1.1) (2022-03-10)

### Bug Fixes

-   bump `@stencil/core` dependency ([ecca4d8](https://github.com/skyra-project/discord-components/commit/ecca4d812ae371b57415c09fae7b5c8fa842700c))
-   **deps:** update all non-major dependencies ([#200](https://github.com/skyra-project/discord-components/issues/200)) ([c95dd81](https://github.com/skyra-project/discord-components/commit/c95dd81b03c042e695dd21db3c62c7137a4426f1))
-   **deps:** update all non-major dependencies ([#209](https://github.com/skyra-project/discord-components/issues/209)) ([2c0dd8a](https://github.com/skyra-project/discord-components/commit/2c0dd8a550ef78d23cf969597a3f08d7fb5c65ba))
-   match rebranded syles ([#216](https://github.com/skyra-project/discord-components/issues/216)) ([7ea32a9](https://github.com/skyra-project/discord-components/commit/7ea32a965557953416ad5f66ddbefed4a641c0fe))
-   rebuild react code ([e1d3766](https://github.com/skyra-project/discord-components/commit/e1d3766a1179ea70d41920ccf34786b27e96b6a7))

# [3.1.0](https://github.com/skyra-project/discord-components/compare/v3.0.1...v3.1.0) (2022-01-12)

### Features

-   **discord-embed-description:** add styles for nested HTML tags ([#195](https://github.com/skyra-project/discord-components/issues/195)) ([6ee7b9f](https://github.com/skyra-project/discord-components/commit/6ee7b9ffea10cfb0ed82a5771b88017060f04711))

## [3.0.1](https://github.com/skyra-project/discord-components/compare/v3.0.0...v3.0.1) (2022-01-08)

### Bug Fixes

-   **react:** use createElement named import for better compatibility with Vite ([1d770da](https://github.com/skyra-project/discord-components/commit/1d770daa291ce9222428d228ed7a7f8f9fad6ee8))

# [3.0.0](https://github.com/skyra-project/discord-components/compare/v2.13.0...v3.0.0) (2022-01-08)

### Bug Fixes

-   fixed embed description and footer disappearing when dynamically editing title ([bdec29c](https://github.com/skyra-project/discord-components/commit/bdec29c1999969a2ea0cf1198d3eb1986a80d674))

### BREAKING CHANGES

-   `discord-embed` no longer takes the properties `footer-image` and `timestamp`, they are moved to the `discord-embed-footer` component.
-   The embed description now has to go into its own component, `discord-embed-description`

```diff
<discord-embed slot="embeds">
-  Custom emojis in the embed description:
+  <discord-embed-description slot="description">Custom emojis in the embed description:</discord-embed-description>
</discord-embed>
```

-   The embed footer now has to go into its own component, `discord-embed-footer`

```diff
- <discord-embed slot="embeds" footer-image="/static/sapphire.png" timestamp="03/20/2021">
+ <discord-embed slot="embeds">
{ /* other embed components */ }
-  <span slot="footer">Open source libraries to aid in the creation of Discord bots</span>
+  <discord-embed-footer slot="footer" footer-image="/static/sapphire.png" timestamp="03/20/2021">
+    Open source libraries to aid in the creation of Discord bots
+  </discord-embed-footer>
</discord-embed>
```

# [2.13.0](https://github.com/skyra-project/discord-components/compare/v2.12.1...v2.13.0) (2021-12-22)

### Bug Fixes

-   **deps:** update all non-major dependencies ([#184](https://github.com/skyra-project/discord-components/issues/184)) ([792e791](https://github.com/skyra-project/discord-components/commit/792e791bba008eacea279b7802da506e9fb64a68))

### Features

-   **discord-invite:** localization support for invite title and button ([#183](https://github.com/skyra-project/discord-components/issues/183)) ([8fd541b](https://github.com/skyra-project/discord-components/commit/8fd541b60b8157aae26748b5400b647753594578))

## [2.12.1](https://github.com/skyra-project/discord-components/compare/v2.12.0...v2.12.1) (2021-12-06)

### Bug Fixes

-   **deps:** update all non-major dependencies ([#177](https://github.com/skyra-project/discord-components/issues/177)) ([36a4c5d](https://github.com/skyra-project/discord-components/commit/36a4c5d871b08418ff96bcf471035bdb19f73598))
-   **discord-embed:** hide embed description when not provided ([f3f3302](https://github.com/skyra-project/discord-components/commit/f3f33029ca62f4517de8dfc3051855b36d8485db)), closes [#180](https://github.com/skyra-project/discord-components/issues/180)

# [2.12.0](https://github.com/skyra-project/discord-components/compare/v2.11.6...v2.12.0) (2021-11-13)

### Features

-   Add `discord-custom-emoji` component & custom emojis in embed titles ([#168](https://github.com/skyra-project/discord-components/issues/168)) ([61a808e](https://github.com/skyra-project/discord-components/commit/61a808e46f16d3ce9c7ea888e208cd1fcbe30e75)), closes [#163](https://github.com/skyra-project/discord-components/issues/163)

## [2.11.6](https://github.com/skyra-project/discord-components/compare/v2.11.5...v2.11.6) (2021-11-08)

### Bug Fixes

-   **react:** fix ESM loading ([8a43f53](https://github.com/skyra-project/discord-components/commit/8a43f5367b48d086bdd46c52d393547bc6209170))

## [2.11.5](https://github.com/skyra-project/discord-components/compare/v2.11.4...v2.11.5) (2021-11-08)

### Bug Fixes

-   **react:** only output ESM bundle ([cf9da04](https://github.com/skyra-project/discord-components/commit/cf9da04318fc5013f8637f01bd4c733b617ad074))

## [2.11.4](https://github.com/skyra-project/discord-components/compare/v2.11.3...v2.11.4) (2021-11-08)

### Bug Fixes

-   **docs:** update nextjs codesandbox link ([4d6382f](https://github.com/skyra-project/discord-components/commit/4d6382fe3538f85cd60ea8aa28e570023b536c98))

## [2.11.3](https://github.com/skyra-project/discord-components/compare/v2.11.3-alpha.3...v2.11.3) (2021-11-08)

**Note:** Version bump only for package root

## [2.11.3-alpha.3](https://github.com/skyra-project/discord-components/compare/v2.11.3-alpha.2...v2.11.3-alpha.3) (2021-11-08)

### Bug Fixes

-   **react:** add dependency on tslib ([cc0b85e](https://github.com/skyra-project/discord-components/commit/cc0b85e23434611302bc1494aa2a76273912f6d1))

## [2.11.3-alpha.2](https://github.com/skyra-project/discord-components/compare/v2.11.3-alpha.1...v2.11.3-alpha.2) (2021-11-08)

### Bug Fixes

-   **react:** no longer use esbuild for bundling ([d03ed4d](https://github.com/skyra-project/discord-components/commit/d03ed4d170493380d724d24268b195c1f4e4d71d))

## [2.11.3-alpha.1](https://github.com/skyra-project/discord-components/compare/v2.11.3-alpha.0...v2.11.3-alpha.1) (2021-11-08)

### Bug Fixes

-   debump required nodejs engine to 14.0.0 ([310f9bc](https://github.com/skyra-project/discord-components/commit/310f9bc6cdcafe6fd0d7267ffff70539b981b4be))

## [2.11.3-alpha.0](https://github.com/skyra-project/discord-components/compare/v2.11.2...v2.11.3-alpha.0) (2021-11-08)

### Bug Fixes

-   **deps:** update all non-major dependencies ([#158](https://github.com/skyra-project/discord-components/issues/158)) ([069255e](https://github.com/skyra-project/discord-components/commit/069255edf3b42b7549cb8a5382fc8f8899a95ac2))
-   **deps:** update all non-major dependencies ([#166](https://github.com/skyra-project/discord-components/issues/166)) ([8d22036](https://github.com/skyra-project/discord-components/commit/8d22036549cca3f7eb2518ac14deda46902f5d55))

## [2.11.2](https://github.com/skyra-project/discord-components/compare/v2.11.1...v2.11.2) (2021-10-03)

### Bug Fixes

-   re-fix react bundle. The output file _has_ to be mjs for this to all work ([946652b](https://github.com/skyra-project/discord-components/commit/946652bb6166e1cf06c681e3fb410ef92975914b))

### Reverts

-   Revert "fix(react): fixed output targets" ([129f14f](https://github.com/skyra-project/discord-components/commit/129f14f8aa2f335a7b37f2d2f068ea87623fce49))

## [2.11.1](https://github.com/skyra-project/discord-components/compare/v2.11.0...v2.11.1) (2021-10-03)

### Bug Fixes

-   **react:** fixed output targets ([ba9faf1](https://github.com/skyra-project/discord-components/commit/ba9faf1ba0c04e89eba3e15341879cbc7dd65369))

# [2.11.0](https://github.com/skyra-project/discord-components/compare/v2.10.1-alpha.0...v2.11.0) (2021-10-02)

### Features

-   Thread Accessories ([#150](https://github.com/skyra-project/discord-components/issues/150)) ([232f05d](https://github.com/skyra-project/discord-components/commit/232f05d915fef41486150e2db43589e9fc11c742))
-   Use channel icons in mentions ([#151](https://github.com/skyra-project/discord-components/issues/151)) ([b3fe40d](https://github.com/skyra-project/discord-components/commit/b3fe40dfbfce68df531e38908d28efacb21cc61b))

## [2.10.1-alpha.0](https://github.com/skyra-project/discord-components/compare/v2.10.0...v2.10.1-alpha.0) (2021-09-21)

### Bug Fixes

-   output react bundle as `.js` to fix a Webpack issue, not loading named imports of `.mjs` files ([bc166f6](https://github.com/skyra-project/discord-components/commit/bc166f6c80b1b0b491144c179bf1a1cc30b6d1b5))

# [2.10.0](https://github.com/skyra-project/discord-components/compare/v2.9.1...v2.10.0) (2021-09-12)

### Features

-   add `discord-tenor-video` component ([#127](https://github.com/skyra-project/discord-components/issues/127)) ([c90dde0](https://github.com/skyra-project/discord-components/commit/c90dde02c23b8c9d25c676249518c60daeaf5d58))

## [2.9.1](https://github.com/skyra-project/discord-components/compare/v2.9.1-alpha.0...v2.9.1) (2021-09-12)

**Note:** Version bump only for package root

## [2.9.1-alpha.0](https://github.com/skyra-project/discord-components/compare/v2.9.0...v2.9.1-alpha.0) (2021-09-10)

**Note:** Version bump only for package root

# [2.9.0](https://github.com/skyra-project/discord-components/compare/v2.8.1...v2.9.0) (2021-09-05)

### Features

-   **discord-mention:** add new thread type ([#117](https://github.com/skyra-project/discord-components/issues/117)) ([3719679](https://github.com/skyra-project/discord-components/commit/371967908b60421a67fd72ad3ad5ec4adab932a2))

## [2.8.1](https://github.com/skyra-project/discord-components/compare/v2.8.0...v2.8.1) (2021-08-18)

### Bug Fixes

-   **discord-command:** remove prepending slash in names ([#111](https://github.com/skyra-project/discord-components/issues/111)) ([c86a17e](https://github.com/skyra-project/discord-components/commit/c86a17ea3494fb050914bddbb385e375fea60876))

# [2.8.0](https://github.com/skyra-project/discord-components/compare/v2.7.1...v2.8.0) (2021-08-18)

### Bug Fixes

-   use proper URLs for discord avatars ([#108](https://github.com/skyra-project/discord-components/issues/108)) ([446cdf4](https://github.com/skyra-project/discord-components/commit/446cdf4863d7e027cd2f08c6b9600e07491cfae2))

### Features

-   add component buttons ([#110](https://github.com/skyra-project/discord-components/issues/110)) ([50f78c5](https://github.com/skyra-project/discord-components/commit/50f78c5643277164e791261f8a8af76a8d893015))

## [2.7.1](https://github.com/skyra-project/discord-components/compare/v2.7.0...v2.7.1) (2021-08-07)

### Bug Fixes

-   **react:** minify build output ([932aaf8](https://github.com/skyra-project/discord-components/commit/932aaf875afb493c818487fd07f8c642e3935a02))

# [2.7.0](https://github.com/skyra-project/discord-components/compare/v2.6.0...v2.7.0) (2021-08-07)

### Features

-   add system messages ([#105](https://github.com/skyra-project/discord-components/issues/105)) ([53440f4](https://github.com/skyra-project/discord-components/commit/53440f44cbe30d7458cc9e38f30c7636483b4a7a))

# [2.6.0](https://github.com/skyra-project/discord-components/compare/v2.5.0...v2.6.0) (2021-08-05)

### Bug Fixes

-   specify string union type for DiscordMention#type prop ([3b8204e](https://github.com/skyra-project/discord-components/commit/3b8204e11bdbe41b17bd2963f6afa11d6e903511))

### Features

-   add replies (+ style changes) ([#103](https://github.com/skyra-project/discord-components/issues/103)) ([065e452](https://github.com/skyra-project/discord-components/commit/065e452f9d0386dfd1b426793aca4c7f07c9c0ae))

# [2.5.0](https://github.com/skyra-project/discord-components/compare/v2.4.0...v2.5.0) (2021-08-04)

### Bug Fixes

-   fixed published bundle ([5f5c545](https://github.com/skyra-project/discord-components/commit/5f5c5456b74dc14096b32d4b5e8fe8d503686c55))

### Features

-   add locked type for mentions ([#102](https://github.com/skyra-project/discord-components/issues/102)) ([e70a5bb](https://github.com/skyra-project/discord-components/commit/e70a5bb242ed695352e5088f6434574dd3614678))

# [2.4.0](https://github.com/skyra-project/discord-components/compare/v2.3.0...v2.4.0) (2021-07-25)

### Features

-   add option to make reactions non-interactive ([b5f61b0](https://github.com/skyra-project/discord-components/commit/b5f61b07ffbd5d4e547b0e8324117ad582fc6295))

# [2.3.0](https://github.com/skyra-project/discord-components/compare/v2.2.0...v2.3.0) (2021-07-25)

### Features

-   add click event handler to reactions ([7686af8](https://github.com/skyra-project/discord-components/commit/7686af8653233b234315e3932e4e38c13448a6b9))
-   add reactions ([#96](https://github.com/skyra-project/discord-components/issues/96)) ([3bb19a6](https://github.com/skyra-project/discord-components/commit/3bb19a69912b9666f922c36eabe6fb959b4fc495))
-   add voice type to mentions ([#97](https://github.com/skyra-project/discord-components/issues/97)) ([9b9fcb2](https://github.com/skyra-project/discord-components/commit/9b9fcb298933405e287ded6b3df27a7f4a60c3ff))

# [2.2.0](https://github.com/skyra-project/discord-components/compare/v2.1.1...v2.2.0) (2021-07-22)

### Features

-   add invite and attachments container components ([#94](https://github.com/skyra-project/discord-components/issues/94)) ([3b782a0](https://github.com/skyra-project/discord-components/commit/3b782a0147a46ce8779bd7387786a07fdc94f5ac))

## [2.1.1](https://github.com/skyra-project/discord-components/compare/v2.1.0...v2.1.1) (2021-07-10)

### Bug Fixes

-   **readme:** update urls and add nextJS demo ([551f9e7](https://github.com/skyra-project/discord-components/commit/551f9e763a48b0854450054404476e6d641a77d3))

# [2.1.0](https://github.com/skyra-project/discord-components/compare/v2.0.9...v2.1.0) (2021-06-26)

### Features

-   add support for server crosspost webhook messages ([a02ec25](https://github.com/skyra-project/discord-components/commit/a02ec254f6804ea76282d081a674c838a87ef396)), closes [#88](https://github.com/skyra-project/discord-components/issues/88)

## [2.0.9](https://github.com/skyra-project/discord-components/compare/v2.0.8...v2.0.9) (2021-06-21)

### Bug Fixes

-   **css:** update to discord rebrand colors ([fe03134](https://github.com/skyra-project/discord-components/commit/fe031344284f0e1674813dfcbc9e43a33b1b78fd))

## [2.0.8](https://github.com/skyra-project/discord-components/compare/v2.0.7...v2.0.8) (2021-06-21)

### Bug Fixes

-   **docs:** add live demo for "No Framework" ([b58242f](https://github.com/skyra-project/discord-components/commit/b58242f39b7f3d316616c844ed922aa0c4834034))
-   **docs:** remove default font from ToC ([82a1281](https://github.com/skyra-project/discord-components/commit/82a1281e84c51287ad01282d399c1be530d8ab2d))

## [2.0.7](https://github.com/skyra-project/discord-components/compare/v2.0.7-alpha.0...v2.0.7) (2021-05-20)

**Note:** Version bump only for package root

## [2.0.7-alpha.0](https://github.com/skyra-project/discord-components/compare/v2.0.6...v2.0.7-alpha.0) (2021-05-19)

### Bug Fixes

-   **core:** specify exports for loader ([b94604f](https://github.com/skyra-project/discord-components/commit/b94604f374ef2944786469401d1505888f6ccc05))

## [2.0.6](https://github.com/skyra-project/discord-components/compare/v2.0.5...v2.0.6) (2021-05-19)

### Bug Fixes

-   specify sideEffects and fix `es2015` and `es2017` file paths ([b759b3c](https://github.com/skyra-project/discord-components/commit/b759b3c4ca9e505b49592d4152f1b5ada4876cc5))

## [2.0.5](https://github.com/skyra-project/discord-components/compare/v2.0.4...v2.0.5) (2021-05-15)

### Bug Fixes

-   **core:** update mention colours to match Discord May 2021 redesign ([a7c7a84](https://github.com/skyra-project/discord-components/commit/a7c7a847082738aeb2405340e79a738ade3563db))

## [2.0.4](https://github.com/skyra-project/discord-components/compare/v2.0.3...v2.0.4) (2021-05-15)

### Bug Fixes

-   change links from discord-message-components to discord-components ([5a8e1e1](https://github.com/skyra-project/discord-components/commit/5a8e1e1e0b3a34020a91f0dae9464141195d8fab))
-   **readme:** update preview images ([a9dc715](https://github.com/skyra-project/discord-components/commit/a9dc715cd99687cfac1912180189eca0229df545))

## [2.0.3](https://github.com/skyra-project/discord-components/compare/v2.0.3-alpha.3...v2.0.3) (2021-05-15)

**Note:** Version bump only for package root

## [2.0.3-alpha.3](https://github.com/skyra-project/discord-components/compare/v2.0.3-alpha.2...v2.0.3-alpha.3) (2021-05-15)

### Reverts

-   "chore: re-add prepublishOnly" ([3609469](https://github.com/skyra-project/discord-components/commit/360946963177a61e158b2082b648adab531f4e63))

## [2.0.3-alpha.2](https://github.com/skyra-project/discord-components/compare/v2.0.3-alpha.1...v2.0.3-alpha.2) (2021-05-15)

### Bug Fixes

-   **react:** include polyfills again ([43ca559](https://github.com/skyra-project/discord-components/commit/43ca5590416559b92a32fb6e9cd1a53c357322a2))

## [2.0.3-alpha.1](https://github.com/skyra-project/discord-components/compare/v2.0.3-alpha.0...v2.0.3-alpha.1) (2021-05-15)

### Bug Fixes

-   fixed Avatar options ([2b97ca8](https://github.com/skyra-project/discord-components/commit/2b97ca80c89e64ad00ffb7f5660fbeed91bacf24))
-   fixed package bundling ([11d2627](https://github.com/skyra-project/discord-components/commit/11d2627bad707a1997e286a02b3004035dfdb306))
-   styling of components ([#72](https://github.com/skyra-project/discord-components/issues/72)) ([b440c2f](https://github.com/skyra-project/discord-components/commit/b440c2fd0b3c1411c0e96e68b0c599b1b95dfecd))

### Features

-   use whitney font as default font ([d7c9267](https://github.com/skyra-project/discord-components/commit/d7c9267a7680df5a3b8c7dbab5e14f673ada162b))

## [2.0.3-alpha.0](https://github.com/skyra-project/discord-components/compare/v2.0.2...v2.0.3-alpha.0) (2021-03-20)

### Bug Fixes

-   **core:** export options on top level ([d128f13](https://github.com/skyra-project/discord-components/commit/d128f13b69a22f134ef89a5fbdd4ad9db94006d0))
-   **core:** use proper lifecycle for embed ([e17ddb9](https://github.com/skyra-project/discord-components/commit/e17ddb9f413b380cb668a7d6a8554c5df31e05ff))
-   **react:** move core from peer to regular dependencies ([8d1e3ff](https://github.com/skyra-project/discord-components/commit/8d1e3ff85a519b27f5590d9f01e98111de7695ae))
-   change lifecycle hooks to `componentWillRender` so props are recomputed on re-renders ([e19f9c3](https://github.com/skyra-project/discord-components/commit/e19f9c3345ee6e943b5d19e383bb4268d1cbc516))
-   fixed readmes and such ([bdb8846](https://github.com/skyra-project/discord-components/commit/bdb8846db2ded36567ef624ddddedf95f59e549b))

### Reverts

-   Revert "chore: run build for prepublishOnly" ([6b405bc](https://github.com/skyra-project/discord-components/commit/6b405bcb7cd386cd42981ff2946cca261742f73e))

## [2.0.2](https://github.com/skyra-project/discord-components/compare/v2.0.1...v2.0.2) (2020-10-26)

### Bug Fixes

-   **react:** allow peer dependency of React 17 and Core 2 ([ae5fb27](https://github.com/skyra-project/discord-components/commit/ae5fb278643f68714bc646697e97269686517eb3))

## [2.0.1](https://github.com/skyra-project/discord-components/compare/v2.0.0...v2.0.1) (2020-10-07)

### Bug Fixes

-   **core:** fixed date parsing for discord-embed ([515d243](https://github.com/skyra-project/discord-components/commit/515d243aa53b921dae523fb599bea9da4e419c07))

# [2.0.0](https://github.com/skyra-project/discord-components/compare/v1.3.0...v2.0.0) (2020-09-05)

### Features

-   bumped stencil-core to v2 ([59ef71e](https://github.com/skyra-project/discord-components/commit/59ef71e48ac786edb35b7c52523206104796a9f0)), closes [/github.com/ionic-team/stencil/blob/master/CHANGELOG.md#-200-2020-08-31](https://github.com//github.com/ionic-team/stencil/blob/master/CHANGELOG.md/issues/-200-2020-08-31) [#12](https://github.com/skyra-project/discord-components/issues/12)

### BREAKING CHANGES

-   IE11, Edge 16-18, Safari 10 and ES5 builds and support for them is fully removed
    now. Also some files are exported under different names in core. For a full list see

# [1.3.0](https://github.com/skyra-project/discord-components/compare/v1.2.2...v1.3.0) (2020-07-26)

### Features

-   rename master branch to main ([0bc3666](https://github.com/skyra-project/discord-components/commit/0bc36663a83ab55df4ebb96fc9c69d6809008934))

## [1.2.2](https://github.com/skyra-project/discord-components/compare/v1.2.1...v1.2.2) (2020-07-13)

### Bug Fixes

-   **core:** fixed layout of messages ([5def145](https://github.com/skyra-project/discord-components/commit/5def1450c0baae16eedd17fdec5e63f93b16f0f3))

## [1.2.1](https://github.com/skyra-project/discord-components/compare/v1.2.0...v1.2.1) (2020-07-08)

### Bug Fixes

-   **attachments:** remove width/height modifier size ([4aea4bd](https://github.com/skyra-project/discord-components/commit/4aea4bdbb8aca01fae90a3a1f8aa5caa50df3ae6))

# [1.2.0](https://github.com/skyra-project/discord-components/compare/v1.1.4...v1.2.0) (2020-07-07)

### Bug Fixes

-   update highlighted mention styling ([98e4827](https://github.com/skyra-project/discord-components/commit/98e4827f9829b6d0b8d30a78337a40e3d44c9fb5))
-   **embed-field:** set title to white to match Discord revert ([2e6007f](https://github.com/skyra-project/discord-components/commit/2e6007fb724edf389a63a534936d1ed528d1fd6c))

### Features

-   **core:** add discord-attachment component ([adef9b1](https://github.com/skyra-project/discord-components/commit/adef9b121c0ba7061374cbe389560706aa07c76a))

## [1.1.4](https://github.com/skyra-project/discord-components/compare/v1.1.3...v1.1.4) (2020-07-06)

### Bug Fixes

-   **core:** fixed that lib didn't load when not defining window.\$discordMessage ([64293a6](https://github.com/skyra-project/discord-components/commit/64293a6f63ccf3c78f3c8086a0d13d8335d784e1))

## [1.1.3](https://github.com/skyra-project/discord-components/compare/v1.1.2...v1.1.3) (2020-07-06)

### Bug Fixes

-   fixed the unpkg/jsdelivr builds ([d863049](https://github.com/skyra-project/discord-components/commit/d86304962a384f5e7a792fb67db826a389ba6aa5))

## [1.1.2](https://github.com/skyra-project/discord-components/compare/v1.1.1...v1.1.2) (2020-06-27)

### Bug Fixes

-   bump package, regenerate react output ([07af3cc](https://github.com/skyra-project/discord-components/commit/07af3cc4e3ab3df728c4ed91341af2e7a5db3239))

## [1.1.1](https://github.com/skyra-project/discord-components/compare/v1.1.0...v1.1.1) (2020-06-06)

### Bug Fixes

-   bump packages, fixing some stenciljs bugs ([2ac34a9](https://github.com/skyra-project/discord-components/commit/2ac34a9abca911e1abffc9671cb75cb24357335a))

# [1.1.0](https://github.com/skyra-project/discord-components/compare/v1.0.1...v1.1.0) (2020-05-19)

### Bug Fixes

-   **core:** fixed parsing of global profile ([8b31278](https://github.com/skyra-project/discord-components/commit/8b3127857e4bdd0a835e27bd1412f9cbb619b31f))

### Features

-   **core:** allow 3-aside inline embed fields ([ec05f33](https://github.com/skyra-project/discord-components/commit/ec05f3372b8c7b590bf0c2d3526f53b3bd2aec98)), closes [#3](https://github.com/skyra-project/discord-components/issues/3)
-   **embed:** embedding videos ([1678248](https://github.com/skyra-project/discord-components/commit/1678248ffe7413bb6e66437f03fed0d15b135e4e)), closes [#1](https://github.com/skyra-project/discord-components/issues/1)
-   **embed:** provider option ([bf23e66](https://github.com/skyra-project/discord-components/commit/bf23e666555035b80625bccd00f49dfd622f80f9)), closes [#2](https://github.com/skyra-project/discord-components/issues/2)

## [1.0.1](https://github.com/skyra-project/discord-components/compare/v1.0.0...v1.0.1) (2020-05-10)

### Bug Fixes

-   **mention:** fixed discord mentions rendering type ([d94a092](https://github.com/skyra-project/discord-components/commit/d94a092f2e9b4c2cd6b4362e14105f7dfb54b6d9))
-   **message:** add hover background to match Discord ([d2c8f32](https://github.com/skyra-project/discord-components/commit/d2c8f32d5f73eb9d65ac091427628d6c705af6b2))

# [1.0.0](https://github.com/skyra-project/discord-components/compare/v1.0.0-alpha.1...v1.0.0) (2020-05-10)

**Note:** Version bump only for package root

# [1.0.0-alpha.1](https://github.com/skyra-project/discord-components/compare/v1.0.0-alpha.0...v1.0.0-alpha.1) (2020-05-10)

**Note:** Version bump only for package root

# 1.0.0-alpha.0 (2020-05-10)

### Features

-   create packages ([1ad5856](https://github.com/skyra-project/discord-components/commit/1ad58560916d3988e8dffc58ad97a52828ff5d35))
