// States transitions table for DEC’s ANSI-compatible video terminals
// https://vt100.net/emu/dec_ansi_parser
// https://github.com/haberman/vtparse

// FROM_STATE, FROM_CHAR, TO_CHAR, ACTION, TO_STATE

STATE(ANYWHERE, 0x18, 0x18, EXECUTE, GROUND)
STATE(ANYWHERE, 0x1a, 0x1a, EXECUTE, GROUND)
STATE(ANYWHERE, 0x80, 0x8f, EXECUTE, GROUND)
STATE(ANYWHERE, 0x91, 0x97, EXECUTE, GROUND)
STATE(ANYWHERE, 0x99, 0x99, EXECUTE, GROUND)
STATE(ANYWHERE, 0x9a, 0x9a, EXECUTE, GROUND)
STATE(ANYWHERE, 0x9c, 0x9c, NONE, GROUND)
STATE(ANYWHERE, 0x1b, 0x1b, NONE, ESCAPE)
STATE(ANYWHERE, 0x98, 0x98, NONE, SOS_PM_APC_STRING)
STATE(ANYWHERE, 0x9e, 0x9e, NONE, SOS_PM_APC_STRING)
STATE(ANYWHERE, 0x9f, 0x9f, NONE, SOS_PM_APC_STRING)
STATE(ANYWHERE, 0x90, 0x90, NONE, DCS_ENTRY)
STATE(ANYWHERE, 0x9d, 0x9d, NONE, OSC_STRING)
STATE(ANYWHERE, 0x9b, 0x9b, NONE, CSI_ENTRY)
STATE(GROUND, 0x00, 0x17, EXECUTE, NONE)
STATE(GROUND, 0x19, 0x19, EXECUTE, NONE)
STATE(GROUND, 0x1c, 0x1f, EXECUTE, NONE)
STATE(GROUND, 0x20, 0x7f, PRINT, NONE)
STATE(ESCAPE, ON_ENTRY, ON_ENTRY, CLEAR, NONE)
STATE(ESCAPE, 0x00, 0x17, EXECUTE, NONE)
STATE(ESCAPE, 0x19, 0x19, EXECUTE, NONE)
STATE(ESCAPE, 0x1c, 0x1f, EXECUTE, NONE)
STATE(ESCAPE, 0x7f, 0x7f, IGNORE, NONE)
STATE(ESCAPE, 0x20, 0x2f, COLLECT, ESCAPE_INTERMEDIATE)
STATE(ESCAPE, 0x30, 0x4f, ESC_DISPATCH, GROUND)
STATE(ESCAPE, 0x51, 0x57, ESC_DISPATCH, GROUND)
STATE(ESCAPE, 0x59, 0x59, ESC_DISPATCH, GROUND)
STATE(ESCAPE, 0x5a, 0x5a, ESC_DISPATCH, GROUND)
STATE(ESCAPE, 0x5c, 0x5c, ESC_DISPATCH, GROUND)
STATE(ESCAPE, 0x60, 0x7e, ESC_DISPATCH, GROUND)
STATE(ESCAPE, 0x5b, 0x5b, NONE, CSI_ENTRY)
STATE(ESCAPE, 0x5d, 0x5d, NONE, OSC_STRING)
STATE(ESCAPE, 0x50, 0x50, NONE, DCS_ENTRY)
STATE(ESCAPE, 0x58, 0x58, NONE, SOS_PM_APC_STRING)
STATE(ESCAPE, 0x5e, 0x5e, NONE, SOS_PM_APC_STRING)
STATE(ESCAPE, 0x5f, 0x5f, NONE, SOS_PM_APC_STRING)
STATE(ESCAPE_INTERMEDIATE, 0x00, 0x17, EXECUTE, NONE)
STATE(ESCAPE_INTERMEDIATE, 0x19, 0x19, EXECUTE, NONE)
STATE(ESCAPE_INTERMEDIATE, 0x1c, 0x1f, EXECUTE, NONE)
STATE(ESCAPE_INTERMEDIATE, 0x20, 0x2f, COLLECT, NONE)
STATE(ESCAPE_INTERMEDIATE, 0x7f, 0x7f, IGNORE, NONE)
STATE(ESCAPE_INTERMEDIATE, 0x30, 0x7e, ESC_DISPATCH, GROUND)
STATE(CSI_ENTRY, ON_ENTRY, ON_ENTRY, CLEAR, NONE)
STATE(CSI_ENTRY, 0x00, 0x17, EXECUTE, NONE)
STATE(CSI_ENTRY, 0x19, 0x19, EXECUTE, NONE)
STATE(CSI_ENTRY, 0x1c, 0x1f, EXECUTE, NONE)
STATE(CSI_ENTRY, 0x7f, 0x7f, IGNORE, NONE)
STATE(CSI_ENTRY, 0x20, 0x2f, COLLECT, CSI_INTERMEDIATE)
STATE(CSI_ENTRY, 0x3a, 0x3a, NONE, CSI_IGNORE)
STATE(CSI_ENTRY, 0x30, 0x39, PARAM, CSI_PARAM)
STATE(CSI_ENTRY, 0x3b, 0x3b, PARAM, CSI_PARAM)
STATE(CSI_ENTRY, 0x3c, 0x3f, COLLECT, CSI_PARAM)
STATE(CSI_ENTRY, 0x40, 0x7e, CSI_DISPATCH, GROUND)
STATE(CSI_IGNORE, 0x00, 0x17, EXECUTE, NONE)
STATE(CSI_IGNORE, 0x19, 0x19, EXECUTE, NONE)
STATE(CSI_IGNORE, 0x1c, 0x1f, EXECUTE, NONE)
STATE(CSI_IGNORE, 0x20, 0x3f, IGNORE, NONE)
STATE(CSI_IGNORE, 0x7f, 0x7f, IGNORE, NONE)
STATE(CSI_IGNORE, 0x40, 0x7e, NONE, GROUND)
STATE(CSI_PARAM, 0x00, 0x17, EXECUTE, NONE)
STATE(CSI_PARAM, 0x19, 0x19, EXECUTE, NONE)
STATE(CSI_PARAM, 0x1c, 0x1f, EXECUTE, NONE)
STATE(CSI_PARAM, 0x30, 0x39, PARAM, NONE)
STATE(CSI_PARAM, 0x3b, 0x3b, PARAM, NONE)
STATE(CSI_PARAM, 0x7f, 0x7f, IGNORE, NONE)
STATE(CSI_PARAM, 0x3a, 0x3a, NONE, CSI_IGNORE)
STATE(CSI_PARAM, 0x3c, 0x3f, NONE, CSI_IGNORE)
STATE(CSI_PARAM, 0x20, 0x2f, COLLECT, CSI_INTERMEDIATE)
STATE(CSI_PARAM, 0x40, 0x7e, CSI_DISPATCH, GROUND)
STATE(CSI_INTERMEDIATE, 0x00, 0x17, EXECUTE, NONE)
STATE(CSI_INTERMEDIATE, 0x19, 0x19, EXECUTE, NONE)
STATE(CSI_INTERMEDIATE, 0x1c, 0x1f, EXECUTE, NONE)
STATE(CSI_INTERMEDIATE, 0x20, 0x2f, COLLECT, NONE)
STATE(CSI_INTERMEDIATE, 0x7f, 0x7f, IGNORE, NONE)
STATE(CSI_INTERMEDIATE, 0x30, 0x3f, NONE, CSI_IGNORE)
STATE(CSI_INTERMEDIATE, 0x40, 0x7e, CSI_DISPATCH, GROUND)
STATE(DCS_ENTRY, ON_ENTRY, ON_ENTRY, CLEAR, NONE)
STATE(DCS_ENTRY, 0x00, 0x17, IGNORE, NONE)
STATE(DCS_ENTRY, 0x19, 0x19, IGNORE, NONE)
STATE(DCS_ENTRY, 0x1c, 0x1f, IGNORE, NONE)
STATE(DCS_ENTRY, 0x7f, 0x7f, IGNORE, NONE)
STATE(DCS_ENTRY, 0x3a, 0x3a, NONE, DCS_IGNORE)
STATE(DCS_ENTRY, 0x20, 0x2f, COLLECT, DCS_INTERMEDIATE)
STATE(DCS_ENTRY, 0x30, 0x39, PARAM, DCS_PARAM)
STATE(DCS_ENTRY, 0x3b, 0x3b, PARAM, DCS_PARAM)
STATE(DCS_ENTRY, 0x3c, 0x3f, COLLECT, DCS_PARAM)
STATE(DCS_ENTRY, 0x40, 0x7e, NONE, DCS_PASSTHROUGH)
STATE(DCS_INTERMEDIATE, 0x00, 0x17, IGNORE, NONE)
STATE(DCS_INTERMEDIATE, 0x19, 0x19, IGNORE, NONE)
STATE(DCS_INTERMEDIATE, 0x1c, 0x1f, IGNORE, NONE)
STATE(DCS_INTERMEDIATE, 0x20, 0x2f, COLLECT, NONE)
STATE(DCS_INTERMEDIATE, 0x7f, 0x7f, IGNORE, NONE)
STATE(DCS_INTERMEDIATE, 0x30, 0x3f, NONE, DCS_IGNORE)
STATE(DCS_INTERMEDIATE, 0x40, 0x7e, NONE, DCS_PASSTHROUGH)
STATE(DCS_IGNORE, 0x00, 0x17, IGNORE, NONE)
STATE(DCS_IGNORE, 0x19, 0x19, IGNORE, NONE)
STATE(DCS_IGNORE, 0x1c, 0x1f, IGNORE, NONE)
STATE(DCS_IGNORE, 0x20, 0x7f, IGNORE, NONE)
STATE(DCS_PARAM, 0x00, 0x17, IGNORE, NONE)
STATE(DCS_PARAM, 0x19, 0x19, IGNORE, NONE)
STATE(DCS_PARAM, 0x1c, 0x1f, IGNORE, NONE)
STATE(DCS_PARAM, 0x30, 0x39, PARAM, NONE)
STATE(DCS_PARAM, 0x3b, 0x3b, PARAM, NONE)
STATE(DCS_PARAM, 0x7f, 0x7f, IGNORE, NONE)
STATE(DCS_PARAM, 0x3a, 0x3a, NONE, DCS_IGNORE)
STATE(DCS_PARAM, 0x3c, 0x3f, NONE, DCS_IGNORE)
STATE(DCS_PARAM, 0x20, 0x2f, COLLECT, DCS_INTERMEDIATE)
STATE(DCS_PARAM, 0x40, 0x7e, NONE, DCS_PASSTHROUGH)
STATE(DCS_PASSTHROUGH, ON_ENTRY, ON_ENTRY, HOOK, NONE)
STATE(DCS_PASSTHROUGH, 0x00, 0x17, PUT, NONE)
STATE(DCS_PASSTHROUGH, 0x19, 0x19, PUT, NONE)
STATE(DCS_PASSTHROUGH, 0x1c, 0x1f, PUT, NONE)
STATE(DCS_PASSTHROUGH, 0x20, 0x7e, PUT, NONE)
STATE(DCS_PASSTHROUGH, 0x7f, 0x7f, IGNORE, NONE)
STATE(DCS_PASSTHROUGH, ON_EXIT, ON_EXIT, UNHOOK, NONE)
STATE(SOS_PM_APC_STRING, 0x00, 0x17, IGNORE, NONE)
STATE(SOS_PM_APC_STRING, 0x19, 0x19, IGNORE, NONE)
STATE(SOS_PM_APC_STRING, 0x1c, 0x1f, IGNORE, NONE)
STATE(SOS_PM_APC_STRING, 0x20, 0x7f, IGNORE, NONE)
STATE(OSC_STRING, ON_ENTRY, ON_ENTRY, OSC_START, NONE)
STATE(OSC_STRING, 0x00, 0x17, IGNORE, NONE)
STATE(OSC_STRING, 0x19, 0x19, IGNORE, NONE)
STATE(OSC_STRING, 0x1c, 0x1f, IGNORE, NONE)
STATE(OSC_STRING, 0x20, 0x7f, OSC_PUT, NONE)
STATE(OSC_STRING, ON_EXIT, ON_EXIT, OSC_END, NONE)
