#include "tables.h"

namespace Jpeg {

// MARK: Quantization ----------------------------------------------------------

Quant const QUANT_Y50 = {
    16, 11, 10, 16, 24, 40, 51, 61,
    12, 12, 14, 19, 26, 58, 60, 55,
    14, 13, 16, 24, 40, 57, 69, 56,
    14, 17, 22, 29, 51, 87, 80, 62,
    18, 22, 37, 56, 68, 109, 103, 77,
    24, 35, 55, 64, 81, 104, 113, 92,
    49, 64, 78, 87, 103, 121, 120, 101,
    72, 92, 95, 98, 112, 100, 103, 99
};

Quant const QUANT_CbCr50 = {
    17, 18, 24, 47, 99, 99, 99, 99,
    18, 21, 26, 66, 99, 99, 99, 99,
    24, 26, 56, 99, 99, 99, 99, 99,
    47, 66, 99, 99, 99, 99, 99, 99,
    99, 99, 99, 99, 99, 99, 99, 99,
    99, 99, 99, 99, 99, 99, 99, 99,
    99, 99, 99, 99, 99, 99, 99, 99,
    99, 99, 99, 99, 99, 99, 99, 99
};

Quant const QUANT_Y75 = {
    16 / 2, 11 / 2, 10 / 2, 16 / 2, 24 / 2, 40 / 2, 51 / 2, 61 / 2,
    12 / 2, 12 / 2, 14 / 2, 19 / 2, 26 / 2, 58 / 2, 60 / 2, 55 / 2,
    14 / 2, 13 / 2, 16 / 2, 24 / 2, 40 / 2, 57 / 2, 69 / 2, 56 / 2,
    14 / 2, 17 / 2, 22 / 2, 29 / 2, 51 / 2, 87 / 2, 80 / 2, 62 / 2,
    18 / 2, 22 / 2, 37 / 2, 56 / 2, 68 / 2, 109 / 2, 103 / 2, 77 / 2,
    24 / 2, 35 / 2, 55 / 2, 64 / 2, 81 / 2, 104 / 2, 113 / 2, 92 / 2,
    49 / 2, 64 / 2, 78 / 2, 87 / 2, 103 / 2, 121 / 2, 120 / 2, 101 / 2,
    72 / 2, 92 / 2, 95 / 2, 98 / 2, 112 / 2, 100 / 2, 103 / 2, 99 / 2
};

Quant const QUANT_CbCr75 = {
    17 / 2, 18 / 2, 24 / 2, 47 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2,
    18 / 2, 21 / 2, 26 / 2, 66 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2,
    24 / 2, 26 / 2, 56 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2,
    47 / 2, 66 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2,
    99 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2,
    99 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2,
    99 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2,
    99 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2, 99 / 2
};

Quant const QUANT_Y100 = {
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1
};

Quant const QUANT_CbCr100 = {
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1
};

Array<Quant const *, 3> const QUANT50 = {&QUANT_Y50, &QUANT_CbCr50, &QUANT_CbCr50};
Array<Quant const *, 3> const QUANT75 = {&QUANT_Y75, &QUANT_CbCr75, &QUANT_CbCr75};
Array<Quant const *, 3> const QUANT100 = {&QUANT_Y100, &QUANT_CbCr100, &QUANT_CbCr100};

// MARK: Huffman Tables --------------------------------------------------------

Huff HUFF_DC_Y = {
    {0, 0, 1, 6, 7, 8, 9, 10, 11, 12, 12, 12, 12, 12, 12, 12, 12},
    {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b},
};

Huff HUFF_DC_CbCr = {
    {0, 0, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 12, 12, 12, 12, 12},
    {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b},

};

Huff HUFF_AC_Y = {
    {0, 0, 2, 3, 6, 9, 11, 15, 18, 23, 28, 32, 36, 36, 36, 37, 162},
    {0x01, 0x02, 0x03, 0x00, 0x04, 0x11, 0x05, 0x12,
     0x21, 0x31, 0x41, 0x06, 0x13, 0x51, 0x61, 0x07,
     0x22, 0x71, 0x14, 0x32, 0x81, 0x91, 0xa1, 0x08,
     0x23, 0x42, 0xb1, 0xc1, 0x15, 0x52, 0xd1, 0xf0,
     0x24, 0x33, 0x62, 0x72, 0x82, 0x09, 0x0a, 0x16,
     0x17, 0x18, 0x19, 0x1a, 0x25, 0x26, 0x27, 0x28,
     0x29, 0x2a, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
     0x3a, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49,
     0x4a, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59,
     0x5a, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69,
     0x6a, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79,
     0x7a, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89,
     0x8a, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98,
     0x99, 0x9a, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
     0xa8, 0xa9, 0xaa, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6,
     0xb7, 0xb8, 0xb9, 0xba, 0xc2, 0xc3, 0xc4, 0xc5,
     0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xd2, 0xd3, 0xd4,
     0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xe1, 0xe2,
     0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea,
     0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8,
     0xf9, 0xfa
    },
};

Huff HUFF_AC_CbCr = {
    {0, 0, 2, 3, 5, 9, 13, 16, 20, 27, 32, 36, 40, 40, 41, 43, 162},
    {0x00, 0x01, 0x02, 0x03, 0x11, 0x04, 0x05, 0x21,
     0x31, 0x06, 0x12, 0x41, 0x51, 0x07, 0x61, 0x71,
     0x13, 0x22, 0x32, 0x81, 0x08, 0x14, 0x42, 0x91,
     0xa1, 0xb1, 0xc1, 0x09, 0x23, 0x33, 0x52, 0xf0,
     0x15, 0x62, 0x72, 0xd1, 0x0a, 0x16, 0x24, 0x34,
     0xe1, 0x25, 0xf1, 0x17, 0x18, 0x19, 0x1a, 0x26,
     0x27, 0x28, 0x29, 0x2a, 0x35, 0x36, 0x37, 0x38,
     0x39, 0x3a, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
     0x49, 0x4a, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
     0x59, 0x5a, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,
     0x69, 0x6a, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
     0x79, 0x7a, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
     0x88, 0x89, 0x8a, 0x92, 0x93, 0x94, 0x95, 0x96,
     0x97, 0x98, 0x99, 0x9a, 0xa2, 0xa3, 0xa4, 0xa5,
     0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xb2, 0xb3, 0xb4,
     0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xc2, 0xc3,
     0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xd2,
     0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda,
     0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9,
     0xea, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8,
     0xf9, 0xfa
    },
};

Array<Huff *, 3> const HUFF_DC = {&HUFF_DC_Y, &HUFF_DC_CbCr, &HUFF_DC_CbCr};
Array<Huff *, 3> const HUFF_AC = {&HUFF_AC_Y, &HUFF_AC_CbCr, &HUFF_AC_CbCr};

} // namespace Jpeg
