#pragma once

#include <karm-base/func.h>
#include <karm-base/rc.h>
#include <karm-base/res.h>

namespace Karm::Av {

enum struct AudioChannel : u32 {
    INVALID = (u32)-1,

    FRONT_LEFT = 1 << 0,
    FRONT_RIGHT = 1 << 1,
    FRONT_CENTER = 1 << 2,
    LOW_FREQUENCY = 1 << 3,
    BACK_LEFT = 1 << 4,
    BACK_RIGHT = 1 << 5,
    FRONT_LEFT_OF_CENTER = 1 << 6,
    FRONT_RIGHT_OF_CENTER = 1 << 7,
    BACK_CENTER = 1 << 8,
    SIDE_LEFT = 1 << 9,
    SIDE_RIGHT = 1 << 10,
    TOP_CENTER = 1 << 11,
    TOP_FRONT_LEFT = 1 << 12,
    TOP_FRONT_CENTER = 1 << 13,
    TOP_FRONT_RIGHT = 1 << 14,
    TOP_BACK_LEFT = 1 << 15,
    TOP_BACK_CENTER = 1 << 16,
    TOP_BACK_RIGHT = 1 << 17,
    TOP_SIDE_LEFT = 1 << 18,
    TOP_SIDE_RIGHT = 1 << 19,
    BOTTOM_FRONT_LEFT = 1 << 20,
    BOTTOM_FRONT_CENTER = 1 << 21,
    BOTTOM_FRONT_RIGHT = 1 << 22,
    LOW_FREQUENCY_2 = 1 << 23,
    FRONT_WIDE_LEFT = 1 << 24,
    FRONT_WIDE_RIGHT = 1 << 25,

    MONO = FRONT_LEFT,
    STEREO = FRONT_LEFT | FRONT_RIGHT,
    TWO_POINT_ONE = FRONT_LEFT | FRONT_RIGHT | LOW_FREQUENCY,
    TRI = FRONT_LEFT | FRONT_RIGHT | FRONT_CENTER,
    TRI_BACK = FRONT_LEFT | FRONT_RIGHT | BACK_CENTER,
    THREE_POINT_ONE = FRONT_LEFT | FRONT_RIGHT | FRONT_CENTER | LOW_FREQUENCY,

    TWO_POINT_ZERO_POINT_TWO = FRONT_LEFT | FRONT_RIGHT | TOP_SIDE_LEFT | TOP_SIDE_RIGHT,
    TWO_POINT_ONE_POINT_TWO = TWO_POINT_ZERO_POINT_TWO | LOW_FREQUENCY,
    THREE_POINT_ZERO_POINT_TWO = FRONT_LEFT | FRONT_RIGHT | FRONT_CENTER | TOP_SIDE_LEFT | TOP_SIDE_RIGHT,
    THREE_POINT_ONE_POINT_TWO = THREE_POINT_ZERO_POINT_TWO | LOW_FREQUENCY,
    QUAD = FRONT_LEFT | FRONT_RIGHT | BACK_LEFT | BACK_RIGHT,
    QUAD_SIDE = FRONT_LEFT | FRONT_RIGHT | SIDE_LEFT | SIDE_RIGHT,
    SURROUND = FRONT_LEFT | FRONT_RIGHT | FRONT_CENTER | BACK_CENTER,
    PENTA = QUAD | FRONT_CENTER,
    FIVE_POINT_ONE = FRONT_LEFT | FRONT_RIGHT | FRONT_CENTER | LOW_FREQUENCY | BACK_LEFT | BACK_RIGHT,
    FIVE_POINT1_SIDE = FRONT_LEFT | FRONT_RIGHT | FRONT_CENTER | LOW_FREQUENCY | SIDE_LEFT | SIDE_RIGHT,
    SIX_POINT_ONE = FRONT_LEFT | FRONT_RIGHT | FRONT_CENTER | LOW_FREQUENCY | BACK_LEFT | BACK_RIGHT | BACK_CENTER,
    SEVEN_POINT_ONE = FIVE_POINT_ONE | SIDE_LEFT | SIDE_RIGHT,
    FIVE_POINT_ONE_POINT_TWO = FIVE_POINT_ONE | TOP_SIDE_LEFT | TOP_SIDE_RIGHT,
    FIVE_POINT_ONE_POINT_FOUR = FIVE_POINT_ONE | TOP_FRONT_LEFT | TOP_FRONT_RIGHT | TOP_BACK_LEFT | TOP_BACK_RIGHT,
    SEVEN_POINT_ONE_POINT_TWO = SEVEN_POINT_ONE | TOP_SIDE_LEFT | TOP_SIDE_RIGHT,
    SEVEN_POINT_ONE_POINT_FOUR = SEVEN_POINT_ONE | TOP_FRONT_LEFT | TOP_FRONT_RIGHT | TOP_BACK_LEFT | TOP_BACK_RIGHT,
    NINE_POINT_ONE_POINT_FOUR = SEVEN_POINT_ONE_POINT_FOUR | FRONT_WIDE_LEFT | FRONT_WIDE_RIGHT,
    NINE_POINT_ONE_POINT_SIX = NINE_POINT_ONE_POINT_FOUR | TOP_SIDE_LEFT | TOP_SIDE_RIGHT,
    FRONT_BACK = FRONT_CENTER | BACK_CENTER
};

enum struct AudioFormat {
    UNSPECIFIED = 0,

    PCM_I16,
    PCM_I32,
    PCM_F32,
    PCM_F64,

    INVALID = -1,
};

template <bool MUT>
struct _Audio {
    AudioChannel channels;
    AudioFormat format;
    usize sampleRate;
    usize frameSize;
};

using Audio = _Audio<false>;

using MutAudio = _Audio<true>;

struct AudioStream : Meta::Static {
    struct Configs {
        AudioChannel channels;
        AudioFormat format;
        usize sampleRate;
    };

    static Res<Strong<AudioStream>> create(Configs const &configs);

    static Res<Strong<AudioStream>> create(Configs const &configs, Func<Res<>(MutAudio)> callback);

    virtual ~AudioStream() = default;
};

} // namespace Karm::Av
