# Welcome to [MCA_HUB Project-hacktoberfest24] - Hacktoberfest 2024 🐙🦥🎉

Thank you for checking out this repository! We're excited to have you contribute to Hacktoberfest 2024. Before you get started, please take a moment to read the following rules and guidelines to ensure a smooth contribution process.

## Please check the URL on the right side of the project section and browse through all sections. If you find any issues, create a new issue; otherwise, work on the open issues.

**You must star ⭐ the repository first before contributing**
---
## How to Contribute

1. **Hacktoberfest Dates:**
   - Your Pull/Merge Requests (PR/MRs) must be created between **October 1 and October 31** (in any time zone).
   - Contributions made to this repository must follow Hacktoberfest rules and be submitted to public, unarchived repositories.

2. **Quality Over Quantity:**
   - **No Spam:** Submitting spammy PR/MRs will disqualify you. Keep your contributions meaningful, and avoid low-quality fixes like minor grammar updates unless they add real value.
   - PR/MRs should not be marked with labels containing the word **“spam”** or **“invalid.”** However, contributions labeled with **“hacktoberfest-accepted”** will be considered valid, even if they are not merged immediately.

3. **Repository Participation:**
   - This repository is participating in Hacktoberfest, so feel free to contribute!
   - Ensure that your PR/MR is either merged, has an overall approving review, or receives the **“hacktoberfest-accepted”** label to count toward your Hacktoberfest progress.

4. **Review Period:**
   - Once your PR/MR is created and passing checks, it will go through a **two-day review period**. Make sure your submission remains compliant throughout this time.
   - Even if Hacktoberfest ends on October 31, PR/MRs still in the seven-day review period may continue into November.

5. **Valid Contributions:**
   - Ensure that your contribution adds real value to the project. Bug fixes, new features, and documentation improvements are welcome!

## How to Get Started

1. Fork this repository to your GitHub account.
2. Clone the forked repository to your local machine.
3. Make meaningful changes and improvements.
4. Create a pull request and follow the guidelines listed above.

If you're new to GitHub and Hacktoberfest, you can check out these resources to get started:
- [How to Create a Pull Request](https://docs.github.com/en/github/collaborating-with-issues-and-pull-requests/creating-a-pull-request)
- [Hacktoberfest Official Website](https://hacktoberfest.com)

## Show Your Support

If you find this repository useful, please give it a ⭐! Contributions of all kinds are welcome, and every bit helps improve this project.

---

**Happy coding and happy Hacktoberfest!** 👨‍💻👩‍💻🦥  
Fork the repo and start contributing today! Let's build something amazing together.🚀


<h1 align="center">
    MCA HUB SYSTEM
</h1>

<h3 align="center">
Streamline Department management, class organization, and add students and faculty.<br>
Seamlessly track attendance, assess performance, and provide feedback. <br>
Access records, view marks, and communicate effortlessly.
</h3>
<br>

👉 [LinkedIn](https://www.linkedin.com/in/sheikh-anarul/)

# About

The MCA-HUB is a web-based application built using the MERN (MongoDB, Express.js, React.js, Node.js) stack. It aims to streamline department management, class organization, and facilitate communication between students, teachers, and administrators.

## Features

- **User Roles:** The system supports three user roles: Admin, Teacher, and Student. Each role has specific functionalities and access levels.

- **Admin Dashboard:** Administrators(HOD) can add new students and teachers, create classes and subjects, manage user accounts, and oversee system settings.

- **Attendance Tracking:** Professors can easily take attendance for their classes, mark students as present or absent, and generate attendance reports.

- **Performance Assessment:** Professors can assess students' performance by providing marks and feedback. Students can view their marks and track their progress over time.

- **Data Visualization:** Students can visualize their performance data through interactive charts and tables, helping them understand their academic performance at a glance.

- **Communication:** Users can communicate effortlessly through the system. Professors can send messages to students and vice versa, promoting effective communication and collaboration.

## Login process
### As student
![Screenshot_20241012_153127](https://github.com/user-attachments/assets/f0d76587-e157-49c5-acc3-cc2651fd256b)
### As teacher
![Screenshot_20241012_153414](https://github.com/user-attachments/assets/99c6fb8a-b4de-4d8c-9543-fcd2fc29df63)
### As admin
Firstly you can registered as admin with different college name, unique email and password then you can login
![Screenshot_20241012_153619](https://github.com/user-attachments/assets/8db0079a-fc8f-455c-bdb6-040eefa7edbb)
![Screenshot_20241012_153628](https://github.com/user-attachments/assets/1fc319a2-24b9-47c1-836f-6052e9752480)

## Env folder
### frontend: 
- REACT_APP_BASE_URL=http://localhost:8081
### backed :
- PORT=8081
- MONGO_URL= mongodb+srv://skanarul8093:skanarul8002@projectcluster.4ksacog.mongodb.net/mcaHub?retryWrites=true&w=majority&appName=projectCluster
## Technologies Used
- Frontend: React.js, Material UI, Redux
- Backend: Node.js, Express.js
- Database: MongoDB Atlas
  <br>
# Deployment

- Render - server side
- Netlify/Vercel - client side


T     H     A     N     K         Y     O     U         T     O         A     L     L
|     |    / \    |\   |/        \ /   / \   | |        |    / \       / \    |     |
|     |   /---\   | \  |          |   |   |  | |        |   |   |     /---\   |     |
|     |  /     \  |  \ |         / \   \ /    |        / \   \ /     /     \  |     |

