---
layout: main/post-blog.html
title: Configure Comment System
description: A simple, fully customizable comment system using Supabase as the database. Easily manage, display, and store comments with complete control and flexibility
keyword: comment system, apoxicam, supabase
cover: /asset/blog/comment.webp
date: 2024-12-03
tags:
 - Tutorial
---


This starter includes a built-in comment system, thanks to my friend [Mustofa-ID](https://mustofa.id) for helping me set it up. The comment system uses Supabase as the database.

> Here we go

### Supabase

1. **Create a Supabase Account**  
   First, create an account on **[Supabase](https://supabase.com)**.

2. **Create a New Project**  
   Once logged in, create a new project with the name of your website.

3. **Create a Table for Comments**  
   In the Supabase dashboard, go to **`SQL Editor`** and run the following query to create the `comments` table:

   ```sql
   create table comments (
       id bigint generated by default as identity not null,
       created_at timestamp with time zone not null default now(),
       name character varying not null,
       email character varying null,
       description text null,
       slug character varying not null,
       hidden boolean null,
       constraint comments_pkey primary key (id)
   );

   alter table comments add column reply_to bigint references comments (id);

   create table verified_users (email varchar unique not null);

   create view comments_view as 
   select
      c.id,
      c.slug,
      c.name,
      c.description,
      c.reply_to,
      c.created_at,
      v.email is not null verified
   from comments c
   left join verified_users v on v.email = c.email
   where (c.hidden is null or c.hidden = false);

   ```

4. **Run the Query**  
   Copy the query into the editor and click the **Run** button. This will create the `comments` table.

5. **Create Policies**  
   Set up policies to allow users to insert and view comments. Run the following queries in the **`SQL Editor`**:

   ```sql
   create policy "Enable insert with email check"
   on comments as permissive for insert to anon
   with check (email not in (select email from verified_users));

   create policy "Allow select for all users"
   on comments for select
   using (hidden = false);

   alter policy "Allow select for authenticated users only"
   on verified_users
   to authenticated using (true);
   ```

### Configure the Comment System

1. **Get Supabase Project URL and API Key**  
   In your Supabase dashboard, go to **`Project Settings`** > **`API`**.  
   Here, you will find the **Project URL** and **API Key** (`anon public`).

2. **Create an `.env` File**  
   Create a `.env` file in your deployment provider (such as GitHub Pages, Netlify, etc.), and add the following variables:

   ```env
   SUPABASE_URL=https://your-project-url.supabase.co
   SUPABASE_KEY=your-anon-public-api-key
   ```

3. **Local Development**  
   You can also create a `.env` file for local development, but avoid hard-coding the values directly into your code.

If you want to modify the comment layout, simply check the files `_include/js/comment.js` and `_include/post/comment.html`.

Please note that you need to manually update the **hidden column value** for each new comment in Supabase. A value of false means the comment will be displayed on your website.

I haven’t figured out how to set up email notifications yet, but I’ll work on it and write a post about it once I do.

> That's it! Your comment system is now configured. Have any question?
