# hledger shell completions

This code generates shell completion scripts for hledger's command line interface.
Context-sensitive completions are usually triggered by pressing the tab key once or twice after typing the command `hledger ` (or `hledger-ui` or `hledger-web`).
Currently only Bash is supported, but Zsh or Fish could be added.

[![asciicast](https://asciinema.org/a/227935.svg)](https://asciinema.org/a/227935)

To use hledger's bash shell completions, these must be installed on your system:
- bash
- the [bash-completion](https://salsa.debian.org/debian/bash-completion) package
- hledger's bash completion script
- hledger, hledger-ui, and/or hledger-web

For user setup and usage instructions, please see [Install > Shell completions](https://hledger.org/install.html#shell-completions).

To test the bash completions, at a bash shell prompt, type
`hledger<SPACE><TAB><TAB>` (should list all hledger commands)
or `hledger reg acct:<TAB><TAB>` (should list your top-level account names).

The bash completion script can handle:

- hledger's command argument
- general flags
- command-specific flags, after the command argument
- flag values, for flags that have standard values
- query prefixes
- account names from the journal, after an account name prefix
- appropriate data from the journal, after these query prefixes: `acct:`, `code:`, `cur:`, `desc:`, `note:`, `payee:`, `real:`, `status:`, `tag:`
- amount comparison operators, after `amt:`.

## Generating hledger shell completions

In the main hledger repo,
first build and install an up-to-date version of hledger in PATH,
then run make to detect its commands and options and generate the `hledger-completion.bash` script.
GNU make and GNU m4 are required.

    stack install hledger
    cd hledger/shell-completion
    make

This is normally done at release time.
The makefile runs `hledger`, `hledger -h`, and `hledger CMD -h` for each command,
to detect (built-in) command names, flag names and flag values,
and it combines these with a stub script to form the final completion script.
You can add `-jNUMPROCS` to make it run faster.

Data from the journal (account names, payee names etc.) is not gathered here;
the script detects those dynamically at completion time.

## Installing the generated shell completions

(If you want a released version of the completion script, use the Install page link above instead.)

To install the dev completion script, also regenerating it if needed:

    make install

This will copy `hledger-completion.bash` to `$XDG_DATA_HOME/bash-completion/completions/hledger`.
(See bash-completion's docs for other places you can install the script if needed.)
bash will use it when completing command lines beginning with "hledger" or "hledger-ui" or "hledger-web".

You can also just source the script it in your shell startup; this will load completions eagerly, adding a delay to your shell start up time.
Or you can source it in your current bash session for testing.

## Packaging hledger shell completions

It's great when hledger packagers can make shell completions just work for users.

Currently there is one completion script: `hledger-completion.bash`.
It is included in the hledger package's tarball on Hackage.

For hledger version 1.40, the up-to-date script is at 
https://github.com/simonmichael/hledger/blob/39dfe5702e1b401f1883d814907d242958eec9c1/hledger/shell-completion/hledger-completion.bash.

From releases after 1.40, it will be included in the bindists provided in Github releases,
and available at urls like 
https://github.com/simonmichael/hledger/blob/1.40/hledger/shell-completion/hledger-completion.bash

After it has been loaded, this script will provide completions for hledger, hledger-ui and hledger-web.
Note if it is installed only as `hledger`, bash-completion will not load it until the user types `hledger<SPACE><TAB>`.
Consider also symbolic-linking it as `hledger-ui` and `hledger-web`, so that `hledger-ui<SPACE><TAB>` and `hledger-web<SPACE><TAB>` will also load it.

Here is a place to track the status of shell completions in hledger packages. As of 1.40:

- Homebrew: includes slightly stale completions, installed as `hledger` only
- Arch Linux AUR: packaging in progress
- Others: unknown

## Completion scripts for other shells

You're welcome to add completion scripts for other shells. It should not be too
hard! All available hledger options and commands are already there (generated by
the Makefile).

The generated text files with options and commands are: `commands.txt`,
`generic-options.txt`, and `options-*.txt` where `*` is the subcommand.

Instructions to add support for another shell:

1. Create e.g. `hledger-completion.fish.m4` as a template file.

2. Add a Make rule to transform it to `hledger-completion.fish`.

3. Use m4 commands to include hledger options and commands into your script
   template. See `hledger-completion.bash.m4` as a reference.

4. Use `make` and then `make hledger-completion.fish` to create and test the
   completion script.

5. Finally, if everything is working, also add the generated artifact
   `hledger-completion.fish` to the repo so that people can use it directly.
