# REGRESSIONS

<div class=pagetoc>

<!-- toc -->
</div>

Short url for this page: [hledger.org/regressions](https://hledger.org/regressions)

A regression is "something that used to work, that broke", or "an unintended not-good change"
in a released version of hledger.

We don't like regressions. We want to detect them quickly, repair them quickly, and reduce their frequency.
You can help by finding them, or fixing them! 

## Regression finder bounty

For new regression reports submitted to the bug tracker since 2024-01-01 (affecting any past release), we currently offer a $50 bounty
([original announcement](https://github.com/simonmichael/hledger/issues/1570)).
If you don't want the bounty, you can absolutely choose to re-donate it back to the project treasury.
But consider accepting it - it's good for the project!
Just do respond within 7 days after the bounty is confirmed, otherwise it will become an automatic project donation.

## Regression fixer bounty

For regression issues fixed, we currently offer a separate $50 bounty.
If you find and fix the regression, you get both bounties. 
(If you caused the regression, we appreciate you fixing it but you don't get the bounties - sorry!)

## How to claim the bounty

1. Discover a new regression, which you did not cause, and report it in the [hledger bug tracker](http://bugs.hledger.org).
   And/or, fix an open issue which has the `regression` label.
2. Wait for confirmation from the issue manager ([SM](https://joyful.com)).
3. Send an expense reimbursement request to [hledger's open collective](https://opencollective.com/hledger).
   Note this might reveal your real name.
   Here's the procedure:
   - at hledger's open collective, click [Submit Expense](https://opencollective.com/hledger/expenses/new).  (If you are logged in, this will be under the ACTIONS menu.)
   - choose **Invoice**; choose a Payout method; click Next
   - Expense title: **Regression (finder / fixer / finder & fixer) bounty for #NNNN**
   - Description: **(Found / Fixed) ISSUEURL, WORKDATE(S)**
   - Date: **today's date**
   - Amount: **USD 50** (or **100** if you found and fixed).
     Or convert to another currency with today's rate (and mention that rate in Description).
   - Next, Submit Expense
5. Wait for the finance manager (SM) to get the email notification and approve it. This should not take more than a day or two.
   (For fastest response, mention on the issue page or in chat that you've submitted.)
6. Wait for Open Collective to pay it. This should happen within a week (payouts happen twice a week).

## Regressions reported

- [Issue tracker: all regression reports](https://bugs.hledger.org/regressions)
- [Open Collective: expense requests](https://opencollective.com/hledger/expenses)  <!-- not ?amount=50-100 because other currencies -->
- [Open Collective: payments](https://opencollective.com/hledger/transactions?kind=EXPENSE)

[#1439]: https://github.com/simonmichael/hledger/issues/1439
[#1468]: https://github.com/simonmichael/hledger/issues/1468
[#1508]: https://github.com/simonmichael/hledger/issues/1508
[#1523]: https://github.com/simonmichael/hledger/issues/1523
[#1526]: https://github.com/simonmichael/hledger/issues/1526
[#1527]: https://github.com/simonmichael/hledger/issues/1527
[#1566]: https://github.com/simonmichael/hledger/issues/1566
[#1568]: https://github.com/simonmichael/hledger/issues/1568
[#1597]: https://github.com/simonmichael/hledger/issues/1597
[#1607]: https://github.com/simonmichael/hledger/issues/1607
[#1625]: https://github.com/simonmichael/hledger/issues/1625
[#1638]: https://github.com/simonmichael/hledger/issues/1638
[#1642]: https://github.com/simonmichael/hledger/issues/1642
[#1656]: https://github.com/simonmichael/hledger/issues/1656
[#1688]: https://github.com/simonmichael/hledger/issues/1688
[#1698]: https://github.com/simonmichael/hledger/issues/1698
[#1736]: https://github.com/simonmichael/hledger/issues/1736
[#1745]: https://github.com/simonmichael/hledger/issues/1745
[#1782]: https://github.com/simonmichael/hledger/issues/1782
[#1800]: https://github.com/simonmichael/hledger/issues/1800
[#1851]: https://github.com/simonmichael/hledger/issues/1851
[#1932]: https://github.com/simonmichael/hledger/issues/1932
[#1933]: https://github.com/simonmichael/hledger/issues/1933
[#2012]: https://github.com/simonmichael/hledger/issues/2012
[#2018]: https://github.com/simonmichael/hledger/issues/2018
[#2020]: https://github.com/simonmichael/hledger/issues/2020
[#2023]: https://github.com/simonmichael/hledger/issues/2023
[#2032]: https://github.com/simonmichael/hledger/issues/2032
[#2034]: https://github.com/simonmichael/hledger/issues/2034
[#2045]: https://github.com/simonmichael/hledger/issues/2045
[#2071]: https://github.com/simonmichael/hledger/issues/2071
[#2072]: https://github.com/simonmichael/hledger/issues/2072
[#2091]: https://github.com/simonmichael/hledger/issues/2091
[#2115]: https://github.com/simonmichael/hledger/issues/2115
[#2125]: https://github.com/simonmichael/hledger/issues/2125
[#2127]: https://github.com/simonmichael/hledger/issues/2127
[#2130]: https://github.com/simonmichael/hledger/issues/2130
[#2134]: https://github.com/simonmichael/hledger/issues/2134
[#2137]: https://github.com/simonmichael/hledger/issues/2137
[#2150]: https://github.com/simonmichael/hledger/issues/2150
[#2153]: https://github.com/simonmichael/hledger/issues/2153
[#2156]: https://github.com/simonmichael/hledger/issues/2156
[#2196]: https://github.com/simonmichael/hledger/issues/2196
[#2224]: https://github.com/simonmichael/hledger/issues/2224
[#2225]: https://github.com/simonmichael/hledger/issues/2225
[#2227]: https://github.com/simonmichael/hledger/issues/2227
[#2254]: https://github.com/simonmichael/hledger/issues/2254
[#2284]: https://github.com/simonmichael/hledger/issues/2284
[#2302]: https://github.com/simonmichael/hledger/issues/2302

<!-- 
This table keeps evolving. Bold things are unresolved. The flow is this:
     (unclaimed)                (submitted)               (paid)
**NAME FINDORFIXDATE** -> **[NAME](EXPENSEPAGE)** -> [NAME](EXPENSEPAGE)
                                                  -> NAME donated
-->

| hledger&nbsp;version, <br>regressions&nbsp;found | Finder&nbsp;bounties <br>(since 2021-06-14)              | Fixer&nbsp;bounties <br>(since 2024-01-01) <!-- some missing -->
|--------------------------|----------------------------------------------------------------------------------|-----------------------------------------------------------------------------------
| **1.19** 2020-09-01      | ---                                                                              | ---
| [#1568]                  | jolmg           N/A                                                              | N/A
| [#1688]                  | Simon Michael   N/A                                                              | N/A
| [#1698]                  | [David Lowe](https://opencollective.com/hledger/expenses/50380)                  | N/A
| [#1745]                  | [Arne Schlüter](https://opencollective.com/hledger/expenses/54446)               | N/A
| [#1800]                  | [Chuck Holmes](https://opencollective.com/hledger/expenses/61802)                | N/A
| **1.20** 2020-12-05      | ---                                                                              | ---
| [#1439]                  | apauley         N/A                                                              | N/A
| [#1468]                  | Simon Michael   N/A                                                              | N/A
| **1.20.3** 2021-01-14    | ---                                                                              | ---
| [#1566]                  | benwebber       N/A                                                              | N/A
| **1.21** 2021-03-10      | ---                                                                              | ---
| [#1508]                  | edlanglois      N/A                                                              | N/A
| [#1523]                  | Simon Michael   N/A                                                              | N/A
| [#1526]                  | lestephane      N/A                                                              | N/A
| [#1527]                  | lestephane      N/A                                                              | N/A
| [#1656]                  | [Stephen Morgan](https://opencollective.com/hledger/expenses/48246)              | N/A
| [#2284]                  | [lakshayg](https://opencollective.com/hledger/expenses/227577)                   | GLaknovik donated
| [#2302]                  | [lowercasename](https://opencollective.com/hledger/expenses/232210)              | 
| **1.22** 2021-07-03      | ---                                                                              | ---
| [#1597]                  | [Simon Michael](https://opencollective.com/hledger/expenses/44939)               | N/A
| [#1607]                  | [Simon Michael](https://opencollective.com/hledger/expenses/45547)               | N/A
| [#1625]                  | [Julian Klode](https://opencollective.com/hledger/expenses/46431)                | N/A
| [#1736]                  | [Romain Gehrig](https://opencollective.com/hledger/expenses/55510)               | N/A
| [#1851]                  | [Eric Langlois](https://opencollective.com/hledger/expenses/72187)               | N/A
| **1.22.1** 2021-08-02    | ---                                                                              | ---
| [#1638]                  | [Yann Büchau](https://opencollective.com/hledger/expenses/46918)                 | N/A
| [#1642]                  | Simon Michael   N/A                                                              | N/A
| **1.23** 2021-09-21      | ---                                                                              | ---
| [#1933]                  | [Simon Michael](https://opencollective.com/hledger/expenses/95068)               | N/A
| [#2071]                  | [William Pierce](https://opencollective.com/hledger/expenses/195768)             | [Simon Michael](https://opencollective.com/hledger/expenses/223927)
| **1.24** 2021-12-01      | ---                                                                              | ---
| [#1782]                  | Simon Michael   N/A                                                              | N/A
| **1.25** 2022-03-04      | ---                                                                              | ---
| [#2032]                  | [Simon Michael](https://opencollective.com/hledger/expenses/137410)              | N/A
| [#2196]                  | [Pranesh Prakash](https://opencollective.com/hledger/expenses/220683)            | [Simon Michael](https://opencollective.com/hledger/expenses/223926), <br>Bas van Dijk [#2224] donated
| **1.26** 2022-06-04      | ---                                                                              | ---
| **1.27** 2022-09-01      | ---                                                                              | ---
| [#1932]                  | [Andras Fabian](https://opencollective.com/hledger/expenses/95112)               | N/A
| [#2018]                  | [Allan Odgaard](https://opencollective.com/hledger/expenses/130591)              | N/A
| **1.28** 2022-12-01      | ---                                                                              | ---
| **1.29** 2023-03-11      | ---                                                                              | ---
| [#2012]                  | Simon Michael   N/A                                                              | N/A
| [#2020]                  | [Pablo Mora](https://opencollective.com/hledger/expenses/131350)                 | N/A
| [#2023]                  | [Simon Michael](https://opencollective.com/hledger/expenses/132635)              | N/A
| [#2034]                  | Simon Michael   N/A                                                              | N/A
| [#2045]                  | [Pranesh Prakash](https://opencollective.com/hledger/expenses/150171)            | N/A
| [#2153]                  | markokocic donated                                                               | N/A
| **1.30** 2023-06-01      | ---                                                                              | ---
| [#2072]                  | [Simon Michael](https://opencollective.com/hledger/expenses/223926)  , <br>usaAmch [#2137] donated, <br>[ipvych](https://opencollective.com/hledger/expenses/221597) [#2150] | [Simon Michael](https://opencollective.com/hledger/expenses/223926)
| **1.31** 2023-09-03      | ---                                                                              | ---
| [#2091]                  | [Petr Slansky](https://opencollective.com/hledger/expenses/166632)               | N/A
| [#2115]                  | usaAmch donated                                                                  | N/A
| **1.32** 2023-12-01      | ---                                                                              | ---
| [#2125]                  | Simon Michael   N/A                                                              | N/A
| [#2127]                  | [Rajeev N](https://opencollective.com/hledger/expenses/177761)                   | N/A
| [#2130]                  | Simon Michael   N/A                                                              | N/A
| [#2134]                  | pepe_pecas donated                                                               | N/A
| [#2156]                  | ishmaelavila 2024-01-18 donated*                                                 | [Simon Michael](https://opencollective.com/hledger/expenses/223926)
| [#2254]                  | akanshaG42 donated                                                               | [Simon Michael](https://opencollective.com/hledger/expenses/223926)
| **1.33** 2024-04-18      | ---                                                                              | ---
| [#2227]                  | [Henning Thielemann](https://opencollective.com/hledger/expenses/224252)         | [Henning Thielemann](https://opencollective.com/hledger/expenses/224252)
| **1.34** 2024-06-01      | ---                                                                              | ---
| **1.40** 2024-09-09      | ---                                                                              | ---
| [#2225]                  | Bas van Dijk donated                                                             | [Henning Thielemann](https://opencollective.com/hledger/expenses/224252)
