#ifdef SIST_DEBUG
#define STRICT " STRICT"
#else
#define STRICT ""
#endif

const char *FtsDatabaseSchema =
        "CREATE TABLE IF NOT EXISTS document_index ("
        "   id INTEGER PRIMARY KEY,"
        "   index_id INTEGER NOT NULL,"
        "   size INTEGER NOT NULL,"
        "   name TEXT NOT NULL,"
        "   path TEXT NOT NULL,"
        "   mtime INTEGER NOT NULL,"
        "   mime TEXT,"
        "   thumbnail_count INTEGER NOT NULL,"
        "   json_data TEXT NOT NULL"
        ")"STRICT";"
        ""
        "CREATE TABLE IF NOT EXISTS stats ("
        "   mtime_min INTEGER,"
        "   mtime_max INTEGER"
        ")"STRICT";"
        ""
        "CREATE TABLE IF NOT EXISTS path_index ("
        "   path TEXT,"
        "   index_id INTEGER,"
        "   count INTEGER NOT NULL,"
        "   depth INTEGER NOT NULL,"
        "   PRIMARY KEY (path, index_id)"
        ")"STRICT";"
        ""
        "CREATE TABLE IF NOT EXISTS mime_index ("
        "   index_id INTEGER,"
        "   mime TEXT,"
        "   count INTEGER,"
        "   PRIMARY KEY(index_id, mime)"
        ")"STRICT";"
        ""
        "CREATE TABLE IF NOT EXISTS tag ("
        "   id INTEGER NOT NULL,"
        "   index_id INTEGER NOT NULL,"
        "   tag TEXT NOT NULL,"
        "   PRIMARY KEY (id, tag)"
        ")"STRICT";"
        "CREATE INDEX IF NOT EXISTS tag_tag_idx ON tag(tag);"
        ""
        "CREATE TABLE IF NOT EXISTS embedding ("
        "   id INTEGER REFERENCES document_index(id),"
        "   model_id INTEGER NOT NULL REFERENCES model(id),"
        "   start INTEGER NOT NULL,"
        "   end INTEGER,"
        "   embedding BLOB NOT NULL,"
        "   PRIMARY KEY (id, model_id, start)"
        ")"STRICT";"
        ""
        "CREATE TABLE IF NOT EXISTS model ("
        "   id INTEGER PRIMARY KEY CHECK (id > 0 AND id < 1000),"
        "   size INTEGER NOT NULL"
        ")"STRICT";"
        ""
        "CREATE TRIGGER IF NOT EXISTS tag_write_trigger"
        "    AFTER INSERT ON tag"
        " BEGIN"
        "  UPDATE document_index"
        "  SET json_data = json_set(json_data, '$.tag', (SELECT json_group_array(tag) FROM tag WHERE id = NEW.id))"
        "  WHERE id = NEW.id;"
        " END;"
        ""
        "CREATE TRIGGER IF NOT EXISTS tag_delete_trigger"
        " AFTER DELETE ON tag"
        " BEGIN"
        "  UPDATE document_index"
        "  SET json_data = json_set(json_data, '$.tag', (SELECT json_group_array(tag) FROM tag WHERE id = OLD.id))"
        "  WHERE id = OLD.id;"
        " END;"
        ""
        "CREATE VIEW IF NOT EXISTS document_view (id, name, content, title, path)"
        " AS"
        " SELECT id,"
        "  json_data->>'name',"
        "  json_data->>'content',"
        "  json_data->>'title',"
        "  json_data->>'path'"
        " FROM document_index;"
        ""
        "CREATE VIRTUAL TABLE IF NOT EXISTS search USING fts5 ("
        "   name,"
        "   content,"
        "   title,"
        "   path,"
        "   content='document_view',"
        "   content_rowid='id'"
        ");"
        // name^8, content^3, title^8, path^5
        "INSERT INTO search(search, rank) VALUES('rank', 'bm25(8, 3, 8, 5)');"
        "";

const char *IpcDatabaseSchema =
        "CREATE TABLE parse_job ("
        "   id INTEGER PRIMARY KEY,"
        "   filepath TEXT NOT NULL,"
        "   mtime INTEGER NOT NULL,"
        "   st_size INTEGER NOT NULL"
        ")"STRICT";"
        ""
        "CREATE TABLE index_job ("
        "   id INTEGER PRIMARY KEY,"
        "   sid TEXT NOT NULL,"
        "   type INTEGER NOT NULL,"
        "   line TEXT"
        ")"STRICT";";

const char *IndexDatabaseSchema =
        "CREATE TABLE thumbnail ("
        "   id INTEGER REFERENCES document(id),"
        "   num INTEGER NOT NULL,"
        "   data BLOB NOT NULL,"
        "   PRIMARY KEY(id, num)"
        ") WITHOUT ROWID;"
        ""
        "CREATE TABLE version ("
        "   id INTEGER PRIMARY KEY AUTOINCREMENT,"
        "   date TEXT NOT NULL DEFAULT (CURRENT_TIMESTAMP)"
        ")"STRICT";"
        ""
        "CREATE TABLE mime("
        "   id INTEGER PRIMARY KEY,"
        "   name TEXT"
        ")"STRICT";"
        "CREATE UNIQUE INDEX mime_name_idx ON mime(name);"
        ""
        "CREATE TABLE document ("
        "   id INTEGER PRIMARY KEY,"
        "   parent INTEGER REFERENCES document(id),"
        "   mime INTEGER REFERENCES mime(id),"
        "   path TEXT NOT NULL,"
        "   version INTEGER NOT NULL REFERENCES version(id),"
        "   mtime INTEGER NOT NULL,"
        "   size INTEGER NOT NULL,"
        "   thumbnail_count INTEGER NOT NULL,"
        "   json_data TEXT CHECK ( json_data IS NULL OR json_valid(json_data) )"
        ")"STRICT";"
        "CREATE UNIQUE INDEX document_path_idx ON document(path);"
        "CREATE TABLE marked ("
        "   id INTEGER PRIMARY KEY,"
        "   marked INTEGER NOT NULL,"
        "   mtime INTEGER NOT NULL"
        ")"STRICT";"
        ""
        "CREATE INDEX marked_marked ON marked(marked);"
        ""
        "CREATE TABLE delete_list ("
        "   id INTEGER PRIMARY KEY"
        ")"STRICT";"
        ""
        "CREATE TABLE tag ("
        "   id INTEGER NOT NULL REFERENCES document(id),"
        "   tag TEXT NOT NULL,"
        "   PRIMARY KEY (id, tag)"
        ")"STRICT";"
        ""
        "CREATE TABLE descriptor ("
        "   id INTEGER PRIMARY KEY,"
        "   version_major INTEGER NOT NULL,"
        "   version_minor INTEGER NOT NULL,"
        "   version_patch INTEGER NOT NULL,"
        "   root TEXT NOT NULL,"
        "   name TEXT NOT NULL,"
        "   rewrite_url TEXT,"
        "   timestamp INTEGER NOT NULL"
        ")"STRICT";"
        ""
        "CREATE TABLE stats_treemap ("
        "   path TEXT NOT NULL,"
        "   size INTEGER NOT NULL"
        ")"STRICT";"
        ""
        "CREATE TABLE stats_size_agg ("
        "   bucket INTEGER NOT NULL,"
        "   count INTEGER NOT NULL"
        ")"STRICT";"
        ""
        "CREATE TABLE stats_date_agg ("
        "   bucket INTEGER NOT NULL,"
        "   count INTEGER NOT NULL"
        ")"STRICT";"
        ""
        "CREATE TABLE stats_mime_agg ("
        "   mime TEXT NOT NULL,"
        "   size INTEGER NOT NULL,"
        "   count INTEGER NOT NULL"
        ")"STRICT";"
        ""
        "CREATE TABLE embedding ("
        "   id INTEGER REFERENCES document(id),"
        "   model_id INTEGER NOT NULL references model(id),"
        "   start INTEGER NOT NULL,"
        "   end INTEGER,"
        "   embedding BLOB NOT NULL,"
        "   PRIMARY KEY (id, model_id, start)"
        ")"STRICT";"
        ""
        "CREATE TABLE model ("
        "   id INTEGER PRIMARY KEY CHECK (id > 0 AND id < 1000),"
        "   name TEXT NOT NULL UNIQUE CHECK ( length(name) < 16 ),"
        "   url TEXT,"
        "   path TEXT NOT NULL UNIQUE,"
        "   size INTEGER NOT NULL,"
        "   type TEXT NOT NULL CHECK ( type IN ('flat', 'nested') )"
        ")"STRICT";";

