export const TranslationKeys = [
  'expand',
  'related-project.title',
  'related-project.description',
  'related-project.link',
  'author-page',
  'related-posts.title',
  'blog.title',
  'blog.load-more',
  'blog.no-results',
  'project.published-in',
  'recognitions',
  'services',
  'deliverables',
  'links',
  'project.team',
  'handbook',
  'on-this-page',
  'close',
  'filters',
  'clear-all',
  'view-project',
  'member.projects.title',
  'member.projects.subtitle',
  'member.posts.title',
  'member.posts.subtitle',
  'member.about',
  'prefooter.title.line1',
  'prefooter.title.line2',
  'prefooter.description',
  'form.subject',
  'contact.type.quote.title',
  'contact.type.quote.description',
  'contact.type.position.title',
  'contact.type.position.description',
  'contact.type.contact.title',
  'contact.type.contact.description',
  'contact.position.default',
  'contact.feedback.success.title',
  'contact.feedback.success.description',
  'contact.feedback.error.notion.title',
  'contact.feedback.error.notion.description',
  'contact.feedback.error.email.title',
  'contact.feedback.error.email.description',
  'contact.type.title',
  'contact.type.description',
  'contact.label.name',
  'contact.label.email',
  'contact.label.budget',
  'contact.label.position',
  'contact.label.message',
  'contact.footer.title',
  'contact.footer.email',
  'contact.submit',
  'blog.pre-footer.title',
  'blog.pre-footer.cta',
  'contact.feedback.error.title',
  'contact.feedback.error.description',
  'contact.label.attachment.quote',
  'contact.label.attachment.position',
  'seo.title',
  'seo.description',
  'projects.title',
  'team.former',
  'careers.footer.title',
  'careers.footer.email',
  'careers.footer.description',
  'tictactoe.play',
  'tictactoe.restart',
  'tictactoe.close',
  'tictactoe.title',
  'tictactoe.subtitle',
  'tictactoe.win',
  'tictactoe.lose',
  'tictactoe.draw',
  'tictactoe.your-turn',
  'tictactoe.wait',
  'handbook.draft.title',
  'handbook.draft.description',
  'draw-segg.title',
  'draw-segg.description',
  'draw-segg.cta',
  'draw-segg.clipboard.feedback',
  'reel.play',
  'file.upload.error.title',
  'file.upload.error.description',
  'a11y.gallery-left',
  'a11y.gallery-right',
  'a11y.physics-add',
  'a11y.see-post',
  'a11y.see-career',
  'blog.tag-meta-description',
  'proposals.password-form.login',
  'proposals.password-form.title',
  'proposals.password-form.subtitle',
  'proposals.password-form.field.label',
  'proposals.password-form.error',
  'proposals.nav.action.long',
  'proposals.nav.action.short',
  'proposals.nav.title',
  'blog.pre-footer.related',
  'proposals.hero.client',
  'proposals.hero.createdby',
  'proposals.hero.date',
  'proposals.nav.versions',
  'proposals.scope.deliverable',
  'proposals.scope.service',
  'proposals.scope.multiple-features',
  'proposals.show',
  'proposals.hide',
  'proposals.team.department',
  'proposals.team.team-member',
  'proposals.team.role',
  'proposals.team.rate',
  'proposals.included',
  'proposals.scope.features',
  'proposals.estimates.area',
  'proposals.estimates.phases',
  'proposals.estimates.team',
  'proposals.estimates.estimated-cost.short',
  'proposals.estimates.duration',
  'proposals.estimates.estimated-cost.long',
  'proposals.estimates.phase',
  'proposals.estimates.people',
  'proposals.estimates.person',
  'proposals.estimates.subtotal',
  'proposals.estimates.discount',
  'proposals.estimates.grand-total',
  'proposals.reply.description',
  'proposals.testimonials',
  'proposals.testimonials.description',
  'proposals.clients.description',
  'proposals.awards',
  'proposals.awards.description',
  'proposals.projects',
  'contact.range',
  'careers.footer.no.positions',
  'careers.footer.no.positions.description',
  'recognitions.award',
  'proposals.accept.title',
  'proposals.accept.subtitle',
  'proposals.accept.secondary-title',
  'proposals.accept.secondary-subtitle',
  'proposals.accept.button',
  'proposals.accept.contact.title',
  'proposals.accept.contact.subtitle',
  'proposals.accept.contact.button',
  'proposals.accept.error',
  'proposals.month',
  'proposals.months',
  'proposals.deliverables.manpower',
  'proposals.deliverables.total',
  'proposals.timeline.month',
  'proposals.timeline.week',
  'proposals.days-per-month',
  'proposals.per-month',
  'proposals.days',
  'proposals.package.reply.title',
  'proposals.package.reply.people',
  'proposals.package.reply.manpower',
  'proposals.package.reply.total-months',
  'proposals.package.reply.monthly-cost',
  'proposals.package.reply.discount',
  'proposals.package.reply.total',
  'proposals.package.technical-resources.title',
  'proposals.package.fulltime',
  'proposals.package.project-manager.title',
  'proposals.package.quality-assurance.title',
  'estimation.man.power',
  'estimation.total',
  'proposals.package.reply.manpower.title',
  'proposals.package.reply.manpower.desc',
  'handbook.last.updated',
  'handbook.navigation.website',
  'estimate.clear',
  'blog.x_minutes',
  'blog.est-reading-time',
  'blog.x_min_read'
] as const;

export type TranslationKey = (typeof TranslationKeys)[number];
export function isTranslationKey(key: string | TranslationKey): key is TranslationKey {
  return TranslationKeys.includes(key as TranslationKey);
}
