/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import weka.classifiers.bayes.net.GUI;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.core.Copyright;
import weka.core.Instances;
import weka.core.Memory;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.SystemInfo;
import weka.core.Tag;
import weka.core.Utils;
import weka.core.Version;
import weka.core.logging.Logger;
import weka.gui.BrowserHelper;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.LogWindow;
import weka.gui.LookAndFeel;
import weka.gui.MainMenuExtension;
import weka.gui.MemoryUsagePanel;
import weka.gui.Messages;
import weka.gui.SimpleCLIPanel;
import weka.gui.SplashWindow;
import weka.gui.arffviewer.ArffViewerMainPanel;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.StartUpListener;
import weka.gui.boundaryvisualizer.BoundaryVisualizer;
import weka.gui.experiment.Experimenter;
import weka.gui.explorer.Explorer;
import weka.gui.graphvisualizer.GraphVisualizer;
import weka.gui.sql.SqlViewer;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.ThresholdVisualizePanel;
import weka.gui.visualize.VisualizePanel;

public class Main
extends JFrame
implements OptionHandler {
    private static final long serialVersionUID = 1453813254824253849L;
    public static final int GUI_MDI = 0;
    public static final int GUI_SDI = 1;
    public static final Tag[] TAGS_GUI;
    protected Main m_Self;
    protected int m_GUIType = 0;
    protected static Main m_MainCommandline;
    protected static Main m_MainSingleton;
    protected static Vector m_StartupListeners;
    protected static Memory m_Memory;
    protected HashSet<Container> m_ChildFrames = new HashSet();
    protected static LogWindow m_LogWindow;
    protected JFileChooser m_FileChooserTreeVisualizer = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserGraphVisualizer = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserPlot = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserROC = new JFileChooser(new File(System.getProperty("user.dir")));
    private JMenu jMenuHelp;
    private JMenu jMenuVisualization;
    private JMenu jMenuTools;
    private JDesktopPane jDesktopPane;
    private JMenu jMenuApplications;
    private JMenuItem jMenuItemHelpSystemInfo;
    private JMenuItem jMenuItemHelpAbout;
    private JMenuItem jMenuItemHelpHomepage;
    private JMenuItem jMenuItemHelpWekaWiki;
    private JMenuItem jMenuItemHelpSourceforge;
    private JMenuItem jMenuItemVisualizationBoundaryVisualizer;
    private JMenuItem jMenuItemVisualizationGraphVisualizer;
    private JMenuItem jMenuItemVisualizationTreeVisualizer;
    private JMenuItem jMenuItemVisualizationROC;
    private JMenuItem jMenuItemVisualizationPlot;
    private JMenuItem jMenuItemToolsSqlViewer;
    private JMenuItem jMenuItemToolsArffViewer;
    private JMenuItem jMenuItemApplicationsSimpleCLI;
    private JMenuItem jMenuItemApplicationsKnowledgeFlow;
    private JMenuItem jMenuItemApplicationsExperimenter;
    private JMenuItem jMenuItemApplicationsExplorer;
    private JMenuItem jMenuItemProgramExit;
    private JMenuItem jMenuItemProgramLogWindow;
    private JMenuItem jMenuItemProgramMemoryUsage;
    private JMenu jMenuProgram;
    private JMenu jMenuExtensions;
    private JMenu jMenuWindows;
    private JMenuBar jMenuBar;

    protected Container createFrame(Main parent, String title, Component c, LayoutManager layout, Object layoutConstraints, int width, int height, JMenuBar menu, boolean listener, boolean visible) {
        Container result = null;
        if (this.m_GUIType == 0) {
            final ChildFrameMDI frame = new ChildFrameMDI(parent, title);
            frame.setLayout(layout);
            if (c != null) {
                frame.getContentPane().add(c, layoutConstraints);
            }
            frame.setJMenuBar(menu);
            frame.pack();
            if (width > -1 && height > -1) {
                frame.setSize(width, height);
            }
            frame.validate();
            if (listener) {
                frame.addInternalFrameListener(new InternalFrameAdapter(){

                    public void internalFrameClosing(InternalFrameEvent e) {
                        frame.dispose();
                    }
                });
            }
            if (visible) {
                frame.setVisible(true);
                try {
                    frame.setSelected(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            result = frame;
        } else if (this.m_GUIType == 1) {
            final ChildFrameSDI frame = new ChildFrameSDI(parent, title);
            frame.setLayout(layout);
            if (c != null) {
                frame.getContentPane().add(c, layoutConstraints);
            }
            frame.setJMenuBar(menu);
            frame.pack();
            if (width > -1 && height > -1) {
                frame.setSize(width, height);
            }
            frame.validate();
            int screenHeight = this.getGraphicsConfiguration().getBounds().height;
            int screenWidth = this.getGraphicsConfiguration().getBounds().width;
            frame.setLocation((screenWidth - frame.getBounds().width) / 2, (screenHeight - frame.getBounds().height) / 2);
            if (listener) {
                frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        frame.dispose();
                    }
                });
            }
            if (visible) {
                frame.setVisible(true);
            }
            result = frame;
        }
        return result;
    }

    protected void insertMenuItem(JMenu menu, JMenuItem menuitem) {
        this.insertMenuItem(menu, menuitem, 0);
    }

    protected void insertMenuItem(JMenu menu, JMenuItem menuitem, int startIndex) {
        boolean inserted = false;
        String newStr = menuitem.getText().toLowerCase();
        for (int i = startIndex; i < menu.getMenuComponentCount(); ++i) {
            JMenuItem current;
            String currentStr;
            if (!(menu.getMenuComponent(i) instanceof JMenuItem) || (currentStr = (current = (JMenuItem)menu.getMenuComponent(i)).getText().toLowerCase()).compareTo(newStr) <= 0) continue;
            inserted = true;
            menu.insert(menuitem, i);
            break;
        }
        if (!inserted) {
            menu.add(menuitem);
        }
    }

    protected void initGUI() {
        this.m_Self = this;
        try {
            this.createTitle("");
            this.setDefaultCloseOperation(3);
            this.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("weka/gui/weka_icon_new_48.png")).getImage());
            Messages.getInstance();
            this.m_FileChooserGraphVisualizer.addChoosableFileFilter(new ExtensionFileFilter(".bif", Messages.getString("Main_InitGUI_ExtensionFileFilter_Text_First")));
            Messages.getInstance();
            this.m_FileChooserGraphVisualizer.addChoosableFileFilter(new ExtensionFileFilter(".xml", Messages.getString("Main_InitGUI_ExtensionFileFilter_Text_Second")));
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            this.m_FileChooserPlot.addChoosableFileFilter(new ExtensionFileFilter(".arff", stringBuilder.append(Messages.getString("Main_InitGUI_ExtensionFileFilter_Text_Third")).append(".arff").append(")").toString()));
            this.m_FileChooserPlot.setMultiSelectionEnabled(true);
            StringBuilder stringBuilder2 = new StringBuilder();
            Messages.getInstance();
            this.m_FileChooserROC.addChoosableFileFilter(new ExtensionFileFilter(".arff", stringBuilder2.append(Messages.getString("Main_InitGUI_ExtensionFileFilter_Text_Third")).append(".arff").append(")").toString()));
            if (this.m_GUIType == 0) {
                this.jDesktopPane = new BackgroundDesktopPane("weka/gui/images/weka_background.gif");
                this.jDesktopPane.setDragMode(1);
                this.setContentPane(this.jDesktopPane);
            } else {
                this.jDesktopPane = null;
            }
            this.jMenuBar = new JMenuBar();
            this.setJMenuBar(this.jMenuBar);
            this.jMenuProgram = new JMenu();
            this.jMenuBar.add(this.jMenuProgram);
            Messages.getInstance();
            this.jMenuProgram.setText(Messages.getString("Main_InitGUI_JMenuProgram_SetText_Text"));
            this.jMenuProgram.setMnemonic('P');
            this.jMenuItemProgramLogWindow = new JMenuItem();
            this.jMenuProgram.add(this.jMenuItemProgramLogWindow);
            Messages.getInstance();
            this.jMenuItemProgramLogWindow.setText(Messages.getString("Main_InitGUI_JMenuItemProgramLogWindow_SetText_Text"));
            this.jMenuItemProgramLogWindow.setMnemonic('L');
            this.jMenuItemProgramLogWindow.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    m_LogWindow.setVisible(true);
                }
            });
            this.jMenuItemProgramMemoryUsage = new JMenuItem();
            this.jMenuProgram.add(this.jMenuItemProgramMemoryUsage);
            Messages.getInstance();
            this.jMenuItemProgramMemoryUsage.setText(Messages.getString("Main_InitGUI_JMenuItemProgramMemoryUsage_SetText_Text"));
            this.jMenuItemProgramMemoryUsage.setMnemonic('M');
            this.jMenuItemProgramMemoryUsage.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String title = Main.this.jMenuItemProgramMemoryUsage.getText();
                    if (!Main.this.containsWindow(title)) {
                        final MemoryUsagePanel panel = new MemoryUsagePanel();
                        Container c = Main.this.createFrame(Main.this.m_Self, title, panel, new BorderLayout(), "Center", 400, 50, null, true, true);
                        Dimension size = c.getPreferredSize();
                        c.setSize(new Dimension((int)size.getWidth(), (int)size.getHeight()));
                        if (Main.this.m_GUIType == 0) {
                            ChildFrameMDI frame = (ChildFrameMDI)c;
                            Point l = panel.getFrameLocation();
                            if (l.x != -1 && l.y != -1) {
                                frame.setLocation(l);
                            }
                            frame.addInternalFrameListener(new InternalFrameAdapter(){

                                public void internalFrameClosing(InternalFrameEvent e) {
                                    panel.stopMonitoring();
                                }
                            });
                        } else {
                            ChildFrameSDI frame = (ChildFrameSDI)c;
                            Point l = panel.getFrameLocation();
                            if (l.x != -1 && l.y != -1) {
                                frame.setLocation(l);
                            }
                            frame.addWindowListener(new WindowAdapter(){

                                public void windowClosing(WindowEvent e) {
                                    panel.stopMonitoring();
                                }
                            });
                        }
                    } else {
                        Main.this.showWindow(Main.this.getWindow(title));
                    }
                }
            });
            this.jMenuProgram.add(new JSeparator());
            this.jMenuItemProgramExit = new JMenuItem();
            this.jMenuProgram.add(this.jMenuItemProgramExit);
            Messages.getInstance();
            this.jMenuItemProgramExit.setText(Messages.getString("Main_InitGUI_JMenuItemProgramExit_SetText_Text"));
            this.jMenuItemProgramExit.setMnemonic('E');
            this.jMenuItemProgramExit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Iterator iter = Main.this.getWindowList();
                    Vector<Container> list = new Vector<Container>();
                    while (iter.hasNext()) {
                        list.add((Container)iter.next());
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        Container c = (Container)list.get(i);
                        if (c instanceof ChildFrameMDI) {
                            ((ChildFrameMDI)c).dispose();
                            continue;
                        }
                        if (!(c instanceof ChildFrameSDI)) continue;
                        ((ChildFrameSDI)c).dispose();
                    }
                    m_LogWindow.dispose();
                    Main.this.m_Self.dispose();
                    System.exit(0);
                }
            });
            this.jMenuApplications = new JMenu();
            this.jMenuBar.add(this.jMenuApplications);
            Messages.getInstance();
            this.jMenuApplications.setText(Messages.getString("Main_InitGUI_JMenuApplications_SetText_Text"));
            this.jMenuApplications.setMnemonic('A');
            this.jMenuItemApplicationsExplorer = new JMenuItem();
            this.jMenuApplications.add(this.jMenuItemApplicationsExplorer);
            Messages.getInstance();
            this.jMenuItemApplicationsExplorer.setText(Messages.getString("Main_InitGUI_JMenuItemApplicationsExplorer_SetText_Text"));
            this.jMenuItemApplicationsExplorer.setMnemonic('E');
            this.jMenuItemApplicationsExplorer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String title = Main.this.jMenuItemApplicationsExplorer.getText();
                    if (!Main.this.containsWindow(title)) {
                        Main.this.createFrame(Main.this.m_Self, title, new Explorer(), new BorderLayout(), "Center", 800, 600, null, true, true);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(title));
                    }
                }
            });
            this.jMenuItemApplicationsExperimenter = new JMenuItem();
            this.jMenuApplications.add(this.jMenuItemApplicationsExperimenter);
            Messages.getInstance();
            this.jMenuItemApplicationsExperimenter.setText(Messages.getString("Main_InitGUI_JMenuItemApplicationsExperimenter_SetText_Text"));
            this.jMenuItemApplicationsExperimenter.setMnemonic('X');
            this.jMenuItemApplicationsExperimenter.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String title = Main.this.jMenuItemApplicationsExperimenter.getText();
                    if (!Main.this.containsWindow(title)) {
                        Main.this.createFrame(Main.this.m_Self, title, new Experimenter(false), new BorderLayout(), "Center", 800, 600, null, true, true);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(title));
                    }
                }
            });
            this.jMenuItemApplicationsKnowledgeFlow = new JMenuItem();
            this.jMenuApplications.add(this.jMenuItemApplicationsKnowledgeFlow);
            Messages.getInstance();
            this.jMenuItemApplicationsKnowledgeFlow.setText(Messages.getString("Main_InitGUI_JMenuItemApplicationsKnowledgeFlow_SetText_Text"));
            this.jMenuItemApplicationsKnowledgeFlow.setMnemonic('K');
            this.jMenuItemApplicationsKnowledgeFlow.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String title = Main.this.jMenuItemApplicationsKnowledgeFlow.getText();
                    if (!Main.this.containsWindow(title)) {
                        KnowledgeFlowApp.createSingleton(new String[0]);
                        Main.this.createFrame(Main.this.m_Self, title, KnowledgeFlowApp.getSingleton(), new BorderLayout(), "Center", 900, 600, null, true, true);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(title));
                    }
                }
            });
            this.jMenuItemApplicationsSimpleCLI = new JMenuItem();
            this.jMenuApplications.add(this.jMenuItemApplicationsSimpleCLI);
            Messages.getInstance();
            this.jMenuItemApplicationsSimpleCLI.setText(Messages.getString("Main_InitGUI_JMenuItemApplicationsSimpleCLI_SetText_Text"));
            this.jMenuItemApplicationsSimpleCLI.setMnemonic('S');
            this.jMenuItemApplicationsSimpleCLI.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String title = Main.this.jMenuItemApplicationsSimpleCLI.getText();
                    if (!Main.this.containsWindow(title)) {
                        try {
                            Main.this.createFrame(Main.this.m_Self, title, new SimpleCLIPanel(), new BorderLayout(), "Center", 600, 500, null, true, true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Main main = Main.this.m_Self;
                            StringBuilder stringBuilder = new StringBuilder();
                            Messages.getInstance();
                            JOptionPane.showMessageDialog(main, stringBuilder.append(Messages.getString("Main_InitGUI_Exception_JOptionPaneShowMessageDialog_Text")).append(e.getMessage()).toString());
                            return;
                        }
                    } else {
                        Main.this.showWindow(Main.this.getWindow(title));
                    }
                }
            });
            this.jMenuTools = new JMenu();
            this.jMenuBar.add(this.jMenuTools);
            Messages.getInstance();
            this.jMenuTools.setText(Messages.getString("Main_InitGUI_JMenuTools_JMenu_SetText_Text"));
            this.jMenuTools.setMnemonic('T');
            this.jMenuItemToolsArffViewer = new JMenuItem();
            this.jMenuTools.add(this.jMenuItemToolsArffViewer);
            Messages.getInstance();
            this.jMenuItemToolsArffViewer.setText(Messages.getString("Main_InitGUI_JMenuItemToolsArffViewer_SetText_Text"));
            this.jMenuItemToolsArffViewer.setMnemonic('A');
            this.jMenuItemToolsArffViewer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String title = Main.this.jMenuItemToolsArffViewer.getText();
                    if (!Main.this.containsWindow(title)) {
                        ArffViewerMainPanel panel = new ArffViewerMainPanel(null);
                        panel.setConfirmExit(false);
                        Container frame = Main.this.createFrame(Main.this.m_Self, title, panel, new BorderLayout(), "Center", 800, 600, panel.getMenu(), true, true);
                        panel.setParent(frame);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(title));
                    }
                }
            });
            this.jMenuItemToolsSqlViewer = new JMenuItem();
            this.jMenuTools.add(this.jMenuItemToolsSqlViewer);
            Messages.getInstance();
            this.jMenuItemToolsSqlViewer.setText(Messages.getString("Main_InitGUI_JMenuItemToolsSqlViewer_SetText_Text"));
            this.jMenuItemToolsSqlViewer.setMnemonic('S');
            this.jMenuItemToolsSqlViewer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String title = Main.this.jMenuItemToolsSqlViewer.getText();
                    if (!Main.this.containsWindow(title)) {
                        final SqlViewer sql = new SqlViewer(null);
                        final Container frame = Main.this.createFrame(Main.this.m_Self, title, sql, new BorderLayout(), "Center", -1, -1, null, false, true);
                        if (frame instanceof ChildFrameMDI) {
                            ((ChildFrameMDI)frame).addInternalFrameListener(new InternalFrameAdapter(){

                                public void internalFrameClosing(InternalFrameEvent e) {
                                    sql.saveSize();
                                    ((ChildFrameMDI)frame).dispose();
                                }
                            });
                        } else if (frame instanceof ChildFrameSDI) {
                            ((ChildFrameSDI)frame).addWindowListener(new WindowAdapter(){

                                public void windowClosing(WindowEvent e) {
                                    sql.saveSize();
                                    ((ChildFrameSDI)frame).dispose();
                                }
                            });
                        }
                    } else {
                        Main.this.showWindow(Main.this.getWindow(title));
                    }
                }
            });
            final JMenuItem jMenuItemBayesNet = new JMenuItem();
            this.jMenuTools.add(jMenuItemBayesNet);
            Messages.getInstance();
            jMenuItemBayesNet.setText(Messages.getString("Main_InitGUI_JMenuItemBayesNet_SetText_Text"));
            jMenuItemBayesNet.setMnemonic('N');
            jMenuItemBayesNet.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String title = jMenuItemBayesNet.getText();
                    if (!Main.this.containsWindow(title)) {
                        GUI bayesNetGUI = new GUI();
                        Container frame = Main.this.createFrame(Main.this.m_Self, title, bayesNetGUI, new BorderLayout(), "Center", 800, 600, bayesNetGUI.getMenuBar(), false, true);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(title));
                    }
                }
            });
            this.jMenuVisualization = new JMenu();
            this.jMenuBar.add(this.jMenuVisualization);
            Messages.getInstance();
            this.jMenuVisualization.setText(Messages.getString("Main_InitGUI_JMenuVisualization_SetText_Text"));
            this.jMenuVisualization.setMnemonic('V');
            this.jMenuItemVisualizationPlot = new JMenuItem();
            this.jMenuVisualization.add(this.jMenuItemVisualizationPlot);
            Messages.getInstance();
            this.jMenuItemVisualizationPlot.setText(Messages.getString("Main_InitGUI_JMenuItemVisualizationPlot_SetText_Text"));
            this.jMenuItemVisualizationPlot.setMnemonic('P');
            this.jMenuItemVisualizationPlot.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    int retVal = Main.this.m_FileChooserPlot.showOpenDialog(Main.this.m_Self);
                    if (retVal != 0) {
                        return;
                    }
                    VisualizePanel panel = new VisualizePanel();
                    String filenames = "";
                    File[] files = Main.this.m_FileChooserPlot.getSelectedFiles();
                    for (int j = 0; j < files.length; ++j) {
                        String filename = files[j].getAbsolutePath();
                        if (j > 0) {
                            filenames = filenames + ", ";
                        }
                        filenames = filenames + filename;
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        System.err.println(stringBuilder.append(Messages.getString("Main_InitGUI_Error_Text")).append(filename).toString());
                        try {
                            BufferedReader r = new BufferedReader(new FileReader(filename));
                            Instances i = new Instances(r);
                            i.setClassIndex(i.numAttributes() - 1);
                            PlotData2D pd1 = new PlotData2D(i);
                            if (j == 0) {
                                Messages.getInstance();
                                pd1.setPlotName(Messages.getString("Main_InitGUI_Pd1_SetPlotName_Text_First"));
                                panel.setMasterPlot(pd1);
                                continue;
                            }
                            StringBuilder stringBuilder2 = new StringBuilder();
                            Messages.getInstance();
                            pd1.setPlotName(stringBuilder2.append(Messages.getString("Main_InitGUI_Pd1_SetPlotName_Text_Second")).append(j + 1).toString());
                            pd1.m_useCustomColour = true;
                            pd1.m_customColour = j % 2 == 0 ? Color.red : Color.blue;
                            panel.addPlot(pd1);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Main main = Main.this.m_Self;
                            StringBuilder stringBuilder3 = new StringBuilder();
                            Messages.getInstance();
                            StringBuilder stringBuilder4 = stringBuilder3.append(Messages.getString("Main_InitGUI_Exception_JOptionPaneShowMessageDialog_Text_First")).append(files[j]);
                            Messages.getInstance();
                            JOptionPane.showMessageDialog(main, stringBuilder4.append(Messages.getString("Main_InitGUI_Exception_JOptionPaneShowMessageDialog_Text_Second")).append(e.getMessage()).toString());
                            return;
                        }
                    }
                    Main.this.createFrame(Main.this.m_Self, Main.this.jMenuItemVisualizationPlot.getText() + " - " + filenames, panel, new BorderLayout(), "Center", 800, 600, null, true, true);
                }
            });
            this.jMenuItemVisualizationROC = new JMenuItem();
            this.jMenuVisualization.add(this.jMenuItemVisualizationROC);
            Messages.getInstance();
            this.jMenuItemVisualizationROC.setText(Messages.getString("Main_InitGUI_JMenuItemVisualizationROC_SetText_Text"));
            this.jMenuItemVisualizationROC.setMnemonic('R');
            this.jMenuItemVisualizationROC.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    int retVal = Main.this.m_FileChooserROC.showOpenDialog(Main.this.m_Self);
                    if (retVal != 0) {
                        return;
                    }
                    String filename = Main.this.m_FileChooserROC.getSelectedFile().getAbsolutePath();
                    Instances result = null;
                    try {
                        result = new Instances(new BufferedReader(new FileReader(filename)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Main main = Main.this.m_Self;
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("Main_InitGUI_Exception_JOptionPaneShowMessageDialog_Text_Third")).append(filename);
                        Messages.getInstance();
                        JOptionPane.showMessageDialog(main, stringBuilder2.append(Messages.getString("Main_InitGUI_Exception_JOptionPaneShowMessageDialog_Text_Fourth")).append(e.getMessage()).toString());
                        return;
                    }
                    result.setClassIndex(result.numAttributes() - 1);
                    ThresholdVisualizePanel vmc = new ThresholdVisualizePanel();
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    vmc.setROCString(stringBuilder.append(Messages.getString("Main_InitGUI_Vmc_SetROCString_Text")).append(Utils.doubleToString(ThresholdCurve.getROCArea(result), 4)).append(")").toString());
                    vmc.setName(result.relationName());
                    PlotData2D tempd = new PlotData2D(result);
                    tempd.setPlotName(result.relationName());
                    tempd.addInstanceNumberAttribute();
                    try {
                        vmc.addPlot(tempd);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Main main = Main.this.m_Self;
                        StringBuilder stringBuilder3 = new StringBuilder();
                        Messages.getInstance();
                        JOptionPane.showMessageDialog(main, stringBuilder3.append(Messages.getString("Main_InitGUI_Exception_JOptionPaneShowMessageDialog_Text_Fifth")).append(e.getMessage()).toString());
                        return;
                    }
                    Main.this.createFrame(Main.this.m_Self, Main.this.jMenuItemVisualizationROC.getText() + " - " + filename, vmc, new BorderLayout(), "Center", 800, 600, null, true, true);
                }
            });
            this.jMenuItemVisualizationTreeVisualizer = new JMenuItem();
            this.jMenuVisualization.add(this.jMenuItemVisualizationTreeVisualizer);
            Messages.getInstance();
            this.jMenuItemVisualizationTreeVisualizer.setText(Messages.getString("Main_InitGUI_JMenuItemVisualizationTreeVisualizer_SetText_Text"));
            this.jMenuItemVisualizationTreeVisualizer.setMnemonic('T');
            this.jMenuItemVisualizationTreeVisualizer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    int retVal = Main.this.m_FileChooserTreeVisualizer.showOpenDialog(Main.this.m_Self);
                    if (retVal != 0) {
                        return;
                    }
                    String filename = Main.this.m_FileChooserTreeVisualizer.getSelectedFile().getAbsolutePath();
                    TreeBuild builder = new TreeBuild();
                    Node top = null;
                    PlaceNode2 arrange = new PlaceNode2();
                    try {
                        top = builder.create(new FileReader(filename));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Main main = Main.this.m_Self;
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("Main_InitGUI_Exception_JOptionPaneShowMessageDialog_Text_Sixth")).append(filename);
                        Messages.getInstance();
                        JOptionPane.showMessageDialog(main, stringBuilder2.append(Messages.getString("Main_InitGUI_Exception_JOptionPaneShowMessageDialog_Text_Seventh")).append(e.getMessage()).toString());
                        return;
                    }
                    Main.this.createFrame(Main.this.m_Self, Main.this.jMenuItemVisualizationTreeVisualizer.getText() + " - " + filename, new TreeVisualizer(null, top, (NodePlace)arrange), new BorderLayout(), "Center", 800, 600, null, true, true);
                }
            });
            this.jMenuItemVisualizationGraphVisualizer = new JMenuItem();
            this.jMenuVisualization.add(this.jMenuItemVisualizationGraphVisualizer);
            Messages.getInstance();
            this.jMenuItemVisualizationGraphVisualizer.setText(Messages.getString("Main_InitGUI_JMenuItemVisualizationGraphVisualizer_SetText_Text"));
            this.jMenuItemVisualizationGraphVisualizer.setMnemonic('G');
            this.jMenuItemVisualizationGraphVisualizer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    int retVal = Main.this.m_FileChooserGraphVisualizer.showOpenDialog(Main.this.m_Self);
                    if (retVal != 0) {
                        return;
                    }
                    String filename = Main.this.m_FileChooserGraphVisualizer.getSelectedFile().getAbsolutePath();
                    GraphVisualizer panel = new GraphVisualizer();
                    try {
                        if (filename.toLowerCase().endsWith(".xml") || filename.toLowerCase().endsWith(".bif")) {
                            panel.readBIF(new FileInputStream(filename));
                        } else {
                            panel.readDOT(new FileReader(filename));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Main main = Main.this.m_Self;
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("Main_InitGUI_Exception_JOptionPaneShowMessageDialog_Text_Eighth")).append(filename);
                        Messages.getInstance();
                        JOptionPane.showMessageDialog(main, stringBuilder2.append(Messages.getString("Main_InitGUI_Exception_JOptionPaneShowMessageDialog_Text_nineth")).append(e.getMessage()).toString());
                        return;
                    }
                    Main.this.createFrame(Main.this.m_Self, Main.this.jMenuItemVisualizationGraphVisualizer.getText() + " - " + filename, panel, new BorderLayout(), "Center", 800, 600, null, true, true);
                }
            });
            this.jMenuItemVisualizationBoundaryVisualizer = new JMenuItem();
            this.jMenuVisualization.add(this.jMenuItemVisualizationBoundaryVisualizer);
            Messages.getInstance();
            this.jMenuItemVisualizationBoundaryVisualizer.setText(Messages.getString("Main_InitGUI_JMenuItemVisualizationBoundaryVisualizer_SetText_Text"));
            this.jMenuItemVisualizationBoundaryVisualizer.setMnemonic('B');
            this.jMenuItemVisualizationBoundaryVisualizer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String title = Main.this.jMenuItemVisualizationBoundaryVisualizer.getText();
                    if (!Main.this.containsWindow(title)) {
                        Main.this.createFrame(Main.this.m_Self, title, new BoundaryVisualizer(), new BorderLayout(), "Center", 800, 600, null, true, true);
                        BoundaryVisualizer.setExitIfNoWindowsOpen(false);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(title));
                    }
                }
            });
            Messages.getInstance();
            this.jMenuExtensions = new JMenu(Messages.getString("Main_InitGUI_JMenuExtensions_JMenu_Text"));
            this.jMenuExtensions.setMnemonic(69);
            this.jMenuBar.add(this.jMenuExtensions);
            this.jMenuExtensions.setVisible(false);
            String extensions = GenericObjectEditor.EDITOR_PROPERTIES.getProperty(MainMenuExtension.class.getName(), "");
            if (extensions.length() > 0) {
                this.jMenuExtensions.setVisible(true);
                String[] classnames = GenericObjectEditor.EDITOR_PROPERTIES.getProperty(MainMenuExtension.class.getName(), "").split(",");
                Hashtable<String, JMenu> submenus = new Hashtable<String, JMenu>();
                for (String classname : classnames) {
                    try {
                        MainMenuExtension ext = (MainMenuExtension)Class.forName(classname).newInstance();
                        JMenu submenu = null;
                        if (ext.getSubmenuTitle() != null && (submenu = (JMenu)submenus.get(ext.getSubmenuTitle())) == null) {
                            submenu = new JMenu(ext.getSubmenuTitle());
                            submenus.put(ext.getSubmenuTitle(), submenu);
                            this.insertMenuItem(this.jMenuExtensions, submenu);
                        }
                        JMenuItem menuitem = new JMenuItem();
                        menuitem.setText(ext.getMenuTitle());
                        ActionListener listener = ext.getActionListener(this.m_Self);
                        if (listener != null) {
                            menuitem.addActionListener(listener);
                        } else {
                            final JMenuItem finalMenuitem = menuitem;
                            final MainMenuExtension finalExt = ext;
                            menuitem.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent e) {
                                    Container frame = Main.this.createFrame(Main.this.m_Self, finalMenuitem.getText(), null, null, null, -1, -1, null, false, false);
                                    finalExt.fillFrame(frame);
                                    frame.setVisible(true);
                                }
                            });
                        }
                        if (submenu != null) {
                            this.insertMenuItem(submenu, menuitem);
                            continue;
                        }
                        this.insertMenuItem(this.jMenuExtensions, menuitem);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            Messages.getInstance();
            this.jMenuWindows = new JMenu(Messages.getString("Main_InitGUI_JMenuWindows_JMenu_Text"));
            this.jMenuWindows.setMnemonic(87);
            this.jMenuBar.add(this.jMenuWindows);
            this.jMenuWindows.setVisible(false);
            this.jMenuHelp = new JMenu();
            this.jMenuBar.add(this.jMenuHelp);
            Messages.getInstance();
            this.jMenuHelp.setText(Messages.getString("Main_InitGUI_JMenuHelp_SetText_Text"));
            this.jMenuHelp.setMnemonic('H');
            this.jMenuItemHelpHomepage = new JMenuItem();
            this.jMenuHelp.add(this.jMenuItemHelpHomepage);
            Messages.getInstance();
            this.jMenuItemHelpHomepage.setText(Messages.getString("Main_InitGUI_JMenuItemHelpHomepage_SetText_Text"));
            this.jMenuItemHelpHomepage.setMnemonic('H');
            this.jMenuItemHelpHomepage.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Main main = Main.this.m_Self;
                    Messages.getInstance();
                    BrowserHelper.openURL(main, Messages.getString("Main_InitGUI_BrowserHelper_OpenURL_Text_First"));
                }
            });
            this.jMenuHelp.add(new JSeparator());
            this.jMenuItemHelpWekaWiki = new JMenuItem();
            this.jMenuHelp.add(this.jMenuItemHelpWekaWiki);
            Messages.getInstance();
            this.jMenuItemHelpWekaWiki.setText(Messages.getString("Main_InitGUI_JMenuItemHelpWekaWiki_SetText_Text"));
            this.jMenuItemHelpWekaWiki.setMnemonic('W');
            this.jMenuItemHelpWekaWiki.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Main main = Main.this.m_Self;
                    Messages.getInstance();
                    BrowserHelper.openURL(main, Messages.getString("Main_InitGUI_BrowserHelper_OpenURL_Text_Second"));
                }
            });
            this.jMenuItemHelpSourceforge = new JMenuItem();
            this.jMenuHelp.add(this.jMenuItemHelpSourceforge);
            Messages.getInstance();
            this.jMenuItemHelpSourceforge.setText(Messages.getString("Main_InitGUI_JMenuItemHelpSourceforge_SetText_Text"));
            this.jMenuItemHelpSourceforge.setMnemonic('F');
            this.jMenuItemHelpSourceforge.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Main main = Main.this.m_Self;
                    Messages.getInstance();
                    BrowserHelper.openURL(main, Messages.getString("Main_InitGUI_BrowserHelperOpenURL_Text_Third"));
                }
            });
            this.jMenuHelp.add(new JSeparator());
            this.jMenuItemHelpSystemInfo = new JMenuItem();
            this.jMenuHelp.add(this.jMenuItemHelpSystemInfo);
            Messages.getInstance();
            this.jMenuItemHelpSystemInfo.setText(Messages.getString("Main_InitGUI_JMenuItemHelpSystemInfo_SetText_Text"));
            this.jMenuItemHelpHomepage.setMnemonic('S');
            this.jMenuItemHelpSystemInfo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String title = Main.this.jMenuItemHelpSystemInfo.getText();
                    if (!Main.this.containsWindow(title)) {
                        Hashtable info = new SystemInfo().getSystemInfo();
                        Vector names = new Vector();
                        Enumeration enm = info.keys();
                        while (enm.hasMoreElements()) {
                            names.add(enm.nextElement());
                        }
                        Collections.sort(names);
                        Object[][] data = new String[info.size()][2];
                        for (int i = 0; i < names.size(); ++i) {
                            data[i][0] = names.get(i).toString();
                            data[i][1] = info.get(data[i][0]).toString();
                        }
                        Object[] objectArray = new String[2];
                        Messages.getInstance();
                        objectArray[0] = Messages.getString("Main_InitGUI_Title_Text_First");
                        Messages.getInstance();
                        objectArray[1] = Messages.getString("Main_InitGUI_Title_Text_Second");
                        Object[] titles = objectArray;
                        JTable table = new JTable(data, titles);
                        Main.this.createFrame(Main.this.m_Self, title, new JScrollPane(table), new BorderLayout(), "Center", 800, 600, null, true, true);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(title));
                    }
                }
            });
            this.jMenuHelp.add(new JSeparator());
            this.jMenuItemHelpAbout = new JMenuItem();
            this.jMenuHelp.add(this.jMenuItemHelpAbout);
            Messages.getInstance();
            this.jMenuItemHelpAbout.setText(Messages.getString("Main_InitGUI_JMenuItemHelpAbout_SetText_Text"));
            this.jMenuItemHelpAbout.setMnemonic('A');
            this.jMenuItemHelpAbout.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String title = Main.this.jMenuItemHelpAbout.getText();
                    if (!Main.this.containsWindow(title)) {
                        JPanel wekaPan = new JPanel();
                        Messages.getInstance();
                        wekaPan.setToolTipText(Messages.getString("Main_InitGUI_WekaPan_JPanel_SetToolTipText_Text"));
                        ImageIcon wii = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/gui/weka3.gif")));
                        JLabel wekaLab = new JLabel(wii);
                        wekaPan.add(wekaLab);
                        Container frame = Main.this.createFrame(Main.this.m_Self, title, wekaPan, new BorderLayout(), "Center", -1, -1, null, true, true);
                        JPanel titlePan = new JPanel();
                        titlePan.setLayout(new GridLayout(8, 1));
                        titlePan.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
                        Messages.getInstance();
                        titlePan.add(new JLabel(Messages.getString("Main_InitGUI_TitlePan_Add_JLabel_Text_First"), 0));
                        Messages.getInstance();
                        titlePan.add(new JLabel(Messages.getString("Main_InitGUI_TitlePan_Add_JLabel_Text_Second"), 0));
                        Messages.getInstance();
                        titlePan.add(new JLabel(Messages.getString("Main_InitGUI_TitlePan_Add_JLabel_Text_Third")));
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        titlePan.add(new JLabel(stringBuilder.append(Messages.getString("Main_InitGUI_TitlePan_Add_JLabel_Text_Fourth")).append(Version.VERSION).toString(), 0));
                        Messages.getInstance();
                        titlePan.add(new JLabel(Messages.getString("Main_InitGUI_TitlePan_Add_JLabel_Text_Fifth")));
                        StringBuilder stringBuilder2 = new StringBuilder();
                        Messages.getInstance();
                        titlePan.add(new JLabel(stringBuilder2.append(Messages.getString("Main_InitGUI_TitlePan_Add_JLabel_Text_Sixth")).append(Copyright.getFromYear()).append(" - ").append(Copyright.getToYear()).toString(), 0));
                        titlePan.add(new JLabel(Copyright.getOwner(), 0));
                        titlePan.add(new JLabel(Copyright.getAddress(), 0));
                        if (frame instanceof ChildFrameMDI) {
                            ((ChildFrameMDI)frame).getContentPane().add((Component)titlePan, "North");
                            ((ChildFrameMDI)frame).pack();
                        } else if (frame instanceof ChildFrameSDI) {
                            ((ChildFrameSDI)frame).getContentPane().add((Component)titlePan, "North");
                            ((ChildFrameSDI)frame).pack();
                        }
                    } else {
                        Main.this.showWindow(Main.this.getWindow(title));
                    }
                }
            });
            int screenHeight = this.getGraphicsConfiguration().getBounds().height;
            int screenWidth = this.getGraphicsConfiguration().getBounds().width;
            if (this.m_GUIType == 0) {
                int newHeight = (int)((double)screenHeight * 0.75);
                int newWidth = (int)((double)screenWidth * 0.75);
                this.setSize(1000 > newWidth ? newWidth : 1000, 800 > newHeight ? newHeight : 800);
                this.setLocation((screenWidth - this.getBounds().width) / 2, (screenHeight - this.getBounds().height) / 2);
            } else if (this.m_GUIType == 1) {
                this.pack();
                this.setSize(screenWidth, this.getHeight());
                this.setLocation(0, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void createTitle(String title) {
        StringBuilder stringBuilder = new StringBuilder();
        Messages.getInstance();
        String newTitle = stringBuilder.append(Messages.getString("Main_CreateTitle_NewTitle_Text")).append(new Version()).toString();
        if (title.length() != 0) {
            newTitle = newTitle + " - " + title;
        }
        this.setTitle(newTitle);
    }

    public void addChildFrame(Container c) {
        this.m_ChildFrames.add(c);
        this.windowListChanged();
    }

    public boolean removeChildFrame(Container c) {
        boolean result = this.m_ChildFrames.remove(c);
        this.windowListChanged();
        return result;
    }

    public boolean showWindow(Container c) {
        boolean result;
        if (c != null) {
            try {
                if (c instanceof ChildFrameMDI) {
                    ChildFrameMDI mdiFrame = (ChildFrameMDI)c;
                    mdiFrame.setIcon(false);
                    mdiFrame.toFront();
                    this.createTitle(mdiFrame.getTitle());
                } else if (c instanceof ChildFrameSDI) {
                    ChildFrameSDI sdiFrame = (ChildFrameSDI)c;
                    sdiFrame.setExtendedState(0);
                    sdiFrame.toFront();
                    this.createTitle(sdiFrame.getTitle());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            result = true;
        } else {
            result = false;
        }
        return result;
    }

    public boolean showWindow(Class windowClass) {
        return this.showWindow(this.getWindow(windowClass));
    }

    public Iterator getWindowList() {
        return this.m_ChildFrames.iterator();
    }

    public Container getWindow(Class windowClass) {
        Container result = null;
        Iterator iter = this.getWindowList();
        while (iter.hasNext()) {
            Container current = (Container)iter.next();
            if (current.getClass() != windowClass) continue;
            result = current;
            break;
        }
        return result;
    }

    public Container getWindow(String title) {
        Container result = null;
        Iterator iter = this.getWindowList();
        while (iter.hasNext()) {
            Container current = (Container)iter.next();
            boolean found = false;
            if (current instanceof ChildFrameMDI) {
                found = ((ChildFrameMDI)current).getTitle().equals(title);
            } else if (current instanceof ChildFrameSDI) {
                found = ((ChildFrameSDI)current).getTitle().equals(title);
            }
            if (!found) continue;
            result = current;
            break;
        }
        return result;
    }

    public boolean containsWindow(Class windowClass) {
        return this.getWindow(windowClass) != null;
    }

    public boolean containsWindow(String title) {
        return this.getWindow(title) != null;
    }

    public void minimizeWindows() {
        Iterator iter = this.getWindowList();
        while (iter.hasNext()) {
            Container frame = (Container)iter.next();
            try {
                if (frame instanceof ChildFrameMDI) {
                    ((ChildFrameMDI)frame).setIcon(true);
                    continue;
                }
                if (!(frame instanceof ChildFrameSDI)) continue;
                ((ChildFrameSDI)frame).setExtendedState(1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void restoreWindows() {
        Iterator iter = this.getWindowList();
        while (iter.hasNext()) {
            Container frame = (Container)iter.next();
            try {
                if (frame instanceof ChildFrameMDI) {
                    ((ChildFrameMDI)frame).setIcon(false);
                    continue;
                }
                if (!(frame instanceof ChildFrameSDI)) continue;
                ((ChildFrameSDI)frame).setExtendedState(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void windowListChanged() {
        this.createWindowMenu();
    }

    protected synchronized void createWindowMenu() {
        this.jMenuWindows.removeAll();
        Messages.getInstance();
        JMenuItem menuItem = new JMenuItem(Messages.getString("Main_CreateWindowMenu_MenuItem_JMenuItem_Text_First"));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.minimizeWindows();
            }
        });
        this.jMenuWindows.add(menuItem);
        Messages.getInstance();
        menuItem = new JMenuItem(Messages.getString("Main_CreateWindowMenu_MenuItem_JMenuItem_Text_Second"));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.restoreWindows();
            }
        });
        this.jMenuWindows.add(menuItem);
        this.jMenuWindows.addSeparator();
        int startIndex = this.jMenuWindows.getMenuComponentCount() - 1;
        Iterator iter = this.getWindowList();
        this.jMenuWindows.setVisible(iter.hasNext());
        while (iter.hasNext()) {
            Container frame = (Container)iter.next();
            if (frame instanceof ChildFrameMDI) {
                menuItem = new JMenuItem(((ChildFrameMDI)frame).getTitle());
            } else if (frame instanceof ChildFrameSDI) {
                menuItem = new JMenuItem(((ChildFrameSDI)frame).getTitle());
            }
            this.insertMenuItem(this.jMenuWindows, menuItem, startIndex);
            menuItem.setActionCommand(Integer.toString(frame.hashCode()));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Container frame = null;
                    Iterator iter = Main.this.getWindowList();
                    while (iter.hasNext()) {
                        frame = (Container)iter.next();
                        String hashFrame = Integer.toString(frame.hashCode());
                        if (!hashFrame.equals(evt.getActionCommand())) continue;
                        Main.this.showWindow(frame);
                        break;
                    }
                    Main.this.showWindow(frame);
                }
            });
        }
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.paint(this.getGraphics());
        }
    }

    public static void createSingleton(String[] args) {
        if (m_MainSingleton == null) {
            m_MainSingleton = new Main();
        }
        try {
            m_MainSingleton.setOptions(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < m_StartupListeners.size(); ++i) {
            ((StartUpListener)m_StartupListeners.elementAt(i)).startUpComplete();
        }
    }

    public static Main getSingleton() {
        return m_MainSingleton;
    }

    public static void addStartupListener(StartUpListener s) {
        m_StartupListeners.add(s);
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        String desc = "";
        for (int i = 0; i < TAGS_GUI.length; ++i) {
            SelectedTag tag = new SelectedTag(TAGS_GUI[i].getID(), TAGS_GUI);
            desc = desc + "\t" + tag.getSelectedTag().getIDStr() + " = " + tag.getSelectedTag().getReadable() + "\n";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Messages.getInstance();
        StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("Main_ListOptions_Option_Text_First")).append(desc);
        Messages.getInstance();
        result.addElement(new Option(stringBuilder2.append(Messages.getString("Main_ListOptions_Option_Text_Second")).append(new SelectedTag(0, TAGS_GUI)).append(")").toString(), "gui", 1, "-gui " + Tag.toOptionList(TAGS_GUI)));
        return result.elements();
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-gui");
        result.add("" + this.getGUIType());
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption("gui", options);
        if (tmpStr.length() != 0) {
            this.setGUIType(new SelectedTag(tmpStr, TAGS_GUI));
        } else {
            this.setGUIType(new SelectedTag(0, TAGS_GUI));
        }
    }

    public void setGUIType(SelectedTag value) {
        if (value.getTags() == TAGS_GUI) {
            this.m_GUIType = value.getSelectedTag().getID();
            this.initGUI();
        }
    }

    public SelectedTag getGUIType() {
        return new SelectedTag(this.m_GUIType, TAGS_GUI);
    }

    public static void main(String[] args) {
        Messages.getInstance();
        Logger.log(Logger.Level.INFO, Messages.getString("Main_Main_Logger_Text"));
        LookAndFeel.setLookAndFeel();
        try {
            if (Utils.getFlag('h', args)) {
                System.out.println();
                Messages.getInstance();
                System.out.println(Messages.getString("Main_Main_Text_First"));
                System.out.println();
                Messages.getInstance();
                System.out.println(Messages.getString("Main_Main_Text_Second"));
                System.out.println();
                System.out.println("-h");
                Messages.getInstance();
                System.out.println(Messages.getString("Main_Main_Text_Third"));
                System.out.println();
                Enumeration enu = new Main().listOptions();
                while (enu.hasMoreElements()) {
                    Option option = (Option)enu.nextElement();
                    System.out.println(option.synopsis());
                    System.out.println(option.description());
                }
                System.out.println();
                System.exit(0);
            }
            Main.addStartupListener(new StartUpListener(){

                public void startUpComplete() {
                    m_MainCommandline = Main.getSingleton();
                    m_MainCommandline.setVisible(true);
                }
            });
            Main.addStartupListener(new StartUpListener(){

                public void startUpComplete() {
                    SplashWindow.disposeSplash();
                }
            });
            SplashWindow.splash(ClassLoader.getSystemResource("weka/gui/images/weka_splash.gif"));
            final String[] options = (String[])args.clone();
            Thread nt = new Thread(){

                public void run() {
                    SplashWindow.invokeMethod(Main.class.getName(), "createSingleton", options);
                }
            };
            nt.start();
            Thread memMonitor = new Thread(){

                public void run() {
                    while (true) {
                        if (!m_Memory.isOutOfMemory()) {
                            continue;
                        }
                        m_MainCommandline = null;
                        System.gc();
                        Messages.getInstance();
                        System.err.println(Messages.getString("Main_Main_Thread_Run_Error_Text_First"));
                        m_Memory.showOutOfMemory();
                        Messages.getInstance();
                        System.err.println(Messages.getString("Main_Main_Thread_Run_Error_Text_Second"));
                        System.exit(-1);
                    }
                }
            };
            memMonitor.setPriority(10);
            memMonitor.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    static {
        Tag[] tagArray = new Tag[2];
        Messages.getInstance();
        tagArray[0] = new Tag(0, "MDI", Messages.getString("Main_Tag_GUI_Text_First"));
        Messages.getInstance();
        tagArray[1] = new Tag(1, "SDI", Messages.getString("Main_Tag_GUI_Text_Second"));
        TAGS_GUI = tagArray;
        m_StartupListeners = new Vector();
        m_Memory = new Memory(true);
        m_LogWindow = new LogWindow();
    }

    public static class ChildFrameMDI
    extends JInternalFrame {
        private static final long serialVersionUID = 3772573515346899959L;
        protected Main m_Parent;

        public ChildFrameMDI(Main parent, String title) {
            super(title, true, true, true, true);
            this.m_Parent = parent;
            this.addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameActivated(InternalFrameEvent e) {
                    if (ChildFrameMDI.this.getParentFrame() != null) {
                        ChildFrameMDI.this.getParentFrame().createTitle(ChildFrameMDI.this.getTitle());
                    }
                }
            });
            if (this.getParentFrame() != null) {
                this.getParentFrame().addChildFrame(this);
                this.getParentFrame().jDesktopPane.add(this);
            }
        }

        public Main getParentFrame() {
            return this.m_Parent;
        }

        public void dispose() {
            if (this.getParentFrame() != null) {
                this.getParentFrame().removeChildFrame(this);
                this.getParentFrame().createTitle("");
            }
            super.dispose();
        }
    }

    public static class ChildFrameSDI
    extends JFrame {
        private static final long serialVersionUID = 8588293938686425618L;
        protected Main m_Parent;

        public ChildFrameSDI(Main parent, String title) {
            super(title);
            this.m_Parent = parent;
            this.addWindowListener(new WindowAdapter(){

                public void windowActivated(WindowEvent e) {
                    if (ChildFrameSDI.this.getParentFrame() != null) {
                        ChildFrameSDI.this.getParentFrame().createTitle(ChildFrameSDI.this.getTitle());
                    }
                }
            });
            if (this.getParentFrame() != null) {
                this.getParentFrame().addChildFrame(this);
                this.setIconImage(this.getParentFrame().getIconImage());
            }
        }

        public Main getParentFrame() {
            return this.m_Parent;
        }

        public void dispose() {
            if (this.getParentFrame() != null) {
                this.getParentFrame().removeChildFrame(this);
                this.getParentFrame().createTitle("");
            }
            super.dispose();
        }
    }

    public static class BackgroundDesktopPane
    extends JDesktopPane {
        private static final long serialVersionUID = 2046713123452402745L;
        protected Image m_Background;

        public BackgroundDesktopPane(String image) {
            try {
                this.m_Background = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(image));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.m_Background != null) {
                g.setColor(Color.WHITE);
                g.clearRect(0, 0, this.getWidth(), this.getHeight());
                int width = this.m_Background.getWidth(null);
                int height = this.m_Background.getHeight(null);
                int x = (this.getWidth() - width) / 2;
                int y = (this.getHeight() - height) / 2;
                g.drawImage(this.m_Background, x, y, width, height, this);
            }
        }
    }
}

