/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.Component;
import java.lang.reflect.Method;
import javax.swing.JOptionPane;
import weka.gui.Messages;

public class BrowserHelper {
    public static final String[] LINUX_BROWSERS = new String[]{"firefox", "google-chrome", "opera", "konqueror", "epiphany", "mozilla", "netscape"};

    public static void openURL(String url) {
        BrowserHelper.openURL(null, url);
    }

    public static void openURL(Component parent, String url) {
        BrowserHelper.openURL(parent, url, true);
    }

    public static void openURL(Component parent, String url, boolean showDialog) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String browser = null;
                for (int count = 0; count < LINUX_BROWSERS.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", LINUX_BROWSERS[count]}).waitFor() != 0) continue;
                    browser = LINUX_BROWSERS[count];
                    break;
                }
                if (browser == null) {
                    Messages.getInstance();
                    throw new Exception(Messages.getString("BrowserHelper_Exception_Text"));
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            String errMsg = stringBuilder.append(Messages.getString("BrowserHelper_Exception_ErrMsg_Text")).append(e.getMessage()).toString();
            if (showDialog) {
                JOptionPane.showMessageDialog(parent, errMsg);
            }
            System.err.println(errMsg);
        }
    }
}

