import * as React from "react";

import Svg, { SvgProps, G, Path, Defs, ClipPath } from "react-native-svg";

const SvgOpenSea = (props: SvgProps) => (
  <Svg width={24} height={24} viewBox="0 0 24 24" fill="none" {...props}>
    <G clipPath="url(#OpenSea_svg__a)">
      <Path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M12 24c6.627 0 12-5.373 12-12S18.628 0 12 0C5.373 0 0 5.373 0 12s5.373 12 12 12Zm7.835-10.69v.774a.111.111 0 0 1-.067.1c-.242.104-1.069.484-1.413.962-.191.267-.373.558-.555.85-.654 1.05-1.32 2.12-2.493 2.12H9.053a4.02 4.02 0 0 1-4.013-4.027v-.072c0-.06.048-.107.107-.107h3.487c.069 0 .12.064.113.132a1.19 1.19 0 0 0 .125.67c.207.42.636.682 1.1.682h1.726v-1.347H9.99a.11.11 0 0 1-.088-.173 3.085 3.085 0 0 1 .061-.091c.162-.23.392-.586.621-.991.157-.274.309-.566.43-.86.024-.049.042-.1.06-.149l.005-.011.026-.072c.024-.067.048-.132.066-.197.02-.06.037-.123.054-.184l.01-.04c.058-.25.083-.513.083-.787 0-.107-.005-.22-.015-.327a4.219 4.219 0 0 0-.034-.35 3.666 3.666 0 0 0-.048-.314 5.314 5.314 0 0 0-.099-.468l-.013-.06c-.01-.032-.018-.063-.026-.095-.02-.073-.039-.146-.063-.222-.098-.336-.21-.664-.328-.971-.043-.122-.092-.238-.141-.355l-.001-.001a12.924 12.924 0 0 0-.17-.39l-.045-.099a6.867 6.867 0 0 1-.093-.196 7.06 7.06 0 0 0-.133-.275 1.16 1.16 0 0 1-.042-.09l-.211-.39a.069.069 0 0 1 .078-.1l1.319.357h.004l.004.002.174.048.191.054.07.02v-.785c0-.378.304-.685.679-.685a.67.67 0 0 1 .48.201.69.69 0 0 1 .198.484V6.65l.14.04a.113.113 0 0 1 .032.016l.046.034.101.077.062.051c.032.027.066.056.104.086a10.128 10.128 0 0 1 .573.503c.214.2.454.434.684.693a9.001 9.001 0 0 1 .26.307c.042.05.084.101.122.151l.043.058c.065.085.132.174.191.265l.047.07c.02.03.042.06.06.09.094.142.177.289.256.436.033.067.068.141.097.214.088.196.157.396.201.596.014.043.023.09.029.132v.01c.014.059.02.122.024.186a1.988 1.988 0 0 1-.107.873l-.01.028a3.447 3.447 0 0 1-.352.728 2.873 2.873 0 0 1-.177.272l-.063.09a3.752 3.752 0 0 1-.171.22 7.977 7.977 0 0 1-.41.488c-.05.059-.103.118-.157.17-.046.052-.092.098-.136.141l-.02.021a6.202 6.202 0 0 1-.21.2l-.136.125a.11.11 0 0 1-.073.027h-1.05v1.347h1.321c.296 0 .577-.105.804-.297l.006-.005c.088-.077.42-.367.812-.799a.103.103 0 0 1 .05-.03l3.65-1.056a.108.108 0 0 1 .138.104ZM5.92 12.404l.052-.081 3.122-4.884a.107.107 0 0 1 .187.014c.522 1.169.972 2.622.76 3.527-.09.373-.336.877-.613 1.343a2.466 2.466 0 0 1-.117.198.106.106 0 0 1-.089.047h-3.21a.107.107 0 0 1-.092-.164Z"
        fill={props.color}
      />
    </G>
    <Defs>
      <ClipPath id="OpenSea_svg__a">
        <Path fill={props.color} d="M0 0h24v24H0z" />
      </ClipPath>
    </Defs>
  </Svg>
);

export default SvgOpenSea;
