![figures](assets/image.png)

# ChatGPT Prompt Engineering for Developers


## Table of Contents

- [Prompt's Construction Principles Guidelines](content/l2-guidelines.ipynb)
- [How to iteratively optimize Prompt Itrative](content/l3-iterative-prompt-development.ipynb)
- [Text Summary Summarizing](content/l4-summarizing.ipynb)
- [Text Inferring Inferring](content/l5-inferring.ipynb)
- [Text Conversion Transforming](content/l6-transforming.ipynb)
- [Text Expansion Expanding](content/l7-expanding.ipynb)
- [Chatbot Chatbot ](content/l8-chatbot.ipynb)

---

Welcome to the **ChatGPT Prompt Engineering for Developers** course! This course will teach you how to utilize a large language model (LLM) effectively to create powerful applications. By leveraging the OpenAI API, you can now develop innovative solutions that were previously expensive, technically challenging, or even impossible.


## Course Overview
Led by **Isa Fulford** from OpenAI and **Andrew Ng** from DeepLearning.AI, this short course provides insights into how LLMs function, offers best practices for prompt engineering, and demonstrates the use of LLM APIs in various applications.

## Key Learning Objectives
- Understand the working of LLMs
- Master prompt engineering best practices
- Utilize LLM APIs for various tasks:
  - Summarizing (e.g., summarizing user reviews for brevity)
  - Inferring (e.g., sentiment classification, topic extraction)
  - Transforming text (e.g., translation, spelling & grammar correction)
  - Expanding (e.g., automatically writing emails)

## Additional Course Highlights
- Learn two key principles for writing effective prompts
- Systematically engineer good prompts
- Build a custom chatbot

## Hands-on Experience
All concepts are illustrated with numerous examples, which you can play with directly in our Jupyter notebook environment to get hands-on experience with prompt engineering.

Unlock the full potential of ChatGPT and revolutionize your application development process with the ChatGPT Prompt Engineering for Developers course!

---

### Course link

[ChatGPT Prompt Engineering for Developers](https://www.deeplearning.ai/short-courses/chatgpt-prompt-engineering-for-developers/)