import {Accessories} from '../avatar.enum';

export class AccessoriesHelper {
  public static getAccessorySvg(acc: Accessories) {
    switch (acc) {
      case Accessories.BLANK:
        return '';
      case Accessories.KURTA:
        return AccessoriesHelper.getKurtaSvg();
      case Accessories.PRESCRIPITON01:
        return AccessoriesHelper.getPresciption01();
      case Accessories.PRESCRIPITON02:
        return AccessoriesHelper.getPresciption02();
      case Accessories.ROUND:
        return AccessoriesHelper.getRound();
      case Accessories.SUNGLASSES:
        return AccessoriesHelper.getSunglasses();
      case Accessories.WAYFARERS:
        return AccessoriesHelper.getWayfarers();
      default:
        return '';
    }
  }

  private static getKurtaSvg() {
    return `
    <g
    id='Top/_Resources/Kurt'
    fill='none'
    transform='translate(62.000000, 85.000000)'
    stroke-width='1'>
    <defs>
      <filter
        x='-0.8%'
    y='-2.0%'
    width='101.5%'
    height='108.0%'
    filterUnits='objectBoundingBox'
    id='kurta_filter'>
    <feOffset
      dx='0'
    dy='2'
    in='SourceAlpha'
    result='shadowOffsetOuter1'
    />
    <feColorMatrix
      values='0 0 0 0 0   0 0 0 0 0   0 0 0 0 0  0 0 0 0.16 0'
    type='matrix'
    in='shadowOffsetOuter1'
    result='shadowMatrixOuter1'
    />
    <feMerge>
    <feMergeNode in='shadowMatrixOuter1' />
    <feMergeNode in='SourceGraphic' />
      </feMerge>
      </filter>
      </defs>
      <g
    id='Kurts'
    filter='url(#kurta_filter)'
    transform='translate(5.000000, 2.000000)'>
    <path
      d='M66,11.1111111 C54.9625586,11.1111111 53.3705645,2.0266011 30.6705882,0.740740741 C7.98552275,-0.283199952 0.815225204,6.4494855 0.776470588,11.1111111 C0.813236892,15.4042795 -0.352293566,26.5612661 14.3647059,39.6296296 C29.1367705,55.1420807 44.2704162,49.8818301 49.6941176,44.8148148 C55.1352081,42.4731118 61.3403442,21.4596351 66,21.4814815 C70.6596558,21.5033279 76.8647919,42.4731118 82.3058824,44.8148148 C87.7295838,49.8818301 102.86323,55.1420807 117.635294,39.6296296 C132.352294,26.5612661 131.186763,15.4042795 131.223529,11.1111111 C131.184775,6.4494855 124.014477,-0.283199952 101.329412,0.740740741 C78.6294355,2.0266011 77.0374414,11.1111111 66,11.1111111 Z'
    id='It!'
    fill='#F4F4F4'
    fill-rule='nonzero'
    />
    <path
      d='M55.1294118,21.4814815 C55.5103632,13.8233491 42.2156493,5.64243259 27.9529412,5.92592593 C13.6973442,6.22450879 11.8417942,15.3786982 11.6470588,18.8888889 C11.2982286,27.0220633 20.014463,45.3037598 36.1058824,44.8148148 C52.1972736,44.305848 54.9092435,26.5344305 55.1294118,21.4814815 Z'
    id='Did'
    fill='#2F383B'
    fill-rule='nonzero'
    />
    <path
      d='M120.352941,21.4814815 C120.733893,13.8233491 107.439179,5.64243259 93.1764706,5.92592593 C78.9208736,6.22450879 77.0653236,15.3786982 76.8705882,18.8888889 C76.521758,27.0220633 85.2379924,45.3037598 101.329412,44.8148148 C117.420803,44.305848 120.132773,26.5344305 120.352941,21.4814815 Z'
    id='Courtney'
    fill='#2F383B'
    fill-rule='nonzero'
    transform='translate(98.611765, 25.370370) scale(-1, 1) translate(-98.611765, -25.370370) '
      />
      </g>
      </g>`;
  }

  private static getPresciption01() {
    return `
    <g
    id='Top/_Resources/Prescription-01'
    fill='none'
    transform='translate(62.000000, 85.000000)'
    stroke-width='1'>
    <defs>
      <filter
        x='-0.8%'
    y='-2.4%'
    width='101.5%'
    height='109.8%'
    filterUnits='objectBoundingBox'
    id='pres_filter1'>
    <feOffset
      dx='0'
    dy='2'
    in='SourceAlpha'
    result='shadowOffsetOuter1'
    />
    <feColorMatrix
      values='0 0 0 0 0   0 0 0 0 0   0 0 0 0 0  0 0 0 0.2 0'
    type='matrix'
    in='shadowOffsetOuter1'
    result='shadowMatrixOuter1'
    />
    <feMerge>
      <feMergeNode in='shadowMatrixOuter1' />
    <feMergeNode in='SourceGraphic' />
      </feMerge>
      </filter>
      </defs>
      <g
    id='Glasses'
    filter='url(#pres_filter1)'
    transform='translate(8.000000, 8.000000)'
    fill='#D6EAF2'>
    <path
      d='M46.2491397,7.27516667 C48.6207695,7.2975 49.7419096,7.69183333 50.1459601,10.1651667 C50.5553446,12.6705 50.1572949,15.4871667 49.6852359,17.9548333 C48.9648125,21.7228333 47.7666627,25.4145 44.9776475,28.1685 C43.5084639,29.6188333 41.7165732,30.7748333 39.8106684,31.5641667 C38.7985419,31.9835 37.7297416,32.2861667 36.6612747,32.5158333 C36.3489024,32.5828333 33.6822357,32.9501667 35.3177735,32.7635 C31.5009631,33.1991667 27.3601122,33.1818333 24.1723805,30.7525 C20.6396056,28.0601667 18.2203032,23.7998333 17.1565036,19.5561667 C16.5340925,17.0731667 15.2262624,11.1345 17.6158944,9.14916667 C20.3532365,6.8745 46.2491397,7.27516667 46.2491397,7.27516667 L46.2491397,7.27516667 Z M22.2178029,0.4905 C16.7774562,0.677833333 13.1466691,1.63383333 10.4633337,7.06916667 C5.54571911,17.0301667 13.9627711,31.9688333 23.352278,36.0395 C34.3293166,40.7991667 46.5921826,35.5318333 52.3955746,26.0058333 C55.4689587,20.9621667 57.0224862,13.3231667 56.9224737,7.50383333 C56.7951245,0.0765 51.6071427,-0.1295 45.5090472,0.0338333333 L22.2178029,0.4905 Z'
    id='Frame-Stuff'
    />
    <path
      d='M79.6805515,7.27256667 C77.3089217,7.29523333 76.1877816,7.68923333 75.7837311,10.1625667 C75.3743466,12.6679 75.7723963,15.4845667 76.244122,17.9522333 C76.9648787,21.7202333 78.1630285,25.4119 80.9520437,28.1659 C82.4212273,29.6162333 84.213118,30.7722333 86.1190228,31.5619 C87.1311493,31.9809 88.1999496,32.2835667 89.2684165,32.5132333 C89.5807888,32.5802333 92.2471221,32.9479 90.6119177,32.7609 C94.4287281,33.1965667 98.569579,33.1792333 101.757311,30.7499 C105.290086,28.0575667 107.709388,23.7975667 108.773188,19.5539 C109.395599,17.0705667 110.703095,11.1322333 108.313797,9.14656667 C105.576455,6.8719 79.6805515,7.27256667 79.6805515,7.27256667 L79.6805515,7.27256667 Z M103.711555,0.4879 C109.152235,0.675233333 112.783022,1.63156667 115.466357,7.06656667 C120.383639,17.0275667 111.96692,31.9662333 102.577413,36.0372333 C91.6003746,40.7965667 79.3375086,35.5292333 73.5337832,26.0035667 C70.4607325,20.9595667 68.907205,13.3205667 69.0068841,7.50123333 C69.1345667,0.0739 74.3225485,-0.1321 80.420644,0.0315666667 L103.711555,0.4879 Z'
    id='Frame-Stuff'
    />
    <path
      d='M13.1969483,4.9267 C9.78501392,5.11836667 5.88606327,5.16436667 2.69005822,6.63936667 C-0.69461078,8.20136667 -1.2176675,11.7387 3.04920921,12.2260333 C4.97094906,12.4457 6.89488267,12.0827 8.78716336,11.7450333 C10.336903,11.4683667 12.4419791,11.5580333 13.9064752,10.9657 C16.6355213,9.86236667 16.4603333,4.74003333 13.1969483,4.9267'
    id='Frame-Stuff'
    />
    <path
      d='M112.73467,4.9267 C116.146606,5.11836667 120.045559,5.16436667 123.241565,6.63936667 C126.626236,8.20136667 127.149293,11.7387 122.882414,12.2260333 C120.960673,12.4457 119.036739,12.0827 117.144457,11.7450333 C115.594717,11.4683667 113.489639,11.5580333 112.025143,10.9657 C109.295782,9.86236667 109.471283,4.74003333 112.73467,4.9267'
    id='Frame-Stuff'
    />
    <path
      d='M73.1094302,7.01263333 C71.1631869,4.71263333 66.0912197,3.38463333 62.8914864,3.38463333 C59.6914198,3.38463333 54.7681378,4.71263333 52.8222279,7.01263333 C51.8407719,8.1723 51.8074344,9.72396667 53.5083137,10.4509667 C55.6262451,11.3566333 57.5174814,9.7143 59.2126933,8.8553 C61.3809643,7.75663333 64.7120473,7.8773 66.7189648,8.8553 C68.4271783,9.68796667 70.3050797,11.3566333 72.4233444,10.4509667 C74.1242237,9.72396667 74.0908862,8.1723 73.1094302,7.01263333'
    id='Frame-Stuff'
      />
      </g>
      </g>`;
  }

  private static getPresciption02() {
    return `
    <g
    id='Top/_Resources/Prescription-02'
    fill='none'
    transform='translate(62.000000, 85.000000)'
    stroke-width='1'>
    <defs>
      <filter
        x='-0.8%'
    y='-2.4%'
    width='101.5%'
    height='109.8%'
    filterUnits='objectBoundingBox'
    id='pres_filter2'>
    <feOffset
      dx='0'
    dy='2'
    in='SourceAlpha'
    result='shadowOffsetOuter1'
    />
    <feColorMatrix
      values='0 0 0 0 0   0 0 0 0 0   0 0 0 0 0  0 0 0 0.2 0'
    type='matrix'
    in='shadowOffsetOuter1'
    result='shadowMatrixOuter1'
    />
    <feMerge>
      <feMergeNode in='shadowMatrixOuter1' />
    <feMergeNode in='SourceGraphic' />
      </feMerge>
      </filter>
      </defs>
      <g
    id='Wayfarers'
    filter='url(#pres_filter2)'
    transform='translate(6.000000, 7.000000)'
    fill='#252C2F'>
    <path
      d='M34,41 L31.2421498,41 C17.3147125,41 9,33.3359286 9,20.5 C9,10.127 10.8170058,0 32.5299306,0 L35.4700694,0 C57.1829942,0 59,10.127 59,20.5 C59,32.5686429 48.7212748,41 34,41 Z M32.3853606,6 C13,6 13,12.8410159 13,21.5015498 C13,28.5719428 16.116254,37 30.9709365,37 L34,37 C46.3649085,37 55,30.6270373 55,21.5015498 C55,12.8410159 55,6 35.6146394,6 L32.3853606,6 Z'
    id='Left'
    fill-rule='nonzero'
    />
    <path
      d='M96,41 L93.2421498,41 C79.3147125,41 71,33.3359286 71,20.5 C71,10.127 72.8170058,0 94.5299306,0 L97.4700694,0 C119.182994,0 121,10.127 121,20.5 C121,32.5686429 110.721275,41 96,41 Z M94.3853606,6 C75,6 75,12.8410159 75,21.5015498 C75,28.5719428 78.1194833,37 92.9709365,37 L96,37 C108.364909,37 117,30.6270373 117,21.5015498 C117,12.8410159 117,6 97.6146394,6 L94.3853606,6 Z'
    id='Right'
    fill-rule='nonzero'
    />
    <path
      d='M2.95454545,5.77156439 C3.64590909,5.09629136 11.2095455,0 32.5,0 C50.3513636,0 54.1302273,1.85267217 59.8502273,4.6518809 L60.2689233,4.85850899 C60.6666014,4.99901896 62.7002447,5.68982981 65.0790606,5.76579519 C67.2462948,5.67278567 69.1000195,5.08540191 69.641698,4.89719767 C76.1703915,1.7220864 82.5610971,0 97.5,0 C118.790455,0 126.354091,5.09629136 127.045455,5.77156439 C128.679318,5.77156439 130,7.06150904 130,8.65734659 L130,11.5431288 C130,13.1389663 128.679318,14.428911 127.045455,14.428911 C127.045455,14.428911 120.143997,14.428911 120.143997,17.3146932 C120.143997,20.2004754 118.181818,13.1389663 118.181818,11.5431288 L118.181818,8.73240251 C114.578575,7.35340151 108.128411,4.78617535 97.5,4.78617535 C85.6584651,4.78617535 79.7610984,6.88602813 74.7022935,8.97112368 L74.7588636,9.10752861 L74.7563667,11.0937608 L72.5391666,16.4436339 L69.8004908,15.3608351 C69.5558969,15.2641292 69.0281396,15.090392 68.2963505,14.9099044 C66.256272,14.4067419 64.1589087,14.253569 62.3040836,14.6343084 C61.6235903,14.7739931 60.9922286,14.9836085 60.4128127,15.266732 L57.7704824,16.5578701 L55.1266751,11.3962031 L55.2440909,9.10175705 L55.3248203,8.90683855 C50.9620526,6.87386374 46.9392639,4.78617535 32.5,4.78617535 C21.8721459,4.78617535 15.422131,7.3524397 11.8181818,8.7314671 L11.8181818,11.5431288 C11.8181818,13.1389663 8.86363636,20.2004754 8.86363636,17.3146932 C8.86363636,14.428911 2.95454545,14.428911 2.95454545,14.428911 C1.32363636,14.428911 0,13.1389663 0,11.5431288 L0,8.65734659 C0,7.06150904 1.32363636,5.77156439 2.95454545,5.77156439 Z'
    id='Stuff'
    fill-rule='nonzero'
      />
      </g>
      </g>`;
  }

  private static getRound() {
    return `
    <g
    id='Top/_Resources/Round'
    fill='none'
    transform='translate(62.000000, 85.000000)'>
    <defs>
      <path
        d='M80.4646192,16.3941179 C84.3801509,8.45869677 92.552602,3 102,3 C110.919691,3 118.702887,7.86591082 122.839921,15.0880638 C123.050197,15.0306504 123.271519,15 123.5,15 L131.5,15 C132.880712,15 134,16.1192881 134,17.5 C134,18.8807119 132.880712,20 131.5,20 L124.963126,20 C125.637355,22.2145921 126,24.5649459 126,27 C126,40.254834 115.254834,51 102,51 C88.745166,51 78,40.254834 78,27 C78,25.5781066 78.1236513,24.1850936 78.3607874,22.8311273 C78.2762458,18.4553035 74.9135957,15 70.8624171,15 C67.1256697,15 63.9747186,17.9397535 63.4417635,21.8300629 C63.8073299,23.4951922 64,25.2250958 64,27 C64,40.254834 53.254834,51 40,51 C26.745166,51 16,40.254834 16,27 C16,24.5649459 16.3626451,22.2145921 17.0368738,20 L10.5,20 C9.11928813,20 8,18.8807119 8,17.5 C8,16.1192881 9.11928813,15 10.5,15 L10.5,15 L18.5,15 C18.728481,15 18.9498033,15.0306504 19.1600793,15.0880638 C23.2971127,7.86591082 31.0803092,3 40,3 C49.3521568,3 57.4549431,8.34919095 61.415666,16.15488 C63.4929212,13.0392725 66.9494432,11 70.8624171,11 C74.8746823,11 78.4070368,13.1440781 80.4646192,16.3941179 Z M40,47 C51.045695,47 60,38.045695 60,27 C60,15.954305 51.045695,7 40,7 C28.954305,7 20,15.954305 20,27 C20,38.045695 28.954305,47 40,47 Z M102,47 C113.045695,47 122,38.045695 122,27 C122,15.954305 113.045695,7 102,7 C90.954305,7 82,15.954305 82,27 C82,38.045695 90.954305,47 102,47 Z'
    id='round_path'
    />
    <filter
      x='-0.8%'
    y='-2.1%'
    width='101.6%'
    height='108.3%'
    filterUnits='objectBoundingBox'
    id='round_id'>
    <feOffset
      dx='0'
    dy='2'
    in='SourceAlpha'
    result='shadowOffsetOuter1'
    />
    <feColorMatrix
      values='0 0 0 0 0   0 0 0 0 0   0 0 0 0 0  0 0 0 0.1 0'
    type='matrix'
    in='shadowOffsetOuter1'
      />
      </filter>
      </defs>
      <g id='Lennon-Glasses'>
    <use
      fill='black'
    fill-opacity='1'
    filter='url(#round_id)'
    href='#round_path'
    />
    <use fill='#252C2F' fill-rule='evenodd' href='#round_path' />
      </g>
      </g>`;
  }

  private static getSunglasses() {
    return `
    <g
    id='Top/_Resources/Sunglasses'
    fill='none'
    transform='translate(62.000000, 85.000000)'
    stroke-width='1'>
    <defs>
      <filter
        x='-0.8%'
    y='-2.6%'
    width='101.6%'
    height='110.5%'
    filterUnits='objectBoundingBox'
    id='sunglasses_filter'>
    <feOffset
      dx='0'
    dy='2'
    in='SourceAlpha'
    result='shadowOffsetOuter1'
    />
    <feColorMatrix
      values='0 0 0 0 0   0 0 0 0 0   0 0 0 0 0  0 0 0 0.1 0'
    type='matrix'
    in='shadowOffsetOuter1'
    result='shadowMatrixOuter1'
    />
    <feMerge>
      <feMergeNode in='shadowMatrixOuter1' />
    <feMergeNode in='SourceGraphic' />
      </feMerge>
      </filter>
      <path
    d='M47.0104611,6.27728008 C49.5212682,6.30134922 50.7082016,6.72633117 51.1359635,9.39189846 C51.5693724,12.0919529 51.1479634,15.1275382 50.648202,17.7869984 C49.8855011,21.8478573 48.6170388,25.8264499 45.6643523,28.794498 C44.1089507,30.3575551 42.2119044,31.6034024 40.1941529,32.4540848 C39.1226305,32.9060098 37.9911085,33.2322006 36.8599395,33.4797175 C36.5292357,33.5519249 33.7060778,33.9478084 35.4375958,33.7466335 C31.3967988,34.2161613 27.0129452,34.1974808 23.6381438,31.5793333 C19.8980507,28.6777448 17.3367734,24.0862872 16.2105455,19.5127916 C15.5516086,16.8368063 14.1670294,10.4365709 16.6968952,8.29693227 C19.5948762,5.84547255 47.0104611,6.27728008 47.0104611,6.27728008 L47.0104611,6.27728008 Z'
    id='sunglasses_path1'
    />
    <path
      d='M78.9192315,6.27468008 C76.4084239,6.29910846 75.2214902,6.72373117 74.7937283,9.38929846 C74.3603192,12.0893529 74.7817283,15.1249382 75.2811369,17.7843984 C76.0441909,21.8452573 77.3126534,25.8238499 80.2653406,28.791898 C81.8207425,30.3549551 83.7177893,31.6008024 85.7355412,32.4518441 C86.8070638,32.9034098 87.938586,33.2296006 89.0697553,33.4771175 C89.4004591,33.5493249 92.2232647,33.9455676 90.4920992,33.7440335 C94.5328971,34.2135613 98.9167517,34.1948808 102.291554,31.5767333 C106.031648,28.6751448 108.592926,24.0840464 109.719154,19.5105508 C110.378091,16.8342063 111.762317,10.4343302 109.232804,8.29433227 C106.334822,5.84287255 78.9192315,6.27468008 78.9192315,6.27468008 L78.9192315,6.27468008 Z'
    id='sunglasses_path2'
    />
    <linearGradient
      x1='50%'
    y1='0%'
    x2='50%'
    y2='70.5058195%'
    id='linearGradient1'>
    <stop stop-color='#FFFFFF' stop-opacity='0.5' offset='0%' />
    <stop stop-color='#000000' stop-opacity='0.5' offset='100%' />
      </linearGradient>
      <linearGradient
    x1='50%'
    y1='0%'
    x2='50%'
    y2='100%'
    id='linearGradient2'>
    <stop stop-color='#FFFFFF' stop-opacity='0.5' offset='0%' />
    <stop stop-color='#000000' stop-opacity='0.5' offset='70.5058195%' />
      </linearGradient>
      </defs>
      <g
    id='Sunglasses'
    filter='url(#sunglasses_filter)'
    transform='translate(8.000000, 8.000000)'>
    <g id='shades'>
    <use
      fill-opacity='0.700000048'
    fill='#000000'
    href='#sunglasses_path1'
    />
    <use
      fill='url(#linearGradient1)'
    style="'mix-blend-mode': 'screen'"
    href='#sunglasses_path1'
      />
      </g>
      <g id='shades'>
    <use
      fill-opacity='0.700000048'
    fill='#000000'
    href='#sunglasses_path1'
    />
    <use
      fill="url(#linearGradient2)"
    style="'mix-blend-mode': 'screen'"
    href='#sunglasses_path2'
      />
      </g>
      <g id='Glasses' fill='#252C2F'>
    <path
      d='M46.2491397,7.27516667 C48.6207695,7.2975 49.7419096,7.69183333 50.1459601,10.1651667 C50.5553446,12.6705 50.1572949,15.4871667 49.6852359,17.9548333 C48.9648125,21.7228333 47.7666627,25.4145 44.9776475,28.1685 C43.5084639,29.6188333 41.7165732,30.7748333 39.8106684,31.5641667 C38.7985419,31.9835 37.7297416,32.2861667 36.6612747,32.5158333 C36.3489024,32.5828333 33.6822357,32.9501667 35.3177735,32.7635 C31.5009631,33.1991667 27.3601122,33.1818333 24.1723805,30.7525 C20.6396056,28.0601667 18.2203032,23.7998333 17.1565036,19.5561667 C16.5340925,17.0731667 15.2262624,11.1345 17.6158944,9.14916667 C20.3532365,6.8745 46.2491397,7.27516667 46.2491397,7.27516667 L46.2491397,7.27516667 Z M22.2178029,0.4905 C16.7774562,0.677833333 13.1466691,1.63383333 10.4633337,7.06916667 C5.54571911,17.0301667 13.9627711,31.9688333 23.352278,36.0395 C34.3293166,40.7991667 46.5921826,35.5318333 52.3955746,26.0058333 C55.4689587,20.9621667 57.0224862,13.3231667 56.9224737,7.50383333 C56.7951245,0.0765 51.6071427,-0.1295 45.5090472,0.0338333333 L22.2178029,0.4905 Z'
    id='Frame'
    />
    <path
      d='M79.6805515,7.27256667 C77.3089217,7.29523333 76.1877816,7.68923333 75.7837311,10.1625667 C75.3743466,12.6679 75.7723963,15.4845667 76.244122,17.9522333 C76.9648787,21.7202333 78.1630285,25.4119 80.9520437,28.1659 C82.4212273,29.6162333 84.213118,30.7722333 86.1190228,31.5619 C87.1311493,31.9809 88.1999496,32.2835667 89.2684165,32.5132333 C89.5807888,32.5802333 92.2471221,32.9479 90.6119177,32.7609 C94.4287281,33.1965667 98.569579,33.1792333 101.757311,30.7499 C105.290086,28.0575667 107.709388,23.7975667 108.773188,19.5539 C109.395599,17.0705667 110.703095,11.1322333 108.313797,9.14656667 C105.576455,6.8719 79.6805515,7.27256667 79.6805515,7.27256667 L79.6805515,7.27256667 Z M103.711555,0.4879 C109.152235,0.675233333 112.783022,1.63156667 115.466357,7.06656667 C120.383639,17.0275667 111.96692,31.9662333 102.577413,36.0372333 C91.6003746,40.7965667 79.3375086,35.5292333 73.5337832,26.0035667 C70.4607325,20.9595667 68.907205,13.3205667 69.0068841,7.50123333 C69.1345667,0.0739 74.3225485,-0.1321 80.420644,0.0315666667 L103.711555,0.4879 Z'
    id='Frame'
    />
    <path
      d='M13.1969483,4.9267 C9.78501392,5.11836667 5.88606327,5.16436667 2.69005822,6.63936667 C-0.69461078,8.20136667 -1.2176675,11.7387 3.04920921,12.2260333 C4.97094906,12.4457 6.89488267,12.0827 8.78716336,11.7450333 C10.336903,11.4683667 12.4419791,11.5580333 13.9064752,10.9657 C16.6355213,9.86236667 16.4603333,4.74003333 13.1969483,4.9267'
    id='Frame'
    />
    <path
      d='M112.73467,4.9267 C116.146606,5.11836667 120.045559,5.16436667 123.241565,6.63936667 C126.626236,8.20136667 127.149293,11.7387 122.882414,12.2260333 C120.960673,12.4457 119.036739,12.0827 117.144457,11.7450333 C115.594717,11.4683667 113.489639,11.5580333 112.025143,10.9657 C109.295782,9.86236667 109.471283,4.74003333 112.73467,4.9267'
    id='Frame'
    />
    <path
      d='M73.1094302,7.01263333 C71.1631869,4.71263333 66.0912197,3.38463333 62.8914864,3.38463333 C59.6914198,3.38463333 54.7681378,4.71263333 52.8222279,7.01263333 C51.8407719,8.1723 51.8074344,9.72396667 53.5083137,10.4509667 C55.6262451,11.3566333 57.5174814,9.7143 59.2126933,8.8553 C61.3809643,7.75663333 64.7120473,7.8773 66.7189648,8.8553 C68.4271783,9.68796667 70.3050797,11.3566333 72.4233444,10.4509667 C74.1242237,9.72396667 74.0908862,8.1723 73.1094302,7.01263333'
    id='Frame'
      />
      </g>
      </g>
      </g>`;
  }

  private static getWayfarers() {
    return `
    <g
    id='Top/_Resources/Wayfarers'
    fill='none'
    transform='translate(62.000000, 85.000000)'
    stroke-width='1'>
    <defs>
      <filter
        x='-0.8%'
    y='-2.4%'
    width='101.6%'
    height='109.8%'
    filterUnits='objectBoundingBox'
    id='way_filter'>
    <feOffset
      dx='0'
    dy='2'
    in='SourceAlpha'
    result='shadowOffsetOuter1'
    />
    <feColorMatrix
      values='0 0 0 0 0   0 0 0 0 0   0 0 0 0 0  0 0 0 0.2 0'
    type='matrix'
    in='shadowOffsetOuter1'
    result='shadowMatrixOuter1'
    />
    <feMerge>
      <feMergeNode in='shadowMatrixOuter1' />
    <feMergeNode in='SourceGraphic' />
      </feMerge>
      </filter>
      <linearGradient
    x1='50%'
    y1='0%'
    x2='50%'
    y2='100%'
    id='linearGradient1'>
    <stop stop-color='#FFFFFF' stop-opacity='0.5' offset='0%' />
    <stop stop-color='#000000' stop-opacity='0.5' offset='70.5058195%' />
      </linearGradient>
      <path
    d='M44.9178864,17.5714286 C44.9178864,27.2737857 36.66775,35.1428571 22.9204545,35.1428571 L20.1704091,35.1428571 C6.42311364,35.1428571 0.923022727,27.2708571 0.923022727,17.5714286 L0.923022727,17.5714286 C0.923022727,7.86614286 2.20715909,0 21.4545455,0 L24.3863636,0 C43.63375,0 44.9178864,7.86614286 44.9178864,17.5714286 L44.9178864,17.5714286 Z'
    id='way_path1'
    />
    <path
      d='M106.486068,17.5714286 C106.486068,27.2737857 98.2388636,35.1428571 84.4886364,35.1428571 L81.7385909,35.1428571 C67.9912955,35.1428571 62.4912045,27.2708571 62.4912045,17.5714286 L62.4912045,17.5714286 C62.4912045,7.86614286 63.7753409,0 83.0227273,0 L85.9545455,0 C105.199,0 106.486068,7.86614286 106.486068,17.5714286 L106.486068,17.5714286 Z'
    id='way_path2'
      />
      </defs>
      <g
    id='Wayfarers'
    filter='url(#way_filter)'
    transform='translate(7.000000, 7.000000)'>
    <g
      id='Shades'
    transform='translate(10.795455, 2.928571)'
    fill-rule='nonzero'>
    <g id='Shade'>
    <use
      fill-opacity='0.700000048'
    fill='#000000'
    fill-rule='evenodd'
    href='#way_path1'
    />
    <use
      fill='url(#linearGradient1)'
    fill-rule='evenodd'
    style="'mix-blend-mode: 'screen"
    href='#way_path1'
      />
      </g>
      <g id='Shade'>
    <use
      fill-opacity='0.700000048'
    fill='#000000'
    fill-rule='evenodd'
    href='#way_path2'
    />
    <use
      fill='url(#linearGradient1)'
    fill-rule='evenodd'
    style="'mix-blend-mode: screen'"
    href='#way_path2'
      />
      </g>
      </g>
      <path
    d='M33.7159091,41 L30.9658636,41 C17.0778409,41 8.78665909,33.3359286 8.78665909,20.5 C8.78665909,10.127 10.5985227,0 32.25,0 L35.1818182,0 C56.8332955,0 58.6451591,10.127 58.6451591,20.5 C58.6451591,32.5686429 48.3955227,41 33.7159091,41 Z M32.25,5.85421429 C14.6502955,5.85421429 14.6502955,12.3175714 14.6502955,20.5 C14.6502955,27.1800714 17.4795,35.1428571 30.9658636,35.1428571 L33.7159091,35.1428571 C44.9418409,35.1428571 52.7815227,29.1217143 52.7815227,20.5 C52.7815227,12.3175714 52.7815227,5.85421429 35.1818182,5.85421429 L32.25,5.85421429 Z'
    id='Left'
    fill='#252C2F'
    fill-rule='nonzero'
    />
    <path
      d='M95.2840909,41 L92.5340455,41 C78.6460227,41 70.3548409,33.3359286 70.3548409,20.5 C70.3548409,10.127 72.1667045,0 93.8181818,0 L96.75,0 C118.401477,0 120.213341,10.127 120.213341,20.5 C120.213341,32.5686429 109.963705,41 95.2840909,41 Z M93.8181818,5.85421429 C76.2184773,5.85421429 76.2184773,12.3175714 76.2184773,20.5 C76.2184773,27.1800714 79.0506136,35.1428571 92.5340455,35.1428571 L95.2840909,35.1428571 C106.510023,35.1428571 114.349705,29.1217143 114.349705,20.5 C114.349705,12.3175714 114.349705,5.85421429 96.75,5.85421429 L93.8181818,5.85421429 Z'
    id='Right'
    fill='#252C2F'
    fill-rule='nonzero'
    />
    <path
      d='M2.93181818,5.85714286 C3.61786364,5.17185714 11.1233182,0 32.25,0 C49.9640455,0 53.7138409,1.88014286 59.3898409,4.72085714 L59.8053162,4.93054903 C60.1999353,5.07314243 62.2179351,5.77419634 64.5784525,5.85128811 C66.7290156,5.75689949 68.5684809,5.16080623 69.1059926,4.96981137 C75.5844654,1.74762081 81.9260118,0 96.75,0 C117.876682,0 125.382136,5.17185714 126.068182,5.85714286 C127.689477,5.85714286 129,7.16621429 129,8.78571429 L129,11.7142857 C129,13.3337857 127.689477,14.6428571 126.068182,14.6428571 C126.068182,14.6428571 120.204545,14.6428571 120.204545,17.5714286 C120.204545,20.5 117.272727,13.3337857 117.272727,11.7142857 L117.272727,8.8618831 C113.697201,7.46243482 107.296654,5.85714286 96.75,5.85714286 C84.9995538,5.85714286 79.1475515,6.98813142 74.1276604,9.10414393 L74.1837955,9.24257143 L71.6878772,10.2500422 L74.1813177,11.2582547 L71.981173,16.6874536 L69.263564,15.5885995 C69.0208516,15.4904597 68.4971539,15.3141463 67.770994,15.1309826 C65.7466083,14.6203594 63.6653786,14.4649153 61.8248214,14.8513001 C61.1495627,14.993056 60.5230576,15.2057795 59.9480988,15.4931011 L57.3260941,16.8033836 L54.7026238,11.5651815 L57.3246285,10.2548989 L57.3310023,10.251716 L54.8191364,9.23671429 L54.8992448,9.03890561 C50.5700368,6.97578666 46.5781927,5.85714286 32.25,5.85714286 C21.7038986,5.85714286 15.3034993,7.46145875 11.7272727,8.86093383 L11.7272727,11.7142857 C11.7272727,13.3337857 8.79545455,20.5 8.79545455,17.5714286 C8.79545455,14.6428571 2.93181818,14.6428571 2.93181818,14.6428571 C1.31345455,14.6428571 0,13.3337857 0,11.7142857 L0,8.78571429 C0,7.16621429 1.31345455,5.85714286 2.93181818,5.85714286 Z'
    id='Stuff'
    fill='#252C2F'
    fill-rule='nonzero'
      />
      </g>
      </g>`;
  }
}
