<div align="center">

  ![](./offical/assets/readme/logo_blue.png)

</div>

------

<div align="center">

![](https://img.shields.io/badge/node-%3E%3D9.0.0-brightgreen.svg) ![](https://img.shields.io/badge/npm-%3E%3D6.1.0-brightgreen.svg) ![](https://img.shields.io/appveyor/ci/gruntjs/grunt.svg)  ![](https://img.shields.io/badge/stable-v1.0.3-blue.svg) ![](https://img.shields.io/badge/alpha-v1.0.4-blue.svg) ![](https://img.shields.io/npm/l/express.svg)

</div>
<div align="center">

为开发者、设计师和产品经理准备的 UI 设计语言


</div>

## 预告

Shine Design 即将迎来重大更新，新版本（2.0）将带来更全面的组件系统，和更丰富的样式选择，尽请期待！

* 全新支持 `Typescript`，输出多版本的组件库。
* 全新 `视觉` 与 `交互` 的设计方案，提供可视化工具，实现不同业务的千人千面。
* 组件数量大幅增加，将扩展到 **30+** 个组件。
* `React` 版本升级，支持全新的语法。

美好的事情值得我们等待。

## 功能特性
* 开箱即用的高质量组件，为开发者、设计师和产品经理提供丰富的创意和思路。
* 兼容 IE, Chrome 和 Firefox 等绝大部分主流浏览器，为用户带来统一的视觉体验。
* 拥有全链路开发和设计工具体系，永久免费。

## 快速构建

推荐使用快速构建工具  `Shined CLI`  搭建项目，只需依次执行：
 ![](./offical/assets/readme/tools.png)
> 构建工具具体用法清参考[构建工具说明](https://shine.design/cli)。

## 使用示例

Shine Design 入门比你想象的更简单, **你只需做如下事情**:
![](./offical/assets/readme/code.png)

>  我们提供了丰富的组件供开发者使用，可以查看[组件文档](https://shine.design/tutorial)。

## 调试与部署

快速构建工具已经集成了一键式调试与部署指令，只需执行如下命令即可实现开发环境下的调试和生产环境的部署：
![](./offical/assets/readme/command.png)

>  开发环境下启动调试后，在浏览器中打开 [http://127.0.0.1:3000](http://127.0.0.1:3000) 查看效果。

## 更新日志
您可以从 [更新日志](https://github.com/shine-design/shine-design/releases) 获取相关版本信息。

## 发布周期
本项目更新参照 [Semantic Versioning 2.0.0](https://semver.org/) 标准进行：
- 修订版本：每周一个修订版本，用于进行日常的 Bug 修复（非紧急）。
- 次版本号：每一到两天发布一个次版本，次版本更新会向下兼容当前主版本。
- 主版本号：重大迭代工作，非周期性更新，与历史主版本不兼容。

## 获取帮助
如果您在使用的过程中碰到问题，可以通过下面几个途径寻求帮助：
* 我们提供了详细的[组件文档](https://shine.design/guide)，大部分问题都可以在文档中得以解决。
* 利用强大的 [Issue](https://github.com/qulongjun/Shine-Design/issues) 功能，您可以直接进行提问，我们会随时关注并解答，同时我们也鼓励资深用户通过 Issue 给新人提供帮助。

## 参与项目
我们很期待您能参与进来一起开发 :)，但我们希望您能遵守相关约定：
* 我们有一份[行为准则](./CODE_OF_CONDUCT.md)，希望所有的贡献者都能遵守，请花时间阅读一遍全文以确保您能明白哪些是可以做的，哪些是不可以做的。
* 基于我们的发布周期，我们每周都会从 `master` 分支切一个 `release` 分支出来，命名规则一般为 `release-版本号` ，例如 `release-1.0.0` 即将要发布的 `1.0.0` 版本。如果您进行了一个Bug修复，请直接 Pull Request 到当前的 `release` 分支，如果进行的是新功能开发，请 Pull Request 到 `master` 分支。
* 如果您有较好的创意，我们也欢迎您通过[Issue](https://github.com/qulongjun/Shine-Design/issues) 直接告诉我们。

## 联系我们
如果您需要联系我们，可以通过发送邮件至 [help@shine.design](mailto:help@shine.design) 。

## License
本项目基于 [MIT license](./LICENSE) 开源。
