// SPDX-FileCopyrightText: Copyright 2024 shadPS4 Emulator Project
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include "common/types.h"

namespace Core::Loader {
class SymbolsResolver;
}

namespace Libraries::NpManager {

constexpr int ORBIS_NP_ERROR_SIGNED_OUT = 0x80550006;

enum class OrbisNpState : u32 { Unknown = 0, SignedOut, SignedIn };

using OrbisNpStateCallbackForNpToolkit = PS4_SYSV_ABI void (*)(s32 userId, OrbisNpState state,
                                                               void* userdata);

constexpr int ORBIS_NP_ONLINEID_MAX_LENGTH = 16;

using OrbisUserServiceUserId = s32;

struct OrbisNpOnlineId {
    char data[ORBIS_NP_ONLINEID_MAX_LENGTH];
    char term;
    char dummy[3];
};

struct OrbisNpId {
    OrbisNpOnlineId handle;
    u8 opt[8];
    u8 reserved[8];
};

int PS4_SYSV_ABI Func_EF4378573542A508();
int PS4_SYSV_ABI _sceNpIpcCreateMemoryFromKernel();
int PS4_SYSV_ABI _sceNpIpcCreateMemoryFromPool();
int PS4_SYSV_ABI _sceNpIpcDestroyMemory();
int PS4_SYSV_ABI _sceNpIpcFreeImpl();
int PS4_SYSV_ABI _sceNpIpcGetNpMemAllocator();
int PS4_SYSV_ABI _sceNpIpcMallocImpl();
int PS4_SYSV_ABI _sceNpIpcReallocImpl();
int PS4_SYSV_ABI _sceNpManagerCreateMemoryFromKernel();
int PS4_SYSV_ABI _sceNpManagerCreateMemoryFromPool();
int PS4_SYSV_ABI _sceNpManagerDestroyMemory();
int PS4_SYSV_ABI _sceNpManagerFreeImpl();
int PS4_SYSV_ABI _sceNpManagerGetNpMemAllocator();
int PS4_SYSV_ABI _sceNpManagerMallocImpl();
int PS4_SYSV_ABI _sceNpManagerReallocImpl();
int PS4_SYSV_ABI _ZN3sce2np10NpOnlineId13GetNpOnlineIdERKNS0_4UserEP13SceNpOnlineId();
int PS4_SYSV_ABI _ZN3sce2np10NpOnlineId13GetNpOnlineIdERKNS0_4UserEPS1_();
int PS4_SYSV_ABI _ZN3sce2np10NpOnlineId16SetNpOnlineIdStrEPKc();
int PS4_SYSV_ABI _ZN3sce2np10NpOnlineId5ClearEv();
int PS4_SYSV_ABI _ZN3sce2np10NpOnlineIdC1ERK13SceNpOnlineId();
int PS4_SYSV_ABI _ZN3sce2np10NpOnlineIdC1ERKS1_();
int PS4_SYSV_ABI _ZN3sce2np10NpOnlineIdC1Ev();
int PS4_SYSV_ABI _ZN3sce2np10NpOnlineIdC2ERK13SceNpOnlineId();
int PS4_SYSV_ABI _ZN3sce2np10NpOnlineIdC2ERKS1_();
int PS4_SYSV_ABI _ZN3sce2np10NpOnlineIdC2Ev();
int PS4_SYSV_ABI _ZN3sce2np10NpOnlineIdD0Ev();
int PS4_SYSV_ABI _ZN3sce2np10NpOnlineIdD1Ev();
int PS4_SYSV_ABI _ZN3sce2np10NpOnlineIdD2Ev();
int PS4_SYSV_ABI _ZN3sce2np11NpHttpTrans13GetResultCodeEPNS0_6HandleE();
int PS4_SYSV_ABI _ZN3sce2np11NpHttpTrans21SetRequestAccessTokenEPNS0_6HandleE();
int PS4_SYSV_ABI _ZN3sce2np11NpHttpTrans24BuildAuthorizationHeaderERKNS0_13NpAccessTokenEPcm();
int PS4_SYSV_ABI _ZN3sce2np11NpHttpTransC2EP16SceNpAllocatorEx();
int PS4_SYSV_ABI _ZN3sce2np11NpHttpTransD0Ev();
int PS4_SYSV_ABI _ZN3sce2np11NpHttpTransD1Ev();
int PS4_SYSV_ABI _ZN3sce2np11NpHttpTransD2Ev();
int PS4_SYSV_ABI _ZN3sce2np12NpHttpClient4InitEii();
int PS4_SYSV_ABI _ZN3sce2np12NpHttpClientC1EP16SceNpAllocatorEx();
int PS4_SYSV_ABI _ZN3sce2np12NpHttpClientC2EP16SceNpAllocatorEx();
int PS4_SYSV_ABI _ZN3sce2np12NpHttpClientD0Ev();
int PS4_SYSV_ABI _ZN3sce2np12NpHttpClientD1Ev();
int PS4_SYSV_ABI _ZN3sce2np12NpHttpClientD2Ev();
int PS4_SYSV_ABI _ZN3sce2np12NpTitleToken5ClearEv();
int PS4_SYSV_ABI _ZN3sce2np12NpTitleTokenC1ERKS1_();
int PS4_SYSV_ABI _ZN3sce2np12NpTitleTokenC1Ev();
int PS4_SYSV_ABI _ZN3sce2np12NpTitleTokenC2ERKS1_();
int PS4_SYSV_ABI _ZN3sce2np12NpTitleTokenC2Ev();
int PS4_SYSV_ABI _ZN3sce2np12NpTitleTokenD0Ev();
int PS4_SYSV_ABI _ZN3sce2np12NpTitleTokenD1Ev();
int PS4_SYSV_ABI _ZN3sce2np12NpTitleTokenD2Ev();
int PS4_SYSV_ABI _ZN3sce2np13NpAccessToken14GetAccessTokenEPNS0_6HandleERKNS0_4UserEPS1_();
int PS4_SYSV_ABI _ZN3sce2np13NpAccessToken5ClearEv();
int PS4_SYSV_ABI _ZN3sce2np13NpAccessTokenC1ERK16SceNpAccessToken();
int PS4_SYSV_ABI _ZN3sce2np13NpAccessTokenC1ERKS1_();
int PS4_SYSV_ABI _ZN3sce2np13NpAccessTokenC1Ev();
int PS4_SYSV_ABI _ZN3sce2np13NpAccessTokenC2ERK16SceNpAccessToken();
int PS4_SYSV_ABI _ZN3sce2np13NpAccessTokenC2ERKS1_();
int PS4_SYSV_ABI _ZN3sce2np13NpAccessTokenC2Ev();
int PS4_SYSV_ABI _ZN3sce2np13NpAccessTokenD0Ev();
int PS4_SYSV_ABI _ZN3sce2np13NpAccessTokenD1Ev();
int PS4_SYSV_ABI _ZN3sce2np13NpAccessTokenD2Ev();
int PS4_SYSV_ABI _ZN3sce2np3ipc14service_client10EndRequestEii();
int PS4_SYSV_ABI _ZN3sce2np3ipc14service_client11InitServiceEi();
int PS4_SYSV_ABI _ZN3sce2np3ipc14service_client11TermServiceEi();
int PS4_SYSV_ABI _ZN3sce2np3ipc14service_client11WaitRequestEiij();
int PS4_SYSV_ABI _ZN3sce2np3ipc14service_client12AbortRequestEii();
int PS4_SYSV_ABI _ZN3sce2np3ipc14service_client12BeginRequestEii();
int PS4_SYSV_ABI _ZN3sce2np3ipc14service_client13CreateRequestEimPKvPi();
int PS4_SYSV_ABI _ZN3sce2np3ipc14service_client13DeleteRequestEii();
int PS4_SYSV_ABI _ZN3sce2np3ipc14service_client13GetIpmiClientEv();
int PS4_SYSV_ABI _ZN3sce2np3ipc14service_client13PollEventFlagEijmjPm();
int PS4_SYSV_ABI _ZN3sce2np3ipc14service_client14PollEventQueueEiPvm();
int PS4_SYSV_ABI _ZN3sce2np4NpId5ClearEv();
int PS4_SYSV_ABI _ZN3sce2np4NpIdC1ERK7SceNpId();
int PS4_SYSV_ABI _ZN3sce2np4NpIdC1ERKS1_();
int PS4_SYSV_ABI _ZN3sce2np4NpIdC1Ev();
int PS4_SYSV_ABI _ZN3sce2np4NpIdC2ERK7SceNpId();
int PS4_SYSV_ABI _ZN3sce2np4NpIdC2ERKS1_();
int PS4_SYSV_ABI _ZN3sce2np4NpIdC2Ev();
int PS4_SYSV_ABI _ZN3sce2np4NpIdD0Ev();
int PS4_SYSV_ABI _ZN3sce2np4NpIdD1Ev();
int PS4_SYSV_ABI _ZN3sce2np4NpIdD2Ev();
int PS4_SYSV_ABI _ZN3sce2np4User5ClearEv();
int PS4_SYSV_ABI _ZN3sce2np4User7GetUserEiPS1_();
int PS4_SYSV_ABI _ZN3sce2np4UserC1Ei();
int PS4_SYSV_ABI _ZN3sce2np4UserC1ERKS1_();
int PS4_SYSV_ABI _ZN3sce2np4UserC1Ev();
int PS4_SYSV_ABI _ZN3sce2np4UserC2Ei();
int PS4_SYSV_ABI _ZN3sce2np4UserC2ERKS1_();
int PS4_SYSV_ABI _ZN3sce2np4UserC2Ev();
int PS4_SYSV_ABI _ZN3sce2np4UserD0Ev();
int PS4_SYSV_ABI _ZN3sce2np4UserD1Ev();
int PS4_SYSV_ABI _ZN3sce2np4UserD2Ev();
int PS4_SYSV_ABI _ZN3sce2np8NpTicket5ClearEv();
int PS4_SYSV_ABI _ZN3sce2np8NpTicketD0Ev();
int PS4_SYSV_ABI _ZN3sce2np8NpTicketD1Ev();
int PS4_SYSV_ABI _ZN3sce2np8NpTicketD2Ev();
int PS4_SYSV_ABI _ZN3sce2npeqERK13SceNpOnlineIdRKNS0_10NpOnlineIdE();
int PS4_SYSV_ABI _ZN3sce2npeqERKNS0_10NpOnlineIdERK13SceNpOnlineId();
int PS4_SYSV_ABI _ZN3sce2npeqERKNS0_10NpOnlineIdES3_();
int PS4_SYSV_ABI _ZN3sce2npeqERKNS0_4UserERKi();
int PS4_SYSV_ABI _ZN3sce2npeqERKNS0_4UserES3_();
int PS4_SYSV_ABI _ZN3sce2npneERK13SceNpOnlineIdRKNS0_10NpOnlineIdE();
int PS4_SYSV_ABI _ZN3sce2npneERKNS0_10NpOnlineIdERK13SceNpOnlineId();
int PS4_SYSV_ABI _ZN3sce2npneERKNS0_10NpOnlineIdES3_();
int PS4_SYSV_ABI _ZN3sce2npneERKNS0_4UserERKi();
int PS4_SYSV_ABI _ZN3sce2npneERKNS0_4UserES3_();
int PS4_SYSV_ABI _ZNK3sce2np10NpOnlineId7IsEmptyEv();
int PS4_SYSV_ABI _ZNK3sce2np12NpTitleToken6GetStrEv();
int PS4_SYSV_ABI _ZNK3sce2np13NpAccessToken7IsEmptyEv();
int PS4_SYSV_ABI _ZNK3sce2np4User10IsLoggedInEv();
int PS4_SYSV_ABI _ZNK3sce2np4User12GetAccountIdEPm();
int PS4_SYSV_ABI _ZNK3sce2np4User12HasAccountIdEPb();
int PS4_SYSV_ABI _ZNK3sce2np4User25GetAccountIdFromRegistoryEPm();
int PS4_SYSV_ABI _ZNK3sce2np4User7IsEmptyEv();
int PS4_SYSV_ABI _ZNK3sce2np4User7IsGuestEv();
int PS4_SYSV_ABI _ZNK3sce2np4User9GetUserIdEv();
int PS4_SYSV_ABI _ZNK3sce2np8NpTicket13GetTicketDataEv();
int PS4_SYSV_ABI _ZNK3sce2np8NpTicket13GetTicketSizeEv();
int PS4_SYSV_ABI _ZThn16_N3sce2np11NpHttpTransD0Ev();
int PS4_SYSV_ABI _ZThn16_N3sce2np11NpHttpTransD1Ev();
int PS4_SYSV_ABI _ZThn8_N3sce2np11NpHttpTransD0Ev();
int PS4_SYSV_ABI _ZThn8_N3sce2np11NpHttpTransD1Ev();
int PS4_SYSV_ABI sceNpAbortRequest();
int PS4_SYSV_ABI sceNpAsmAbort();
int PS4_SYSV_ABI sceNpAsmClientAbortRequest();
int PS4_SYSV_ABI sceNpAsmClientClearNpTitleToken();
int PS4_SYSV_ABI sceNpAsmClientClearNpTitleTokenA();
int PS4_SYSV_ABI sceNpAsmClientCreateRequest2();
int PS4_SYSV_ABI sceNpAsmClientCreateResourceContext();
int PS4_SYSV_ABI sceNpAsmClientCreateResourceContext2();
int PS4_SYSV_ABI sceNpAsmClientDeleteRequest();
int PS4_SYSV_ABI sceNpAsmClientDeleteResourceContext();
int PS4_SYSV_ABI sceNpAsmClientDeleteResourceContext2();
int PS4_SYSV_ABI sceNpAsmClientGetAppId();
int PS4_SYSV_ABI sceNpAsmClientGetCacheControlMaxAge();
int PS4_SYSV_ABI sceNpAsmClientGetGameNpTitleInfo();
int PS4_SYSV_ABI sceNpAsmClientGetGameNpTitleToken();
int PS4_SYSV_ABI sceNpAsmClientGetGameTitleBanInfo();
int PS4_SYSV_ABI sceNpAsmClientGetNpComInfo2();
int PS4_SYSV_ABI sceNpAsmClientGetNpComInfo2A();
int PS4_SYSV_ABI sceNpAsmClientGetNpComInfo2WithHmac();
int PS4_SYSV_ABI sceNpAsmClientGetNpComInfo3();
int PS4_SYSV_ABI sceNpAsmClientGetNpComInfo4();
int PS4_SYSV_ABI sceNpAsmClientGetNpTitleId();
int PS4_SYSV_ABI sceNpAsmClientGetNpTitleToken();
int PS4_SYSV_ABI sceNpAsmClientGetNpTitleToken2();
int PS4_SYSV_ABI sceNpAsmClientGetNpTitleTokenA();
int PS4_SYSV_ABI sceNpAsmClientGetRelatedGameNpTitleIds();
int PS4_SYSV_ABI sceNpAsmClientGetRelatedGameNpTitleIdsA();
int PS4_SYSV_ABI sceNpAsmClientGetRelatedGameNpTitleIdsResult();
int PS4_SYSV_ABI sceNpAsmClientGetServiceBaseUrl();
int PS4_SYSV_ABI sceNpAsmClientGetServiceBaseUrlA();
int PS4_SYSV_ABI sceNpAsmClientGetServiceBaseUrlWithNpTitleId();
int PS4_SYSV_ABI sceNpAsmClientGetServiceBaseUrlWithNpTitleIdA();
int PS4_SYSV_ABI sceNpAsmClientGetServiceIdInfo();
int PS4_SYSV_ABI sceNpAsmClientGetServiceIdInfoA();
int PS4_SYSV_ABI sceNpAsmClientInitialize();
int PS4_SYSV_ABI sceNpAsmClientSetNpTitleId();
int PS4_SYSV_ABI sceNpAsmClientTerminate();
int PS4_SYSV_ABI sceNpAsmCreateConnection();
int PS4_SYSV_ABI sceNpAsmCreateRequest();
int PS4_SYSV_ABI sceNpAsmDeleteConnection();
int PS4_SYSV_ABI sceNpAsmDeleteRequest();
int PS4_SYSV_ABI sceNpAsmGenerateNpTitleToken();
int PS4_SYSV_ABI sceNpAsmGenerateNpTitleToken2();
int PS4_SYSV_ABI sceNpAsmGetNpCommInfo();
int PS4_SYSV_ABI sceNpAsmGetNpCommInfo2();
int PS4_SYSV_ABI sceNpAsmGetRelatedGameNpTitleIds();
int PS4_SYSV_ABI sceNpAsmGetServiceBaseUrl();
int PS4_SYSV_ABI sceNpAsmGetServiceIdInfo();
int PS4_SYSV_ABI sceNpAsmInitialize();
int PS4_SYSV_ABI sceNpAsmTerminate();
int PS4_SYSV_ABI sceNpCheckCallback();
int PS4_SYSV_ABI sceNpCheckCallbackForLib();
int PS4_SYSV_ABI sceNpCheckNpAvailability();
int PS4_SYSV_ABI sceNpCheckNpAvailabilityA();
int PS4_SYSV_ABI sceNpCheckNpReachability();
int PS4_SYSV_ABI sceNpCheckPlus();
int PS4_SYSV_ABI sceNpCreateAsyncRequest();
int PS4_SYSV_ABI sceNpCreateRequest();
int PS4_SYSV_ABI sceNpDeleteRequest(int reqId);
int PS4_SYSV_ABI sceNpGetAccountAge();
int PS4_SYSV_ABI sceNpGetAccountCountry();
int PS4_SYSV_ABI sceNpGetAccountCountryA();
int PS4_SYSV_ABI sceNpGetAccountDateOfBirth();
int PS4_SYSV_ABI sceNpGetAccountDateOfBirthA();
int PS4_SYSV_ABI sceNpGetAccountId();
int PS4_SYSV_ABI sceNpGetAccountIdA();
int PS4_SYSV_ABI sceNpGetAccountLanguage();
int PS4_SYSV_ABI sceNpGetAccountLanguage2();
int PS4_SYSV_ABI sceNpGetAccountLanguageA();
int PS4_SYSV_ABI sceNpGetGamePresenceStatus();
int PS4_SYSV_ABI sceNpGetGamePresenceStatusA();
int PS4_SYSV_ABI sceNpGetNpId(OrbisUserServiceUserId userId, OrbisNpId* npId);
int PS4_SYSV_ABI sceNpGetNpReachabilityState();
int PS4_SYSV_ABI sceNpGetOnlineId(s32 userId, OrbisNpOnlineId* onlineId);
int PS4_SYSV_ABI sceNpGetParentalControlInfo();
int PS4_SYSV_ABI sceNpGetParentalControlInfoA();
int PS4_SYSV_ABI sceNpGetState(s32 userId, OrbisNpState* state);
int PS4_SYSV_ABI sceNpGetUserIdByAccountId();
int PS4_SYSV_ABI sceNpGetUserIdByOnlineId();
int PS4_SYSV_ABI sceNpHasSignedUp();
int PS4_SYSV_ABI sceNpIdMapperAbortRequest();
int PS4_SYSV_ABI sceNpIdMapperAccountIdToNpId();
int PS4_SYSV_ABI sceNpIdMapperAccountIdToOnlineId();
int PS4_SYSV_ABI sceNpIdMapperCreateRequest();
int PS4_SYSV_ABI sceNpIdMapperDeleteRequest();
int PS4_SYSV_ABI sceNpIdMapperNpIdToAccountId();
int PS4_SYSV_ABI sceNpIdMapperOnlineIdToAccountId();
int PS4_SYSV_ABI sceNpInGameMessageAbortHandle();
int PS4_SYSV_ABI sceNpInGameMessageCheckCallback();
int PS4_SYSV_ABI sceNpInGameMessageCreateHandle();
int PS4_SYSV_ABI sceNpInGameMessageDeleteHandle();
int PS4_SYSV_ABI sceNpInGameMessageGetMemoryPoolStatistics();
int PS4_SYSV_ABI sceNpInGameMessageInitialize();
int PS4_SYSV_ABI sceNpInGameMessagePrepare();
int PS4_SYSV_ABI sceNpInGameMessagePrepareA();
int PS4_SYSV_ABI sceNpInGameMessageSendData();
int PS4_SYSV_ABI sceNpInGameMessageSendDataA();
int PS4_SYSV_ABI sceNpInGameMessageTerminate();
int PS4_SYSV_ABI sceNpIntCheckPlus();
int PS4_SYSV_ABI sceNpIntGetAppType();
int PS4_SYSV_ABI sceNpIntGetGamePresenceStatus();
int PS4_SYSV_ABI sceNpIntGetNpTitleId();
int PS4_SYSV_ABI sceNpIntGetNpTitleIdSecret();
int PS4_SYSV_ABI sceNpIntRegisterGamePresenceCallback();
int PS4_SYSV_ABI sceNpIsPlusMember();
int PS4_SYSV_ABI sceNpManagerIntAbortRequest();
int PS4_SYSV_ABI sceNpManagerIntAddActiveSigninStateCallback();
int PS4_SYSV_ABI sceNpManagerIntAddOnlineIdChangeCallback();
int PS4_SYSV_ABI sceNpManagerIntAddPlusMemberTypeCallback();
int PS4_SYSV_ABI sceNpManagerIntAddSigninStateCallback();
int PS4_SYSV_ABI sceNpManagerIntAuthGetAuthorizationCode();
int PS4_SYSV_ABI sceNpManagerIntAuthGetIdToken();
int PS4_SYSV_ABI sceNpManagerIntBindOfflineAccountId();
int PS4_SYSV_ABI sceNpManagerIntCheckGameNpAvailability();
int PS4_SYSV_ABI sceNpManagerIntCheckNpAvailability();
int PS4_SYSV_ABI sceNpManagerIntCheckNpAvailabilityByPid();
int PS4_SYSV_ABI sceNpManagerIntCheckNpState();
int PS4_SYSV_ABI sceNpManagerIntCheckNpStateA();
int PS4_SYSV_ABI sceNpManagerIntClearGameAccessToken();
int PS4_SYSV_ABI sceNpManagerIntClearOnlineIdChangeFlag();
int PS4_SYSV_ABI sceNpManagerIntClearTicket();
int PS4_SYSV_ABI sceNpManagerIntClearUsedFlag();
int PS4_SYSV_ABI sceNpManagerIntClearVshAccessToken();
int PS4_SYSV_ABI sceNpManagerIntCreateLoginContext();
int PS4_SYSV_ABI sceNpManagerIntCreateLoginRequest();
int PS4_SYSV_ABI sceNpManagerIntCreateRequest();
int PS4_SYSV_ABI sceNpManagerIntDeleteLoginContext();
int PS4_SYSV_ABI sceNpManagerIntDeleteRequest();
int PS4_SYSV_ABI sceNpManagerIntGetAccountCountry();
int PS4_SYSV_ABI sceNpManagerIntGetAccountCountryA();
int PS4_SYSV_ABI sceNpManagerIntGetAccountCountrySdk();
int PS4_SYSV_ABI sceNpManagerIntGetAccountDateOfBirthA();
int PS4_SYSV_ABI sceNpManagerIntGetAccountDateOfBirthSdk();
int PS4_SYSV_ABI sceNpManagerIntGetAccountId();
int PS4_SYSV_ABI sceNpManagerIntGetAccountIdSdk();
int PS4_SYSV_ABI sceNpManagerIntGetAccountLanguage();
int PS4_SYSV_ABI sceNpManagerIntGetAccountLanguageA();
int PS4_SYSV_ABI sceNpManagerIntGetAccountNpEnv();
int PS4_SYSV_ABI sceNpManagerIntGetAccountType();
int PS4_SYSV_ABI sceNpManagerIntGetActiveSigninState();
int PS4_SYSV_ABI sceNpManagerIntGetAuthorizationCodeA();
int PS4_SYSV_ABI sceNpManagerIntGetAuthorizationCodeWithPsnoUri();
int PS4_SYSV_ABI sceNpManagerIntGetAuthServerErrorFlag();
int PS4_SYSV_ABI sceNpManagerIntGetClientCredentialAccessToken();
int PS4_SYSV_ABI sceNpManagerIntGetCommunicationRestrictionStatus();
int PS4_SYSV_ABI sceNpManagerIntGetGameAccessToken();
int PS4_SYSV_ABI sceNpManagerIntGetIssuerId();
int PS4_SYSV_ABI sceNpManagerIntGetLastAccountLanguage();
int PS4_SYSV_ABI sceNpManagerIntGetMAccountId();
int PS4_SYSV_ABI sceNpManagerIntGetNpEnv();
int PS4_SYSV_ABI sceNpManagerIntGetNpId();
int PS4_SYSV_ABI sceNpManagerIntGetNpIdByOnlineId();
int PS4_SYSV_ABI sceNpManagerIntGetNpIdSdk();
int PS4_SYSV_ABI sceNpManagerIntGetOfflineAccountId();
int PS4_SYSV_ABI sceNpManagerIntGetOnlineIdByAccountId();
int PS4_SYSV_ABI sceNpManagerIntGetOnlineIdChangeFlag();
int PS4_SYSV_ABI sceNpManagerIntGetOnlineIdInternal();
int PS4_SYSV_ABI sceNpManagerIntGetOnlineIdSdk();
int PS4_SYSV_ABI sceNpManagerIntGetParentalControlFlag();
int PS4_SYSV_ABI sceNpManagerIntGetParentalControlInfo();
int PS4_SYSV_ABI sceNpManagerIntGetParentalControlInfoA();
int PS4_SYSV_ABI sceNpManagerIntGetPlusMemberType();
int PS4_SYSV_ABI sceNpManagerIntGetPlusMemberTypeNB();
int PS4_SYSV_ABI sceNpManagerIntGetServerError();
int PS4_SYSV_ABI sceNpManagerIntGetSigninState();
int PS4_SYSV_ABI sceNpManagerIntGetTicket();
int PS4_SYSV_ABI sceNpManagerIntGetTicketA();
int PS4_SYSV_ABI sceNpManagerIntGetTitleTokenWithCheck();
int PS4_SYSV_ABI sceNpManagerIntGetUserIdByAccountId();
int PS4_SYSV_ABI sceNpManagerIntGetUserIdByMAccountId();
int PS4_SYSV_ABI sceNpManagerIntGetUserIdByNpId();
int PS4_SYSV_ABI sceNpManagerIntGetUserIdByOfflineAccountId();
int PS4_SYSV_ABI sceNpManagerIntGetUserIdByOnlineId();
int PS4_SYSV_ABI sceNpManagerIntGetUserIdByOnlineIdSdk();
int PS4_SYSV_ABI sceNpManagerIntGetUserList();
int PS4_SYSV_ABI sceNpManagerIntGetUserNum();
int PS4_SYSV_ABI sceNpManagerIntGetVshAccessToken();
int PS4_SYSV_ABI sceNpManagerIntGetVshAccessTokenWithCheck();
int PS4_SYSV_ABI sceNpManagerIntGetVshClientId();
int PS4_SYSV_ABI sceNpManagerIntIsSubAccount();
int PS4_SYSV_ABI sceNpManagerIntIsTemporarySignout();
int PS4_SYSV_ABI sceNpManagerIntIsUnregisteredClientError();
int PS4_SYSV_ABI sceNpManagerIntLoginAddJsonInfo();
int PS4_SYSV_ABI sceNpManagerIntLoginAuthenticate();
int PS4_SYSV_ABI sceNpManagerIntLoginBind();
int PS4_SYSV_ABI sceNpManagerIntLoginGet2svInfo();
int PS4_SYSV_ABI sceNpManagerIntLoginGetAccessToken();
int PS4_SYSV_ABI sceNpManagerIntLoginGetAccessTokenViaImplicitFlow();
int PS4_SYSV_ABI sceNpManagerIntLoginGetAccountId();
int PS4_SYSV_ABI sceNpManagerIntLoginGetAuthenticateResponse();
int PS4_SYSV_ABI sceNpManagerIntLoginGetAuthorizationCode();
int PS4_SYSV_ABI sceNpManagerIntLoginGetDeviceCodeInfo();
int PS4_SYSV_ABI sceNpManagerIntLoginGetEmail();
int PS4_SYSV_ABI sceNpManagerIntLoginGetOnlineId();
int PS4_SYSV_ABI sceNpManagerIntLoginGetUserId();
int PS4_SYSV_ABI sceNpManagerIntLoginParseJsonUserInfo();
int PS4_SYSV_ABI sceNpManagerIntLoginResetSsoToken();
int PS4_SYSV_ABI sceNpManagerIntLoginRevalidatePassword();
int PS4_SYSV_ABI sceNpManagerIntLoginSetAccountInfo();
int PS4_SYSV_ABI sceNpManagerIntLoginSetSsoToken();
int PS4_SYSV_ABI sceNpManagerIntLoginSignin();
int PS4_SYSV_ABI sceNpManagerIntLoginValidateCredential();
int PS4_SYSV_ABI sceNpManagerIntLoginValidateKratosAuthCode();
int PS4_SYSV_ABI sceNpManagerIntLoginVerifyDeviceCode();
int PS4_SYSV_ABI sceNpManagerIntPfAuth();
int PS4_SYSV_ABI sceNpManagerIntRemoveActiveSigninStateCallback();
int PS4_SYSV_ABI sceNpManagerIntRemoveOnlineIdChangeCallback();
int PS4_SYSV_ABI sceNpManagerIntRemovePlusMemberTypeCallback();
int PS4_SYSV_ABI sceNpManagerIntRemoveSigninStateCallback();
int PS4_SYSV_ABI sceNpManagerIntRevalidatePassword();
int PS4_SYSV_ABI sceNpManagerIntSetPlusMemberTypeNB();
int PS4_SYSV_ABI sceNpManagerIntSetTimeout();
int PS4_SYSV_ABI sceNpManagerIntSignout();
int PS4_SYSV_ABI sceNpManagerIntSubmitUserCode();
int PS4_SYSV_ABI sceNpManagerIntTemporarySignout();
int PS4_SYSV_ABI sceNpManagerIntUnbindOfflineAccountId();
int PS4_SYSV_ABI sceNpManagerIntUpdateVshAccessToken();
int PS4_SYSV_ABI sceNpManagerIntWebLoginRequired();
int PS4_SYSV_ABI sceNpManagerPrxStartVsh();
int PS4_SYSV_ABI sceNpManagerPrxStopVsh();
int PS4_SYSV_ABI sceNpNotifyPlusFeature();
int PS4_SYSV_ABI sceNpPollAsync();
int PS4_SYSV_ABI sceNpPush2CreateUserContext();
int PS4_SYSV_ABI sceNpPush2DeleteUserContext();
int PS4_SYSV_ABI sceNpPush2Init();
int PS4_SYSV_ABI sceNpPush2IsInit();
int PS4_SYSV_ABI sceNpPush2OptionalCheckCallback();
int PS4_SYSV_ABI sceNpPush2RegisterDataType();
int PS4_SYSV_ABI sceNpPush2RegisterExtendedDataFilter();
int PS4_SYSV_ABI sceNpPush2RegisterNotificationExCallback();
int PS4_SYSV_ABI sceNpPush2SendPushStatisticsDataSystemTelemetry();
int PS4_SYSV_ABI sceNpPush2SetGlobalMutex();
int PS4_SYSV_ABI sceNpPush2SetNpCommunicationId();
int PS4_SYSV_ABI sceNpPush2Term();
int PS4_SYSV_ABI sceNpPush2TriggerEmptyUserEvent();
int PS4_SYSV_ABI sceNpPush2UnregisterDataType();
int PS4_SYSV_ABI sceNpPush2UnregisterExtendedDataFilter();
int PS4_SYSV_ABI sceNpPush2UnregisterNotificationExCallback();
int PS4_SYSV_ABI sceNpPush2UnsetNpCommunicationId();
int PS4_SYSV_ABI sceNpPush2WaitCallback();
int PS4_SYSV_ABI sceNpPushCheckCallback();
int PS4_SYSV_ABI sceNpPushInit();
int PS4_SYSV_ABI sceNpPushIntBeginInactive();
int PS4_SYSV_ABI sceNpPushIntEndInactive();
int PS4_SYSV_ABI sceNpPushIntGetBindUserState();
int PS4_SYSV_ABI sceNpPushIntGetConnectionState();
int PS4_SYSV_ABI sceNpPushIntRegisterNotificationPacketCallback();
int PS4_SYSV_ABI sceNpPushIntUnregisterNotificationPacketCallback();
int PS4_SYSV_ABI sceNpPushRegisterExtendedDataFilter();
int PS4_SYSV_ABI sceNpPushRegisterNotificationExCallback();
int PS4_SYSV_ABI sceNpPushSetNpCommunicationId();
int PS4_SYSV_ABI sceNpPushStartNotification();
int PS4_SYSV_ABI sceNpPushStartNotificationA();
int PS4_SYSV_ABI sceNpPushStopNotification();
int PS4_SYSV_ABI sceNpPushStopNotificationA();
int PS4_SYSV_ABI sceNpPushTerm();
int PS4_SYSV_ABI sceNpPushUnregisterExtendedDataFilter();
int PS4_SYSV_ABI sceNpPushUnregisterNotificationCallback();
int PS4_SYSV_ABI sceNpPushUnsetNpCommunicationId();
int PS4_SYSV_ABI sceNpRegisterGamePresenceCallback();
int PS4_SYSV_ABI sceNpRegisterGamePresenceCallbackA();
int PS4_SYSV_ABI sceNpRegisterNpReachabilityStateCallback();
int PS4_SYSV_ABI sceNpRegisterPlusEventCallback();
int PS4_SYSV_ABI sceNpRegisterStateCallback();
int PS4_SYSV_ABI sceNpRegisterStateCallbackA();
int PS4_SYSV_ABI sceNpServiceClientInit();
int PS4_SYSV_ABI sceNpServiceClientTerm();
int PS4_SYSV_ABI sceNpSetAdditionalScope();
int PS4_SYSV_ABI sceNpSetContentRestriction();
int PS4_SYSV_ABI sceNpSetGamePresenceOnline();
int PS4_SYSV_ABI sceNpSetGamePresenceOnlineA();
int PS4_SYSV_ABI sceNpSetNpTitleId();
int PS4_SYSV_ABI sceNpSetNpTitleIdVsh();
int PS4_SYSV_ABI sceNpSetTimeout();
int PS4_SYSV_ABI sceNpUnregisterGamePresenceCallbackA();
int PS4_SYSV_ABI sceNpUnregisterNpReachabilityStateCallback();
int PS4_SYSV_ABI sceNpUnregisterPlusEventCallback();
int PS4_SYSV_ABI sceNpUnregisterStateCallback();
int PS4_SYSV_ABI sceNpUnregisterStateCallbackA();
int PS4_SYSV_ABI sceNpWaitAsync();
int PS4_SYSV_ABI Func_05003628D66BD87D();
int PS4_SYSV_ABI Func_0C388A4F21C98AF9();
int PS4_SYSV_ABI Func_0CECC7A08A3E50AF();
int PS4_SYSV_ABI Func_0D17030A1DA18EEB();
int PS4_SYSV_ABI Func_0F0F320B6AD8A53D();
int PS4_SYSV_ABI Func_113C477090F9A174();
int PS4_SYSV_ABI Func_12D367D5C727F008();
int PS4_SYSV_ABI Func_1640120BD475931E();
int PS4_SYSV_ABI Func_1AFE1C07C95E65A5();
int PS4_SYSV_ABI Func_1D983C7E0C28AC72();
int PS4_SYSV_ABI Func_208943695A3B58FE();
int PS4_SYSV_ABI Func_258A3D10C99A43BB();
int PS4_SYSV_ABI Func_263E325794B412AC();
int PS4_SYSV_ABI Func_2B6A4BF35C5E240D();
int PS4_SYSV_ABI Func_2B707FFE05ACB009();
int PS4_SYSV_ABI Func_2CE5AB230EBAF8B4();
int PS4_SYSV_ABI Func_3237EE3C3AFC187B();
int PS4_SYSV_ABI Func_33D4DFB2A1603BFF();
int PS4_SYSV_ABI Func_3821D79C1ED86F33();
int PS4_SYSV_ABI Func_3F431997C7105BBF();
int PS4_SYSV_ABI Func_4192797C2D2D3FC3();
int PS4_SYSV_ABI Func_41C7E3D88BBB7F75();
int PS4_SYSV_ABI Func_438F60858A883FCF();
int PS4_SYSV_ABI Func_4C4A062E5660FABD();
int PS4_SYSV_ABI Func_4C808F7A4EFA36A7();
int PS4_SYSV_ABI Func_4E1CED7E62F68F46();
int PS4_SYSV_ABI Func_5161A48C6A61C4BF();
int PS4_SYSV_ABI Func_542603999CA0AEE9();
int PS4_SYSV_ABI Func_54690B41C1128799();
int PS4_SYSV_ABI Func_55A76C7C29521FAD();
int PS4_SYSV_ABI Func_562B234AAE25F80C();
int PS4_SYSV_ABI Func_58D1975026DD864A();
int PS4_SYSV_ABI Func_5A60395F8C3FE128();
int PS4_SYSV_ABI Func_5B382777E9B5F294();
int PS4_SYSV_ABI Func_5DB301F9CD649671();
int PS4_SYSV_ABI Func_6441D55869D8D6F2();
int PS4_SYSV_ABI Func_69068E18854284DE();
int PS4_SYSV_ABI Func_6F59C3B00B03E05A();
int PS4_SYSV_ABI Func_724CCE7F78A1356B();
int PS4_SYSV_ABI Func_750F1B053C243308();
int PS4_SYSV_ABI Func_760F079BB91DE258();
int PS4_SYSV_ABI Func_78657523221556EF();
int PS4_SYSV_ABI Func_8089888BD363EDA6();
int PS4_SYSV_ABI Func_810CA029B6F7C3A1();
int PS4_SYSV_ABI Func_8253B94686A8D3FD();
int PS4_SYSV_ABI Func_8665138A709E1654();
int PS4_SYSV_ABI Func_882F48FAE6097C0C();
int PS4_SYSV_ABI Func_89DBE4B3303FF888();
int PS4_SYSV_ABI Func_8BD3E57620BDDC38();
int PS4_SYSV_ABI Func_8F0A74013AD633EC();
int PS4_SYSV_ABI Func_8FA6264BF3F6CC00();
int PS4_SYSV_ABI Func_9292E87C2C0971E4();
int PS4_SYSV_ABI Func_92CA292318CA03A8();
int PS4_SYSV_ABI Func_9348596C2B17F662();
int PS4_SYSV_ABI Func_9507E9B321A5E0D7();
int PS4_SYSV_ABI Func_98CA95E231980731();
int PS4_SYSV_ABI Func_9E66CC4BBF2C1990();
int PS4_SYSV_ABI Func_9E6CEF7064891F84();
int PS4_SYSV_ABI Func_A7BC2C792E9522C5();
int PS4_SYSV_ABI Func_ABBA0F809548CB02();
int PS4_SYSV_ABI Func_B14A27A4CEDE020F();
int PS4_SYSV_ABI Func_B323EE1C23AB97F3();
int PS4_SYSV_ABI Func_B429819DAEF40BAC();
int PS4_SYSV_ABI Func_B54B9571BEAD82C5();
int PS4_SYSV_ABI Func_B5ACB5CF4A4114A6();
int PS4_SYSV_ABI Func_BA41BE0F44157EE4();
int PS4_SYSV_ABI Func_BAA1DEC848D99690();
int PS4_SYSV_ABI Func_BB8CCCD6C9480EB2();
int PS4_SYSV_ABI Func_BEC25DAAE8B8B81F();
int PS4_SYSV_ABI Func_BFEE936391AB0C70();
int PS4_SYSV_ABI Func_C0DD2DBE2EA66F7A();
int PS4_SYSV_ABI Func_C1F858BF5B86C2A1();
int PS4_SYSV_ABI Func_C240618E6FC39206();
int PS4_SYSV_ABI Func_C338A34450310E79();
int PS4_SYSV_ABI Func_C91EE3603D966909();
int PS4_SYSV_ABI Func_CB67035ED668CF6B();
int PS4_SYSV_ABI Func_D5A5A28B7351A9BE();
int PS4_SYSV_ABI Func_DA8426059F1D5A2D();
int PS4_SYSV_ABI Func_DA8E15DD00AF9DF8();
int PS4_SYSV_ABI Func_DB86987643BB5DD7();
int PS4_SYSV_ABI Func_DEC53D7165C137DF();
int PS4_SYSV_ABI Func_DFDEEE26F2EB96B3();
int PS4_SYSV_ABI Func_E2056A6F01642866();
int PS4_SYSV_ABI Func_E240E9B8597EE56E();
int PS4_SYSV_ABI Func_E32CE33B706F05F7();
int PS4_SYSV_ABI Func_E4F67EFC91C84F87();
int PS4_SYSV_ABI Func_E6F041A2660F83EB();
int PS4_SYSV_ABI Func_E979BA413BD84D38();
int PS4_SYSV_ABI Func_EDDDF2D305DB7866();
int PS4_SYSV_ABI Func_F08EC7725B42E2F9();
int PS4_SYSV_ABI Func_F3595D8EFFF26EC0();
int PS4_SYSV_ABI Func_F3DF5271142F155D();
int PS4_SYSV_ABI Func_F89997168DC987A8();
int PS4_SYSV_ABI Func_F91B5B25CC9B30D9();
int PS4_SYSV_ABI Func_FC335B7102A585B3();
int PS4_SYSV_ABI Func_FCEAC354CA8B206E();
int PS4_SYSV_ABI Func_FF966E4351E564D6();
int PS4_SYSV_ABI sceNpRegisterStateCallbackForToolkit(OrbisNpStateCallbackForNpToolkit callback,
                                                      void* userdata);
int PS4_SYSV_ABI sceNpUnregisterStateCallbackForToolkit();

void RegisterlibSceNpManager(Core::Loader::SymbolsResolver* sym);
} // namespace Libraries::NpManager
