/*
 ***********************************************************************************************************************
 *
 *  Copyright (c) 2014-2021 Advanced Micro Devices, Inc. All Rights Reserved.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in all
 *  copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 *  SOFTWARE.
 *
 **********************************************************************************************************************/

#if !defined __SI__CI__VIoffset_HEADER
#define __SI__CI__VIoffset_HEADER

namespace Pal
{
namespace Gfx6
{
inline namespace Chip
{

#define SI_CI_offset_HEADER__SI__CI
constexpr unsigned int cfgADAPTER_ID                                    = 0x000B;
constexpr unsigned int cfgADAPTER_ID_W                                  = 0x0013;
constexpr unsigned int cfgBASE_ADDR_1                                   = 0x0004;
constexpr unsigned int cfgBASE_ADDR_2                                   = 0x0005;
constexpr unsigned int cfgBASE_ADDR_3                                   = 0x0006;
constexpr unsigned int cfgBASE_ADDR_4                                   = 0x0007;
constexpr unsigned int cfgBASE_ADDR_5                                   = 0x0008;
constexpr unsigned int cfgBASE_ADDR_6                                   = 0x0009;
constexpr unsigned int cfgBASE_CLASS                                    = 0x0002;
constexpr unsigned int cfgBIST                                          = 0x0003;
constexpr unsigned int cfgCACHE_LINE                                    = 0x0003;
constexpr unsigned int cfgCAP_PTR                                       = 0x000D;
constexpr unsigned int cfgCOMMAND                                       = 0x0001;
constexpr unsigned int cfgDEVICE_CAP                                    = 0x0017;
constexpr unsigned int cfgDEVICE_CAP2                                   = 0x001F;
constexpr unsigned int cfgDEVICE_CNTL                                   = 0x0018;
constexpr unsigned int cfgDEVICE_CNTL2                                  = 0x0020;
constexpr unsigned int cfgDEVICE_ID                                     = 0x0000;
constexpr unsigned int cfgDEVICE_STATUS                                 = 0x0018;
constexpr unsigned int cfgDEVICE_STATUS2                                = 0x0020;
constexpr unsigned int cfgHEADER                                        = 0x0003;
constexpr unsigned int cfgINTERRUPT_LINE                                = 0x000F;
constexpr unsigned int cfgINTERRUPT_PIN                                 = 0x000F;
constexpr unsigned int cfgLATENCY                                       = 0x0003;
constexpr unsigned int cfgLINK_CAP                                      = 0x0019;
constexpr unsigned int cfgLINK_CAP2                                     = 0x0021;
constexpr unsigned int cfgLINK_CNTL                                     = 0x001A;
constexpr unsigned int cfgLINK_CNTL2                                    = 0x0022;
constexpr unsigned int cfgLINK_STATUS                                   = 0x001A;
constexpr unsigned int cfgLINK_STATUS2                                  = 0x0022;
constexpr unsigned int cfgMAX_LATENCY                                   = 0x000F;
constexpr unsigned int cfgMIN_GRANT                                     = 0x000F;
constexpr unsigned int cfgMSI_CAP_LIST                                  = 0x0028;
constexpr unsigned int cfgMSI_MSG_ADDR_HI                               = 0x002A;
constexpr unsigned int cfgMSI_MSG_ADDR_LO                               = 0x0029;
constexpr unsigned int cfgMSI_MSG_CNTL                                  = 0x0028;
constexpr unsigned int cfgMSI_MSG_DATA                                  = 0x002A;
constexpr unsigned int cfgMSI_MSG_DATA_64                               = 0x002B;
constexpr unsigned int cfgPCIE_ACS_CAP__CI__VI                          = 0x00A9;
constexpr unsigned int cfgPCIE_ACS_CNTL__CI__VI                         = 0x00A9;
constexpr unsigned int cfgPCIE_ACS_ENH_CAP_LIST__CI__VI                 = 0x00A8;
constexpr unsigned int cfgPCIE_ADV_ERR_CAP_CNTL                         = 0x005A;
constexpr unsigned int cfgPCIE_ADV_ERR_RPT_ENH_CAP_LIST                 = 0x0054;
constexpr unsigned int cfgPCIE_ATS_CAP__CI__VI                          = 0x00AD;
constexpr unsigned int cfgPCIE_ATS_CNTL__CI__VI                         = 0x00AD;
constexpr unsigned int cfgPCIE_ATS_ENH_CAP_LIST__CI__VI                 = 0x00AC;
constexpr unsigned int cfgPCIE_BAR1_CAP__CI__VI                         = 0x0081;
constexpr unsigned int cfgPCIE_BAR1_CNTL__CI__VI                        = 0x0082;
constexpr unsigned int cfgPCIE_BAR2_CAP__CI__VI                         = 0x0083;
constexpr unsigned int cfgPCIE_BAR2_CNTL__CI__VI                        = 0x0084;
constexpr unsigned int cfgPCIE_BAR3_CAP__CI__VI                         = 0x0085;
constexpr unsigned int cfgPCIE_BAR3_CNTL__CI__VI                        = 0x0086;
constexpr unsigned int cfgPCIE_BAR4_CAP__CI__VI                         = 0x0087;
constexpr unsigned int cfgPCIE_BAR4_CNTL__CI__VI                        = 0x0088;
constexpr unsigned int cfgPCIE_BAR5_CAP__CI__VI                         = 0x0089;
constexpr unsigned int cfgPCIE_BAR5_CNTL__CI__VI                        = 0x008A;
constexpr unsigned int cfgPCIE_BAR6_CAP__CI__VI                         = 0x008B;
constexpr unsigned int cfgPCIE_BAR6_CNTL__CI__VI                        = 0x008C;
constexpr unsigned int cfgPCIE_BAR_ENH_CAP_LIST__CI__VI                 = 0x0080;
constexpr unsigned int cfgPCIE_CAP                                      = 0x0016;
constexpr unsigned int cfgPCIE_CAP_LIST                                 = 0x0016;
constexpr unsigned int cfgPCIE_CORR_ERR_MASK                            = 0x0059;
constexpr unsigned int cfgPCIE_CORR_ERR_STATUS                          = 0x0058;
constexpr unsigned int cfgPCIE_DEV_SERIAL_NUM_DW1                       = 0x0051;
constexpr unsigned int cfgPCIE_DEV_SERIAL_NUM_DW2                       = 0x0052;
constexpr unsigned int cfgPCIE_DEV_SERIAL_NUM_ENH_CAP_LIST              = 0x0050;
constexpr unsigned int cfgPCIE_DPA_CAP__CI__VI                          = 0x0095;
constexpr unsigned int cfgPCIE_DPA_CNTL__CI__VI                         = 0x0097;
constexpr unsigned int cfgPCIE_DPA_ENH_CAP_LIST__CI__VI                 = 0x0094;
constexpr unsigned int cfgPCIE_DPA_LATENCY_INDICATOR__CI__VI            = 0x0096;
constexpr unsigned int cfgPCIE_DPA_STATUS__CI__VI                       = 0x0097;
constexpr unsigned int cfgPCIE_DPA_SUBSTATE_PWR_ALLOC_0__CI__VI         = 0x0098;
constexpr unsigned int cfgPCIE_DPA_SUBSTATE_PWR_ALLOC_1__CI__VI         = 0x0098;
constexpr unsigned int cfgPCIE_DPA_SUBSTATE_PWR_ALLOC_2__CI__VI         = 0x0098;
constexpr unsigned int cfgPCIE_DPA_SUBSTATE_PWR_ALLOC_3__CI__VI         = 0x0098;
constexpr unsigned int cfgPCIE_DPA_SUBSTATE_PWR_ALLOC_4__CI__VI         = 0x0099;
constexpr unsigned int cfgPCIE_DPA_SUBSTATE_PWR_ALLOC_5__CI__VI         = 0x0099;
constexpr unsigned int cfgPCIE_DPA_SUBSTATE_PWR_ALLOC_6__CI__VI         = 0x0099;
constexpr unsigned int cfgPCIE_DPA_SUBSTATE_PWR_ALLOC_7__CI__VI         = 0x0099;
constexpr unsigned int cfgPCIE_HDR_LOG0                                 = 0x005B;
constexpr unsigned int cfgPCIE_HDR_LOG1                                 = 0x005C;
constexpr unsigned int cfgPCIE_HDR_LOG2                                 = 0x005D;
constexpr unsigned int cfgPCIE_HDR_LOG3                                 = 0x005E;
constexpr unsigned int cfgPCIE_LANE_0_EQUALIZATION_CNTL__CI__VI         = 0x009F;
constexpr unsigned int cfgPCIE_LANE_10_EQUALIZATION_CNTL__CI__VI        = 0x00A4;
constexpr unsigned int cfgPCIE_LANE_11_EQUALIZATION_CNTL__CI__VI        = 0x00A4;
constexpr unsigned int cfgPCIE_LANE_12_EQUALIZATION_CNTL__CI__VI        = 0x00A5;
constexpr unsigned int cfgPCIE_LANE_13_EQUALIZATION_CNTL__CI__VI        = 0x00A5;
constexpr unsigned int cfgPCIE_LANE_14_EQUALIZATION_CNTL__CI__VI        = 0x00A6;
constexpr unsigned int cfgPCIE_LANE_15_EQUALIZATION_CNTL__CI__VI        = 0x00A6;
constexpr unsigned int cfgPCIE_LANE_1_EQUALIZATION_CNTL__CI__VI         = 0x009F;
constexpr unsigned int cfgPCIE_LANE_2_EQUALIZATION_CNTL__CI__VI         = 0x00A0;
constexpr unsigned int cfgPCIE_LANE_3_EQUALIZATION_CNTL__CI__VI         = 0x00A0;
constexpr unsigned int cfgPCIE_LANE_4_EQUALIZATION_CNTL__CI__VI         = 0x00A1;
constexpr unsigned int cfgPCIE_LANE_5_EQUALIZATION_CNTL__CI__VI         = 0x00A1;
constexpr unsigned int cfgPCIE_LANE_6_EQUALIZATION_CNTL__CI__VI         = 0x00A2;
constexpr unsigned int cfgPCIE_LANE_7_EQUALIZATION_CNTL__CI__VI         = 0x00A2;
constexpr unsigned int cfgPCIE_LANE_8_EQUALIZATION_CNTL__CI__VI         = 0x00A3;
constexpr unsigned int cfgPCIE_LANE_9_EQUALIZATION_CNTL__CI__VI         = 0x00A3;
constexpr unsigned int cfgPCIE_LANE_ERROR_STATUS__CI__VI                = 0x009E;
constexpr unsigned int cfgPCIE_LINK_CNTL3__CI__VI                       = 0x009D;
constexpr unsigned int cfgPCIE_OUTSTAND_PAGE_REQ_ALLOC__CI__VI          = 0x00B3;
constexpr unsigned int cfgPCIE_OUTSTAND_PAGE_REQ_CAPACITY__CI__VI       = 0x00B2;
constexpr unsigned int cfgPCIE_PAGE_REQ_CNTL__CI__VI                    = 0x00B1;
constexpr unsigned int cfgPCIE_PAGE_REQ_ENH_CAP_LIST__CI__VI            = 0x00B0;
constexpr unsigned int cfgPCIE_PAGE_REQ_STATUS__CI__VI                  = 0x00B1;
constexpr unsigned int cfgPCIE_PASID_CAP__CI__VI                        = 0x00B5;
constexpr unsigned int cfgPCIE_PASID_CNTL__CI__VI                       = 0x00B5;
constexpr unsigned int cfgPCIE_PASID_ENH_CAP_LIST__CI__VI               = 0x00B4;
constexpr unsigned int cfgPCIE_PORT_VC_CAP_REG1                         = 0x0045;
constexpr unsigned int cfgPCIE_PORT_VC_CAP_REG2                         = 0x0046;
constexpr unsigned int cfgPCIE_PORT_VC_CNTL                             = 0x0047;
constexpr unsigned int cfgPCIE_PORT_VC_STATUS                           = 0x0047;
constexpr unsigned int cfgPCIE_PWR_BUDGET_CAP__CI__VI                   = 0x0093;
constexpr unsigned int cfgPCIE_PWR_BUDGET_DATA_SELECT__CI__VI           = 0x0091;
constexpr unsigned int cfgPCIE_PWR_BUDGET_DATA__CI__VI                  = 0x0092;
constexpr unsigned int cfgPCIE_PWR_BUDGET_ENH_CAP_LIST__CI__VI          = 0x0090;
constexpr unsigned int cfgPCIE_SECONDARY_ENH_CAP_LIST__CI__VI           = 0x009C;
constexpr unsigned int cfgPCIE_TLP_PREFIX_LOG0__CI__VI                  = 0x0062;
constexpr unsigned int cfgPCIE_TLP_PREFIX_LOG1__CI__VI                  = 0x0063;
constexpr unsigned int cfgPCIE_TLP_PREFIX_LOG2__CI__VI                  = 0x0064;
constexpr unsigned int cfgPCIE_TLP_PREFIX_LOG3__CI__VI                  = 0x0065;
constexpr unsigned int cfgPCIE_UNCORR_ERR_MASK                          = 0x0056;
constexpr unsigned int cfgPCIE_UNCORR_ERR_SEVERITY                      = 0x0057;
constexpr unsigned int cfgPCIE_UNCORR_ERR_STATUS                        = 0x0055;
constexpr unsigned int cfgPCIE_VC0_RESOURCE_CAP                         = 0x0048;
constexpr unsigned int cfgPCIE_VC0_RESOURCE_CNTL                        = 0x0049;
constexpr unsigned int cfgPCIE_VC0_RESOURCE_STATUS                      = 0x004A;
constexpr unsigned int cfgPCIE_VC1_RESOURCE_CAP                         = 0x004B;
constexpr unsigned int cfgPCIE_VC1_RESOURCE_CNTL                        = 0x004C;
constexpr unsigned int cfgPCIE_VC1_RESOURCE_STATUS                      = 0x004D;
constexpr unsigned int cfgPCIE_VC_ENH_CAP_LIST                          = 0x0044;
constexpr unsigned int cfgPCIE_VENDOR_SPECIFIC1                         = 0x0042;
constexpr unsigned int cfgPCIE_VENDOR_SPECIFIC2                         = 0x0043;
constexpr unsigned int cfgPCIE_VENDOR_SPECIFIC_ENH_CAP_LIST             = 0x0040;
constexpr unsigned int cfgPCIE_VENDOR_SPECIFIC_HDR                      = 0x0041;
constexpr unsigned int cfgPMI_CAP                                       = 0x0014;
constexpr unsigned int cfgPMI_CAP_LIST                                  = 0x0014;
constexpr unsigned int cfgPMI_STATUS_CNTL                               = 0x0015;
constexpr unsigned int cfgPROG_INTERFACE                                = 0x0002;
constexpr unsigned int cfgREVISION_ID                                   = 0x0002;
constexpr unsigned int cfgROM_BASE_ADDR                                 = 0x000C;
constexpr unsigned int cfgSTATUS                                        = 0x0001;
constexpr unsigned int cfgSUB_CLASS                                     = 0x0002;
constexpr unsigned int cfgVENDOR_CAP_LIST__CI__VI                       = 0x0012;
constexpr unsigned int cfgVENDOR_ID                                     = 0x0000;
constexpr unsigned int ioATTRDR__SI__VI                                 = 0x00F0;
constexpr unsigned int ioATTRDW__SI__VI                                 = 0x00F0;
constexpr unsigned int ioATTRX__SI__VI                                  = 0x00F0;
constexpr unsigned int ioBIF_RFE_SNOOP_REG__CI__VI                      = 0x0027;
constexpr unsigned int ioCRTC8_DATA__SI__VI                             = 0x00ED;
constexpr unsigned int ioCRTC8_IDX__SI__VI                              = 0x00ED;
constexpr unsigned int ioDAC_DATA__SI__VI                               = 0x00F2;
constexpr unsigned int ioDAC_MASK__SI__VI                               = 0x00F1;
constexpr unsigned int ioDAC_R_INDEX__SI__VI                            = 0x00F1;
constexpr unsigned int ioDAC_W_INDEX__SI__VI                            = 0x00F2;
constexpr unsigned int ioGENENB__SI__VI                                 = 0x00F0;
constexpr unsigned int ioGENFC_RD__SI__VI                               = 0x00F2;
constexpr unsigned int ioGENFC_WT__SI__VI                               = 0x00EE;
constexpr unsigned int ioGENMO_RD__SI__VI                               = 0x00F3;
constexpr unsigned int ioGENMO_WT__SI__VI                               = 0x00F0;
constexpr unsigned int ioGENS0__SI__VI                                  = 0x00F0;
constexpr unsigned int ioGENS1__SI__VI                                  = 0x00EE;
constexpr unsigned int ioGRPH8_DATA__SI__VI                             = 0x00F3;
constexpr unsigned int ioGRPH8_IDX__SI__VI                              = 0x00F3;
constexpr unsigned int ioMM_DATA                                        = 0x0001;
constexpr unsigned int ioMM_INDEX                                       = 0x0000;
constexpr unsigned int ioMM_INDEX_HI__CI__VI                            = 0x0006;
constexpr unsigned int ioPCIE_DATA_2__CI__VI                            = 0x000D;
constexpr unsigned int ioPCIE_DATA__CI__VI                              = 0x000F;
constexpr unsigned int ioPCIE_DATA__SI                                  = 0x000D;
constexpr unsigned int ioPCIE_INDEX_2__CI__VI                           = 0x000C;
constexpr unsigned int ioPCIE_INDEX__CI__VI                             = 0x000E;
constexpr unsigned int ioPCIE_INDEX__SI                                 = 0x000C;
constexpr unsigned int ioROM_DATA__SI                                   = 0x002B;
constexpr unsigned int ioROM_INDEX__SI                                  = 0x002A;
constexpr unsigned int ioSEQ8_DATA__SI__VI                              = 0x00F1;
constexpr unsigned int ioSEQ8_IDX__SI__VI                               = 0x00F1;
constexpr unsigned int ioVGA_MEM_READ_PAGE_ADDR__SI__VI                 = 0x0013;
constexpr unsigned int ioVGA_MEM_WRITE_PAGE_ADDR__SI__VI                = 0x0012;
constexpr unsigned int mmABM_TEST_DEBUG_DATA__SI__VI                    = 0x169F;
constexpr unsigned int mmABM_TEST_DEBUG_INDEX__SI__VI                   = 0x169E;
constexpr unsigned int mmACP_CONFIG__CI                                 = 0x0F95;
constexpr unsigned int mmAFMT_60958_0__SI                               = 0x1C41;
constexpr unsigned int mmAFMT_60958_1__SI                               = 0x1C42;
constexpr unsigned int mmAFMT_60958_2__SI                               = 0x1C48;
constexpr unsigned int mmAFMT_AUDIO_CRC_CONTROL__SI                     = 0x1C43;
constexpr unsigned int mmAFMT_AUDIO_CRC_RESULT__SI                      = 0x1C49;
constexpr unsigned int mmAFMT_AUDIO_INFO0__SI                           = 0x1C3F;
constexpr unsigned int mmAFMT_AUDIO_INFO1__SI                           = 0x1C40;
constexpr unsigned int mmAFMT_AUDIO_PACKET_CONTROL2__SI                 = 0x1C17;
constexpr unsigned int mmAFMT_AUDIO_PACKET_CONTROL__SI                  = 0x1C4B;
constexpr unsigned int mmAFMT_AVI_INFO0__SI                             = 0x1C21;
constexpr unsigned int mmAFMT_AVI_INFO1__SI                             = 0x1C22;
constexpr unsigned int mmAFMT_AVI_INFO2__SI                             = 0x1C23;
constexpr unsigned int mmAFMT_AVI_INFO3__SI                             = 0x1C24;
constexpr unsigned int mmAFMT_INFOFRAME_CONTROL0__SI                    = 0x1C4D;
constexpr unsigned int mmAFMT_ISRC1_0__SI                               = 0x1C18;
constexpr unsigned int mmAFMT_ISRC1_1__SI                               = 0x1C19;
constexpr unsigned int mmAFMT_ISRC1_2__SI                               = 0x1C1A;
constexpr unsigned int mmAFMT_ISRC1_3__SI                               = 0x1C1B;
constexpr unsigned int mmAFMT_ISRC1_4__SI                               = 0x1C1C;
constexpr unsigned int mmAFMT_ISRC2_0__SI                               = 0x1C1D;
constexpr unsigned int mmAFMT_ISRC2_1__SI                               = 0x1C1E;
constexpr unsigned int mmAFMT_ISRC2_2__SI                               = 0x1C1F;
constexpr unsigned int mmAFMT_ISRC2_3__SI                               = 0x1C20;
constexpr unsigned int mmAFMT_MPEG_INFO0__SI                            = 0x1C25;
constexpr unsigned int mmAFMT_MPEG_INFO1__SI                            = 0x1C26;
constexpr unsigned int mmAFMT_RAMP_CONTROL0__SI                         = 0x1C44;
constexpr unsigned int mmAFMT_RAMP_CONTROL1__SI                         = 0x1C45;
constexpr unsigned int mmAFMT_RAMP_CONTROL2__SI                         = 0x1C46;
constexpr unsigned int mmAFMT_RAMP_CONTROL3__SI                         = 0x1C47;
constexpr unsigned int mmAFMT_STATUS__SI                                = 0x1C4A;
constexpr unsigned int mmAFMT_VBI_PACKET_CONTROL__SI                    = 0x1C4C;
constexpr unsigned int mmATC_ATS_CNTL__CI__VI                           = 0x0CC9;
constexpr unsigned int mmATC_ATS_DEBUG__CI__VI                          = 0x0CCA;
constexpr unsigned int mmATC_ATS_DEFAULT_PAGE_CNTL__CI__VI              = 0x0CD1;
constexpr unsigned int mmATC_ATS_DEFAULT_PAGE_LOW__CI__VI               = 0x0CD0;
constexpr unsigned int mmATC_ATS_FAULT_CNTL__CI__VI                     = 0x0CCD;
constexpr unsigned int mmATC_ATS_FAULT_DEBUG__CI__VI                    = 0x0CCB;
constexpr unsigned int mmATC_ATS_FAULT_STATUS_ADDR__CI__VI              = 0x0CCF;
constexpr unsigned int mmATC_ATS_FAULT_STATUS_INFO__CI__VI              = 0x0CCE;
constexpr unsigned int mmATC_ATS_STATUS__CI__VI                         = 0x0CCC;
constexpr unsigned int mmATC_L1RD_DEBUG_TLB__CI__VI                     = 0x0CDE;
constexpr unsigned int mmATC_L1RD_STATUS__CI__VI                        = 0x0CE0;
constexpr unsigned int mmATC_L1WR_DEBUG_TLB__CI__VI                     = 0x0CDF;
constexpr unsigned int mmATC_L1WR_STATUS__CI__VI                        = 0x0CE1;
constexpr unsigned int mmATC_L1_ADDRESS_OFFSET__CI__VI                  = 0x0CDD;
constexpr unsigned int mmATC_L1_CNTL__CI__VI                            = 0x0CDC;
constexpr unsigned int mmATC_L2_CNTL2__CI__VI                           = 0x0CD6;
constexpr unsigned int mmATC_L2_CNTL__CI__VI                            = 0x0CD5;
constexpr unsigned int mmATC_L2_DEBUG2__CI__VI                          = 0x0CD8;
constexpr unsigned int mmATC_L2_DEBUG__CI__VI                           = 0x0CD7;
constexpr unsigned int mmATC_MISC_CG__CI__VI                            = 0x0CD4;
constexpr unsigned int mmATC_PERFCOUNTER0_CFG__CI__VI                   = 0x07C8;
constexpr unsigned int mmATC_PERFCOUNTER1_CFG__CI__VI                   = 0x07C9;
constexpr unsigned int mmATC_PERFCOUNTER2_CFG__CI__VI                   = 0x07CA;
constexpr unsigned int mmATC_PERFCOUNTER3_CFG__CI__VI                   = 0x07CB;
constexpr unsigned int mmATC_PERFCOUNTER_HI__CI__VI                     = 0x07AF;
constexpr unsigned int mmATC_PERFCOUNTER_LO__CI__VI                     = 0x07A7;
constexpr unsigned int mmATC_PERFCOUNTER_RSLT_CNTL__CI__VI              = 0x07D5;
constexpr unsigned int mmATC_VMID0_PASID_MAPPING__CI__VI                = 0x0CE7;
constexpr unsigned int mmATC_VMID10_PASID_MAPPING__CI__VI               = 0x0CF1;
constexpr unsigned int mmATC_VMID11_PASID_MAPPING__CI__VI               = 0x0CF2;
constexpr unsigned int mmATC_VMID12_PASID_MAPPING__CI__VI               = 0x0CF3;
constexpr unsigned int mmATC_VMID13_PASID_MAPPING__CI__VI               = 0x0CF4;
constexpr unsigned int mmATC_VMID14_PASID_MAPPING__CI__VI               = 0x0CF5;
constexpr unsigned int mmATC_VMID15_PASID_MAPPING__CI__VI               = 0x0CF6;
constexpr unsigned int mmATC_VMID1_PASID_MAPPING__CI__VI                = 0x0CE8;
constexpr unsigned int mmATC_VMID2_PASID_MAPPING__CI__VI                = 0x0CE9;
constexpr unsigned int mmATC_VMID3_PASID_MAPPING__CI__VI                = 0x0CEA;
constexpr unsigned int mmATC_VMID4_PASID_MAPPING__CI__VI                = 0x0CEB;
constexpr unsigned int mmATC_VMID5_PASID_MAPPING__CI__VI                = 0x0CEC;
constexpr unsigned int mmATC_VMID6_PASID_MAPPING__CI__VI                = 0x0CED;
constexpr unsigned int mmATC_VMID7_PASID_MAPPING__CI__VI                = 0x0CEE;
constexpr unsigned int mmATC_VMID8_PASID_MAPPING__CI__VI                = 0x0CEF;
constexpr unsigned int mmATC_VMID9_PASID_MAPPING__CI__VI                = 0x0CF0;
constexpr unsigned int mmATC_VMID_PASID_MAPPING_UPDATE_STATUS__CI__VI   = 0x0CE6;
constexpr unsigned int mmATC_VM_APERTURE0_CNTL2__CI__VI                 = 0x0CC6;
constexpr unsigned int mmATC_VM_APERTURE0_CNTL__CI__VI                  = 0x0CC4;
constexpr unsigned int mmATC_VM_APERTURE0_HIGH_ADDR__CI__VI             = 0x0CC2;
constexpr unsigned int mmATC_VM_APERTURE0_LOW_ADDR__CI__VI              = 0x0CC0;
constexpr unsigned int mmATC_VM_APERTURE1_CNTL2__CI__VI                 = 0x0CC7;
constexpr unsigned int mmATC_VM_APERTURE1_CNTL__CI__VI                  = 0x0CC5;
constexpr unsigned int mmATC_VM_APERTURE1_HIGH_ADDR__CI__VI             = 0x0CC3;
constexpr unsigned int mmATC_VM_APERTURE1_LOW_ADDR__CI__VI              = 0x0CC1;
constexpr unsigned int mmATTRDR__SI__VI                                 = 0x00F0;
constexpr unsigned int mmATTRDW__SI__VI                                 = 0x00F0;
constexpr unsigned int mmATTRX__SI__VI                                  = 0x00F0;
constexpr unsigned int mmAUXN_IMPCAL__SI                                = 0x194B;
constexpr unsigned int mmAUXP_IMPCAL__SI                                = 0x194A;
constexpr unsigned int mmAUX_ARB_CONTROL__SI                            = 0x1882;
constexpr unsigned int mmAUX_CONTROL__SI                                = 0x1880;
constexpr unsigned int mmAUX_DPHY_RX_CONTROL0__SI                       = 0x188A;
constexpr unsigned int mmAUX_DPHY_RX_CONTROL1__SI                       = 0x188B;
constexpr unsigned int mmAUX_DPHY_RX_STATUS__SI                         = 0x188D;
constexpr unsigned int mmAUX_DPHY_TX_CONTROL__SI                        = 0x1889;
constexpr unsigned int mmAUX_DPHY_TX_REF_CONTROL__SI                    = 0x1888;
constexpr unsigned int mmAUX_DPHY_TX_STATUS__SI                         = 0x188C;
constexpr unsigned int mmAUX_INTERRUPT_CONTROL__SI                      = 0x1883;
constexpr unsigned int mmAUX_LS_DATA__SI                                = 0x1887;
constexpr unsigned int mmAUX_LS_STATUS__SI                              = 0x1885;
constexpr unsigned int mmAUX_SW_CONTROL__SI                             = 0x1881;
constexpr unsigned int mmAUX_SW_DATA__SI                                = 0x1886;
constexpr unsigned int mmAUX_SW_STATUS__SI                              = 0x1884;
constexpr unsigned int mmAZALIA_APPLICATION_POSITION_IN_CYCLIC_BUFFER__SI  = 0x17F6;
constexpr unsigned int mmAZALIA_AUDIO_DTO_CONTROL__SI                   = 0x173D;
constexpr unsigned int mmAZALIA_AUDIO_DTO__SI                           = 0x173C;
constexpr unsigned int mmAZALIA_BDL_DMA_CONTROL__SI                     = 0x1730;
constexpr unsigned int mmAZALIA_CORB_DMA_CONTROL__SI                    = 0x172F;
constexpr unsigned int mmAZALIA_CUMULATIVE_LATENCY_COUNT__SI            = 0x1737;
constexpr unsigned int mmAZALIA_CUMULATIVE_REQUEST_COUNT__SI            = 0x1738;
constexpr unsigned int mmAZALIA_CYCLIC_BUFFER_SYNC__SI                  = 0x17F7;
constexpr unsigned int mmAZALIA_DATA_DMA_CONTROL__SI                    = 0x1731;
constexpr unsigned int mmAZALIA_F0_CODEC_CONVERTER_CONTROL_CHANNEL_STREAM_ID__SI  = 0x174F;
constexpr unsigned int mmAZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE__SI  = 0x174C;
constexpr unsigned int mmAZALIA_F0_CODEC_FUNCTION_CONTROL_RESET__SI     = 0x174D;
constexpr unsigned int mmAZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID__SI  = 0x1750;
constexpr unsigned int mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_GROUP_TYPE__SI  = 0x1742;
constexpr unsigned int mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES__SI  = 0x1745;
constexpr unsigned int mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS__SI  = 0x1744;
constexpr unsigned int mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES__SI  = 0x1743;
constexpr unsigned int mmAZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE__SI  = 0x174B;
constexpr unsigned int mmAZALIA_F0_CODEC_PIN_CONTROL_WIDGET_CONTROL__SI  = 0x1753;
constexpr unsigned int mmAZALIA_F0_CODEC_ROOT_PARAMETER_REVISION_ID__SI  = 0x173F;
constexpr unsigned int mmAZALIA_F0_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID__SI  = 0x173E;
constexpr unsigned int mmAZALIA_LATENCY_COUNTER_CONTROL__SI             = 0x1735;
constexpr unsigned int mmAZALIA_RIRB_AND_DP_CONTROL__SI                 = 0x172D;
constexpr unsigned int mmAZALIA_UNDERFLOW_FILLER_SAMPLE__SI             = 0x1732;
constexpr unsigned int mmAZALIA_WORSTCASE_LATENCY_COUNT__SI             = 0x1736;
constexpr unsigned int mmAZ_TEST_DEBUG_DATA__SI                         = 0x1756;
constexpr unsigned int mmAZ_TEST_DEBUG_INDEX__SI                        = 0x1755;
constexpr unsigned int mmBACO_CNTL_MISC__CI__VI                         = 0x14DB;
constexpr unsigned int mmBACO_CNTL__CI__VI                              = 0x14E5;
constexpr unsigned int mmBCI_DEBUG_READ__CI__VI                         = 0x24EB;
constexpr unsigned int mmBCI_DEBUG_READ__SI                             = 0x24E3;
constexpr unsigned int mmBIF_BACO_DEBUG_LATCH__CI__VI                   = 0x14DC;
constexpr unsigned int mmBIF_BACO_DEBUG__CI__VI                         = 0x14DF;
constexpr unsigned int mmBIF_BACO_MSIC__CI                              = 0x1480;
constexpr unsigned int mmBIF_BUSNUM_CNTL1                               = 0x1525;
constexpr unsigned int mmBIF_BUSNUM_CNTL2                               = 0x152B;
constexpr unsigned int mmBIF_BUSNUM_LIST0                               = 0x1526;
constexpr unsigned int mmBIF_BUSNUM_LIST1                               = 0x1527;
constexpr unsigned int mmBIF_BUSY_DELAY_CNTR                            = 0x1529;
constexpr unsigned int mmBIF_CC_RFE_IMP_OVERRIDECNTL__CI__VI            = 0x1455;
constexpr unsigned int mmBIF_CLK_PDWN_DELAY_TIMER__CI                   = 0x1483;
constexpr unsigned int mmBIF_CLK_PDWN_DELAY_TIMER__SI                   = 0x151F;
constexpr unsigned int mmBIF_DEBUG_CNTL                                 = 0x151C;
constexpr unsigned int mmBIF_DEBUG_MUX                                  = 0x151D;
constexpr unsigned int mmBIF_DEBUG_OUT                                  = 0x151E;
constexpr unsigned int mmBIF_DEVFUNCNUM_LIST0__CI__VI                   = 0x14E8;
constexpr unsigned int mmBIF_DEVFUNCNUM_LIST1__CI__VI                   = 0x14E7;
constexpr unsigned int mmBIF_DOORBELL_CNTL__CI__VI                      = 0x14C3;
constexpr unsigned int mmBIF_FB_EN                                      = 0x1524;
constexpr unsigned int mmBIF_FEATURES_CONTROL_MISC__CI__VI              = 0x14C2;
constexpr unsigned int mmBIF_IMPCTL_CONTINUOUS_CALIBRATION_PERIOD__CI__VI  = 0x1454;
constexpr unsigned int mmBIF_IMPCTL_RXCNTL__CI__VI                      = 0x1451;
constexpr unsigned int mmBIF_IMPCTL_SMPLCNTL__CI__VI                    = 0x1450;
constexpr unsigned int mmBIF_IMPCTL_TXCNTL_pd__CI__VI                   = 0x1452;
constexpr unsigned int mmBIF_IMPCTL_TXCNTL_pu__CI__VI                   = 0x1453;
constexpr unsigned int mmBIF_LNCNT_RESET__CI                            = 0x1488;
constexpr unsigned int mmBIF_PERFCOUNTER0_RESULT__CI__VI                = 0x152D;
constexpr unsigned int mmBIF_PERFCOUNTER1_RESULT__CI__VI                = 0x152E;
constexpr unsigned int mmBIF_PERFMON_CNTL__CI__VI                       = 0x152C;
constexpr unsigned int mmBIF_PIF_TXCLK_SWITCH_TIMER__CI                 = 0x1481;
constexpr unsigned int mmBIF_PWDN_COMMAND__CI__VI                       = 0x1444;
constexpr unsigned int mmBIF_PWDN_STATUS__CI__VI                        = 0x1445;
constexpr unsigned int mmBIF_RESET_CNTL__CI                             = 0x1486;
constexpr unsigned int mmBIF_RESET_EN__CI                               = 0x1482;
constexpr unsigned int mmBIF_RESET_EN__SI                               = 0x1511;
constexpr unsigned int mmBIF_RFE_CLIENT_SOFTRST_TRIGGER__CI__VI         = 0x1442;
constexpr unsigned int mmBIF_RFE_IMPRST_CNTL__CI__VI                    = 0x1458;
constexpr unsigned int mmBIF_RFE_MASTER_SOFTRST_TRIGGER__CI__VI         = 0x1443;
constexpr unsigned int mmBIF_RFE_MMCFG_CNTL__CI__VI                     = 0x144C;
constexpr unsigned int mmBIF_RFE_MST_BU_CMDSTATUS__CI__VI               = 0x1446;
constexpr unsigned int mmBIF_RFE_MST_BX_CMDSTATUS__CI                   = 0x1448;
constexpr unsigned int mmBIF_RFE_MST_RWREG_RFEWDBIF_CMDSTATUS__CI__VI   = 0x1447;
constexpr unsigned int mmBIF_RFE_MST_TMOUT_STATUS__CI__VI               = 0x144B;
constexpr unsigned int mmBIF_RFE_SNOOP_REG__CI__VI                      = 0x0027;
constexpr unsigned int mmBIF_RFE_SOFTRST_CNTL__CI__VI                   = 0x1441;
constexpr unsigned int mmBIF_SCRATCH0                                   = 0x150E;
constexpr unsigned int mmBIF_SCRATCH1                                   = 0x150F;
constexpr unsigned int mmBIF_SLVARB_MODE__CI__VI                        = 0x14C4;
constexpr unsigned int mmBIF_SSA_DISP_LOWER__CI                         = 0x14D2;
constexpr unsigned int mmBIF_SSA_DISP_UPPER__CI                         = 0x14D3;
constexpr unsigned int mmBIF_SSA_GFX0_LOWER__CI                         = 0x14CA;
constexpr unsigned int mmBIF_SSA_GFX0_UPPER__CI                         = 0x14CB;
constexpr unsigned int mmBIF_SSA_GFX1_LOWER__CI                         = 0x14CC;
constexpr unsigned int mmBIF_SSA_GFX1_UPPER__CI                         = 0x14CD;
constexpr unsigned int mmBIF_SSA_GFX2_LOWER__CI                         = 0x14CE;
constexpr unsigned int mmBIF_SSA_GFX2_UPPER__CI                         = 0x14CF;
constexpr unsigned int mmBIF_SSA_GFX3_LOWER__CI                         = 0x14D0;
constexpr unsigned int mmBIF_SSA_GFX3_UPPER__CI                         = 0x14D1;
constexpr unsigned int mmBIF_SSA_MC_LOWER__CI                           = 0x14D4;
constexpr unsigned int mmBIF_SSA_MC_UPPER__CI                           = 0x14D5;
constexpr unsigned int mmBIF_SSA_PWR_STATUS__CI                         = 0x14C8;
constexpr unsigned int mmBIF_XDMA_HI__CI__VI                            = 0x14C1;
constexpr unsigned int mmBIF_XDMA_LO__CI__VI                            = 0x14C0;
constexpr unsigned int mmBIOS_SCRATCH_0                                 = 0x05C9;
constexpr unsigned int mmBIOS_SCRATCH_1                                 = 0x05CA;
constexpr unsigned int mmBIOS_SCRATCH_10                                = 0x05D3;
constexpr unsigned int mmBIOS_SCRATCH_11                                = 0x05D4;
constexpr unsigned int mmBIOS_SCRATCH_12                                = 0x05D5;
constexpr unsigned int mmBIOS_SCRATCH_13                                = 0x05D6;
constexpr unsigned int mmBIOS_SCRATCH_14                                = 0x05D7;
constexpr unsigned int mmBIOS_SCRATCH_15                                = 0x05D8;
constexpr unsigned int mmBIOS_SCRATCH_2                                 = 0x05CB;
constexpr unsigned int mmBIOS_SCRATCH_3                                 = 0x05CC;
constexpr unsigned int mmBIOS_SCRATCH_4                                 = 0x05CD;
constexpr unsigned int mmBIOS_SCRATCH_5                                 = 0x05CE;
constexpr unsigned int mmBIOS_SCRATCH_6                                 = 0x05CF;
constexpr unsigned int mmBIOS_SCRATCH_7                                 = 0x05D0;
constexpr unsigned int mmBIOS_SCRATCH_8                                 = 0x05D1;
constexpr unsigned int mmBIOS_SCRATCH_9                                 = 0x05D2;
constexpr unsigned int mmBL1_PWM_ABM_CNTL__SI__VI                       = 0x162E;
constexpr unsigned int mmBL1_PWM_AMBIENT_LIGHT_LEVEL__SI__VI            = 0x1628;
constexpr unsigned int mmBL1_PWM_BL_UPDATE_SAMPLE_RATE__SI__VI          = 0x162F;
constexpr unsigned int mmBL1_PWM_CURRENT_ABM_LEVEL__SI__VI              = 0x162B;
constexpr unsigned int mmBL1_PWM_FINAL_DUTY_CYCLE__SI__VI               = 0x162C;
constexpr unsigned int mmBL1_PWM_GRP2_REG_LOCK__SI__VI                  = 0x1630;
constexpr unsigned int mmBL1_PWM_MINIMUM_DUTY_CYCLE__SI__VI             = 0x162D;
constexpr unsigned int mmBL1_PWM_TARGET_ABM_LEVEL__SI__VI               = 0x162A;
constexpr unsigned int mmBL1_PWM_USER_LEVEL__SI__VI                     = 0x1629;
constexpr unsigned int mmBL_PWM_CNTL2__SI                               = 0x1968;
constexpr unsigned int mmBL_PWM_CNTL__SI                                = 0x1967;
constexpr unsigned int mmBL_PWM_GRP1_REG_LOCK__SI                       = 0x196A;
constexpr unsigned int mmBL_PWM_PERIOD_CNTL__SI                         = 0x1969;
constexpr unsigned int mmBUS_CNTL                                       = 0x1508;
constexpr unsigned int mmBX_RESET_EN__CI__VI                            = 0x1514;
constexpr unsigned int mmCAPTURE_HOST_BUSNUM                            = 0x153C;
constexpr unsigned int mmCB_BLEND0_CONTROL                              = 0xA1E0;
constexpr unsigned int mmCB_BLEND1_CONTROL                              = 0xA1E1;
constexpr unsigned int mmCB_BLEND2_CONTROL                              = 0xA1E2;
constexpr unsigned int mmCB_BLEND3_CONTROL                              = 0xA1E3;
constexpr unsigned int mmCB_BLEND4_CONTROL                              = 0xA1E4;
constexpr unsigned int mmCB_BLEND5_CONTROL                              = 0xA1E5;
constexpr unsigned int mmCB_BLEND6_CONTROL                              = 0xA1E6;
constexpr unsigned int mmCB_BLEND7_CONTROL                              = 0xA1E7;
constexpr unsigned int mmCB_BLEND_ALPHA                                 = 0xA108;
constexpr unsigned int mmCB_BLEND_BLUE                                  = 0xA107;
constexpr unsigned int mmCB_BLEND_GREEN                                 = 0xA106;
constexpr unsigned int mmCB_BLEND_RED                                   = 0xA105;
constexpr unsigned int mmCB_CGTT_SCLK_CTRL__CI__VI                      = 0xF0A8;
constexpr unsigned int mmCB_CGTT_SCLK_CTRL__SI                          = 0x2698;
constexpr unsigned int mmCB_COLOR0_ATTRIB                               = 0xA31D;
constexpr unsigned int mmCB_COLOR0_BASE                                 = 0xA318;
constexpr unsigned int mmCB_COLOR0_CLEAR_WORD0                          = 0xA323;
constexpr unsigned int mmCB_COLOR0_CLEAR_WORD1                          = 0xA324;
constexpr unsigned int mmCB_COLOR0_CMASK                                = 0xA31F;
constexpr unsigned int mmCB_COLOR0_CMASK_SLICE                          = 0xA320;
constexpr unsigned int mmCB_COLOR0_FMASK                                = 0xA321;
constexpr unsigned int mmCB_COLOR0_FMASK_SLICE                          = 0xA322;
constexpr unsigned int mmCB_COLOR0_INFO                                 = 0xA31C;
constexpr unsigned int mmCB_COLOR0_PITCH                                = 0xA319;
constexpr unsigned int mmCB_COLOR0_SLICE                                = 0xA31A;
constexpr unsigned int mmCB_COLOR0_VIEW                                 = 0xA31B;
constexpr unsigned int mmCB_COLOR1_ATTRIB                               = 0xA32C;
constexpr unsigned int mmCB_COLOR1_BASE                                 = 0xA327;
constexpr unsigned int mmCB_COLOR1_CLEAR_WORD0                          = 0xA332;
constexpr unsigned int mmCB_COLOR1_CLEAR_WORD1                          = 0xA333;
constexpr unsigned int mmCB_COLOR1_CMASK                                = 0xA32E;
constexpr unsigned int mmCB_COLOR1_CMASK_SLICE                          = 0xA32F;
constexpr unsigned int mmCB_COLOR1_FMASK                                = 0xA330;
constexpr unsigned int mmCB_COLOR1_FMASK_SLICE                          = 0xA331;
constexpr unsigned int mmCB_COLOR1_INFO                                 = 0xA32B;
constexpr unsigned int mmCB_COLOR1_PITCH                                = 0xA328;
constexpr unsigned int mmCB_COLOR1_SLICE                                = 0xA329;
constexpr unsigned int mmCB_COLOR1_VIEW                                 = 0xA32A;
constexpr unsigned int mmCB_COLOR2_ATTRIB                               = 0xA33B;
constexpr unsigned int mmCB_COLOR2_BASE                                 = 0xA336;
constexpr unsigned int mmCB_COLOR2_CLEAR_WORD0                          = 0xA341;
constexpr unsigned int mmCB_COLOR2_CLEAR_WORD1                          = 0xA342;
constexpr unsigned int mmCB_COLOR2_CMASK                                = 0xA33D;
constexpr unsigned int mmCB_COLOR2_CMASK_SLICE                          = 0xA33E;
constexpr unsigned int mmCB_COLOR2_FMASK                                = 0xA33F;
constexpr unsigned int mmCB_COLOR2_FMASK_SLICE                          = 0xA340;
constexpr unsigned int mmCB_COLOR2_INFO                                 = 0xA33A;
constexpr unsigned int mmCB_COLOR2_PITCH                                = 0xA337;
constexpr unsigned int mmCB_COLOR2_SLICE                                = 0xA338;
constexpr unsigned int mmCB_COLOR2_VIEW                                 = 0xA339;
constexpr unsigned int mmCB_COLOR3_ATTRIB                               = 0xA34A;
constexpr unsigned int mmCB_COLOR3_BASE                                 = 0xA345;
constexpr unsigned int mmCB_COLOR3_CLEAR_WORD0                          = 0xA350;
constexpr unsigned int mmCB_COLOR3_CLEAR_WORD1                          = 0xA351;
constexpr unsigned int mmCB_COLOR3_CMASK                                = 0xA34C;
constexpr unsigned int mmCB_COLOR3_CMASK_SLICE                          = 0xA34D;
constexpr unsigned int mmCB_COLOR3_FMASK                                = 0xA34E;
constexpr unsigned int mmCB_COLOR3_FMASK_SLICE                          = 0xA34F;
constexpr unsigned int mmCB_COLOR3_INFO                                 = 0xA349;
constexpr unsigned int mmCB_COLOR3_PITCH                                = 0xA346;
constexpr unsigned int mmCB_COLOR3_SLICE                                = 0xA347;
constexpr unsigned int mmCB_COLOR3_VIEW                                 = 0xA348;
constexpr unsigned int mmCB_COLOR4_ATTRIB                               = 0xA359;
constexpr unsigned int mmCB_COLOR4_BASE                                 = 0xA354;
constexpr unsigned int mmCB_COLOR4_CLEAR_WORD0                          = 0xA35F;
constexpr unsigned int mmCB_COLOR4_CLEAR_WORD1                          = 0xA360;
constexpr unsigned int mmCB_COLOR4_CMASK                                = 0xA35B;
constexpr unsigned int mmCB_COLOR4_CMASK_SLICE                          = 0xA35C;
constexpr unsigned int mmCB_COLOR4_FMASK                                = 0xA35D;
constexpr unsigned int mmCB_COLOR4_FMASK_SLICE                          = 0xA35E;
constexpr unsigned int mmCB_COLOR4_INFO                                 = 0xA358;
constexpr unsigned int mmCB_COLOR4_PITCH                                = 0xA355;
constexpr unsigned int mmCB_COLOR4_SLICE                                = 0xA356;
constexpr unsigned int mmCB_COLOR4_VIEW                                 = 0xA357;
constexpr unsigned int mmCB_COLOR5_ATTRIB                               = 0xA368;
constexpr unsigned int mmCB_COLOR5_BASE                                 = 0xA363;
constexpr unsigned int mmCB_COLOR5_CLEAR_WORD0                          = 0xA36E;
constexpr unsigned int mmCB_COLOR5_CLEAR_WORD1                          = 0xA36F;
constexpr unsigned int mmCB_COLOR5_CMASK                                = 0xA36A;
constexpr unsigned int mmCB_COLOR5_CMASK_SLICE                          = 0xA36B;
constexpr unsigned int mmCB_COLOR5_FMASK                                = 0xA36C;
constexpr unsigned int mmCB_COLOR5_FMASK_SLICE                          = 0xA36D;
constexpr unsigned int mmCB_COLOR5_INFO                                 = 0xA367;
constexpr unsigned int mmCB_COLOR5_PITCH                                = 0xA364;
constexpr unsigned int mmCB_COLOR5_SLICE                                = 0xA365;
constexpr unsigned int mmCB_COLOR5_VIEW                                 = 0xA366;
constexpr unsigned int mmCB_COLOR6_ATTRIB                               = 0xA377;
constexpr unsigned int mmCB_COLOR6_BASE                                 = 0xA372;
constexpr unsigned int mmCB_COLOR6_CLEAR_WORD0                          = 0xA37D;
constexpr unsigned int mmCB_COLOR6_CLEAR_WORD1                          = 0xA37E;
constexpr unsigned int mmCB_COLOR6_CMASK                                = 0xA379;
constexpr unsigned int mmCB_COLOR6_CMASK_SLICE                          = 0xA37A;
constexpr unsigned int mmCB_COLOR6_FMASK                                = 0xA37B;
constexpr unsigned int mmCB_COLOR6_FMASK_SLICE                          = 0xA37C;
constexpr unsigned int mmCB_COLOR6_INFO                                 = 0xA376;
constexpr unsigned int mmCB_COLOR6_PITCH                                = 0xA373;
constexpr unsigned int mmCB_COLOR6_SLICE                                = 0xA374;
constexpr unsigned int mmCB_COLOR6_VIEW                                 = 0xA375;
constexpr unsigned int mmCB_COLOR7_ATTRIB                               = 0xA386;
constexpr unsigned int mmCB_COLOR7_BASE                                 = 0xA381;
constexpr unsigned int mmCB_COLOR7_CLEAR_WORD0                          = 0xA38C;
constexpr unsigned int mmCB_COLOR7_CLEAR_WORD1                          = 0xA38D;
constexpr unsigned int mmCB_COLOR7_CMASK                                = 0xA388;
constexpr unsigned int mmCB_COLOR7_CMASK_SLICE                          = 0xA389;
constexpr unsigned int mmCB_COLOR7_FMASK                                = 0xA38A;
constexpr unsigned int mmCB_COLOR7_FMASK_SLICE                          = 0xA38B;
constexpr unsigned int mmCB_COLOR7_INFO                                 = 0xA385;
constexpr unsigned int mmCB_COLOR7_PITCH                                = 0xA382;
constexpr unsigned int mmCB_COLOR7_SLICE                                = 0xA383;
constexpr unsigned int mmCB_COLOR7_VIEW                                 = 0xA384;
constexpr unsigned int mmCB_COLOR_CONTROL                               = 0xA202;
constexpr unsigned int mmCB_DEBUG_BUS_1                                 = 0x2699;
constexpr unsigned int mmCB_DEBUG_BUS_13                                = 0x26A5;
constexpr unsigned int mmCB_DEBUG_BUS_14                                = 0x26A6;
constexpr unsigned int mmCB_DEBUG_BUS_15                                = 0x26A7;
constexpr unsigned int mmCB_DEBUG_BUS_16                                = 0x26A8;
constexpr unsigned int mmCB_DEBUG_BUS_17                                = 0x26A9;
constexpr unsigned int mmCB_DEBUG_BUS_18                                = 0x26AA;
constexpr unsigned int mmCB_DEBUG_BUS_2                                 = 0x269A;
constexpr unsigned int mmCB_HW_CONTROL                                  = 0x2684;
constexpr unsigned int mmCB_HW_CONTROL_1                                = 0x2685;
constexpr unsigned int mmCB_HW_CONTROL_2                                = 0x2686;
constexpr unsigned int mmCB_HW_CONTROL_3__CI__VI                        = 0x2683;
constexpr unsigned int mmCB_PERFCOUNTER0_HI__CI__VI                     = 0xD407;
constexpr unsigned int mmCB_PERFCOUNTER0_HI__SI                         = 0x2691;
constexpr unsigned int mmCB_PERFCOUNTER0_LO__CI__VI                     = 0xD406;
constexpr unsigned int mmCB_PERFCOUNTER0_LO__SI                         = 0x2690;
constexpr unsigned int mmCB_PERFCOUNTER0_SELECT0__SI                    = 0x2688;
constexpr unsigned int mmCB_PERFCOUNTER0_SELECT1__CI__VI                = 0xDC02;
constexpr unsigned int mmCB_PERFCOUNTER0_SELECT1__SI                    = 0x2689;
constexpr unsigned int mmCB_PERFCOUNTER0_SELECT__CI__VI                 = 0xDC01;
constexpr unsigned int mmCB_PERFCOUNTER1_HI__CI__VI                     = 0xD409;
constexpr unsigned int mmCB_PERFCOUNTER1_HI__SI                         = 0x2693;
constexpr unsigned int mmCB_PERFCOUNTER1_LO__CI__VI                     = 0xD408;
constexpr unsigned int mmCB_PERFCOUNTER1_LO__SI                         = 0x2692;
constexpr unsigned int mmCB_PERFCOUNTER1_SELECT0__SI                    = 0x268A;
constexpr unsigned int mmCB_PERFCOUNTER1_SELECT1__SI                    = 0x268B;
constexpr unsigned int mmCB_PERFCOUNTER1_SELECT__CI__VI                 = 0xDC03;
constexpr unsigned int mmCB_PERFCOUNTER2_HI__CI__VI                     = 0xD40B;
constexpr unsigned int mmCB_PERFCOUNTER2_HI__SI                         = 0x2695;
constexpr unsigned int mmCB_PERFCOUNTER2_LO__CI__VI                     = 0xD40A;
constexpr unsigned int mmCB_PERFCOUNTER2_LO__SI                         = 0x2694;
constexpr unsigned int mmCB_PERFCOUNTER2_SELECT0__SI                    = 0x268C;
constexpr unsigned int mmCB_PERFCOUNTER2_SELECT1__SI                    = 0x268D;
constexpr unsigned int mmCB_PERFCOUNTER2_SELECT__CI__VI                 = 0xDC04;
constexpr unsigned int mmCB_PERFCOUNTER3_HI__CI__VI                     = 0xD40D;
constexpr unsigned int mmCB_PERFCOUNTER3_HI__SI                         = 0x2697;
constexpr unsigned int mmCB_PERFCOUNTER3_LO__CI__VI                     = 0xD40C;
constexpr unsigned int mmCB_PERFCOUNTER3_LO__SI                         = 0x2696;
constexpr unsigned int mmCB_PERFCOUNTER3_SELECT0__SI                    = 0x268E;
constexpr unsigned int mmCB_PERFCOUNTER3_SELECT1__SI                    = 0x268F;
constexpr unsigned int mmCB_PERFCOUNTER3_SELECT__CI__VI                 = 0xDC05;
constexpr unsigned int mmCB_PERFCOUNTER_FILTER__CI__VI                  = 0xDC00;
constexpr unsigned int mmCB_SHADER_MASK                                 = 0xA08F;
constexpr unsigned int mmCB_TARGET_MASK                                 = 0xA08E;
constexpr unsigned int mmCC_DRM_ID_STRAPS                               = 0x1559;
constexpr unsigned int mmCC_GC_EDC_CONFIG__CI__VI                       = 0x3098;
constexpr unsigned int mmCC_GC_PRIM_CONFIG__CI__VI                      = 0x2240;
constexpr unsigned int mmCC_GC_SHADER_ARRAY_CONFIG                      = 0x226F;
constexpr unsigned int mmCC_MC_MAX_CHANNEL                              = 0x096E;
constexpr unsigned int mmCC_RB_BACKEND_DISABLE                          = 0x263D;
constexpr unsigned int mmCC_RB_DAISY_CHAIN                              = 0x2641;
constexpr unsigned int mmCC_RB_REDUNDANCY                               = 0x263C;
constexpr unsigned int mmCC_SQC_BANK_DISABLE                            = 0x2307;
constexpr unsigned int mmCC_SYS_RB_BACKEND_DISABLE                      = 0x03A0;
constexpr unsigned int mmCC_SYS_RB_REDUNDANCY                           = 0x039F;
constexpr unsigned int mmCGTS_CU0_LDS_SQ_CTRL_REG__CI__VI               = 0xF009;
constexpr unsigned int mmCGTS_CU0_SP0_CTRL_REG__CI__VI                  = 0xF008;
constexpr unsigned int mmCGTS_CU0_SP1_CTRL_REG__CI__VI                  = 0xF00B;
constexpr unsigned int mmCGTS_CU0_TA_SQC_CTRL_REG__CI__VI               = 0xF00A;
constexpr unsigned int mmCGTS_CU0_TD_TCP_CTRL_REG__CI__VI               = 0xF00C;
constexpr unsigned int mmCGTS_CU10_LDS_SQ_CTRL_REG__CI__VI              = 0xF03B;
constexpr unsigned int mmCGTS_CU10_SP0_CTRL_REG__CI__VI                 = 0xF03A;
constexpr unsigned int mmCGTS_CU10_SP1_CTRL_REG__CI__VI                 = 0xF03D;
constexpr unsigned int mmCGTS_CU10_TA_CTRL_REG__CI__VI                  = 0xF03C;
constexpr unsigned int mmCGTS_CU10_TD_TCP_CTRL_REG__CI__VI              = 0xF03E;
constexpr unsigned int mmCGTS_CU11_LDS_SQ_CTRL_REG__CI__VI              = 0xF040;
constexpr unsigned int mmCGTS_CU11_SP0_CTRL_REG__CI__VI                 = 0xF03F;
constexpr unsigned int mmCGTS_CU11_SP1_CTRL_REG__CI__VI                 = 0xF042;
constexpr unsigned int mmCGTS_CU11_TA_CTRL_REG__CI__VI                  = 0xF041;
constexpr unsigned int mmCGTS_CU11_TD_TCP_CTRL_REG__CI__VI              = 0xF043;
constexpr unsigned int mmCGTS_CU12_LDS_SQ_CTRL_REG__CI__VI              = 0xF045;
constexpr unsigned int mmCGTS_CU12_SP0_CTRL_REG__CI__VI                 = 0xF044;
constexpr unsigned int mmCGTS_CU12_SP1_CTRL_REG__CI__VI                 = 0xF047;
constexpr unsigned int mmCGTS_CU12_TA_SQC_CTRL_REG__CI__VI              = 0xF046;
constexpr unsigned int mmCGTS_CU12_TD_TCP_CTRL_REG__CI__VI              = 0xF048;
constexpr unsigned int mmCGTS_CU13_LDS_SQ_CTRL_REG__CI__VI              = 0xF04A;
constexpr unsigned int mmCGTS_CU13_SP0_CTRL_REG__CI__VI                 = 0xF049;
constexpr unsigned int mmCGTS_CU13_SP1_CTRL_REG__CI__VI                 = 0xF04C;
constexpr unsigned int mmCGTS_CU13_TA_CTRL_REG__CI__VI                  = 0xF04B;
constexpr unsigned int mmCGTS_CU13_TD_TCP_CTRL_REG__CI__VI              = 0xF04D;
constexpr unsigned int mmCGTS_CU14_LDS_SQ_CTRL_REG__CI__VI              = 0xF04F;
constexpr unsigned int mmCGTS_CU14_SP0_CTRL_REG__CI__VI                 = 0xF04E;
constexpr unsigned int mmCGTS_CU14_SP1_CTRL_REG__CI__VI                 = 0xF051;
constexpr unsigned int mmCGTS_CU14_TA_CTRL_REG__CI__VI                  = 0xF050;
constexpr unsigned int mmCGTS_CU14_TD_TCP_CTRL_REG__CI__VI              = 0xF052;
constexpr unsigned int mmCGTS_CU15_LDS_SQ_CTRL_REG__CI__VI              = 0xF054;
constexpr unsigned int mmCGTS_CU15_SP0_CTRL_REG__CI__VI                 = 0xF053;
constexpr unsigned int mmCGTS_CU15_SP1_CTRL_REG__CI__VI                 = 0xF056;
constexpr unsigned int mmCGTS_CU15_TA_CTRL_REG__CI__VI                  = 0xF055;
constexpr unsigned int mmCGTS_CU15_TD_TCP_CTRL_REG__CI__VI              = 0xF057;
constexpr unsigned int mmCGTS_CU1_LDS_SQ_CTRL_REG__CI__VI               = 0xF00E;
constexpr unsigned int mmCGTS_CU1_SP0_CTRL_REG__CI__VI                  = 0xF00D;
constexpr unsigned int mmCGTS_CU1_SP1_CTRL_REG__CI__VI                  = 0xF010;
constexpr unsigned int mmCGTS_CU1_TA_CTRL_REG__CI__VI                   = 0xF00F;
constexpr unsigned int mmCGTS_CU1_TD_TCP_CTRL_REG__CI__VI               = 0xF011;
constexpr unsigned int mmCGTS_CU2_LDS_SQ_CTRL_REG__CI__VI               = 0xF013;
constexpr unsigned int mmCGTS_CU2_SP0_CTRL_REG__CI__VI                  = 0xF012;
constexpr unsigned int mmCGTS_CU2_SP1_CTRL_REG__CI__VI                  = 0xF015;
constexpr unsigned int mmCGTS_CU2_TA_CTRL_REG__CI__VI                   = 0xF014;
constexpr unsigned int mmCGTS_CU2_TD_TCP_CTRL_REG__CI__VI               = 0xF016;
constexpr unsigned int mmCGTS_CU3_LDS_SQ_CTRL_REG__CI__VI               = 0xF018;
constexpr unsigned int mmCGTS_CU3_SP0_CTRL_REG__CI__VI                  = 0xF017;
constexpr unsigned int mmCGTS_CU3_SP1_CTRL_REG__CI__VI                  = 0xF01A;
constexpr unsigned int mmCGTS_CU3_TA_CTRL_REG__CI__VI                   = 0xF019;
constexpr unsigned int mmCGTS_CU3_TD_TCP_CTRL_REG__CI__VI               = 0xF01B;
constexpr unsigned int mmCGTS_CU4_LDS_SQ_CTRL_REG__CI__VI               = 0xF01D;
constexpr unsigned int mmCGTS_CU4_SP0_CTRL_REG__CI__VI                  = 0xF01C;
constexpr unsigned int mmCGTS_CU4_SP1_CTRL_REG__CI__VI                  = 0xF01F;
constexpr unsigned int mmCGTS_CU4_TA_SQC_CTRL_REG__CI__VI               = 0xF01E;
constexpr unsigned int mmCGTS_CU4_TD_TCP_CTRL_REG__CI__VI               = 0xF020;
constexpr unsigned int mmCGTS_CU5_LDS_SQ_CTRL_REG__CI__VI               = 0xF022;
constexpr unsigned int mmCGTS_CU5_SP0_CTRL_REG__CI__VI                  = 0xF021;
constexpr unsigned int mmCGTS_CU5_SP1_CTRL_REG__CI__VI                  = 0xF024;
constexpr unsigned int mmCGTS_CU5_TA_CTRL_REG__CI__VI                   = 0xF023;
constexpr unsigned int mmCGTS_CU5_TD_TCP_CTRL_REG__CI__VI               = 0xF025;
constexpr unsigned int mmCGTS_CU6_LDS_SQ_CTRL_REG__CI__VI               = 0xF027;
constexpr unsigned int mmCGTS_CU6_SP0_CTRL_REG__CI__VI                  = 0xF026;
constexpr unsigned int mmCGTS_CU6_SP1_CTRL_REG__CI__VI                  = 0xF029;
constexpr unsigned int mmCGTS_CU6_TA_CTRL_REG__CI__VI                   = 0xF028;
constexpr unsigned int mmCGTS_CU6_TD_TCP_CTRL_REG__CI__VI               = 0xF02A;
constexpr unsigned int mmCGTS_CU7_LDS_SQ_CTRL_REG__CI__VI               = 0xF02C;
constexpr unsigned int mmCGTS_CU7_SP0_CTRL_REG__CI__VI                  = 0xF02B;
constexpr unsigned int mmCGTS_CU7_SP1_CTRL_REG__CI__VI                  = 0xF02E;
constexpr unsigned int mmCGTS_CU7_TA_CTRL_REG__CI__VI                   = 0xF02D;
constexpr unsigned int mmCGTS_CU7_TD_TCP_CTRL_REG__CI__VI               = 0xF02F;
constexpr unsigned int mmCGTS_CU8_LDS_SQ_CTRL_REG__CI__VI               = 0xF031;
constexpr unsigned int mmCGTS_CU8_SP0_CTRL_REG__CI__VI                  = 0xF030;
constexpr unsigned int mmCGTS_CU8_SP1_CTRL_REG__CI__VI                  = 0xF033;
constexpr unsigned int mmCGTS_CU8_TA_SQC_CTRL_REG__CI__VI               = 0xF032;
constexpr unsigned int mmCGTS_CU8_TD_TCP_CTRL_REG__CI__VI               = 0xF034;
constexpr unsigned int mmCGTS_CU9_LDS_SQ_CTRL_REG__CI__VI               = 0xF036;
constexpr unsigned int mmCGTS_CU9_SP0_CTRL_REG__CI__VI                  = 0xF035;
constexpr unsigned int mmCGTS_CU9_SP1_CTRL_REG__CI__VI                  = 0xF038;
constexpr unsigned int mmCGTS_CU9_TA_CTRL_REG__CI__VI                   = 0xF037;
constexpr unsigned int mmCGTS_CU9_TD_TCP_CTRL_REG__CI__VI               = 0xF039;
constexpr unsigned int mmCGTS_RD_CTRL_REG__CI__VI                       = 0xF001;
constexpr unsigned int mmCGTS_RD_CTRL_REG__SI                           = 0x2455;
constexpr unsigned int mmCGTS_RD_REG__CI__VI                            = 0xF002;
constexpr unsigned int mmCGTS_RD_REG__SI                                = 0x2456;
constexpr unsigned int mmCGTS_SM_CTRL_REG__CI__VI                       = 0xF000;
constexpr unsigned int mmCGTS_SM_CTRL_REG__SI                           = 0x2454;
constexpr unsigned int mmCGTS_TCC_DISABLE__CI__VI                       = 0xF003;
constexpr unsigned int mmCGTS_TCC_DISABLE__SI                           = 0x2452;
constexpr unsigned int mmCGTS_USER_TCC_DISABLE__CI__VI                  = 0xF004;
constexpr unsigned int mmCGTS_USER_TCC_DISABLE__SI                      = 0x2453;
constexpr unsigned int mmCGTT_BCI_CLK_CTRL__CI__VI                      = 0xF082;
constexpr unsigned int mmCGTT_BCI_CLK_CTRL__SI                          = 0x24A9;
constexpr unsigned int mmCGTT_CPC_CLK_CTRL__CI__VI                      = 0xF0B2;
constexpr unsigned int mmCGTT_CPF_CLK_CTRL__CI__VI                      = 0xF0B1;
constexpr unsigned int mmCGTT_CP_CLK_CTRL__CI__VI                       = 0xF0B0;
constexpr unsigned int mmCGTT_CP_CLK_CTRL__SI                           = 0x3059;
constexpr unsigned int mmCGTT_GDS_CLK_CTRL__CI__VI                      = 0xF0A0;
constexpr unsigned int mmCGTT_GDS_CLK_CTRL__SI                          = 0x25DD;
constexpr unsigned int mmCGTT_IA_CLK_CTRL__CI__VI                       = 0xF085;
constexpr unsigned int mmCGTT_IA_CLK_CTRL__SI                           = 0x2261;
constexpr unsigned int mmCGTT_PA_CLK_CTRL__CI__VI                       = 0xF088;
constexpr unsigned int mmCGTT_PA_CLK_CTRL__SI                           = 0x2286;
constexpr unsigned int mmCGTT_PC_CLK_CTRL__CI__VI                       = 0xF081;
constexpr unsigned int mmCGTT_PC_CLK_CTRL__SI                           = 0x24A8;
constexpr unsigned int mmCGTT_RLC_CLK_CTRL__CI__VI                      = 0xF0B8;
constexpr unsigned int mmCGTT_RLC_CLK_CTRL__SI                          = 0x30E0;
constexpr unsigned int mmCGTT_ROM_CLK_CTRL0__SI                         = 0x0583;
constexpr unsigned int mmCGTT_SC_CLK_CTRL__CI__VI                       = 0xF089;
constexpr unsigned int mmCGTT_SC_CLK_CTRL__SI                           = 0x22CA;
constexpr unsigned int mmCGTT_SPI_CLK_CTRL__CI__VI                      = 0xF080;
constexpr unsigned int mmCGTT_SPI_CLK_CTRL__SI                          = 0x2451;
constexpr unsigned int mmCGTT_SQG_CLK_CTRL__CI__VI                      = 0xF08D;
constexpr unsigned int mmCGTT_SQG_CLK_CTRL__SI                          = 0x2363;
constexpr unsigned int mmCGTT_SQ_CLK_CTRL__CI__VI                       = 0xF08C;
constexpr unsigned int mmCGTT_SQ_CLK_CTRL__SI                           = 0x2362;
constexpr unsigned int mmCGTT_SX_CLK_CTRL0__CI__VI                      = 0xF094;
constexpr unsigned int mmCGTT_SX_CLK_CTRL0__SI                          = 0x240C;
constexpr unsigned int mmCGTT_SX_CLK_CTRL1__CI__VI                      = 0xF095;
constexpr unsigned int mmCGTT_SX_CLK_CTRL1__SI                          = 0x240D;
constexpr unsigned int mmCGTT_SX_CLK_CTRL2__CI__VI                      = 0xF096;
constexpr unsigned int mmCGTT_SX_CLK_CTRL2__SI                          = 0x240E;
constexpr unsigned int mmCGTT_SX_CLK_CTRL3__CI__VI                      = 0xF097;
constexpr unsigned int mmCGTT_SX_CLK_CTRL3__SI                          = 0x240F;
constexpr unsigned int mmCGTT_SX_CLK_CTRL4__CI__VI                      = 0xF098;
constexpr unsigned int mmCGTT_SX_CLK_CTRL4__SI                          = 0x2410;
constexpr unsigned int mmCGTT_TCI_CLK_CTRL__CI__VI                      = 0xF09F;
constexpr unsigned int mmCGTT_TCI_CLK_CTRL__SI                          = 0x2B60;
constexpr unsigned int mmCGTT_TCP_CLK_CTRL__CI__VI                      = 0xF09E;
constexpr unsigned int mmCGTT_TCP_CLK_CTRL__SI                          = 0x2B15;
constexpr unsigned int mmCGTT_VGT_CLK_CTRL__CI__VI                      = 0xF084;
constexpr unsigned int mmCGTT_VGT_CLK_CTRL__SI                          = 0x225F;
constexpr unsigned int mmCGTT_WD_CLK_CTRL__CI__VI                       = 0xF086;
constexpr unsigned int mmCG_CLKPIN_CNTL__SI                             = 0x0198;
constexpr unsigned int mmCG_DISPLAY_GAP_CNTL__SI                        = 0x020A;
constexpr unsigned int mmCG_FDO_CTRL0__SI                               = 0x01D5;
constexpr unsigned int mmCG_FDO_CTRL1__SI                               = 0x01D6;
constexpr unsigned int mmCG_FDO_CTRL2__SI                               = 0x01D7;
constexpr unsigned int mmCG_FPS_CNT__CI                                 = 0x0194;
constexpr unsigned int mmCG_FREQ_TRAN_VOTING__SI                        = 0x01EF;
constexpr unsigned int mmCG_MULT_THERMAL_CTRL__SI                       = 0x01C4;
constexpr unsigned int mmCG_MULT_THERMAL_STATUS__SI                     = 0x01C5;
constexpr unsigned int mmCG_SPLL_FUNC_CNTL_2__SI                        = 0x0181;
constexpr unsigned int mmCG_SPLL_FUNC_CNTL_3__SI                        = 0x0182;
constexpr unsigned int mmCG_SPLL_FUNC_CNTL_4__SI                        = 0x0183;
constexpr unsigned int mmCG_SPLL_FUNC_CNTL_5__SI                        = 0x0184;
constexpr unsigned int mmCG_SPLL_FUNC_CNTL__SI                          = 0x0180;
constexpr unsigned int mmCG_SPLL_SPREAD_SPECTRUM_2__SI                  = 0x0189;
constexpr unsigned int mmCG_SPLL_SPREAD_SPECTRUM__SI                    = 0x0188;
constexpr unsigned int mmCG_STATIC_SCREEN_PARAMETER__SI                 = 0x0203;
constexpr unsigned int mmCG_TACH_CTRL__SI                               = 0x01DC;
constexpr unsigned int mmCG_TACH_STATUS__SI                             = 0x01DD;
constexpr unsigned int mmCG_THERMAL_CTRL__SI                            = 0x01C0;
constexpr unsigned int mmCG_THERMAL_INT__SI                             = 0x01C2;
constexpr unsigned int mmCG_THERMAL_STATUS__SI                          = 0x01C1;
constexpr unsigned int mmCG_ULV_PARAMETER__SI                           = 0x021F;
constexpr unsigned int mmCHUB_ATC_PERFCOUNTER0_CFG__CI__VI              = 0x07D8;
constexpr unsigned int mmCHUB_ATC_PERFCOUNTER1_CFG__CI__VI              = 0x07D9;
constexpr unsigned int mmCHUB_ATC_PERFCOUNTER_HI__CI__VI                = 0x07D7;
constexpr unsigned int mmCHUB_ATC_PERFCOUNTER_LO__CI__VI                = 0x07D6;
constexpr unsigned int mmCHUB_ATC_PERFCOUNTER_RSLT_CNTL__CI__VI         = 0x07DA;
constexpr unsigned int mmCLKREQB_PAD_CNTL__CI__VI                       = 0x1521;
constexpr unsigned int mmCOHER_DEST_BASE_0                              = 0xA092;
constexpr unsigned int mmCOHER_DEST_BASE_1                              = 0xA093;
constexpr unsigned int mmCOHER_DEST_BASE_2                              = 0xA07E;
constexpr unsigned int mmCOHER_DEST_BASE_3                              = 0xA07F;
constexpr unsigned int mmCOHER_DEST_BASE_HI_0__CI__VI                   = 0xA07A;
constexpr unsigned int mmCOHER_DEST_BASE_HI_1__CI__VI                   = 0xA07B;
constexpr unsigned int mmCOHER_DEST_BASE_HI_2__CI__VI                   = 0xA07C;
constexpr unsigned int mmCOHER_DEST_BASE_HI_3__CI__VI                   = 0xA07D;
constexpr unsigned int mmCOMPUTE_DIM_X                                  = 0x2E01;
constexpr unsigned int mmCOMPUTE_DIM_Y                                  = 0x2E02;
constexpr unsigned int mmCOMPUTE_DIM_Z                                  = 0x2E03;
constexpr unsigned int mmCOMPUTE_DISPATCH_INITIATOR                     = 0x2E00;
constexpr unsigned int mmCOMPUTE_MISC_RESERVED__CI__VI                  = 0x2E1F;
constexpr unsigned int mmCOMPUTE_NUM_THREAD_X                           = 0x2E07;
constexpr unsigned int mmCOMPUTE_NUM_THREAD_Y                           = 0x2E08;
constexpr unsigned int mmCOMPUTE_NUM_THREAD_Z                           = 0x2E09;
constexpr unsigned int mmCOMPUTE_PERFCOUNT_ENABLE__CI__VI               = 0x2E0B;
constexpr unsigned int mmCOMPUTE_PGM_HI                                 = 0x2E0D;
constexpr unsigned int mmCOMPUTE_PGM_LO                                 = 0x2E0C;
constexpr unsigned int mmCOMPUTE_PGM_RSRC1                              = 0x2E12;
constexpr unsigned int mmCOMPUTE_PGM_RSRC2                              = 0x2E13;
constexpr unsigned int mmCOMPUTE_PIPELINESTAT_ENABLE__CI__VI            = 0x2E0A;
constexpr unsigned int mmCOMPUTE_RESOURCE_LIMITS                        = 0x2E15;
constexpr unsigned int mmCOMPUTE_RESTART_X__CI__VI                      = 0x2E1B;
constexpr unsigned int mmCOMPUTE_RESTART_Y__CI__VI                      = 0x2E1C;
constexpr unsigned int mmCOMPUTE_RESTART_Z__CI__VI                      = 0x2E1D;
constexpr unsigned int mmCOMPUTE_START_X                                = 0x2E04;
constexpr unsigned int mmCOMPUTE_START_Y                                = 0x2E05;
constexpr unsigned int mmCOMPUTE_START_Z                                = 0x2E06;
constexpr unsigned int mmCOMPUTE_STATIC_THREAD_MGMT_SE0                 = 0x2E16;
constexpr unsigned int mmCOMPUTE_STATIC_THREAD_MGMT_SE1                 = 0x2E17;
constexpr unsigned int mmCOMPUTE_STATIC_THREAD_MGMT_SE2__CI__VI         = 0x2E19;
constexpr unsigned int mmCOMPUTE_STATIC_THREAD_MGMT_SE3__CI__VI         = 0x2E1A;
constexpr unsigned int mmCOMPUTE_TBA_HI                                 = 0x2E0F;
constexpr unsigned int mmCOMPUTE_TBA_LO                                 = 0x2E0E;
constexpr unsigned int mmCOMPUTE_THREAD_TRACE_ENABLE__CI__VI            = 0x2E1E;
constexpr unsigned int mmCOMPUTE_TMA_HI                                 = 0x2E11;
constexpr unsigned int mmCOMPUTE_TMA_LO                                 = 0x2E10;
constexpr unsigned int mmCOMPUTE_TMPRING_SIZE                           = 0x2E18;
constexpr unsigned int mmCOMPUTE_USER_DATA_0                            = 0x2E40;
constexpr unsigned int mmCOMPUTE_USER_DATA_1                            = 0x2E41;
constexpr unsigned int mmCOMPUTE_USER_DATA_10                           = 0x2E4A;
constexpr unsigned int mmCOMPUTE_USER_DATA_11                           = 0x2E4B;
constexpr unsigned int mmCOMPUTE_USER_DATA_12                           = 0x2E4C;
constexpr unsigned int mmCOMPUTE_USER_DATA_13                           = 0x2E4D;
constexpr unsigned int mmCOMPUTE_USER_DATA_14                           = 0x2E4E;
constexpr unsigned int mmCOMPUTE_USER_DATA_15                           = 0x2E4F;
constexpr unsigned int mmCOMPUTE_USER_DATA_2                            = 0x2E42;
constexpr unsigned int mmCOMPUTE_USER_DATA_3                            = 0x2E43;
constexpr unsigned int mmCOMPUTE_USER_DATA_4                            = 0x2E44;
constexpr unsigned int mmCOMPUTE_USER_DATA_5                            = 0x2E45;
constexpr unsigned int mmCOMPUTE_USER_DATA_6                            = 0x2E46;
constexpr unsigned int mmCOMPUTE_USER_DATA_7                            = 0x2E47;
constexpr unsigned int mmCOMPUTE_USER_DATA_8                            = 0x2E48;
constexpr unsigned int mmCOMPUTE_USER_DATA_9                            = 0x2E49;
constexpr unsigned int mmCOMPUTE_VMID                                   = 0x2E14;
constexpr unsigned int mmCONFIG_APER_SIZE                               = 0x150C;
constexpr unsigned int mmCONFIG_CNTL                                    = 0x1509;
constexpr unsigned int mmCONFIG_F0_BASE                                 = 0x150B;
constexpr unsigned int mmCONFIG_MEMSIZE                                 = 0x150A;
constexpr unsigned int mmCONFIG_REG_APER_SIZE                           = 0x150D;
constexpr unsigned int mmCPC1_CONFIG__CI                                = 0x0F97;
constexpr unsigned int mmCPC2_CONFIG__CI                                = 0x0F98;
constexpr unsigned int mmCPC_INT_CNTL__CI__VI                           = 0x30B4;
constexpr unsigned int mmCPC_INT_CNTX_ID__CI__VI                        = 0x30B7;
constexpr unsigned int mmCPC_INT_STATUS__CI__VI                         = 0x30B5;
constexpr unsigned int mmCPC_PERFCOUNTER0_HI__CI__VI                    = 0xD007;
constexpr unsigned int mmCPC_PERFCOUNTER0_LO__CI__VI                    = 0xD006;
constexpr unsigned int mmCPC_PERFCOUNTER0_SELECT1__CI__VI               = 0xD804;
constexpr unsigned int mmCPC_PERFCOUNTER0_SELECT__CI__VI                = 0xD809;
constexpr unsigned int mmCPC_PERFCOUNTER1_HI__CI__VI                    = 0xD005;
constexpr unsigned int mmCPC_PERFCOUNTER1_LO__CI__VI                    = 0xD004;
constexpr unsigned int mmCPC_PERFCOUNTER1_SELECT__CI__VI                = 0xD803;
constexpr unsigned int mmCPF_PERFCOUNTER0_HI__CI__VI                    = 0xD00B;
constexpr unsigned int mmCPF_PERFCOUNTER0_LO__CI__VI                    = 0xD00A;
constexpr unsigned int mmCPF_PERFCOUNTER0_SELECT1__CI__VI               = 0xD806;
constexpr unsigned int mmCPF_PERFCOUNTER0_SELECT__CI__VI                = 0xD807;
constexpr unsigned int mmCPF_PERFCOUNTER1_HI__CI__VI                    = 0xD009;
constexpr unsigned int mmCPF_PERFCOUNTER1_LO__CI__VI                    = 0xD008;
constexpr unsigned int mmCPF_PERFCOUNTER1_SELECT__CI__VI                = 0xD805;
constexpr unsigned int mmCPG_CONFIG__CI                                 = 0x0F96;
constexpr unsigned int mmCPG_PERFCOUNTER0_HI__CI__VI                    = 0xD003;
constexpr unsigned int mmCPG_PERFCOUNTER0_LO__CI__VI                    = 0xD002;
constexpr unsigned int mmCPG_PERFCOUNTER0_SELECT1__CI__VI               = 0xD801;
constexpr unsigned int mmCPG_PERFCOUNTER0_SELECT__CI__VI                = 0xD802;
constexpr unsigned int mmCPG_PERFCOUNTER1_HI__CI__VI                    = 0xD001;
constexpr unsigned int mmCPG_PERFCOUNTER1_LO__CI__VI                    = 0xD000;
constexpr unsigned int mmCPG_PERFCOUNTER1_SELECT__CI__VI                = 0xD800;
constexpr unsigned int mmCP_APPEND_ADDR_HI__CI__VI                      = 0xC059;
constexpr unsigned int mmCP_APPEND_ADDR_HI__SI                          = 0x2159;
constexpr unsigned int mmCP_APPEND_ADDR_LO__CI__VI                      = 0xC058;
constexpr unsigned int mmCP_APPEND_ADDR_LO__SI                          = 0x2158;
constexpr unsigned int mmCP_APPEND_DATA__CI__VI                         = 0xC05A;
constexpr unsigned int mmCP_APPEND_DATA__SI                             = 0x215A;
constexpr unsigned int mmCP_APPEND_LAST_CS_FENCE__CI__VI                = 0xC05B;
constexpr unsigned int mmCP_APPEND_LAST_CS_FENCE__SI                    = 0x215B;
constexpr unsigned int mmCP_APPEND_LAST_PS_FENCE__CI__VI                = 0xC05C;
constexpr unsigned int mmCP_APPEND_LAST_PS_FENCE__SI                    = 0x215C;
constexpr unsigned int mmCP_ATOMIC_PREOP_HI__CI__VI                     = 0xC05E;
constexpr unsigned int mmCP_ATOMIC_PREOP_HI__SI                         = 0x215E;
constexpr unsigned int mmCP_ATOMIC_PREOP_LO__CI__VI                     = 0xC05D;
constexpr unsigned int mmCP_ATOMIC_PREOP_LO__SI                         = 0x215D;
constexpr unsigned int mmCP_BUSY_STAT                                   = 0x219F;
constexpr unsigned int mmCP_CEQ1_AVAIL                                  = 0x21E6;
constexpr unsigned int mmCP_CEQ2_AVAIL                                  = 0x21E7;
constexpr unsigned int mmCP_CE_COMPARE_COUNT__CI__VI                    = 0x20C0;
constexpr unsigned int mmCP_CE_COUNTER__CI__VI                          = 0xC09A;
constexpr unsigned int mmCP_CE_DE_COUNT__CI__VI                         = 0x20C1;
constexpr unsigned int mmCP_CE_HEADER_DUMP                              = 0x21A4;
constexpr unsigned int mmCP_CE_IB1_BASE_HI__CI__VI                      = 0xC0C7;
constexpr unsigned int mmCP_CE_IB1_BASE_HI__SI                          = 0x21C7;
constexpr unsigned int mmCP_CE_IB1_BASE_LO__CI__VI                      = 0xC0C6;
constexpr unsigned int mmCP_CE_IB1_BASE_LO__SI                          = 0x21C6;
constexpr unsigned int mmCP_CE_IB1_BUFSZ__CI__VI                        = 0xC0C8;
constexpr unsigned int mmCP_CE_IB1_BUFSZ__SI                            = 0x21C8;
constexpr unsigned int mmCP_CE_IB1_OFFSET__CI__VI                       = 0xC098;
constexpr unsigned int mmCP_CE_IB2_BASE_HI__CI__VI                      = 0xC0CA;
constexpr unsigned int mmCP_CE_IB2_BASE_HI__SI                          = 0x21CA;
constexpr unsigned int mmCP_CE_IB2_BASE_LO__CI__VI                      = 0xC0C9;
constexpr unsigned int mmCP_CE_IB2_BASE_LO__SI                          = 0x21C9;
constexpr unsigned int mmCP_CE_IB2_BUFSZ__CI__VI                        = 0xC0CB;
constexpr unsigned int mmCP_CE_IB2_BUFSZ__SI                            = 0x21CB;
constexpr unsigned int mmCP_CE_IB2_OFFSET__CI__VI                       = 0xC099;
constexpr unsigned int mmCP_CE_INIT_BASE_HI__CI__VI                     = 0xC0C4;
constexpr unsigned int mmCP_CE_INIT_BASE_HI__SI                         = 0x21C4;
constexpr unsigned int mmCP_CE_INIT_BASE_LO__CI__VI                     = 0xC0C3;
constexpr unsigned int mmCP_CE_INIT_BASE_LO__SI                         = 0x21C3;
constexpr unsigned int mmCP_CE_INIT_BUFSZ__CI__VI                       = 0xC0C5;
constexpr unsigned int mmCP_CE_INIT_BUFSZ__SI                           = 0x21C5;
constexpr unsigned int mmCP_CE_INTR_ROUTINE_START__CI__VI               = 0x30A8;
constexpr unsigned int mmCP_CE_PRGRM_CNTR_START__CI__VI                 = 0x30A3;
constexpr unsigned int mmCP_CE_ROQ_IB1_STAT                             = 0x21E9;
constexpr unsigned int mmCP_CE_ROQ_IB2_STAT                             = 0x21EA;
constexpr unsigned int mmCP_CE_ROQ_RB_STAT                              = 0x21E8;
constexpr unsigned int mmCP_CMD_DATA                                    = 0x21DF;
constexpr unsigned int mmCP_CMD_INDEX                                   = 0x21DE;
constexpr unsigned int mmCP_CNTX_STAT                                   = 0x21B8;
constexpr unsigned int mmCP_COHER_BASE_HI__CI__VI                       = 0xC079;
constexpr unsigned int mmCP_COHER_BASE__CI__VI                          = 0xC07E;
constexpr unsigned int mmCP_COHER_BASE__SI                              = 0x217E;
constexpr unsigned int mmCP_COHER_CNTL__CI__VI                          = 0xC07C;
constexpr unsigned int mmCP_COHER_CNTL__SI                              = 0x217C;
constexpr unsigned int mmCP_COHER_SIZE_HI__CI__VI                       = 0xC08C;
constexpr unsigned int mmCP_COHER_SIZE__CI__VI                          = 0xC07D;
constexpr unsigned int mmCP_COHER_SIZE__SI                              = 0x217D;
constexpr unsigned int mmCP_COHER_START_DELAY__CI__VI                   = 0xC07B;
constexpr unsigned int mmCP_COHER_START_DELAY__SI                       = 0x217B;
constexpr unsigned int mmCP_COHER_STATUS__CI__VI                        = 0xC07F;
constexpr unsigned int mmCP_COHER_STATUS__SI                            = 0x217F;
constexpr unsigned int mmCP_CONFIG__SI                                  = 0x0F92;
constexpr unsigned int mmCP_CONTEXT_CNTL__CI__VI                        = 0x30AD;
constexpr unsigned int mmCP_CPC_BUSY_STAT__CI__VI                       = 0x2085;
constexpr unsigned int mmCP_CPC_GRBM_FREE_COUNT__CI__VI                 = 0x208B;
constexpr unsigned int mmCP_CPC_HALT_HYST_COUNT__CI__VI                 = 0x20A7;
constexpr unsigned int mmCP_CPC_MC_CNTL__CI                             = 0x208A;
constexpr unsigned int mmCP_CPC_SCRATCH_DATA__CI__VI                    = 0x2091;
constexpr unsigned int mmCP_CPC_SCRATCH_INDEX__CI__VI                   = 0x2090;
constexpr unsigned int mmCP_CPC_STALLED_STAT1__CI__VI                   = 0x2086;
constexpr unsigned int mmCP_CPC_STATUS__CI__VI                          = 0x2084;
constexpr unsigned int mmCP_CPF_BUSY_STAT__CI__VI                       = 0x2088;
constexpr unsigned int mmCP_CPF_STALLED_STAT1__CI__VI                   = 0x2089;
constexpr unsigned int mmCP_CPF_STATUS__CI__VI                          = 0x2087;
constexpr unsigned int mmCP_CSF_CNTL                                    = 0x21B5;
constexpr unsigned int mmCP_CSF_STAT                                    = 0x21B4;
constexpr unsigned int mmCP_DEBUG                                       = 0x307F;
constexpr unsigned int mmCP_DEVICE_ID__CI__VI                           = 0x304B;
constexpr unsigned int mmCP_DE_CE_COUNT__CI__VI                         = 0x20C2;
constexpr unsigned int mmCP_DE_DE_COUNT__CI__VI                         = 0x20C4;
constexpr unsigned int mmCP_DE_LAST_INVAL_COUNT__CI__VI                 = 0x20C3;
constexpr unsigned int mmCP_DFY_ADDR_HI__CI__VI                         = 0x3022;
constexpr unsigned int mmCP_DFY_ADDR_LO__CI__VI                         = 0x3023;
constexpr unsigned int mmCP_DFY_CNTL__CI__VI                            = 0x3020;
constexpr unsigned int mmCP_DFY_DATA_0__CI__VI                          = 0x3024;
constexpr unsigned int mmCP_DFY_DATA_10__CI__VI                         = 0x302E;
constexpr unsigned int mmCP_DFY_DATA_11__CI__VI                         = 0x302F;
constexpr unsigned int mmCP_DFY_DATA_12__CI__VI                         = 0x3030;
constexpr unsigned int mmCP_DFY_DATA_13__CI__VI                         = 0x3031;
constexpr unsigned int mmCP_DFY_DATA_14__CI__VI                         = 0x3032;
constexpr unsigned int mmCP_DFY_DATA_15__CI__VI                         = 0x3033;
constexpr unsigned int mmCP_DFY_DATA_1__CI__VI                          = 0x3025;
constexpr unsigned int mmCP_DFY_DATA_2__CI__VI                          = 0x3026;
constexpr unsigned int mmCP_DFY_DATA_3__CI__VI                          = 0x3027;
constexpr unsigned int mmCP_DFY_DATA_4__CI__VI                          = 0x3028;
constexpr unsigned int mmCP_DFY_DATA_5__CI__VI                          = 0x3029;
constexpr unsigned int mmCP_DFY_DATA_6__CI__VI                          = 0x302A;
constexpr unsigned int mmCP_DFY_DATA_7__CI__VI                          = 0x302B;
constexpr unsigned int mmCP_DFY_DATA_8__CI__VI                          = 0x302C;
constexpr unsigned int mmCP_DFY_DATA_9__CI__VI                          = 0x302D;
constexpr unsigned int mmCP_DFY_STAT__CI__VI                            = 0x3021;
constexpr unsigned int mmCP_DMA_CNTL__CI__VI                            = 0xC08A;
constexpr unsigned int mmCP_DMA_CNTL__SI                                = 0x218A;
constexpr unsigned int mmCP_DMA_ME_COMMAND__CI__VI                      = 0xC084;
constexpr unsigned int mmCP_DMA_ME_COMMAND__SI                          = 0x2184;
constexpr unsigned int mmCP_DMA_ME_CONTROL__CI__VI                      = 0xC078;
constexpr unsigned int mmCP_DMA_ME_DST_ADDR_HI__CI__VI                  = 0xC083;
constexpr unsigned int mmCP_DMA_ME_DST_ADDR_HI__SI                      = 0x2183;
constexpr unsigned int mmCP_DMA_ME_DST_ADDR__CI__VI                     = 0xC082;
constexpr unsigned int mmCP_DMA_ME_DST_ADDR__SI                         = 0x2182;
constexpr unsigned int mmCP_DMA_ME_SRC_ADDR_HI__CI__VI                  = 0xC081;
constexpr unsigned int mmCP_DMA_ME_SRC_ADDR_HI__SI                      = 0x2181;
constexpr unsigned int mmCP_DMA_ME_SRC_ADDR__CI__VI                     = 0xC080;
constexpr unsigned int mmCP_DMA_ME_SRC_ADDR__SI                         = 0x2180;
constexpr unsigned int mmCP_DMA_PFP_COMMAND__CI__VI                     = 0xC089;
constexpr unsigned int mmCP_DMA_PFP_COMMAND__SI                         = 0x2189;
constexpr unsigned int mmCP_DMA_PFP_CONTROL__CI__VI                     = 0xC077;
constexpr unsigned int mmCP_DMA_PFP_DST_ADDR_HI__CI__VI                 = 0xC088;
constexpr unsigned int mmCP_DMA_PFP_DST_ADDR_HI__SI                     = 0x2188;
constexpr unsigned int mmCP_DMA_PFP_DST_ADDR__CI__VI                    = 0xC087;
constexpr unsigned int mmCP_DMA_PFP_DST_ADDR__SI                        = 0x2187;
constexpr unsigned int mmCP_DMA_PFP_SRC_ADDR_HI__CI__VI                 = 0xC086;
constexpr unsigned int mmCP_DMA_PFP_SRC_ADDR_HI__SI                     = 0x2186;
constexpr unsigned int mmCP_DMA_PFP_SRC_ADDR__CI__VI                    = 0xC085;
constexpr unsigned int mmCP_DMA_PFP_SRC_ADDR__SI                        = 0x2185;
constexpr unsigned int mmCP_DMA_READ_TAGS__CI__VI                       = 0xC08B;
constexpr unsigned int mmCP_DMA_READ_TAGS__SI                           = 0x218B;
constexpr unsigned int mmCP_ECC_FIRSTOCCURRENCE                         = 0x307A;
constexpr unsigned int mmCP_ECC_FIRSTOCCURRENCE_RING0                   = 0x307B;
constexpr unsigned int mmCP_ECC_FIRSTOCCURRENCE_RING1                   = 0x307C;
constexpr unsigned int mmCP_ECC_FIRSTOCCURRENCE_RING2                   = 0x307D;
constexpr unsigned int mmCP_ENDIAN_SWAP__CI__VI                         = 0x3050;
constexpr unsigned int mmCP_EOP_DONE_ADDR_HI__CI__VI                    = 0xC001;
constexpr unsigned int mmCP_EOP_DONE_ADDR_HI__SI                        = 0x2101;
constexpr unsigned int mmCP_EOP_DONE_ADDR_LO__CI__VI                    = 0xC000;
constexpr unsigned int mmCP_EOP_DONE_ADDR_LO__SI                        = 0x2100;
constexpr unsigned int mmCP_EOP_DONE_DATA_CNTL__CI__VI                  = 0xC0D6;
constexpr unsigned int mmCP_EOP_DONE_DATA_HI__CI__VI                    = 0xC003;
constexpr unsigned int mmCP_EOP_DONE_DATA_HI__SI                        = 0x2103;
constexpr unsigned int mmCP_EOP_DONE_DATA_LO__CI__VI                    = 0xC002;
constexpr unsigned int mmCP_EOP_DONE_DATA_LO__SI                        = 0x2102;
constexpr unsigned int mmCP_EOP_DONE_EVENT_CNTL__CI__VI                 = 0xC0D5;
constexpr unsigned int mmCP_EOP_LAST_FENCE_HI__CI__VI                   = 0xC005;
constexpr unsigned int mmCP_EOP_LAST_FENCE_HI__SI                       = 0x2105;
constexpr unsigned int mmCP_EOP_LAST_FENCE_LO__CI__VI                   = 0xC004;
constexpr unsigned int mmCP_EOP_LAST_FENCE_LO__SI                       = 0x2104;
constexpr unsigned int mmCP_FETCHER_SOURCE__CI                          = 0x3082;
constexpr unsigned int mmCP_GDS_ATOMIC0_PREOP_HI__CI__VI                = 0xC060;
constexpr unsigned int mmCP_GDS_ATOMIC0_PREOP_HI__SI                    = 0x2160;
constexpr unsigned int mmCP_GDS_ATOMIC0_PREOP_LO__CI__VI                = 0xC05F;
constexpr unsigned int mmCP_GDS_ATOMIC0_PREOP_LO__SI                    = 0x215F;
constexpr unsigned int mmCP_GDS_ATOMIC1_PREOP_HI__CI__VI                = 0xC062;
constexpr unsigned int mmCP_GDS_ATOMIC1_PREOP_HI__SI                    = 0x2162;
constexpr unsigned int mmCP_GDS_ATOMIC1_PREOP_LO__CI__VI                = 0xC061;
constexpr unsigned int mmCP_GDS_ATOMIC1_PREOP_LO__SI                    = 0x2161;
constexpr unsigned int mmCP_GRBM_FREE_COUNT                             = 0x21A3;
constexpr unsigned int mmCP_HPD_EOP_BASE_ADDR_HI__CI                    = 0x3242;
constexpr unsigned int mmCP_HPD_EOP_BASE_ADDR__CI                       = 0x3241;
constexpr unsigned int mmCP_HPD_EOP_CONTROL__CI                         = 0x3244;
constexpr unsigned int mmCP_HPD_EOP_VMID__CI                            = 0x3243;
constexpr unsigned int mmCP_HPD_ROQ_OFFSETS__CI__VI                     = 0x3240;
constexpr unsigned int mmCP_HQD_ACTIVE__CI__VI                          = 0x3247;
constexpr unsigned int mmCP_HQD_ATOMIC0_PREOP_HI__CI__VI                = 0x3262;
constexpr unsigned int mmCP_HQD_ATOMIC0_PREOP_LO__CI__VI                = 0x3261;
constexpr unsigned int mmCP_HQD_ATOMIC1_PREOP_HI__CI__VI                = 0x3264;
constexpr unsigned int mmCP_HQD_ATOMIC1_PREOP_LO__CI__VI                = 0x3263;
constexpr unsigned int mmCP_HQD_DEQUEUE_REQUEST__CI__VI                 = 0x325D;
constexpr unsigned int mmCP_HQD_DMA_OFFLOAD__CI__VI                     = 0x325E;
constexpr unsigned int mmCP_HQD_HQ_SCHEDULER0__CI__VI                   = 0x3265;
constexpr unsigned int mmCP_HQD_HQ_SCHEDULER1__CI__VI                   = 0x3266;
constexpr unsigned int mmCP_HQD_IB_BASE_ADDR_HI__CI__VI                 = 0x3258;
constexpr unsigned int mmCP_HQD_IB_BASE_ADDR__CI__VI                    = 0x3257;
constexpr unsigned int mmCP_HQD_IB_CONTROL__CI__VI                      = 0x325A;
constexpr unsigned int mmCP_HQD_IB_RPTR__CI__VI                         = 0x3259;
constexpr unsigned int mmCP_HQD_IQ_RPTR__CI__VI                         = 0x325C;
constexpr unsigned int mmCP_HQD_IQ_TIMER__CI__VI                        = 0x325B;
constexpr unsigned int mmCP_HQD_MSG_TYPE__CI__VI                        = 0x3260;
constexpr unsigned int mmCP_HQD_PERSISTENT_STATE__CI__VI                = 0x3249;
constexpr unsigned int mmCP_HQD_PIPE_PRIORITY__CI__VI                   = 0x324A;
constexpr unsigned int mmCP_HQD_PQ_BASE_HI__CI__VI                      = 0x324E;
constexpr unsigned int mmCP_HQD_PQ_BASE__CI__VI                         = 0x324D;
constexpr unsigned int mmCP_HQD_PQ_CONTROL__CI__VI                      = 0x3256;
constexpr unsigned int mmCP_HQD_PQ_DOORBELL_CONTROL__CI__VI             = 0x3254;
constexpr unsigned int mmCP_HQD_PQ_RPTR_REPORT_ADDR_HI__CI__VI          = 0x3251;
constexpr unsigned int mmCP_HQD_PQ_RPTR_REPORT_ADDR__CI__VI             = 0x3250;
constexpr unsigned int mmCP_HQD_PQ_RPTR__CI__VI                         = 0x324F;
constexpr unsigned int mmCP_HQD_PQ_WPTR_POLL_ADDR_HI__CI__VI            = 0x3253;
constexpr unsigned int mmCP_HQD_PQ_WPTR_POLL_ADDR__CI__VI               = 0x3252;
constexpr unsigned int mmCP_HQD_PQ_WPTR__CI__VI                         = 0x3255;
constexpr unsigned int mmCP_HQD_QUANTUM__CI__VI                         = 0x324C;
constexpr unsigned int mmCP_HQD_QUEUE_PRIORITY__CI__VI                  = 0x324B;
constexpr unsigned int mmCP_HQD_SEMA_CMD__CI__VI                        = 0x325F;
constexpr unsigned int mmCP_HQD_VMID__CI__VI                            = 0x3248;
constexpr unsigned int mmCP_IB1_BASE_HI__CI__VI                         = 0xC0CD;
constexpr unsigned int mmCP_IB1_BASE_HI__SI                             = 0x21CD;
constexpr unsigned int mmCP_IB1_BASE_LO__CI__VI                         = 0xC0CC;
constexpr unsigned int mmCP_IB1_BASE_LO__SI                             = 0x21CC;
constexpr unsigned int mmCP_IB1_BUFSZ__CI__VI                           = 0xC0CE;
constexpr unsigned int mmCP_IB1_BUFSZ__SI                               = 0x21CE;
constexpr unsigned int mmCP_IB1_OFFSET__CI__VI                          = 0xC092;
constexpr unsigned int mmCP_IB1_OFFSET__SI                              = 0x2192;
constexpr unsigned int mmCP_IB1_PREAMBLE_BEGIN__CI__VI                  = 0xC094;
constexpr unsigned int mmCP_IB1_PREAMBLE_BEGIN__SI                      = 0x2194;
constexpr unsigned int mmCP_IB1_PREAMBLE_END__CI__VI                    = 0xC095;
constexpr unsigned int mmCP_IB1_PREAMBLE_END__SI                        = 0x2195;
constexpr unsigned int mmCP_IB2_BASE_HI__CI__VI                         = 0xC0D0;
constexpr unsigned int mmCP_IB2_BASE_HI__SI                             = 0x21D0;
constexpr unsigned int mmCP_IB2_BASE_LO__CI__VI                         = 0xC0CF;
constexpr unsigned int mmCP_IB2_BASE_LO__SI                             = 0x21CF;
constexpr unsigned int mmCP_IB2_BUFSZ__CI__VI                           = 0xC0D1;
constexpr unsigned int mmCP_IB2_BUFSZ__SI                               = 0x21D1;
constexpr unsigned int mmCP_IB2_OFFSET__CI__VI                          = 0xC093;
constexpr unsigned int mmCP_IB2_OFFSET__SI                              = 0x2193;
constexpr unsigned int mmCP_IB2_PREAMBLE_BEGIN__CI__VI                  = 0xC096;
constexpr unsigned int mmCP_IB2_PREAMBLE_BEGIN__SI                      = 0x2196;
constexpr unsigned int mmCP_IB2_PREAMBLE_END__CI__VI                    = 0xC097;
constexpr unsigned int mmCP_IB2_PREAMBLE_END__SI                        = 0x2197;
constexpr unsigned int mmCP_INT_CNTL                                    = 0x3049;
constexpr unsigned int mmCP_INT_CNTL_RING0                              = 0x306A;
constexpr unsigned int mmCP_INT_CNTL_RING1                              = 0x306B;
constexpr unsigned int mmCP_INT_CNTL_RING2                              = 0x306C;
constexpr unsigned int mmCP_INT_STATUS                                  = 0x304A;
constexpr unsigned int mmCP_INT_STATUS_RING0                            = 0x306D;
constexpr unsigned int mmCP_INT_STATUS_RING1                            = 0x306E;
constexpr unsigned int mmCP_INT_STATUS_RING2                            = 0x306F;
constexpr unsigned int mmCP_INT_STAT_DEBUG                              = 0x21F7;
constexpr unsigned int mmCP_IQ_WAIT_TIME1__CI__VI                       = 0x30AF;
constexpr unsigned int mmCP_IQ_WAIT_TIME2__CI__VI                       = 0x30B0;
constexpr unsigned int mmCP_MAX_CONTEXT__CI__VI                         = 0x30AE;
constexpr unsigned int mmCP_MC_PACK_DELAY_CNT__SI__CI                   = 0x21A7;
constexpr unsigned int mmCP_MC_TAG_CNTL__CI                             = 0x21A8;
constexpr unsigned int mmCP_MC_TAG_DATA__CI                             = 0x21A9;
constexpr unsigned int mmCP_ME0_PIPE0_PRIORITY__CI__VI                  = 0x304D;
constexpr unsigned int mmCP_ME0_PIPE0_VMID__CI__VI                      = 0x3052;
constexpr unsigned int mmCP_ME0_PIPE1_PRIORITY__CI__VI                  = 0x304E;
constexpr unsigned int mmCP_ME0_PIPE1_VMID__CI__VI                      = 0x3053;
constexpr unsigned int mmCP_ME0_PIPE2_PRIORITY__CI__VI                  = 0x304F;
constexpr unsigned int mmCP_ME0_PIPE_PRIORITY_CNTS__CI__VI              = 0x304C;
constexpr unsigned int mmCP_ME1_INT_STAT_DEBUG__CI__VI                  = 0x3095;
constexpr unsigned int mmCP_ME1_PIPE0_INT_CNTL__CI__VI                  = 0x3085;
constexpr unsigned int mmCP_ME1_PIPE0_INT_STATUS__CI__VI                = 0x308D;
constexpr unsigned int mmCP_ME1_PIPE0_PRIORITY__CI__VI                  = 0x309A;
constexpr unsigned int mmCP_ME1_PIPE1_INT_CNTL__CI__VI                  = 0x3086;
constexpr unsigned int mmCP_ME1_PIPE1_INT_STATUS__CI__VI                = 0x308E;
constexpr unsigned int mmCP_ME1_PIPE1_PRIORITY__CI__VI                  = 0x309B;
constexpr unsigned int mmCP_ME1_PIPE2_INT_CNTL__CI__VI                  = 0x3087;
constexpr unsigned int mmCP_ME1_PIPE2_INT_STATUS__CI__VI                = 0x308F;
constexpr unsigned int mmCP_ME1_PIPE2_PRIORITY__CI__VI                  = 0x309C;
constexpr unsigned int mmCP_ME1_PIPE3_INT_CNTL__CI__VI                  = 0x3088;
constexpr unsigned int mmCP_ME1_PIPE3_INT_STATUS__CI__VI                = 0x3090;
constexpr unsigned int mmCP_ME1_PIPE3_PRIORITY__CI__VI                  = 0x309D;
constexpr unsigned int mmCP_ME1_PIPE_PRIORITY_CNTS__CI__VI              = 0x3099;
constexpr unsigned int mmCP_ME2_INT_STAT_DEBUG__CI__VI                  = 0x3096;
constexpr unsigned int mmCP_ME2_PIPE0_INT_CNTL__CI__VI                  = 0x3089;
constexpr unsigned int mmCP_ME2_PIPE0_INT_STATUS__CI__VI                = 0x3091;
constexpr unsigned int mmCP_ME2_PIPE0_PRIORITY__CI__VI                  = 0x309F;
constexpr unsigned int mmCP_ME2_PIPE1_INT_CNTL__CI__VI                  = 0x308A;
constexpr unsigned int mmCP_ME2_PIPE1_INT_STATUS__CI__VI                = 0x3092;
constexpr unsigned int mmCP_ME2_PIPE1_PRIORITY__CI__VI                  = 0x30A0;
constexpr unsigned int mmCP_ME2_PIPE2_INT_CNTL__CI__VI                  = 0x308B;
constexpr unsigned int mmCP_ME2_PIPE2_INT_STATUS__CI__VI                = 0x3093;
constexpr unsigned int mmCP_ME2_PIPE2_PRIORITY__CI__VI                  = 0x30A1;
constexpr unsigned int mmCP_ME2_PIPE3_INT_CNTL__CI__VI                  = 0x308C;
constexpr unsigned int mmCP_ME2_PIPE3_INT_STATUS__CI__VI                = 0x3094;
constexpr unsigned int mmCP_ME2_PIPE3_PRIORITY__CI__VI                  = 0x30A2;
constexpr unsigned int mmCP_ME2_PIPE_PRIORITY_CNTS__CI__VI              = 0x309E;
constexpr unsigned int mmCP_MEC1_INTR_ROUTINE_START__CI__VI             = 0x30AB;
constexpr unsigned int mmCP_MEC1_PRGRM_CNTR_START__CI__VI               = 0x30A6;
constexpr unsigned int mmCP_MEC2_INTR_ROUTINE_START__CI__VI             = 0x30AC;
constexpr unsigned int mmCP_MEC2_PRGRM_CNTR_START__CI__VI               = 0x30A7;
constexpr unsigned int mmCP_MEC_CNTL__CI__VI                            = 0x208D;
constexpr unsigned int mmCP_MEC_ME1_HEADER_DUMP__CI__VI                 = 0x208E;
constexpr unsigned int mmCP_MEC_ME1_UCODE_ADDR__CI                      = 0x305C;
constexpr unsigned int mmCP_MEC_ME1_UCODE_DATA__CI                      = 0x305D;
constexpr unsigned int mmCP_MEC_ME2_HEADER_DUMP__CI__VI                 = 0x208F;
constexpr unsigned int mmCP_MEC_ME2_UCODE_ADDR__CI                      = 0x305E;
constexpr unsigned int mmCP_MEC_ME2_UCODE_DATA__CI                      = 0x305F;
constexpr unsigned int mmCP_MEM_SLP_CNTL                                = 0x3079;
constexpr unsigned int mmCP_MEQ_AVAIL                                   = 0x21DD;
constexpr unsigned int mmCP_MEQ_STAT                                    = 0x21E5;
constexpr unsigned int mmCP_MEQ_STQ_THRESHOLD__CI__VI                   = 0x21BD;
constexpr unsigned int mmCP_MEQ_THRESHOLDS                              = 0x21D9;
constexpr unsigned int mmCP_ME_ATOMIC_PREOP_HI__CI__VI                  = 0xC05E;
constexpr unsigned int mmCP_ME_ATOMIC_PREOP_LO__CI__VI                  = 0xC05D;
constexpr unsigned int mmCP_ME_CNTL                                     = 0x21B6;
constexpr unsigned int mmCP_ME_GDS_ATOMIC0_PREOP_HI__CI__VI             = 0xC060;
constexpr unsigned int mmCP_ME_GDS_ATOMIC0_PREOP_LO__CI__VI             = 0xC05F;
constexpr unsigned int mmCP_ME_GDS_ATOMIC1_PREOP_HI__CI__VI             = 0xC062;
constexpr unsigned int mmCP_ME_GDS_ATOMIC1_PREOP_LO__CI__VI             = 0xC061;
constexpr unsigned int mmCP_ME_HEADER_DUMP                              = 0x21A1;
constexpr unsigned int mmCP_ME_INTR_ROUTINE_START__CI__VI               = 0x30AA;
constexpr unsigned int mmCP_ME_MC_RADDR_HI__CI__VI                      = 0xC06E;
constexpr unsigned int mmCP_ME_MC_RADDR_HI__SI                          = 0x216E;
constexpr unsigned int mmCP_ME_MC_RADDR_LO__CI__VI                      = 0xC06D;
constexpr unsigned int mmCP_ME_MC_RADDR_LO__SI                          = 0x216D;
constexpr unsigned int mmCP_ME_MC_WADDR_HI__CI__VI                      = 0xC06A;
constexpr unsigned int mmCP_ME_MC_WADDR_HI__SI                          = 0x216A;
constexpr unsigned int mmCP_ME_MC_WADDR_LO__CI__VI                      = 0xC069;
constexpr unsigned int mmCP_ME_MC_WADDR_LO__SI                          = 0x2169;
constexpr unsigned int mmCP_ME_MC_WDATA_HI__CI__VI                      = 0xC06C;
constexpr unsigned int mmCP_ME_MC_WDATA_HI__SI                          = 0x216C;
constexpr unsigned int mmCP_ME_MC_WDATA_LO__CI__VI                      = 0xC06B;
constexpr unsigned int mmCP_ME_MC_WDATA_LO__SI                          = 0x216B;
constexpr unsigned int mmCP_ME_PREEMPTION                               = 0x21B9;
constexpr unsigned int mmCP_ME_PRGRM_CNTR_START__CI__VI                 = 0x30A5;
constexpr unsigned int mmCP_MQD_BASE_ADDR_HI__CI__VI                    = 0x3246;
constexpr unsigned int mmCP_MQD_BASE_ADDR__CI__VI                       = 0x3245;
constexpr unsigned int mmCP_MQD_CONTROL__CI__VI                         = 0x3267;
constexpr unsigned int mmCP_NUM_PRIM_NEEDED_COUNT0_HI__CI__VI           = 0xC00B;
constexpr unsigned int mmCP_NUM_PRIM_NEEDED_COUNT0_HI__SI               = 0x210B;
constexpr unsigned int mmCP_NUM_PRIM_NEEDED_COUNT0_LO__CI__VI           = 0xC00A;
constexpr unsigned int mmCP_NUM_PRIM_NEEDED_COUNT0_LO__SI               = 0x210A;
constexpr unsigned int mmCP_NUM_PRIM_NEEDED_COUNT1_HI__CI__VI           = 0xC00F;
constexpr unsigned int mmCP_NUM_PRIM_NEEDED_COUNT1_HI__SI               = 0x210F;
constexpr unsigned int mmCP_NUM_PRIM_NEEDED_COUNT1_LO__CI__VI           = 0xC00E;
constexpr unsigned int mmCP_NUM_PRIM_NEEDED_COUNT1_LO__SI               = 0x210E;
constexpr unsigned int mmCP_NUM_PRIM_NEEDED_COUNT2_HI__CI__VI           = 0xC013;
constexpr unsigned int mmCP_NUM_PRIM_NEEDED_COUNT2_HI__SI               = 0x2113;
constexpr unsigned int mmCP_NUM_PRIM_NEEDED_COUNT2_LO__CI__VI           = 0xC012;
constexpr unsigned int mmCP_NUM_PRIM_NEEDED_COUNT2_LO__SI               = 0x2112;
constexpr unsigned int mmCP_NUM_PRIM_NEEDED_COUNT3_HI__CI__VI           = 0xC017;
constexpr unsigned int mmCP_NUM_PRIM_NEEDED_COUNT3_HI__SI               = 0x2117;
constexpr unsigned int mmCP_NUM_PRIM_NEEDED_COUNT3_LO__CI__VI           = 0xC016;
constexpr unsigned int mmCP_NUM_PRIM_NEEDED_COUNT3_LO__SI               = 0x2116;
constexpr unsigned int mmCP_NUM_PRIM_WRITTEN_COUNT0_HI__CI__VI          = 0xC009;
constexpr unsigned int mmCP_NUM_PRIM_WRITTEN_COUNT0_HI__SI              = 0x2109;
constexpr unsigned int mmCP_NUM_PRIM_WRITTEN_COUNT0_LO__CI__VI          = 0xC008;
constexpr unsigned int mmCP_NUM_PRIM_WRITTEN_COUNT0_LO__SI              = 0x2108;
constexpr unsigned int mmCP_NUM_PRIM_WRITTEN_COUNT1_HI__CI__VI          = 0xC00D;
constexpr unsigned int mmCP_NUM_PRIM_WRITTEN_COUNT1_HI__SI              = 0x210D;
constexpr unsigned int mmCP_NUM_PRIM_WRITTEN_COUNT1_LO__CI__VI          = 0xC00C;
constexpr unsigned int mmCP_NUM_PRIM_WRITTEN_COUNT1_LO__SI              = 0x210C;
constexpr unsigned int mmCP_NUM_PRIM_WRITTEN_COUNT2_HI__CI__VI          = 0xC011;
constexpr unsigned int mmCP_NUM_PRIM_WRITTEN_COUNT2_HI__SI              = 0x2111;
constexpr unsigned int mmCP_NUM_PRIM_WRITTEN_COUNT2_LO__CI__VI          = 0xC010;
constexpr unsigned int mmCP_NUM_PRIM_WRITTEN_COUNT2_LO__SI              = 0x2110;
constexpr unsigned int mmCP_NUM_PRIM_WRITTEN_COUNT3_HI__CI__VI          = 0xC015;
constexpr unsigned int mmCP_NUM_PRIM_WRITTEN_COUNT3_HI__SI              = 0x2115;
constexpr unsigned int mmCP_NUM_PRIM_WRITTEN_COUNT3_LO__CI__VI          = 0xC014;
constexpr unsigned int mmCP_NUM_PRIM_WRITTEN_COUNT3_LO__SI              = 0x2114;
constexpr unsigned int mmCP_PA_CINVOC_COUNT_HI__CI__VI                  = 0xC029;
constexpr unsigned int mmCP_PA_CINVOC_COUNT_HI__SI                      = 0x2129;
constexpr unsigned int mmCP_PA_CINVOC_COUNT_LO__CI__VI                  = 0xC028;
constexpr unsigned int mmCP_PA_CINVOC_COUNT_LO__SI                      = 0x2128;
constexpr unsigned int mmCP_PA_CPRIM_COUNT_HI__CI__VI                   = 0xC02B;
constexpr unsigned int mmCP_PA_CPRIM_COUNT_HI__SI                       = 0x212B;
constexpr unsigned int mmCP_PA_CPRIM_COUNT_LO__CI__VI                   = 0xC02A;
constexpr unsigned int mmCP_PA_CPRIM_COUNT_LO__SI                       = 0x212A;
constexpr unsigned int mmCP_PERFCOUNTER_HI__SI                          = 0x21FE;
constexpr unsigned int mmCP_PERFCOUNTER_LO__SI                          = 0x21FD;
constexpr unsigned int mmCP_PERFCOUNTER_SELECT__SI                      = 0x21FC;
constexpr unsigned int mmCP_PERFMON_CNTL__CI__VI                        = 0xD808;
constexpr unsigned int mmCP_PERFMON_CNTL__SI                            = 0x21FF;
constexpr unsigned int mmCP_PERFMON_CNTX_CNTL                           = 0xA0D8;
constexpr unsigned int mmCP_PFP_ATOMIC_PREOP_HI__CI__VI                 = 0xC053;
constexpr unsigned int mmCP_PFP_ATOMIC_PREOP_LO__CI__VI                 = 0xC052;
constexpr unsigned int mmCP_PFP_GDS_ATOMIC0_PREOP_HI__CI__VI            = 0xC055;
constexpr unsigned int mmCP_PFP_GDS_ATOMIC0_PREOP_LO__CI__VI            = 0xC054;
constexpr unsigned int mmCP_PFP_GDS_ATOMIC1_PREOP_HI__CI__VI            = 0xC057;
constexpr unsigned int mmCP_PFP_GDS_ATOMIC1_PREOP_LO__CI__VI            = 0xC056;
constexpr unsigned int mmCP_PFP_HEADER_DUMP                             = 0x21A2;
constexpr unsigned int mmCP_PFP_IB_CONTROL__CI__VI                      = 0xC08D;
constexpr unsigned int mmCP_PFP_IB_CONTROL__SI                          = 0x218D;
constexpr unsigned int mmCP_PFP_INTR_ROUTINE_START__CI__VI              = 0x30A9;
constexpr unsigned int mmCP_PFP_LOAD_CONTROL__CI__VI                    = 0xC08E;
constexpr unsigned int mmCP_PFP_LOAD_CONTROL__SI                        = 0x218E;
constexpr unsigned int mmCP_PFP_PRGRM_CNTR_START__CI__VI                = 0x30A4;
constexpr unsigned int mmCP_PIPEID__CI__VI                              = 0xA0D9;
constexpr unsigned int mmCP_PIPE_STATS_ADDR_HI__CI__VI                  = 0xC019;
constexpr unsigned int mmCP_PIPE_STATS_ADDR_HI__SI                      = 0x2119;
constexpr unsigned int mmCP_PIPE_STATS_ADDR_LO__CI__VI                  = 0xC018;
constexpr unsigned int mmCP_PIPE_STATS_ADDR_LO__SI                      = 0x2118;
constexpr unsigned int mmCP_PQ_WPTR_POLL_CNTL1__CI__VI                  = 0x3084;
constexpr unsigned int mmCP_PQ_WPTR_POLL_CNTL__CI__VI                   = 0x3083;
constexpr unsigned int mmCP_PRT_LOD_STATS_CNTL0__CI__VI                 = 0x20AD;
constexpr unsigned int mmCP_PRT_LOD_STATS_CNTL1__CI__VI                 = 0x20AE;
constexpr unsigned int mmCP_PRT_LOD_STATS_CNTL2__CI__VI                 = 0x20AF;
constexpr unsigned int mmCP_PWR_CNTL                                    = 0x3078;
constexpr unsigned int mmCP_QUEUE_THRESHOLDS                            = 0x21D8;
constexpr unsigned int mmCP_RB0_BASE                                    = 0x3040;
constexpr unsigned int mmCP_RB0_BASE_HI__CI__VI                         = 0x30B1;
constexpr unsigned int mmCP_RB0_CNTL                                    = 0x3041;
constexpr unsigned int mmCP_RB0_RPTR                                    = 0x21C0;
constexpr unsigned int mmCP_RB0_RPTR_ADDR                               = 0x3043;
constexpr unsigned int mmCP_RB0_RPTR_ADDR_HI                            = 0x3044;
constexpr unsigned int mmCP_RB0_WPTR                                    = 0x3045;
constexpr unsigned int mmCP_RB1_BASE                                    = 0x3060;
constexpr unsigned int mmCP_RB1_BASE_HI__CI__VI                         = 0x30B2;
constexpr unsigned int mmCP_RB1_CNTL                                    = 0x3061;
constexpr unsigned int mmCP_RB1_RPTR                                    = 0x21BF;
constexpr unsigned int mmCP_RB1_RPTR_ADDR                               = 0x3062;
constexpr unsigned int mmCP_RB1_RPTR_ADDR_HI                            = 0x3063;
constexpr unsigned int mmCP_RB1_WPTR                                    = 0x3064;
constexpr unsigned int mmCP_RB2_BASE                                    = 0x3065;
constexpr unsigned int mmCP_RB2_CNTL                                    = 0x3066;
constexpr unsigned int mmCP_RB2_RPTR                                    = 0x21BE;
constexpr unsigned int mmCP_RB2_RPTR_ADDR                               = 0x3067;
constexpr unsigned int mmCP_RB2_RPTR_ADDR_HI                            = 0x3068;
constexpr unsigned int mmCP_RB2_WPTR                                    = 0x3069;
constexpr unsigned int mmCP_RB_BASE                                     = 0x3040;
constexpr unsigned int mmCP_RB_CNTL                                     = 0x3041;
constexpr unsigned int mmCP_RB_OFFSET__CI__VI                           = 0xC091;
constexpr unsigned int mmCP_RB_OFFSET__SI                               = 0x2191;
constexpr unsigned int mmCP_RB_RPTR                                     = 0x21C0;
constexpr unsigned int mmCP_RB_RPTR_ADDR                                = 0x3043;
constexpr unsigned int mmCP_RB_RPTR_ADDR_HI                             = 0x3044;
constexpr unsigned int mmCP_RB_RPTR_WR                                  = 0x3042;
constexpr unsigned int mmCP_RB_VMID                                     = 0x3051;
constexpr unsigned int mmCP_RB_WPTR                                     = 0x3045;
constexpr unsigned int mmCP_RB_WPTR_DELAY                               = 0x21C1;
constexpr unsigned int mmCP_RB_WPTR_POLL_ADDR_HI                        = 0x3047;
constexpr unsigned int mmCP_RB_WPTR_POLL_ADDR_LO                        = 0x3046;
constexpr unsigned int mmCP_RB_WPTR_POLL_CNTL                           = 0x21C2;
constexpr unsigned int mmCP_RING0_PRIORITY                              = 0x304D;
constexpr unsigned int mmCP_RING1_PRIORITY                              = 0x304E;
constexpr unsigned int mmCP_RING2_PRIORITY                              = 0x304F;
constexpr unsigned int mmCP_RINGID                                      = 0xA0D9;
constexpr unsigned int mmCP_RING_PRIORITY_CNTS                          = 0x304C;
constexpr unsigned int mmCP_ROQ1_THRESHOLDS                             = 0x21D5;
constexpr unsigned int mmCP_ROQ2_AVAIL                                  = 0x21DC;
constexpr unsigned int mmCP_ROQ2_THRESHOLDS                             = 0x21D6;
constexpr unsigned int mmCP_ROQ_AVAIL                                   = 0x21DA;
constexpr unsigned int mmCP_ROQ_IB1_STAT                                = 0x21E1;
constexpr unsigned int mmCP_ROQ_IB2_STAT                                = 0x21E2;
constexpr unsigned int mmCP_ROQ_RB_STAT                                 = 0x21E0;
constexpr unsigned int mmCP_ROQ_THRESHOLDS__CI__VI                      = 0x21BC;
constexpr unsigned int mmCP_SCRATCH_DATA__CI__VI                        = 0xC090;
constexpr unsigned int mmCP_SCRATCH_DATA__SI                            = 0x2190;
constexpr unsigned int mmCP_SCRATCH_INDEX__CI__VI                       = 0xC08F;
constexpr unsigned int mmCP_SCRATCH_INDEX__SI                           = 0x218F;
constexpr unsigned int mmCP_SC_PSINVOC_COUNT0_HI__CI__VI                = 0xC02D;
constexpr unsigned int mmCP_SC_PSINVOC_COUNT0_HI__SI                    = 0x212D;
constexpr unsigned int mmCP_SC_PSINVOC_COUNT0_LO__CI__VI                = 0xC02C;
constexpr unsigned int mmCP_SC_PSINVOC_COUNT0_LO__SI                    = 0x212C;
constexpr unsigned int mmCP_SC_PSINVOC_COUNT1_HI__CI__VI                = 0xC02F;
constexpr unsigned int mmCP_SC_PSINVOC_COUNT1_HI__SI                    = 0x212F;
constexpr unsigned int mmCP_SC_PSINVOC_COUNT1_LO__CI__VI                = 0xC02E;
constexpr unsigned int mmCP_SC_PSINVOC_COUNT1_LO__SI                    = 0x212E;
constexpr unsigned int mmCP_SEM_WAIT_TIMER__CI__VI                      = 0xC06F;
constexpr unsigned int mmCP_SEM_WAIT_TIMER__SI                          = 0x216F;
constexpr unsigned int mmCP_SIG_SEM_ADDR_HI__CI__VI                     = 0xC071;
constexpr unsigned int mmCP_SIG_SEM_ADDR_HI__SI                         = 0x2171;
constexpr unsigned int mmCP_SIG_SEM_ADDR_LO__CI__VI                     = 0xC070;
constexpr unsigned int mmCP_SIG_SEM_ADDR_LO__SI                         = 0x2170;
constexpr unsigned int mmCP_STALLED_STAT1                               = 0x219D;
constexpr unsigned int mmCP_STALLED_STAT2                               = 0x219E;
constexpr unsigned int mmCP_STALLED_STAT3                               = 0x219C;
constexpr unsigned int mmCP_STAT                                        = 0x21A0;
constexpr unsigned int mmCP_STQ_AVAIL                                   = 0x21DB;
constexpr unsigned int mmCP_STQ_STAT                                    = 0x21E3;
constexpr unsigned int mmCP_STQ_THRESHOLDS                              = 0x21D7;
constexpr unsigned int mmCP_STQ_WR_STAT__CI__VI                         = 0x21E4;
constexpr unsigned int mmCP_STREAM_OUT_ADDR_HI__CI__VI                  = 0xC007;
constexpr unsigned int mmCP_STREAM_OUT_ADDR_HI__SI                      = 0x2107;
constexpr unsigned int mmCP_STREAM_OUT_ADDR_LO__CI__VI                  = 0xC006;
constexpr unsigned int mmCP_STREAM_OUT_ADDR_LO__SI                      = 0x2106;
constexpr unsigned int mmCP_STRMOUT_CNTL__CI__VI                        = 0xC03F;
constexpr unsigned int mmCP_STRMOUT_CNTL__SI                            = 0x213F;
constexpr unsigned int mmCP_ST_BASE_HI__CI__VI                          = 0xC0D3;
constexpr unsigned int mmCP_ST_BASE_HI__SI                              = 0x21D3;
constexpr unsigned int mmCP_ST_BASE_LO__CI__VI                          = 0xC0D2;
constexpr unsigned int mmCP_ST_BASE_LO__SI                              = 0x21D2;
constexpr unsigned int mmCP_ST_BUFSZ__CI__VI                            = 0xC0D4;
constexpr unsigned int mmCP_ST_BUFSZ__SI                                = 0x21D4;
constexpr unsigned int mmCP_VGT_CSINVOC_COUNT_HI__CI__VI                = 0xC031;
constexpr unsigned int mmCP_VGT_CSINVOC_COUNT_HI__SI                    = 0x2131;
constexpr unsigned int mmCP_VGT_CSINVOC_COUNT_LO__CI__VI                = 0xC030;
constexpr unsigned int mmCP_VGT_CSINVOC_COUNT_LO__SI                    = 0x2130;
constexpr unsigned int mmCP_VGT_DSINVOC_COUNT_HI__CI__VI                = 0xC027;
constexpr unsigned int mmCP_VGT_DSINVOC_COUNT_HI__SI                    = 0x2127;
constexpr unsigned int mmCP_VGT_DSINVOC_COUNT_LO__CI__VI                = 0xC026;
constexpr unsigned int mmCP_VGT_DSINVOC_COUNT_LO__SI                    = 0x2126;
constexpr unsigned int mmCP_VGT_GSINVOC_COUNT_HI__CI__VI                = 0xC023;
constexpr unsigned int mmCP_VGT_GSINVOC_COUNT_HI__SI                    = 0x2123;
constexpr unsigned int mmCP_VGT_GSINVOC_COUNT_LO__CI__VI                = 0xC022;
constexpr unsigned int mmCP_VGT_GSINVOC_COUNT_LO__SI                    = 0x2122;
constexpr unsigned int mmCP_VGT_GSPRIM_COUNT_HI__CI__VI                 = 0xC01F;
constexpr unsigned int mmCP_VGT_GSPRIM_COUNT_HI__SI                     = 0x211F;
constexpr unsigned int mmCP_VGT_GSPRIM_COUNT_LO__CI__VI                 = 0xC01E;
constexpr unsigned int mmCP_VGT_GSPRIM_COUNT_LO__SI                     = 0x211E;
constexpr unsigned int mmCP_VGT_HSINVOC_COUNT_HI__CI__VI                = 0xC025;
constexpr unsigned int mmCP_VGT_HSINVOC_COUNT_HI__SI                    = 0x2125;
constexpr unsigned int mmCP_VGT_HSINVOC_COUNT_LO__CI__VI                = 0xC024;
constexpr unsigned int mmCP_VGT_HSINVOC_COUNT_LO__SI                    = 0x2124;
constexpr unsigned int mmCP_VGT_IAPRIM_COUNT_HI__CI__VI                 = 0xC01D;
constexpr unsigned int mmCP_VGT_IAPRIM_COUNT_HI__SI                     = 0x211D;
constexpr unsigned int mmCP_VGT_IAPRIM_COUNT_LO__CI__VI                 = 0xC01C;
constexpr unsigned int mmCP_VGT_IAPRIM_COUNT_LO__SI                     = 0x211C;
constexpr unsigned int mmCP_VGT_IAVERT_COUNT_HI__CI__VI                 = 0xC01B;
constexpr unsigned int mmCP_VGT_IAVERT_COUNT_HI__SI                     = 0x211B;
constexpr unsigned int mmCP_VGT_IAVERT_COUNT_LO__CI__VI                 = 0xC01A;
constexpr unsigned int mmCP_VGT_IAVERT_COUNT_LO__SI                     = 0x211A;
constexpr unsigned int mmCP_VGT_VSINVOC_COUNT_HI__CI__VI                = 0xC021;
constexpr unsigned int mmCP_VGT_VSINVOC_COUNT_HI__SI                    = 0x2121;
constexpr unsigned int mmCP_VGT_VSINVOC_COUNT_LO__CI__VI                = 0xC020;
constexpr unsigned int mmCP_VGT_VSINVOC_COUNT_LO__SI                    = 0x2120;
constexpr unsigned int mmCP_VMID                                        = 0xA0DA;
constexpr unsigned int mmCP_VMID_PREEMPT__CI__VI                        = 0x30B6;
constexpr unsigned int mmCP_VMID_RESET__CI__VI                          = 0x30B3;
constexpr unsigned int mmCP_WAIT_REG_MEM_TIMEOUT__CI__VI                = 0xC074;
constexpr unsigned int mmCP_WAIT_REG_MEM_TIMEOUT__SI                    = 0x2174;
constexpr unsigned int mmCP_WAIT_SEM_ADDR_HI__CI__VI                    = 0xC076;
constexpr unsigned int mmCP_WAIT_SEM_ADDR_HI__SI                        = 0x2176;
constexpr unsigned int mmCP_WAIT_SEM_ADDR_LO__CI__VI                    = 0xC075;
constexpr unsigned int mmCP_WAIT_SEM_ADDR_LO__SI                        = 0x2175;
constexpr unsigned int mmCRTC0_CRTC_ALLOW_STOP_OFF_V_CNT__SI__VI        = 0x1BC3;
constexpr unsigned int mmCRTC0_CRTC_BLACK_COLOR__SI                     = 0x1BA2;
constexpr unsigned int mmCRTC0_CRTC_BLANK_CONTROL                       = 0x1B9D;
constexpr unsigned int mmCRTC0_CRTC_BLANK_DATA_COLOR__SI                = 0x1BA1;
constexpr unsigned int mmCRTC0_CRTC_CONTROL__SI__VI                     = 0x1B9C;
constexpr unsigned int mmCRTC0_CRTC_COUNT_CONTROL__SI__VI               = 0x1BA9;
constexpr unsigned int mmCRTC0_CRTC_COUNT_RESET__SI__VI                 = 0x1BAA;
constexpr unsigned int mmCRTC0_CRTC_DOUBLE_BUFFER_CONTROL__SI__VI       = 0x1BB6;
constexpr unsigned int mmCRTC0_CRTC_DTMTEST_CNTL__SI__VI                = 0x1B92;
constexpr unsigned int mmCRTC0_CRTC_DTMTEST_STATUS_POSITION__SI__VI     = 0x1B93;
constexpr unsigned int mmCRTC0_CRTC_FLOW_CONTROL__SI__VI                = 0x1B99;
constexpr unsigned int mmCRTC0_CRTC_FORCE_COUNT_NOW_CNTL__SI__VI        = 0x1B98;
constexpr unsigned int mmCRTC0_CRTC_H_BLANK_START_END__SI__VI           = 0x1B81;
constexpr unsigned int mmCRTC0_CRTC_H_SYNC_A_CNTL__SI__VI               = 0x1B83;
constexpr unsigned int mmCRTC0_CRTC_H_SYNC_A__SI__VI                    = 0x1B82;
constexpr unsigned int mmCRTC0_CRTC_H_SYNC_B_CNTL__SI__VI               = 0x1B85;
constexpr unsigned int mmCRTC0_CRTC_H_SYNC_B__SI__VI                    = 0x1B84;
constexpr unsigned int mmCRTC0_CRTC_H_TOTAL__SI__VI                     = 0x1B80;
constexpr unsigned int mmCRTC0_CRTC_INTERLACE_CONTROL__SI__VI           = 0x1B9E;
constexpr unsigned int mmCRTC0_CRTC_INTERLACE_STATUS__SI__VI            = 0x1B9F;
constexpr unsigned int mmCRTC0_CRTC_INTERRUPT_CONTROL__SI__VI           = 0x1BB4;
constexpr unsigned int mmCRTC0_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE__SI__VI  = 0x1BAB;
constexpr unsigned int mmCRTC0_CRTC_MASTER_EN__SI__VI                   = 0x1BC2;
constexpr unsigned int mmCRTC0_CRTC_MVP_INBAND_CNTL_INSERT_TIMER__SI__VI  = 0x1BC0;
constexpr unsigned int mmCRTC0_CRTC_MVP_INBAND_CNTL_INSERT__SI__VI      = 0x1BBF;
constexpr unsigned int mmCRTC0_CRTC_MVP_STATUS__SI__VI                  = 0x1BC1;
constexpr unsigned int mmCRTC0_CRTC_NOM_VERT_POSITION__SI__VI           = 0x1BA5;
constexpr unsigned int mmCRTC0_CRTC_OVERSCAN_COLOR__SI                  = 0x1BA0;
constexpr unsigned int mmCRTC0_CRTC_PIXEL_DATA_READBACK__SI             = 0x1B9A;
constexpr unsigned int mmCRTC0_CRTC_SNAPSHOT_CONTROL__SI__VI            = 0x1BB0;
constexpr unsigned int mmCRTC0_CRTC_SNAPSHOT_FRAME__SI__VI              = 0x1BB2;
constexpr unsigned int mmCRTC0_CRTC_SNAPSHOT_POSITION__SI__VI           = 0x1BB1;
constexpr unsigned int mmCRTC0_CRTC_SNAPSHOT_STATUS__SI__VI             = 0x1BAF;
constexpr unsigned int mmCRTC0_CRTC_START_LINE_CONTROL__SI__VI          = 0x1BB3;
constexpr unsigned int mmCRTC0_CRTC_STATUS                              = 0x1BA3;
constexpr unsigned int mmCRTC0_CRTC_STATUS_FRAME_COUNT__SI__VI          = 0x1BA6;
constexpr unsigned int mmCRTC0_CRTC_STATUS_HV_COUNT__SI__VI             = 0x1BA8;
constexpr unsigned int mmCRTC0_CRTC_STATUS_POSITION                     = 0x1BA4;
constexpr unsigned int mmCRTC0_CRTC_STATUS_VF_COUNT__SI__VI             = 0x1BA7;
constexpr unsigned int mmCRTC0_CRTC_STEREO_CONTROL__SI__VI              = 0x1BAE;
constexpr unsigned int mmCRTC0_CRTC_STEREO_FORCE_NEXT_EYE__SI           = 0x1B9B;
constexpr unsigned int mmCRTC0_CRTC_STEREO_STATUS__SI__VI               = 0x1BAD;
constexpr unsigned int mmCRTC0_CRTC_TEST_DEBUG_DATA__SI__VI             = 0x1BC7;
constexpr unsigned int mmCRTC0_CRTC_TEST_DEBUG_INDEX__SI__VI            = 0x1BC6;
constexpr unsigned int mmCRTC0_CRTC_TEST_PATTERN_COLOR__SI__VI          = 0x1BBC;
constexpr unsigned int mmCRTC0_CRTC_TEST_PATTERN_CONTROL__SI__VI        = 0x1BBA;
constexpr unsigned int mmCRTC0_CRTC_TEST_PATTERN_PARAMETERS__SI__VI     = 0x1BBB;
constexpr unsigned int mmCRTC0_CRTC_TRIGA_CNTL__SI__VI                  = 0x1B94;
constexpr unsigned int mmCRTC0_CRTC_TRIGA_MANUAL_TRIG__SI__VI           = 0x1B95;
constexpr unsigned int mmCRTC0_CRTC_TRIGB_CNTL__SI__VI                  = 0x1B96;
constexpr unsigned int mmCRTC0_CRTC_TRIGB_MANUAL_TRIG__SI__VI           = 0x1B97;
constexpr unsigned int mmCRTC0_CRTC_UPDATE_LOCK__SI__VI                 = 0x1BB5;
constexpr unsigned int mmCRTC0_CRTC_VBI_END__SI__VI                     = 0x1B86;
constexpr unsigned int mmCRTC0_CRTC_VERT_SYNC_CONTROL__SI__VI           = 0x1BAC;
constexpr unsigned int mmCRTC0_CRTC_VGA_PARAMETER_CAPTURE_MODE__SI__VI  = 0x1BB7;
constexpr unsigned int mmCRTC0_CRTC_VSYNC_NOM_INT_STATUS__SI__VI        = 0x1B8C;
constexpr unsigned int mmCRTC0_CRTC_V_BLANK_START_END__SI__VI           = 0x1B8D;
constexpr unsigned int mmCRTC0_CRTC_V_SYNC_A_CNTL__SI__VI               = 0x1B8F;
constexpr unsigned int mmCRTC0_CRTC_V_SYNC_A__SI__VI                    = 0x1B8E;
constexpr unsigned int mmCRTC0_CRTC_V_SYNC_B_CNTL__SI__VI               = 0x1B91;
constexpr unsigned int mmCRTC0_CRTC_V_SYNC_B__SI__VI                    = 0x1B90;
constexpr unsigned int mmCRTC0_CRTC_V_TOTAL_CONTROL__SI__VI             = 0x1B8A;
constexpr unsigned int mmCRTC0_CRTC_V_TOTAL_INT_STATUS__SI__VI          = 0x1B8B;
constexpr unsigned int mmCRTC0_CRTC_V_TOTAL_MAX__SI__VI                 = 0x1B89;
constexpr unsigned int mmCRTC0_CRTC_V_TOTAL_MIN__SI__VI                 = 0x1B88;
constexpr unsigned int mmCRTC0_CRTC_V_TOTAL__SI__VI                     = 0x1B87;
constexpr unsigned int mmCRTC0_CRTC_V_UPDATE_INT_STATUS__SI__VI         = 0x1BC4;
constexpr unsigned int mmCRTC0_MASTER_UPDATE_LOCK__SI__VI               = 0x1BBD;
constexpr unsigned int mmCRTC0_MASTER_UPDATE_MODE                       = 0x1BBE;
constexpr unsigned int mmCRTC0_PIXEL_RATE_CNTL__SI                      = 0x0120;
constexpr unsigned int mmCRTC1_CRTC_ALLOW_STOP_OFF_V_CNT__SI            = 0x1EC3;
constexpr unsigned int mmCRTC1_CRTC_BLACK_COLOR__SI                     = 0x1EA2;
constexpr unsigned int mmCRTC1_CRTC_BLANK_DATA_COLOR__SI                = 0x1EA1;
constexpr unsigned int mmCRTC1_CRTC_CONTROL__SI                         = 0x1E9C;
constexpr unsigned int mmCRTC1_CRTC_COUNT_CONTROL__SI                   = 0x1EA9;
constexpr unsigned int mmCRTC1_CRTC_COUNT_RESET__SI                     = 0x1EAA;
constexpr unsigned int mmCRTC1_CRTC_DOUBLE_BUFFER_CONTROL__SI           = 0x1EB6;
constexpr unsigned int mmCRTC1_CRTC_DTMTEST_CNTL__SI                    = 0x1E92;
constexpr unsigned int mmCRTC1_CRTC_DTMTEST_STATUS_POSITION__SI         = 0x1E93;
constexpr unsigned int mmCRTC1_CRTC_FLOW_CONTROL__SI                    = 0x1E99;
constexpr unsigned int mmCRTC1_CRTC_FORCE_COUNT_NOW_CNTL__SI            = 0x1E98;
constexpr unsigned int mmCRTC1_CRTC_H_BLANK_START_END__SI               = 0x1E81;
constexpr unsigned int mmCRTC1_CRTC_H_SYNC_A_CNTL__SI                   = 0x1E83;
constexpr unsigned int mmCRTC1_CRTC_H_SYNC_A__SI                        = 0x1E82;
constexpr unsigned int mmCRTC1_CRTC_H_SYNC_B_CNTL__SI                   = 0x1E85;
constexpr unsigned int mmCRTC1_CRTC_H_SYNC_B__SI                        = 0x1E84;
constexpr unsigned int mmCRTC1_CRTC_H_TOTAL__SI                         = 0x1E80;
constexpr unsigned int mmCRTC1_CRTC_INTERLACE_CONTROL__SI               = 0x1E9E;
constexpr unsigned int mmCRTC1_CRTC_INTERLACE_STATUS__SI                = 0x1E9F;
constexpr unsigned int mmCRTC1_CRTC_INTERRUPT_CONTROL__SI               = 0x1EB4;
constexpr unsigned int mmCRTC1_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE__SI    = 0x1EAB;
constexpr unsigned int mmCRTC1_CRTC_MASTER_EN__SI                       = 0x1EC2;
constexpr unsigned int mmCRTC1_CRTC_MVP_INBAND_CNTL_INSERT_TIMER__SI    = 0x1EC0;
constexpr unsigned int mmCRTC1_CRTC_MVP_INBAND_CNTL_INSERT__SI          = 0x1EBF;
constexpr unsigned int mmCRTC1_CRTC_MVP_STATUS__SI                      = 0x1EC1;
constexpr unsigned int mmCRTC1_CRTC_NOM_VERT_POSITION__SI               = 0x1EA5;
constexpr unsigned int mmCRTC1_CRTC_OVERSCAN_COLOR__SI                  = 0x1EA0;
constexpr unsigned int mmCRTC1_CRTC_PIXEL_DATA_READBACK__SI             = 0x1E9A;
constexpr unsigned int mmCRTC1_CRTC_SNAPSHOT_CONTROL__SI                = 0x1EB0;
constexpr unsigned int mmCRTC1_CRTC_SNAPSHOT_FRAME__SI                  = 0x1EB2;
constexpr unsigned int mmCRTC1_CRTC_SNAPSHOT_POSITION__SI               = 0x1EB1;
constexpr unsigned int mmCRTC1_CRTC_SNAPSHOT_STATUS__SI                 = 0x1EAF;
constexpr unsigned int mmCRTC1_CRTC_START_LINE_CONTROL__SI              = 0x1EB3;
constexpr unsigned int mmCRTC1_CRTC_STATUS_FRAME_COUNT__SI              = 0x1EA6;
constexpr unsigned int mmCRTC1_CRTC_STATUS_HV_COUNT__SI                 = 0x1EA8;
constexpr unsigned int mmCRTC1_CRTC_STATUS_VF_COUNT__SI                 = 0x1EA7;
constexpr unsigned int mmCRTC1_CRTC_STEREO_CONTROL__SI                  = 0x1EAE;
constexpr unsigned int mmCRTC1_CRTC_STEREO_FORCE_NEXT_EYE__SI           = 0x1E9B;
constexpr unsigned int mmCRTC1_CRTC_STEREO_STATUS__SI                   = 0x1EAD;
constexpr unsigned int mmCRTC1_CRTC_TEST_DEBUG_DATA__SI                 = 0x1EC7;
constexpr unsigned int mmCRTC1_CRTC_TEST_DEBUG_INDEX__SI                = 0x1EC6;
constexpr unsigned int mmCRTC1_CRTC_TEST_PATTERN_COLOR__SI              = 0x1EBC;
constexpr unsigned int mmCRTC1_CRTC_TEST_PATTERN_CONTROL__SI            = 0x1EBA;
constexpr unsigned int mmCRTC1_CRTC_TEST_PATTERN_PARAMETERS__SI         = 0x1EBB;
constexpr unsigned int mmCRTC1_CRTC_TRIGA_CNTL__SI                      = 0x1E94;
constexpr unsigned int mmCRTC1_CRTC_TRIGA_MANUAL_TRIG__SI               = 0x1E95;
constexpr unsigned int mmCRTC1_CRTC_TRIGB_CNTL__SI                      = 0x1E96;
constexpr unsigned int mmCRTC1_CRTC_TRIGB_MANUAL_TRIG__SI               = 0x1E97;
constexpr unsigned int mmCRTC1_CRTC_UPDATE_LOCK__SI                     = 0x1EB5;
constexpr unsigned int mmCRTC1_CRTC_VBI_END__SI                         = 0x1E86;
constexpr unsigned int mmCRTC1_CRTC_VERT_SYNC_CONTROL__SI               = 0x1EAC;
constexpr unsigned int mmCRTC1_CRTC_VGA_PARAMETER_CAPTURE_MODE__SI      = 0x1EB7;
constexpr unsigned int mmCRTC1_CRTC_VSYNC_NOM_INT_STATUS__SI            = 0x1E8C;
constexpr unsigned int mmCRTC1_CRTC_V_BLANK_START_END__SI               = 0x1E8D;
constexpr unsigned int mmCRTC1_CRTC_V_SYNC_A_CNTL__SI                   = 0x1E8F;
constexpr unsigned int mmCRTC1_CRTC_V_SYNC_A__SI                        = 0x1E8E;
constexpr unsigned int mmCRTC1_CRTC_V_SYNC_B_CNTL__SI                   = 0x1E91;
constexpr unsigned int mmCRTC1_CRTC_V_SYNC_B__SI                        = 0x1E90;
constexpr unsigned int mmCRTC1_CRTC_V_TOTAL_CONTROL__SI                 = 0x1E8A;
constexpr unsigned int mmCRTC1_CRTC_V_TOTAL_INT_STATUS__SI              = 0x1E8B;
constexpr unsigned int mmCRTC1_CRTC_V_TOTAL_MAX__SI                     = 0x1E89;
constexpr unsigned int mmCRTC1_CRTC_V_TOTAL_MIN__SI                     = 0x1E88;
constexpr unsigned int mmCRTC1_CRTC_V_TOTAL__SI                         = 0x1E87;
constexpr unsigned int mmCRTC1_CRTC_V_UPDATE_INT_STATUS__SI             = 0x1EC4;
constexpr unsigned int mmCRTC1_MASTER_UPDATE_LOCK__SI                   = 0x1EBD;
constexpr unsigned int mmCRTC1_PIXEL_RATE_CNTL__SI                      = 0x0121;
constexpr unsigned int mmCRTC2_CRTC_ALLOW_STOP_OFF_V_CNT__SI            = 0x41C3;
constexpr unsigned int mmCRTC2_CRTC_BLACK_COLOR__SI                     = 0x41A2;
constexpr unsigned int mmCRTC2_CRTC_BLANK_DATA_COLOR__SI                = 0x41A1;
constexpr unsigned int mmCRTC2_CRTC_CONTROL__SI                         = 0x419C;
constexpr unsigned int mmCRTC2_CRTC_COUNT_CONTROL__SI                   = 0x41A9;
constexpr unsigned int mmCRTC2_CRTC_COUNT_RESET__SI                     = 0x41AA;
constexpr unsigned int mmCRTC2_CRTC_DOUBLE_BUFFER_CONTROL__SI           = 0x41B6;
constexpr unsigned int mmCRTC2_CRTC_DTMTEST_CNTL__SI                    = 0x4192;
constexpr unsigned int mmCRTC2_CRTC_DTMTEST_STATUS_POSITION__SI         = 0x4193;
constexpr unsigned int mmCRTC2_CRTC_FLOW_CONTROL__SI                    = 0x4199;
constexpr unsigned int mmCRTC2_CRTC_FORCE_COUNT_NOW_CNTL__SI            = 0x4198;
constexpr unsigned int mmCRTC2_CRTC_H_BLANK_START_END__SI               = 0x4181;
constexpr unsigned int mmCRTC2_CRTC_H_SYNC_A_CNTL__SI                   = 0x4183;
constexpr unsigned int mmCRTC2_CRTC_H_SYNC_A__SI                        = 0x4182;
constexpr unsigned int mmCRTC2_CRTC_H_SYNC_B_CNTL__SI                   = 0x4185;
constexpr unsigned int mmCRTC2_CRTC_H_SYNC_B__SI                        = 0x4184;
constexpr unsigned int mmCRTC2_CRTC_H_TOTAL__SI                         = 0x4180;
constexpr unsigned int mmCRTC2_CRTC_INTERLACE_CONTROL__SI               = 0x419E;
constexpr unsigned int mmCRTC2_CRTC_INTERLACE_STATUS__SI                = 0x419F;
constexpr unsigned int mmCRTC2_CRTC_INTERRUPT_CONTROL__SI               = 0x41B4;
constexpr unsigned int mmCRTC2_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE__SI    = 0x41AB;
constexpr unsigned int mmCRTC2_CRTC_MASTER_EN__SI                       = 0x41C2;
constexpr unsigned int mmCRTC2_CRTC_MVP_INBAND_CNTL_INSERT_TIMER__SI    = 0x41C0;
constexpr unsigned int mmCRTC2_CRTC_MVP_INBAND_CNTL_INSERT__SI          = 0x41BF;
constexpr unsigned int mmCRTC2_CRTC_MVP_STATUS__SI                      = 0x41C1;
constexpr unsigned int mmCRTC2_CRTC_NOM_VERT_POSITION__SI               = 0x41A5;
constexpr unsigned int mmCRTC2_CRTC_OVERSCAN_COLOR__SI                  = 0x41A0;
constexpr unsigned int mmCRTC2_CRTC_PIXEL_DATA_READBACK__SI             = 0x419A;
constexpr unsigned int mmCRTC2_CRTC_SNAPSHOT_CONTROL__SI                = 0x41B0;
constexpr unsigned int mmCRTC2_CRTC_SNAPSHOT_FRAME__SI                  = 0x41B2;
constexpr unsigned int mmCRTC2_CRTC_SNAPSHOT_POSITION__SI               = 0x41B1;
constexpr unsigned int mmCRTC2_CRTC_SNAPSHOT_STATUS__SI                 = 0x41AF;
constexpr unsigned int mmCRTC2_CRTC_START_LINE_CONTROL__SI              = 0x41B3;
constexpr unsigned int mmCRTC2_CRTC_STATUS_FRAME_COUNT__SI              = 0x41A6;
constexpr unsigned int mmCRTC2_CRTC_STATUS_HV_COUNT__SI                 = 0x41A8;
constexpr unsigned int mmCRTC2_CRTC_STATUS_VF_COUNT__SI                 = 0x41A7;
constexpr unsigned int mmCRTC2_CRTC_STEREO_CONTROL__SI                  = 0x41AE;
constexpr unsigned int mmCRTC2_CRTC_STEREO_FORCE_NEXT_EYE__SI           = 0x419B;
constexpr unsigned int mmCRTC2_CRTC_STEREO_STATUS__SI                   = 0x41AD;
constexpr unsigned int mmCRTC2_CRTC_TEST_DEBUG_DATA__SI                 = 0x41C7;
constexpr unsigned int mmCRTC2_CRTC_TEST_DEBUG_INDEX__SI                = 0x41C6;
constexpr unsigned int mmCRTC2_CRTC_TEST_PATTERN_COLOR__SI              = 0x41BC;
constexpr unsigned int mmCRTC2_CRTC_TEST_PATTERN_CONTROL__SI            = 0x41BA;
constexpr unsigned int mmCRTC2_CRTC_TEST_PATTERN_PARAMETERS__SI         = 0x41BB;
constexpr unsigned int mmCRTC2_CRTC_TRIGA_CNTL__SI                      = 0x4194;
constexpr unsigned int mmCRTC2_CRTC_TRIGA_MANUAL_TRIG__SI               = 0x4195;
constexpr unsigned int mmCRTC2_CRTC_TRIGB_CNTL__SI                      = 0x4196;
constexpr unsigned int mmCRTC2_CRTC_TRIGB_MANUAL_TRIG__SI               = 0x4197;
constexpr unsigned int mmCRTC2_CRTC_UPDATE_LOCK__SI                     = 0x41B5;
constexpr unsigned int mmCRTC2_CRTC_VBI_END__SI                         = 0x4186;
constexpr unsigned int mmCRTC2_CRTC_VERT_SYNC_CONTROL__SI               = 0x41AC;
constexpr unsigned int mmCRTC2_CRTC_VGA_PARAMETER_CAPTURE_MODE__SI      = 0x41B7;
constexpr unsigned int mmCRTC2_CRTC_VSYNC_NOM_INT_STATUS__SI            = 0x418C;
constexpr unsigned int mmCRTC2_CRTC_V_BLANK_START_END__SI               = 0x418D;
constexpr unsigned int mmCRTC2_CRTC_V_SYNC_A_CNTL__SI                   = 0x418F;
constexpr unsigned int mmCRTC2_CRTC_V_SYNC_A__SI                        = 0x418E;
constexpr unsigned int mmCRTC2_CRTC_V_SYNC_B_CNTL__SI                   = 0x4191;
constexpr unsigned int mmCRTC2_CRTC_V_SYNC_B__SI                        = 0x4190;
constexpr unsigned int mmCRTC2_CRTC_V_TOTAL_CONTROL__SI                 = 0x418A;
constexpr unsigned int mmCRTC2_CRTC_V_TOTAL_INT_STATUS__SI              = 0x418B;
constexpr unsigned int mmCRTC2_CRTC_V_TOTAL_MAX__SI                     = 0x4189;
constexpr unsigned int mmCRTC2_CRTC_V_TOTAL_MIN__SI                     = 0x4188;
constexpr unsigned int mmCRTC2_CRTC_V_TOTAL__SI                         = 0x4187;
constexpr unsigned int mmCRTC2_CRTC_V_UPDATE_INT_STATUS__SI             = 0x41C4;
constexpr unsigned int mmCRTC2_MASTER_UPDATE_LOCK__SI                   = 0x41BD;
constexpr unsigned int mmCRTC2_PIXEL_RATE_CNTL__SI                      = 0x0122;
constexpr unsigned int mmCRTC3_CRTC_ALLOW_STOP_OFF_V_CNT__SI            = 0x44C3;
constexpr unsigned int mmCRTC3_CRTC_BLACK_COLOR__SI                     = 0x44A2;
constexpr unsigned int mmCRTC3_CRTC_BLANK_DATA_COLOR__SI                = 0x44A1;
constexpr unsigned int mmCRTC3_CRTC_CONTROL__SI                         = 0x449C;
constexpr unsigned int mmCRTC3_CRTC_COUNT_CONTROL__SI                   = 0x44A9;
constexpr unsigned int mmCRTC3_CRTC_COUNT_RESET__SI                     = 0x44AA;
constexpr unsigned int mmCRTC3_CRTC_DOUBLE_BUFFER_CONTROL__SI           = 0x44B6;
constexpr unsigned int mmCRTC3_CRTC_DTMTEST_CNTL__SI                    = 0x4492;
constexpr unsigned int mmCRTC3_CRTC_DTMTEST_STATUS_POSITION__SI         = 0x4493;
constexpr unsigned int mmCRTC3_CRTC_FLOW_CONTROL__SI                    = 0x4499;
constexpr unsigned int mmCRTC3_CRTC_FORCE_COUNT_NOW_CNTL__SI            = 0x4498;
constexpr unsigned int mmCRTC3_CRTC_H_BLANK_START_END__SI               = 0x4481;
constexpr unsigned int mmCRTC3_CRTC_H_SYNC_A_CNTL__SI                   = 0x4483;
constexpr unsigned int mmCRTC3_CRTC_H_SYNC_A__SI                        = 0x4482;
constexpr unsigned int mmCRTC3_CRTC_H_SYNC_B_CNTL__SI                   = 0x4485;
constexpr unsigned int mmCRTC3_CRTC_H_SYNC_B__SI                        = 0x4484;
constexpr unsigned int mmCRTC3_CRTC_H_TOTAL__SI                         = 0x4480;
constexpr unsigned int mmCRTC3_CRTC_INTERLACE_CONTROL__SI               = 0x449E;
constexpr unsigned int mmCRTC3_CRTC_INTERLACE_STATUS__SI                = 0x449F;
constexpr unsigned int mmCRTC3_CRTC_INTERRUPT_CONTROL__SI               = 0x44B4;
constexpr unsigned int mmCRTC3_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE__SI    = 0x44AB;
constexpr unsigned int mmCRTC3_CRTC_MASTER_EN__SI                       = 0x44C2;
constexpr unsigned int mmCRTC3_CRTC_MVP_INBAND_CNTL_INSERT_TIMER__SI    = 0x44C0;
constexpr unsigned int mmCRTC3_CRTC_MVP_INBAND_CNTL_INSERT__SI          = 0x44BF;
constexpr unsigned int mmCRTC3_CRTC_MVP_STATUS__SI                      = 0x44C1;
constexpr unsigned int mmCRTC3_CRTC_NOM_VERT_POSITION__SI               = 0x44A5;
constexpr unsigned int mmCRTC3_CRTC_OVERSCAN_COLOR__SI                  = 0x44A0;
constexpr unsigned int mmCRTC3_CRTC_PIXEL_DATA_READBACK__SI             = 0x449A;
constexpr unsigned int mmCRTC3_CRTC_SNAPSHOT_CONTROL__SI                = 0x44B0;
constexpr unsigned int mmCRTC3_CRTC_SNAPSHOT_FRAME__SI                  = 0x44B2;
constexpr unsigned int mmCRTC3_CRTC_SNAPSHOT_POSITION__SI               = 0x44B1;
constexpr unsigned int mmCRTC3_CRTC_SNAPSHOT_STATUS__SI                 = 0x44AF;
constexpr unsigned int mmCRTC3_CRTC_START_LINE_CONTROL__SI              = 0x44B3;
constexpr unsigned int mmCRTC3_CRTC_STATUS_FRAME_COUNT__SI              = 0x44A6;
constexpr unsigned int mmCRTC3_CRTC_STATUS_HV_COUNT__SI                 = 0x44A8;
constexpr unsigned int mmCRTC3_CRTC_STATUS_VF_COUNT__SI                 = 0x44A7;
constexpr unsigned int mmCRTC3_CRTC_STEREO_CONTROL__SI                  = 0x44AE;
constexpr unsigned int mmCRTC3_CRTC_STEREO_FORCE_NEXT_EYE__SI           = 0x449B;
constexpr unsigned int mmCRTC3_CRTC_STEREO_STATUS__SI                   = 0x44AD;
constexpr unsigned int mmCRTC3_CRTC_TEST_DEBUG_DATA__SI                 = 0x44C7;
constexpr unsigned int mmCRTC3_CRTC_TEST_DEBUG_INDEX__SI                = 0x44C6;
constexpr unsigned int mmCRTC3_CRTC_TEST_PATTERN_COLOR__SI              = 0x44BC;
constexpr unsigned int mmCRTC3_CRTC_TEST_PATTERN_CONTROL__SI            = 0x44BA;
constexpr unsigned int mmCRTC3_CRTC_TEST_PATTERN_PARAMETERS__SI         = 0x44BB;
constexpr unsigned int mmCRTC3_CRTC_TRIGA_CNTL__SI                      = 0x4494;
constexpr unsigned int mmCRTC3_CRTC_TRIGA_MANUAL_TRIG__SI               = 0x4495;
constexpr unsigned int mmCRTC3_CRTC_TRIGB_CNTL__SI                      = 0x4496;
constexpr unsigned int mmCRTC3_CRTC_TRIGB_MANUAL_TRIG__SI               = 0x4497;
constexpr unsigned int mmCRTC3_CRTC_UPDATE_LOCK__SI                     = 0x44B5;
constexpr unsigned int mmCRTC3_CRTC_VBI_END__SI                         = 0x4486;
constexpr unsigned int mmCRTC3_CRTC_VERT_SYNC_CONTROL__SI               = 0x44AC;
constexpr unsigned int mmCRTC3_CRTC_VGA_PARAMETER_CAPTURE_MODE__SI      = 0x44B7;
constexpr unsigned int mmCRTC3_CRTC_VSYNC_NOM_INT_STATUS__SI            = 0x448C;
constexpr unsigned int mmCRTC3_CRTC_V_BLANK_START_END__SI               = 0x448D;
constexpr unsigned int mmCRTC3_CRTC_V_SYNC_A_CNTL__SI                   = 0x448F;
constexpr unsigned int mmCRTC3_CRTC_V_SYNC_A__SI                        = 0x448E;
constexpr unsigned int mmCRTC3_CRTC_V_SYNC_B_CNTL__SI                   = 0x4491;
constexpr unsigned int mmCRTC3_CRTC_V_SYNC_B__SI                        = 0x4490;
constexpr unsigned int mmCRTC3_CRTC_V_TOTAL_CONTROL__SI                 = 0x448A;
constexpr unsigned int mmCRTC3_CRTC_V_TOTAL_INT_STATUS__SI              = 0x448B;
constexpr unsigned int mmCRTC3_CRTC_V_TOTAL_MAX__SI                     = 0x4489;
constexpr unsigned int mmCRTC3_CRTC_V_TOTAL_MIN__SI                     = 0x4488;
constexpr unsigned int mmCRTC3_CRTC_V_TOTAL__SI                         = 0x4487;
constexpr unsigned int mmCRTC3_CRTC_V_UPDATE_INT_STATUS__SI             = 0x44C4;
constexpr unsigned int mmCRTC3_MASTER_UPDATE_LOCK__SI                   = 0x44BD;
constexpr unsigned int mmCRTC3_PIXEL_RATE_CNTL__SI                      = 0x0123;
constexpr unsigned int mmCRTC4_CRTC_ALLOW_STOP_OFF_V_CNT__SI            = 0x47C3;
constexpr unsigned int mmCRTC4_CRTC_BLACK_COLOR__SI                     = 0x47A2;
constexpr unsigned int mmCRTC4_CRTC_BLANK_DATA_COLOR__SI                = 0x47A1;
constexpr unsigned int mmCRTC4_CRTC_CONTROL__SI                         = 0x479C;
constexpr unsigned int mmCRTC4_CRTC_COUNT_CONTROL__SI                   = 0x47A9;
constexpr unsigned int mmCRTC4_CRTC_COUNT_RESET__SI                     = 0x47AA;
constexpr unsigned int mmCRTC4_CRTC_DOUBLE_BUFFER_CONTROL__SI           = 0x47B6;
constexpr unsigned int mmCRTC4_CRTC_DTMTEST_CNTL__SI                    = 0x4792;
constexpr unsigned int mmCRTC4_CRTC_DTMTEST_STATUS_POSITION__SI         = 0x4793;
constexpr unsigned int mmCRTC4_CRTC_FLOW_CONTROL__SI                    = 0x4799;
constexpr unsigned int mmCRTC4_CRTC_FORCE_COUNT_NOW_CNTL__SI            = 0x4798;
constexpr unsigned int mmCRTC4_CRTC_H_BLANK_START_END__SI               = 0x4781;
constexpr unsigned int mmCRTC4_CRTC_H_SYNC_A_CNTL__SI                   = 0x4783;
constexpr unsigned int mmCRTC4_CRTC_H_SYNC_A__SI                        = 0x4782;
constexpr unsigned int mmCRTC4_CRTC_H_SYNC_B_CNTL__SI                   = 0x4785;
constexpr unsigned int mmCRTC4_CRTC_H_SYNC_B__SI                        = 0x4784;
constexpr unsigned int mmCRTC4_CRTC_H_TOTAL__SI                         = 0x4780;
constexpr unsigned int mmCRTC4_CRTC_INTERLACE_CONTROL__SI               = 0x479E;
constexpr unsigned int mmCRTC4_CRTC_INTERLACE_STATUS__SI                = 0x479F;
constexpr unsigned int mmCRTC4_CRTC_INTERRUPT_CONTROL__SI               = 0x47B4;
constexpr unsigned int mmCRTC4_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE__SI    = 0x47AB;
constexpr unsigned int mmCRTC4_CRTC_MASTER_EN__SI                       = 0x47C2;
constexpr unsigned int mmCRTC4_CRTC_MVP_INBAND_CNTL_INSERT_TIMER__SI    = 0x47C0;
constexpr unsigned int mmCRTC4_CRTC_MVP_INBAND_CNTL_INSERT__SI          = 0x47BF;
constexpr unsigned int mmCRTC4_CRTC_MVP_STATUS__SI                      = 0x47C1;
constexpr unsigned int mmCRTC4_CRTC_NOM_VERT_POSITION__SI               = 0x47A5;
constexpr unsigned int mmCRTC4_CRTC_OVERSCAN_COLOR__SI                  = 0x47A0;
constexpr unsigned int mmCRTC4_CRTC_PIXEL_DATA_READBACK__SI             = 0x479A;
constexpr unsigned int mmCRTC4_CRTC_SNAPSHOT_CONTROL__SI                = 0x47B0;
constexpr unsigned int mmCRTC4_CRTC_SNAPSHOT_FRAME__SI                  = 0x47B2;
constexpr unsigned int mmCRTC4_CRTC_SNAPSHOT_POSITION__SI               = 0x47B1;
constexpr unsigned int mmCRTC4_CRTC_SNAPSHOT_STATUS__SI                 = 0x47AF;
constexpr unsigned int mmCRTC4_CRTC_START_LINE_CONTROL__SI              = 0x47B3;
constexpr unsigned int mmCRTC4_CRTC_STATUS_FRAME_COUNT__SI              = 0x47A6;
constexpr unsigned int mmCRTC4_CRTC_STATUS_HV_COUNT__SI                 = 0x47A8;
constexpr unsigned int mmCRTC4_CRTC_STATUS_VF_COUNT__SI                 = 0x47A7;
constexpr unsigned int mmCRTC4_CRTC_STEREO_CONTROL__SI                  = 0x47AE;
constexpr unsigned int mmCRTC4_CRTC_STEREO_FORCE_NEXT_EYE__SI           = 0x479B;
constexpr unsigned int mmCRTC4_CRTC_STEREO_STATUS__SI                   = 0x47AD;
constexpr unsigned int mmCRTC4_CRTC_TEST_DEBUG_DATA__SI                 = 0x47C7;
constexpr unsigned int mmCRTC4_CRTC_TEST_DEBUG_INDEX__SI                = 0x47C6;
constexpr unsigned int mmCRTC4_CRTC_TEST_PATTERN_COLOR__SI              = 0x47BC;
constexpr unsigned int mmCRTC4_CRTC_TEST_PATTERN_CONTROL__SI            = 0x47BA;
constexpr unsigned int mmCRTC4_CRTC_TEST_PATTERN_PARAMETERS__SI         = 0x47BB;
constexpr unsigned int mmCRTC4_CRTC_TRIGA_CNTL__SI                      = 0x4794;
constexpr unsigned int mmCRTC4_CRTC_TRIGA_MANUAL_TRIG__SI               = 0x4795;
constexpr unsigned int mmCRTC4_CRTC_TRIGB_CNTL__SI                      = 0x4796;
constexpr unsigned int mmCRTC4_CRTC_TRIGB_MANUAL_TRIG__SI               = 0x4797;
constexpr unsigned int mmCRTC4_CRTC_UPDATE_LOCK__SI                     = 0x47B5;
constexpr unsigned int mmCRTC4_CRTC_VBI_END__SI                         = 0x4786;
constexpr unsigned int mmCRTC4_CRTC_VERT_SYNC_CONTROL__SI               = 0x47AC;
constexpr unsigned int mmCRTC4_CRTC_VGA_PARAMETER_CAPTURE_MODE__SI      = 0x47B7;
constexpr unsigned int mmCRTC4_CRTC_VSYNC_NOM_INT_STATUS__SI            = 0x478C;
constexpr unsigned int mmCRTC4_CRTC_V_BLANK_START_END__SI               = 0x478D;
constexpr unsigned int mmCRTC4_CRTC_V_SYNC_A_CNTL__SI                   = 0x478F;
constexpr unsigned int mmCRTC4_CRTC_V_SYNC_A__SI                        = 0x478E;
constexpr unsigned int mmCRTC4_CRTC_V_SYNC_B_CNTL__SI                   = 0x4791;
constexpr unsigned int mmCRTC4_CRTC_V_SYNC_B__SI                        = 0x4790;
constexpr unsigned int mmCRTC4_CRTC_V_TOTAL_CONTROL__SI                 = 0x478A;
constexpr unsigned int mmCRTC4_CRTC_V_TOTAL_INT_STATUS__SI              = 0x478B;
constexpr unsigned int mmCRTC4_CRTC_V_TOTAL_MAX__SI                     = 0x4789;
constexpr unsigned int mmCRTC4_CRTC_V_TOTAL_MIN__SI                     = 0x4788;
constexpr unsigned int mmCRTC4_CRTC_V_TOTAL__SI                         = 0x4787;
constexpr unsigned int mmCRTC4_CRTC_V_UPDATE_INT_STATUS__SI             = 0x47C4;
constexpr unsigned int mmCRTC4_MASTER_UPDATE_LOCK__SI                   = 0x47BD;
constexpr unsigned int mmCRTC4_PIXEL_RATE_CNTL__SI                      = 0x0124;
constexpr unsigned int mmCRTC5_CRTC_ALLOW_STOP_OFF_V_CNT__SI            = 0x4AC3;
constexpr unsigned int mmCRTC5_CRTC_BLACK_COLOR__SI                     = 0x4AA2;
constexpr unsigned int mmCRTC5_CRTC_BLANK_DATA_COLOR__SI                = 0x4AA1;
constexpr unsigned int mmCRTC5_CRTC_CONTROL__SI                         = 0x4A9C;
constexpr unsigned int mmCRTC5_CRTC_COUNT_CONTROL__SI                   = 0x4AA9;
constexpr unsigned int mmCRTC5_CRTC_COUNT_RESET__SI                     = 0x4AAA;
constexpr unsigned int mmCRTC5_CRTC_DOUBLE_BUFFER_CONTROL__SI           = 0x4AB6;
constexpr unsigned int mmCRTC5_CRTC_DTMTEST_CNTL__SI                    = 0x4A92;
constexpr unsigned int mmCRTC5_CRTC_DTMTEST_STATUS_POSITION__SI         = 0x4A93;
constexpr unsigned int mmCRTC5_CRTC_FLOW_CONTROL__SI                    = 0x4A99;
constexpr unsigned int mmCRTC5_CRTC_FORCE_COUNT_NOW_CNTL__SI            = 0x4A98;
constexpr unsigned int mmCRTC5_CRTC_H_BLANK_START_END__SI               = 0x4A81;
constexpr unsigned int mmCRTC5_CRTC_H_SYNC_A_CNTL__SI                   = 0x4A83;
constexpr unsigned int mmCRTC5_CRTC_H_SYNC_A__SI                        = 0x4A82;
constexpr unsigned int mmCRTC5_CRTC_H_SYNC_B_CNTL__SI                   = 0x4A85;
constexpr unsigned int mmCRTC5_CRTC_H_SYNC_B__SI                        = 0x4A84;
constexpr unsigned int mmCRTC5_CRTC_H_TOTAL__SI                         = 0x4A80;
constexpr unsigned int mmCRTC5_CRTC_INTERLACE_CONTROL__SI               = 0x4A9E;
constexpr unsigned int mmCRTC5_CRTC_INTERLACE_STATUS__SI                = 0x4A9F;
constexpr unsigned int mmCRTC5_CRTC_INTERRUPT_CONTROL__SI               = 0x4AB4;
constexpr unsigned int mmCRTC5_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE__SI    = 0x4AAB;
constexpr unsigned int mmCRTC5_CRTC_MASTER_EN__SI                       = 0x4AC2;
constexpr unsigned int mmCRTC5_CRTC_MVP_INBAND_CNTL_INSERT_TIMER__SI    = 0x4AC0;
constexpr unsigned int mmCRTC5_CRTC_MVP_INBAND_CNTL_INSERT__SI          = 0x4ABF;
constexpr unsigned int mmCRTC5_CRTC_MVP_STATUS__SI                      = 0x4AC1;
constexpr unsigned int mmCRTC5_CRTC_NOM_VERT_POSITION__SI               = 0x4AA5;
constexpr unsigned int mmCRTC5_CRTC_OVERSCAN_COLOR__SI                  = 0x4AA0;
constexpr unsigned int mmCRTC5_CRTC_PIXEL_DATA_READBACK__SI             = 0x4A9A;
constexpr unsigned int mmCRTC5_CRTC_SNAPSHOT_CONTROL__SI                = 0x4AB0;
constexpr unsigned int mmCRTC5_CRTC_SNAPSHOT_FRAME__SI                  = 0x4AB2;
constexpr unsigned int mmCRTC5_CRTC_SNAPSHOT_POSITION__SI               = 0x4AB1;
constexpr unsigned int mmCRTC5_CRTC_SNAPSHOT_STATUS__SI                 = 0x4AAF;
constexpr unsigned int mmCRTC5_CRTC_START_LINE_CONTROL__SI              = 0x4AB3;
constexpr unsigned int mmCRTC5_CRTC_STATUS_FRAME_COUNT__SI              = 0x4AA6;
constexpr unsigned int mmCRTC5_CRTC_STATUS_HV_COUNT__SI                 = 0x4AA8;
constexpr unsigned int mmCRTC5_CRTC_STATUS_VF_COUNT__SI                 = 0x4AA7;
constexpr unsigned int mmCRTC5_CRTC_STEREO_CONTROL__SI                  = 0x4AAE;
constexpr unsigned int mmCRTC5_CRTC_STEREO_FORCE_NEXT_EYE__SI           = 0x4A9B;
constexpr unsigned int mmCRTC5_CRTC_STEREO_STATUS__SI                   = 0x4AAD;
constexpr unsigned int mmCRTC5_CRTC_TEST_DEBUG_DATA__SI                 = 0x4AC7;
constexpr unsigned int mmCRTC5_CRTC_TEST_DEBUG_INDEX__SI                = 0x4AC6;
constexpr unsigned int mmCRTC5_CRTC_TEST_PATTERN_COLOR__SI              = 0x4ABC;
constexpr unsigned int mmCRTC5_CRTC_TEST_PATTERN_CONTROL__SI            = 0x4ABA;
constexpr unsigned int mmCRTC5_CRTC_TEST_PATTERN_PARAMETERS__SI         = 0x4ABB;
constexpr unsigned int mmCRTC5_CRTC_TRIGA_CNTL__SI                      = 0x4A94;
constexpr unsigned int mmCRTC5_CRTC_TRIGA_MANUAL_TRIG__SI               = 0x4A95;
constexpr unsigned int mmCRTC5_CRTC_TRIGB_CNTL__SI                      = 0x4A96;
constexpr unsigned int mmCRTC5_CRTC_TRIGB_MANUAL_TRIG__SI               = 0x4A97;
constexpr unsigned int mmCRTC5_CRTC_UPDATE_LOCK__SI                     = 0x4AB5;
constexpr unsigned int mmCRTC5_CRTC_VBI_END__SI                         = 0x4A86;
constexpr unsigned int mmCRTC5_CRTC_VERT_SYNC_CONTROL__SI               = 0x4AAC;
constexpr unsigned int mmCRTC5_CRTC_VGA_PARAMETER_CAPTURE_MODE__SI      = 0x4AB7;
constexpr unsigned int mmCRTC5_CRTC_VSYNC_NOM_INT_STATUS__SI            = 0x4A8C;
constexpr unsigned int mmCRTC5_CRTC_V_BLANK_START_END__SI               = 0x4A8D;
constexpr unsigned int mmCRTC5_CRTC_V_SYNC_A_CNTL__SI                   = 0x4A8F;
constexpr unsigned int mmCRTC5_CRTC_V_SYNC_A__SI                        = 0x4A8E;
constexpr unsigned int mmCRTC5_CRTC_V_SYNC_B_CNTL__SI                   = 0x4A91;
constexpr unsigned int mmCRTC5_CRTC_V_SYNC_B__SI                        = 0x4A90;
constexpr unsigned int mmCRTC5_CRTC_V_TOTAL_CONTROL__SI                 = 0x4A8A;
constexpr unsigned int mmCRTC5_CRTC_V_TOTAL_INT_STATUS__SI              = 0x4A8B;
constexpr unsigned int mmCRTC5_CRTC_V_TOTAL_MAX__SI                     = 0x4A89;
constexpr unsigned int mmCRTC5_CRTC_V_TOTAL_MIN__SI                     = 0x4A88;
constexpr unsigned int mmCRTC5_CRTC_V_TOTAL__SI                         = 0x4A87;
constexpr unsigned int mmCRTC5_CRTC_V_UPDATE_INT_STATUS__SI             = 0x4AC4;
constexpr unsigned int mmCRTC5_MASTER_UPDATE_LOCK__SI                   = 0x4ABD;
constexpr unsigned int mmCRTC5_PIXEL_RATE_CNTL__SI                      = 0x0125;
constexpr unsigned int mmCRTC8_DATA__SI__VI                             = 0x00ED;
constexpr unsigned int mmCRTC8_IDX__SI__VI                              = 0x00ED;
constexpr unsigned int mmCRTC_ALLOW_STOP_OFF_V_CNT__SI__VI              = 0x1BC3;
constexpr unsigned int mmCRTC_BLACK_COLOR__SI                           = 0x1BA2;
constexpr unsigned int mmCRTC_BLANK_CONTROL                             = 0x1B9D;
constexpr unsigned int mmCRTC_BLANK_DATA_COLOR__SI                      = 0x1BA1;
constexpr unsigned int mmCRTC_CONTROL__SI__VI                           = 0x1B9C;
constexpr unsigned int mmCRTC_COUNT_CONTROL__SI__VI                     = 0x1BA9;
constexpr unsigned int mmCRTC_COUNT_RESET__SI__VI                       = 0x1BAA;
constexpr unsigned int mmCRTC_DOUBLE_BUFFER_CONTROL__SI__VI             = 0x1BB6;
constexpr unsigned int mmCRTC_DTMTEST_CNTL__SI__VI                      = 0x1B92;
constexpr unsigned int mmCRTC_DTMTEST_STATUS_POSITION__SI__VI           = 0x1B93;
constexpr unsigned int mmCRTC_FLOW_CONTROL__SI__VI                      = 0x1B99;
constexpr unsigned int mmCRTC_FORCE_COUNT_NOW_CNTL__SI__VI              = 0x1B98;
constexpr unsigned int mmCRTC_H_BLANK_START_END__SI__VI                 = 0x1B81;
constexpr unsigned int mmCRTC_H_SYNC_A_CNTL__SI__VI                     = 0x1B83;
constexpr unsigned int mmCRTC_H_SYNC_A__SI__VI                          = 0x1B82;
constexpr unsigned int mmCRTC_H_SYNC_B_CNTL__SI__VI                     = 0x1B85;
constexpr unsigned int mmCRTC_H_SYNC_B__SI__VI                          = 0x1B84;
constexpr unsigned int mmCRTC_H_TOTAL__SI__VI                           = 0x1B80;
constexpr unsigned int mmCRTC_INTERLACE_CONTROL__SI__VI                 = 0x1B9E;
constexpr unsigned int mmCRTC_INTERLACE_STATUS__SI__VI                  = 0x1B9F;
constexpr unsigned int mmCRTC_INTERRUPT_CONTROL__SI__VI                 = 0x1BB4;
constexpr unsigned int mmCRTC_MANUAL_FORCE_VSYNC_NEXT_LINE__SI__VI      = 0x1BAB;
constexpr unsigned int mmCRTC_MASTER_EN__SI__VI                         = 0x1BC2;
constexpr unsigned int mmCRTC_MVP_INBAND_CNTL_INSERT_TIMER__SI__VI      = 0x1BC0;
constexpr unsigned int mmCRTC_MVP_INBAND_CNTL_INSERT__SI__VI            = 0x1BBF;
constexpr unsigned int mmCRTC_MVP_STATUS__SI__VI                        = 0x1BC1;
constexpr unsigned int mmCRTC_NOM_VERT_POSITION__SI__VI                 = 0x1BA5;
constexpr unsigned int mmCRTC_OVERSCAN_COLOR__SI                        = 0x1BA0;
constexpr unsigned int mmCRTC_PIXEL_DATA_READBACK__SI                   = 0x1B9A;
constexpr unsigned int mmCRTC_SNAPSHOT_CONTROL__SI__VI                  = 0x1BB0;
constexpr unsigned int mmCRTC_SNAPSHOT_FRAME__SI__VI                    = 0x1BB2;
constexpr unsigned int mmCRTC_SNAPSHOT_POSITION__SI__VI                 = 0x1BB1;
constexpr unsigned int mmCRTC_SNAPSHOT_STATUS__SI__VI                   = 0x1BAF;
constexpr unsigned int mmCRTC_START_LINE_CONTROL__SI__VI                = 0x1BB3;
constexpr unsigned int mmCRTC_STATUS                                    = 0x1BA3;
constexpr unsigned int mmCRTC_STATUS_FRAME_COUNT__SI__VI                = 0x1BA6;
constexpr unsigned int mmCRTC_STATUS_HV_COUNT__SI__VI                   = 0x1BA8;
constexpr unsigned int mmCRTC_STATUS_POSITION__SI__VI                   = 0x1BA4;
constexpr unsigned int mmCRTC_STATUS_VF_COUNT__SI__VI                   = 0x1BA7;
constexpr unsigned int mmCRTC_STEREO_CONTROL__SI__VI                    = 0x1BAE;
constexpr unsigned int mmCRTC_STEREO_FORCE_NEXT_EYE__SI                 = 0x1B9B;
constexpr unsigned int mmCRTC_STEREO_STATUS__SI__VI                     = 0x1BAD;
constexpr unsigned int mmCRTC_TEST_DEBUG_DATA__SI__VI                   = 0x1BC7;
constexpr unsigned int mmCRTC_TEST_DEBUG_INDEX__SI__VI                  = 0x1BC6;
constexpr unsigned int mmCRTC_TEST_PATTERN_COLOR__SI__VI                = 0x1BBC;
constexpr unsigned int mmCRTC_TEST_PATTERN_CONTROL__SI__VI              = 0x1BBA;
constexpr unsigned int mmCRTC_TEST_PATTERN_PARAMETERS__SI__VI           = 0x1BBB;
constexpr unsigned int mmCRTC_TRIGA_CNTL__SI__VI                        = 0x1B94;
constexpr unsigned int mmCRTC_TRIGA_MANUAL_TRIG__SI__VI                 = 0x1B95;
constexpr unsigned int mmCRTC_TRIGB_CNTL__SI__VI                        = 0x1B96;
constexpr unsigned int mmCRTC_TRIGB_MANUAL_TRIG__SI__VI                 = 0x1B97;
constexpr unsigned int mmCRTC_UPDATE_LOCK__SI__VI                       = 0x1BB5;
constexpr unsigned int mmCRTC_VBI_END__SI__VI                           = 0x1B86;
constexpr unsigned int mmCRTC_VERT_SYNC_CONTROL__SI__VI                 = 0x1BAC;
constexpr unsigned int mmCRTC_VGA_PARAMETER_CAPTURE_MODE__SI__VI        = 0x1BB7;
constexpr unsigned int mmCRTC_VSYNC_NOM_INT_STATUS__SI__VI              = 0x1B8C;
constexpr unsigned int mmCRTC_V_BLANK_START_END__SI__VI                 = 0x1B8D;
constexpr unsigned int mmCRTC_V_SYNC_A_CNTL__SI__VI                     = 0x1B8F;
constexpr unsigned int mmCRTC_V_SYNC_A__SI__VI                          = 0x1B8E;
constexpr unsigned int mmCRTC_V_SYNC_B_CNTL__SI__VI                     = 0x1B91;
constexpr unsigned int mmCRTC_V_SYNC_B__SI__VI                          = 0x1B90;
constexpr unsigned int mmCRTC_V_TOTAL_CONTROL__SI__VI                   = 0x1B8A;
constexpr unsigned int mmCRTC_V_TOTAL_INT_STATUS__SI__VI                = 0x1B8B;
constexpr unsigned int mmCRTC_V_TOTAL_MAX__SI__VI                       = 0x1B89;
constexpr unsigned int mmCRTC_V_TOTAL_MIN__SI__VI                       = 0x1B88;
constexpr unsigned int mmCRTC_V_TOTAL__SI__VI                           = 0x1B87;
constexpr unsigned int mmCRTC_V_UPDATE_INT_STATUS__SI__VI               = 0x1BC4;
constexpr unsigned int mmCS_COPY_STATE                                  = 0xA1F3;
constexpr unsigned int mmCUR_COLOR1__SI__VI                             = 0x1A6C;
constexpr unsigned int mmCUR_COLOR2__SI__VI                             = 0x1A6D;
constexpr unsigned int mmCUR_CONTROL__SI__VI                            = 0x1A66;
constexpr unsigned int mmCUR_HOT_SPOT__SI__VI                           = 0x1A6B;
constexpr unsigned int mmCUR_POSITION__SI__VI                           = 0x1A6A;
constexpr unsigned int mmCUR_SIZE__SI__VI                               = 0x1A68;
constexpr unsigned int mmCUR_SURFACE_ADDRESS_HIGH__SI__VI               = 0x1A69;
constexpr unsigned int mmCUR_SURFACE_ADDRESS__SI__VI                    = 0x1A67;
constexpr unsigned int mmCUR_UPDATE__SI__VI                             = 0x1A6E;
constexpr unsigned int mmD1VGA_CONTROL__SI__VI                          = 0x00CC;
constexpr unsigned int mmD2VGA_CONTROL__SI__VI                          = 0x00CE;
constexpr unsigned int mmD3VGA_CONTROL__SI__VI                          = 0x00F8;
constexpr unsigned int mmD4VGA_CONTROL__SI__VI                          = 0x00F9;
constexpr unsigned int mmD5VGA_CONTROL__SI__VI                          = 0x00FA;
constexpr unsigned int mmD6VGA_CONTROL__SI__VI                          = 0x00FB;
constexpr unsigned int mmDAC_AUTODETECT_CONTROL2__SI                    = 0x19AF;
constexpr unsigned int mmDAC_AUTODETECT_CONTROL3__SI                    = 0x19B0;
constexpr unsigned int mmDAC_AUTODETECT_CONTROL__SI                     = 0x19AE;
constexpr unsigned int mmDAC_AUTODETECT_INT_CONTROL__SI                 = 0x19B2;
constexpr unsigned int mmDAC_AUTODETECT_STATUS__SI                      = 0x19B1;
constexpr unsigned int mmDAC_COMPARATOR_ENABLE__SI                      = 0x19B7;
constexpr unsigned int mmDAC_COMPARATOR_OUTPUT__SI                      = 0x19B8;
constexpr unsigned int mmDAC_CONTROL__SI                                = 0x19B6;
constexpr unsigned int mmDAC_CRC_CONTROL__SI                            = 0x19A7;
constexpr unsigned int mmDAC_CRC_EN__SI                                 = 0x19A6;
constexpr unsigned int mmDAC_CRC_SIG_CONTROL_MASK__SI                   = 0x19A9;
constexpr unsigned int mmDAC_CRC_SIG_CONTROL__SI                        = 0x19AB;
constexpr unsigned int mmDAC_CRC_SIG_RGB_MASK__SI                       = 0x19A8;
constexpr unsigned int mmDAC_CRC_SIG_RGB__SI                            = 0x19AA;
constexpr unsigned int mmDAC_DATA__SI__VI                               = 0x00F2;
constexpr unsigned int mmDAC_DFT_CONFIG__SI                             = 0x19BA;
constexpr unsigned int mmDAC_ENABLE__SI                                 = 0x19A4;
constexpr unsigned int mmDAC_FORCE_DATA__SI                             = 0x19B4;
constexpr unsigned int mmDAC_FORCE_OUTPUT_CNTL__SI                      = 0x19B3;
constexpr unsigned int mmDAC_MACRO_CNTL__SI                             = 0x1939;
constexpr unsigned int mmDAC_MASK__SI__VI                               = 0x00F1;
constexpr unsigned int mmDAC_POWERDOWN__SI                              = 0x19B5;
constexpr unsigned int mmDAC_PWR_CNTL__SI                               = 0x19B9;
constexpr unsigned int mmDAC_R_INDEX__SI__VI                            = 0x00F1;
constexpr unsigned int mmDAC_SOURCE_SELECT__SI                          = 0x19A5;
constexpr unsigned int mmDAC_STEREOSYNC_SELECT__SI                      = 0x19AD;
constexpr unsigned int mmDAC_SYNC_TRISTATE_CONTROL__SI                  = 0x19AC;
constexpr unsigned int mmDAC_W_INDEX__SI__VI                            = 0x00F2;
constexpr unsigned int mmDATA_FORMAT__SI                                = 0x1AC0;
constexpr unsigned int mmDBG_BYPASS_SRBM_ACCESS__CI                     = 0x14EB;
constexpr unsigned int mmDB_ALPHA_TO_MASK                               = 0xA2DC;
constexpr unsigned int mmDB_CGTT_CLK_CTRL_0__CI__VI                     = 0xF0A4;
constexpr unsigned int mmDB_CGTT_CLK_CTRL_0__SI                         = 0x261A;
constexpr unsigned int mmDB_COUNT_CONTROL                               = 0xA001;
constexpr unsigned int mmDB_CREDIT_LIMIT                                = 0x2614;
constexpr unsigned int mmDB_DEBUG                                       = 0x260C;
constexpr unsigned int mmDB_DEBUG2                                      = 0x260D;
constexpr unsigned int mmDB_DEBUG3                                      = 0x260E;
constexpr unsigned int mmDB_DEBUG4                                      = 0x260F;
constexpr unsigned int mmDB_DEPTH_BOUNDS_MAX                            = 0xA009;
constexpr unsigned int mmDB_DEPTH_BOUNDS_MIN                            = 0xA008;
constexpr unsigned int mmDB_DEPTH_CLEAR                                 = 0xA00B;
constexpr unsigned int mmDB_DEPTH_CONTROL                               = 0xA200;
constexpr unsigned int mmDB_DEPTH_INFO                                  = 0xA00F;
constexpr unsigned int mmDB_DEPTH_SIZE                                  = 0xA016;
constexpr unsigned int mmDB_DEPTH_SLICE                                 = 0xA017;
constexpr unsigned int mmDB_DEPTH_VIEW                                  = 0xA002;
constexpr unsigned int mmDB_EQAA                                        = 0xA201;
constexpr unsigned int mmDB_FIFO_DEPTH1                                 = 0x2618;
constexpr unsigned int mmDB_FIFO_DEPTH2                                 = 0x2619;
constexpr unsigned int mmDB_FREE_CACHELINES                             = 0x2617;
constexpr unsigned int mmDB_HTILE_DATA_BASE                             = 0xA005;
constexpr unsigned int mmDB_HTILE_SURFACE                               = 0xA2AF;
constexpr unsigned int mmDB_OCCLUSION_COUNT0_HI__CI__VI                 = 0xC3C1;
constexpr unsigned int mmDB_OCCLUSION_COUNT0_LOW__CI__VI                = 0xC3C0;
constexpr unsigned int mmDB_OCCLUSION_COUNT1_HI__CI__VI                 = 0xC3C3;
constexpr unsigned int mmDB_OCCLUSION_COUNT1_LOW__CI__VI                = 0xC3C2;
constexpr unsigned int mmDB_OCCLUSION_COUNT2_HI__CI__VI                 = 0xC3C5;
constexpr unsigned int mmDB_OCCLUSION_COUNT2_LOW__CI__VI                = 0xC3C4;
constexpr unsigned int mmDB_OCCLUSION_COUNT3_HI__CI__VI                 = 0xC3C7;
constexpr unsigned int mmDB_OCCLUSION_COUNT3_LOW__CI__VI                = 0xC3C6;
constexpr unsigned int mmDB_PERFCOUNTER0_HI__CI__VI                     = 0xD441;
constexpr unsigned int mmDB_PERFCOUNTER0_HI__SI                         = 0x2602;
constexpr unsigned int mmDB_PERFCOUNTER0_LO__CI__VI                     = 0xD440;
constexpr unsigned int mmDB_PERFCOUNTER0_LO__SI                         = 0x2601;
constexpr unsigned int mmDB_PERFCOUNTER0_SELECT1__CI__VI                = 0xDC41;
constexpr unsigned int mmDB_PERFCOUNTER0_SELECT__CI__VI                 = 0xDC40;
constexpr unsigned int mmDB_PERFCOUNTER0_SELECT__SI                     = 0x2600;
constexpr unsigned int mmDB_PERFCOUNTER1_HI__CI__VI                     = 0xD443;
constexpr unsigned int mmDB_PERFCOUNTER1_HI__SI                         = 0x2605;
constexpr unsigned int mmDB_PERFCOUNTER1_LO__CI__VI                     = 0xD442;
constexpr unsigned int mmDB_PERFCOUNTER1_LO__SI                         = 0x2604;
constexpr unsigned int mmDB_PERFCOUNTER1_SELECT1__CI__VI                = 0xDC43;
constexpr unsigned int mmDB_PERFCOUNTER1_SELECT__CI__VI                 = 0xDC42;
constexpr unsigned int mmDB_PERFCOUNTER1_SELECT__SI                     = 0x2603;
constexpr unsigned int mmDB_PERFCOUNTER2_HI__CI__VI                     = 0xD445;
constexpr unsigned int mmDB_PERFCOUNTER2_HI__SI                         = 0x2608;
constexpr unsigned int mmDB_PERFCOUNTER2_LO__CI__VI                     = 0xD444;
constexpr unsigned int mmDB_PERFCOUNTER2_LO__SI                         = 0x2607;
constexpr unsigned int mmDB_PERFCOUNTER2_SELECT__CI__VI                 = 0xDC44;
constexpr unsigned int mmDB_PERFCOUNTER2_SELECT__SI                     = 0x2606;
constexpr unsigned int mmDB_PERFCOUNTER3_HI__CI__VI                     = 0xD447;
constexpr unsigned int mmDB_PERFCOUNTER3_HI__SI                         = 0x260B;
constexpr unsigned int mmDB_PERFCOUNTER3_LO__CI__VI                     = 0xD446;
constexpr unsigned int mmDB_PERFCOUNTER3_LO__SI                         = 0x260A;
constexpr unsigned int mmDB_PERFCOUNTER3_SELECT__CI__VI                 = 0xDC46;
constexpr unsigned int mmDB_PERFCOUNTER3_SELECT__SI                     = 0x2609;
constexpr unsigned int mmDB_PRELOAD_CONTROL                             = 0xA2B2;
constexpr unsigned int mmDB_READ_DEBUG_0                                = 0x2620;
constexpr unsigned int mmDB_READ_DEBUG_1                                = 0x2621;
constexpr unsigned int mmDB_READ_DEBUG_2                                = 0x2622;
constexpr unsigned int mmDB_READ_DEBUG_3                                = 0x2623;
constexpr unsigned int mmDB_READ_DEBUG_4                                = 0x2624;
constexpr unsigned int mmDB_READ_DEBUG_5                                = 0x2625;
constexpr unsigned int mmDB_READ_DEBUG_6                                = 0x2626;
constexpr unsigned int mmDB_READ_DEBUG_7                                = 0x2627;
constexpr unsigned int mmDB_READ_DEBUG_8                                = 0x2628;
constexpr unsigned int mmDB_READ_DEBUG_9                                = 0x2629;
constexpr unsigned int mmDB_READ_DEBUG_A                                = 0x262A;
constexpr unsigned int mmDB_READ_DEBUG_B                                = 0x262B;
constexpr unsigned int mmDB_READ_DEBUG_C                                = 0x262C;
constexpr unsigned int mmDB_READ_DEBUG_D                                = 0x262D;
constexpr unsigned int mmDB_READ_DEBUG_E                                = 0x262E;
constexpr unsigned int mmDB_READ_DEBUG_F                                = 0x262F;
constexpr unsigned int mmDB_RENDER_CONTROL                              = 0xA000;
constexpr unsigned int mmDB_RENDER_OVERRIDE                             = 0xA003;
constexpr unsigned int mmDB_RENDER_OVERRIDE2                            = 0xA004;
constexpr unsigned int mmDB_RING_CONTROL__CI__VI                        = 0x261B;
constexpr unsigned int mmDB_SHADER_CONTROL                              = 0xA203;
constexpr unsigned int mmDB_SRESULTS_COMPARE_STATE0                     = 0xA2B0;
constexpr unsigned int mmDB_SRESULTS_COMPARE_STATE1                     = 0xA2B1;
constexpr unsigned int mmDB_STENCILREFMASK                              = 0xA10C;
constexpr unsigned int mmDB_STENCILREFMASK_BF                           = 0xA10D;
constexpr unsigned int mmDB_STENCIL_CLEAR                               = 0xA00A;
constexpr unsigned int mmDB_STENCIL_CONTROL                             = 0xA10B;
constexpr unsigned int mmDB_STENCIL_INFO                                = 0xA011;
constexpr unsigned int mmDB_STENCIL_READ_BASE                           = 0xA013;
constexpr unsigned int mmDB_STENCIL_WRITE_BASE                          = 0xA015;
constexpr unsigned int mmDB_SUBTILE_CONTROL                             = 0x2616;
constexpr unsigned int mmDB_WATERMARKS                                  = 0x2615;
constexpr unsigned int mmDB_ZPASS_COUNT_HI__CI__VI                      = 0xC3FF;
constexpr unsigned int mmDB_ZPASS_COUNT_HI__SI                          = 0x261D;
constexpr unsigned int mmDB_ZPASS_COUNT_LOW__CI__VI                     = 0xC3FE;
constexpr unsigned int mmDB_ZPASS_COUNT_LOW__SI                         = 0x261C;
constexpr unsigned int mmDB_Z_INFO                                      = 0xA010;
constexpr unsigned int mmDB_Z_READ_BASE                                 = 0xA012;
constexpr unsigned int mmDB_Z_WRITE_BASE                                = 0xA014;
constexpr unsigned int mmDCCG_AUDIO_DTO0_MODULE__SI                     = 0x0154;
constexpr unsigned int mmDCCG_AUDIO_DTO0_PHASE__SI                      = 0x0153;
constexpr unsigned int mmDCCG_GATE_DISABLE_CNTL__SI                     = 0x011F;
constexpr unsigned int mmDCCG_TEST_CLK_SEL__SI                          = 0x0147;
constexpr unsigned int mmDCCG_TEST_DEBUG_DATA__SI                       = 0x0159;
constexpr unsigned int mmDCCG_TEST_DEBUG_INDEX__SI                      = 0x0158;
constexpr unsigned int mmDCCG_VPCLK_CNTL__SI                            = 0x015E;
constexpr unsigned int mmDCDEBUG_BUS_CLK1_SEL__SI                       = 0x1860;
constexpr unsigned int mmDCDEBUG_BUS_CLK2_SEL__SI                       = 0x1861;
constexpr unsigned int mmDCDEBUG_BUS_CLK3_SEL__SI                       = 0x1862;
constexpr unsigned int mmDCDEBUG_BUS_CLK4_SEL__SI                       = 0x1863;
constexpr unsigned int mmDCDEBUG_OUT_CNTL__SI                           = 0x186B;
constexpr unsigned int mmDCDEBUG_OUT_PIN_OVERRIDE__SI                   = 0x186A;
constexpr unsigned int mmDCIO_DEBUG__SI                                 = 0x196F;
constexpr unsigned int mmDCIO_IMPCAL_CNTL_AB__SI                        = 0x194C;
constexpr unsigned int mmDCIO_IMPCAL_CNTL_CD__SI                        = 0x194F;
constexpr unsigned int mmDCIO_IMPCAL_CNTL_EF__SI                        = 0x1952;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_DATA_SYNCHRONIZATION__SI   = 0x1984;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_REG_TEST_OUTPUT__SI        = 0x1986;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_DATA_SYNCHRONIZATION__SI   = 0x1990;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_REG_TEST_OUTPUT__SI        = 0x1992;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_DATA_SYNCHRONIZATION__SI   = 0x199C;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_REG_TEST_OUTPUT__SI        = 0x199E;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_DATA_SYNCHRONIZATION__SI   = 0x19C4;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_REG_TEST_OUTPUT__SI        = 0x19C6;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_DATA_SYNCHRONIZATION__SI   = 0x19D0;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_REG_TEST_OUTPUT__SI        = 0x19D2;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_DATA_SYNCHRONIZATION__SI   = 0x19DC;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_REG_TEST_OUTPUT__SI        = 0x19DE;
constexpr unsigned int mmDCI_TEST_DEBUG_DATA__SI                        = 0x0321;
constexpr unsigned int mmDCI_TEST_DEBUG_INDEX__SI                       = 0x0320;
constexpr unsigned int mmDCP0_CUR_COLOR1__SI__VI                        = 0x1A6C;
constexpr unsigned int mmDCP0_CUR_COLOR2__SI__VI                        = 0x1A6D;
constexpr unsigned int mmDCP0_CUR_CONTROL__SI__VI                       = 0x1A66;
constexpr unsigned int mmDCP0_CUR_HOT_SPOT__SI__VI                      = 0x1A6B;
constexpr unsigned int mmDCP0_CUR_POSITION__SI__VI                      = 0x1A6A;
constexpr unsigned int mmDCP0_CUR_SIZE__SI__VI                          = 0x1A68;
constexpr unsigned int mmDCP0_CUR_SURFACE_ADDRESS_HIGH__SI__VI          = 0x1A69;
constexpr unsigned int mmDCP0_CUR_SURFACE_ADDRESS__SI__VI               = 0x1A67;
constexpr unsigned int mmDCP0_CUR_UPDATE__SI__VI                        = 0x1A6E;
constexpr unsigned int mmDCP0_DCP_CRC_CONTROL__SI__VI                   = 0x1A87;
constexpr unsigned int mmDCP0_DCP_CRC_CURRENT__SI__VI                   = 0x1A89;
constexpr unsigned int mmDCP0_DCP_CRC_LAST__SI__VI                      = 0x1A8B;
constexpr unsigned int mmDCP0_DCP_CRC_MASK__SI__VI                      = 0x1A88;
constexpr unsigned int mmDCP0_DCP_DEBUG__SI__VI                         = 0x1A8D;
constexpr unsigned int mmDCP0_DCP_LB_DATA_GAP_BETWEEN_CHUNK__SI__VI     = 0x1A91;
constexpr unsigned int mmDCP0_DCP_TEST_DEBUG_DATA__SI__VI               = 0x1A96;
constexpr unsigned int mmDCP0_DCP_TEST_DEBUG_INDEX__SI__VI              = 0x1A95;
constexpr unsigned int mmDCP0_DC_LUT_30_COLOR__SI__VI                   = 0x1A7C;
constexpr unsigned int mmDCP0_DC_LUT_AUTOFILL__SI__VI                   = 0x1A7F;
constexpr unsigned int mmDCP0_DC_LUT_BLACK_OFFSET_BLUE__SI__VI          = 0x1A81;
constexpr unsigned int mmDCP0_DC_LUT_BLACK_OFFSET_GREEN__SI__VI         = 0x1A82;
constexpr unsigned int mmDCP0_DC_LUT_BLACK_OFFSET_RED__SI__VI           = 0x1A83;
constexpr unsigned int mmDCP0_DC_LUT_CONTROL__SI__VI                    = 0x1A80;
constexpr unsigned int mmDCP0_DC_LUT_PWL_DATA__SI__VI                   = 0x1A7B;
constexpr unsigned int mmDCP0_DC_LUT_RW_INDEX__SI__VI                   = 0x1A79;
constexpr unsigned int mmDCP0_DC_LUT_RW_MODE__SI__VI                    = 0x1A78;
constexpr unsigned int mmDCP0_DC_LUT_SEQ_COLOR__SI__VI                  = 0x1A7A;
constexpr unsigned int mmDCP0_DC_LUT_WHITE_OFFSET_BLUE__SI__VI          = 0x1A84;
constexpr unsigned int mmDCP0_DC_LUT_WHITE_OFFSET_GREEN__SI__VI         = 0x1A85;
constexpr unsigned int mmDCP0_DC_LUT_WHITE_OFFSET_RED__SI__VI           = 0x1A86;
constexpr unsigned int mmDCP0_DC_LUT_WRITE_EN_MASK__SI__VI              = 0x1A7E;
constexpr unsigned int mmDCP0_GRPH_COMPRESS_PITCH__SI__VI               = 0x1A1A;
constexpr unsigned int mmDCP0_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH__SI__VI  = 0x1A1B;
constexpr unsigned int mmDCP0_GRPH_COMPRESS_SURFACE_ADDRESS__SI__VI     = 0x1A19;
constexpr unsigned int mmDCP0_GRPH_CONTROL                              = 0x1A01;
constexpr unsigned int mmDCP0_GRPH_DFQ_CONTROL__SI__VI                  = 0x1A14;
constexpr unsigned int mmDCP0_GRPH_DFQ_STATUS__SI__VI                   = 0x1A15;
constexpr unsigned int mmDCP0_GRPH_ENABLE__SI__VI                       = 0x1A00;
constexpr unsigned int mmDCP0_GRPH_FLIP_CONTROL                         = 0x1A12;
constexpr unsigned int mmDCP0_GRPH_INTERRUPT_CONTROL__SI__VI            = 0x1A17;
constexpr unsigned int mmDCP0_GRPH_INTERRUPT_STATUS__SI__VI             = 0x1A16;
constexpr unsigned int mmDCP0_GRPH_LUT_10BIT_BYPASS__SI__VI             = 0x1A02;
constexpr unsigned int mmDCP0_GRPH_PITCH                                = 0x1A06;
constexpr unsigned int mmDCP0_GRPH_PRIMARY_SURFACE_ADDRESS              = 0x1A04;
constexpr unsigned int mmDCP0_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH         = 0x1A07;
constexpr unsigned int mmDCP0_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH__SI__VI  = 0x1A08;
constexpr unsigned int mmDCP0_GRPH_SECONDARY_SURFACE_ADDRESS__SI__VI    = 0x1A05;
constexpr unsigned int mmDCP0_GRPH_SURFACE_ADDRESS_HIGH_INUSE__SI__VI   = 0x1A18;
constexpr unsigned int mmDCP0_GRPH_SURFACE_ADDRESS_INUSE__SI__VI        = 0x1A13;
constexpr unsigned int mmDCP0_GRPH_SURFACE_OFFSET_X__SI__VI             = 0x1A09;
constexpr unsigned int mmDCP0_GRPH_SURFACE_OFFSET_Y__SI__VI             = 0x1A0A;
constexpr unsigned int mmDCP0_GRPH_SWAP_CNTL__SI__VI                    = 0x1A03;
constexpr unsigned int mmDCP0_GRPH_UPDATE                               = 0x1A11;
constexpr unsigned int mmDCP0_GRPH_X_END__SI__VI                        = 0x1A0D;
constexpr unsigned int mmDCP0_GRPH_X_START__SI__VI                      = 0x1A0B;
constexpr unsigned int mmDCP0_GRPH_Y_END__SI__VI                        = 0x1A0E;
constexpr unsigned int mmDCP0_GRPH_Y_START__SI__VI                      = 0x1A0C;
constexpr unsigned int mmDCP0_OVLSCL_EDGE_PIXEL_CNTL__SI__VI            = 0x1A2C;
constexpr unsigned int mmDCP0_OVL_CONTROL1__SI__VI                      = 0x1A1D;
constexpr unsigned int mmDCP0_OVL_CONTROL2__SI__VI                      = 0x1A1E;
constexpr unsigned int mmDCP0_OVL_DFQ_CONTROL__SI__VI                   = 0x1A29;
constexpr unsigned int mmDCP0_OVL_DFQ_STATUS__SI__VI                    = 0x1A2A;
constexpr unsigned int mmDCP0_OVL_ENABLE__SI__VI                        = 0x1A1C;
constexpr unsigned int mmDCP0_OVL_END__SI__VI                           = 0x1A26;
constexpr unsigned int mmDCP0_OVL_PITCH__SI__VI                         = 0x1A21;
constexpr unsigned int mmDCP0_OVL_START__SI__VI                         = 0x1A25;
constexpr unsigned int mmDCP0_OVL_SURFACE_ADDRESS                       = 0x1A20;
constexpr unsigned int mmDCP0_OVL_SURFACE_ADDRESS_HIGH                  = 0x1A22;
constexpr unsigned int mmDCP0_OVL_SURFACE_ADDRESS_HIGH_INUSE__SI__VI    = 0x1A2B;
constexpr unsigned int mmDCP0_OVL_SURFACE_ADDRESS_INUSE__SI__VI         = 0x1A28;
constexpr unsigned int mmDCP0_OVL_SURFACE_OFFSET_X__SI__VI              = 0x1A23;
constexpr unsigned int mmDCP0_OVL_SURFACE_OFFSET_Y__SI__VI              = 0x1A24;
constexpr unsigned int mmDCP0_OVL_SWAP_CNTL__SI__VI                     = 0x1A1F;
constexpr unsigned int mmDCP0_OVL_UPDATE__SI__VI                        = 0x1A27;
constexpr unsigned int mmDCP1_CUR_COLOR1__SI                            = 0x1D6C;
constexpr unsigned int mmDCP1_CUR_COLOR2__SI                            = 0x1D6D;
constexpr unsigned int mmDCP1_CUR_CONTROL__SI                           = 0x1D66;
constexpr unsigned int mmDCP1_CUR_HOT_SPOT__SI                          = 0x1D6B;
constexpr unsigned int mmDCP1_CUR_POSITION__SI                          = 0x1D6A;
constexpr unsigned int mmDCP1_CUR_SIZE__SI                              = 0x1D68;
constexpr unsigned int mmDCP1_CUR_SURFACE_ADDRESS_HIGH__SI              = 0x1D69;
constexpr unsigned int mmDCP1_CUR_SURFACE_ADDRESS__SI                   = 0x1D67;
constexpr unsigned int mmDCP1_CUR_UPDATE__SI                            = 0x1D6E;
constexpr unsigned int mmDCP1_DCP_CRC_CONTROL__SI                       = 0x1D87;
constexpr unsigned int mmDCP1_DCP_CRC_CURRENT__SI                       = 0x1D89;
constexpr unsigned int mmDCP1_DCP_CRC_LAST__SI                          = 0x1D8B;
constexpr unsigned int mmDCP1_DCP_CRC_MASK__SI                          = 0x1D88;
constexpr unsigned int mmDCP1_DCP_DEBUG__SI                             = 0x1D8D;
constexpr unsigned int mmDCP1_DCP_LB_DATA_GAP_BETWEEN_CHUNK__SI         = 0x1D91;
constexpr unsigned int mmDCP1_DCP_TEST_DEBUG_DATA__SI                   = 0x1D96;
constexpr unsigned int mmDCP1_DCP_TEST_DEBUG_INDEX__SI                  = 0x1D95;
constexpr unsigned int mmDCP1_DC_LUT_30_COLOR__SI                       = 0x1D7C;
constexpr unsigned int mmDCP1_DC_LUT_AUTOFILL__SI                       = 0x1D7F;
constexpr unsigned int mmDCP1_DC_LUT_BLACK_OFFSET_BLUE__SI              = 0x1D81;
constexpr unsigned int mmDCP1_DC_LUT_BLACK_OFFSET_GREEN__SI             = 0x1D82;
constexpr unsigned int mmDCP1_DC_LUT_BLACK_OFFSET_RED__SI               = 0x1D83;
constexpr unsigned int mmDCP1_DC_LUT_CONTROL__SI                        = 0x1D80;
constexpr unsigned int mmDCP1_DC_LUT_PWL_DATA__SI                       = 0x1D7B;
constexpr unsigned int mmDCP1_DC_LUT_RW_INDEX__SI                       = 0x1D79;
constexpr unsigned int mmDCP1_DC_LUT_RW_MODE__SI                        = 0x1D78;
constexpr unsigned int mmDCP1_DC_LUT_SEQ_COLOR__SI                      = 0x1D7A;
constexpr unsigned int mmDCP1_DC_LUT_WHITE_OFFSET_BLUE__SI              = 0x1D84;
constexpr unsigned int mmDCP1_DC_LUT_WHITE_OFFSET_GREEN__SI             = 0x1D85;
constexpr unsigned int mmDCP1_DC_LUT_WHITE_OFFSET_RED__SI               = 0x1D86;
constexpr unsigned int mmDCP1_DC_LUT_WRITE_EN_MASK__SI                  = 0x1D7E;
constexpr unsigned int mmDCP1_GRPH_COMPRESS_PITCH__SI                   = 0x1D1A;
constexpr unsigned int mmDCP1_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH__SI    = 0x1D1B;
constexpr unsigned int mmDCP1_GRPH_COMPRESS_SURFACE_ADDRESS__SI         = 0x1D19;
constexpr unsigned int mmDCP1_GRPH_DFQ_CONTROL__SI                      = 0x1D14;
constexpr unsigned int mmDCP1_GRPH_DFQ_STATUS__SI                       = 0x1D15;
constexpr unsigned int mmDCP1_GRPH_ENABLE__SI                           = 0x1D00;
constexpr unsigned int mmDCP1_GRPH_INTERRUPT_CONTROL__SI                = 0x1D17;
constexpr unsigned int mmDCP1_GRPH_INTERRUPT_STATUS__SI                 = 0x1D16;
constexpr unsigned int mmDCP1_GRPH_LUT_10BIT_BYPASS__SI                 = 0x1D02;
constexpr unsigned int mmDCP1_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH__SI     = 0x1D07;
constexpr unsigned int mmDCP1_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH__SI   = 0x1D08;
constexpr unsigned int mmDCP1_GRPH_SECONDARY_SURFACE_ADDRESS__SI        = 0x1D05;
constexpr unsigned int mmDCP1_GRPH_SURFACE_ADDRESS_HIGH_INUSE__SI       = 0x1D18;
constexpr unsigned int mmDCP1_GRPH_SURFACE_ADDRESS_INUSE__SI            = 0x1D13;
constexpr unsigned int mmDCP1_GRPH_SURFACE_OFFSET_X__SI                 = 0x1D09;
constexpr unsigned int mmDCP1_GRPH_SURFACE_OFFSET_Y__SI                 = 0x1D0A;
constexpr unsigned int mmDCP1_GRPH_SWAP_CNTL__SI                        = 0x1D03;
constexpr unsigned int mmDCP1_GRPH_X_END__SI                            = 0x1D0D;
constexpr unsigned int mmDCP1_GRPH_X_START__SI                          = 0x1D0B;
constexpr unsigned int mmDCP1_GRPH_Y_END__SI                            = 0x1D0E;
constexpr unsigned int mmDCP1_GRPH_Y_START__SI                          = 0x1D0C;
constexpr unsigned int mmDCP1_OVLSCL_EDGE_PIXEL_CNTL__SI                = 0x1D2C;
constexpr unsigned int mmDCP1_OVL_CONTROL1__SI                          = 0x1D1D;
constexpr unsigned int mmDCP1_OVL_CONTROL2__SI                          = 0x1D1E;
constexpr unsigned int mmDCP1_OVL_DFQ_CONTROL__SI                       = 0x1D29;
constexpr unsigned int mmDCP1_OVL_DFQ_STATUS__SI                        = 0x1D2A;
constexpr unsigned int mmDCP1_OVL_ENABLE__SI                            = 0x1D1C;
constexpr unsigned int mmDCP1_OVL_END__SI                               = 0x1D26;
constexpr unsigned int mmDCP1_OVL_PITCH__SI                             = 0x1D21;
constexpr unsigned int mmDCP1_OVL_START__SI                             = 0x1D25;
constexpr unsigned int mmDCP1_OVL_SURFACE_ADDRESS_HIGH_INUSE__SI        = 0x1D2B;
constexpr unsigned int mmDCP1_OVL_SURFACE_ADDRESS_HIGH__SI              = 0x1D22;
constexpr unsigned int mmDCP1_OVL_SURFACE_ADDRESS_INUSE__SI             = 0x1D28;
constexpr unsigned int mmDCP1_OVL_SURFACE_OFFSET_X__SI                  = 0x1D23;
constexpr unsigned int mmDCP1_OVL_SURFACE_OFFSET_Y__SI                  = 0x1D24;
constexpr unsigned int mmDCP1_OVL_SWAP_CNTL__SI                         = 0x1D1F;
constexpr unsigned int mmDCP1_OVL_UPDATE__SI                            = 0x1D27;
constexpr unsigned int mmDCP2_CUR_COLOR1__SI                            = 0x406C;
constexpr unsigned int mmDCP2_CUR_COLOR2__SI                            = 0x406D;
constexpr unsigned int mmDCP2_CUR_CONTROL__SI                           = 0x4066;
constexpr unsigned int mmDCP2_CUR_HOT_SPOT__SI                          = 0x406B;
constexpr unsigned int mmDCP2_CUR_POSITION__SI                          = 0x406A;
constexpr unsigned int mmDCP2_CUR_SIZE__SI                              = 0x4068;
constexpr unsigned int mmDCP2_CUR_SURFACE_ADDRESS_HIGH__SI              = 0x4069;
constexpr unsigned int mmDCP2_CUR_SURFACE_ADDRESS__SI                   = 0x4067;
constexpr unsigned int mmDCP2_CUR_UPDATE__SI                            = 0x406E;
constexpr unsigned int mmDCP2_DCP_CRC_CONTROL__SI                       = 0x4087;
constexpr unsigned int mmDCP2_DCP_CRC_CURRENT__SI                       = 0x4089;
constexpr unsigned int mmDCP2_DCP_CRC_LAST__SI                          = 0x408B;
constexpr unsigned int mmDCP2_DCP_CRC_MASK__SI                          = 0x4088;
constexpr unsigned int mmDCP2_DCP_DEBUG__SI                             = 0x408D;
constexpr unsigned int mmDCP2_DCP_LB_DATA_GAP_BETWEEN_CHUNK__SI         = 0x4091;
constexpr unsigned int mmDCP2_DCP_TEST_DEBUG_DATA__SI                   = 0x4096;
constexpr unsigned int mmDCP2_DCP_TEST_DEBUG_INDEX__SI                  = 0x4095;
constexpr unsigned int mmDCP2_DC_LUT_30_COLOR__SI                       = 0x407C;
constexpr unsigned int mmDCP2_DC_LUT_AUTOFILL__SI                       = 0x407F;
constexpr unsigned int mmDCP2_DC_LUT_BLACK_OFFSET_BLUE__SI              = 0x4081;
constexpr unsigned int mmDCP2_DC_LUT_BLACK_OFFSET_GREEN__SI             = 0x4082;
constexpr unsigned int mmDCP2_DC_LUT_BLACK_OFFSET_RED__SI               = 0x4083;
constexpr unsigned int mmDCP2_DC_LUT_CONTROL__SI                        = 0x4080;
constexpr unsigned int mmDCP2_DC_LUT_PWL_DATA__SI                       = 0x407B;
constexpr unsigned int mmDCP2_DC_LUT_RW_INDEX__SI                       = 0x4079;
constexpr unsigned int mmDCP2_DC_LUT_RW_MODE__SI                        = 0x4078;
constexpr unsigned int mmDCP2_DC_LUT_SEQ_COLOR__SI                      = 0x407A;
constexpr unsigned int mmDCP2_DC_LUT_WHITE_OFFSET_BLUE__SI              = 0x4084;
constexpr unsigned int mmDCP2_DC_LUT_WHITE_OFFSET_GREEN__SI             = 0x4085;
constexpr unsigned int mmDCP2_DC_LUT_WHITE_OFFSET_RED__SI               = 0x4086;
constexpr unsigned int mmDCP2_DC_LUT_WRITE_EN_MASK__SI                  = 0x407E;
constexpr unsigned int mmDCP2_GRPH_COMPRESS_PITCH__SI                   = 0x401A;
constexpr unsigned int mmDCP2_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH__SI    = 0x401B;
constexpr unsigned int mmDCP2_GRPH_COMPRESS_SURFACE_ADDRESS__SI         = 0x4019;
constexpr unsigned int mmDCP2_GRPH_DFQ_CONTROL__SI                      = 0x4014;
constexpr unsigned int mmDCP2_GRPH_DFQ_STATUS__SI                       = 0x4015;
constexpr unsigned int mmDCP2_GRPH_ENABLE__SI                           = 0x4000;
constexpr unsigned int mmDCP2_GRPH_INTERRUPT_CONTROL__SI                = 0x4017;
constexpr unsigned int mmDCP2_GRPH_INTERRUPT_STATUS__SI                 = 0x4016;
constexpr unsigned int mmDCP2_GRPH_LUT_10BIT_BYPASS__SI                 = 0x4002;
constexpr unsigned int mmDCP2_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH__SI     = 0x4007;
constexpr unsigned int mmDCP2_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH__SI   = 0x4008;
constexpr unsigned int mmDCP2_GRPH_SECONDARY_SURFACE_ADDRESS__SI        = 0x4005;
constexpr unsigned int mmDCP2_GRPH_SURFACE_ADDRESS_HIGH_INUSE__SI       = 0x4018;
constexpr unsigned int mmDCP2_GRPH_SURFACE_ADDRESS_INUSE__SI            = 0x4013;
constexpr unsigned int mmDCP2_GRPH_SURFACE_OFFSET_X__SI                 = 0x4009;
constexpr unsigned int mmDCP2_GRPH_SURFACE_OFFSET_Y__SI                 = 0x400A;
constexpr unsigned int mmDCP2_GRPH_SWAP_CNTL__SI                        = 0x4003;
constexpr unsigned int mmDCP2_GRPH_X_END__SI                            = 0x400D;
constexpr unsigned int mmDCP2_GRPH_X_START__SI                          = 0x400B;
constexpr unsigned int mmDCP2_GRPH_Y_END__SI                            = 0x400E;
constexpr unsigned int mmDCP2_GRPH_Y_START__SI                          = 0x400C;
constexpr unsigned int mmDCP2_OVLSCL_EDGE_PIXEL_CNTL__SI                = 0x402C;
constexpr unsigned int mmDCP2_OVL_CONTROL1__SI                          = 0x401D;
constexpr unsigned int mmDCP2_OVL_CONTROL2__SI                          = 0x401E;
constexpr unsigned int mmDCP2_OVL_DFQ_CONTROL__SI                       = 0x4029;
constexpr unsigned int mmDCP2_OVL_DFQ_STATUS__SI                        = 0x402A;
constexpr unsigned int mmDCP2_OVL_ENABLE__SI                            = 0x401C;
constexpr unsigned int mmDCP2_OVL_END__SI                               = 0x4026;
constexpr unsigned int mmDCP2_OVL_PITCH__SI                             = 0x4021;
constexpr unsigned int mmDCP2_OVL_START__SI                             = 0x4025;
constexpr unsigned int mmDCP2_OVL_SURFACE_ADDRESS_HIGH_INUSE__SI        = 0x402B;
constexpr unsigned int mmDCP2_OVL_SURFACE_ADDRESS_HIGH__SI              = 0x4022;
constexpr unsigned int mmDCP2_OVL_SURFACE_ADDRESS_INUSE__SI             = 0x4028;
constexpr unsigned int mmDCP2_OVL_SURFACE_OFFSET_X__SI                  = 0x4023;
constexpr unsigned int mmDCP2_OVL_SURFACE_OFFSET_Y__SI                  = 0x4024;
constexpr unsigned int mmDCP2_OVL_SWAP_CNTL__SI                         = 0x401F;
constexpr unsigned int mmDCP2_OVL_UPDATE__SI                            = 0x4027;
constexpr unsigned int mmDCP3_CUR_COLOR1__SI                            = 0x436C;
constexpr unsigned int mmDCP3_CUR_COLOR2__SI                            = 0x436D;
constexpr unsigned int mmDCP3_CUR_CONTROL__SI                           = 0x4366;
constexpr unsigned int mmDCP3_CUR_HOT_SPOT__SI                          = 0x436B;
constexpr unsigned int mmDCP3_CUR_POSITION__SI                          = 0x436A;
constexpr unsigned int mmDCP3_CUR_SIZE__SI                              = 0x4368;
constexpr unsigned int mmDCP3_CUR_SURFACE_ADDRESS_HIGH__SI              = 0x4369;
constexpr unsigned int mmDCP3_CUR_SURFACE_ADDRESS__SI                   = 0x4367;
constexpr unsigned int mmDCP3_CUR_UPDATE__SI                            = 0x436E;
constexpr unsigned int mmDCP3_DCP_CRC_CONTROL__SI                       = 0x4387;
constexpr unsigned int mmDCP3_DCP_CRC_CURRENT__SI                       = 0x4389;
constexpr unsigned int mmDCP3_DCP_CRC_LAST__SI                          = 0x438B;
constexpr unsigned int mmDCP3_DCP_CRC_MASK__SI                          = 0x4388;
constexpr unsigned int mmDCP3_DCP_DEBUG__SI                             = 0x438D;
constexpr unsigned int mmDCP3_DCP_LB_DATA_GAP_BETWEEN_CHUNK__SI         = 0x4391;
constexpr unsigned int mmDCP3_DCP_TEST_DEBUG_DATA__SI                   = 0x4396;
constexpr unsigned int mmDCP3_DCP_TEST_DEBUG_INDEX__SI                  = 0x4395;
constexpr unsigned int mmDCP3_DC_LUT_30_COLOR__SI                       = 0x437C;
constexpr unsigned int mmDCP3_DC_LUT_AUTOFILL__SI                       = 0x437F;
constexpr unsigned int mmDCP3_DC_LUT_BLACK_OFFSET_BLUE__SI              = 0x4381;
constexpr unsigned int mmDCP3_DC_LUT_BLACK_OFFSET_GREEN__SI             = 0x4382;
constexpr unsigned int mmDCP3_DC_LUT_BLACK_OFFSET_RED__SI               = 0x4383;
constexpr unsigned int mmDCP3_DC_LUT_CONTROL__SI                        = 0x4380;
constexpr unsigned int mmDCP3_DC_LUT_PWL_DATA__SI                       = 0x437B;
constexpr unsigned int mmDCP3_DC_LUT_RW_INDEX__SI                       = 0x4379;
constexpr unsigned int mmDCP3_DC_LUT_RW_MODE__SI                        = 0x4378;
constexpr unsigned int mmDCP3_DC_LUT_SEQ_COLOR__SI                      = 0x437A;
constexpr unsigned int mmDCP3_DC_LUT_WHITE_OFFSET_BLUE__SI              = 0x4384;
constexpr unsigned int mmDCP3_DC_LUT_WHITE_OFFSET_GREEN__SI             = 0x4385;
constexpr unsigned int mmDCP3_DC_LUT_WHITE_OFFSET_RED__SI               = 0x4386;
constexpr unsigned int mmDCP3_DC_LUT_WRITE_EN_MASK__SI                  = 0x437E;
constexpr unsigned int mmDCP3_GRPH_COMPRESS_PITCH__SI                   = 0x431A;
constexpr unsigned int mmDCP3_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH__SI    = 0x431B;
constexpr unsigned int mmDCP3_GRPH_COMPRESS_SURFACE_ADDRESS__SI         = 0x4319;
constexpr unsigned int mmDCP3_GRPH_DFQ_CONTROL__SI                      = 0x4314;
constexpr unsigned int mmDCP3_GRPH_DFQ_STATUS__SI                       = 0x4315;
constexpr unsigned int mmDCP3_GRPH_ENABLE__SI                           = 0x4300;
constexpr unsigned int mmDCP3_GRPH_INTERRUPT_CONTROL__SI                = 0x4317;
constexpr unsigned int mmDCP3_GRPH_INTERRUPT_STATUS__SI                 = 0x4316;
constexpr unsigned int mmDCP3_GRPH_LUT_10BIT_BYPASS__SI                 = 0x4302;
constexpr unsigned int mmDCP3_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH__SI     = 0x4307;
constexpr unsigned int mmDCP3_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH__SI   = 0x4308;
constexpr unsigned int mmDCP3_GRPH_SECONDARY_SURFACE_ADDRESS__SI        = 0x4305;
constexpr unsigned int mmDCP3_GRPH_SURFACE_ADDRESS_HIGH_INUSE__SI       = 0x4318;
constexpr unsigned int mmDCP3_GRPH_SURFACE_ADDRESS_INUSE__SI            = 0x4313;
constexpr unsigned int mmDCP3_GRPH_SURFACE_OFFSET_X__SI                 = 0x4309;
constexpr unsigned int mmDCP3_GRPH_SURFACE_OFFSET_Y__SI                 = 0x430A;
constexpr unsigned int mmDCP3_GRPH_SWAP_CNTL__SI                        = 0x4303;
constexpr unsigned int mmDCP3_GRPH_X_END__SI                            = 0x430D;
constexpr unsigned int mmDCP3_GRPH_X_START__SI                          = 0x430B;
constexpr unsigned int mmDCP3_GRPH_Y_END__SI                            = 0x430E;
constexpr unsigned int mmDCP3_GRPH_Y_START__SI                          = 0x430C;
constexpr unsigned int mmDCP3_OVLSCL_EDGE_PIXEL_CNTL__SI                = 0x432C;
constexpr unsigned int mmDCP3_OVL_CONTROL1__SI                          = 0x431D;
constexpr unsigned int mmDCP3_OVL_CONTROL2__SI                          = 0x431E;
constexpr unsigned int mmDCP3_OVL_DFQ_CONTROL__SI                       = 0x4329;
constexpr unsigned int mmDCP3_OVL_DFQ_STATUS__SI                        = 0x432A;
constexpr unsigned int mmDCP3_OVL_ENABLE__SI                            = 0x431C;
constexpr unsigned int mmDCP3_OVL_END__SI                               = 0x4326;
constexpr unsigned int mmDCP3_OVL_PITCH__SI                             = 0x4321;
constexpr unsigned int mmDCP3_OVL_START__SI                             = 0x4325;
constexpr unsigned int mmDCP3_OVL_SURFACE_ADDRESS_HIGH_INUSE__SI        = 0x432B;
constexpr unsigned int mmDCP3_OVL_SURFACE_ADDRESS_HIGH__SI              = 0x4322;
constexpr unsigned int mmDCP3_OVL_SURFACE_ADDRESS_INUSE__SI             = 0x4328;
constexpr unsigned int mmDCP3_OVL_SURFACE_OFFSET_X__SI                  = 0x4323;
constexpr unsigned int mmDCP3_OVL_SURFACE_OFFSET_Y__SI                  = 0x4324;
constexpr unsigned int mmDCP3_OVL_SWAP_CNTL__SI                         = 0x431F;
constexpr unsigned int mmDCP3_OVL_UPDATE__SI                            = 0x4327;
constexpr unsigned int mmDCP4_CUR_COLOR1__SI                            = 0x466C;
constexpr unsigned int mmDCP4_CUR_COLOR2__SI                            = 0x466D;
constexpr unsigned int mmDCP4_CUR_CONTROL__SI                           = 0x4666;
constexpr unsigned int mmDCP4_CUR_HOT_SPOT__SI                          = 0x466B;
constexpr unsigned int mmDCP4_CUR_POSITION__SI                          = 0x466A;
constexpr unsigned int mmDCP4_CUR_SIZE__SI                              = 0x4668;
constexpr unsigned int mmDCP4_CUR_SURFACE_ADDRESS_HIGH__SI              = 0x4669;
constexpr unsigned int mmDCP4_CUR_SURFACE_ADDRESS__SI                   = 0x4667;
constexpr unsigned int mmDCP4_CUR_UPDATE__SI                            = 0x466E;
constexpr unsigned int mmDCP4_DCP_CRC_CONTROL__SI                       = 0x4687;
constexpr unsigned int mmDCP4_DCP_CRC_CURRENT__SI                       = 0x4689;
constexpr unsigned int mmDCP4_DCP_CRC_LAST__SI                          = 0x468B;
constexpr unsigned int mmDCP4_DCP_CRC_MASK__SI                          = 0x4688;
constexpr unsigned int mmDCP4_DCP_DEBUG__SI                             = 0x468D;
constexpr unsigned int mmDCP4_DCP_LB_DATA_GAP_BETWEEN_CHUNK__SI         = 0x4691;
constexpr unsigned int mmDCP4_DCP_TEST_DEBUG_DATA__SI                   = 0x4696;
constexpr unsigned int mmDCP4_DCP_TEST_DEBUG_INDEX__SI                  = 0x4695;
constexpr unsigned int mmDCP4_DC_LUT_30_COLOR__SI                       = 0x467C;
constexpr unsigned int mmDCP4_DC_LUT_AUTOFILL__SI                       = 0x467F;
constexpr unsigned int mmDCP4_DC_LUT_BLACK_OFFSET_BLUE__SI              = 0x4681;
constexpr unsigned int mmDCP4_DC_LUT_BLACK_OFFSET_GREEN__SI             = 0x4682;
constexpr unsigned int mmDCP4_DC_LUT_BLACK_OFFSET_RED__SI               = 0x4683;
constexpr unsigned int mmDCP4_DC_LUT_CONTROL__SI                        = 0x4680;
constexpr unsigned int mmDCP4_DC_LUT_PWL_DATA__SI                       = 0x467B;
constexpr unsigned int mmDCP4_DC_LUT_RW_INDEX__SI                       = 0x4679;
constexpr unsigned int mmDCP4_DC_LUT_RW_MODE__SI                        = 0x4678;
constexpr unsigned int mmDCP4_DC_LUT_SEQ_COLOR__SI                      = 0x467A;
constexpr unsigned int mmDCP4_DC_LUT_WHITE_OFFSET_BLUE__SI              = 0x4684;
constexpr unsigned int mmDCP4_DC_LUT_WHITE_OFFSET_GREEN__SI             = 0x4685;
constexpr unsigned int mmDCP4_DC_LUT_WHITE_OFFSET_RED__SI               = 0x4686;
constexpr unsigned int mmDCP4_DC_LUT_WRITE_EN_MASK__SI                  = 0x467E;
constexpr unsigned int mmDCP4_GRPH_COMPRESS_PITCH__SI                   = 0x461A;
constexpr unsigned int mmDCP4_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH__SI    = 0x461B;
constexpr unsigned int mmDCP4_GRPH_COMPRESS_SURFACE_ADDRESS__SI         = 0x4619;
constexpr unsigned int mmDCP4_GRPH_DFQ_CONTROL__SI                      = 0x4614;
constexpr unsigned int mmDCP4_GRPH_DFQ_STATUS__SI                       = 0x4615;
constexpr unsigned int mmDCP4_GRPH_ENABLE__SI                           = 0x4600;
constexpr unsigned int mmDCP4_GRPH_INTERRUPT_CONTROL__SI                = 0x4617;
constexpr unsigned int mmDCP4_GRPH_INTERRUPT_STATUS__SI                 = 0x4616;
constexpr unsigned int mmDCP4_GRPH_LUT_10BIT_BYPASS__SI                 = 0x4602;
constexpr unsigned int mmDCP4_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH__SI     = 0x4607;
constexpr unsigned int mmDCP4_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH__SI   = 0x4608;
constexpr unsigned int mmDCP4_GRPH_SECONDARY_SURFACE_ADDRESS__SI        = 0x4605;
constexpr unsigned int mmDCP4_GRPH_SURFACE_ADDRESS_HIGH_INUSE__SI       = 0x4618;
constexpr unsigned int mmDCP4_GRPH_SURFACE_ADDRESS_INUSE__SI            = 0x4613;
constexpr unsigned int mmDCP4_GRPH_SURFACE_OFFSET_X__SI                 = 0x4609;
constexpr unsigned int mmDCP4_GRPH_SURFACE_OFFSET_Y__SI                 = 0x460A;
constexpr unsigned int mmDCP4_GRPH_SWAP_CNTL__SI                        = 0x4603;
constexpr unsigned int mmDCP4_GRPH_X_END__SI                            = 0x460D;
constexpr unsigned int mmDCP4_GRPH_X_START__SI                          = 0x460B;
constexpr unsigned int mmDCP4_GRPH_Y_END__SI                            = 0x460E;
constexpr unsigned int mmDCP4_GRPH_Y_START__SI                          = 0x460C;
constexpr unsigned int mmDCP4_OVLSCL_EDGE_PIXEL_CNTL__SI                = 0x462C;
constexpr unsigned int mmDCP4_OVL_CONTROL1__SI                          = 0x461D;
constexpr unsigned int mmDCP4_OVL_CONTROL2__SI                          = 0x461E;
constexpr unsigned int mmDCP4_OVL_DFQ_CONTROL__SI                       = 0x4629;
constexpr unsigned int mmDCP4_OVL_DFQ_STATUS__SI                        = 0x462A;
constexpr unsigned int mmDCP4_OVL_ENABLE__SI                            = 0x461C;
constexpr unsigned int mmDCP4_OVL_END__SI                               = 0x4626;
constexpr unsigned int mmDCP4_OVL_PITCH__SI                             = 0x4621;
constexpr unsigned int mmDCP4_OVL_START__SI                             = 0x4625;
constexpr unsigned int mmDCP4_OVL_SURFACE_ADDRESS_HIGH_INUSE__SI        = 0x462B;
constexpr unsigned int mmDCP4_OVL_SURFACE_ADDRESS_HIGH__SI              = 0x4622;
constexpr unsigned int mmDCP4_OVL_SURFACE_ADDRESS_INUSE__SI             = 0x4628;
constexpr unsigned int mmDCP4_OVL_SURFACE_OFFSET_X__SI                  = 0x4623;
constexpr unsigned int mmDCP4_OVL_SURFACE_OFFSET_Y__SI                  = 0x4624;
constexpr unsigned int mmDCP4_OVL_SWAP_CNTL__SI                         = 0x461F;
constexpr unsigned int mmDCP4_OVL_UPDATE__SI                            = 0x4627;
constexpr unsigned int mmDCP5_CUR_COLOR1__SI                            = 0x496C;
constexpr unsigned int mmDCP5_CUR_COLOR2__SI                            = 0x496D;
constexpr unsigned int mmDCP5_CUR_CONTROL__SI                           = 0x4966;
constexpr unsigned int mmDCP5_CUR_HOT_SPOT__SI                          = 0x496B;
constexpr unsigned int mmDCP5_CUR_POSITION__SI                          = 0x496A;
constexpr unsigned int mmDCP5_CUR_SIZE__SI                              = 0x4968;
constexpr unsigned int mmDCP5_CUR_SURFACE_ADDRESS_HIGH__SI              = 0x4969;
constexpr unsigned int mmDCP5_CUR_SURFACE_ADDRESS__SI                   = 0x4967;
constexpr unsigned int mmDCP5_CUR_UPDATE__SI                            = 0x496E;
constexpr unsigned int mmDCP5_DCP_CRC_CONTROL__SI                       = 0x4987;
constexpr unsigned int mmDCP5_DCP_CRC_CURRENT__SI                       = 0x4989;
constexpr unsigned int mmDCP5_DCP_CRC_LAST__SI                          = 0x498B;
constexpr unsigned int mmDCP5_DCP_CRC_MASK__SI                          = 0x4988;
constexpr unsigned int mmDCP5_DCP_DEBUG__SI                             = 0x498D;
constexpr unsigned int mmDCP5_DCP_LB_DATA_GAP_BETWEEN_CHUNK__SI         = 0x4991;
constexpr unsigned int mmDCP5_DCP_TEST_DEBUG_DATA__SI                   = 0x4996;
constexpr unsigned int mmDCP5_DCP_TEST_DEBUG_INDEX__SI                  = 0x4995;
constexpr unsigned int mmDCP5_DC_LUT_30_COLOR__SI                       = 0x497C;
constexpr unsigned int mmDCP5_DC_LUT_AUTOFILL__SI                       = 0x497F;
constexpr unsigned int mmDCP5_DC_LUT_BLACK_OFFSET_BLUE__SI              = 0x4981;
constexpr unsigned int mmDCP5_DC_LUT_BLACK_OFFSET_GREEN__SI             = 0x4982;
constexpr unsigned int mmDCP5_DC_LUT_BLACK_OFFSET_RED__SI               = 0x4983;
constexpr unsigned int mmDCP5_DC_LUT_CONTROL__SI                        = 0x4980;
constexpr unsigned int mmDCP5_DC_LUT_PWL_DATA__SI                       = 0x497B;
constexpr unsigned int mmDCP5_DC_LUT_RW_INDEX__SI                       = 0x4979;
constexpr unsigned int mmDCP5_DC_LUT_RW_MODE__SI                        = 0x4978;
constexpr unsigned int mmDCP5_DC_LUT_SEQ_COLOR__SI                      = 0x497A;
constexpr unsigned int mmDCP5_DC_LUT_WHITE_OFFSET_BLUE__SI              = 0x4984;
constexpr unsigned int mmDCP5_DC_LUT_WHITE_OFFSET_GREEN__SI             = 0x4985;
constexpr unsigned int mmDCP5_DC_LUT_WHITE_OFFSET_RED__SI               = 0x4986;
constexpr unsigned int mmDCP5_DC_LUT_WRITE_EN_MASK__SI                  = 0x497E;
constexpr unsigned int mmDCP5_GRPH_COMPRESS_PITCH__SI                   = 0x491A;
constexpr unsigned int mmDCP5_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH__SI    = 0x491B;
constexpr unsigned int mmDCP5_GRPH_COMPRESS_SURFACE_ADDRESS__SI         = 0x4919;
constexpr unsigned int mmDCP5_GRPH_DFQ_CONTROL__SI                      = 0x4914;
constexpr unsigned int mmDCP5_GRPH_DFQ_STATUS__SI                       = 0x4915;
constexpr unsigned int mmDCP5_GRPH_ENABLE__SI                           = 0x4900;
constexpr unsigned int mmDCP5_GRPH_INTERRUPT_CONTROL__SI                = 0x4917;
constexpr unsigned int mmDCP5_GRPH_INTERRUPT_STATUS__SI                 = 0x4916;
constexpr unsigned int mmDCP5_GRPH_LUT_10BIT_BYPASS__SI                 = 0x4902;
constexpr unsigned int mmDCP5_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH__SI     = 0x4907;
constexpr unsigned int mmDCP5_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH__SI   = 0x4908;
constexpr unsigned int mmDCP5_GRPH_SECONDARY_SURFACE_ADDRESS__SI        = 0x4905;
constexpr unsigned int mmDCP5_GRPH_SURFACE_ADDRESS_HIGH_INUSE__SI       = 0x4918;
constexpr unsigned int mmDCP5_GRPH_SURFACE_ADDRESS_INUSE__SI            = 0x4913;
constexpr unsigned int mmDCP5_GRPH_SURFACE_OFFSET_X__SI                 = 0x4909;
constexpr unsigned int mmDCP5_GRPH_SURFACE_OFFSET_Y__SI                 = 0x490A;
constexpr unsigned int mmDCP5_GRPH_SWAP_CNTL__SI                        = 0x4903;
constexpr unsigned int mmDCP5_GRPH_X_END__SI                            = 0x490D;
constexpr unsigned int mmDCP5_GRPH_X_START__SI                          = 0x490B;
constexpr unsigned int mmDCP5_GRPH_Y_END__SI                            = 0x490E;
constexpr unsigned int mmDCP5_GRPH_Y_START__SI                          = 0x490C;
constexpr unsigned int mmDCP5_OVLSCL_EDGE_PIXEL_CNTL__SI                = 0x492C;
constexpr unsigned int mmDCP5_OVL_CONTROL1__SI                          = 0x491D;
constexpr unsigned int mmDCP5_OVL_CONTROL2__SI                          = 0x491E;
constexpr unsigned int mmDCP5_OVL_DFQ_CONTROL__SI                       = 0x4929;
constexpr unsigned int mmDCP5_OVL_DFQ_STATUS__SI                        = 0x492A;
constexpr unsigned int mmDCP5_OVL_ENABLE__SI                            = 0x491C;
constexpr unsigned int mmDCP5_OVL_END__SI                               = 0x4926;
constexpr unsigned int mmDCP5_OVL_PITCH__SI                             = 0x4921;
constexpr unsigned int mmDCP5_OVL_START__SI                             = 0x4925;
constexpr unsigned int mmDCP5_OVL_SURFACE_ADDRESS_HIGH_INUSE__SI        = 0x492B;
constexpr unsigned int mmDCP5_OVL_SURFACE_ADDRESS_HIGH__SI              = 0x4922;
constexpr unsigned int mmDCP5_OVL_SURFACE_ADDRESS_INUSE__SI             = 0x4928;
constexpr unsigned int mmDCP5_OVL_SURFACE_OFFSET_X__SI                  = 0x4923;
constexpr unsigned int mmDCP5_OVL_SURFACE_OFFSET_Y__SI                  = 0x4924;
constexpr unsigned int mmDCP5_OVL_SWAP_CNTL__SI                         = 0x491F;
constexpr unsigned int mmDCP5_OVL_UPDATE__SI                            = 0x4927;
constexpr unsigned int mmDCP_CRC_CONTROL__SI__VI                        = 0x1A87;
constexpr unsigned int mmDCP_CRC_CURRENT__SI__VI                        = 0x1A89;
constexpr unsigned int mmDCP_CRC_LAST__SI__VI                           = 0x1A8B;
constexpr unsigned int mmDCP_CRC_MASK__SI__VI                           = 0x1A88;
constexpr unsigned int mmDCP_DEBUG__SI__VI                              = 0x1A8D;
constexpr unsigned int mmDCP_LB_DATA_GAP_BETWEEN_CHUNK__SI__VI          = 0x1A91;
constexpr unsigned int mmDCP_TEST_DEBUG_DATA__SI__VI                    = 0x1A96;
constexpr unsigned int mmDCP_TEST_DEBUG_INDEX__SI__VI                   = 0x1A95;
constexpr unsigned int mmDC_ABM1_ACE_CNTL_MISC__SI__VI                  = 0x1641;
constexpr unsigned int mmDC_ABM1_ACE_OFFSET_SLOPE_0__SI__VI             = 0x163A;
constexpr unsigned int mmDC_ABM1_ACE_OFFSET_SLOPE_1__SI__VI             = 0x163B;
constexpr unsigned int mmDC_ABM1_ACE_OFFSET_SLOPE_2__SI__VI             = 0x163C;
constexpr unsigned int mmDC_ABM1_ACE_OFFSET_SLOPE_3__SI__VI             = 0x163D;
constexpr unsigned int mmDC_ABM1_ACE_OFFSET_SLOPE_4__SI__VI             = 0x163E;
constexpr unsigned int mmDC_ABM1_ACE_THRES_12__SI__VI                   = 0x163F;
constexpr unsigned int mmDC_ABM1_ACE_THRES_34__SI__VI                   = 0x1640;
constexpr unsigned int mmDC_ABM1_BL_MASTER_LOCK__SI__VI                 = 0x169C;
constexpr unsigned int mmDC_ABM1_CNTL__SI__VI                           = 0x1638;
constexpr unsigned int mmDC_ABM1_DEBUG_MISC__SI__VI                     = 0x1649;
constexpr unsigned int mmDC_ABM1_HGLS_REG_READ_PROGRESS__SI__VI         = 0x164A;
constexpr unsigned int mmDC_ABM1_HG_BIN_17_24_SHIFT_INDEX__SI__VI       = 0x1659;
constexpr unsigned int mmDC_ABM1_HG_BIN_1_32_SHIFT_FLAG__SI__VI         = 0x1656;
constexpr unsigned int mmDC_ABM1_HG_BIN_1_8_SHIFT_INDEX__SI__VI         = 0x1657;
constexpr unsigned int mmDC_ABM1_HG_BIN_25_32_SHIFT_INDEX__SI__VI       = 0x165A;
constexpr unsigned int mmDC_ABM1_HG_BIN_9_16_SHIFT_INDEX__SI__VI        = 0x1658;
constexpr unsigned int mmDC_ABM1_HG_MISC_CTRL__SI__VI                   = 0x164B;
constexpr unsigned int mmDC_ABM1_HG_RESULT_10__SI__VI                   = 0x1664;
constexpr unsigned int mmDC_ABM1_HG_RESULT_11__SI__VI                   = 0x1665;
constexpr unsigned int mmDC_ABM1_HG_RESULT_12__SI__VI                   = 0x1666;
constexpr unsigned int mmDC_ABM1_HG_RESULT_13__SI__VI                   = 0x1667;
constexpr unsigned int mmDC_ABM1_HG_RESULT_14__SI__VI                   = 0x1668;
constexpr unsigned int mmDC_ABM1_HG_RESULT_15__SI__VI                   = 0x1669;
constexpr unsigned int mmDC_ABM1_HG_RESULT_16__SI__VI                   = 0x166A;
constexpr unsigned int mmDC_ABM1_HG_RESULT_17__SI__VI                   = 0x166B;
constexpr unsigned int mmDC_ABM1_HG_RESULT_18__SI__VI                   = 0x166C;
constexpr unsigned int mmDC_ABM1_HG_RESULT_19__SI__VI                   = 0x166D;
constexpr unsigned int mmDC_ABM1_HG_RESULT_1__SI__VI                    = 0x165B;
constexpr unsigned int mmDC_ABM1_HG_RESULT_20__SI__VI                   = 0x166E;
constexpr unsigned int mmDC_ABM1_HG_RESULT_21__SI__VI                   = 0x166F;
constexpr unsigned int mmDC_ABM1_HG_RESULT_22__SI__VI                   = 0x1670;
constexpr unsigned int mmDC_ABM1_HG_RESULT_23__SI__VI                   = 0x1671;
constexpr unsigned int mmDC_ABM1_HG_RESULT_24__SI__VI                   = 0x1672;
constexpr unsigned int mmDC_ABM1_HG_RESULT_2__SI__VI                    = 0x165C;
constexpr unsigned int mmDC_ABM1_HG_RESULT_3__SI__VI                    = 0x165D;
constexpr unsigned int mmDC_ABM1_HG_RESULT_4__SI__VI                    = 0x165E;
constexpr unsigned int mmDC_ABM1_HG_RESULT_5__SI__VI                    = 0x165F;
constexpr unsigned int mmDC_ABM1_HG_RESULT_6__SI__VI                    = 0x1660;
constexpr unsigned int mmDC_ABM1_HG_RESULT_7__SI__VI                    = 0x1661;
constexpr unsigned int mmDC_ABM1_HG_RESULT_8__SI__VI                    = 0x1662;
constexpr unsigned int mmDC_ABM1_HG_RESULT_9__SI__VI                    = 0x1663;
constexpr unsigned int mmDC_ABM1_HG_SAMPLE_RATE__SI__VI                 = 0x1654;
constexpr unsigned int mmDC_ABM1_IPCSC_COEFF_SEL__SI__VI                = 0x1639;
constexpr unsigned int mmDC_ABM1_LS_FILTERED_MIN_MAX_LUMA__SI__VI       = 0x164E;
constexpr unsigned int mmDC_ABM1_LS_MAX_PIXEL_VALUE_COUNT__SI__VI       = 0x1653;
constexpr unsigned int mmDC_ABM1_LS_MIN_MAX_LUMA__SI__VI                = 0x164D;
constexpr unsigned int mmDC_ABM1_LS_MIN_MAX_PIXEL_VALUE_THRES__SI__VI   = 0x1651;
constexpr unsigned int mmDC_ABM1_LS_MIN_PIXEL_VALUE_COUNT__SI__VI       = 0x1652;
constexpr unsigned int mmDC_ABM1_LS_OVR_SCAN_BIN__SI__VI                = 0x1650;
constexpr unsigned int mmDC_ABM1_LS_PIXEL_COUNT__SI__VI                 = 0x164F;
constexpr unsigned int mmDC_ABM1_LS_SAMPLE_RATE__SI__VI                 = 0x1655;
constexpr unsigned int mmDC_ABM1_LS_SUM_OF_LUMA__SI__VI                 = 0x164C;
constexpr unsigned int mmDC_DMCU_SCRATCH__SI__VI                        = 0x1618;
constexpr unsigned int mmDC_GENERICA__SI                                = 0x1900;
constexpr unsigned int mmDC_GENERICB__SI                                = 0x1901;
constexpr unsigned int mmDC_GPIO_DDC1_A__SI                             = 0x190D;
constexpr unsigned int mmDC_GPIO_DDC1_EN__SI                            = 0x190E;
constexpr unsigned int mmDC_GPIO_DDC1_MASK__SI                          = 0x190C;
constexpr unsigned int mmDC_GPIO_DDC1_Y__SI                             = 0x190F;
constexpr unsigned int mmDC_GPIO_DDC2_A__SI                             = 0x1911;
constexpr unsigned int mmDC_GPIO_DDC2_EN__SI                            = 0x1912;
constexpr unsigned int mmDC_GPIO_DDC2_MASK__SI                          = 0x1910;
constexpr unsigned int mmDC_GPIO_DDC2_Y__SI                             = 0x1913;
constexpr unsigned int mmDC_GPIO_DDC3_A__SI                             = 0x1915;
constexpr unsigned int mmDC_GPIO_DDC3_EN__SI                            = 0x1916;
constexpr unsigned int mmDC_GPIO_DDC3_MASK__SI                          = 0x1914;
constexpr unsigned int mmDC_GPIO_DDC3_Y__SI                             = 0x1917;
constexpr unsigned int mmDC_GPIO_DDC4_A__SI                             = 0x1919;
constexpr unsigned int mmDC_GPIO_DDC4_EN__SI                            = 0x191A;
constexpr unsigned int mmDC_GPIO_DDC4_MASK__SI                          = 0x1918;
constexpr unsigned int mmDC_GPIO_DDC4_Y__SI                             = 0x191B;
constexpr unsigned int mmDC_GPIO_DDC5_A__SI                             = 0x191D;
constexpr unsigned int mmDC_GPIO_DDC5_EN__SI                            = 0x191E;
constexpr unsigned int mmDC_GPIO_DDC5_MASK__SI                          = 0x191C;
constexpr unsigned int mmDC_GPIO_DDC5_Y__SI                             = 0x191F;
constexpr unsigned int mmDC_GPIO_DDC6_A__SI                             = 0x1921;
constexpr unsigned int mmDC_GPIO_DDC6_EN__SI                            = 0x1922;
constexpr unsigned int mmDC_GPIO_DDC6_MASK__SI                          = 0x1920;
constexpr unsigned int mmDC_GPIO_DDC6_Y__SI                             = 0x1923;
constexpr unsigned int mmDC_GPIO_DEBUG__SI                              = 0x1946;
constexpr unsigned int mmDC_GPIO_DVODATA_A__SI                          = 0x1909;
constexpr unsigned int mmDC_GPIO_DVODATA_EN__SI                         = 0x190A;
constexpr unsigned int mmDC_GPIO_DVODATA_MASK__SI                       = 0x1908;
constexpr unsigned int mmDC_GPIO_DVODATA_Y__SI                          = 0x190B;
constexpr unsigned int mmDC_GPIO_GENERIC_A__SI                          = 0x1905;
constexpr unsigned int mmDC_GPIO_GENERIC_EN__SI                         = 0x1906;
constexpr unsigned int mmDC_GPIO_GENERIC_MASK__SI                       = 0x1904;
constexpr unsigned int mmDC_GPIO_GENERIC_Y__SI                          = 0x1907;
constexpr unsigned int mmDC_GPIO_HPD_A__SI                              = 0x192D;
constexpr unsigned int mmDC_GPIO_HPD_EN__SI                             = 0x192E;
constexpr unsigned int mmDC_GPIO_HPD_MASK__SI                           = 0x192C;
constexpr unsigned int mmDC_GPIO_HPD_Y__SI                              = 0x192F;
constexpr unsigned int mmDC_GPIO_PAD_STRENGTH_1__SI                     = 0x1944;
constexpr unsigned int mmDC_GPIO_PAD_STRENGTH_2__SI                     = 0x1945;
constexpr unsigned int mmDC_GPIO_PWRSEQ_A__SI                           = 0x1941;
constexpr unsigned int mmDC_GPIO_PWRSEQ_EN__SI                          = 0x1942;
constexpr unsigned int mmDC_GPIO_PWRSEQ_MASK__SI                        = 0x1940;
constexpr unsigned int mmDC_GPIO_PWRSEQ_Y__SI                           = 0x1943;
constexpr unsigned int mmDC_GPIO_SYNCA_A__SI                            = 0x1925;
constexpr unsigned int mmDC_GPIO_SYNCA_EN__SI                           = 0x1926;
constexpr unsigned int mmDC_GPIO_SYNCA_MASK__SI                         = 0x1924;
constexpr unsigned int mmDC_GPIO_SYNCA_Y__SI                            = 0x1927;
constexpr unsigned int mmDC_GPU_TIMER_READ_CNTL__SI                     = 0x1972;
constexpr unsigned int mmDC_GPU_TIMER_READ__SI                          = 0x1971;
constexpr unsigned int mmDC_GPU_TIMER_START_POSITION__SI                = 0x1970;
constexpr unsigned int mmDC_HPD1_CONTROL__SI                            = 0x1809;
constexpr unsigned int mmDC_HPD1_INT_CONTROL__SI                        = 0x1808;
constexpr unsigned int mmDC_HPD1_INT_STATUS__SI                         = 0x1807;
constexpr unsigned int mmDC_HPD2_CONTROL__SI                            = 0x180C;
constexpr unsigned int mmDC_HPD2_INT_CONTROL__SI                        = 0x180B;
constexpr unsigned int mmDC_HPD2_INT_STATUS__SI                         = 0x180A;
constexpr unsigned int mmDC_HPD3_CONTROL__SI                            = 0x180F;
constexpr unsigned int mmDC_HPD3_INT_CONTROL__SI                        = 0x180E;
constexpr unsigned int mmDC_HPD3_INT_STATUS__SI                         = 0x180D;
constexpr unsigned int mmDC_HPD4_CONTROL__SI                            = 0x1812;
constexpr unsigned int mmDC_HPD4_INT_CONTROL__SI                        = 0x1811;
constexpr unsigned int mmDC_HPD4_INT_STATUS__SI                         = 0x1810;
constexpr unsigned int mmDC_HPD5_CONTROL__SI                            = 0x1815;
constexpr unsigned int mmDC_HPD5_INT_CONTROL__SI                        = 0x1814;
constexpr unsigned int mmDC_HPD5_INT_STATUS__SI                         = 0x1813;
constexpr unsigned int mmDC_HPD6_CONTROL__SI                            = 0x1818;
constexpr unsigned int mmDC_HPD6_INT_CONTROL__SI                        = 0x1817;
constexpr unsigned int mmDC_HPD6_INT_STATUS__SI                         = 0x1816;
constexpr unsigned int mmDC_I2C_ARBITRATION__SI                         = 0x181A;
constexpr unsigned int mmDC_I2C_CONTROL__SI                             = 0x1819;
constexpr unsigned int mmDC_I2C_DATA__SI                                = 0x1833;
constexpr unsigned int mmDC_I2C_DDC1_HW_STATUS__SI                      = 0x181D;
constexpr unsigned int mmDC_I2C_DDC1_SETUP__SI                          = 0x1824;
constexpr unsigned int mmDC_I2C_DDC1_SPEED__SI                          = 0x1823;
constexpr unsigned int mmDC_I2C_DDC2_HW_STATUS__SI                      = 0x181E;
constexpr unsigned int mmDC_I2C_DDC2_SETUP__SI                          = 0x1826;
constexpr unsigned int mmDC_I2C_DDC2_SPEED__SI                          = 0x1825;
constexpr unsigned int mmDC_I2C_DDC3_HW_STATUS__SI                      = 0x181F;
constexpr unsigned int mmDC_I2C_DDC3_SETUP__SI                          = 0x1828;
constexpr unsigned int mmDC_I2C_DDC3_SPEED__SI                          = 0x1827;
constexpr unsigned int mmDC_I2C_DDC4_HW_STATUS__SI                      = 0x1820;
constexpr unsigned int mmDC_I2C_DDC4_SETUP__SI                          = 0x182A;
constexpr unsigned int mmDC_I2C_DDC4_SPEED__SI                          = 0x1829;
constexpr unsigned int mmDC_I2C_DDC5_HW_STATUS__SI                      = 0x1821;
constexpr unsigned int mmDC_I2C_DDC5_SETUP__SI                          = 0x182C;
constexpr unsigned int mmDC_I2C_DDC5_SPEED__SI                          = 0x182B;
constexpr unsigned int mmDC_I2C_DDC6_HW_STATUS__SI                      = 0x1822;
constexpr unsigned int mmDC_I2C_DDC6_SETUP__SI                          = 0x182E;
constexpr unsigned int mmDC_I2C_DDC6_SPEED__SI                          = 0x182D;
constexpr unsigned int mmDC_I2C_INTERRUPT_CONTROL__SI                   = 0x181B;
constexpr unsigned int mmDC_I2C_SW_STATUS__SI                           = 0x181C;
constexpr unsigned int mmDC_I2C_TRANSACTION0__SI                        = 0x182F;
constexpr unsigned int mmDC_I2C_TRANSACTION1__SI                        = 0x1830;
constexpr unsigned int mmDC_I2C_TRANSACTION2__SI                        = 0x1831;
constexpr unsigned int mmDC_I2C_TRANSACTION3__SI                        = 0x1832;
constexpr unsigned int mmDC_LUT_30_COLOR__SI__VI                        = 0x1A7C;
constexpr unsigned int mmDC_LUT_AUTOFILL__SI__VI                        = 0x1A7F;
constexpr unsigned int mmDC_LUT_BLACK_OFFSET_BLUE__SI__VI               = 0x1A81;
constexpr unsigned int mmDC_LUT_BLACK_OFFSET_GREEN__SI__VI              = 0x1A82;
constexpr unsigned int mmDC_LUT_BLACK_OFFSET_RED__SI__VI                = 0x1A83;
constexpr unsigned int mmDC_LUT_CONTROL__SI__VI                         = 0x1A80;
constexpr unsigned int mmDC_LUT_PWL_DATA__SI__VI                        = 0x1A7B;
constexpr unsigned int mmDC_LUT_RW_INDEX__SI__VI                        = 0x1A79;
constexpr unsigned int mmDC_LUT_RW_MODE__SI__VI                         = 0x1A78;
constexpr unsigned int mmDC_LUT_SEQ_COLOR__SI__VI                       = 0x1A7A;
constexpr unsigned int mmDC_LUT_WHITE_OFFSET_BLUE__SI__VI               = 0x1A84;
constexpr unsigned int mmDC_LUT_WHITE_OFFSET_GREEN__SI__VI              = 0x1A85;
constexpr unsigned int mmDC_LUT_WHITE_OFFSET_RED__SI__VI                = 0x1A86;
constexpr unsigned int mmDC_LUT_WRITE_EN_MASK__SI__VI                   = 0x1A7E;
constexpr unsigned int mmDC_MVP_LB_CONTROL__SI                          = 0x1ADB;
constexpr unsigned int mmDC_PAD_EXTERN_SIG__SI                          = 0x1902;
constexpr unsigned int mmDC_PINSTRAPS__SI                               = 0x1954;
constexpr unsigned int mmDC_REF_CLK_CNTL__SI                            = 0x1903;
constexpr unsigned int mmDC_TEST_DEBUG_DATA__SI                         = 0x186D;
constexpr unsigned int mmDC_TEST_DEBUG_INDEX__SI                        = 0x186C;
constexpr unsigned int mmDEBUG_DATA                                     = 0x203D;
constexpr unsigned int mmDEBUG_INDEX                                    = 0x203C;
constexpr unsigned int mmDENTIST_DISPCLK_CNTL__SI                       = 0x015F;
constexpr unsigned int mmDESKTOP_HEIGHT__SI                             = 0x1AC1;
constexpr unsigned int mmDIDT_IND_DATA__CI__VI                          = 0x3281;
constexpr unsigned int mmDIDT_IND_INDEX__CI__VI                         = 0x3280;
constexpr unsigned int mmDIG0_AFMT_60958_0__SI                          = 0x1C41;
constexpr unsigned int mmDIG0_AFMT_60958_1__SI                          = 0x1C42;
constexpr unsigned int mmDIG0_AFMT_60958_2__SI                          = 0x1C48;
constexpr unsigned int mmDIG0_AFMT_AUDIO_CRC_CONTROL__SI                = 0x1C43;
constexpr unsigned int mmDIG0_AFMT_AUDIO_CRC_RESULT__SI                 = 0x1C49;
constexpr unsigned int mmDIG0_AFMT_AUDIO_INFO0__SI                      = 0x1C3F;
constexpr unsigned int mmDIG0_AFMT_AUDIO_INFO1__SI                      = 0x1C40;
constexpr unsigned int mmDIG0_AFMT_AUDIO_PACKET_CONTROL2__SI            = 0x1C17;
constexpr unsigned int mmDIG0_AFMT_AUDIO_PACKET_CONTROL__SI             = 0x1C4B;
constexpr unsigned int mmDIG0_AFMT_AVI_INFO0__SI                        = 0x1C21;
constexpr unsigned int mmDIG0_AFMT_AVI_INFO1__SI                        = 0x1C22;
constexpr unsigned int mmDIG0_AFMT_AVI_INFO2__SI                        = 0x1C23;
constexpr unsigned int mmDIG0_AFMT_AVI_INFO3__SI                        = 0x1C24;
constexpr unsigned int mmDIG0_AFMT_INFOFRAME_CONTROL0__SI               = 0x1C4D;
constexpr unsigned int mmDIG0_AFMT_ISRC1_0__SI                          = 0x1C18;
constexpr unsigned int mmDIG0_AFMT_ISRC1_1__SI                          = 0x1C19;
constexpr unsigned int mmDIG0_AFMT_ISRC1_2__SI                          = 0x1C1A;
constexpr unsigned int mmDIG0_AFMT_ISRC1_3__SI                          = 0x1C1B;
constexpr unsigned int mmDIG0_AFMT_ISRC1_4__SI                          = 0x1C1C;
constexpr unsigned int mmDIG0_AFMT_ISRC2_0__SI                          = 0x1C1D;
constexpr unsigned int mmDIG0_AFMT_ISRC2_1__SI                          = 0x1C1E;
constexpr unsigned int mmDIG0_AFMT_ISRC2_2__SI                          = 0x1C1F;
constexpr unsigned int mmDIG0_AFMT_ISRC2_3__SI                          = 0x1C20;
constexpr unsigned int mmDIG0_AFMT_MPEG_INFO0__SI                       = 0x1C25;
constexpr unsigned int mmDIG0_AFMT_MPEG_INFO1__SI                       = 0x1C26;
constexpr unsigned int mmDIG0_AFMT_RAMP_CONTROL0__SI                    = 0x1C44;
constexpr unsigned int mmDIG0_AFMT_RAMP_CONTROL1__SI                    = 0x1C45;
constexpr unsigned int mmDIG0_AFMT_RAMP_CONTROL2__SI                    = 0x1C46;
constexpr unsigned int mmDIG0_AFMT_RAMP_CONTROL3__SI                    = 0x1C47;
constexpr unsigned int mmDIG0_AFMT_STATUS__SI                           = 0x1C4A;
constexpr unsigned int mmDIG0_AFMT_VBI_PACKET_CONTROL__SI               = 0x1C4C;
constexpr unsigned int mmDIG0_DIG_CLOCK_PATTERN__SI                     = 0x1C03;
constexpr unsigned int mmDIG0_DIG_OUTPUT_CRC_CNTL__SI                   = 0x1C01;
constexpr unsigned int mmDIG0_DIG_OUTPUT_CRC_RESULT__SI                 = 0x1C02;
constexpr unsigned int mmDIG0_DIG_RANDOM_PATTERN_SEED__SI               = 0x1C05;
constexpr unsigned int mmDIG0_DIG_TEST_PATTERN__SI                      = 0x1C04;
constexpr unsigned int mmDIG0_HDMI_ACR_32_0__SI                         = 0x1C37;
constexpr unsigned int mmDIG0_HDMI_ACR_32_1__SI                         = 0x1C38;
constexpr unsigned int mmDIG0_HDMI_ACR_44_0__SI                         = 0x1C39;
constexpr unsigned int mmDIG0_HDMI_ACR_44_1__SI                         = 0x1C3A;
constexpr unsigned int mmDIG0_HDMI_ACR_48_0__SI                         = 0x1C3B;
constexpr unsigned int mmDIG0_HDMI_ACR_48_1__SI                         = 0x1C3C;
constexpr unsigned int mmDIG0_HDMI_ACR_PACKET_CONTROL__SI               = 0x1C0F;
constexpr unsigned int mmDIG0_HDMI_ACR_STATUS_0__SI                     = 0x1C3D;
constexpr unsigned int mmDIG0_HDMI_ACR_STATUS_1__SI                     = 0x1C3E;
constexpr unsigned int mmDIG0_HDMI_AUDIO_PACKET_CONTROL__SI             = 0x1C0E;
constexpr unsigned int mmDIG0_HDMI_CONTROL__SI                          = 0x1C0C;
constexpr unsigned int mmDIG0_HDMI_GC__SI                               = 0x1C16;
constexpr unsigned int mmDIG0_HDMI_GENERIC_PACKET_CONTROL__SI           = 0x1C13;
constexpr unsigned int mmDIG0_HDMI_INFOFRAME_CONTROL0__SI               = 0x1C11;
constexpr unsigned int mmDIG0_HDMI_INFOFRAME_CONTROL1__SI               = 0x1C12;
constexpr unsigned int mmDIG0_HDMI_STATUS__SI                           = 0x1C0D;
constexpr unsigned int mmDIG0_HDMI_VBI_PACKET_CONTROL__SI               = 0x1C10;
constexpr unsigned int mmDIG0_LVDS_DATA_CNTL__SI                        = 0x1C8C;
constexpr unsigned int mmDIG0_TMDS_CNTL__SI                             = 0x1C7C;
constexpr unsigned int mmDIG0_TMDS_CONTROL0_FEEDBACK__SI                = 0x1C7E;
constexpr unsigned int mmDIG0_TMDS_CONTROL_CHAR__SI                     = 0x1C7D;
constexpr unsigned int mmDIG0_TMDS_CTL0_1_GEN_CNTL__SI                  = 0x1C86;
constexpr unsigned int mmDIG0_TMDS_CTL2_3_GEN_CNTL__SI                  = 0x1C87;
constexpr unsigned int mmDIG0_TMDS_CTL_BITS__SI                         = 0x1C83;
constexpr unsigned int mmDIG0_TMDS_DCBALANCER_CONTROL__SI               = 0x1C84;
constexpr unsigned int mmDIG0_TMDS_DEBUG__SI                            = 0x1C82;
constexpr unsigned int mmDIG0_TMDS_STEREOSYNC_CTL_SEL__SI               = 0x1C7F;
constexpr unsigned int mmDIG0_TMDS_SYNC_CHAR_PATTERN_0_1__SI            = 0x1C80;
constexpr unsigned int mmDIG0_TMDS_SYNC_CHAR_PATTERN_2_3__SI            = 0x1C81;
constexpr unsigned int mmDIG1_AFMT_60958_0__SI                          = 0x1F41;
constexpr unsigned int mmDIG1_AFMT_60958_1__SI                          = 0x1F42;
constexpr unsigned int mmDIG1_AFMT_60958_2__SI                          = 0x1F48;
constexpr unsigned int mmDIG1_AFMT_AUDIO_CRC_CONTROL__SI                = 0x1F43;
constexpr unsigned int mmDIG1_AFMT_AUDIO_CRC_RESULT__SI                 = 0x1F49;
constexpr unsigned int mmDIG1_AFMT_AUDIO_INFO0__SI                      = 0x1F3F;
constexpr unsigned int mmDIG1_AFMT_AUDIO_INFO1__SI                      = 0x1F40;
constexpr unsigned int mmDIG1_AFMT_AUDIO_PACKET_CONTROL2__SI            = 0x1F17;
constexpr unsigned int mmDIG1_AFMT_AUDIO_PACKET_CONTROL__SI             = 0x1F4B;
constexpr unsigned int mmDIG1_AFMT_AVI_INFO0__SI                        = 0x1F21;
constexpr unsigned int mmDIG1_AFMT_AVI_INFO1__SI                        = 0x1F22;
constexpr unsigned int mmDIG1_AFMT_AVI_INFO2__SI                        = 0x1F23;
constexpr unsigned int mmDIG1_AFMT_AVI_INFO3__SI                        = 0x1F24;
constexpr unsigned int mmDIG1_AFMT_INFOFRAME_CONTROL0__SI               = 0x1F4D;
constexpr unsigned int mmDIG1_AFMT_ISRC1_0__SI                          = 0x1F18;
constexpr unsigned int mmDIG1_AFMT_ISRC1_1__SI                          = 0x1F19;
constexpr unsigned int mmDIG1_AFMT_ISRC1_2__SI                          = 0x1F1A;
constexpr unsigned int mmDIG1_AFMT_ISRC1_3__SI                          = 0x1F1B;
constexpr unsigned int mmDIG1_AFMT_ISRC1_4__SI                          = 0x1F1C;
constexpr unsigned int mmDIG1_AFMT_ISRC2_0__SI                          = 0x1F1D;
constexpr unsigned int mmDIG1_AFMT_ISRC2_1__SI                          = 0x1F1E;
constexpr unsigned int mmDIG1_AFMT_ISRC2_2__SI                          = 0x1F1F;
constexpr unsigned int mmDIG1_AFMT_ISRC2_3__SI                          = 0x1F20;
constexpr unsigned int mmDIG1_AFMT_MPEG_INFO0__SI                       = 0x1F25;
constexpr unsigned int mmDIG1_AFMT_MPEG_INFO1__SI                       = 0x1F26;
constexpr unsigned int mmDIG1_AFMT_RAMP_CONTROL0__SI                    = 0x1F44;
constexpr unsigned int mmDIG1_AFMT_RAMP_CONTROL1__SI                    = 0x1F45;
constexpr unsigned int mmDIG1_AFMT_RAMP_CONTROL2__SI                    = 0x1F46;
constexpr unsigned int mmDIG1_AFMT_RAMP_CONTROL3__SI                    = 0x1F47;
constexpr unsigned int mmDIG1_AFMT_STATUS__SI                           = 0x1F4A;
constexpr unsigned int mmDIG1_AFMT_VBI_PACKET_CONTROL__SI               = 0x1F4C;
constexpr unsigned int mmDIG1_DIG_CLOCK_PATTERN__SI                     = 0x1F03;
constexpr unsigned int mmDIG1_DIG_OUTPUT_CRC_CNTL__SI                   = 0x1F01;
constexpr unsigned int mmDIG1_DIG_OUTPUT_CRC_RESULT__SI                 = 0x1F02;
constexpr unsigned int mmDIG1_DIG_RANDOM_PATTERN_SEED__SI               = 0x1F05;
constexpr unsigned int mmDIG1_DIG_TEST_PATTERN__SI                      = 0x1F04;
constexpr unsigned int mmDIG1_HDMI_ACR_32_0__SI                         = 0x1F37;
constexpr unsigned int mmDIG1_HDMI_ACR_32_1__SI                         = 0x1F38;
constexpr unsigned int mmDIG1_HDMI_ACR_44_0__SI                         = 0x1F39;
constexpr unsigned int mmDIG1_HDMI_ACR_44_1__SI                         = 0x1F3A;
constexpr unsigned int mmDIG1_HDMI_ACR_48_0__SI                         = 0x1F3B;
constexpr unsigned int mmDIG1_HDMI_ACR_48_1__SI                         = 0x1F3C;
constexpr unsigned int mmDIG1_HDMI_ACR_PACKET_CONTROL__SI               = 0x1F0F;
constexpr unsigned int mmDIG1_HDMI_ACR_STATUS_0__SI                     = 0x1F3D;
constexpr unsigned int mmDIG1_HDMI_ACR_STATUS_1__SI                     = 0x1F3E;
constexpr unsigned int mmDIG1_HDMI_AUDIO_PACKET_CONTROL__SI             = 0x1F0E;
constexpr unsigned int mmDIG1_HDMI_CONTROL__SI                          = 0x1F0C;
constexpr unsigned int mmDIG1_HDMI_GC__SI                               = 0x1F16;
constexpr unsigned int mmDIG1_HDMI_GENERIC_PACKET_CONTROL__SI           = 0x1F13;
constexpr unsigned int mmDIG1_HDMI_INFOFRAME_CONTROL0__SI               = 0x1F11;
constexpr unsigned int mmDIG1_HDMI_INFOFRAME_CONTROL1__SI               = 0x1F12;
constexpr unsigned int mmDIG1_HDMI_STATUS__SI                           = 0x1F0D;
constexpr unsigned int mmDIG1_HDMI_VBI_PACKET_CONTROL__SI               = 0x1F10;
constexpr unsigned int mmDIG1_LVDS_DATA_CNTL__SI                        = 0x1F8C;
constexpr unsigned int mmDIG1_TMDS_CNTL__SI                             = 0x1F7C;
constexpr unsigned int mmDIG1_TMDS_CONTROL0_FEEDBACK__SI                = 0x1F7E;
constexpr unsigned int mmDIG1_TMDS_CONTROL_CHAR__SI                     = 0x1F7D;
constexpr unsigned int mmDIG1_TMDS_CTL0_1_GEN_CNTL__SI                  = 0x1F86;
constexpr unsigned int mmDIG1_TMDS_CTL2_3_GEN_CNTL__SI                  = 0x1F87;
constexpr unsigned int mmDIG1_TMDS_CTL_BITS__SI                         = 0x1F83;
constexpr unsigned int mmDIG1_TMDS_DCBALANCER_CONTROL__SI               = 0x1F84;
constexpr unsigned int mmDIG1_TMDS_DEBUG__SI                            = 0x1F82;
constexpr unsigned int mmDIG1_TMDS_STEREOSYNC_CTL_SEL__SI               = 0x1F7F;
constexpr unsigned int mmDIG1_TMDS_SYNC_CHAR_PATTERN_0_1__SI            = 0x1F80;
constexpr unsigned int mmDIG1_TMDS_SYNC_CHAR_PATTERN_2_3__SI            = 0x1F81;
constexpr unsigned int mmDIG2_AFMT_60958_0__SI                          = 0x4241;
constexpr unsigned int mmDIG2_AFMT_60958_1__SI                          = 0x4242;
constexpr unsigned int mmDIG2_AFMT_60958_2__SI                          = 0x4248;
constexpr unsigned int mmDIG2_AFMT_AUDIO_CRC_CONTROL__SI                = 0x4243;
constexpr unsigned int mmDIG2_AFMT_AUDIO_CRC_RESULT__SI                 = 0x4249;
constexpr unsigned int mmDIG2_AFMT_AUDIO_INFO0__SI                      = 0x423F;
constexpr unsigned int mmDIG2_AFMT_AUDIO_INFO1__SI                      = 0x4240;
constexpr unsigned int mmDIG2_AFMT_AUDIO_PACKET_CONTROL2__SI            = 0x4217;
constexpr unsigned int mmDIG2_AFMT_AUDIO_PACKET_CONTROL__SI             = 0x424B;
constexpr unsigned int mmDIG2_AFMT_AVI_INFO0__SI                        = 0x4221;
constexpr unsigned int mmDIG2_AFMT_AVI_INFO1__SI                        = 0x4222;
constexpr unsigned int mmDIG2_AFMT_AVI_INFO2__SI                        = 0x4223;
constexpr unsigned int mmDIG2_AFMT_AVI_INFO3__SI                        = 0x4224;
constexpr unsigned int mmDIG2_AFMT_INFOFRAME_CONTROL0__SI               = 0x424D;
constexpr unsigned int mmDIG2_AFMT_ISRC1_0__SI                          = 0x4218;
constexpr unsigned int mmDIG2_AFMT_ISRC1_1__SI                          = 0x4219;
constexpr unsigned int mmDIG2_AFMT_ISRC1_2__SI                          = 0x421A;
constexpr unsigned int mmDIG2_AFMT_ISRC1_3__SI                          = 0x421B;
constexpr unsigned int mmDIG2_AFMT_ISRC1_4__SI                          = 0x421C;
constexpr unsigned int mmDIG2_AFMT_ISRC2_0__SI                          = 0x421D;
constexpr unsigned int mmDIG2_AFMT_ISRC2_1__SI                          = 0x421E;
constexpr unsigned int mmDIG2_AFMT_ISRC2_2__SI                          = 0x421F;
constexpr unsigned int mmDIG2_AFMT_ISRC2_3__SI                          = 0x4220;
constexpr unsigned int mmDIG2_AFMT_MPEG_INFO0__SI                       = 0x4225;
constexpr unsigned int mmDIG2_AFMT_MPEG_INFO1__SI                       = 0x4226;
constexpr unsigned int mmDIG2_AFMT_RAMP_CONTROL0__SI                    = 0x4244;
constexpr unsigned int mmDIG2_AFMT_RAMP_CONTROL1__SI                    = 0x4245;
constexpr unsigned int mmDIG2_AFMT_RAMP_CONTROL2__SI                    = 0x4246;
constexpr unsigned int mmDIG2_AFMT_RAMP_CONTROL3__SI                    = 0x4247;
constexpr unsigned int mmDIG2_AFMT_STATUS__SI                           = 0x424A;
constexpr unsigned int mmDIG2_AFMT_VBI_PACKET_CONTROL__SI               = 0x424C;
constexpr unsigned int mmDIG2_DIG_CLOCK_PATTERN__SI                     = 0x4203;
constexpr unsigned int mmDIG2_DIG_OUTPUT_CRC_CNTL__SI                   = 0x4201;
constexpr unsigned int mmDIG2_DIG_OUTPUT_CRC_RESULT__SI                 = 0x4202;
constexpr unsigned int mmDIG2_DIG_RANDOM_PATTERN_SEED__SI               = 0x4205;
constexpr unsigned int mmDIG2_DIG_TEST_PATTERN__SI                      = 0x4204;
constexpr unsigned int mmDIG2_HDMI_ACR_32_0__SI                         = 0x4237;
constexpr unsigned int mmDIG2_HDMI_ACR_32_1__SI                         = 0x4238;
constexpr unsigned int mmDIG2_HDMI_ACR_44_0__SI                         = 0x4239;
constexpr unsigned int mmDIG2_HDMI_ACR_44_1__SI                         = 0x423A;
constexpr unsigned int mmDIG2_HDMI_ACR_48_0__SI                         = 0x423B;
constexpr unsigned int mmDIG2_HDMI_ACR_48_1__SI                         = 0x423C;
constexpr unsigned int mmDIG2_HDMI_ACR_PACKET_CONTROL__SI               = 0x420F;
constexpr unsigned int mmDIG2_HDMI_ACR_STATUS_0__SI                     = 0x423D;
constexpr unsigned int mmDIG2_HDMI_ACR_STATUS_1__SI                     = 0x423E;
constexpr unsigned int mmDIG2_HDMI_AUDIO_PACKET_CONTROL__SI             = 0x420E;
constexpr unsigned int mmDIG2_HDMI_CONTROL__SI                          = 0x420C;
constexpr unsigned int mmDIG2_HDMI_GC__SI                               = 0x4216;
constexpr unsigned int mmDIG2_HDMI_GENERIC_PACKET_CONTROL__SI           = 0x4213;
constexpr unsigned int mmDIG2_HDMI_INFOFRAME_CONTROL0__SI               = 0x4211;
constexpr unsigned int mmDIG2_HDMI_INFOFRAME_CONTROL1__SI               = 0x4212;
constexpr unsigned int mmDIG2_HDMI_STATUS__SI                           = 0x420D;
constexpr unsigned int mmDIG2_HDMI_VBI_PACKET_CONTROL__SI               = 0x4210;
constexpr unsigned int mmDIG2_LVDS_DATA_CNTL__SI                        = 0x428C;
constexpr unsigned int mmDIG2_TMDS_CNTL__SI                             = 0x427C;
constexpr unsigned int mmDIG2_TMDS_CONTROL0_FEEDBACK__SI                = 0x427E;
constexpr unsigned int mmDIG2_TMDS_CONTROL_CHAR__SI                     = 0x427D;
constexpr unsigned int mmDIG2_TMDS_CTL0_1_GEN_CNTL__SI                  = 0x4286;
constexpr unsigned int mmDIG2_TMDS_CTL2_3_GEN_CNTL__SI                  = 0x4287;
constexpr unsigned int mmDIG2_TMDS_CTL_BITS__SI                         = 0x4283;
constexpr unsigned int mmDIG2_TMDS_DCBALANCER_CONTROL__SI               = 0x4284;
constexpr unsigned int mmDIG2_TMDS_DEBUG__SI                            = 0x4282;
constexpr unsigned int mmDIG2_TMDS_STEREOSYNC_CTL_SEL__SI               = 0x427F;
constexpr unsigned int mmDIG2_TMDS_SYNC_CHAR_PATTERN_0_1__SI            = 0x4280;
constexpr unsigned int mmDIG2_TMDS_SYNC_CHAR_PATTERN_2_3__SI            = 0x4281;
constexpr unsigned int mmDIG3_AFMT_60958_0__SI                          = 0x4541;
constexpr unsigned int mmDIG3_AFMT_60958_1__SI                          = 0x4542;
constexpr unsigned int mmDIG3_AFMT_60958_2__SI                          = 0x4548;
constexpr unsigned int mmDIG3_AFMT_AUDIO_CRC_CONTROL__SI                = 0x4543;
constexpr unsigned int mmDIG3_AFMT_AUDIO_CRC_RESULT__SI                 = 0x4549;
constexpr unsigned int mmDIG3_AFMT_AUDIO_INFO0__SI                      = 0x453F;
constexpr unsigned int mmDIG3_AFMT_AUDIO_INFO1__SI                      = 0x4540;
constexpr unsigned int mmDIG3_AFMT_AUDIO_PACKET_CONTROL2__SI            = 0x4517;
constexpr unsigned int mmDIG3_AFMT_AUDIO_PACKET_CONTROL__SI             = 0x454B;
constexpr unsigned int mmDIG3_AFMT_AVI_INFO0__SI                        = 0x4521;
constexpr unsigned int mmDIG3_AFMT_AVI_INFO1__SI                        = 0x4522;
constexpr unsigned int mmDIG3_AFMT_AVI_INFO2__SI                        = 0x4523;
constexpr unsigned int mmDIG3_AFMT_AVI_INFO3__SI                        = 0x4524;
constexpr unsigned int mmDIG3_AFMT_INFOFRAME_CONTROL0__SI               = 0x454D;
constexpr unsigned int mmDIG3_AFMT_ISRC1_0__SI                          = 0x4518;
constexpr unsigned int mmDIG3_AFMT_ISRC1_1__SI                          = 0x4519;
constexpr unsigned int mmDIG3_AFMT_ISRC1_2__SI                          = 0x451A;
constexpr unsigned int mmDIG3_AFMT_ISRC1_3__SI                          = 0x451B;
constexpr unsigned int mmDIG3_AFMT_ISRC1_4__SI                          = 0x451C;
constexpr unsigned int mmDIG3_AFMT_ISRC2_0__SI                          = 0x451D;
constexpr unsigned int mmDIG3_AFMT_ISRC2_1__SI                          = 0x451E;
constexpr unsigned int mmDIG3_AFMT_ISRC2_2__SI                          = 0x451F;
constexpr unsigned int mmDIG3_AFMT_ISRC2_3__SI                          = 0x4520;
constexpr unsigned int mmDIG3_AFMT_MPEG_INFO0__SI                       = 0x4525;
constexpr unsigned int mmDIG3_AFMT_MPEG_INFO1__SI                       = 0x4526;
constexpr unsigned int mmDIG3_AFMT_RAMP_CONTROL0__SI                    = 0x4544;
constexpr unsigned int mmDIG3_AFMT_RAMP_CONTROL1__SI                    = 0x4545;
constexpr unsigned int mmDIG3_AFMT_RAMP_CONTROL2__SI                    = 0x4546;
constexpr unsigned int mmDIG3_AFMT_RAMP_CONTROL3__SI                    = 0x4547;
constexpr unsigned int mmDIG3_AFMT_STATUS__SI                           = 0x454A;
constexpr unsigned int mmDIG3_AFMT_VBI_PACKET_CONTROL__SI               = 0x454C;
constexpr unsigned int mmDIG3_DIG_CLOCK_PATTERN__SI                     = 0x4503;
constexpr unsigned int mmDIG3_DIG_OUTPUT_CRC_CNTL__SI                   = 0x4501;
constexpr unsigned int mmDIG3_DIG_OUTPUT_CRC_RESULT__SI                 = 0x4502;
constexpr unsigned int mmDIG3_DIG_RANDOM_PATTERN_SEED__SI               = 0x4505;
constexpr unsigned int mmDIG3_DIG_TEST_PATTERN__SI                      = 0x4504;
constexpr unsigned int mmDIG3_HDMI_ACR_32_0__SI                         = 0x4537;
constexpr unsigned int mmDIG3_HDMI_ACR_32_1__SI                         = 0x4538;
constexpr unsigned int mmDIG3_HDMI_ACR_44_0__SI                         = 0x4539;
constexpr unsigned int mmDIG3_HDMI_ACR_44_1__SI                         = 0x453A;
constexpr unsigned int mmDIG3_HDMI_ACR_48_0__SI                         = 0x453B;
constexpr unsigned int mmDIG3_HDMI_ACR_48_1__SI                         = 0x453C;
constexpr unsigned int mmDIG3_HDMI_ACR_PACKET_CONTROL__SI               = 0x450F;
constexpr unsigned int mmDIG3_HDMI_ACR_STATUS_0__SI                     = 0x453D;
constexpr unsigned int mmDIG3_HDMI_ACR_STATUS_1__SI                     = 0x453E;
constexpr unsigned int mmDIG3_HDMI_AUDIO_PACKET_CONTROL__SI             = 0x450E;
constexpr unsigned int mmDIG3_HDMI_CONTROL__SI                          = 0x450C;
constexpr unsigned int mmDIG3_HDMI_GC__SI                               = 0x4516;
constexpr unsigned int mmDIG3_HDMI_GENERIC_PACKET_CONTROL__SI           = 0x4513;
constexpr unsigned int mmDIG3_HDMI_INFOFRAME_CONTROL0__SI               = 0x4511;
constexpr unsigned int mmDIG3_HDMI_INFOFRAME_CONTROL1__SI               = 0x4512;
constexpr unsigned int mmDIG3_HDMI_STATUS__SI                           = 0x450D;
constexpr unsigned int mmDIG3_HDMI_VBI_PACKET_CONTROL__SI               = 0x4510;
constexpr unsigned int mmDIG3_LVDS_DATA_CNTL__SI                        = 0x458C;
constexpr unsigned int mmDIG3_TMDS_CNTL__SI                             = 0x457C;
constexpr unsigned int mmDIG3_TMDS_CONTROL0_FEEDBACK__SI                = 0x457E;
constexpr unsigned int mmDIG3_TMDS_CONTROL_CHAR__SI                     = 0x457D;
constexpr unsigned int mmDIG3_TMDS_CTL0_1_GEN_CNTL__SI                  = 0x4586;
constexpr unsigned int mmDIG3_TMDS_CTL2_3_GEN_CNTL__SI                  = 0x4587;
constexpr unsigned int mmDIG3_TMDS_CTL_BITS__SI                         = 0x4583;
constexpr unsigned int mmDIG3_TMDS_DCBALANCER_CONTROL__SI               = 0x4584;
constexpr unsigned int mmDIG3_TMDS_DEBUG__SI                            = 0x4582;
constexpr unsigned int mmDIG3_TMDS_STEREOSYNC_CTL_SEL__SI               = 0x457F;
constexpr unsigned int mmDIG3_TMDS_SYNC_CHAR_PATTERN_0_1__SI            = 0x4580;
constexpr unsigned int mmDIG3_TMDS_SYNC_CHAR_PATTERN_2_3__SI            = 0x4581;
constexpr unsigned int mmDIG4_AFMT_60958_0__SI                          = 0x4841;
constexpr unsigned int mmDIG4_AFMT_60958_1__SI                          = 0x4842;
constexpr unsigned int mmDIG4_AFMT_60958_2__SI                          = 0x4848;
constexpr unsigned int mmDIG4_AFMT_AUDIO_CRC_CONTROL__SI                = 0x4843;
constexpr unsigned int mmDIG4_AFMT_AUDIO_CRC_RESULT__SI                 = 0x4849;
constexpr unsigned int mmDIG4_AFMT_AUDIO_INFO0__SI                      = 0x483F;
constexpr unsigned int mmDIG4_AFMT_AUDIO_INFO1__SI                      = 0x4840;
constexpr unsigned int mmDIG4_AFMT_AUDIO_PACKET_CONTROL2__SI            = 0x4817;
constexpr unsigned int mmDIG4_AFMT_AUDIO_PACKET_CONTROL__SI             = 0x484B;
constexpr unsigned int mmDIG4_AFMT_AVI_INFO0__SI                        = 0x4821;
constexpr unsigned int mmDIG4_AFMT_AVI_INFO1__SI                        = 0x4822;
constexpr unsigned int mmDIG4_AFMT_AVI_INFO2__SI                        = 0x4823;
constexpr unsigned int mmDIG4_AFMT_AVI_INFO3__SI                        = 0x4824;
constexpr unsigned int mmDIG4_AFMT_INFOFRAME_CONTROL0__SI               = 0x484D;
constexpr unsigned int mmDIG4_AFMT_ISRC1_0__SI                          = 0x4818;
constexpr unsigned int mmDIG4_AFMT_ISRC1_1__SI                          = 0x4819;
constexpr unsigned int mmDIG4_AFMT_ISRC1_2__SI                          = 0x481A;
constexpr unsigned int mmDIG4_AFMT_ISRC1_3__SI                          = 0x481B;
constexpr unsigned int mmDIG4_AFMT_ISRC1_4__SI                          = 0x481C;
constexpr unsigned int mmDIG4_AFMT_ISRC2_0__SI                          = 0x481D;
constexpr unsigned int mmDIG4_AFMT_ISRC2_1__SI                          = 0x481E;
constexpr unsigned int mmDIG4_AFMT_ISRC2_2__SI                          = 0x481F;
constexpr unsigned int mmDIG4_AFMT_ISRC2_3__SI                          = 0x4820;
constexpr unsigned int mmDIG4_AFMT_MPEG_INFO0__SI                       = 0x4825;
constexpr unsigned int mmDIG4_AFMT_MPEG_INFO1__SI                       = 0x4826;
constexpr unsigned int mmDIG4_AFMT_RAMP_CONTROL0__SI                    = 0x4844;
constexpr unsigned int mmDIG4_AFMT_RAMP_CONTROL1__SI                    = 0x4845;
constexpr unsigned int mmDIG4_AFMT_RAMP_CONTROL2__SI                    = 0x4846;
constexpr unsigned int mmDIG4_AFMT_RAMP_CONTROL3__SI                    = 0x4847;
constexpr unsigned int mmDIG4_AFMT_STATUS__SI                           = 0x484A;
constexpr unsigned int mmDIG4_AFMT_VBI_PACKET_CONTROL__SI               = 0x484C;
constexpr unsigned int mmDIG4_DIG_CLOCK_PATTERN__SI                     = 0x4803;
constexpr unsigned int mmDIG4_DIG_OUTPUT_CRC_CNTL__SI                   = 0x4801;
constexpr unsigned int mmDIG4_DIG_OUTPUT_CRC_RESULT__SI                 = 0x4802;
constexpr unsigned int mmDIG4_DIG_RANDOM_PATTERN_SEED__SI               = 0x4805;
constexpr unsigned int mmDIG4_DIG_TEST_PATTERN__SI                      = 0x4804;
constexpr unsigned int mmDIG4_HDMI_ACR_32_0__SI                         = 0x4837;
constexpr unsigned int mmDIG4_HDMI_ACR_32_1__SI                         = 0x4838;
constexpr unsigned int mmDIG4_HDMI_ACR_44_0__SI                         = 0x4839;
constexpr unsigned int mmDIG4_HDMI_ACR_44_1__SI                         = 0x483A;
constexpr unsigned int mmDIG4_HDMI_ACR_48_0__SI                         = 0x483B;
constexpr unsigned int mmDIG4_HDMI_ACR_48_1__SI                         = 0x483C;
constexpr unsigned int mmDIG4_HDMI_ACR_PACKET_CONTROL__SI               = 0x480F;
constexpr unsigned int mmDIG4_HDMI_ACR_STATUS_0__SI                     = 0x483D;
constexpr unsigned int mmDIG4_HDMI_ACR_STATUS_1__SI                     = 0x483E;
constexpr unsigned int mmDIG4_HDMI_AUDIO_PACKET_CONTROL__SI             = 0x480E;
constexpr unsigned int mmDIG4_HDMI_CONTROL__SI                          = 0x480C;
constexpr unsigned int mmDIG4_HDMI_GC__SI                               = 0x4816;
constexpr unsigned int mmDIG4_HDMI_GENERIC_PACKET_CONTROL__SI           = 0x4813;
constexpr unsigned int mmDIG4_HDMI_INFOFRAME_CONTROL0__SI               = 0x4811;
constexpr unsigned int mmDIG4_HDMI_INFOFRAME_CONTROL1__SI               = 0x4812;
constexpr unsigned int mmDIG4_HDMI_STATUS__SI                           = 0x480D;
constexpr unsigned int mmDIG4_HDMI_VBI_PACKET_CONTROL__SI               = 0x4810;
constexpr unsigned int mmDIG4_LVDS_DATA_CNTL__SI                        = 0x488C;
constexpr unsigned int mmDIG4_TMDS_CNTL__SI                             = 0x487C;
constexpr unsigned int mmDIG4_TMDS_CONTROL0_FEEDBACK__SI                = 0x487E;
constexpr unsigned int mmDIG4_TMDS_CONTROL_CHAR__SI                     = 0x487D;
constexpr unsigned int mmDIG4_TMDS_CTL0_1_GEN_CNTL__SI                  = 0x4886;
constexpr unsigned int mmDIG4_TMDS_CTL2_3_GEN_CNTL__SI                  = 0x4887;
constexpr unsigned int mmDIG4_TMDS_CTL_BITS__SI                         = 0x4883;
constexpr unsigned int mmDIG4_TMDS_DCBALANCER_CONTROL__SI               = 0x4884;
constexpr unsigned int mmDIG4_TMDS_DEBUG__SI                            = 0x4882;
constexpr unsigned int mmDIG4_TMDS_STEREOSYNC_CTL_SEL__SI               = 0x487F;
constexpr unsigned int mmDIG4_TMDS_SYNC_CHAR_PATTERN_0_1__SI            = 0x4880;
constexpr unsigned int mmDIG4_TMDS_SYNC_CHAR_PATTERN_2_3__SI            = 0x4881;
constexpr unsigned int mmDIG5_AFMT_60958_0__SI                          = 0x4B41;
constexpr unsigned int mmDIG5_AFMT_60958_1__SI                          = 0x4B42;
constexpr unsigned int mmDIG5_AFMT_60958_2__SI                          = 0x4B48;
constexpr unsigned int mmDIG5_AFMT_AUDIO_CRC_CONTROL__SI                = 0x4B43;
constexpr unsigned int mmDIG5_AFMT_AUDIO_CRC_RESULT__SI                 = 0x4B49;
constexpr unsigned int mmDIG5_AFMT_AUDIO_INFO0__SI                      = 0x4B3F;
constexpr unsigned int mmDIG5_AFMT_AUDIO_INFO1__SI                      = 0x4B40;
constexpr unsigned int mmDIG5_AFMT_AUDIO_PACKET_CONTROL2__SI            = 0x4B17;
constexpr unsigned int mmDIG5_AFMT_AUDIO_PACKET_CONTROL__SI             = 0x4B4B;
constexpr unsigned int mmDIG5_AFMT_AVI_INFO0__SI                        = 0x4B21;
constexpr unsigned int mmDIG5_AFMT_AVI_INFO1__SI                        = 0x4B22;
constexpr unsigned int mmDIG5_AFMT_AVI_INFO2__SI                        = 0x4B23;
constexpr unsigned int mmDIG5_AFMT_AVI_INFO3__SI                        = 0x4B24;
constexpr unsigned int mmDIG5_AFMT_INFOFRAME_CONTROL0__SI               = 0x4B4D;
constexpr unsigned int mmDIG5_AFMT_ISRC1_0__SI                          = 0x4B18;
constexpr unsigned int mmDIG5_AFMT_ISRC1_1__SI                          = 0x4B19;
constexpr unsigned int mmDIG5_AFMT_ISRC1_2__SI                          = 0x4B1A;
constexpr unsigned int mmDIG5_AFMT_ISRC1_3__SI                          = 0x4B1B;
constexpr unsigned int mmDIG5_AFMT_ISRC1_4__SI                          = 0x4B1C;
constexpr unsigned int mmDIG5_AFMT_ISRC2_0__SI                          = 0x4B1D;
constexpr unsigned int mmDIG5_AFMT_ISRC2_1__SI                          = 0x4B1E;
constexpr unsigned int mmDIG5_AFMT_ISRC2_2__SI                          = 0x4B1F;
constexpr unsigned int mmDIG5_AFMT_ISRC2_3__SI                          = 0x4B20;
constexpr unsigned int mmDIG5_AFMT_MPEG_INFO0__SI                       = 0x4B25;
constexpr unsigned int mmDIG5_AFMT_MPEG_INFO1__SI                       = 0x4B26;
constexpr unsigned int mmDIG5_AFMT_RAMP_CONTROL0__SI                    = 0x4B44;
constexpr unsigned int mmDIG5_AFMT_RAMP_CONTROL1__SI                    = 0x4B45;
constexpr unsigned int mmDIG5_AFMT_RAMP_CONTROL2__SI                    = 0x4B46;
constexpr unsigned int mmDIG5_AFMT_RAMP_CONTROL3__SI                    = 0x4B47;
constexpr unsigned int mmDIG5_AFMT_STATUS__SI                           = 0x4B4A;
constexpr unsigned int mmDIG5_AFMT_VBI_PACKET_CONTROL__SI               = 0x4B4C;
constexpr unsigned int mmDIG5_DIG_CLOCK_PATTERN__SI                     = 0x4B03;
constexpr unsigned int mmDIG5_DIG_OUTPUT_CRC_CNTL__SI                   = 0x4B01;
constexpr unsigned int mmDIG5_DIG_OUTPUT_CRC_RESULT__SI                 = 0x4B02;
constexpr unsigned int mmDIG5_DIG_RANDOM_PATTERN_SEED__SI               = 0x4B05;
constexpr unsigned int mmDIG5_DIG_TEST_PATTERN__SI                      = 0x4B04;
constexpr unsigned int mmDIG5_HDMI_ACR_32_0__SI                         = 0x4B37;
constexpr unsigned int mmDIG5_HDMI_ACR_32_1__SI                         = 0x4B38;
constexpr unsigned int mmDIG5_HDMI_ACR_44_0__SI                         = 0x4B39;
constexpr unsigned int mmDIG5_HDMI_ACR_44_1__SI                         = 0x4B3A;
constexpr unsigned int mmDIG5_HDMI_ACR_48_0__SI                         = 0x4B3B;
constexpr unsigned int mmDIG5_HDMI_ACR_48_1__SI                         = 0x4B3C;
constexpr unsigned int mmDIG5_HDMI_ACR_PACKET_CONTROL__SI               = 0x4B0F;
constexpr unsigned int mmDIG5_HDMI_ACR_STATUS_0__SI                     = 0x4B3D;
constexpr unsigned int mmDIG5_HDMI_ACR_STATUS_1__SI                     = 0x4B3E;
constexpr unsigned int mmDIG5_HDMI_AUDIO_PACKET_CONTROL__SI             = 0x4B0E;
constexpr unsigned int mmDIG5_HDMI_CONTROL__SI                          = 0x4B0C;
constexpr unsigned int mmDIG5_HDMI_GC__SI                               = 0x4B16;
constexpr unsigned int mmDIG5_HDMI_GENERIC_PACKET_CONTROL__SI           = 0x4B13;
constexpr unsigned int mmDIG5_HDMI_INFOFRAME_CONTROL0__SI               = 0x4B11;
constexpr unsigned int mmDIG5_HDMI_INFOFRAME_CONTROL1__SI               = 0x4B12;
constexpr unsigned int mmDIG5_HDMI_STATUS__SI                           = 0x4B0D;
constexpr unsigned int mmDIG5_HDMI_VBI_PACKET_CONTROL__SI               = 0x4B10;
constexpr unsigned int mmDIG5_LVDS_DATA_CNTL__SI                        = 0x4B8C;
constexpr unsigned int mmDIG5_TMDS_CNTL__SI                             = 0x4B7C;
constexpr unsigned int mmDIG5_TMDS_CONTROL0_FEEDBACK__SI                = 0x4B7E;
constexpr unsigned int mmDIG5_TMDS_CONTROL_CHAR__SI                     = 0x4B7D;
constexpr unsigned int mmDIG5_TMDS_CTL0_1_GEN_CNTL__SI                  = 0x4B86;
constexpr unsigned int mmDIG5_TMDS_CTL2_3_GEN_CNTL__SI                  = 0x4B87;
constexpr unsigned int mmDIG5_TMDS_CTL_BITS__SI                         = 0x4B83;
constexpr unsigned int mmDIG5_TMDS_DCBALANCER_CONTROL__SI               = 0x4B84;
constexpr unsigned int mmDIG5_TMDS_DEBUG__SI                            = 0x4B82;
constexpr unsigned int mmDIG5_TMDS_STEREOSYNC_CTL_SEL__SI               = 0x4B7F;
constexpr unsigned int mmDIG5_TMDS_SYNC_CHAR_PATTERN_0_1__SI            = 0x4B80;
constexpr unsigned int mmDIG5_TMDS_SYNC_CHAR_PATTERN_2_3__SI            = 0x4B81;
constexpr unsigned int mmDIG_CLOCK_PATTERN__SI                          = 0x1C03;
constexpr unsigned int mmDIG_OUTPUT_CRC_CNTL__SI                        = 0x1C01;
constexpr unsigned int mmDIG_OUTPUT_CRC_RESULT__SI                      = 0x1C02;
constexpr unsigned int mmDIG_RANDOM_PATTERN_SEED__SI                    = 0x1C05;
constexpr unsigned int mmDIG_TEST_PATTERN__SI                           = 0x1C04;
constexpr unsigned int mmDISPCLK_CGTT_BLK_CTRL_REG__SI                  = 0x0128;
constexpr unsigned int mmDISP_INTERRUPT_STATUS_CONTINUE2__SI            = 0x183F;
constexpr unsigned int mmDISP_INTERRUPT_STATUS_CONTINUE__SI             = 0x183E;
constexpr unsigned int mmDISP_INTERRUPT_STATUS__SI                      = 0x183D;
constexpr unsigned int mmDISP_TIMER_CONTROL__SI                         = 0x1842;
constexpr unsigned int mmDLL_CNTL__SI__CI                               = 0x0AE9;
constexpr unsigned int mmDMCU_CTRL__SI__VI                              = 0x1600;
constexpr unsigned int mmDMCU_ERAM_RD_CTRL__SI__VI                      = 0x160B;
constexpr unsigned int mmDMCU_ERAM_RD_DATA__SI__VI                      = 0x160C;
constexpr unsigned int mmDMCU_ERAM_WR_CTRL__SI__VI                      = 0x1609;
constexpr unsigned int mmDMCU_ERAM_WR_DATA__SI__VI                      = 0x160A;
constexpr unsigned int mmDMCU_EVENT_TRIGGER__SI__VI                     = 0x1611;
constexpr unsigned int mmDMCU_FW_CHECKSUM_SMPL_BYTE_POS__SI__VI         = 0x161A;
constexpr unsigned int mmDMCU_FW_CS_HI__SI__VI                          = 0x1606;
constexpr unsigned int mmDMCU_FW_CS_LO__SI__VI                          = 0x1607;
constexpr unsigned int mmDMCU_FW_END_ADDR__SI__VI                       = 0x1604;
constexpr unsigned int mmDMCU_FW_ISR_START_ADDR__SI__VI                 = 0x1605;
constexpr unsigned int mmDMCU_FW_START_ADDR__SI__VI                     = 0x1603;
constexpr unsigned int mmDMCU_INTERRUPT_STATUS__SI__VI                  = 0x1614;
constexpr unsigned int mmDMCU_INTERRUPT_TO_HOST_EN_MASK__SI__VI         = 0x1615;
constexpr unsigned int mmDMCU_INTERRUPT_TO_UC_EN_MASK__SI__VI           = 0x1616;
constexpr unsigned int mmDMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__SI__VI      = 0x1617;
constexpr unsigned int mmDMCU_INT_CNT__SI__VI                           = 0x1619;
constexpr unsigned int mmDMCU_IRAM_RD_CTRL__SI__VI                      = 0x160F;
constexpr unsigned int mmDMCU_IRAM_RD_DATA__SI__VI                      = 0x1610;
constexpr unsigned int mmDMCU_IRAM_WR_CTRL__SI__VI                      = 0x160D;
constexpr unsigned int mmDMCU_IRAM_WR_DATA__SI__VI                      = 0x160E;
constexpr unsigned int mmDMCU_PC_START_ADDR__SI__VI                     = 0x1602;
constexpr unsigned int mmDMCU_RAM_ACCESS_CTRL__SI__VI                   = 0x1608;
constexpr unsigned int mmDMCU_STATUS__SI__VI                            = 0x1601;
constexpr unsigned int mmDMCU_TEST_DEBUG_DATA__SI__VI                   = 0x1627;
constexpr unsigned int mmDMCU_TEST_DEBUG_INDEX__SI__VI                  = 0x1626;
constexpr unsigned int mmDMCU_UC_INTERNAL_INT_STATUS__SI__VI            = 0x1612;
constexpr unsigned int mmDMIF_ARBITRATION_CONTROL__SI__VI               = 0x02F9;
constexpr unsigned int mmDMIF_CONTROL__SI__VI                           = 0x02F6;
constexpr unsigned int mmDMIF_HW_DEBUG__SI__VI                          = 0x02F8;
constexpr unsigned int mmDMIF_STATUS__SI__VI                            = 0x02F7;
constexpr unsigned int mmDMIF_TEST_DEBUG_DATA__SI                       = 0x0313;
constexpr unsigned int mmDMIF_TEST_DEBUG_INDEX__SI                      = 0x0312;
constexpr unsigned int mmDOUT_POWER_MANAGEMENT_CNTL__SI                 = 0x1841;
constexpr unsigned int mmDOUT_SCRATCH0__SI                              = 0x1844;
constexpr unsigned int mmDOUT_SCRATCH1__SI                              = 0x1845;
constexpr unsigned int mmDOUT_SCRATCH2__SI                              = 0x1846;
constexpr unsigned int mmDOUT_SCRATCH3__SI                              = 0x1847;
constexpr unsigned int mmDOUT_SCRATCH4__SI                              = 0x1848;
constexpr unsigned int mmDOUT_SCRATCH5__SI                              = 0x1849;
constexpr unsigned int mmDOUT_SCRATCH6__SI                              = 0x184A;
constexpr unsigned int mmDOUT_SCRATCH7__SI                              = 0x184B;
constexpr unsigned int mmDOUT_TEST_DEBUG_DATA__SI                       = 0x184E;
constexpr unsigned int mmDOUT_TEST_DEBUG_INDEX__SI                      = 0x184D;
constexpr unsigned int mmDP0_DP_CONFIG__SI                              = 0x1CC2;
constexpr unsigned int mmDP0_DP_DPHY_8B10B_CNTL__SI                     = 0x1CD3;
constexpr unsigned int mmDP0_DP_DPHY_CNTL__SI                           = 0x1CD0;
constexpr unsigned int mmDP0_DP_DPHY_CRC_CNTL__SI                       = 0x1CD7;
constexpr unsigned int mmDP0_DP_DPHY_CRC_EN__SI                         = 0x1CD6;
constexpr unsigned int mmDP0_DP_DPHY_CRC_RESULT__SI                     = 0x1CD8;
constexpr unsigned int mmDP0_DP_DPHY_FAST_TRAINING__SI                  = 0x1CCE;
constexpr unsigned int mmDP0_DP_DPHY_PRBS_CNTL__SI                      = 0x1CD4;
constexpr unsigned int mmDP0_DP_DPHY_SYM__SI                            = 0x1CD2;
constexpr unsigned int mmDP0_DP_DPHY_TRAINING_PATTERN_SEL__SI           = 0x1CD1;
constexpr unsigned int mmDP0_DP_LINK_CNTL__SI                           = 0x1CC0;
constexpr unsigned int mmDP0_DP_PIXEL_FORMAT__SI                        = 0x1CC1;
constexpr unsigned int mmDP0_DP_SEC_AUD_M_READBACK__SI                  = 0x1CA8;
constexpr unsigned int mmDP0_DP_SEC_AUD_M__SI                           = 0x1CA7;
constexpr unsigned int mmDP0_DP_SEC_AUD_N_READBACK__SI                  = 0x1CA6;
constexpr unsigned int mmDP0_DP_SEC_AUD_N__SI                           = 0x1CA5;
constexpr unsigned int mmDP0_DP_SEC_CNTL__SI                            = 0x1CA0;
constexpr unsigned int mmDP0_DP_SEC_FRAMING1__SI                        = 0x1CA1;
constexpr unsigned int mmDP0_DP_SEC_FRAMING2__SI                        = 0x1CA2;
constexpr unsigned int mmDP0_DP_SEC_FRAMING3__SI                        = 0x1CA3;
constexpr unsigned int mmDP0_DP_SEC_FRAMING4__SI                        = 0x1CA4;
constexpr unsigned int mmDP0_DP_SEC_PACKET_CNTL__SI                     = 0x1CAA;
constexpr unsigned int mmDP0_DP_SEC_TIMESTAMP__SI                       = 0x1CA9;
constexpr unsigned int mmDP0_DP_STEER_FIFO__SI                          = 0x1CC4;
constexpr unsigned int mmDP0_DP_TEST_DEBUG_DATA__SI                     = 0x1CFD;
constexpr unsigned int mmDP0_DP_TEST_DEBUG_INDEX__SI                    = 0x1CFC;
constexpr unsigned int mmDP0_DP_VID_INTERRUPT_CNTL__SI                  = 0x1CCF;
constexpr unsigned int mmDP0_DP_VID_MSA_VBID__SI                        = 0x1CCD;
constexpr unsigned int mmDP0_DP_VID_M__SI                               = 0x1CCB;
constexpr unsigned int mmDP0_DP_VID_N__SI                               = 0x1CCA;
constexpr unsigned int mmDP0_DP_VID_STREAM_CNTL__SI                     = 0x1CC3;
constexpr unsigned int mmDP0_DP_VID_TIMING__SI                          = 0x1CC9;
constexpr unsigned int mmDP1_DP_CONFIG__SI                              = 0x1FC2;
constexpr unsigned int mmDP1_DP_DPHY_8B10B_CNTL__SI                     = 0x1FD3;
constexpr unsigned int mmDP1_DP_DPHY_CNTL__SI                           = 0x1FD0;
constexpr unsigned int mmDP1_DP_DPHY_CRC_CNTL__SI                       = 0x1FD7;
constexpr unsigned int mmDP1_DP_DPHY_CRC_EN__SI                         = 0x1FD6;
constexpr unsigned int mmDP1_DP_DPHY_CRC_RESULT__SI                     = 0x1FD8;
constexpr unsigned int mmDP1_DP_DPHY_FAST_TRAINING__SI                  = 0x1FCE;
constexpr unsigned int mmDP1_DP_DPHY_PRBS_CNTL__SI                      = 0x1FD4;
constexpr unsigned int mmDP1_DP_DPHY_SYM__SI                            = 0x1FD2;
constexpr unsigned int mmDP1_DP_DPHY_TRAINING_PATTERN_SEL__SI           = 0x1FD1;
constexpr unsigned int mmDP1_DP_LINK_CNTL__SI                           = 0x1FC0;
constexpr unsigned int mmDP1_DP_PIXEL_FORMAT__SI                        = 0x1FC1;
constexpr unsigned int mmDP1_DP_SEC_AUD_M_READBACK__SI                  = 0x1FA8;
constexpr unsigned int mmDP1_DP_SEC_AUD_M__SI                           = 0x1FA7;
constexpr unsigned int mmDP1_DP_SEC_AUD_N_READBACK__SI                  = 0x1FA6;
constexpr unsigned int mmDP1_DP_SEC_AUD_N__SI                           = 0x1FA5;
constexpr unsigned int mmDP1_DP_SEC_CNTL__SI                            = 0x1FA0;
constexpr unsigned int mmDP1_DP_SEC_FRAMING1__SI                        = 0x1FA1;
constexpr unsigned int mmDP1_DP_SEC_FRAMING2__SI                        = 0x1FA2;
constexpr unsigned int mmDP1_DP_SEC_FRAMING3__SI                        = 0x1FA3;
constexpr unsigned int mmDP1_DP_SEC_FRAMING4__SI                        = 0x1FA4;
constexpr unsigned int mmDP1_DP_SEC_PACKET_CNTL__SI                     = 0x1FAA;
constexpr unsigned int mmDP1_DP_SEC_TIMESTAMP__SI                       = 0x1FA9;
constexpr unsigned int mmDP1_DP_STEER_FIFO__SI                          = 0x1FC4;
constexpr unsigned int mmDP1_DP_TEST_DEBUG_DATA__SI                     = 0x1FFD;
constexpr unsigned int mmDP1_DP_TEST_DEBUG_INDEX__SI                    = 0x1FFC;
constexpr unsigned int mmDP1_DP_VID_INTERRUPT_CNTL__SI                  = 0x1FCF;
constexpr unsigned int mmDP1_DP_VID_MSA_VBID__SI                        = 0x1FCD;
constexpr unsigned int mmDP1_DP_VID_M__SI                               = 0x1FCB;
constexpr unsigned int mmDP1_DP_VID_N__SI                               = 0x1FCA;
constexpr unsigned int mmDP1_DP_VID_STREAM_CNTL__SI                     = 0x1FC3;
constexpr unsigned int mmDP1_DP_VID_TIMING__SI                          = 0x1FC9;
constexpr unsigned int mmDP2_DP_CONFIG__SI                              = 0x42C2;
constexpr unsigned int mmDP2_DP_DPHY_8B10B_CNTL__SI                     = 0x42D3;
constexpr unsigned int mmDP2_DP_DPHY_CNTL__SI                           = 0x42D0;
constexpr unsigned int mmDP2_DP_DPHY_CRC_CNTL__SI                       = 0x42D7;
constexpr unsigned int mmDP2_DP_DPHY_CRC_EN__SI                         = 0x42D6;
constexpr unsigned int mmDP2_DP_DPHY_CRC_RESULT__SI                     = 0x42D8;
constexpr unsigned int mmDP2_DP_DPHY_FAST_TRAINING__SI                  = 0x42CE;
constexpr unsigned int mmDP2_DP_DPHY_PRBS_CNTL__SI                      = 0x42D4;
constexpr unsigned int mmDP2_DP_DPHY_SYM__SI                            = 0x42D2;
constexpr unsigned int mmDP2_DP_DPHY_TRAINING_PATTERN_SEL__SI           = 0x42D1;
constexpr unsigned int mmDP2_DP_LINK_CNTL__SI                           = 0x42C0;
constexpr unsigned int mmDP2_DP_PIXEL_FORMAT__SI                        = 0x42C1;
constexpr unsigned int mmDP2_DP_SEC_AUD_M_READBACK__SI                  = 0x42A8;
constexpr unsigned int mmDP2_DP_SEC_AUD_M__SI                           = 0x42A7;
constexpr unsigned int mmDP2_DP_SEC_AUD_N_READBACK__SI                  = 0x42A6;
constexpr unsigned int mmDP2_DP_SEC_AUD_N__SI                           = 0x42A5;
constexpr unsigned int mmDP2_DP_SEC_CNTL__SI                            = 0x42A0;
constexpr unsigned int mmDP2_DP_SEC_FRAMING1__SI                        = 0x42A1;
constexpr unsigned int mmDP2_DP_SEC_FRAMING2__SI                        = 0x42A2;
constexpr unsigned int mmDP2_DP_SEC_FRAMING3__SI                        = 0x42A3;
constexpr unsigned int mmDP2_DP_SEC_FRAMING4__SI                        = 0x42A4;
constexpr unsigned int mmDP2_DP_SEC_PACKET_CNTL__SI                     = 0x42AA;
constexpr unsigned int mmDP2_DP_SEC_TIMESTAMP__SI                       = 0x42A9;
constexpr unsigned int mmDP2_DP_STEER_FIFO__SI                          = 0x42C4;
constexpr unsigned int mmDP2_DP_TEST_DEBUG_DATA__SI                     = 0x42FD;
constexpr unsigned int mmDP2_DP_TEST_DEBUG_INDEX__SI                    = 0x42FC;
constexpr unsigned int mmDP2_DP_VID_INTERRUPT_CNTL__SI                  = 0x42CF;
constexpr unsigned int mmDP2_DP_VID_MSA_VBID__SI                        = 0x42CD;
constexpr unsigned int mmDP2_DP_VID_M__SI                               = 0x42CB;
constexpr unsigned int mmDP2_DP_VID_N__SI                               = 0x42CA;
constexpr unsigned int mmDP2_DP_VID_STREAM_CNTL__SI                     = 0x42C3;
constexpr unsigned int mmDP2_DP_VID_TIMING__SI                          = 0x42C9;
constexpr unsigned int mmDP3_DP_CONFIG__SI                              = 0x45C2;
constexpr unsigned int mmDP3_DP_DPHY_8B10B_CNTL__SI                     = 0x45D3;
constexpr unsigned int mmDP3_DP_DPHY_CNTL__SI                           = 0x45D0;
constexpr unsigned int mmDP3_DP_DPHY_CRC_CNTL__SI                       = 0x45D7;
constexpr unsigned int mmDP3_DP_DPHY_CRC_EN__SI                         = 0x45D6;
constexpr unsigned int mmDP3_DP_DPHY_CRC_RESULT__SI                     = 0x45D8;
constexpr unsigned int mmDP3_DP_DPHY_FAST_TRAINING__SI                  = 0x45CE;
constexpr unsigned int mmDP3_DP_DPHY_PRBS_CNTL__SI                      = 0x45D4;
constexpr unsigned int mmDP3_DP_DPHY_SYM__SI                            = 0x45D2;
constexpr unsigned int mmDP3_DP_DPHY_TRAINING_PATTERN_SEL__SI           = 0x45D1;
constexpr unsigned int mmDP3_DP_LINK_CNTL__SI                           = 0x45C0;
constexpr unsigned int mmDP3_DP_PIXEL_FORMAT__SI                        = 0x45C1;
constexpr unsigned int mmDP3_DP_SEC_AUD_M_READBACK__SI                  = 0x45A8;
constexpr unsigned int mmDP3_DP_SEC_AUD_M__SI                           = 0x45A7;
constexpr unsigned int mmDP3_DP_SEC_AUD_N_READBACK__SI                  = 0x45A6;
constexpr unsigned int mmDP3_DP_SEC_AUD_N__SI                           = 0x45A5;
constexpr unsigned int mmDP3_DP_SEC_CNTL__SI                            = 0x45A0;
constexpr unsigned int mmDP3_DP_SEC_FRAMING1__SI                        = 0x45A1;
constexpr unsigned int mmDP3_DP_SEC_FRAMING2__SI                        = 0x45A2;
constexpr unsigned int mmDP3_DP_SEC_FRAMING3__SI                        = 0x45A3;
constexpr unsigned int mmDP3_DP_SEC_FRAMING4__SI                        = 0x45A4;
constexpr unsigned int mmDP3_DP_SEC_PACKET_CNTL__SI                     = 0x45AA;
constexpr unsigned int mmDP3_DP_SEC_TIMESTAMP__SI                       = 0x45A9;
constexpr unsigned int mmDP3_DP_STEER_FIFO__SI                          = 0x45C4;
constexpr unsigned int mmDP3_DP_TEST_DEBUG_DATA__SI                     = 0x45FD;
constexpr unsigned int mmDP3_DP_TEST_DEBUG_INDEX__SI                    = 0x45FC;
constexpr unsigned int mmDP3_DP_VID_INTERRUPT_CNTL__SI                  = 0x45CF;
constexpr unsigned int mmDP3_DP_VID_MSA_VBID__SI                        = 0x45CD;
constexpr unsigned int mmDP3_DP_VID_M__SI                               = 0x45CB;
constexpr unsigned int mmDP3_DP_VID_N__SI                               = 0x45CA;
constexpr unsigned int mmDP3_DP_VID_STREAM_CNTL__SI                     = 0x45C3;
constexpr unsigned int mmDP3_DP_VID_TIMING__SI                          = 0x45C9;
constexpr unsigned int mmDP4_DP_CONFIG__SI                              = 0x48C2;
constexpr unsigned int mmDP4_DP_DPHY_8B10B_CNTL__SI                     = 0x48D3;
constexpr unsigned int mmDP4_DP_DPHY_CNTL__SI                           = 0x48D0;
constexpr unsigned int mmDP4_DP_DPHY_CRC_CNTL__SI                       = 0x48D7;
constexpr unsigned int mmDP4_DP_DPHY_CRC_EN__SI                         = 0x48D6;
constexpr unsigned int mmDP4_DP_DPHY_CRC_RESULT__SI                     = 0x48D8;
constexpr unsigned int mmDP4_DP_DPHY_FAST_TRAINING__SI                  = 0x48CE;
constexpr unsigned int mmDP4_DP_DPHY_PRBS_CNTL__SI                      = 0x48D4;
constexpr unsigned int mmDP4_DP_DPHY_SYM__SI                            = 0x48D2;
constexpr unsigned int mmDP4_DP_DPHY_TRAINING_PATTERN_SEL__SI           = 0x48D1;
constexpr unsigned int mmDP4_DP_LINK_CNTL__SI                           = 0x48C0;
constexpr unsigned int mmDP4_DP_PIXEL_FORMAT__SI                        = 0x48C1;
constexpr unsigned int mmDP4_DP_SEC_AUD_M_READBACK__SI                  = 0x48A8;
constexpr unsigned int mmDP4_DP_SEC_AUD_M__SI                           = 0x48A7;
constexpr unsigned int mmDP4_DP_SEC_AUD_N_READBACK__SI                  = 0x48A6;
constexpr unsigned int mmDP4_DP_SEC_AUD_N__SI                           = 0x48A5;
constexpr unsigned int mmDP4_DP_SEC_CNTL__SI                            = 0x48A0;
constexpr unsigned int mmDP4_DP_SEC_FRAMING1__SI                        = 0x48A1;
constexpr unsigned int mmDP4_DP_SEC_FRAMING2__SI                        = 0x48A2;
constexpr unsigned int mmDP4_DP_SEC_FRAMING3__SI                        = 0x48A3;
constexpr unsigned int mmDP4_DP_SEC_FRAMING4__SI                        = 0x48A4;
constexpr unsigned int mmDP4_DP_SEC_PACKET_CNTL__SI                     = 0x48AA;
constexpr unsigned int mmDP4_DP_SEC_TIMESTAMP__SI                       = 0x48A9;
constexpr unsigned int mmDP4_DP_STEER_FIFO__SI                          = 0x48C4;
constexpr unsigned int mmDP4_DP_TEST_DEBUG_DATA__SI                     = 0x48FD;
constexpr unsigned int mmDP4_DP_TEST_DEBUG_INDEX__SI                    = 0x48FC;
constexpr unsigned int mmDP4_DP_VID_INTERRUPT_CNTL__SI                  = 0x48CF;
constexpr unsigned int mmDP4_DP_VID_MSA_VBID__SI                        = 0x48CD;
constexpr unsigned int mmDP4_DP_VID_M__SI                               = 0x48CB;
constexpr unsigned int mmDP4_DP_VID_N__SI                               = 0x48CA;
constexpr unsigned int mmDP4_DP_VID_STREAM_CNTL__SI                     = 0x48C3;
constexpr unsigned int mmDP4_DP_VID_TIMING__SI                          = 0x48C9;
constexpr unsigned int mmDP5_DP_CONFIG__SI                              = 0x4BC2;
constexpr unsigned int mmDP5_DP_DPHY_8B10B_CNTL__SI                     = 0x4BD3;
constexpr unsigned int mmDP5_DP_DPHY_CNTL__SI                           = 0x4BD0;
constexpr unsigned int mmDP5_DP_DPHY_CRC_CNTL__SI                       = 0x4BD7;
constexpr unsigned int mmDP5_DP_DPHY_CRC_EN__SI                         = 0x4BD6;
constexpr unsigned int mmDP5_DP_DPHY_CRC_RESULT__SI                     = 0x4BD8;
constexpr unsigned int mmDP5_DP_DPHY_FAST_TRAINING__SI                  = 0x4BCE;
constexpr unsigned int mmDP5_DP_DPHY_PRBS_CNTL__SI                      = 0x4BD4;
constexpr unsigned int mmDP5_DP_DPHY_SYM__SI                            = 0x4BD2;
constexpr unsigned int mmDP5_DP_DPHY_TRAINING_PATTERN_SEL__SI           = 0x4BD1;
constexpr unsigned int mmDP5_DP_LINK_CNTL__SI                           = 0x4BC0;
constexpr unsigned int mmDP5_DP_PIXEL_FORMAT__SI                        = 0x4BC1;
constexpr unsigned int mmDP5_DP_SEC_AUD_M_READBACK__SI                  = 0x4BA8;
constexpr unsigned int mmDP5_DP_SEC_AUD_M__SI                           = 0x4BA7;
constexpr unsigned int mmDP5_DP_SEC_AUD_N_READBACK__SI                  = 0x4BA6;
constexpr unsigned int mmDP5_DP_SEC_AUD_N__SI                           = 0x4BA5;
constexpr unsigned int mmDP5_DP_SEC_CNTL__SI                            = 0x4BA0;
constexpr unsigned int mmDP5_DP_SEC_FRAMING1__SI                        = 0x4BA1;
constexpr unsigned int mmDP5_DP_SEC_FRAMING2__SI                        = 0x4BA2;
constexpr unsigned int mmDP5_DP_SEC_FRAMING3__SI                        = 0x4BA3;
constexpr unsigned int mmDP5_DP_SEC_FRAMING4__SI                        = 0x4BA4;
constexpr unsigned int mmDP5_DP_SEC_PACKET_CNTL__SI                     = 0x4BAA;
constexpr unsigned int mmDP5_DP_SEC_TIMESTAMP__SI                       = 0x4BA9;
constexpr unsigned int mmDP5_DP_STEER_FIFO__SI                          = 0x4BC4;
constexpr unsigned int mmDP5_DP_TEST_DEBUG_DATA__SI                     = 0x4BFD;
constexpr unsigned int mmDP5_DP_TEST_DEBUG_INDEX__SI                    = 0x4BFC;
constexpr unsigned int mmDP5_DP_VID_INTERRUPT_CNTL__SI                  = 0x4BCF;
constexpr unsigned int mmDP5_DP_VID_MSA_VBID__SI                        = 0x4BCD;
constexpr unsigned int mmDP5_DP_VID_M__SI                               = 0x4BCB;
constexpr unsigned int mmDP5_DP_VID_N__SI                               = 0x4BCA;
constexpr unsigned int mmDP5_DP_VID_STREAM_CNTL__SI                     = 0x4BC3;
constexpr unsigned int mmDP5_DP_VID_TIMING__SI                          = 0x4BC9;
constexpr unsigned int mmDP_AUX0_AUX_ARB_CONTROL__SI                    = 0x1882;
constexpr unsigned int mmDP_AUX0_AUX_CONTROL__SI                        = 0x1880;
constexpr unsigned int mmDP_AUX0_AUX_DPHY_RX_CONTROL0__SI               = 0x188A;
constexpr unsigned int mmDP_AUX0_AUX_DPHY_RX_CONTROL1__SI               = 0x188B;
constexpr unsigned int mmDP_AUX0_AUX_DPHY_RX_STATUS__SI                 = 0x188D;
constexpr unsigned int mmDP_AUX0_AUX_DPHY_TX_CONTROL__SI                = 0x1889;
constexpr unsigned int mmDP_AUX0_AUX_DPHY_TX_REF_CONTROL__SI            = 0x1888;
constexpr unsigned int mmDP_AUX0_AUX_DPHY_TX_STATUS__SI                 = 0x188C;
constexpr unsigned int mmDP_AUX0_AUX_INTERRUPT_CONTROL__SI              = 0x1883;
constexpr unsigned int mmDP_AUX0_AUX_LS_DATA__SI                        = 0x1887;
constexpr unsigned int mmDP_AUX0_AUX_LS_STATUS__SI                      = 0x1885;
constexpr unsigned int mmDP_AUX0_AUX_SW_CONTROL__SI                     = 0x1881;
constexpr unsigned int mmDP_AUX0_AUX_SW_DATA__SI                        = 0x1886;
constexpr unsigned int mmDP_AUX0_AUX_SW_STATUS__SI                      = 0x1884;
constexpr unsigned int mmDP_AUX1_AUX_ARB_CONTROL__SI                    = 0x1896;
constexpr unsigned int mmDP_AUX1_AUX_CONTROL__SI                        = 0x1894;
constexpr unsigned int mmDP_AUX1_AUX_DPHY_RX_CONTROL0__SI               = 0x189E;
constexpr unsigned int mmDP_AUX1_AUX_DPHY_RX_CONTROL1__SI               = 0x189F;
constexpr unsigned int mmDP_AUX1_AUX_DPHY_RX_STATUS__SI                 = 0x18A1;
constexpr unsigned int mmDP_AUX1_AUX_DPHY_TX_CONTROL__SI                = 0x189D;
constexpr unsigned int mmDP_AUX1_AUX_DPHY_TX_REF_CONTROL__SI            = 0x189C;
constexpr unsigned int mmDP_AUX1_AUX_DPHY_TX_STATUS__SI                 = 0x18A0;
constexpr unsigned int mmDP_AUX1_AUX_INTERRUPT_CONTROL__SI              = 0x1897;
constexpr unsigned int mmDP_AUX1_AUX_LS_DATA__SI                        = 0x189B;
constexpr unsigned int mmDP_AUX1_AUX_LS_STATUS__SI                      = 0x1899;
constexpr unsigned int mmDP_AUX1_AUX_SW_CONTROL__SI                     = 0x1895;
constexpr unsigned int mmDP_AUX1_AUX_SW_DATA__SI                        = 0x189A;
constexpr unsigned int mmDP_AUX1_AUX_SW_STATUS__SI                      = 0x1898;
constexpr unsigned int mmDP_AUX2_AUX_ARB_CONTROL__SI                    = 0x18AA;
constexpr unsigned int mmDP_AUX2_AUX_CONTROL__SI                        = 0x18A8;
constexpr unsigned int mmDP_AUX2_AUX_DPHY_RX_CONTROL0__SI               = 0x18B2;
constexpr unsigned int mmDP_AUX2_AUX_DPHY_RX_CONTROL1__SI               = 0x18B3;
constexpr unsigned int mmDP_AUX2_AUX_DPHY_RX_STATUS__SI                 = 0x18B5;
constexpr unsigned int mmDP_AUX2_AUX_DPHY_TX_CONTROL__SI                = 0x18B1;
constexpr unsigned int mmDP_AUX2_AUX_DPHY_TX_REF_CONTROL__SI            = 0x18B0;
constexpr unsigned int mmDP_AUX2_AUX_DPHY_TX_STATUS__SI                 = 0x18B4;
constexpr unsigned int mmDP_AUX2_AUX_INTERRUPT_CONTROL__SI              = 0x18AB;
constexpr unsigned int mmDP_AUX2_AUX_LS_DATA__SI                        = 0x18AF;
constexpr unsigned int mmDP_AUX2_AUX_LS_STATUS__SI                      = 0x18AD;
constexpr unsigned int mmDP_AUX2_AUX_SW_CONTROL__SI                     = 0x18A9;
constexpr unsigned int mmDP_AUX2_AUX_SW_DATA__SI                        = 0x18AE;
constexpr unsigned int mmDP_AUX2_AUX_SW_STATUS__SI                      = 0x18AC;
constexpr unsigned int mmDP_AUX3_AUX_ARB_CONTROL__SI                    = 0x18C2;
constexpr unsigned int mmDP_AUX3_AUX_CONTROL__SI                        = 0x18C0;
constexpr unsigned int mmDP_AUX3_AUX_DPHY_RX_CONTROL0__SI               = 0x18CA;
constexpr unsigned int mmDP_AUX3_AUX_DPHY_RX_CONTROL1__SI               = 0x18CB;
constexpr unsigned int mmDP_AUX3_AUX_DPHY_RX_STATUS__SI                 = 0x18CD;
constexpr unsigned int mmDP_AUX3_AUX_DPHY_TX_CONTROL__SI                = 0x18C9;
constexpr unsigned int mmDP_AUX3_AUX_DPHY_TX_REF_CONTROL__SI            = 0x18C8;
constexpr unsigned int mmDP_AUX3_AUX_DPHY_TX_STATUS__SI                 = 0x18CC;
constexpr unsigned int mmDP_AUX3_AUX_INTERRUPT_CONTROL__SI              = 0x18C3;
constexpr unsigned int mmDP_AUX3_AUX_LS_DATA__SI                        = 0x18C7;
constexpr unsigned int mmDP_AUX3_AUX_LS_STATUS__SI                      = 0x18C5;
constexpr unsigned int mmDP_AUX3_AUX_SW_CONTROL__SI                     = 0x18C1;
constexpr unsigned int mmDP_AUX3_AUX_SW_DATA__SI                        = 0x18C6;
constexpr unsigned int mmDP_AUX3_AUX_SW_STATUS__SI                      = 0x18C4;
constexpr unsigned int mmDP_AUX4_AUX_ARB_CONTROL__SI                    = 0x18D6;
constexpr unsigned int mmDP_AUX4_AUX_CONTROL__SI                        = 0x18D4;
constexpr unsigned int mmDP_AUX4_AUX_DPHY_RX_CONTROL0__SI               = 0x18DE;
constexpr unsigned int mmDP_AUX4_AUX_DPHY_RX_CONTROL1__SI               = 0x18DF;
constexpr unsigned int mmDP_AUX4_AUX_DPHY_RX_STATUS__SI                 = 0x18E1;
constexpr unsigned int mmDP_AUX4_AUX_DPHY_TX_CONTROL__SI                = 0x18DD;
constexpr unsigned int mmDP_AUX4_AUX_DPHY_TX_REF_CONTROL__SI            = 0x18DC;
constexpr unsigned int mmDP_AUX4_AUX_DPHY_TX_STATUS__SI                 = 0x18E0;
constexpr unsigned int mmDP_AUX4_AUX_INTERRUPT_CONTROL__SI              = 0x18D7;
constexpr unsigned int mmDP_AUX4_AUX_LS_DATA__SI                        = 0x18DB;
constexpr unsigned int mmDP_AUX4_AUX_LS_STATUS__SI                      = 0x18D9;
constexpr unsigned int mmDP_AUX4_AUX_SW_CONTROL__SI                     = 0x18D5;
constexpr unsigned int mmDP_AUX4_AUX_SW_DATA__SI                        = 0x18DA;
constexpr unsigned int mmDP_AUX4_AUX_SW_STATUS__SI                      = 0x18D8;
constexpr unsigned int mmDP_AUX5_AUX_ARB_CONTROL__SI                    = 0x18EA;
constexpr unsigned int mmDP_AUX5_AUX_CONTROL__SI                        = 0x18E8;
constexpr unsigned int mmDP_AUX5_AUX_DPHY_RX_CONTROL0__SI               = 0x18F2;
constexpr unsigned int mmDP_AUX5_AUX_DPHY_RX_CONTROL1__SI               = 0x18F3;
constexpr unsigned int mmDP_AUX5_AUX_DPHY_RX_STATUS__SI                 = 0x18F5;
constexpr unsigned int mmDP_AUX5_AUX_DPHY_TX_CONTROL__SI                = 0x18F1;
constexpr unsigned int mmDP_AUX5_AUX_DPHY_TX_REF_CONTROL__SI            = 0x18F0;
constexpr unsigned int mmDP_AUX5_AUX_DPHY_TX_STATUS__SI                 = 0x18F4;
constexpr unsigned int mmDP_AUX5_AUX_INTERRUPT_CONTROL__SI              = 0x18EB;
constexpr unsigned int mmDP_AUX5_AUX_LS_DATA__SI                        = 0x18EF;
constexpr unsigned int mmDP_AUX5_AUX_LS_STATUS__SI                      = 0x18ED;
constexpr unsigned int mmDP_AUX5_AUX_SW_CONTROL__SI                     = 0x18E9;
constexpr unsigned int mmDP_AUX5_AUX_SW_DATA__SI                        = 0x18EE;
constexpr unsigned int mmDP_AUX5_AUX_SW_STATUS__SI                      = 0x18EC;
constexpr unsigned int mmDP_CONFIG__SI                                  = 0x1CC2;
constexpr unsigned int mmDP_DPHY_8B10B_CNTL__SI                         = 0x1CD3;
constexpr unsigned int mmDP_DPHY_CNTL__SI                               = 0x1CD0;
constexpr unsigned int mmDP_DPHY_CRC_CNTL__SI                           = 0x1CD7;
constexpr unsigned int mmDP_DPHY_CRC_EN__SI                             = 0x1CD6;
constexpr unsigned int mmDP_DPHY_CRC_RESULT__SI                         = 0x1CD8;
constexpr unsigned int mmDP_DPHY_FAST_TRAINING__SI                      = 0x1CCE;
constexpr unsigned int mmDP_DPHY_PRBS_CNTL__SI                          = 0x1CD4;
constexpr unsigned int mmDP_DPHY_SYM__SI                                = 0x1CD2;
constexpr unsigned int mmDP_DPHY_TRAINING_PATTERN_SEL__SI               = 0x1CD1;
constexpr unsigned int mmDP_DTO0_MODULO__SI                             = 0x0171;
constexpr unsigned int mmDP_DTO0_PHASE__SI                              = 0x0170;
constexpr unsigned int mmDP_DTO1_MODULO__SI                             = 0x0173;
constexpr unsigned int mmDP_DTO1_PHASE__SI                              = 0x0172;
constexpr unsigned int mmDP_DTO2_MODULO__SI                             = 0x0175;
constexpr unsigned int mmDP_DTO2_PHASE__SI                              = 0x0174;
constexpr unsigned int mmDP_DTO3_MODULO__SI                             = 0x0177;
constexpr unsigned int mmDP_DTO3_PHASE__SI                              = 0x0176;
constexpr unsigned int mmDP_DTO4_MODULO__SI                             = 0x0179;
constexpr unsigned int mmDP_DTO4_PHASE__SI                              = 0x0178;
constexpr unsigned int mmDP_DTO5_MODULO__SI                             = 0x017B;
constexpr unsigned int mmDP_DTO5_PHASE__SI                              = 0x017A;
constexpr unsigned int mmDP_LINK_CNTL__SI                               = 0x1CC0;
constexpr unsigned int mmDP_PIXEL_FORMAT__SI                            = 0x1CC1;
constexpr unsigned int mmDP_SEC_AUD_M_READBACK__SI                      = 0x1CA8;
constexpr unsigned int mmDP_SEC_AUD_M__SI                               = 0x1CA7;
constexpr unsigned int mmDP_SEC_AUD_N_READBACK__SI                      = 0x1CA6;
constexpr unsigned int mmDP_SEC_AUD_N__SI                               = 0x1CA5;
constexpr unsigned int mmDP_SEC_CNTL__SI                                = 0x1CA0;
constexpr unsigned int mmDP_SEC_FRAMING1__SI                            = 0x1CA1;
constexpr unsigned int mmDP_SEC_FRAMING2__SI                            = 0x1CA2;
constexpr unsigned int mmDP_SEC_FRAMING3__SI                            = 0x1CA3;
constexpr unsigned int mmDP_SEC_FRAMING4__SI                            = 0x1CA4;
constexpr unsigned int mmDP_SEC_PACKET_CNTL__SI                         = 0x1CAA;
constexpr unsigned int mmDP_SEC_TIMESTAMP__SI                           = 0x1CA9;
constexpr unsigned int mmDP_STEER_FIFO__SI                              = 0x1CC4;
constexpr unsigned int mmDP_TEST_DEBUG_DATA__SI                         = 0x1CFD;
constexpr unsigned int mmDP_TEST_DEBUG_INDEX__SI                        = 0x1CFC;
constexpr unsigned int mmDP_VID_INTERRUPT_CNTL__SI                      = 0x1CCF;
constexpr unsigned int mmDP_VID_MSA_VBID__SI                            = 0x1CCD;
constexpr unsigned int mmDP_VID_M__SI                                   = 0x1CCB;
constexpr unsigned int mmDP_VID_N__SI                                   = 0x1CCA;
constexpr unsigned int mmDP_VID_STREAM_CNTL__SI                         = 0x1CC3;
constexpr unsigned int mmDP_VID_TIMING__SI                              = 0x1CC9;
constexpr unsigned int mmDVOACLKC_CNTL__SI                              = 0x014E;
constexpr unsigned int mmDVOACLKC_MVP_CNTL__SI                          = 0x014D;
constexpr unsigned int mmDVOACLKD_CNTL__SI                              = 0x014C;
constexpr unsigned int mmDVO_CONTROL__SI                                = 0x185B;
constexpr unsigned int mmDVO_CRC2_SIG_MASK__SI                          = 0x185D;
constexpr unsigned int mmDVO_CRC2_SIG_RESULT__SI                        = 0x185E;
constexpr unsigned int mmDVO_CRC_EN__SI                                 = 0x185C;
constexpr unsigned int mmDVO_ENABLE__SI                                 = 0x1858;
constexpr unsigned int mmDVO_OUTPUT__SI                                 = 0x185A;
constexpr unsigned int mmDVO_SOURCE_SELECT__SI                          = 0x1859;
constexpr unsigned int mmDVO_STRENGTH_CONTROL__SI                       = 0x195D;
constexpr unsigned int mmEXT_OVERSCAN_LEFT_RIGHT__SI__VI                = 0x1B5E;
constexpr unsigned int mmEXT_OVERSCAN_TOP_BOTTOM__SI__VI                = 0x1B5F;
constexpr unsigned int mmFBC_CLIENT_REGION_MASK__SI                     = 0x16EB;
constexpr unsigned int mmFBC_CNTL__SI                                   = 0x16D0;
constexpr unsigned int mmFBC_COMP_CNTL__SI                              = 0x16D4;
constexpr unsigned int mmFBC_COMP_MODE__SI                              = 0x16D5;
constexpr unsigned int mmFBC_CSM_REGION_OFFSET_01__SI                   = 0x16E9;
constexpr unsigned int mmFBC_CSM_REGION_OFFSET_23__SI                   = 0x16EA;
constexpr unsigned int mmFBC_DEBUG0__SI                                 = 0x16D6;
constexpr unsigned int mmFBC_DEBUG1__SI                                 = 0x16D7;
constexpr unsigned int mmFBC_DEBUG2__SI                                 = 0x16D8;
constexpr unsigned int mmFBC_DEBUG_COMP__SI                             = 0x16EC;
constexpr unsigned int mmFBC_DEBUG_CSR_RDATA__SI                        = 0x16EE;
constexpr unsigned int mmFBC_DEBUG_CSR_WDATA__SI                        = 0x16EF;
constexpr unsigned int mmFBC_DEBUG_CSR__SI                              = 0x16ED;
constexpr unsigned int mmFBC_IDLE_FORCE_CLEAR_MASK__SI                  = 0x16D2;
constexpr unsigned int mmFBC_IDLE_MASK__SI                              = 0x16D1;
constexpr unsigned int mmFBC_IND_LUT0__SI                               = 0x16D9;
constexpr unsigned int mmFBC_IND_LUT10__SI                              = 0x16E3;
constexpr unsigned int mmFBC_IND_LUT11__SI                              = 0x16E4;
constexpr unsigned int mmFBC_IND_LUT12__SI                              = 0x16E5;
constexpr unsigned int mmFBC_IND_LUT13__SI                              = 0x16E6;
constexpr unsigned int mmFBC_IND_LUT14__SI                              = 0x16E7;
constexpr unsigned int mmFBC_IND_LUT15__SI                              = 0x16E8;
constexpr unsigned int mmFBC_IND_LUT1__SI                               = 0x16DA;
constexpr unsigned int mmFBC_IND_LUT2__SI                               = 0x16DB;
constexpr unsigned int mmFBC_IND_LUT3__SI                               = 0x16DC;
constexpr unsigned int mmFBC_IND_LUT4__SI                               = 0x16DD;
constexpr unsigned int mmFBC_IND_LUT5__SI                               = 0x16DE;
constexpr unsigned int mmFBC_IND_LUT6__SI                               = 0x16DF;
constexpr unsigned int mmFBC_IND_LUT7__SI                               = 0x16E0;
constexpr unsigned int mmFBC_IND_LUT8__SI                               = 0x16E1;
constexpr unsigned int mmFBC_IND_LUT9__SI                               = 0x16E2;
constexpr unsigned int mmFBC_MISC__SI                                   = 0x16F0;
constexpr unsigned int mmFBC_START_STOP_DELAY__SI                       = 0x16D3;
constexpr unsigned int mmFBC_TEST_DEBUG_DATA__SI                        = 0x16F5;
constexpr unsigned int mmFBC_TEST_DEBUG_INDEX__SI                       = 0x16F4;
constexpr unsigned int mmFMT0_FMT_BIT_DEPTH_CONTROL__SI__VI             = 0x1BF2;
constexpr unsigned int mmFMT0_FMT_CLAMP_CNTL__SI__VI                    = 0x1BF9;
constexpr unsigned int mmFMT0_FMT_CONTROL__SI__VI                       = 0x1BEE;
constexpr unsigned int mmFMT0_FMT_CRC_CNTL__SI__VI                      = 0x1BFA;
constexpr unsigned int mmFMT0_FMT_CRC_SIG_BLUE_CONTROL_MASK__SI__VI     = 0x1BFC;
constexpr unsigned int mmFMT0_FMT_CRC_SIG_BLUE_CONTROL__SI__VI          = 0x1BFE;
constexpr unsigned int mmFMT0_FMT_CRC_SIG_RED_GREEN_MASK__SI__VI        = 0x1BFB;
constexpr unsigned int mmFMT0_FMT_CRC_SIG_RED_GREEN__SI__VI             = 0x1BFD;
constexpr unsigned int mmFMT0_FMT_DEBUG_CNTL__SI__VI                    = 0x1BFF;
constexpr unsigned int mmFMT0_FMT_DITHER_RAND_B_SEED__SI__VI            = 0x1BF5;
constexpr unsigned int mmFMT0_FMT_DITHER_RAND_G_SEED__SI__VI            = 0x1BF4;
constexpr unsigned int mmFMT0_FMT_DITHER_RAND_R_SEED__SI__VI            = 0x1BF3;
constexpr unsigned int mmFMT0_FMT_DYNAMIC_EXP_CNTL__SI__VI              = 0x1BED;
constexpr unsigned int mmFMT0_FMT_FORCE_DATA_0_1__SI__VI                = 0x1BF0;
constexpr unsigned int mmFMT0_FMT_FORCE_DATA_2_3__SI__VI                = 0x1BF1;
constexpr unsigned int mmFMT0_FMT_FORCE_OUTPUT_CNTL__SI__VI             = 0x1BEF;
constexpr unsigned int mmFMT0_FMT_TEMPORAL_DITHER_PATTERN_CONTROL__SI__VI  = 0x1BF6;
constexpr unsigned int mmFMT0_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_S_MATRIX__SI__VI  = 0x1BF7;
constexpr unsigned int mmFMT0_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_T_MATRIX__SI__VI  = 0x1BF8;
constexpr unsigned int mmFMT1_FMT_BIT_DEPTH_CONTROL__SI                 = 0x1EF2;
constexpr unsigned int mmFMT1_FMT_CLAMP_CNTL__SI                        = 0x1EF9;
constexpr unsigned int mmFMT1_FMT_CONTROL__SI                           = 0x1EEE;
constexpr unsigned int mmFMT1_FMT_CRC_CNTL__SI                          = 0x1EFA;
constexpr unsigned int mmFMT1_FMT_CRC_SIG_BLUE_CONTROL_MASK__SI         = 0x1EFC;
constexpr unsigned int mmFMT1_FMT_CRC_SIG_BLUE_CONTROL__SI              = 0x1EFE;
constexpr unsigned int mmFMT1_FMT_CRC_SIG_RED_GREEN_MASK__SI            = 0x1EFB;
constexpr unsigned int mmFMT1_FMT_CRC_SIG_RED_GREEN__SI                 = 0x1EFD;
constexpr unsigned int mmFMT1_FMT_DEBUG_CNTL__SI                        = 0x1EFF;
constexpr unsigned int mmFMT1_FMT_DITHER_RAND_B_SEED__SI                = 0x1EF5;
constexpr unsigned int mmFMT1_FMT_DITHER_RAND_G_SEED__SI                = 0x1EF4;
constexpr unsigned int mmFMT1_FMT_DITHER_RAND_R_SEED__SI                = 0x1EF3;
constexpr unsigned int mmFMT1_FMT_DYNAMIC_EXP_CNTL__SI                  = 0x1EED;
constexpr unsigned int mmFMT1_FMT_FORCE_DATA_0_1__SI                    = 0x1EF0;
constexpr unsigned int mmFMT1_FMT_FORCE_DATA_2_3__SI                    = 0x1EF1;
constexpr unsigned int mmFMT1_FMT_FORCE_OUTPUT_CNTL__SI                 = 0x1EEF;
constexpr unsigned int mmFMT1_FMT_TEMPORAL_DITHER_PATTERN_CONTROL__SI   = 0x1EF6;
constexpr unsigned int mmFMT1_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_S_MATRIX__SI  = 0x1EF7;
constexpr unsigned int mmFMT1_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_T_MATRIX__SI  = 0x1EF8;
constexpr unsigned int mmFMT2_FMT_BIT_DEPTH_CONTROL__SI                 = 0x41F2;
constexpr unsigned int mmFMT2_FMT_CLAMP_CNTL__SI                        = 0x41F9;
constexpr unsigned int mmFMT2_FMT_CONTROL__SI                           = 0x41EE;
constexpr unsigned int mmFMT2_FMT_CRC_CNTL__SI                          = 0x41FA;
constexpr unsigned int mmFMT2_FMT_CRC_SIG_BLUE_CONTROL_MASK__SI         = 0x41FC;
constexpr unsigned int mmFMT2_FMT_CRC_SIG_BLUE_CONTROL__SI              = 0x41FE;
constexpr unsigned int mmFMT2_FMT_CRC_SIG_RED_GREEN_MASK__SI            = 0x41FB;
constexpr unsigned int mmFMT2_FMT_CRC_SIG_RED_GREEN__SI                 = 0x41FD;
constexpr unsigned int mmFMT2_FMT_DEBUG_CNTL__SI                        = 0x41FF;
constexpr unsigned int mmFMT2_FMT_DITHER_RAND_B_SEED__SI                = 0x41F5;
constexpr unsigned int mmFMT2_FMT_DITHER_RAND_G_SEED__SI                = 0x41F4;
constexpr unsigned int mmFMT2_FMT_DITHER_RAND_R_SEED__SI                = 0x41F3;
constexpr unsigned int mmFMT2_FMT_DYNAMIC_EXP_CNTL__SI                  = 0x41ED;
constexpr unsigned int mmFMT2_FMT_FORCE_DATA_0_1__SI                    = 0x41F0;
constexpr unsigned int mmFMT2_FMT_FORCE_DATA_2_3__SI                    = 0x41F1;
constexpr unsigned int mmFMT2_FMT_FORCE_OUTPUT_CNTL__SI                 = 0x41EF;
constexpr unsigned int mmFMT2_FMT_TEMPORAL_DITHER_PATTERN_CONTROL__SI   = 0x41F6;
constexpr unsigned int mmFMT2_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_S_MATRIX__SI  = 0x41F7;
constexpr unsigned int mmFMT2_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_T_MATRIX__SI  = 0x41F8;
constexpr unsigned int mmFMT3_FMT_BIT_DEPTH_CONTROL__SI                 = 0x44F2;
constexpr unsigned int mmFMT3_FMT_CLAMP_CNTL__SI                        = 0x44F9;
constexpr unsigned int mmFMT3_FMT_CONTROL__SI                           = 0x44EE;
constexpr unsigned int mmFMT3_FMT_CRC_CNTL__SI                          = 0x44FA;
constexpr unsigned int mmFMT3_FMT_CRC_SIG_BLUE_CONTROL_MASK__SI         = 0x44FC;
constexpr unsigned int mmFMT3_FMT_CRC_SIG_BLUE_CONTROL__SI              = 0x44FE;
constexpr unsigned int mmFMT3_FMT_CRC_SIG_RED_GREEN_MASK__SI            = 0x44FB;
constexpr unsigned int mmFMT3_FMT_CRC_SIG_RED_GREEN__SI                 = 0x44FD;
constexpr unsigned int mmFMT3_FMT_DEBUG_CNTL__SI                        = 0x44FF;
constexpr unsigned int mmFMT3_FMT_DITHER_RAND_B_SEED__SI                = 0x44F5;
constexpr unsigned int mmFMT3_FMT_DITHER_RAND_G_SEED__SI                = 0x44F4;
constexpr unsigned int mmFMT3_FMT_DITHER_RAND_R_SEED__SI                = 0x44F3;
constexpr unsigned int mmFMT3_FMT_DYNAMIC_EXP_CNTL__SI                  = 0x44ED;
constexpr unsigned int mmFMT3_FMT_FORCE_DATA_0_1__SI                    = 0x44F0;
constexpr unsigned int mmFMT3_FMT_FORCE_DATA_2_3__SI                    = 0x44F1;
constexpr unsigned int mmFMT3_FMT_FORCE_OUTPUT_CNTL__SI                 = 0x44EF;
constexpr unsigned int mmFMT3_FMT_TEMPORAL_DITHER_PATTERN_CONTROL__SI   = 0x44F6;
constexpr unsigned int mmFMT3_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_S_MATRIX__SI  = 0x44F7;
constexpr unsigned int mmFMT3_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_T_MATRIX__SI  = 0x44F8;
constexpr unsigned int mmFMT4_FMT_BIT_DEPTH_CONTROL__SI                 = 0x47F2;
constexpr unsigned int mmFMT4_FMT_CLAMP_CNTL__SI                        = 0x47F9;
constexpr unsigned int mmFMT4_FMT_CONTROL__SI                           = 0x47EE;
constexpr unsigned int mmFMT4_FMT_CRC_CNTL__SI                          = 0x47FA;
constexpr unsigned int mmFMT4_FMT_CRC_SIG_BLUE_CONTROL_MASK__SI         = 0x47FC;
constexpr unsigned int mmFMT4_FMT_CRC_SIG_BLUE_CONTROL__SI              = 0x47FE;
constexpr unsigned int mmFMT4_FMT_CRC_SIG_RED_GREEN_MASK__SI            = 0x47FB;
constexpr unsigned int mmFMT4_FMT_CRC_SIG_RED_GREEN__SI                 = 0x47FD;
constexpr unsigned int mmFMT4_FMT_DEBUG_CNTL__SI                        = 0x47FF;
constexpr unsigned int mmFMT4_FMT_DITHER_RAND_B_SEED__SI                = 0x47F5;
constexpr unsigned int mmFMT4_FMT_DITHER_RAND_G_SEED__SI                = 0x47F4;
constexpr unsigned int mmFMT4_FMT_DITHER_RAND_R_SEED__SI                = 0x47F3;
constexpr unsigned int mmFMT4_FMT_DYNAMIC_EXP_CNTL__SI                  = 0x47ED;
constexpr unsigned int mmFMT4_FMT_FORCE_DATA_0_1__SI                    = 0x47F0;
constexpr unsigned int mmFMT4_FMT_FORCE_DATA_2_3__SI                    = 0x47F1;
constexpr unsigned int mmFMT4_FMT_FORCE_OUTPUT_CNTL__SI                 = 0x47EF;
constexpr unsigned int mmFMT4_FMT_TEMPORAL_DITHER_PATTERN_CONTROL__SI   = 0x47F6;
constexpr unsigned int mmFMT4_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_S_MATRIX__SI  = 0x47F7;
constexpr unsigned int mmFMT4_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_T_MATRIX__SI  = 0x47F8;
constexpr unsigned int mmFMT5_FMT_BIT_DEPTH_CONTROL__SI                 = 0x4AF2;
constexpr unsigned int mmFMT5_FMT_CLAMP_CNTL__SI                        = 0x4AF9;
constexpr unsigned int mmFMT5_FMT_CONTROL__SI                           = 0x4AEE;
constexpr unsigned int mmFMT5_FMT_CRC_CNTL__SI                          = 0x4AFA;
constexpr unsigned int mmFMT5_FMT_CRC_SIG_BLUE_CONTROL_MASK__SI         = 0x4AFC;
constexpr unsigned int mmFMT5_FMT_CRC_SIG_BLUE_CONTROL__SI              = 0x4AFE;
constexpr unsigned int mmFMT5_FMT_CRC_SIG_RED_GREEN_MASK__SI            = 0x4AFB;
constexpr unsigned int mmFMT5_FMT_CRC_SIG_RED_GREEN__SI                 = 0x4AFD;
constexpr unsigned int mmFMT5_FMT_DEBUG_CNTL__SI                        = 0x4AFF;
constexpr unsigned int mmFMT5_FMT_DITHER_RAND_B_SEED__SI                = 0x4AF5;
constexpr unsigned int mmFMT5_FMT_DITHER_RAND_G_SEED__SI                = 0x4AF4;
constexpr unsigned int mmFMT5_FMT_DITHER_RAND_R_SEED__SI                = 0x4AF3;
constexpr unsigned int mmFMT5_FMT_DYNAMIC_EXP_CNTL__SI                  = 0x4AED;
constexpr unsigned int mmFMT5_FMT_FORCE_DATA_0_1__SI                    = 0x4AF0;
constexpr unsigned int mmFMT5_FMT_FORCE_DATA_2_3__SI                    = 0x4AF1;
constexpr unsigned int mmFMT5_FMT_FORCE_OUTPUT_CNTL__SI                 = 0x4AEF;
constexpr unsigned int mmFMT5_FMT_TEMPORAL_DITHER_PATTERN_CONTROL__SI   = 0x4AF6;
constexpr unsigned int mmFMT5_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_S_MATRIX__SI  = 0x4AF7;
constexpr unsigned int mmFMT5_FMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_T_MATRIX__SI  = 0x4AF8;
constexpr unsigned int mmFMT_BIT_DEPTH_CONTROL__SI__VI                  = 0x1BF2;
constexpr unsigned int mmFMT_CLAMP_CNTL__SI__VI                         = 0x1BF9;
constexpr unsigned int mmFMT_CONTROL__SI__VI                            = 0x1BEE;
constexpr unsigned int mmFMT_CRC_CNTL__SI__VI                           = 0x1BFA;
constexpr unsigned int mmFMT_CRC_SIG_BLUE_CONTROL_MASK__SI__VI          = 0x1BFC;
constexpr unsigned int mmFMT_CRC_SIG_BLUE_CONTROL__SI__VI               = 0x1BFE;
constexpr unsigned int mmFMT_CRC_SIG_RED_GREEN_MASK__SI__VI             = 0x1BFB;
constexpr unsigned int mmFMT_CRC_SIG_RED_GREEN__SI__VI                  = 0x1BFD;
constexpr unsigned int mmFMT_DEBUG_CNTL__SI__VI                         = 0x1BFF;
constexpr unsigned int mmFMT_DITHER_RAND_B_SEED__SI__VI                 = 0x1BF5;
constexpr unsigned int mmFMT_DITHER_RAND_G_SEED__SI__VI                 = 0x1BF4;
constexpr unsigned int mmFMT_DITHER_RAND_R_SEED__SI__VI                 = 0x1BF3;
constexpr unsigned int mmFMT_DYNAMIC_EXP_CNTL__SI__VI                   = 0x1BED;
constexpr unsigned int mmFMT_FORCE_DATA_0_1__SI__VI                     = 0x1BF0;
constexpr unsigned int mmFMT_FORCE_DATA_2_3__SI__VI                     = 0x1BF1;
constexpr unsigned int mmFMT_FORCE_OUTPUT_CNTL__SI__VI                  = 0x1BEF;
constexpr unsigned int mmFMT_TEMPORAL_DITHER_PATTERN_CONTROL__SI__VI    = 0x1BF6;
constexpr unsigned int mmFMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_S_MATRIX__SI__VI  = 0x1BF7;
constexpr unsigned int mmFMT_TEMPORAL_DITHER_PROGRAMMABLE_PATTERN_T_MATRIX__SI__VI  = 0x1BF8;
constexpr unsigned int mmGARLIC_FLUSH_ADDR_END_0__CI__VI                = 0x1403;
constexpr unsigned int mmGARLIC_FLUSH_ADDR_END_1__CI__VI                = 0x1405;
constexpr unsigned int mmGARLIC_FLUSH_ADDR_END_2__CI__VI                = 0x1407;
constexpr unsigned int mmGARLIC_FLUSH_ADDR_END_3__CI__VI                = 0x1409;
constexpr unsigned int mmGARLIC_FLUSH_ADDR_END_4__CI__VI                = 0x140B;
constexpr unsigned int mmGARLIC_FLUSH_ADDR_END_5__CI__VI                = 0x140D;
constexpr unsigned int mmGARLIC_FLUSH_ADDR_END_6__CI__VI                = 0x140F;
constexpr unsigned int mmGARLIC_FLUSH_ADDR_END_7__CI__VI                = 0x1411;
constexpr unsigned int mmGARLIC_FLUSH_ADDR_START_0__CI__VI              = 0x1402;
constexpr unsigned int mmGARLIC_FLUSH_ADDR_START_1__CI__VI              = 0x1404;
constexpr unsigned int mmGARLIC_FLUSH_ADDR_START_2__CI__VI              = 0x1406;
constexpr unsigned int mmGARLIC_FLUSH_ADDR_START_3__CI__VI              = 0x1408;
constexpr unsigned int mmGARLIC_FLUSH_ADDR_START_4__CI__VI              = 0x140A;
constexpr unsigned int mmGARLIC_FLUSH_ADDR_START_5__CI__VI              = 0x140C;
constexpr unsigned int mmGARLIC_FLUSH_ADDR_START_6__CI__VI              = 0x140E;
constexpr unsigned int mmGARLIC_FLUSH_ADDR_START_7__CI__VI              = 0x1410;
constexpr unsigned int mmGARLIC_FLUSH_CNTL__CI__VI                      = 0x1401;
constexpr unsigned int mmGARLIC_FLUSH_REQ__CI__VI                       = 0x1412;
constexpr unsigned int mmGB_ADDR_CONFIG                                 = 0x263E;
constexpr unsigned int mmGB_BACKEND_MAP                                 = 0x263F;
constexpr unsigned int mmGB_EDC_MODE                                    = 0x307E;
constexpr unsigned int mmGB_GPU_ID                                      = 0x2640;
constexpr unsigned int mmGB_MACROTILE_MODE0__CI__VI                     = 0x2664;
constexpr unsigned int mmGB_MACROTILE_MODE10__CI__VI                    = 0x266E;
constexpr unsigned int mmGB_MACROTILE_MODE11__CI__VI                    = 0x266F;
constexpr unsigned int mmGB_MACROTILE_MODE12__CI__VI                    = 0x2670;
constexpr unsigned int mmGB_MACROTILE_MODE13__CI__VI                    = 0x2671;
constexpr unsigned int mmGB_MACROTILE_MODE14__CI__VI                    = 0x2672;
constexpr unsigned int mmGB_MACROTILE_MODE15__CI__VI                    = 0x2673;
constexpr unsigned int mmGB_MACROTILE_MODE1__CI__VI                     = 0x2665;
constexpr unsigned int mmGB_MACROTILE_MODE2__CI__VI                     = 0x2666;
constexpr unsigned int mmGB_MACROTILE_MODE3__CI__VI                     = 0x2667;
constexpr unsigned int mmGB_MACROTILE_MODE4__CI__VI                     = 0x2668;
constexpr unsigned int mmGB_MACROTILE_MODE5__CI__VI                     = 0x2669;
constexpr unsigned int mmGB_MACROTILE_MODE6__CI__VI                     = 0x266A;
constexpr unsigned int mmGB_MACROTILE_MODE7__CI__VI                     = 0x266B;
constexpr unsigned int mmGB_MACROTILE_MODE8__CI__VI                     = 0x266C;
constexpr unsigned int mmGB_MACROTILE_MODE9__CI__VI                     = 0x266D;
constexpr unsigned int mmGB_TILE_MODE0                                  = 0x2644;
constexpr unsigned int mmGB_TILE_MODE1                                  = 0x2645;
constexpr unsigned int mmGB_TILE_MODE10                                 = 0x264E;
constexpr unsigned int mmGB_TILE_MODE11                                 = 0x264F;
constexpr unsigned int mmGB_TILE_MODE12                                 = 0x2650;
constexpr unsigned int mmGB_TILE_MODE13                                 = 0x2651;
constexpr unsigned int mmGB_TILE_MODE14                                 = 0x2652;
constexpr unsigned int mmGB_TILE_MODE15                                 = 0x2653;
constexpr unsigned int mmGB_TILE_MODE16                                 = 0x2654;
constexpr unsigned int mmGB_TILE_MODE17                                 = 0x2655;
constexpr unsigned int mmGB_TILE_MODE18                                 = 0x2656;
constexpr unsigned int mmGB_TILE_MODE19                                 = 0x2657;
constexpr unsigned int mmGB_TILE_MODE2                                  = 0x2646;
constexpr unsigned int mmGB_TILE_MODE20                                 = 0x2658;
constexpr unsigned int mmGB_TILE_MODE21                                 = 0x2659;
constexpr unsigned int mmGB_TILE_MODE22                                 = 0x265A;
constexpr unsigned int mmGB_TILE_MODE23                                 = 0x265B;
constexpr unsigned int mmGB_TILE_MODE24                                 = 0x265C;
constexpr unsigned int mmGB_TILE_MODE25                                 = 0x265D;
constexpr unsigned int mmGB_TILE_MODE26                                 = 0x265E;
constexpr unsigned int mmGB_TILE_MODE27                                 = 0x265F;
constexpr unsigned int mmGB_TILE_MODE28                                 = 0x2660;
constexpr unsigned int mmGB_TILE_MODE29                                 = 0x2661;
constexpr unsigned int mmGB_TILE_MODE3                                  = 0x2647;
constexpr unsigned int mmGB_TILE_MODE30                                 = 0x2662;
constexpr unsigned int mmGB_TILE_MODE31                                 = 0x2663;
constexpr unsigned int mmGB_TILE_MODE4                                  = 0x2648;
constexpr unsigned int mmGB_TILE_MODE5                                  = 0x2649;
constexpr unsigned int mmGB_TILE_MODE6                                  = 0x264A;
constexpr unsigned int mmGB_TILE_MODE7                                  = 0x264B;
constexpr unsigned int mmGB_TILE_MODE8                                  = 0x264C;
constexpr unsigned int mmGB_TILE_MODE9                                  = 0x264D;
constexpr unsigned int mmGCK_SMC_IND_DATA__CI__VI                       = 0x0081;
constexpr unsigned int mmGCK_SMC_IND_INDEX__CI__VI                      = 0x0080;
constexpr unsigned int mmGC_USER_PRIM_CONFIG__CI__VI                    = 0x2241;
constexpr unsigned int mmGC_USER_RB_BACKEND_DISABLE                     = 0x26DF;
constexpr unsigned int mmGC_USER_RB_REDUNDANCY__CI__VI                  = 0x26DE;
constexpr unsigned int mmGC_USER_SHADER_ARRAY_CONFIG                    = 0x2270;
constexpr unsigned int mmGC_USER_SYS_RB_BACKEND_DISABLE                 = 0x03A1;
constexpr unsigned int mmGDS_ATOM_BASE__CI__VI                          = 0xC40C;
constexpr unsigned int mmGDS_ATOM_BASE__SI                              = 0x25CE;
constexpr unsigned int mmGDS_ATOM_CNTL__CI__VI                          = 0xC40A;
constexpr unsigned int mmGDS_ATOM_CNTL__SI                              = 0x25CC;
constexpr unsigned int mmGDS_ATOM_COMPLETE__CI__VI                      = 0xC40B;
constexpr unsigned int mmGDS_ATOM_COMPLETE__SI                          = 0x25CD;
constexpr unsigned int mmGDS_ATOM_DST__CI__VI                           = 0xC410;
constexpr unsigned int mmGDS_ATOM_DST__SI                               = 0x25D2;
constexpr unsigned int mmGDS_ATOM_OFFSET0__CI__VI                       = 0xC40E;
constexpr unsigned int mmGDS_ATOM_OFFSET0__SI                           = 0x25D0;
constexpr unsigned int mmGDS_ATOM_OFFSET1__CI__VI                       = 0xC40F;
constexpr unsigned int mmGDS_ATOM_OFFSET1__SI                           = 0x25D1;
constexpr unsigned int mmGDS_ATOM_OP__CI__VI                            = 0xC411;
constexpr unsigned int mmGDS_ATOM_OP__SI                                = 0x25D3;
constexpr unsigned int mmGDS_ATOM_READ0_U__CI__VI                       = 0xC417;
constexpr unsigned int mmGDS_ATOM_READ0_U__SI                           = 0x25D9;
constexpr unsigned int mmGDS_ATOM_READ0__CI__VI                         = 0xC416;
constexpr unsigned int mmGDS_ATOM_READ0__SI                             = 0x25D8;
constexpr unsigned int mmGDS_ATOM_READ1_U__CI__VI                       = 0xC419;
constexpr unsigned int mmGDS_ATOM_READ1_U__SI                           = 0x25DB;
constexpr unsigned int mmGDS_ATOM_READ1__CI__VI                         = 0xC418;
constexpr unsigned int mmGDS_ATOM_READ1__SI                             = 0x25DA;
constexpr unsigned int mmGDS_ATOM_SIZE__CI__VI                          = 0xC40D;
constexpr unsigned int mmGDS_ATOM_SIZE__SI                              = 0x25CF;
constexpr unsigned int mmGDS_ATOM_SRC0_U__CI__VI                        = 0xC413;
constexpr unsigned int mmGDS_ATOM_SRC0_U__SI                            = 0x25D5;
constexpr unsigned int mmGDS_ATOM_SRC0__CI__VI                          = 0xC412;
constexpr unsigned int mmGDS_ATOM_SRC0__SI                              = 0x25D4;
constexpr unsigned int mmGDS_ATOM_SRC1_U__CI__VI                        = 0xC415;
constexpr unsigned int mmGDS_ATOM_SRC1_U__SI                            = 0x25D7;
constexpr unsigned int mmGDS_ATOM_SRC1__CI__VI                          = 0xC414;
constexpr unsigned int mmGDS_ATOM_SRC1__SI                              = 0x25D6;
constexpr unsigned int mmGDS_CNTL_STATUS                                = 0x25C1;
constexpr unsigned int mmGDS_COMPUTE_MAX_WAVE_ID__CI__VI                = 0x3348;
constexpr unsigned int mmGDS_CONFIG                                     = 0x25C0;
constexpr unsigned int mmGDS_DEBUG_CNTL__CI__VI                         = 0x25C8;
constexpr unsigned int mmGDS_DEBUG_CNTL__SI                             = 0x25DE;
constexpr unsigned int mmGDS_DEBUG_DATA__CI__VI                         = 0x25C9;
constexpr unsigned int mmGDS_DEBUG_DATA__SI                             = 0x25DF;
constexpr unsigned int mmGDS_ENHANCE2__CI__VI                           = 0x25C2;
constexpr unsigned int mmGDS_ENHANCE__CI__VI                            = 0x334B;
constexpr unsigned int mmGDS_ENHANCE__SI                                = 0x25DC;
constexpr unsigned int mmGDS_GRBM_SECDED_CNT__CI                        = 0x25C6;
constexpr unsigned int mmGDS_GRBM_SECDED_CNT__SI                        = 0x25E3;
constexpr unsigned int mmGDS_GWS_RESET0__CI__VI                         = 0x3344;
constexpr unsigned int mmGDS_GWS_RESET1__CI__VI                         = 0x3345;
constexpr unsigned int mmGDS_GWS_RESOURCE_CNTL__CI__VI                  = 0xC41A;
constexpr unsigned int mmGDS_GWS_RESOURCE_CNTL__SI                      = 0x25E0;
constexpr unsigned int mmGDS_GWS_RESOURCE_CNT__CI__VI                   = 0xC41C;
constexpr unsigned int mmGDS_GWS_RESOURCE_RESET__CI__VI                 = 0x3346;
constexpr unsigned int mmGDS_GWS_RESOURCE__CI__VI                       = 0xC41B;
constexpr unsigned int mmGDS_GWS_RESOURCE__SI                           = 0x25E1;
constexpr unsigned int mmGDS_GWS_VMID0__CI__VI                          = 0x3320;
constexpr unsigned int mmGDS_GWS_VMID10__CI__VI                         = 0x332A;
constexpr unsigned int mmGDS_GWS_VMID11__CI__VI                         = 0x332B;
constexpr unsigned int mmGDS_GWS_VMID12__CI__VI                         = 0x332C;
constexpr unsigned int mmGDS_GWS_VMID13__CI__VI                         = 0x332D;
constexpr unsigned int mmGDS_GWS_VMID14__CI__VI                         = 0x332E;
constexpr unsigned int mmGDS_GWS_VMID15__CI__VI                         = 0x332F;
constexpr unsigned int mmGDS_GWS_VMID1__CI__VI                          = 0x3321;
constexpr unsigned int mmGDS_GWS_VMID2__CI__VI                          = 0x3322;
constexpr unsigned int mmGDS_GWS_VMID3__CI__VI                          = 0x3323;
constexpr unsigned int mmGDS_GWS_VMID4__CI__VI                          = 0x3324;
constexpr unsigned int mmGDS_GWS_VMID5__CI__VI                          = 0x3325;
constexpr unsigned int mmGDS_GWS_VMID6__CI__VI                          = 0x3326;
constexpr unsigned int mmGDS_GWS_VMID7__CI__VI                          = 0x3327;
constexpr unsigned int mmGDS_GWS_VMID8__CI__VI                          = 0x3328;
constexpr unsigned int mmGDS_GWS_VMID9__CI__VI                          = 0x3329;
constexpr unsigned int mmGDS_OA_ADDRESS__CI__VI                         = 0xC41F;
constexpr unsigned int mmGDS_OA_CGPG_RESTORE__CI__VI                    = 0x334C;
constexpr unsigned int mmGDS_OA_CNTL__CI__VI                            = 0xC41D;
constexpr unsigned int mmGDS_OA_COUNTER__CI__VI                         = 0xC41E;
constexpr unsigned int mmGDS_OA_DED__CI                                 = 0x25C7;
constexpr unsigned int mmGDS_OA_DED__SI                                 = 0x25E4;
constexpr unsigned int mmGDS_OA_INCDEC__CI__VI                          = 0xC420;
constexpr unsigned int mmGDS_OA_RESET_MASK__CI__VI                      = 0x3349;
constexpr unsigned int mmGDS_OA_RESET__CI__VI                           = 0x334A;
constexpr unsigned int mmGDS_OA_RING_SIZE__CI__VI                       = 0xC421;
constexpr unsigned int mmGDS_OA_VMID0__CI__VI                           = 0x3330;
constexpr unsigned int mmGDS_OA_VMID10__CI__VI                          = 0x333A;
constexpr unsigned int mmGDS_OA_VMID11__CI__VI                          = 0x333B;
constexpr unsigned int mmGDS_OA_VMID12__CI__VI                          = 0x333C;
constexpr unsigned int mmGDS_OA_VMID13__CI__VI                          = 0x333D;
constexpr unsigned int mmGDS_OA_VMID14__CI__VI                          = 0x333E;
constexpr unsigned int mmGDS_OA_VMID15__CI__VI                          = 0x333F;
constexpr unsigned int mmGDS_OA_VMID1__CI__VI                           = 0x3331;
constexpr unsigned int mmGDS_OA_VMID2__CI__VI                           = 0x3332;
constexpr unsigned int mmGDS_OA_VMID3__CI__VI                           = 0x3333;
constexpr unsigned int mmGDS_OA_VMID4__CI__VI                           = 0x3334;
constexpr unsigned int mmGDS_OA_VMID5__CI__VI                           = 0x3335;
constexpr unsigned int mmGDS_OA_VMID6__CI__VI                           = 0x3336;
constexpr unsigned int mmGDS_OA_VMID7__CI__VI                           = 0x3337;
constexpr unsigned int mmGDS_OA_VMID8__CI__VI                           = 0x3338;
constexpr unsigned int mmGDS_OA_VMID9__CI__VI                           = 0x3339;
constexpr unsigned int mmGDS_PERFCOUNTER0_HI__CI__VI                    = 0xD281;
constexpr unsigned int mmGDS_PERFCOUNTER0_HI__SI                        = 0x25E7;
constexpr unsigned int mmGDS_PERFCOUNTER0_LO__CI__VI                    = 0xD280;
constexpr unsigned int mmGDS_PERFCOUNTER0_LO__SI                        = 0x25E6;
constexpr unsigned int mmGDS_PERFCOUNTER0_SELECT1__CI__VI               = 0xDA84;
constexpr unsigned int mmGDS_PERFCOUNTER0_SELECT__CI__VI                = 0xDA80;
constexpr unsigned int mmGDS_PERFCOUNTER0_SELECT__SI                    = 0x25E5;
constexpr unsigned int mmGDS_PERFCOUNTER1_HI__CI__VI                    = 0xD283;
constexpr unsigned int mmGDS_PERFCOUNTER1_HI__SI                        = 0x25EA;
constexpr unsigned int mmGDS_PERFCOUNTER1_LO__CI__VI                    = 0xD282;
constexpr unsigned int mmGDS_PERFCOUNTER1_LO__SI                        = 0x25E9;
constexpr unsigned int mmGDS_PERFCOUNTER1_SELECT__CI__VI                = 0xDA81;
constexpr unsigned int mmGDS_PERFCOUNTER1_SELECT__SI                    = 0x25E8;
constexpr unsigned int mmGDS_PERFCOUNTER2_HI__CI__VI                    = 0xD285;
constexpr unsigned int mmGDS_PERFCOUNTER2_HI__SI                        = 0x25ED;
constexpr unsigned int mmGDS_PERFCOUNTER2_LO__CI__VI                    = 0xD284;
constexpr unsigned int mmGDS_PERFCOUNTER2_LO__SI                        = 0x25EC;
constexpr unsigned int mmGDS_PERFCOUNTER2_SELECT__CI__VI                = 0xDA82;
constexpr unsigned int mmGDS_PERFCOUNTER2_SELECT__SI                    = 0x25EB;
constexpr unsigned int mmGDS_PERFCOUNTER3_HI__CI__VI                    = 0xD287;
constexpr unsigned int mmGDS_PERFCOUNTER3_HI__SI                        = 0x25F0;
constexpr unsigned int mmGDS_PERFCOUNTER3_LO__CI__VI                    = 0xD286;
constexpr unsigned int mmGDS_PERFCOUNTER3_LO__SI                        = 0x25EF;
constexpr unsigned int mmGDS_PERFCOUNTER3_SELECT__CI__VI                = 0xDA83;
constexpr unsigned int mmGDS_PERFCOUNTER3_SELECT__SI                    = 0x25EE;
constexpr unsigned int mmGDS_PROTECTION_FAULT__CI__VI                   = 0x25C3;
constexpr unsigned int mmGDS_RD_ADDR__CI__VI                            = 0xC400;
constexpr unsigned int mmGDS_RD_ADDR__SI                                = 0x25C2;
constexpr unsigned int mmGDS_RD_BURST_ADDR__CI__VI                      = 0xC402;
constexpr unsigned int mmGDS_RD_BURST_ADDR__SI                          = 0x25C4;
constexpr unsigned int mmGDS_RD_BURST_COUNT__CI__VI                     = 0xC403;
constexpr unsigned int mmGDS_RD_BURST_COUNT__SI                         = 0x25C5;
constexpr unsigned int mmGDS_RD_BURST_DATA__CI__VI                      = 0xC404;
constexpr unsigned int mmGDS_RD_BURST_DATA__SI                          = 0x25C6;
constexpr unsigned int mmGDS_RD_DATA__CI__VI                            = 0xC401;
constexpr unsigned int mmGDS_RD_DATA__SI                                = 0x25C3;
constexpr unsigned int mmGDS_SECDED_CNT__CI                             = 0x25C5;
constexpr unsigned int mmGDS_SECDED_CNT__SI                             = 0x25E2;
constexpr unsigned int mmGDS_VMID0_BASE__CI__VI                         = 0x3300;
constexpr unsigned int mmGDS_VMID0_SIZE__CI__VI                         = 0x3301;
constexpr unsigned int mmGDS_VMID10_BASE__CI__VI                        = 0x3314;
constexpr unsigned int mmGDS_VMID10_SIZE__CI__VI                        = 0x3315;
constexpr unsigned int mmGDS_VMID11_BASE__CI__VI                        = 0x3316;
constexpr unsigned int mmGDS_VMID11_SIZE__CI__VI                        = 0x3317;
constexpr unsigned int mmGDS_VMID12_BASE__CI__VI                        = 0x3318;
constexpr unsigned int mmGDS_VMID12_SIZE__CI__VI                        = 0x3319;
constexpr unsigned int mmGDS_VMID13_BASE__CI__VI                        = 0x331A;
constexpr unsigned int mmGDS_VMID13_SIZE__CI__VI                        = 0x331B;
constexpr unsigned int mmGDS_VMID14_BASE__CI__VI                        = 0x331C;
constexpr unsigned int mmGDS_VMID14_SIZE__CI__VI                        = 0x331D;
constexpr unsigned int mmGDS_VMID15_BASE__CI__VI                        = 0x331E;
constexpr unsigned int mmGDS_VMID15_SIZE__CI__VI                        = 0x331F;
constexpr unsigned int mmGDS_VMID1_BASE__CI__VI                         = 0x3302;
constexpr unsigned int mmGDS_VMID1_SIZE__CI__VI                         = 0x3303;
constexpr unsigned int mmGDS_VMID2_BASE__CI__VI                         = 0x3304;
constexpr unsigned int mmGDS_VMID2_SIZE__CI__VI                         = 0x3305;
constexpr unsigned int mmGDS_VMID3_BASE__CI__VI                         = 0x3306;
constexpr unsigned int mmGDS_VMID3_SIZE__CI__VI                         = 0x3307;
constexpr unsigned int mmGDS_VMID4_BASE__CI__VI                         = 0x3308;
constexpr unsigned int mmGDS_VMID4_SIZE__CI__VI                         = 0x3309;
constexpr unsigned int mmGDS_VMID5_BASE__CI__VI                         = 0x330A;
constexpr unsigned int mmGDS_VMID5_SIZE__CI__VI                         = 0x330B;
constexpr unsigned int mmGDS_VMID6_BASE__CI__VI                         = 0x330C;
constexpr unsigned int mmGDS_VMID6_SIZE__CI__VI                         = 0x330D;
constexpr unsigned int mmGDS_VMID7_BASE__CI__VI                         = 0x330E;
constexpr unsigned int mmGDS_VMID7_SIZE__CI__VI                         = 0x330F;
constexpr unsigned int mmGDS_VMID8_BASE__CI__VI                         = 0x3310;
constexpr unsigned int mmGDS_VMID8_SIZE__CI__VI                         = 0x3311;
constexpr unsigned int mmGDS_VMID9_BASE__CI__VI                         = 0x3312;
constexpr unsigned int mmGDS_VMID9_SIZE__CI__VI                         = 0x3313;
constexpr unsigned int mmGDS_VM_PROTECTION_FAULT__CI__VI                = 0x25C4;
constexpr unsigned int mmGDS_WRITE_COMPLETE__CI__VI                     = 0xC409;
constexpr unsigned int mmGDS_WRITE_COMPLETE__SI                         = 0x25CB;
constexpr unsigned int mmGDS_WR_ADDR__CI__VI                            = 0xC405;
constexpr unsigned int mmGDS_WR_ADDR__SI                                = 0x25C7;
constexpr unsigned int mmGDS_WR_BURST_ADDR__CI__VI                      = 0xC407;
constexpr unsigned int mmGDS_WR_BURST_ADDR__SI                          = 0x25C9;
constexpr unsigned int mmGDS_WR_BURST_DATA__CI__VI                      = 0xC408;
constexpr unsigned int mmGDS_WR_BURST_DATA__SI                          = 0x25CA;
constexpr unsigned int mmGDS_WR_DATA__CI__VI                            = 0xC406;
constexpr unsigned int mmGDS_WR_DATA__SI                                = 0x25C8;
constexpr unsigned int mmGENENB__SI__VI                                 = 0x00F0;
constexpr unsigned int mmGENERAL_PWRMGT__SI                             = 0x01E0;
constexpr unsigned int mmGENERIC_I2C_CONTROL__SI                        = 0x1834;
constexpr unsigned int mmGENERIC_I2C_DATA__SI                           = 0x183A;
constexpr unsigned int mmGENERIC_I2C_INTERRUPT_CONTROL__SI              = 0x1835;
constexpr unsigned int mmGENERIC_I2C_PIN_DEBUG__SI                      = 0x183C;
constexpr unsigned int mmGENERIC_I2C_PIN_SELECTION__SI                  = 0x183B;
constexpr unsigned int mmGENERIC_I2C_SETUP__SI                          = 0x1838;
constexpr unsigned int mmGENERIC_I2C_SPEED__SI                          = 0x1837;
constexpr unsigned int mmGENERIC_I2C_STATUS__SI                         = 0x1836;
constexpr unsigned int mmGENERIC_I2C_TRANSACTION__SI                    = 0x1839;
constexpr unsigned int mmGENFC_RD__SI__VI                               = 0x00F2;
constexpr unsigned int mmGENFC_WT__SI__VI                               = 0x00EE;
constexpr unsigned int mmGENMO_RD__SI__VI                               = 0x00F3;
constexpr unsigned int mmGENMO_WT__SI__VI                               = 0x00F0;
constexpr unsigned int mmGENS0__SI__VI                                  = 0x00F0;
constexpr unsigned int mmGENS1__SI__VI                                  = 0x00EE;
constexpr unsigned int mmGFX_COPY_STATE                                 = 0xA1F4;
constexpr unsigned int mmGFX_PIPE_CONTROL__CI__VI                       = 0x226D;
constexpr unsigned int mmGFX_PIPE_PRIORITY__CI__VI                      = 0xF87F;
constexpr unsigned int mmGMCON_DEBUG__CI__VI                            = 0x0D5F;
constexpr unsigned int mmGMCON_MASK__CI__VI                             = 0x0D52;
constexpr unsigned int mmGMCON_MISC2__CI__VI                            = 0x0D44;
constexpr unsigned int mmGMCON_MISC3__CI__VI                            = 0x0D51;
constexpr unsigned int mmGMCON_MISC__CI__VI                             = 0x0D43;
constexpr unsigned int mmGMCON_PERF_MON_CNTL0__CI__VI                   = 0x0D4A;
constexpr unsigned int mmGMCON_PERF_MON_CNTL1__CI__VI                   = 0x0D4B;
constexpr unsigned int mmGMCON_PERF_MON_RSLT0__CI__VI                   = 0x0D4C;
constexpr unsigned int mmGMCON_PERF_MON_RSLT1__CI__VI                   = 0x0D4D;
constexpr unsigned int mmGMCON_PGFSM_CONFIG__CI__VI                     = 0x0D4E;
constexpr unsigned int mmGMCON_PGFSM_READ__CI__VI                       = 0x0D50;
constexpr unsigned int mmGMCON_PGFSM_WRITE__CI__VI                      = 0x0D4F;
constexpr unsigned int mmGMCON_RENG_EXECUTE__CI__VI                     = 0x0D42;
constexpr unsigned int mmGMCON_RENG_RAM_DATA__CI__VI                    = 0x0D41;
constexpr unsigned int mmGMCON_RENG_RAM_INDEX__CI__VI                   = 0x0D40;
constexpr unsigned int mmGMCON_STCTRL_REGISTER_SAVE_EXCL_SET0__CI__VI   = 0x0D48;
constexpr unsigned int mmGMCON_STCTRL_REGISTER_SAVE_EXCL_SET1__CI__VI   = 0x0D49;
constexpr unsigned int mmGMCON_STCTRL_REGISTER_SAVE_RANGE0__CI__VI      = 0x0D45;
constexpr unsigned int mmGMCON_STCTRL_REGISTER_SAVE_RANGE1__CI__VI      = 0x0D46;
constexpr unsigned int mmGMCON_STCTRL_REGISTER_SAVE_RANGE2__CI__VI      = 0x0D47;
constexpr unsigned int mmGPIOPAD_A__CI__VI                              = 0x0183;
constexpr unsigned int mmGPIOPAD_A__SI                                  = 0x05E7;
constexpr unsigned int mmGPIOPAD_EN__CI__VI                             = 0x0184;
constexpr unsigned int mmGPIOPAD_EN__SI                                 = 0x05E8;
constexpr unsigned int mmGPIOPAD_EXTERN_TRIG_CNTL__CI__VI               = 0x018D;
constexpr unsigned int mmGPIOPAD_EXTERN_TRIG_CNTL__SI                   = 0x05F1;
constexpr unsigned int mmGPIOPAD_INT_EN__CI__VI                         = 0x018A;
constexpr unsigned int mmGPIOPAD_INT_EN__SI                             = 0x05EE;
constexpr unsigned int mmGPIOPAD_INT_POLARITY__CI__VI                   = 0x018C;
constexpr unsigned int mmGPIOPAD_INT_POLARITY__SI                       = 0x05F0;
constexpr unsigned int mmGPIOPAD_INT_STAT_AK__CI__VI                    = 0x0189;
constexpr unsigned int mmGPIOPAD_INT_STAT_AK__SI                        = 0x05ED;
constexpr unsigned int mmGPIOPAD_INT_STAT_EN__CI__VI                    = 0x0187;
constexpr unsigned int mmGPIOPAD_INT_STAT_EN__SI                        = 0x05EB;
constexpr unsigned int mmGPIOPAD_INT_STAT__CI__VI                       = 0x0188;
constexpr unsigned int mmGPIOPAD_INT_STAT__SI                           = 0x05EC;
constexpr unsigned int mmGPIOPAD_INT_TYPE__CI__VI                       = 0x018B;
constexpr unsigned int mmGPIOPAD_INT_TYPE__SI                           = 0x05EF;
constexpr unsigned int mmGPIOPAD_MASK__CI__VI                           = 0x0182;
constexpr unsigned int mmGPIOPAD_MASK__SI                               = 0x05E6;
constexpr unsigned int mmGPIOPAD_PD_EN__CI__VI                          = 0x0193;
constexpr unsigned int mmGPIOPAD_PD_EN__SI                              = 0x05F4;
constexpr unsigned int mmGPIOPAD_PINSTRAPS__CI__VI                      = 0x0186;
constexpr unsigned int mmGPIOPAD_PINSTRAPS__SI                          = 0x05EA;
constexpr unsigned int mmGPIOPAD_PU_EN__CI__VI                          = 0x0192;
constexpr unsigned int mmGPIOPAD_PU_EN__SI                              = 0x05F3;
constexpr unsigned int mmGPIOPAD_RCVR_SEL__CI__VI                       = 0x0191;
constexpr unsigned int mmGPIOPAD_RCVR_SEL__SI                           = 0x05F2;
constexpr unsigned int mmGPIOPAD_STRENGTH__CI__VI                       = 0x0181;
constexpr unsigned int mmGPIOPAD_STRENGTH__SI                           = 0x05E5;
constexpr unsigned int mmGPIOPAD_SW_INT_STAT__CI__VI                    = 0x0180;
constexpr unsigned int mmGPIOPAD_SW_INT_STAT__SI                        = 0x05E4;
constexpr unsigned int mmGPIOPAD_Y__CI__VI                              = 0x0185;
constexpr unsigned int mmGPIOPAD_Y__SI                                  = 0x05E9;
constexpr unsigned int mmGPU_GARLIC_FLUSH_DONE__CI__VI                  = 0x1414;
constexpr unsigned int mmGPU_GARLIC_FLUSH_REQ__CI__VI                   = 0x1413;
constexpr unsigned int mmGPU_HDP_FLUSH_DONE__CI__VI                     = 0x1538;
constexpr unsigned int mmGPU_HDP_FLUSH_REQ__CI__VI                      = 0x1537;
constexpr unsigned int mmGRBM_CNTL                                      = 0x2000;
constexpr unsigned int mmGRBM_DEBUG                                     = 0x2014;
constexpr unsigned int mmGRBM_DEBUG_CNTL                                = 0x2009;
constexpr unsigned int mmGRBM_DEBUG_DATA                                = 0x200A;
constexpr unsigned int mmGRBM_DEBUG_SNAPSHOT                            = 0x2015;
constexpr unsigned int mmGRBM_GFX_CLKEN_CNTL                            = 0x200C;
constexpr unsigned int mmGRBM_GFX_INDEX__CI__VI                         = 0xC200;
constexpr unsigned int mmGRBM_GFX_INDEX__SI                             = 0x200B;
constexpr unsigned int mmGRBM_INT_CNTL                                  = 0x2018;
constexpr unsigned int mmGRBM_NOWHERE                                   = 0x203F;
constexpr unsigned int mmGRBM_PERFCOUNTER0_HI__CI__VI                   = 0xD041;
constexpr unsigned int mmGRBM_PERFCOUNTER0_HI__SI                       = 0x201F;
constexpr unsigned int mmGRBM_PERFCOUNTER0_LO__CI__VI                   = 0xD040;
constexpr unsigned int mmGRBM_PERFCOUNTER0_LO__SI                       = 0x201E;
constexpr unsigned int mmGRBM_PERFCOUNTER0_SELECT__CI__VI               = 0xD840;
constexpr unsigned int mmGRBM_PERFCOUNTER0_SELECT__SI                   = 0x201C;
constexpr unsigned int mmGRBM_PERFCOUNTER1_HI__CI__VI                   = 0xD044;
constexpr unsigned int mmGRBM_PERFCOUNTER1_HI__SI                       = 0x2021;
constexpr unsigned int mmGRBM_PERFCOUNTER1_LO__CI__VI                   = 0xD043;
constexpr unsigned int mmGRBM_PERFCOUNTER1_LO__SI                       = 0x2020;
constexpr unsigned int mmGRBM_PERFCOUNTER1_SELECT__CI__VI               = 0xD841;
constexpr unsigned int mmGRBM_PERFCOUNTER1_SELECT__SI                   = 0x201D;
constexpr unsigned int mmGRBM_PWR_CNTL                                  = 0x2003;
constexpr unsigned int mmGRBM_READ_ERROR                                = 0x2016;
constexpr unsigned int mmGRBM_READ_ERROR2__CI__VI                       = 0x2017;
constexpr unsigned int mmGRBM_SCRATCH_REG0                              = 0x2040;
constexpr unsigned int mmGRBM_SCRATCH_REG1                              = 0x2041;
constexpr unsigned int mmGRBM_SCRATCH_REG2                              = 0x2042;
constexpr unsigned int mmGRBM_SCRATCH_REG3                              = 0x2043;
constexpr unsigned int mmGRBM_SCRATCH_REG4                              = 0x2044;
constexpr unsigned int mmGRBM_SCRATCH_REG5                              = 0x2045;
constexpr unsigned int mmGRBM_SCRATCH_REG6                              = 0x2046;
constexpr unsigned int mmGRBM_SCRATCH_REG7                              = 0x2047;
constexpr unsigned int mmGRBM_SE0_PERFCOUNTER_HI__CI__VI                = 0xD046;
constexpr unsigned int mmGRBM_SE0_PERFCOUNTER_HI__SI                    = 0x202B;
constexpr unsigned int mmGRBM_SE0_PERFCOUNTER_LO__CI__VI                = 0xD045;
constexpr unsigned int mmGRBM_SE0_PERFCOUNTER_LO__SI                    = 0x202A;
constexpr unsigned int mmGRBM_SE0_PERFCOUNTER_SELECT__CI__VI            = 0xD842;
constexpr unsigned int mmGRBM_SE0_PERFCOUNTER_SELECT__SI                = 0x2026;
constexpr unsigned int mmGRBM_SE1_PERFCOUNTER_HI__CI__VI                = 0xD048;
constexpr unsigned int mmGRBM_SE1_PERFCOUNTER_HI__SI                    = 0x202D;
constexpr unsigned int mmGRBM_SE1_PERFCOUNTER_LO__CI__VI                = 0xD047;
constexpr unsigned int mmGRBM_SE1_PERFCOUNTER_LO__SI                    = 0x202C;
constexpr unsigned int mmGRBM_SE1_PERFCOUNTER_SELECT__CI__VI            = 0xD843;
constexpr unsigned int mmGRBM_SE1_PERFCOUNTER_SELECT__SI                = 0x2027;
constexpr unsigned int mmGRBM_SE2_PERFCOUNTER_HI__CI__VI                = 0xD04A;
constexpr unsigned int mmGRBM_SE2_PERFCOUNTER_LO__CI__VI                = 0xD049;
constexpr unsigned int mmGRBM_SE2_PERFCOUNTER_SELECT__CI__VI            = 0xD844;
constexpr unsigned int mmGRBM_SE3_PERFCOUNTER_HI__CI__VI                = 0xD04C;
constexpr unsigned int mmGRBM_SE3_PERFCOUNTER_LO__CI__VI                = 0xD04B;
constexpr unsigned int mmGRBM_SE3_PERFCOUNTER_SELECT__CI__VI            = 0xD845;
constexpr unsigned int mmGRBM_SKEW_CNTL                                 = 0x2001;
constexpr unsigned int mmGRBM_SOFT_RESET                                = 0x2008;
constexpr unsigned int mmGRBM_STATUS                                    = 0x2004;
constexpr unsigned int mmGRBM_STATUS2                                   = 0x2002;
constexpr unsigned int mmGRBM_STATUS_SE0                                = 0x2005;
constexpr unsigned int mmGRBM_STATUS_SE1                                = 0x2006;
constexpr unsigned int mmGRBM_STATUS_SE2__CI__VI                        = 0x200E;
constexpr unsigned int mmGRBM_STATUS_SE3__CI__VI                        = 0x200F;
constexpr unsigned int mmGRBM_WAIT_IDLE_CLOCKS                          = 0x200D;
constexpr unsigned int mmGRPH8_DATA__SI__VI                             = 0x00F3;
constexpr unsigned int mmGRPH8_IDX__SI__VI                              = 0x00F3;
constexpr unsigned int mmGRPH_COMPRESS_PITCH__SI__VI                    = 0x1A1A;
constexpr unsigned int mmGRPH_COMPRESS_SURFACE_ADDRESS_HIGH__SI__VI     = 0x1A1B;
constexpr unsigned int mmGRPH_COMPRESS_SURFACE_ADDRESS__SI__VI          = 0x1A19;
constexpr unsigned int mmGRPH_CONTROL                                   = 0x1A01;
constexpr unsigned int mmGRPH_DFQ_CONTROL__SI__VI                       = 0x1A14;
constexpr unsigned int mmGRPH_DFQ_STATUS__SI__VI                        = 0x1A15;
constexpr unsigned int mmGRPH_ENABLE__SI__VI                            = 0x1A00;
constexpr unsigned int mmGRPH_FLIP_CONTROL__SI__VI                      = 0x1A12;
constexpr unsigned int mmGRPH_INTERRUPT_CONTROL__SI__VI                 = 0x1A17;
constexpr unsigned int mmGRPH_INTERRUPT_STATUS__SI__VI                  = 0x1A16;
constexpr unsigned int mmGRPH_LUT_10BIT_BYPASS__SI__VI                  = 0x1A02;
constexpr unsigned int mmGRPH_PITCH__SI__VI                             = 0x1A06;
constexpr unsigned int mmGRPH_PRIMARY_SURFACE_ADDRESS_HIGH__SI__VI      = 0x1A07;
constexpr unsigned int mmGRPH_PRIMARY_SURFACE_ADDRESS__SI__VI           = 0x1A04;
constexpr unsigned int mmGRPH_SECONDARY_SURFACE_ADDRESS_HIGH__SI__VI    = 0x1A08;
constexpr unsigned int mmGRPH_SECONDARY_SURFACE_ADDRESS__SI__VI         = 0x1A05;
constexpr unsigned int mmGRPH_SURFACE_ADDRESS_HIGH_INUSE__SI__VI        = 0x1A18;
constexpr unsigned int mmGRPH_SURFACE_ADDRESS_INUSE__SI__VI             = 0x1A13;
constexpr unsigned int mmGRPH_SURFACE_OFFSET_X__SI__VI                  = 0x1A09;
constexpr unsigned int mmGRPH_SURFACE_OFFSET_Y__SI__VI                  = 0x1A0A;
constexpr unsigned int mmGRPH_SWAP_CNTL__SI__VI                         = 0x1A03;
constexpr unsigned int mmGRPH_UPDATE__SI__VI                            = 0x1A11;
constexpr unsigned int mmGRPH_X_END__SI__VI                             = 0x1A0D;
constexpr unsigned int mmGRPH_X_START__SI__VI                           = 0x1A0B;
constexpr unsigned int mmGRPH_Y_END__SI__VI                             = 0x1A0E;
constexpr unsigned int mmGRPH_Y_START__SI__VI                           = 0x1A0C;
constexpr unsigned int mmHDMI_ACR_32_0__SI                              = 0x1C37;
constexpr unsigned int mmHDMI_ACR_32_1__SI                              = 0x1C38;
constexpr unsigned int mmHDMI_ACR_44_0__SI                              = 0x1C39;
constexpr unsigned int mmHDMI_ACR_44_1__SI                              = 0x1C3A;
constexpr unsigned int mmHDMI_ACR_48_0__SI                              = 0x1C3B;
constexpr unsigned int mmHDMI_ACR_48_1__SI                              = 0x1C3C;
constexpr unsigned int mmHDMI_ACR_PACKET_CONTROL__SI                    = 0x1C0F;
constexpr unsigned int mmHDMI_ACR_STATUS_0__SI                          = 0x1C3D;
constexpr unsigned int mmHDMI_ACR_STATUS_1__SI                          = 0x1C3E;
constexpr unsigned int mmHDMI_AUDIO_PACKET_CONTROL__SI                  = 0x1C0E;
constexpr unsigned int mmHDMI_CONTROL__SI                               = 0x1C0C;
constexpr unsigned int mmHDMI_GC__SI                                    = 0x1C16;
constexpr unsigned int mmHDMI_GENERIC_PACKET_CONTROL__SI                = 0x1C13;
constexpr unsigned int mmHDMI_INFOFRAME_CONTROL0__SI                    = 0x1C11;
constexpr unsigned int mmHDMI_INFOFRAME_CONTROL1__SI                    = 0x1C12;
constexpr unsigned int mmHDMI_STATUS__SI                                = 0x1C0D;
constexpr unsigned int mmHDMI_VBI_PACKET_CONTROL__SI                    = 0x1C10;
constexpr unsigned int mmHDP_DEBUG0                                     = 0x0BCC;
constexpr unsigned int mmHDP_DEBUG1                                     = 0x0BCD;
constexpr unsigned int mmHDP_HOST_PATH_CNTL                             = 0x0B00;
constexpr unsigned int mmHDP_LAST_SURFACE_HIT                           = 0x0BCE;
constexpr unsigned int mmHDP_MEM_COHERENCY_FLUSH_CNTL                   = 0x1520;
constexpr unsigned int mmHDP_NONSURFACE_BASE                            = 0x0B01;
constexpr unsigned int mmHDP_NONSURFACE_INFO                            = 0x0B02;
constexpr unsigned int mmHDP_NONSURFACE_SIZE                            = 0x0B03;
constexpr unsigned int mmHDP_NONSURF_FLAGS                              = 0x0BC9;
constexpr unsigned int mmHDP_NONSURF_FLAGS_CLR                          = 0x0BCA;
constexpr unsigned int mmHDP_OUTSTANDING_REQ                            = 0x0BD1;
constexpr unsigned int mmHDP_REG_COHERENCY_FLUSH_CNTL                   = 0x1528;
constexpr unsigned int mmHDP_SC_MULTI_CHIP_CNTL                         = 0x0BD0;
constexpr unsigned int mmHDP_SW_SEMAPHORE                               = 0x0BCB;
constexpr unsigned int mmHDP_TILING_CONFIG                              = 0x0BCF;
constexpr unsigned int mmHDP_XDP_BUSY_STS                               = 0x0C3E;
constexpr unsigned int mmHDP_XDP_CGTT_BLK_CTRL                          = 0x0C33;
constexpr unsigned int mmHDP_XDP_CHKN                                   = 0x0C40;
constexpr unsigned int mmHDP_XDP_D2H_BAR_UPDATE                         = 0x0C02;
constexpr unsigned int mmHDP_XDP_D2H_FLUSH                              = 0x0C01;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_10                            = 0x0C0A;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_11                            = 0x0C0B;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_12                            = 0x0C0C;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_13                            = 0x0C0D;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_14                            = 0x0C0E;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_15                            = 0x0C0F;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_16                            = 0x0C10;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_17                            = 0x0C11;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_18                            = 0x0C12;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_19                            = 0x0C13;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_20                            = 0x0C14;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_21                            = 0x0C15;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_22                            = 0x0C16;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_23                            = 0x0C17;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_24                            = 0x0C18;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_25                            = 0x0C19;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_26                            = 0x0C1A;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_27                            = 0x0C1B;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_28                            = 0x0C1C;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_29                            = 0x0C1D;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_3                             = 0x0C03;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_30                            = 0x0C1E;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_31                            = 0x0C1F;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_32                            = 0x0C20;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_33                            = 0x0C21;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_34                            = 0x0C22;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_4                             = 0x0C04;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_5                             = 0x0C05;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_6                             = 0x0C06;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_7                             = 0x0C07;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_8                             = 0x0C08;
constexpr unsigned int mmHDP_XDP_D2H_RSVD_9                             = 0x0C09;
constexpr unsigned int mmHDP_XDP_DBG_ADDR                               = 0x0C41;
constexpr unsigned int mmHDP_XDP_DBG_DATA                               = 0x0C42;
constexpr unsigned int mmHDP_XDP_DBG_MASK                               = 0x0C43;
constexpr unsigned int mmHDP_XDP_DIRECT2HDP_FIRST                       = 0x0C00;
constexpr unsigned int mmHDP_XDP_DIRECT2HDP_LAST                        = 0x0C23;
constexpr unsigned int mmHDP_XDP_FLUSH_ARMED_STS                        = 0x0C3C;
constexpr unsigned int mmHDP_XDP_FLUSH_CNTR0_STS                        = 0x0C3D;
constexpr unsigned int mmHDP_XDP_HDP_IPH_CFG                            = 0x0C31;
constexpr unsigned int mmHDP_XDP_HDP_MBX_MC_CFG                         = 0x0C2D;
constexpr unsigned int mmHDP_XDP_HDP_MC_CFG                             = 0x0C2E;
constexpr unsigned int mmHDP_XDP_HST_CFG                                = 0x0C2F;
constexpr unsigned int mmHDP_XDP_P2P_BAR0                               = 0x0C34;
constexpr unsigned int mmHDP_XDP_P2P_BAR1                               = 0x0C35;
constexpr unsigned int mmHDP_XDP_P2P_BAR2                               = 0x0C36;
constexpr unsigned int mmHDP_XDP_P2P_BAR3                               = 0x0C37;
constexpr unsigned int mmHDP_XDP_P2P_BAR4                               = 0x0C38;
constexpr unsigned int mmHDP_XDP_P2P_BAR5                               = 0x0C39;
constexpr unsigned int mmHDP_XDP_P2P_BAR6                               = 0x0C3A;
constexpr unsigned int mmHDP_XDP_P2P_BAR7                               = 0x0C3B;
constexpr unsigned int mmHDP_XDP_P2P_BAR_CFG                            = 0x0C24;
constexpr unsigned int mmHDP_XDP_P2P_MBX_ADDR0                          = 0x0C26;
constexpr unsigned int mmHDP_XDP_P2P_MBX_ADDR1                          = 0x0C27;
constexpr unsigned int mmHDP_XDP_P2P_MBX_ADDR2                          = 0x0C28;
constexpr unsigned int mmHDP_XDP_P2P_MBX_ADDR3                          = 0x0C29;
constexpr unsigned int mmHDP_XDP_P2P_MBX_ADDR4                          = 0x0C2A;
constexpr unsigned int mmHDP_XDP_P2P_MBX_ADDR5                          = 0x0C2B;
constexpr unsigned int mmHDP_XDP_P2P_MBX_ADDR6                          = 0x0C2C;
constexpr unsigned int mmHDP_XDP_P2P_MBX_OFFSET                         = 0x0C25;
constexpr unsigned int mmHDP_XDP_SID_CFG                                = 0x0C30;
constexpr unsigned int mmHDP_XDP_SRBM_CFG                               = 0x0C32;
constexpr unsigned int mmHDP_XDP_STICKY                                 = 0x0C3F;
constexpr unsigned int mmHOST_BUSNUM                                    = 0x153D;
constexpr unsigned int mmHW_DEBUG                                       = 0x1515;
constexpr unsigned int mmIA_CNTL_STATUS                                 = 0x2237;
constexpr unsigned int mmIA_DEBUG_CNTL                                  = 0x223A;
constexpr unsigned int mmIA_DEBUG_DATA                                  = 0x223B;
constexpr unsigned int mmIA_ENHANCE                                     = 0xA29C;
constexpr unsigned int mmIA_MULTI_VGT_PARAM                             = 0xA2AA;
constexpr unsigned int mmIA_PERFCOUNTER0_HI__CI__VI                     = 0xD089;
constexpr unsigned int mmIA_PERFCOUNTER0_HI__SI                         = 0x2225;
constexpr unsigned int mmIA_PERFCOUNTER0_LO__CI__VI                     = 0xD088;
constexpr unsigned int mmIA_PERFCOUNTER0_LO__SI                         = 0x2224;
constexpr unsigned int mmIA_PERFCOUNTER0_SELECT1__CI__VI                = 0xD888;
constexpr unsigned int mmIA_PERFCOUNTER0_SELECT__CI__VI                 = 0xD884;
constexpr unsigned int mmIA_PERFCOUNTER0_SELECT__SI                     = 0x2220;
constexpr unsigned int mmIA_PERFCOUNTER1_HI__CI__VI                     = 0xD08B;
constexpr unsigned int mmIA_PERFCOUNTER1_HI__SI                         = 0x2227;
constexpr unsigned int mmIA_PERFCOUNTER1_LO__CI__VI                     = 0xD08A;
constexpr unsigned int mmIA_PERFCOUNTER1_LO__SI                         = 0x2226;
constexpr unsigned int mmIA_PERFCOUNTER1_SELECT__CI__VI                 = 0xD885;
constexpr unsigned int mmIA_PERFCOUNTER1_SELECT__SI                     = 0x2221;
constexpr unsigned int mmIA_PERFCOUNTER2_HI__CI__VI                     = 0xD08D;
constexpr unsigned int mmIA_PERFCOUNTER2_HI__SI                         = 0x2229;
constexpr unsigned int mmIA_PERFCOUNTER2_LO__CI__VI                     = 0xD08C;
constexpr unsigned int mmIA_PERFCOUNTER2_LO__SI                         = 0x2228;
constexpr unsigned int mmIA_PERFCOUNTER2_SELECT__CI__VI                 = 0xD886;
constexpr unsigned int mmIA_PERFCOUNTER2_SELECT__SI                     = 0x2222;
constexpr unsigned int mmIA_PERFCOUNTER3_HI__CI__VI                     = 0xD08F;
constexpr unsigned int mmIA_PERFCOUNTER3_HI__SI                         = 0x222B;
constexpr unsigned int mmIA_PERFCOUNTER3_LO__CI__VI                     = 0xD08E;
constexpr unsigned int mmIA_PERFCOUNTER3_LO__SI                         = 0x222A;
constexpr unsigned int mmIA_PERFCOUNTER3_SELECT__CI__VI                 = 0xD887;
constexpr unsigned int mmIA_PERFCOUNTER3_SELECT__SI                     = 0x2223;
constexpr unsigned int mmIA_VMID_OVERRIDE__SI__CI                       = 0x2260;
constexpr unsigned int mmIH_ADVFAULT_CNTL__SI__CI                       = 0x0F8C;
constexpr unsigned int mmIH_PERFCOUNTER0_RESULT__CI                     = 0x0F8A;
constexpr unsigned int mmIH_PERFCOUNTER1_RESULT__CI                     = 0x0F8B;
constexpr unsigned int mmIH_PERFMON_CNTL__CI                            = 0x0F89;
constexpr unsigned int mmIH_VMID_0_LUT__CI                              = 0x0F50;
constexpr unsigned int mmIH_VMID_10_LUT__CI                             = 0x0F5A;
constexpr unsigned int mmIH_VMID_11_LUT__CI                             = 0x0F5B;
constexpr unsigned int mmIH_VMID_12_LUT__CI                             = 0x0F5C;
constexpr unsigned int mmIH_VMID_13_LUT__CI                             = 0x0F5D;
constexpr unsigned int mmIH_VMID_14_LUT__CI                             = 0x0F5E;
constexpr unsigned int mmIH_VMID_15_LUT__CI                             = 0x0F5F;
constexpr unsigned int mmIH_VMID_1_LUT__CI                              = 0x0F51;
constexpr unsigned int mmIH_VMID_2_LUT__CI                              = 0x0F52;
constexpr unsigned int mmIH_VMID_3_LUT__CI                              = 0x0F53;
constexpr unsigned int mmIH_VMID_4_LUT__CI                              = 0x0F54;
constexpr unsigned int mmIH_VMID_5_LUT__CI                              = 0x0F55;
constexpr unsigned int mmIH_VMID_6_LUT__CI                              = 0x0F56;
constexpr unsigned int mmIH_VMID_7_LUT__CI                              = 0x0F57;
constexpr unsigned int mmIH_VMID_8_LUT__CI                              = 0x0F58;
constexpr unsigned int mmIH_VMID_9_LUT__CI                              = 0x0F59;
constexpr unsigned int mmIMPCTL_RESET__CI__VI                           = 0x14F5;
constexpr unsigned int mmINTERRUPT_CNTL                                 = 0x151A;
constexpr unsigned int mmINTERRUPT_CNTL2                                = 0x151B;
constexpr unsigned int mmINT_MASK__SI                                   = 0x1AD0;
constexpr unsigned int mmLB0_DC_MVP_LB_CONTROL__SI                      = 0x1ADB;
constexpr unsigned int mmLB0_LB_DEBUG__SI                               = 0x1AFC;
constexpr unsigned int mmLB0_LB_SYNC_RESET_SEL__SI                      = 0x1ACA;
constexpr unsigned int mmLB0_LB_TEST_DEBUG_DATA__SI__VI                 = 0x1AFF;
constexpr unsigned int mmLB0_LB_TEST_DEBUG_INDEX__SI__VI                = 0x1AFE;
constexpr unsigned int mmLB0_MVP_AFR_FLIP_FIFO_CNTL__SI                 = 0x1AD9;
constexpr unsigned int mmLB0_MVP_AFR_FLIP_MODE__SI                      = 0x1AD8;
constexpr unsigned int mmLB0_MVP_FLIP_LINE_NUM_INSERT__SI               = 0x1ADA;
constexpr unsigned int mmLB1_DC_MVP_LB_CONTROL__SI                      = 0x1DDB;
constexpr unsigned int mmLB1_LB_DEBUG__SI                               = 0x1DFC;
constexpr unsigned int mmLB1_LB_SYNC_RESET_SEL__SI                      = 0x1DCA;
constexpr unsigned int mmLB1_LB_TEST_DEBUG_DATA__SI                     = 0x1DFF;
constexpr unsigned int mmLB1_LB_TEST_DEBUG_INDEX__SI                    = 0x1DFE;
constexpr unsigned int mmLB1_MVP_AFR_FLIP_FIFO_CNTL__SI                 = 0x1DD9;
constexpr unsigned int mmLB1_MVP_AFR_FLIP_MODE__SI                      = 0x1DD8;
constexpr unsigned int mmLB1_MVP_FLIP_LINE_NUM_INSERT__SI               = 0x1DDA;
constexpr unsigned int mmLB2_DC_MVP_LB_CONTROL__SI                      = 0x40DB;
constexpr unsigned int mmLB2_LB_DEBUG__SI                               = 0x40FC;
constexpr unsigned int mmLB2_LB_SYNC_RESET_SEL__SI                      = 0x40CA;
constexpr unsigned int mmLB2_LB_TEST_DEBUG_DATA__SI                     = 0x40FF;
constexpr unsigned int mmLB2_LB_TEST_DEBUG_INDEX__SI                    = 0x40FE;
constexpr unsigned int mmLB2_MVP_AFR_FLIP_FIFO_CNTL__SI                 = 0x40D9;
constexpr unsigned int mmLB2_MVP_AFR_FLIP_MODE__SI                      = 0x40D8;
constexpr unsigned int mmLB2_MVP_FLIP_LINE_NUM_INSERT__SI               = 0x40DA;
constexpr unsigned int mmLB3_DC_MVP_LB_CONTROL__SI                      = 0x43DB;
constexpr unsigned int mmLB3_LB_DEBUG__SI                               = 0x43FC;
constexpr unsigned int mmLB3_LB_SYNC_RESET_SEL__SI                      = 0x43CA;
constexpr unsigned int mmLB3_LB_TEST_DEBUG_DATA__SI                     = 0x43FF;
constexpr unsigned int mmLB3_LB_TEST_DEBUG_INDEX__SI                    = 0x43FE;
constexpr unsigned int mmLB3_MVP_AFR_FLIP_FIFO_CNTL__SI                 = 0x43D9;
constexpr unsigned int mmLB3_MVP_AFR_FLIP_MODE__SI                      = 0x43D8;
constexpr unsigned int mmLB3_MVP_FLIP_LINE_NUM_INSERT__SI               = 0x43DA;
constexpr unsigned int mmLB4_DC_MVP_LB_CONTROL__SI                      = 0x46DB;
constexpr unsigned int mmLB4_LB_DEBUG__SI                               = 0x46FC;
constexpr unsigned int mmLB4_LB_SYNC_RESET_SEL__SI                      = 0x46CA;
constexpr unsigned int mmLB4_LB_TEST_DEBUG_DATA__SI                     = 0x46FF;
constexpr unsigned int mmLB4_LB_TEST_DEBUG_INDEX__SI                    = 0x46FE;
constexpr unsigned int mmLB4_MVP_AFR_FLIP_FIFO_CNTL__SI                 = 0x46D9;
constexpr unsigned int mmLB4_MVP_AFR_FLIP_MODE__SI                      = 0x46D8;
constexpr unsigned int mmLB4_MVP_FLIP_LINE_NUM_INSERT__SI               = 0x46DA;
constexpr unsigned int mmLB5_DC_MVP_LB_CONTROL__SI                      = 0x49DB;
constexpr unsigned int mmLB5_LB_DEBUG__SI                               = 0x49FC;
constexpr unsigned int mmLB5_LB_SYNC_RESET_SEL__SI                      = 0x49CA;
constexpr unsigned int mmLB5_LB_TEST_DEBUG_DATA__SI                     = 0x49FF;
constexpr unsigned int mmLB5_LB_TEST_DEBUG_INDEX__SI                    = 0x49FE;
constexpr unsigned int mmLB5_MVP_AFR_FLIP_FIFO_CNTL__SI                 = 0x49D9;
constexpr unsigned int mmLB5_MVP_AFR_FLIP_MODE__SI                      = 0x49D8;
constexpr unsigned int mmLB5_MVP_FLIP_LINE_NUM_INSERT__SI               = 0x49DA;
constexpr unsigned int mmLB_DEBUG__SI                                   = 0x1AFC;
constexpr unsigned int mmLB_SYNC_RESET_SEL__SI                          = 0x1ACA;
constexpr unsigned int mmLB_TEST_DEBUG_DATA__SI__VI                     = 0x1AFF;
constexpr unsigned int mmLB_TEST_DEBUG_INDEX__SI__VI                    = 0x1AFE;
constexpr unsigned int mmLNCNT_CONTROL__CI                              = 0x1487;
constexpr unsigned int mmLVDS_DATA_CNTL__SI                             = 0x1C8C;
constexpr unsigned int mmLVTMA_PWRSEQ_CNTL__SI                          = 0x1962;
constexpr unsigned int mmLVTMA_PWRSEQ_DELAY1__SI                        = 0x1965;
constexpr unsigned int mmLVTMA_PWRSEQ_DELAY2__SI                        = 0x1966;
constexpr unsigned int mmLVTMA_PWRSEQ_REF_DIV__SI                       = 0x1964;
constexpr unsigned int mmLVTMA_PWRSEQ_STATE__SI                         = 0x1963;
constexpr unsigned int mmMASTER_COMM_CMD_REG__SI__VI                    = 0x161F;
constexpr unsigned int mmMASTER_COMM_CNTL_REG__SI__VI                   = 0x1620;
constexpr unsigned int mmMASTER_COMM_DATA_REG1__SI__VI                  = 0x161C;
constexpr unsigned int mmMASTER_COMM_DATA_REG2__SI__VI                  = 0x161D;
constexpr unsigned int mmMASTER_COMM_DATA_REG3__SI__VI                  = 0x161E;
constexpr unsigned int mmMASTER_CREDIT_CNTL                             = 0x1516;
constexpr unsigned int mmMASTER_UPDATE_LOCK__SI__VI                     = 0x1BBD;
constexpr unsigned int mmMASTER_UPDATE_MODE__SI__VI                     = 0x1BBE;
constexpr unsigned int mmMCIF_CONTROL__SI                               = 0x0314;
constexpr unsigned int mmMCIF_TEST_DEBUG_DATA__SI                       = 0x0317;
constexpr unsigned int mmMCIF_TEST_DEBUG_INDEX__SI                      = 0x0316;
constexpr unsigned int mmMCIF_WRITE_COMBINE_CONTROL__SI                 = 0x0315;
constexpr unsigned int mmMCLK_PWRMGT_CNTL__SI__CI                       = 0x0AE8;
constexpr unsigned int mmMC_ARB_ADDR_HASH                               = 0x09DC;
constexpr unsigned int mmMC_ARB_ADDR_SWIZ0__CI__VI                      = 0x09CB;
constexpr unsigned int mmMC_ARB_ADDR_SWIZ1__CI__VI                      = 0x09CC;
constexpr unsigned int mmMC_ARB_AGE_CNTL__CI__VI                        = 0x09BF;
constexpr unsigned int mmMC_ARB_AGE_RD                                  = 0x09E9;
constexpr unsigned int mmMC_ARB_AGE_WR                                  = 0x09EA;
constexpr unsigned int mmMC_ARB_BANKMAP                                 = 0x09D7;
constexpr unsigned int mmMC_ARB_BURST_TIME                              = 0x0A02;
constexpr unsigned int mmMC_ARB_BUSY_STATUS__CI__VI                     = 0x09FD;
constexpr unsigned int mmMC_ARB_CAC_CNTL                                = 0x09D4;
constexpr unsigned int mmMC_ARB_CG                                      = 0x09FA;
constexpr unsigned int mmMC_ARB_DRAM_TIMING                             = 0x09DD;
constexpr unsigned int mmMC_ARB_DRAM_TIMING2                            = 0x09DE;
constexpr unsigned int mmMC_ARB_DRAM_TIMING2_1                          = 0x09FF;
constexpr unsigned int mmMC_ARB_DRAM_TIMING_1                           = 0x09FC;
constexpr unsigned int mmMC_ARB_FED_CNTL                                = 0x09C1;
constexpr unsigned int mmMC_ARB_GDEC_RD_CNTL                            = 0x09EE;
constexpr unsigned int mmMC_ARB_GDEC_WR_CNTL                            = 0x09EF;
constexpr unsigned int mmMC_ARB_GECC2                                   = 0x09C9;
constexpr unsigned int mmMC_ARB_GECC2_CLI                               = 0x09CA;
constexpr unsigned int mmMC_ARB_GECC2_DEBUG                             = 0x09C4;
constexpr unsigned int mmMC_ARB_GECC2_DEBUG2                            = 0x09C5;
constexpr unsigned int mmMC_ARB_GECC2_MISC                              = 0x09C3;
constexpr unsigned int mmMC_ARB_GECC2_STATUS                            = 0x09C2;
constexpr unsigned int mmMC_ARB_HARSH_BWCNT0_RD__CI__VI                 = 0x0DCE;
constexpr unsigned int mmMC_ARB_HARSH_BWCNT0_WR__CI__VI                 = 0x0DCF;
constexpr unsigned int mmMC_ARB_HARSH_BWCNT1_RD__CI__VI                 = 0x0DD0;
constexpr unsigned int mmMC_ARB_HARSH_BWCNT1_WR__CI__VI                 = 0x0DD1;
constexpr unsigned int mmMC_ARB_HARSH_BWPERIOD0_RD__CI__VI              = 0x0DCA;
constexpr unsigned int mmMC_ARB_HARSH_BWPERIOD0_WR__CI__VI              = 0x0DCB;
constexpr unsigned int mmMC_ARB_HARSH_BWPERIOD1_RD__CI__VI              = 0x0DCC;
constexpr unsigned int mmMC_ARB_HARSH_BWPERIOD1_WR__CI__VI              = 0x0DCD;
constexpr unsigned int mmMC_ARB_HARSH_CTL_RD__CI__VI                    = 0x0DD6;
constexpr unsigned int mmMC_ARB_HARSH_CTL_WR__CI__VI                    = 0x0DD7;
constexpr unsigned int mmMC_ARB_HARSH_EN_RD__CI__VI                     = 0x0DC0;
constexpr unsigned int mmMC_ARB_HARSH_EN_WR__CI__VI                     = 0x0DC1;
constexpr unsigned int mmMC_ARB_HARSH_SAT0_RD__CI__VI                   = 0x0DD2;
constexpr unsigned int mmMC_ARB_HARSH_SAT0_WR__CI__VI                   = 0x0DD3;
constexpr unsigned int mmMC_ARB_HARSH_SAT1_RD__CI__VI                   = 0x0DD4;
constexpr unsigned int mmMC_ARB_HARSH_SAT1_WR__CI__VI                   = 0x0DD5;
constexpr unsigned int mmMC_ARB_HARSH_TX_HI0_RD__CI__VI                 = 0x0DC2;
constexpr unsigned int mmMC_ARB_HARSH_TX_HI0_WR__CI__VI                 = 0x0DC3;
constexpr unsigned int mmMC_ARB_HARSH_TX_HI1_RD__CI__VI                 = 0x0DC4;
constexpr unsigned int mmMC_ARB_HARSH_TX_HI1_WR__CI__VI                 = 0x0DC5;
constexpr unsigned int mmMC_ARB_HARSH_TX_LO0_RD__CI__VI                 = 0x0DC6;
constexpr unsigned int mmMC_ARB_HARSH_TX_LO0_WR__CI__VI                 = 0x0DC7;
constexpr unsigned int mmMC_ARB_HARSH_TX_LO1_RD__CI__VI                 = 0x0DC8;
constexpr unsigned int mmMC_ARB_HARSH_TX_LO1_WR__CI__VI                 = 0x0DC9;
constexpr unsigned int mmMC_ARB_LAZY0_RD                                = 0x09E5;
constexpr unsigned int mmMC_ARB_LAZY0_WR                                = 0x09E6;
constexpr unsigned int mmMC_ARB_LAZY1_RD                                = 0x09E7;
constexpr unsigned int mmMC_ARB_LAZY1_WR                                = 0x09E8;
constexpr unsigned int mmMC_ARB_LM_RD                                   = 0x09F0;
constexpr unsigned int mmMC_ARB_LM_WR                                   = 0x09F1;
constexpr unsigned int mmMC_ARB_MAX_LAT_CID__CI__VI                     = 0x09F6;
constexpr unsigned int mmMC_ARB_MAX_LAT_RSLT0__CI__VI                   = 0x09F7;
constexpr unsigned int mmMC_ARB_MAX_LAT_RSLT1__CI__VI                   = 0x09F8;
constexpr unsigned int mmMC_ARB_MINCLKS                                 = 0x09DA;
constexpr unsigned int mmMC_ARB_MISC                                    = 0x09D6;
constexpr unsigned int mmMC_ARB_MISC2                                   = 0x09D5;
constexpr unsigned int mmMC_ARB_MISC3__CI__VI                           = 0x09CD;
constexpr unsigned int mmMC_ARB_PERFCOUNTER0_CFG__CI__VI                = 0x07BC;
constexpr unsigned int mmMC_ARB_PERFCOUNTER1_CFG__CI__VI                = 0x07BD;
constexpr unsigned int mmMC_ARB_PERFCOUNTER2_CFG__CI__VI                = 0x07BE;
constexpr unsigned int mmMC_ARB_PERFCOUNTER3_CFG__CI__VI                = 0x07BF;
constexpr unsigned int mmMC_ARB_PERFCOUNTER_HI__CI__VI                  = 0x07AE;
constexpr unsigned int mmMC_ARB_PERFCOUNTER_LO__CI__VI                  = 0x07A6;
constexpr unsigned int mmMC_ARB_PERFCOUNTER_RSLT_CNTL__CI__VI           = 0x07D4;
constexpr unsigned int mmMC_ARB_PERF_MON_CNTL0_ECC__CI                  = 0x07DB;
constexpr unsigned int mmMC_ARB_PERF_MON_CNTL0__SI                      = 0x09F6;
constexpr unsigned int mmMC_ARB_PM_CNTL                                 = 0x09ED;
constexpr unsigned int mmMC_ARB_POP                                     = 0x09D9;
constexpr unsigned int mmMC_ARB_RAMCFG                                  = 0x09D8;
constexpr unsigned int mmMC_ARB_REMREQ                                  = 0x09F2;
constexpr unsigned int mmMC_ARB_REPLAY                                  = 0x09F3;
constexpr unsigned int mmMC_ARB_RET_CREDITS2__CI__VI                    = 0x09C0;
constexpr unsigned int mmMC_ARB_RET_CREDITS_RD                          = 0x09F4;
constexpr unsigned int mmMC_ARB_RET_CREDITS_WR                          = 0x09F5;
constexpr unsigned int mmMC_ARB_RFSH_CNTL                               = 0x09EB;
constexpr unsigned int mmMC_ARB_RFSH_RATE                               = 0x09EC;
constexpr unsigned int mmMC_ARB_RTT_CNTL0                               = 0x09D0;
constexpr unsigned int mmMC_ARB_RTT_CNTL1                               = 0x09D1;
constexpr unsigned int mmMC_ARB_RTT_CNTL2                               = 0x09D2;
constexpr unsigned int mmMC_ARB_RTT_DATA                                = 0x09CF;
constexpr unsigned int mmMC_ARB_RTT_DEBUG                               = 0x09D3;
constexpr unsigned int mmMC_ARB_SQM_CNTL                                = 0x09DB;
constexpr unsigned int mmMC_ARB_SSM__CI                                 = 0x09F9;
constexpr unsigned int mmMC_ARB_TM_CNTL_RD                              = 0x09E3;
constexpr unsigned int mmMC_ARB_TM_CNTL_WR                              = 0x09E4;
constexpr unsigned int mmMC_ARB_WCDR__SI__CI                            = 0x09FB;
constexpr unsigned int mmMC_ARB_WCDR_2__SI__CI                          = 0x09CE;
constexpr unsigned int mmMC_ARB_WTM_CNTL_RD                             = 0x09DF;
constexpr unsigned int mmMC_ARB_WTM_CNTL_WR                             = 0x09E0;
constexpr unsigned int mmMC_ARB_WTM_GRPWT_RD                            = 0x09E1;
constexpr unsigned int mmMC_ARB_WTM_GRPWT_WR                            = 0x09E2;
constexpr unsigned int mmMC_BIST_AUTO_CNTL__SI__CI                      = 0x0A06;
constexpr unsigned int mmMC_BIST_CMD_CNTL__SI__CI                       = 0x0A8E;
constexpr unsigned int mmMC_BIST_CMP_CNTL__SI__CI                       = 0x0A8D;
constexpr unsigned int mmMC_BIST_CMP_CNTL_2__SI__CI                     = 0x0AB6;
constexpr unsigned int mmMC_BIST_DATA_MASK__SI__CI                      = 0x0A12;
constexpr unsigned int mmMC_BIST_DIR_CNTL__SI__CI                       = 0x0A07;
constexpr unsigned int mmMC_BIST_EADDR__SI__CI                          = 0x0A09;
constexpr unsigned int mmMC_BIST_RDATA_EDC__SI__CI                      = 0x0A1D;
constexpr unsigned int mmMC_BIST_RDATA_MASK__SI__CI                     = 0x0A1C;
constexpr unsigned int mmMC_BIST_SADDR__SI__CI                          = 0x0A08;
constexpr unsigned int mmMC_CG_CONFIG                                   = 0x096F;
constexpr unsigned int mmMC_CG_CONFIG_MCD                               = 0x0829;
constexpr unsigned int mmMC_CITF_CNTL                                   = 0x0970;
constexpr unsigned int mmMC_CITF_CREDITS_ARB_RD                         = 0x0972;
constexpr unsigned int mmMC_CITF_CREDITS_ARB_WR                         = 0x0973;
constexpr unsigned int mmMC_CITF_CREDITS_VM                             = 0x0971;
constexpr unsigned int mmMC_CITF_CREDITS_XBAR                           = 0x0989;
constexpr unsigned int mmMC_CITF_DAGB_CNTL                              = 0x0974;
constexpr unsigned int mmMC_CITF_DAGB_DLY                               = 0x0977;
constexpr unsigned int mmMC_CITF_INT_CREDITS                            = 0x0975;
constexpr unsigned int mmMC_CITF_INT_CREDITS_WR__CI__VI                 = 0x097D;
constexpr unsigned int mmMC_CITF_MISC_RD_CG                             = 0x0992;
constexpr unsigned int mmMC_CITF_MISC_VM_CG                             = 0x0994;
constexpr unsigned int mmMC_CITF_MISC_WR_CG                             = 0x0993;
constexpr unsigned int mmMC_CITF_PERFCOUNTER0_CFG__CI__VI               = 0x07B0;
constexpr unsigned int mmMC_CITF_PERFCOUNTER1_CFG__CI__VI               = 0x07B1;
constexpr unsigned int mmMC_CITF_PERFCOUNTER2_CFG__CI__VI               = 0x07B2;
constexpr unsigned int mmMC_CITF_PERFCOUNTER3_CFG__CI__VI               = 0x07B3;
constexpr unsigned int mmMC_CITF_PERFCOUNTER_HI__CI__VI                 = 0x07A8;
constexpr unsigned int mmMC_CITF_PERFCOUNTER_LO__CI__VI                 = 0x07A0;
constexpr unsigned int mmMC_CITF_PERFCOUNTER_RSLT_CNTL__CI__VI          = 0x07CE;
constexpr unsigned int mmMC_CITF_PERF_MON_CNTL2                         = 0x098E;
constexpr unsigned int mmMC_CITF_PERF_MON_RSLT2                         = 0x0991;
constexpr unsigned int mmMC_CITF_REMREQ                                 = 0x097A;
constexpr unsigned int mmMC_CITF_RET_MODE                               = 0x0976;
constexpr unsigned int mmMC_CITF_WTM_RD_CNTL                            = 0x097F;
constexpr unsigned int mmMC_CITF_WTM_WR_CNTL                            = 0x0980;
constexpr unsigned int mmMC_CITF_XTRA_ENABLE                            = 0x096D;
constexpr unsigned int mmMC_CONFIG                                      = 0x0800;
constexpr unsigned int mmMC_CONFIG_MCD                                  = 0x0828;
constexpr unsigned int mmMC_DC_INTERFACE_NACK_STATUS__SI                = 0x031C;
constexpr unsigned int mmMC_DLB_CONFIG0__CI                             = 0x0D93;
constexpr unsigned int mmMC_DLB_CONFIG1__CI                             = 0x0D94;
constexpr unsigned int mmMC_DLB_MISCCTRL0__CI                           = 0x0D90;
constexpr unsigned int mmMC_DLB_MISCCTRL1__CI                           = 0x0D91;
constexpr unsigned int mmMC_DLB_MISCCTRL2__CI                           = 0x0D92;
constexpr unsigned int mmMC_DLB_SETUPFIFO__CI                           = 0x0D97;
constexpr unsigned int mmMC_DLB_SETUPSWEEP__CI                          = 0x0D96;
constexpr unsigned int mmMC_DLB_SETUP__CI                               = 0x0D95;
constexpr unsigned int mmMC_DLB_STATUS_MISC0__CI                        = 0x0D9A;
constexpr unsigned int mmMC_DLB_STATUS_MISC1__CI                        = 0x0D9B;
constexpr unsigned int mmMC_DLB_STATUS_MISC2__CI                        = 0x0D9C;
constexpr unsigned int mmMC_DLB_STATUS_MISC3__CI                        = 0x0D9D;
constexpr unsigned int mmMC_DLB_STATUS_MISC4__CI                        = 0x0D9E;
constexpr unsigned int mmMC_DLB_STATUS_MISC5__CI                        = 0x0D9F;
constexpr unsigned int mmMC_DLB_STATUS_MISC6__CI                        = 0x0DA0;
constexpr unsigned int mmMC_DLB_STATUS_MISC7__CI                        = 0x0DA1;
constexpr unsigned int mmMC_DLB_STATUS__CI                              = 0x0D99;
constexpr unsigned int mmMC_DLB_WRITE_MASK__CI                          = 0x0D98;
constexpr unsigned int mmMC_HUB_MISC_DBG__SI__CI                        = 0x0831;
constexpr unsigned int mmMC_HUB_MISC_FRAMING                            = 0x0834;
constexpr unsigned int mmMC_HUB_MISC_HUB_CG                             = 0x082E;
constexpr unsigned int mmMC_HUB_MISC_IDLE_STATUS                        = 0x0847;
constexpr unsigned int mmMC_HUB_MISC_OVERRIDE                           = 0x0833;
constexpr unsigned int mmMC_HUB_MISC_POWER                              = 0x082D;
constexpr unsigned int mmMC_HUB_MISC_SIP_CG                             = 0x0830;
constexpr unsigned int mmMC_HUB_MISC_STATUS                             = 0x0832;
constexpr unsigned int mmMC_HUB_MISC_VM_CG                              = 0x082F;
constexpr unsigned int mmMC_HUB_PERFCOUNTER0_CFG__CI__VI                = 0x07B4;
constexpr unsigned int mmMC_HUB_PERFCOUNTER1_CFG__CI__VI                = 0x07B5;
constexpr unsigned int mmMC_HUB_PERFCOUNTER2_CFG__CI__VI                = 0x07B6;
constexpr unsigned int mmMC_HUB_PERFCOUNTER3_CFG__CI__VI                = 0x07B7;
constexpr unsigned int mmMC_HUB_PERFCOUNTER_HI__CI__VI                  = 0x07A9;
constexpr unsigned int mmMC_HUB_PERFCOUNTER_LO__CI__VI                  = 0x07A1;
constexpr unsigned int mmMC_HUB_PERFCOUNTER_RSLT_CNTL__CI__VI           = 0x07CF;
constexpr unsigned int mmMC_HUB_RDREQ_ACPG_LIMIT__CI__VI                = 0x0849;
constexpr unsigned int mmMC_HUB_RDREQ_ACPG__CI                          = 0x0887;
constexpr unsigned int mmMC_HUB_RDREQ_ACPO__CI                          = 0x0888;
constexpr unsigned int mmMC_HUB_RDREQ_CNTL                              = 0x083B;
constexpr unsigned int mmMC_HUB_RDREQ_CPC__CI                           = 0x085A;
constexpr unsigned int mmMC_HUB_RDREQ_CPF__CI                           = 0x085B;
constexpr unsigned int mmMC_HUB_RDREQ_CPG__CI                           = 0x0859;
constexpr unsigned int mmMC_HUB_RDREQ_CP__SI                            = 0x0859;
constexpr unsigned int mmMC_HUB_RDREQ_CREDITS                           = 0x0844;
constexpr unsigned int mmMC_HUB_RDREQ_CREDITS2                          = 0x0845;
constexpr unsigned int mmMC_HUB_RDREQ_DMIF_LIMIT                        = 0x0848;
constexpr unsigned int mmMC_HUB_RDREQ_DMIF__CI                          = 0x0865;
constexpr unsigned int mmMC_HUB_RDREQ_DMIF__SI                          = 0x0863;
constexpr unsigned int mmMC_HUB_RDREQ_GBL0                              = 0x0856;
constexpr unsigned int mmMC_HUB_RDREQ_GBL1                              = 0x0857;
constexpr unsigned int mmMC_HUB_RDREQ_HDP__CI                           = 0x085E;
constexpr unsigned int mmMC_HUB_RDREQ_HDP__SI                           = 0x085B;
constexpr unsigned int mmMC_HUB_RDREQ_IA0__CI                           = 0x084F;
constexpr unsigned int mmMC_HUB_RDREQ_IA1__CI                           = 0x0850;
constexpr unsigned int mmMC_HUB_RDREQ_IA__CI                            = 0x0864;
constexpr unsigned int mmMC_HUB_RDREQ_MCDW                              = 0x0851;
constexpr unsigned int mmMC_HUB_RDREQ_MCDX                              = 0x0852;
constexpr unsigned int mmMC_HUB_RDREQ_MCDY                              = 0x0853;
constexpr unsigned int mmMC_HUB_RDREQ_MCDZ                              = 0x0854;
constexpr unsigned int mmMC_HUB_RDREQ_MCIF__CI                          = 0x0866;
constexpr unsigned int mmMC_HUB_RDREQ_MCIF__SI                          = 0x0864;
constexpr unsigned int mmMC_HUB_RDREQ_RLC__CI                           = 0x085F;
constexpr unsigned int mmMC_HUB_RDREQ_RLC__SI                           = 0x085D;
constexpr unsigned int mmMC_HUB_RDREQ_SAM__CI                           = 0x0889;
constexpr unsigned int mmMC_HUB_RDREQ_SDMA0__CI                         = 0x085C;
constexpr unsigned int mmMC_HUB_RDREQ_SDMA1__CI                         = 0x085D;
constexpr unsigned int mmMC_HUB_RDREQ_SEM__CI                           = 0x0860;
constexpr unsigned int mmMC_HUB_RDREQ_SEM__SI                           = 0x085E;
constexpr unsigned int mmMC_HUB_RDREQ_SIP                               = 0x0855;
constexpr unsigned int mmMC_HUB_RDREQ_SMU                               = 0x0858;
constexpr unsigned int mmMC_HUB_RDREQ_STATUS                            = 0x0839;
constexpr unsigned int mmMC_HUB_RDREQ_UMC__CI                           = 0x0862;
constexpr unsigned int mmMC_HUB_RDREQ_UMC__SI                           = 0x0860;
constexpr unsigned int mmMC_HUB_RDREQ_UVD__CI                           = 0x0863;
constexpr unsigned int mmMC_HUB_RDREQ_UVD__SI                           = 0x0861;
constexpr unsigned int mmMC_HUB_RDREQ_VCEU__CI                          = 0x0868;
constexpr unsigned int mmMC_HUB_RDREQ_VCEU__SI                          = 0x0866;
constexpr unsigned int mmMC_HUB_RDREQ_VCE__CI                           = 0x0861;
constexpr unsigned int mmMC_HUB_RDREQ_VCE__SI                           = 0x085F;
constexpr unsigned int mmMC_HUB_RDREQ_VMC__CI                           = 0x0867;
constexpr unsigned int mmMC_HUB_RDREQ_VMC__SI                           = 0x0865;
constexpr unsigned int mmMC_HUB_RDREQ_WTM_CNTL                          = 0x083D;
constexpr unsigned int mmMC_HUB_RDREQ_XDMAM__CI                         = 0x0886;
constexpr unsigned int mmMC_HUB_RDREQ_XDMAM__SI                         = 0x0882;
constexpr unsigned int mmMC_HUB_SHARED_DAGB_DLY                         = 0x0846;
constexpr unsigned int mmMC_HUB_WDP_ACPG__CI                            = 0x088A;
constexpr unsigned int mmMC_HUB_WDP_ACPO__CI                            = 0x088B;
constexpr unsigned int mmMC_HUB_WDP_BP                                  = 0x0837;
constexpr unsigned int mmMC_HUB_WDP_CNTL                                = 0x0835;
constexpr unsigned int mmMC_HUB_WDP_CPC__CI                             = 0x086F;
constexpr unsigned int mmMC_HUB_WDP_CPF__CI                             = 0x0870;
constexpr unsigned int mmMC_HUB_WDP_CPG__CI                             = 0x086E;
constexpr unsigned int mmMC_HUB_WDP_CP__SI                              = 0x086C;
constexpr unsigned int mmMC_HUB_WDP_CREDITS                             = 0x083F;
constexpr unsigned int mmMC_HUB_WDP_ERR                                 = 0x0836;
constexpr unsigned int mmMC_HUB_WDP_GBL0                                = 0x0841;
constexpr unsigned int mmMC_HUB_WDP_GBL1                                = 0x0842;
constexpr unsigned int mmMC_HUB_WDP_HDP__CI                             = 0x087C;
constexpr unsigned int mmMC_HUB_WDP_HDP__SI                             = 0x0879;
constexpr unsigned int mmMC_HUB_WDP_IH__CI                              = 0x0875;
constexpr unsigned int mmMC_HUB_WDP_IH__SI                              = 0x0872;
constexpr unsigned int mmMC_HUB_WDP_MCDW__CI                            = 0x0869;
constexpr unsigned int mmMC_HUB_WDP_MCDW__SI                            = 0x0867;
constexpr unsigned int mmMC_HUB_WDP_MCDX__CI                            = 0x086A;
constexpr unsigned int mmMC_HUB_WDP_MCDX__SI                            = 0x0868;
constexpr unsigned int mmMC_HUB_WDP_MCDY__CI                            = 0x086B;
constexpr unsigned int mmMC_HUB_WDP_MCDY__SI                            = 0x0869;
constexpr unsigned int mmMC_HUB_WDP_MCDZ__CI                            = 0x086C;
constexpr unsigned int mmMC_HUB_WDP_MCDZ__SI                            = 0x086A;
constexpr unsigned int mmMC_HUB_WDP_MCIF__CI                            = 0x0872;
constexpr unsigned int mmMC_HUB_WDP_MCIF__SI                            = 0x086F;
constexpr unsigned int mmMC_HUB_WDP_MGPU__SI__CI                        = 0x0843;
constexpr unsigned int mmMC_HUB_WDP_MGPU2__SI__CI                       = 0x0840;
constexpr unsigned int mmMC_HUB_WDP_RLC__CI                             = 0x0876;
constexpr unsigned int mmMC_HUB_WDP_RLC__SI                             = 0x0873;
constexpr unsigned int mmMC_HUB_WDP_SAM__CI                             = 0x088C;
constexpr unsigned int mmMC_HUB_WDP_SDMA0__CI                           = 0x087D;
constexpr unsigned int mmMC_HUB_WDP_SDMA1__CI                           = 0x087E;
constexpr unsigned int mmMC_HUB_WDP_SEM__CI                             = 0x0877;
constexpr unsigned int mmMC_HUB_WDP_SEM__SI                             = 0x0874;
constexpr unsigned int mmMC_HUB_WDP_SH0__CI                             = 0x0871;
constexpr unsigned int mmMC_HUB_WDP_SH0__SI                             = 0x086E;
constexpr unsigned int mmMC_HUB_WDP_SH1__CI                             = 0x0879;
constexpr unsigned int mmMC_HUB_WDP_SH1__SI                             = 0x0876;
constexpr unsigned int mmMC_HUB_WDP_SH2__CI__VI                         = 0x084D;
constexpr unsigned int mmMC_HUB_WDP_SH3__CI__VI                         = 0x084E;
constexpr unsigned int mmMC_HUB_WDP_SIP__CI                             = 0x086D;
constexpr unsigned int mmMC_HUB_WDP_SIP__SI                             = 0x086B;
constexpr unsigned int mmMC_HUB_WDP_SMU__CI                             = 0x0878;
constexpr unsigned int mmMC_HUB_WDP_SMU__SI                             = 0x0875;
constexpr unsigned int mmMC_HUB_WDP_STATUS                              = 0x0838;
constexpr unsigned int mmMC_HUB_WDP_UMC__CI                             = 0x087A;
constexpr unsigned int mmMC_HUB_WDP_UMC__SI                             = 0x0877;
constexpr unsigned int mmMC_HUB_WDP_UVD__CI                             = 0x087B;
constexpr unsigned int mmMC_HUB_WDP_UVD__SI                             = 0x0878;
constexpr unsigned int mmMC_HUB_WDP_VCEU__CI                            = 0x0883;
constexpr unsigned int mmMC_HUB_WDP_VCEU__SI                            = 0x087F;
constexpr unsigned int mmMC_HUB_WDP_VCE__CI                             = 0x0873;
constexpr unsigned int mmMC_HUB_WDP_VCE__SI                             = 0x0870;
constexpr unsigned int mmMC_HUB_WDP_WTM_CNTL                            = 0x083E;
constexpr unsigned int mmMC_HUB_WDP_XDMAM__CI                           = 0x0884;
constexpr unsigned int mmMC_HUB_WDP_XDMAM__SI                           = 0x0880;
constexpr unsigned int mmMC_HUB_WDP_XDMA__CI                            = 0x0885;
constexpr unsigned int mmMC_HUB_WDP_XDMA__SI                            = 0x0881;
constexpr unsigned int mmMC_HUB_WDP_XDP__CI                             = 0x0874;
constexpr unsigned int mmMC_HUB_WDP_XDP__SI                             = 0x0871;
constexpr unsigned int mmMC_HUB_WRRET_CNTL                              = 0x083C;
constexpr unsigned int mmMC_HUB_WRRET_MCDW__CI                          = 0x087F;
constexpr unsigned int mmMC_HUB_WRRET_MCDW__SI                          = 0x087B;
constexpr unsigned int mmMC_HUB_WRRET_MCDX__CI                          = 0x0880;
constexpr unsigned int mmMC_HUB_WRRET_MCDX__SI                          = 0x087C;
constexpr unsigned int mmMC_HUB_WRRET_MCDY__CI                          = 0x0881;
constexpr unsigned int mmMC_HUB_WRRET_MCDY__SI                          = 0x087D;
constexpr unsigned int mmMC_HUB_WRRET_MCDZ__CI                          = 0x0882;
constexpr unsigned int mmMC_HUB_WRRET_MCDZ__SI                          = 0x087E;
constexpr unsigned int mmMC_HUB_WRRET_STATUS                            = 0x083A;
constexpr unsigned int mmMC_IMP_CNTL__SI__CI                            = 0x0A36;
constexpr unsigned int mmMC_IMP_DEBUG__SI__CI                           = 0x0A37;
constexpr unsigned int mmMC_IMP_DQ_STATUS__SI__CI                       = 0x0ABC;
constexpr unsigned int mmMC_IMP_STATUS__SI__CI                          = 0x0A38;
constexpr unsigned int mmMC_IO_APHY_STR_CNTL_D0__SI__CI                 = 0x0A97;
constexpr unsigned int mmMC_IO_APHY_STR_CNTL_D1__SI__CI                 = 0x0A98;
constexpr unsigned int mmMC_IO_CDRCNTL1_D0__SI__CI                      = 0x0ADD;
constexpr unsigned int mmMC_IO_CDRCNTL1_D1__SI__CI                      = 0x0ADE;
constexpr unsigned int mmMC_IO_CDRCNTL2_D0__SI__CI                      = 0x0AE4;
constexpr unsigned int mmMC_IO_CDRCNTL2_D1__SI__CI                      = 0x0AE5;
constexpr unsigned int mmMC_IO_CDRCNTL_D0__SI__CI                       = 0x0A55;
constexpr unsigned int mmMC_IO_CDRCNTL_D1__SI__CI                       = 0x0A56;
constexpr unsigned int mmMC_IO_DPHY_STR_CNTL_D0__SI__CI                 = 0x0A4E;
constexpr unsigned int mmMC_IO_DPHY_STR_CNTL_D1__SI__CI                 = 0x0A54;
constexpr unsigned int mmMC_IO_PAD_CNTL__SI__CI                         = 0x0A73;
constexpr unsigned int mmMC_IO_PAD_CNTL_D0__SI__CI                      = 0x0A74;
constexpr unsigned int mmMC_IO_PAD_CNTL_D1__SI__CI                      = 0x0A75;
constexpr unsigned int mmMC_IO_RXCNTL1_DPHY0_D0__SI__CI                 = 0x0ADF;
constexpr unsigned int mmMC_IO_RXCNTL1_DPHY0_D1__SI__CI                 = 0x0AE1;
constexpr unsigned int mmMC_IO_RXCNTL1_DPHY1_D0__SI__CI                 = 0x0AE0;
constexpr unsigned int mmMC_IO_RXCNTL1_DPHY1_D1__SI__CI                 = 0x0AE2;
constexpr unsigned int mmMC_IO_RXCNTL_DPHY0_D0__SI__CI                  = 0x0A4C;
constexpr unsigned int mmMC_IO_RXCNTL_DPHY0_D1__SI__CI                  = 0x0A52;
constexpr unsigned int mmMC_IO_RXCNTL_DPHY1_D0__SI__CI                  = 0x0A4D;
constexpr unsigned int mmMC_IO_RXCNTL_DPHY1_D1__SI__CI                  = 0x0A53;
constexpr unsigned int mmMC_IO_TXCNTL_APHY_D0__SI__CI                   = 0x0A4B;
constexpr unsigned int mmMC_IO_TXCNTL_APHY_D1__SI__CI                   = 0x0A51;
constexpr unsigned int mmMC_IO_TXCNTL_DPHY0_D0__SI__CI                  = 0x0A49;
constexpr unsigned int mmMC_IO_TXCNTL_DPHY0_D1__SI__CI                  = 0x0A4F;
constexpr unsigned int mmMC_IO_TXCNTL_DPHY1_D0__SI__CI                  = 0x0A4A;
constexpr unsigned int mmMC_IO_TXCNTL_DPHY1_D1__SI__CI                  = 0x0A50;
constexpr unsigned int mmMC_MCBVM_PERFCOUNTER0_CFG__CI__VI              = 0x07C0;
constexpr unsigned int mmMC_MCBVM_PERFCOUNTER1_CFG__CI__VI              = 0x07C1;
constexpr unsigned int mmMC_MCBVM_PERFCOUNTER2_CFG__CI__VI              = 0x07C2;
constexpr unsigned int mmMC_MCBVM_PERFCOUNTER3_CFG__CI__VI              = 0x07C3;
constexpr unsigned int mmMC_MCBVM_PERFCOUNTER_HI__CI__VI                = 0x07AA;
constexpr unsigned int mmMC_MCBVM_PERFCOUNTER_LO__CI__VI                = 0x07A3;
constexpr unsigned int mmMC_MCBVM_PERFCOUNTER_RSLT_CNTL__CI__VI         = 0x07D1;
constexpr unsigned int mmMC_MCDVM_PERFCOUNTER0_CFG__CI__VI              = 0x07C4;
constexpr unsigned int mmMC_MCDVM_PERFCOUNTER1_CFG__CI__VI              = 0x07C5;
constexpr unsigned int mmMC_MCDVM_PERFCOUNTER2_CFG__CI__VI              = 0x07C6;
constexpr unsigned int mmMC_MCDVM_PERFCOUNTER3_CFG__CI__VI              = 0x07C7;
constexpr unsigned int mmMC_MCDVM_PERFCOUNTER_HI__CI__VI                = 0x07AB;
constexpr unsigned int mmMC_MCDVM_PERFCOUNTER_LO__CI__VI                = 0x07A4;
constexpr unsigned int mmMC_MCDVM_PERFCOUNTER_RSLT_CNTL__CI__VI         = 0x07D2;
constexpr unsigned int mmMC_MEM_POWER_LS                                = 0x082A;
constexpr unsigned int mmMC_NPL_STATUS__SI__CI                          = 0x0A76;
constexpr unsigned int mmMC_PHY_TIMING_2__SI__CI                        = 0x0ACE;
constexpr unsigned int mmMC_PHY_TIMING_D0__SI__CI                       = 0x0ACC;
constexpr unsigned int mmMC_PHY_TIMING_D1__SI__CI                       = 0x0ACD;
constexpr unsigned int mmMC_PMG_AUTO_CFG__SI__CI                        = 0x0A35;
constexpr unsigned int mmMC_PMG_AUTO_CMD__SI__CI                        = 0x0A34;
constexpr unsigned int mmMC_RD_CB                                       = 0x0981;
constexpr unsigned int mmMC_RD_DB                                       = 0x0982;
constexpr unsigned int mmMC_RD_GRP_EXT                                  = 0x0978;
constexpr unsigned int mmMC_RD_GRP_GFX                                  = 0x0803;
constexpr unsigned int mmMC_RD_GRP_LCL                                  = 0x098A;
constexpr unsigned int mmMC_RD_GRP_OTH                                  = 0x0807;
constexpr unsigned int mmMC_RD_GRP_SYS                                  = 0x0805;
constexpr unsigned int mmMC_RD_HUB                                      = 0x0985;
constexpr unsigned int mmMC_RD_TC0                                      = 0x0983;
constexpr unsigned int mmMC_RD_TC1                                      = 0x0984;
constexpr unsigned int mmMC_RPB_ARB_CNTL                                = 0x0951;
constexpr unsigned int mmMC_RPB_BIF_CNTL                                = 0x0952;
constexpr unsigned int mmMC_RPB_CID_QUEUE_EX                            = 0x095A;
constexpr unsigned int mmMC_RPB_CID_QUEUE_EX_DATA                       = 0x095B;
constexpr unsigned int mmMC_RPB_CID_QUEUE_RD                            = 0x0957;
constexpr unsigned int mmMC_RPB_CID_QUEUE_WR                            = 0x0956;
constexpr unsigned int mmMC_RPB_CONF                                    = 0x094D;
constexpr unsigned int mmMC_RPB_DBG1                                    = 0x094F;
constexpr unsigned int mmMC_RPB_EFF_CNTL                                = 0x0950;
constexpr unsigned int mmMC_RPB_IF_CONF                                 = 0x094E;
constexpr unsigned int mmMC_RPB_PERFCOUNTER0_CFG__CI__VI                = 0x07B8;
constexpr unsigned int mmMC_RPB_PERFCOUNTER1_CFG__CI__VI                = 0x07B9;
constexpr unsigned int mmMC_RPB_PERFCOUNTER2_CFG__CI__VI                = 0x07BA;
constexpr unsigned int mmMC_RPB_PERFCOUNTER3_CFG__CI__VI                = 0x07BB;
constexpr unsigned int mmMC_RPB_PERFCOUNTER_HI__CI__VI                  = 0x07AC;
constexpr unsigned int mmMC_RPB_PERFCOUNTER_LO__CI__VI                  = 0x07A2;
constexpr unsigned int mmMC_RPB_PERFCOUNTER_RSLT_CNTL__CI__VI           = 0x07D0;
constexpr unsigned int mmMC_RPB_PERF_COUNTER_CNTL                       = 0x0958;
constexpr unsigned int mmMC_RPB_PERF_COUNTER_STATUS                     = 0x0959;
constexpr unsigned int mmMC_RPB_RD_SWITCH_CNTL                          = 0x0955;
constexpr unsigned int mmMC_RPB_WR_COMBINE_CNTL                         = 0x0954;
constexpr unsigned int mmMC_RPB_WR_SWITCH_CNTL                          = 0x0953;
constexpr unsigned int mmMC_SEQ_BIT_REMAP_B0_D0__SI__CI                 = 0x0AA3;
constexpr unsigned int mmMC_SEQ_BIT_REMAP_B0_D1__SI__CI                 = 0x0AA7;
constexpr unsigned int mmMC_SEQ_BIT_REMAP_B1_D0__SI__CI                 = 0x0AA4;
constexpr unsigned int mmMC_SEQ_BIT_REMAP_B1_D1__SI__CI                 = 0x0AA8;
constexpr unsigned int mmMC_SEQ_BIT_REMAP_B2_D0__SI__CI                 = 0x0AA5;
constexpr unsigned int mmMC_SEQ_BIT_REMAP_B2_D1__SI__CI                 = 0x0AA9;
constexpr unsigned int mmMC_SEQ_BIT_REMAP_B3_D0__SI__CI                 = 0x0AA6;
constexpr unsigned int mmMC_SEQ_BIT_REMAP_B3_D1__SI__CI                 = 0x0AAA;
constexpr unsigned int mmMC_SEQ_BYTE_REMAP_D0__SI__CI                   = 0x0A93;
constexpr unsigned int mmMC_SEQ_BYTE_REMAP_D1__SI__CI                   = 0x0A94;
constexpr unsigned int mmMC_SEQ_CNTL_3__CI                              = 0x0D80;
constexpr unsigned int mmMC_SEQ_DLL_STBY_LP__CI                         = 0x0D8F;
constexpr unsigned int mmMC_SEQ_DLL_STBY__CI                            = 0x0D8E;
constexpr unsigned int mmMC_SEQ_DRAM_ERROR_INSERTION__SI__CI            = 0x0ACB;
constexpr unsigned int mmMC_SEQ_G5PDX_CMD0_LP__CI                       = 0x0D84;
constexpr unsigned int mmMC_SEQ_G5PDX_CMD0__CI                          = 0x0D83;
constexpr unsigned int mmMC_SEQ_G5PDX_CMD1_LP__CI                       = 0x0D86;
constexpr unsigned int mmMC_SEQ_G5PDX_CMD1__CI                          = 0x0D85;
constexpr unsigned int mmMC_SEQ_G5PDX_CTRL_LP__CI                       = 0x0D82;
constexpr unsigned int mmMC_SEQ_G5PDX_CTRL__CI                          = 0x0D81;
constexpr unsigned int mmMC_SEQ_IO_RDBI__SI__CI                         = 0x0AB4;
constexpr unsigned int mmMC_SEQ_IO_REDC__SI__CI                         = 0x0AB5;
constexpr unsigned int mmMC_SEQ_IO_RESERVE_D0__SI__CI                   = 0x0AB7;
constexpr unsigned int mmMC_SEQ_IO_RESERVE_D1__SI__CI                   = 0x0AB8;
constexpr unsigned int mmMC_SEQ_IO_RWORD0__SI__CI                       = 0x0AAC;
constexpr unsigned int mmMC_SEQ_IO_RWORD1__SI__CI                       = 0x0AAD;
constexpr unsigned int mmMC_SEQ_IO_RWORD2__SI__CI                       = 0x0AAE;
constexpr unsigned int mmMC_SEQ_IO_RWORD3__SI__CI                       = 0x0AAF;
constexpr unsigned int mmMC_SEQ_IO_RWORD4__SI__CI                       = 0x0AB0;
constexpr unsigned int mmMC_SEQ_IO_RWORD5__SI__CI                       = 0x0AB1;
constexpr unsigned int mmMC_SEQ_IO_RWORD6__SI__CI                       = 0x0AB2;
constexpr unsigned int mmMC_SEQ_IO_RWORD7__SI__CI                       = 0x0AB3;
constexpr unsigned int mmMC_SEQ_MPLL_OVERRIDE__SI__CI                   = 0x0A22;
constexpr unsigned int mmMC_SEQ_PERF_CNTL__SI__CI                       = 0x0A77;
constexpr unsigned int mmMC_SEQ_PERF_CNTL_1__SI__CI                     = 0x0AFD;
constexpr unsigned int mmMC_SEQ_PERF_SEQ_CNT_A_I0__SI__CI               = 0x0A79;
constexpr unsigned int mmMC_SEQ_PERF_SEQ_CNT_A_I1__SI__CI               = 0x0A7A;
constexpr unsigned int mmMC_SEQ_PERF_SEQ_CNT_B_I0__SI__CI               = 0x0A7B;
constexpr unsigned int mmMC_SEQ_PERF_SEQ_CNT_B_I1__SI__CI               = 0x0A7C;
constexpr unsigned int mmMC_SEQ_PERF_SEQ_CNT_C_I0__SI__CI               = 0x0AD9;
constexpr unsigned int mmMC_SEQ_PERF_SEQ_CNT_C_I1__SI__CI               = 0x0ADA;
constexpr unsigned int mmMC_SEQ_PERF_SEQ_CNT_D_I0__SI__CI               = 0x0ADB;
constexpr unsigned int mmMC_SEQ_PERF_SEQ_CNT_D_I1__SI__CI               = 0x0ADC;
constexpr unsigned int mmMC_SEQ_PERF_SEQ_CTL__SI__CI                    = 0x0A78;
constexpr unsigned int mmMC_SEQ_PHYREG_BCAST__CI                        = 0x0D89;
constexpr unsigned int mmMC_SEQ_PMG_CMD_EMRS_LP__SI__CI                 = 0x0AA1;
constexpr unsigned int mmMC_SEQ_PMG_CMD_MRS1_LP__SI__CI                 = 0x0AD2;
constexpr unsigned int mmMC_SEQ_PMG_CMD_MRS2_LP__SI__CI                 = 0x0AD8;
constexpr unsigned int mmMC_SEQ_PMG_CMD_MRS_LP__SI__CI                  = 0x0AA2;
constexpr unsigned int mmMC_SEQ_PMG_DVS_CMD_LP__CI                      = 0x0D8D;
constexpr unsigned int mmMC_SEQ_PMG_DVS_CMD__CI                         = 0x0D8C;
constexpr unsigned int mmMC_SEQ_PMG_DVS_CTL_LP__CI                      = 0x0D8B;
constexpr unsigned int mmMC_SEQ_PMG_DVS_CTL__CI                         = 0x0D8A;
constexpr unsigned int mmMC_SEQ_PMG_PG_HWCNTL__SI__CI                   = 0x0AB9;
constexpr unsigned int mmMC_SEQ_PMG_PG_SWCNTL_0__SI__CI                 = 0x0ABA;
constexpr unsigned int mmMC_SEQ_PMG_PG_SWCNTL_1__SI__CI                 = 0x0ABB;
constexpr unsigned int mmMC_SEQ_RXFRAMING_BYTE0_D0__SI__CI              = 0x0A67;
constexpr unsigned int mmMC_SEQ_RXFRAMING_BYTE0_D1__SI__CI              = 0x0A6D;
constexpr unsigned int mmMC_SEQ_RXFRAMING_BYTE1_D0__SI__CI              = 0x0A68;
constexpr unsigned int mmMC_SEQ_RXFRAMING_BYTE1_D1__SI__CI              = 0x0A6E;
constexpr unsigned int mmMC_SEQ_RXFRAMING_BYTE2_D0__SI__CI              = 0x0A69;
constexpr unsigned int mmMC_SEQ_RXFRAMING_BYTE2_D1__SI__CI              = 0x0A6F;
constexpr unsigned int mmMC_SEQ_RXFRAMING_BYTE3_D0__SI__CI              = 0x0A6A;
constexpr unsigned int mmMC_SEQ_RXFRAMING_BYTE3_D1__SI__CI              = 0x0A70;
constexpr unsigned int mmMC_SEQ_RXFRAMING_DBI_D0__SI__CI                = 0x0A6B;
constexpr unsigned int mmMC_SEQ_RXFRAMING_DBI_D1__SI__CI                = 0x0A71;
constexpr unsigned int mmMC_SEQ_RXFRAMING_EDC_D0__SI__CI                = 0x0A6C;
constexpr unsigned int mmMC_SEQ_RXFRAMING_EDC_D1__SI__CI                = 0x0A72;
constexpr unsigned int mmMC_SEQ_SREG_READ__CI                           = 0x0D87;
constexpr unsigned int mmMC_SEQ_SREG_STATUS__CI                         = 0x0D88;
constexpr unsigned int mmMC_SEQ_TCG_CNTL__SI__CI                        = 0x0ABD;
constexpr unsigned int mmMC_SEQ_TRAIN_EDC_THRESHOLD__SI__CI             = 0x0A3B;
constexpr unsigned int mmMC_SEQ_TRAIN_EDC_THRESHOLD2__SI__CI            = 0x0AFE;
constexpr unsigned int mmMC_SEQ_TRAIN_EDC_THRESHOLD3__SI__CI            = 0x0AFF;
constexpr unsigned int mmMC_SEQ_TRAIN_TIMING__SI__CI                    = 0x0A40;
constexpr unsigned int mmMC_SEQ_TSM_BCNT__SI__CI                        = 0x0AC2;
constexpr unsigned int mmMC_SEQ_TSM_CTRL__SI__CI                        = 0x0ABE;
constexpr unsigned int mmMC_SEQ_TSM_DBI__SI__CI                         = 0x0AC6;
constexpr unsigned int mmMC_SEQ_TSM_DEBUG_DATA__SI__CI                  = 0x0AD0;
constexpr unsigned int mmMC_SEQ_TSM_DEBUG_INDEX__SI__CI                 = 0x0ACF;
constexpr unsigned int mmMC_SEQ_TSM_EDC__SI__CI                         = 0x0AC5;
constexpr unsigned int mmMC_SEQ_TSM_FLAG__SI__CI                        = 0x0AC3;
constexpr unsigned int mmMC_SEQ_TSM_GCNT__SI__CI                        = 0x0ABF;
constexpr unsigned int mmMC_SEQ_TSM_MISC__SI__CI                        = 0x0AE6;
constexpr unsigned int mmMC_SEQ_TSM_NCNT__SI__CI                        = 0x0AC1;
constexpr unsigned int mmMC_SEQ_TSM_OCNT__SI__CI                        = 0x0AC0;
constexpr unsigned int mmMC_SEQ_TSM_UPDATE__SI__CI                      = 0x0AC4;
constexpr unsigned int mmMC_SEQ_TSM_WCDR__SI__CI                        = 0x0AE3;
constexpr unsigned int mmMC_SEQ_TXFRAMING_BYTE0_D0__SI__CI              = 0x0A58;
constexpr unsigned int mmMC_SEQ_TXFRAMING_BYTE0_D1__SI__CI              = 0x0A60;
constexpr unsigned int mmMC_SEQ_TXFRAMING_BYTE1_D0__SI__CI              = 0x0A59;
constexpr unsigned int mmMC_SEQ_TXFRAMING_BYTE1_D1__SI__CI              = 0x0A61;
constexpr unsigned int mmMC_SEQ_TXFRAMING_BYTE2_D0__SI__CI              = 0x0A5A;
constexpr unsigned int mmMC_SEQ_TXFRAMING_BYTE2_D1__SI__CI              = 0x0A62;
constexpr unsigned int mmMC_SEQ_TXFRAMING_BYTE3_D0__SI__CI              = 0x0A5B;
constexpr unsigned int mmMC_SEQ_TXFRAMING_BYTE3_D1__SI__CI              = 0x0A63;
constexpr unsigned int mmMC_SEQ_TXFRAMING_DBI_D0__SI__CI                = 0x0A5C;
constexpr unsigned int mmMC_SEQ_TXFRAMING_DBI_D1__SI__CI                = 0x0A64;
constexpr unsigned int mmMC_SEQ_TXFRAMING_EDC_D0__SI__CI                = 0x0A5D;
constexpr unsigned int mmMC_SEQ_TXFRAMING_EDC_D1__SI__CI                = 0x0A65;
constexpr unsigned int mmMC_SEQ_TXFRAMING_FCK_D0__SI__CI                = 0x0A5E;
constexpr unsigned int mmMC_SEQ_TXFRAMING_FCK_D1__SI__CI                = 0x0A66;
constexpr unsigned int mmMC_SEQ_VENDOR_ID_I0__SI__CI                    = 0x0A7E;
constexpr unsigned int mmMC_SEQ_VENDOR_ID_I1__SI__CI                    = 0x0A7F;
constexpr unsigned int mmMC_SEQ_WCDR_CTRL__SI__CI                       = 0x0A39;
constexpr unsigned int mmMC_SEQ_WR_CTL_2__SI__CI                        = 0x0AD5;
constexpr unsigned int mmMC_SEQ_WR_CTL_2_LP__SI__CI                     = 0x0AD6;
constexpr unsigned int mmMC_SHARED_BLACKOUT_CNTL                        = 0x082B;
constexpr unsigned int mmMC_SHARED_CHMAP                                = 0x0801;
constexpr unsigned int mmMC_SHARED_CHREMAP                              = 0x0802;
constexpr unsigned int mmMC_TRAIN_EDCCDR_R_D0__SI__CI                   = 0x0A41;
constexpr unsigned int mmMC_TRAIN_EDCCDR_R_D1__SI__CI                   = 0x0A42;
constexpr unsigned int mmMC_TRAIN_EDC_STATUS_D0__SI__CI                 = 0x0A45;
constexpr unsigned int mmMC_TRAIN_EDC_STATUS_D1__SI__CI                 = 0x0A48;
constexpr unsigned int mmMC_TRAIN_PRBSERR_0_D0__SI__CI                  = 0x0A43;
constexpr unsigned int mmMC_TRAIN_PRBSERR_0_D1__SI__CI                  = 0x0A46;
constexpr unsigned int mmMC_TRAIN_PRBSERR_1_D0__SI__CI                  = 0x0A44;
constexpr unsigned int mmMC_TRAIN_PRBSERR_1_D1__SI__CI                  = 0x0A47;
constexpr unsigned int mmMC_TRAIN_PRBSERR_2_D0__SI__CI                  = 0x0AFB;
constexpr unsigned int mmMC_TRAIN_PRBSERR_2_D1__SI__CI                  = 0x0AFC;
constexpr unsigned int mmMC_VM_AGP_BASE                                 = 0x080C;
constexpr unsigned int mmMC_VM_AGP_BOT                                  = 0x080B;
constexpr unsigned int mmMC_VM_AGP_TOP                                  = 0x080A;
constexpr unsigned int mmMC_VM_DC_WRITE_CNTL                            = 0x0810;
constexpr unsigned int mmMC_VM_DC_WRITE_HIT_REGION_0_HIGH_ADDR          = 0x0815;
constexpr unsigned int mmMC_VM_DC_WRITE_HIT_REGION_0_LOW_ADDR           = 0x0811;
constexpr unsigned int mmMC_VM_DC_WRITE_HIT_REGION_1_HIGH_ADDR          = 0x0816;
constexpr unsigned int mmMC_VM_DC_WRITE_HIT_REGION_1_LOW_ADDR           = 0x0812;
constexpr unsigned int mmMC_VM_DC_WRITE_HIT_REGION_2_HIGH_ADDR          = 0x0817;
constexpr unsigned int mmMC_VM_DC_WRITE_HIT_REGION_2_LOW_ADDR           = 0x0813;
constexpr unsigned int mmMC_VM_DC_WRITE_HIT_REGION_3_HIGH_ADDR          = 0x0818;
constexpr unsigned int mmMC_VM_DC_WRITE_HIT_REGION_3_LOW_ADDR           = 0x0814;
constexpr unsigned int mmMC_VM_FB_LOCATION                              = 0x0809;
constexpr unsigned int mmMC_VM_FB_OFFSET                                = 0x081A;
constexpr unsigned int mmMC_VM_L2_PERFCOUNTER0_CFG__CI__VI              = 0x07CC;
constexpr unsigned int mmMC_VM_L2_PERFCOUNTER1_CFG__CI__VI              = 0x07CD;
constexpr unsigned int mmMC_VM_L2_PERFCOUNTER_HI__CI__VI                = 0x07AD;
constexpr unsigned int mmMC_VM_L2_PERFCOUNTER_LO__CI__VI                = 0x07A5;
constexpr unsigned int mmMC_VM_L2_PERFCOUNTER_RSLT_CNTL__CI__VI         = 0x07D3;
constexpr unsigned int mmMC_VM_MB_L1_TLB0_DEBUG                         = 0x0891;
constexpr unsigned int mmMC_VM_MB_L1_TLB0_STATUS                        = 0x0895;
constexpr unsigned int mmMC_VM_MB_L1_TLB1_STATUS                        = 0x0896;
constexpr unsigned int mmMC_VM_MB_L1_TLB2_DEBUG                         = 0x0893;
constexpr unsigned int mmMC_VM_MB_L1_TLB2_STATUS                        = 0x0897;
constexpr unsigned int mmMC_VM_MB_L1_TLB3_DEBUG                         = 0x08A5;
constexpr unsigned int mmMC_VM_MB_L1_TLB3_STATUS                        = 0x08A6;
constexpr unsigned int mmMC_VM_MB_L2ARBITER_L2_CREDITS                  = 0x08A1;
constexpr unsigned int mmMC_VM_MD_L1_TLB0_DEBUG                         = 0x0998;
constexpr unsigned int mmMC_VM_MD_L1_TLB0_STATUS                        = 0x099B;
constexpr unsigned int mmMC_VM_MD_L1_TLB1_DEBUG                         = 0x0999;
constexpr unsigned int mmMC_VM_MD_L1_TLB1_STATUS                        = 0x099C;
constexpr unsigned int mmMC_VM_MD_L1_TLB2_DEBUG                         = 0x099A;
constexpr unsigned int mmMC_VM_MD_L1_TLB2_STATUS                        = 0x099D;
constexpr unsigned int mmMC_VM_MD_L1_TLB3_DEBUG                         = 0x09A7;
constexpr unsigned int mmMC_VM_MD_L1_TLB3_STATUS                        = 0x09A8;
constexpr unsigned int mmMC_VM_MD_L2ARBITER_L2_CREDITS                  = 0x09A4;
constexpr unsigned int mmMC_VM_MX_L1_TLB_CNTL                           = 0x0819;
constexpr unsigned int mmMC_VM_STEERING__CI__VI                         = 0x081B;
constexpr unsigned int mmMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR             = 0x080F;
constexpr unsigned int mmMC_VM_SYSTEM_APERTURE_HIGH_ADDR                = 0x080E;
constexpr unsigned int mmMC_VM_SYSTEM_APERTURE_LOW_ADDR                 = 0x080D;
constexpr unsigned int mmMC_WR_CB                                       = 0x0986;
constexpr unsigned int mmMC_WR_DB                                       = 0x0987;
constexpr unsigned int mmMC_WR_GRP_EXT                                  = 0x0979;
constexpr unsigned int mmMC_WR_GRP_GFX                                  = 0x0804;
constexpr unsigned int mmMC_WR_GRP_LCL                                  = 0x098B;
constexpr unsigned int mmMC_WR_GRP_OTH                                  = 0x0808;
constexpr unsigned int mmMC_WR_GRP_SYS                                  = 0x0806;
constexpr unsigned int mmMC_WR_HUB                                      = 0x0988;
constexpr unsigned int mmMC_WR_TC0                                      = 0x097B;
constexpr unsigned int mmMC_WR_TC1                                      = 0x097C;
constexpr unsigned int mmMC_XBAR_ADDR_DEC                               = 0x0C80;
constexpr unsigned int mmMC_XBAR_ARB                                    = 0x0C8D;
constexpr unsigned int mmMC_XBAR_ARB_MAX_BURST                          = 0x0C8E;
constexpr unsigned int mmMC_XBAR_CHTRIREMAP                             = 0x0C8B;
constexpr unsigned int mmMC_XBAR_PERF_MON_CNTL0__SI__CI                 = 0x0C8F;
constexpr unsigned int mmMC_XBAR_PERF_MON_CNTL1__SI__CI                 = 0x0C90;
constexpr unsigned int mmMC_XBAR_PERF_MON_CNTL2__SI__CI                 = 0x0C91;
constexpr unsigned int mmMC_XBAR_PERF_MON_MAX_THSH__SI__CI              = 0x0C96;
constexpr unsigned int mmMC_XBAR_PERF_MON_RSLT0__SI__CI                 = 0x0C92;
constexpr unsigned int mmMC_XBAR_PERF_MON_RSLT1__SI__CI                 = 0x0C93;
constexpr unsigned int mmMC_XBAR_PERF_MON_RSLT2__SI__CI                 = 0x0C94;
constexpr unsigned int mmMC_XBAR_PERF_MON_RSLT3__SI__CI                 = 0x0C95;
constexpr unsigned int mmMC_XBAR_RDREQ_CREDIT                           = 0x0C83;
constexpr unsigned int mmMC_XBAR_RDREQ_PRI_CREDIT                       = 0x0C84;
constexpr unsigned int mmMC_XBAR_RDRET_CREDIT1                          = 0x0C87;
constexpr unsigned int mmMC_XBAR_RDRET_CREDIT2                          = 0x0C88;
constexpr unsigned int mmMC_XBAR_RDRET_PRI_CREDIT1                      = 0x0C89;
constexpr unsigned int mmMC_XBAR_RDRET_PRI_CREDIT2                      = 0x0C8A;
constexpr unsigned int mmMC_XBAR_REMOTE                                 = 0x0C81;
constexpr unsigned int mmMC_XBAR_SPARE0                                 = 0x0C97;
constexpr unsigned int mmMC_XBAR_SPARE1                                 = 0x0C98;
constexpr unsigned int mmMC_XBAR_TWOCHAN                                = 0x0C8C;
constexpr unsigned int mmMC_XBAR_WRREQ_CREDIT                           = 0x0C82;
constexpr unsigned int mmMC_XBAR_WRRET_CREDIT1                          = 0x0C85;
constexpr unsigned int mmMC_XBAR_WRRET_CREDIT2                          = 0x0C86;
constexpr unsigned int mmMC_XPB_CLG_CFG0                                = 0x08E9;
constexpr unsigned int mmMC_XPB_CLG_CFG1                                = 0x08EA;
constexpr unsigned int mmMC_XPB_CLG_CFG10                               = 0x08F3;
constexpr unsigned int mmMC_XPB_CLG_CFG11                               = 0x08F4;
constexpr unsigned int mmMC_XPB_CLG_CFG12                               = 0x08F5;
constexpr unsigned int mmMC_XPB_CLG_CFG13                               = 0x08F6;
constexpr unsigned int mmMC_XPB_CLG_CFG14                               = 0x08F7;
constexpr unsigned int mmMC_XPB_CLG_CFG15                               = 0x08F8;
constexpr unsigned int mmMC_XPB_CLG_CFG16                               = 0x08F9;
constexpr unsigned int mmMC_XPB_CLG_CFG17                               = 0x08FA;
constexpr unsigned int mmMC_XPB_CLG_CFG18                               = 0x08FB;
constexpr unsigned int mmMC_XPB_CLG_CFG19                               = 0x08FC;
constexpr unsigned int mmMC_XPB_CLG_CFG2                                = 0x08EB;
constexpr unsigned int mmMC_XPB_CLG_CFG20                               = 0x0928;
constexpr unsigned int mmMC_XPB_CLG_CFG21                               = 0x0929;
constexpr unsigned int mmMC_XPB_CLG_CFG22                               = 0x092A;
constexpr unsigned int mmMC_XPB_CLG_CFG23                               = 0x092B;
constexpr unsigned int mmMC_XPB_CLG_CFG24                               = 0x092C;
constexpr unsigned int mmMC_XPB_CLG_CFG25                               = 0x092D;
constexpr unsigned int mmMC_XPB_CLG_CFG26                               = 0x092E;
constexpr unsigned int mmMC_XPB_CLG_CFG27                               = 0x092F;
constexpr unsigned int mmMC_XPB_CLG_CFG28                               = 0x0930;
constexpr unsigned int mmMC_XPB_CLG_CFG29                               = 0x0931;
constexpr unsigned int mmMC_XPB_CLG_CFG3                                = 0x08EC;
constexpr unsigned int mmMC_XPB_CLG_CFG30                               = 0x0932;
constexpr unsigned int mmMC_XPB_CLG_CFG31                               = 0x0933;
constexpr unsigned int mmMC_XPB_CLG_CFG32                               = 0x0936;
constexpr unsigned int mmMC_XPB_CLG_CFG33                               = 0x0937;
constexpr unsigned int mmMC_XPB_CLG_CFG34                               = 0x0938;
constexpr unsigned int mmMC_XPB_CLG_CFG35                               = 0x0939;
constexpr unsigned int mmMC_XPB_CLG_CFG36                               = 0x093A;
constexpr unsigned int mmMC_XPB_CLG_CFG4                                = 0x08ED;
constexpr unsigned int mmMC_XPB_CLG_CFG5                                = 0x08EE;
constexpr unsigned int mmMC_XPB_CLG_CFG6                                = 0x08EF;
constexpr unsigned int mmMC_XPB_CLG_CFG7                                = 0x08F0;
constexpr unsigned int mmMC_XPB_CLG_CFG8                                = 0x08F1;
constexpr unsigned int mmMC_XPB_CLG_CFG9                                = 0x08F2;
constexpr unsigned int mmMC_XPB_CLG_EXTRA                               = 0x08FD;
constexpr unsigned int mmMC_XPB_CLG_EXTRA_RD                            = 0x0935;
constexpr unsigned int mmMC_XPB_CLK_GAT                                 = 0x091E;
constexpr unsigned int mmMC_XPB_INTF_CFG                                = 0x091F;
constexpr unsigned int mmMC_XPB_INTF_CFG2                               = 0x0934;
constexpr unsigned int mmMC_XPB_INTF_STS                                = 0x0920;
constexpr unsigned int mmMC_XPB_LB_ADDR                                 = 0x08FE;
constexpr unsigned int mmMC_XPB_MAP_INVERT_FLUSH_NUM_LSB                = 0x0923;
constexpr unsigned int mmMC_XPB_MISC_CFG                                = 0x0927;
constexpr unsigned int mmMC_XPB_P2P_BAR0                                = 0x0904;
constexpr unsigned int mmMC_XPB_P2P_BAR1                                = 0x0905;
constexpr unsigned int mmMC_XPB_P2P_BAR2                                = 0x0906;
constexpr unsigned int mmMC_XPB_P2P_BAR3                                = 0x0907;
constexpr unsigned int mmMC_XPB_P2P_BAR4                                = 0x0908;
constexpr unsigned int mmMC_XPB_P2P_BAR5                                = 0x0909;
constexpr unsigned int mmMC_XPB_P2P_BAR6                                = 0x090A;
constexpr unsigned int mmMC_XPB_P2P_BAR7                                = 0x090B;
constexpr unsigned int mmMC_XPB_P2P_BAR_CFG                             = 0x0903;
constexpr unsigned int mmMC_XPB_P2P_BAR_DEBUG                           = 0x090D;
constexpr unsigned int mmMC_XPB_P2P_BAR_DELTA_ABOVE                     = 0x090E;
constexpr unsigned int mmMC_XPB_P2P_BAR_DELTA_BELOW                     = 0x090F;
constexpr unsigned int mmMC_XPB_P2P_BAR_SETUP                           = 0x090C;
constexpr unsigned int mmMC_XPB_PEER_SYS_BAR0                           = 0x0910;
constexpr unsigned int mmMC_XPB_PEER_SYS_BAR1                           = 0x0911;
constexpr unsigned int mmMC_XPB_PEER_SYS_BAR2                           = 0x0912;
constexpr unsigned int mmMC_XPB_PEER_SYS_BAR3                           = 0x0913;
constexpr unsigned int mmMC_XPB_PEER_SYS_BAR4                           = 0x0914;
constexpr unsigned int mmMC_XPB_PEER_SYS_BAR5                           = 0x0915;
constexpr unsigned int mmMC_XPB_PEER_SYS_BAR6                           = 0x0916;
constexpr unsigned int mmMC_XPB_PEER_SYS_BAR7                           = 0x0917;
constexpr unsigned int mmMC_XPB_PEER_SYS_BAR8                           = 0x0918;
constexpr unsigned int mmMC_XPB_PEER_SYS_BAR9                           = 0x0919;
constexpr unsigned int mmMC_XPB_PERF_KNOBS                              = 0x0924;
constexpr unsigned int mmMC_XPB_PIPE_STS                                = 0x0921;
constexpr unsigned int mmMC_XPB_RTR_DEST_MAP0                           = 0x08DB;
constexpr unsigned int mmMC_XPB_RTR_DEST_MAP1                           = 0x08DC;
constexpr unsigned int mmMC_XPB_RTR_DEST_MAP2                           = 0x08DD;
constexpr unsigned int mmMC_XPB_RTR_DEST_MAP3                           = 0x08DE;
constexpr unsigned int mmMC_XPB_RTR_DEST_MAP4                           = 0x08DF;
constexpr unsigned int mmMC_XPB_RTR_DEST_MAP5                           = 0x08E0;
constexpr unsigned int mmMC_XPB_RTR_DEST_MAP6                           = 0x08E1;
constexpr unsigned int mmMC_XPB_RTR_DEST_MAP7                           = 0x08E2;
constexpr unsigned int mmMC_XPB_RTR_DEST_MAP8                           = 0x08E3;
constexpr unsigned int mmMC_XPB_RTR_DEST_MAP9                           = 0x08E4;
constexpr unsigned int mmMC_XPB_RTR_SRC_APRTR0                          = 0x08CD;
constexpr unsigned int mmMC_XPB_RTR_SRC_APRTR1                          = 0x08CE;
constexpr unsigned int mmMC_XPB_RTR_SRC_APRTR2                          = 0x08CF;
constexpr unsigned int mmMC_XPB_RTR_SRC_APRTR3                          = 0x08D0;
constexpr unsigned int mmMC_XPB_RTR_SRC_APRTR4                          = 0x08D1;
constexpr unsigned int mmMC_XPB_RTR_SRC_APRTR5                          = 0x08D2;
constexpr unsigned int mmMC_XPB_RTR_SRC_APRTR6                          = 0x08D3;
constexpr unsigned int mmMC_XPB_RTR_SRC_APRTR7                          = 0x08D4;
constexpr unsigned int mmMC_XPB_RTR_SRC_APRTR8                          = 0x08D5;
constexpr unsigned int mmMC_XPB_RTR_SRC_APRTR9                          = 0x08D6;
constexpr unsigned int mmMC_XPB_STICKY                                  = 0x0925;
constexpr unsigned int mmMC_XPB_STICKY_W1C                              = 0x0926;
constexpr unsigned int mmMC_XPB_SUB_CTRL                                = 0x0922;
constexpr unsigned int mmMC_XPB_UNC_THRESH_HST                          = 0x08FF;
constexpr unsigned int mmMC_XPB_UNC_THRESH_SID                          = 0x0900;
constexpr unsigned int mmMC_XPB_WCB_CFG                                 = 0x0902;
constexpr unsigned int mmMC_XPB_WCB_STS                                 = 0x0901;
constexpr unsigned int mmMC_XPB_XDMA_PEER_SYS_BAR0                      = 0x091A;
constexpr unsigned int mmMC_XPB_XDMA_PEER_SYS_BAR1                      = 0x091B;
constexpr unsigned int mmMC_XPB_XDMA_PEER_SYS_BAR2                      = 0x091C;
constexpr unsigned int mmMC_XPB_XDMA_PEER_SYS_BAR3                      = 0x091D;
constexpr unsigned int mmMC_XPB_XDMA_RTR_DEST_MAP0                      = 0x08E5;
constexpr unsigned int mmMC_XPB_XDMA_RTR_DEST_MAP1                      = 0x08E6;
constexpr unsigned int mmMC_XPB_XDMA_RTR_DEST_MAP2                      = 0x08E7;
constexpr unsigned int mmMC_XPB_XDMA_RTR_DEST_MAP3                      = 0x08E8;
constexpr unsigned int mmMC_XPB_XDMA_RTR_SRC_APRTR0                     = 0x08D7;
constexpr unsigned int mmMC_XPB_XDMA_RTR_SRC_APRTR1                     = 0x08D8;
constexpr unsigned int mmMC_XPB_XDMA_RTR_SRC_APRTR2                     = 0x08D9;
constexpr unsigned int mmMC_XPB_XDMA_RTR_SRC_APRTR3                     = 0x08DA;
constexpr unsigned int mmMEM_TYPE_CNTL__CI__VI                          = 0x14E4;
constexpr unsigned int mmMICROSECOND_TIME_BASE_DIV__SI                  = 0x0148;
constexpr unsigned int mmMM_CFGREGS_CNTL                                = 0x1513;
constexpr unsigned int mmMM_DATA                                        = 0x0001;
constexpr unsigned int mmMM_INDEX                                       = 0x0000;
constexpr unsigned int mmMM_INDEX_HI__CI__VI                            = 0x0006;
constexpr unsigned int mmMPLL_AD_FUNC_CNTL__SI__CI                      = 0x0AF0;
constexpr unsigned int mmMPLL_AD_STATUS__SI__CI                         = 0x0AF6;
constexpr unsigned int mmMPLL_BYPASSCLK_SEL__SI                         = 0x0197;
constexpr unsigned int mmMPLL_CNTL_MODE__SI__CI                         = 0x0AEC;
constexpr unsigned int mmMPLL_CONTROL__SI__CI                           = 0x0AF5;
constexpr unsigned int mmMPLL_DQ_0_0_STATUS__SI__CI                     = 0x0AF7;
constexpr unsigned int mmMPLL_DQ_0_1_STATUS__SI__CI                     = 0x0AF8;
constexpr unsigned int mmMPLL_DQ_1_0_STATUS__SI__CI                     = 0x0AF9;
constexpr unsigned int mmMPLL_DQ_1_1_STATUS__SI__CI                     = 0x0AFA;
constexpr unsigned int mmMPLL_DQ_FUNC_CNTL__SI__CI                      = 0x0AF1;
constexpr unsigned int mmMPLL_FUNC_CNTL__SI__CI                         = 0x0AED;
constexpr unsigned int mmMPLL_FUNC_CNTL_1__SI__CI                       = 0x0AEE;
constexpr unsigned int mmMPLL_FUNC_CNTL_2__SI__CI                       = 0x0AEF;
constexpr unsigned int mmMPLL_SEQ_UCODE_1__SI__CI                       = 0x0AEA;
constexpr unsigned int mmMPLL_SEQ_UCODE_2__SI__CI                       = 0x0AEB;
constexpr unsigned int mmMPLL_SS1__SI__CI                               = 0x0AF3;
constexpr unsigned int mmMPLL_SS2__SI__CI                               = 0x0AF4;
constexpr unsigned int mmMPLL_TIME__SI__CI                              = 0x0AF2;
constexpr unsigned int mmMVP_AFR_FLIP_FIFO_CNTL__SI                     = 0x1AD9;
constexpr unsigned int mmMVP_AFR_FLIP_MODE__SI                          = 0x1AD8;
constexpr unsigned int mmMVP_BLACK_KEYER__SI                            = 0x1686;
constexpr unsigned int mmMVP_CONTROL1__SI                               = 0x1680;
constexpr unsigned int mmMVP_CONTROL2__SI                               = 0x1681;
constexpr unsigned int mmMVP_CONTROL3__SI                               = 0x168A;
constexpr unsigned int mmMVP_CRC_CNTL__SI                               = 0x1687;
constexpr unsigned int mmMVP_CRC_RESULT_BLUE_GREEN__SI                  = 0x1688;
constexpr unsigned int mmMVP_CRC_RESULT_RED__SI                         = 0x1689;
constexpr unsigned int mmMVP_FIFO_CONTROL__SI                           = 0x1682;
constexpr unsigned int mmMVP_FIFO_STATUS__SI                            = 0x1683;
constexpr unsigned int mmMVP_FLIP_LINE_NUM_INSERT__SI                   = 0x1ADA;
constexpr unsigned int mmMVP_INBAND_CNTL_CAP__SI                        = 0x1685;
constexpr unsigned int mmMVP_RECEIVE_CNT_CNTL1__SI                      = 0x168B;
constexpr unsigned int mmMVP_RECEIVE_CNT_CNTL2__SI                      = 0x168C;
constexpr unsigned int mmMVP_SLAVE_STATUS__SI                           = 0x1684;
constexpr unsigned int mmMVP_TEST_DEBUG_DATA__SI                        = 0x168E;
constexpr unsigned int mmMVP_TEST_DEBUG_INDEX__SI                       = 0x168D;
constexpr unsigned int mmNEW_REFCLKB_TIMER_1__CI                        = 0x1484;
constexpr unsigned int mmNEW_REFCLKB_TIMER__CI                          = 0x1485;
constexpr unsigned int mmOVLSCL_EDGE_PIXEL_CNTL__SI__VI                 = 0x1A2C;
constexpr unsigned int mmOVL_CONTROL1__SI__VI                           = 0x1A1D;
constexpr unsigned int mmOVL_CONTROL2__SI__VI                           = 0x1A1E;
constexpr unsigned int mmOVL_DFQ_CONTROL__SI__VI                        = 0x1A29;
constexpr unsigned int mmOVL_DFQ_STATUS__SI__VI                         = 0x1A2A;
constexpr unsigned int mmOVL_ENABLE__SI__VI                             = 0x1A1C;
constexpr unsigned int mmOVL_END__SI__VI                                = 0x1A26;
constexpr unsigned int mmOVL_PITCH__SI__VI                              = 0x1A21;
constexpr unsigned int mmOVL_START__SI__VI                              = 0x1A25;
constexpr unsigned int mmOVL_SURFACE_ADDRESS                            = 0x1A20;
constexpr unsigned int mmOVL_SURFACE_ADDRESS_HIGH                       = 0x1A22;
constexpr unsigned int mmOVL_SURFACE_ADDRESS_HIGH_INUSE__SI__VI         = 0x1A2B;
constexpr unsigned int mmOVL_SURFACE_ADDRESS_INUSE__SI__VI              = 0x1A28;
constexpr unsigned int mmOVL_SURFACE_OFFSET_X__SI__VI                   = 0x1A23;
constexpr unsigned int mmOVL_SURFACE_OFFSET_Y__SI__VI                   = 0x1A24;
constexpr unsigned int mmOVL_SWAP_CNTL__SI__VI                          = 0x1A1F;
constexpr unsigned int mmOVL_UPDATE__SI__VI                             = 0x1A27;
constexpr unsigned int mmPAGE_MIRROR_CNTL__SI                           = 0x0581;
constexpr unsigned int mmPA_CL_CLIP_CNTL                                = 0xA204;
constexpr unsigned int mmPA_CL_CNTL_STATUS                              = 0x2284;
constexpr unsigned int mmPA_CL_ENHANCE                                  = 0x2285;
constexpr unsigned int mmPA_CL_GB_HORZ_CLIP_ADJ                         = 0xA2FC;
constexpr unsigned int mmPA_CL_GB_HORZ_DISC_ADJ                         = 0xA2FD;
constexpr unsigned int mmPA_CL_GB_VERT_CLIP_ADJ                         = 0xA2FA;
constexpr unsigned int mmPA_CL_GB_VERT_DISC_ADJ                         = 0xA2FB;
constexpr unsigned int mmPA_CL_NANINF_CNTL                              = 0xA208;
constexpr unsigned int mmPA_CL_POINT_CULL_RAD                           = 0xA1F8;
constexpr unsigned int mmPA_CL_POINT_SIZE                               = 0xA1F7;
constexpr unsigned int mmPA_CL_POINT_X_RAD                              = 0xA1F5;
constexpr unsigned int mmPA_CL_POINT_Y_RAD                              = 0xA1F6;
constexpr unsigned int mmPA_CL_RESET_DEBUG__CI__VI                      = 0x2286;
constexpr unsigned int mmPA_CL_UCP_0_W                                  = 0xA172;
constexpr unsigned int mmPA_CL_UCP_0_X                                  = 0xA16F;
constexpr unsigned int mmPA_CL_UCP_0_Y                                  = 0xA170;
constexpr unsigned int mmPA_CL_UCP_0_Z                                  = 0xA171;
constexpr unsigned int mmPA_CL_UCP_1_W                                  = 0xA176;
constexpr unsigned int mmPA_CL_UCP_1_X                                  = 0xA173;
constexpr unsigned int mmPA_CL_UCP_1_Y                                  = 0xA174;
constexpr unsigned int mmPA_CL_UCP_1_Z                                  = 0xA175;
constexpr unsigned int mmPA_CL_UCP_2_W                                  = 0xA17A;
constexpr unsigned int mmPA_CL_UCP_2_X                                  = 0xA177;
constexpr unsigned int mmPA_CL_UCP_2_Y                                  = 0xA178;
constexpr unsigned int mmPA_CL_UCP_2_Z                                  = 0xA179;
constexpr unsigned int mmPA_CL_UCP_3_W                                  = 0xA17E;
constexpr unsigned int mmPA_CL_UCP_3_X                                  = 0xA17B;
constexpr unsigned int mmPA_CL_UCP_3_Y                                  = 0xA17C;
constexpr unsigned int mmPA_CL_UCP_3_Z                                  = 0xA17D;
constexpr unsigned int mmPA_CL_UCP_4_W                                  = 0xA182;
constexpr unsigned int mmPA_CL_UCP_4_X                                  = 0xA17F;
constexpr unsigned int mmPA_CL_UCP_4_Y                                  = 0xA180;
constexpr unsigned int mmPA_CL_UCP_4_Z                                  = 0xA181;
constexpr unsigned int mmPA_CL_UCP_5_W                                  = 0xA186;
constexpr unsigned int mmPA_CL_UCP_5_X                                  = 0xA183;
constexpr unsigned int mmPA_CL_UCP_5_Y                                  = 0xA184;
constexpr unsigned int mmPA_CL_UCP_5_Z                                  = 0xA185;
constexpr unsigned int mmPA_CL_VPORT_XOFFSET                            = 0xA110;
constexpr unsigned int mmPA_CL_VPORT_XOFFSET_1                          = 0xA116;
constexpr unsigned int mmPA_CL_VPORT_XOFFSET_10                         = 0xA14C;
constexpr unsigned int mmPA_CL_VPORT_XOFFSET_11                         = 0xA152;
constexpr unsigned int mmPA_CL_VPORT_XOFFSET_12                         = 0xA158;
constexpr unsigned int mmPA_CL_VPORT_XOFFSET_13                         = 0xA15E;
constexpr unsigned int mmPA_CL_VPORT_XOFFSET_14                         = 0xA164;
constexpr unsigned int mmPA_CL_VPORT_XOFFSET_15                         = 0xA16A;
constexpr unsigned int mmPA_CL_VPORT_XOFFSET_2                          = 0xA11C;
constexpr unsigned int mmPA_CL_VPORT_XOFFSET_3                          = 0xA122;
constexpr unsigned int mmPA_CL_VPORT_XOFFSET_4                          = 0xA128;
constexpr unsigned int mmPA_CL_VPORT_XOFFSET_5                          = 0xA12E;
constexpr unsigned int mmPA_CL_VPORT_XOFFSET_6                          = 0xA134;
constexpr unsigned int mmPA_CL_VPORT_XOFFSET_7                          = 0xA13A;
constexpr unsigned int mmPA_CL_VPORT_XOFFSET_8                          = 0xA140;
constexpr unsigned int mmPA_CL_VPORT_XOFFSET_9                          = 0xA146;
constexpr unsigned int mmPA_CL_VPORT_XSCALE                             = 0xA10F;
constexpr unsigned int mmPA_CL_VPORT_XSCALE_1                           = 0xA115;
constexpr unsigned int mmPA_CL_VPORT_XSCALE_10                          = 0xA14B;
constexpr unsigned int mmPA_CL_VPORT_XSCALE_11                          = 0xA151;
constexpr unsigned int mmPA_CL_VPORT_XSCALE_12                          = 0xA157;
constexpr unsigned int mmPA_CL_VPORT_XSCALE_13                          = 0xA15D;
constexpr unsigned int mmPA_CL_VPORT_XSCALE_14                          = 0xA163;
constexpr unsigned int mmPA_CL_VPORT_XSCALE_15                          = 0xA169;
constexpr unsigned int mmPA_CL_VPORT_XSCALE_2                           = 0xA11B;
constexpr unsigned int mmPA_CL_VPORT_XSCALE_3                           = 0xA121;
constexpr unsigned int mmPA_CL_VPORT_XSCALE_4                           = 0xA127;
constexpr unsigned int mmPA_CL_VPORT_XSCALE_5                           = 0xA12D;
constexpr unsigned int mmPA_CL_VPORT_XSCALE_6                           = 0xA133;
constexpr unsigned int mmPA_CL_VPORT_XSCALE_7                           = 0xA139;
constexpr unsigned int mmPA_CL_VPORT_XSCALE_8                           = 0xA13F;
constexpr unsigned int mmPA_CL_VPORT_XSCALE_9                           = 0xA145;
constexpr unsigned int mmPA_CL_VPORT_YOFFSET                            = 0xA112;
constexpr unsigned int mmPA_CL_VPORT_YOFFSET_1                          = 0xA118;
constexpr unsigned int mmPA_CL_VPORT_YOFFSET_10                         = 0xA14E;
constexpr unsigned int mmPA_CL_VPORT_YOFFSET_11                         = 0xA154;
constexpr unsigned int mmPA_CL_VPORT_YOFFSET_12                         = 0xA15A;
constexpr unsigned int mmPA_CL_VPORT_YOFFSET_13                         = 0xA160;
constexpr unsigned int mmPA_CL_VPORT_YOFFSET_14                         = 0xA166;
constexpr unsigned int mmPA_CL_VPORT_YOFFSET_15                         = 0xA16C;
constexpr unsigned int mmPA_CL_VPORT_YOFFSET_2                          = 0xA11E;
constexpr unsigned int mmPA_CL_VPORT_YOFFSET_3                          = 0xA124;
constexpr unsigned int mmPA_CL_VPORT_YOFFSET_4                          = 0xA12A;
constexpr unsigned int mmPA_CL_VPORT_YOFFSET_5                          = 0xA130;
constexpr unsigned int mmPA_CL_VPORT_YOFFSET_6                          = 0xA136;
constexpr unsigned int mmPA_CL_VPORT_YOFFSET_7                          = 0xA13C;
constexpr unsigned int mmPA_CL_VPORT_YOFFSET_8                          = 0xA142;
constexpr unsigned int mmPA_CL_VPORT_YOFFSET_9                          = 0xA148;
constexpr unsigned int mmPA_CL_VPORT_YSCALE                             = 0xA111;
constexpr unsigned int mmPA_CL_VPORT_YSCALE_1                           = 0xA117;
constexpr unsigned int mmPA_CL_VPORT_YSCALE_10                          = 0xA14D;
constexpr unsigned int mmPA_CL_VPORT_YSCALE_11                          = 0xA153;
constexpr unsigned int mmPA_CL_VPORT_YSCALE_12                          = 0xA159;
constexpr unsigned int mmPA_CL_VPORT_YSCALE_13                          = 0xA15F;
constexpr unsigned int mmPA_CL_VPORT_YSCALE_14                          = 0xA165;
constexpr unsigned int mmPA_CL_VPORT_YSCALE_15                          = 0xA16B;
constexpr unsigned int mmPA_CL_VPORT_YSCALE_2                           = 0xA11D;
constexpr unsigned int mmPA_CL_VPORT_YSCALE_3                           = 0xA123;
constexpr unsigned int mmPA_CL_VPORT_YSCALE_4                           = 0xA129;
constexpr unsigned int mmPA_CL_VPORT_YSCALE_5                           = 0xA12F;
constexpr unsigned int mmPA_CL_VPORT_YSCALE_6                           = 0xA135;
constexpr unsigned int mmPA_CL_VPORT_YSCALE_7                           = 0xA13B;
constexpr unsigned int mmPA_CL_VPORT_YSCALE_8                           = 0xA141;
constexpr unsigned int mmPA_CL_VPORT_YSCALE_9                           = 0xA147;
constexpr unsigned int mmPA_CL_VPORT_ZOFFSET                            = 0xA114;
constexpr unsigned int mmPA_CL_VPORT_ZOFFSET_1                          = 0xA11A;
constexpr unsigned int mmPA_CL_VPORT_ZOFFSET_10                         = 0xA150;
constexpr unsigned int mmPA_CL_VPORT_ZOFFSET_11                         = 0xA156;
constexpr unsigned int mmPA_CL_VPORT_ZOFFSET_12                         = 0xA15C;
constexpr unsigned int mmPA_CL_VPORT_ZOFFSET_13                         = 0xA162;
constexpr unsigned int mmPA_CL_VPORT_ZOFFSET_14                         = 0xA168;
constexpr unsigned int mmPA_CL_VPORT_ZOFFSET_15                         = 0xA16E;
constexpr unsigned int mmPA_CL_VPORT_ZOFFSET_2                          = 0xA120;
constexpr unsigned int mmPA_CL_VPORT_ZOFFSET_3                          = 0xA126;
constexpr unsigned int mmPA_CL_VPORT_ZOFFSET_4                          = 0xA12C;
constexpr unsigned int mmPA_CL_VPORT_ZOFFSET_5                          = 0xA132;
constexpr unsigned int mmPA_CL_VPORT_ZOFFSET_6                          = 0xA138;
constexpr unsigned int mmPA_CL_VPORT_ZOFFSET_7                          = 0xA13E;
constexpr unsigned int mmPA_CL_VPORT_ZOFFSET_8                          = 0xA144;
constexpr unsigned int mmPA_CL_VPORT_ZOFFSET_9                          = 0xA14A;
constexpr unsigned int mmPA_CL_VPORT_ZSCALE                             = 0xA113;
constexpr unsigned int mmPA_CL_VPORT_ZSCALE_1                           = 0xA119;
constexpr unsigned int mmPA_CL_VPORT_ZSCALE_10                          = 0xA14F;
constexpr unsigned int mmPA_CL_VPORT_ZSCALE_11                          = 0xA155;
constexpr unsigned int mmPA_CL_VPORT_ZSCALE_12                          = 0xA15B;
constexpr unsigned int mmPA_CL_VPORT_ZSCALE_13                          = 0xA161;
constexpr unsigned int mmPA_CL_VPORT_ZSCALE_14                          = 0xA167;
constexpr unsigned int mmPA_CL_VPORT_ZSCALE_15                          = 0xA16D;
constexpr unsigned int mmPA_CL_VPORT_ZSCALE_2                           = 0xA11F;
constexpr unsigned int mmPA_CL_VPORT_ZSCALE_3                           = 0xA125;
constexpr unsigned int mmPA_CL_VPORT_ZSCALE_4                           = 0xA12B;
constexpr unsigned int mmPA_CL_VPORT_ZSCALE_5                           = 0xA131;
constexpr unsigned int mmPA_CL_VPORT_ZSCALE_6                           = 0xA137;
constexpr unsigned int mmPA_CL_VPORT_ZSCALE_7                           = 0xA13D;
constexpr unsigned int mmPA_CL_VPORT_ZSCALE_8                           = 0xA143;
constexpr unsigned int mmPA_CL_VPORT_ZSCALE_9                           = 0xA149;
constexpr unsigned int mmPA_CL_VS_OUT_CNTL                              = 0xA207;
constexpr unsigned int mmPA_CL_VTE_CNTL                                 = 0xA206;
constexpr unsigned int mmPA_SC_AA_CONFIG                                = 0xA2F8;
constexpr unsigned int mmPA_SC_AA_MASK_X0Y0_X1Y0                        = 0xA30E;
constexpr unsigned int mmPA_SC_AA_MASK_X0Y1_X1Y1                        = 0xA30F;
constexpr unsigned int mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0              = 0xA2FE;
constexpr unsigned int mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1              = 0xA2FF;
constexpr unsigned int mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2              = 0xA300;
constexpr unsigned int mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3              = 0xA301;
constexpr unsigned int mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0              = 0xA306;
constexpr unsigned int mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1              = 0xA307;
constexpr unsigned int mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2              = 0xA308;
constexpr unsigned int mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3              = 0xA309;
constexpr unsigned int mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0              = 0xA302;
constexpr unsigned int mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1              = 0xA303;
constexpr unsigned int mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2              = 0xA304;
constexpr unsigned int mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3              = 0xA305;
constexpr unsigned int mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0              = 0xA30A;
constexpr unsigned int mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1              = 0xA30B;
constexpr unsigned int mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2              = 0xA30C;
constexpr unsigned int mmPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3              = 0xA30D;
constexpr unsigned int mmPA_SC_CENTROID_PRIORITY_0                      = 0xA2F5;
constexpr unsigned int mmPA_SC_CENTROID_PRIORITY_1                      = 0xA2F6;
constexpr unsigned int mmPA_SC_CLIPRECT_0_BR                            = 0xA085;
constexpr unsigned int mmPA_SC_CLIPRECT_0_TL                            = 0xA084;
constexpr unsigned int mmPA_SC_CLIPRECT_1_BR                            = 0xA087;
constexpr unsigned int mmPA_SC_CLIPRECT_1_TL                            = 0xA086;
constexpr unsigned int mmPA_SC_CLIPRECT_2_BR                            = 0xA089;
constexpr unsigned int mmPA_SC_CLIPRECT_2_TL                            = 0xA088;
constexpr unsigned int mmPA_SC_CLIPRECT_3_BR                            = 0xA08B;
constexpr unsigned int mmPA_SC_CLIPRECT_3_TL                            = 0xA08A;
constexpr unsigned int mmPA_SC_CLIPRECT_RULE                            = 0xA083;
constexpr unsigned int mmPA_SC_DEBUG_CNTL                               = 0x22F6;
constexpr unsigned int mmPA_SC_DEBUG_DATA                               = 0x22F7;
constexpr unsigned int mmPA_SC_EDGERULE                                 = 0xA08C;
constexpr unsigned int mmPA_SC_ENHANCE                                  = 0x22FC;
constexpr unsigned int mmPA_SC_FIFO_DEPTH_CNTL                          = 0x2295;
constexpr unsigned int mmPA_SC_FIFO_SIZE                                = 0x22F3;
constexpr unsigned int mmPA_SC_FORCE_EOV_MAX_CNTS                       = 0x22C9;
constexpr unsigned int mmPA_SC_GENERIC_SCISSOR_BR                       = 0xA091;
constexpr unsigned int mmPA_SC_GENERIC_SCISSOR_TL                       = 0xA090;
constexpr unsigned int mmPA_SC_HP3D_TRAP_SCREEN_COUNT__CI__VI           = 0xC2AC;
constexpr unsigned int mmPA_SC_HP3D_TRAP_SCREEN_HV_EN__CI__VI           = 0xC2A8;
constexpr unsigned int mmPA_SC_HP3D_TRAP_SCREEN_HV_LOCK__CI__VI         = 0x22C1;
constexpr unsigned int mmPA_SC_HP3D_TRAP_SCREEN_H__CI__VI               = 0xC2A9;
constexpr unsigned int mmPA_SC_HP3D_TRAP_SCREEN_OCCURRENCE__CI__VI      = 0xC2AB;
constexpr unsigned int mmPA_SC_HP3D_TRAP_SCREEN_V__CI__VI               = 0xC2AA;
constexpr unsigned int mmPA_SC_IF_FIFO_SIZE                             = 0x22F5;
constexpr unsigned int mmPA_SC_LINE_CNTL                                = 0xA2F7;
constexpr unsigned int mmPA_SC_LINE_STIPPLE                             = 0xA283;
constexpr unsigned int mmPA_SC_LINE_STIPPLE_STATE__CI__VI               = 0xC281;
constexpr unsigned int mmPA_SC_LINE_STIPPLE_STATE__SI                   = 0x22C4;
constexpr unsigned int mmPA_SC_MODE_CNTL_0                              = 0xA292;
constexpr unsigned int mmPA_SC_MODE_CNTL_1                              = 0xA293;
constexpr unsigned int mmPA_SC_P3D_TRAP_SCREEN_COUNT__CI__VI            = 0xC2A4;
constexpr unsigned int mmPA_SC_P3D_TRAP_SCREEN_HV_EN__CI__VI            = 0xC2A0;
constexpr unsigned int mmPA_SC_P3D_TRAP_SCREEN_HV_LOCK__CI__VI          = 0x22C0;
constexpr unsigned int mmPA_SC_P3D_TRAP_SCREEN_H__CI__VI                = 0xC2A1;
constexpr unsigned int mmPA_SC_P3D_TRAP_SCREEN_OCCURRENCE__CI__VI       = 0xC2A3;
constexpr unsigned int mmPA_SC_P3D_TRAP_SCREEN_V__CI__VI                = 0xC2A2;
constexpr unsigned int mmPA_SC_PERFCOUNTER0_HI__CI__VI                  = 0xD141;
constexpr unsigned int mmPA_SC_PERFCOUNTER0_HI__SI                      = 0x22A9;
constexpr unsigned int mmPA_SC_PERFCOUNTER0_LO__CI__VI                  = 0xD140;
constexpr unsigned int mmPA_SC_PERFCOUNTER0_LO__SI                      = 0x22A8;
constexpr unsigned int mmPA_SC_PERFCOUNTER0_SELECT1__CI__VI             = 0xD941;
constexpr unsigned int mmPA_SC_PERFCOUNTER0_SELECT__CI__VI              = 0xD940;
constexpr unsigned int mmPA_SC_PERFCOUNTER0_SELECT__SI                  = 0x22A0;
constexpr unsigned int mmPA_SC_PERFCOUNTER1_HI__CI__VI                  = 0xD143;
constexpr unsigned int mmPA_SC_PERFCOUNTER1_HI__SI                      = 0x22AB;
constexpr unsigned int mmPA_SC_PERFCOUNTER1_LO__CI__VI                  = 0xD142;
constexpr unsigned int mmPA_SC_PERFCOUNTER1_LO__SI                      = 0x22AA;
constexpr unsigned int mmPA_SC_PERFCOUNTER1_SELECT__CI__VI              = 0xD942;
constexpr unsigned int mmPA_SC_PERFCOUNTER1_SELECT__SI                  = 0x22A1;
constexpr unsigned int mmPA_SC_PERFCOUNTER2_HI__CI__VI                  = 0xD145;
constexpr unsigned int mmPA_SC_PERFCOUNTER2_HI__SI                      = 0x22AD;
constexpr unsigned int mmPA_SC_PERFCOUNTER2_LO__CI__VI                  = 0xD144;
constexpr unsigned int mmPA_SC_PERFCOUNTER2_LO__SI                      = 0x22AC;
constexpr unsigned int mmPA_SC_PERFCOUNTER2_SELECT__CI__VI              = 0xD943;
constexpr unsigned int mmPA_SC_PERFCOUNTER2_SELECT__SI                  = 0x22A2;
constexpr unsigned int mmPA_SC_PERFCOUNTER3_HI__CI__VI                  = 0xD147;
constexpr unsigned int mmPA_SC_PERFCOUNTER3_HI__SI                      = 0x22AF;
constexpr unsigned int mmPA_SC_PERFCOUNTER3_LO__CI__VI                  = 0xD146;
constexpr unsigned int mmPA_SC_PERFCOUNTER3_LO__SI                      = 0x22AE;
constexpr unsigned int mmPA_SC_PERFCOUNTER3_SELECT__CI__VI              = 0xD944;
constexpr unsigned int mmPA_SC_PERFCOUNTER3_SELECT__SI                  = 0x22A3;
constexpr unsigned int mmPA_SC_PERFCOUNTER4_HI__CI__VI                  = 0xD149;
constexpr unsigned int mmPA_SC_PERFCOUNTER4_HI__SI                      = 0x22B1;
constexpr unsigned int mmPA_SC_PERFCOUNTER4_LO__CI__VI                  = 0xD148;
constexpr unsigned int mmPA_SC_PERFCOUNTER4_LO__SI                      = 0x22B0;
constexpr unsigned int mmPA_SC_PERFCOUNTER4_SELECT__CI__VI              = 0xD945;
constexpr unsigned int mmPA_SC_PERFCOUNTER4_SELECT__SI                  = 0x22A4;
constexpr unsigned int mmPA_SC_PERFCOUNTER5_HI__CI__VI                  = 0xD14B;
constexpr unsigned int mmPA_SC_PERFCOUNTER5_HI__SI                      = 0x22B3;
constexpr unsigned int mmPA_SC_PERFCOUNTER5_LO__CI__VI                  = 0xD14A;
constexpr unsigned int mmPA_SC_PERFCOUNTER5_LO__SI                      = 0x22B2;
constexpr unsigned int mmPA_SC_PERFCOUNTER5_SELECT__CI__VI              = 0xD946;
constexpr unsigned int mmPA_SC_PERFCOUNTER5_SELECT__SI                  = 0x22A5;
constexpr unsigned int mmPA_SC_PERFCOUNTER6_HI__CI__VI                  = 0xD14D;
constexpr unsigned int mmPA_SC_PERFCOUNTER6_HI__SI                      = 0x22B5;
constexpr unsigned int mmPA_SC_PERFCOUNTER6_LO__CI__VI                  = 0xD14C;
constexpr unsigned int mmPA_SC_PERFCOUNTER6_LO__SI                      = 0x22B4;
constexpr unsigned int mmPA_SC_PERFCOUNTER6_SELECT__CI__VI              = 0xD947;
constexpr unsigned int mmPA_SC_PERFCOUNTER6_SELECT__SI                  = 0x22A6;
constexpr unsigned int mmPA_SC_PERFCOUNTER7_HI__CI__VI                  = 0xD14F;
constexpr unsigned int mmPA_SC_PERFCOUNTER7_HI__SI                      = 0x22B7;
constexpr unsigned int mmPA_SC_PERFCOUNTER7_LO__CI__VI                  = 0xD14E;
constexpr unsigned int mmPA_SC_PERFCOUNTER7_LO__SI                      = 0x22B6;
constexpr unsigned int mmPA_SC_PERFCOUNTER7_SELECT__CI__VI              = 0xD948;
constexpr unsigned int mmPA_SC_PERFCOUNTER7_SELECT__SI                  = 0x22A7;
constexpr unsigned int mmPA_SC_RASTER_CONFIG                            = 0xA0D4;
constexpr unsigned int mmPA_SC_RASTER_CONFIG_1__CI__VI                  = 0xA0D5;
constexpr unsigned int mmPA_SC_SCREEN_SCISSOR_BR                        = 0xA00D;
constexpr unsigned int mmPA_SC_SCREEN_SCISSOR_TL                        = 0xA00C;
constexpr unsigned int mmPA_SC_TRAP_SCREEN_COUNT__CI__VI                = 0xC2B4;
constexpr unsigned int mmPA_SC_TRAP_SCREEN_HV_EN__CI__VI                = 0xC2B0;
constexpr unsigned int mmPA_SC_TRAP_SCREEN_HV_LOCK__CI__VI              = 0x22C2;
constexpr unsigned int mmPA_SC_TRAP_SCREEN_H__CI__VI                    = 0xC2B1;
constexpr unsigned int mmPA_SC_TRAP_SCREEN_OCCURRENCE__CI__VI           = 0xC2B3;
constexpr unsigned int mmPA_SC_TRAP_SCREEN_V__CI__VI                    = 0xC2B2;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_0_BR                       = 0xA095;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_0_TL                       = 0xA094;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_10_BR                      = 0xA0A9;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_10_TL                      = 0xA0A8;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_11_BR                      = 0xA0AB;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_11_TL                      = 0xA0AA;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_12_BR                      = 0xA0AD;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_12_TL                      = 0xA0AC;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_13_BR                      = 0xA0AF;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_13_TL                      = 0xA0AE;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_14_BR                      = 0xA0B1;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_14_TL                      = 0xA0B0;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_15_BR                      = 0xA0B3;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_15_TL                      = 0xA0B2;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_1_BR                       = 0xA097;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_1_TL                       = 0xA096;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_2_BR                       = 0xA099;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_2_TL                       = 0xA098;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_3_BR                       = 0xA09B;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_3_TL                       = 0xA09A;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_4_BR                       = 0xA09D;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_4_TL                       = 0xA09C;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_5_BR                       = 0xA09F;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_5_TL                       = 0xA09E;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_6_BR                       = 0xA0A1;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_6_TL                       = 0xA0A0;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_7_BR                       = 0xA0A3;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_7_TL                       = 0xA0A2;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_8_BR                       = 0xA0A5;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_8_TL                       = 0xA0A4;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_9_BR                       = 0xA0A7;
constexpr unsigned int mmPA_SC_VPORT_SCISSOR_9_TL                       = 0xA0A6;
constexpr unsigned int mmPA_SC_VPORT_ZMAX_0                             = 0xA0B5;
constexpr unsigned int mmPA_SC_VPORT_ZMAX_1                             = 0xA0B7;
constexpr unsigned int mmPA_SC_VPORT_ZMAX_10                            = 0xA0C9;
constexpr unsigned int mmPA_SC_VPORT_ZMAX_11                            = 0xA0CB;
constexpr unsigned int mmPA_SC_VPORT_ZMAX_12                            = 0xA0CD;
constexpr unsigned int mmPA_SC_VPORT_ZMAX_13                            = 0xA0CF;
constexpr unsigned int mmPA_SC_VPORT_ZMAX_14                            = 0xA0D1;
constexpr unsigned int mmPA_SC_VPORT_ZMAX_15                            = 0xA0D3;
constexpr unsigned int mmPA_SC_VPORT_ZMAX_2                             = 0xA0B9;
constexpr unsigned int mmPA_SC_VPORT_ZMAX_3                             = 0xA0BB;
constexpr unsigned int mmPA_SC_VPORT_ZMAX_4                             = 0xA0BD;
constexpr unsigned int mmPA_SC_VPORT_ZMAX_5                             = 0xA0BF;
constexpr unsigned int mmPA_SC_VPORT_ZMAX_6                             = 0xA0C1;
constexpr unsigned int mmPA_SC_VPORT_ZMAX_7                             = 0xA0C3;
constexpr unsigned int mmPA_SC_VPORT_ZMAX_8                             = 0xA0C5;
constexpr unsigned int mmPA_SC_VPORT_ZMAX_9                             = 0xA0C7;
constexpr unsigned int mmPA_SC_VPORT_ZMIN_0                             = 0xA0B4;
constexpr unsigned int mmPA_SC_VPORT_ZMIN_1                             = 0xA0B6;
constexpr unsigned int mmPA_SC_VPORT_ZMIN_10                            = 0xA0C8;
constexpr unsigned int mmPA_SC_VPORT_ZMIN_11                            = 0xA0CA;
constexpr unsigned int mmPA_SC_VPORT_ZMIN_12                            = 0xA0CC;
constexpr unsigned int mmPA_SC_VPORT_ZMIN_13                            = 0xA0CE;
constexpr unsigned int mmPA_SC_VPORT_ZMIN_14                            = 0xA0D0;
constexpr unsigned int mmPA_SC_VPORT_ZMIN_15                            = 0xA0D2;
constexpr unsigned int mmPA_SC_VPORT_ZMIN_2                             = 0xA0B8;
constexpr unsigned int mmPA_SC_VPORT_ZMIN_3                             = 0xA0BA;
constexpr unsigned int mmPA_SC_VPORT_ZMIN_4                             = 0xA0BC;
constexpr unsigned int mmPA_SC_VPORT_ZMIN_5                             = 0xA0BE;
constexpr unsigned int mmPA_SC_VPORT_ZMIN_6                             = 0xA0C0;
constexpr unsigned int mmPA_SC_VPORT_ZMIN_7                             = 0xA0C2;
constexpr unsigned int mmPA_SC_VPORT_ZMIN_8                             = 0xA0C4;
constexpr unsigned int mmPA_SC_VPORT_ZMIN_9                             = 0xA0C6;
constexpr unsigned int mmPA_SC_WINDOW_OFFSET                            = 0xA080;
constexpr unsigned int mmPA_SC_WINDOW_SCISSOR_BR                        = 0xA082;
constexpr unsigned int mmPA_SC_WINDOW_SCISSOR_TL                        = 0xA081;
constexpr unsigned int mmPA_SU_CNTL_STATUS                              = 0x2294;
constexpr unsigned int mmPA_SU_DEBUG_CNTL                               = 0x2280;
constexpr unsigned int mmPA_SU_DEBUG_DATA                               = 0x2281;
constexpr unsigned int mmPA_SU_HARDWARE_SCREEN_OFFSET                   = 0xA08D;
constexpr unsigned int mmPA_SU_LINE_CNTL                                = 0xA282;
constexpr unsigned int mmPA_SU_LINE_STIPPLE_CNTL                        = 0xA209;
constexpr unsigned int mmPA_SU_LINE_STIPPLE_SCALE                       = 0xA20A;
constexpr unsigned int mmPA_SU_LINE_STIPPLE_VALUE__CI__VI               = 0xC280;
constexpr unsigned int mmPA_SU_LINE_STIPPLE_VALUE__SI                   = 0x2298;
constexpr unsigned int mmPA_SU_PERFCOUNTER0_HI__CI__VI                  = 0xD101;
constexpr unsigned int mmPA_SU_PERFCOUNTER0_HI__SI                      = 0x228D;
constexpr unsigned int mmPA_SU_PERFCOUNTER0_LO__CI__VI                  = 0xD100;
constexpr unsigned int mmPA_SU_PERFCOUNTER0_LO__SI                      = 0x228C;
constexpr unsigned int mmPA_SU_PERFCOUNTER0_SELECT1__CI__VI             = 0xD901;
constexpr unsigned int mmPA_SU_PERFCOUNTER0_SELECT__CI__VI              = 0xD900;
constexpr unsigned int mmPA_SU_PERFCOUNTER0_SELECT__SI                  = 0x2288;
constexpr unsigned int mmPA_SU_PERFCOUNTER1_HI__CI__VI                  = 0xD103;
constexpr unsigned int mmPA_SU_PERFCOUNTER1_HI__SI                      = 0x228F;
constexpr unsigned int mmPA_SU_PERFCOUNTER1_LO__CI__VI                  = 0xD102;
constexpr unsigned int mmPA_SU_PERFCOUNTER1_LO__SI                      = 0x228E;
constexpr unsigned int mmPA_SU_PERFCOUNTER1_SELECT1__CI__VI             = 0xD903;
constexpr unsigned int mmPA_SU_PERFCOUNTER1_SELECT__CI__VI              = 0xD902;
constexpr unsigned int mmPA_SU_PERFCOUNTER1_SELECT__SI                  = 0x2289;
constexpr unsigned int mmPA_SU_PERFCOUNTER2_HI__CI__VI                  = 0xD105;
constexpr unsigned int mmPA_SU_PERFCOUNTER2_HI__SI                      = 0x2291;
constexpr unsigned int mmPA_SU_PERFCOUNTER2_LO__CI__VI                  = 0xD104;
constexpr unsigned int mmPA_SU_PERFCOUNTER2_LO__SI                      = 0x2290;
constexpr unsigned int mmPA_SU_PERFCOUNTER2_SELECT__CI__VI              = 0xD904;
constexpr unsigned int mmPA_SU_PERFCOUNTER2_SELECT__SI                  = 0x228A;
constexpr unsigned int mmPA_SU_PERFCOUNTER3_HI__CI__VI                  = 0xD107;
constexpr unsigned int mmPA_SU_PERFCOUNTER3_HI__SI                      = 0x2293;
constexpr unsigned int mmPA_SU_PERFCOUNTER3_LO__CI__VI                  = 0xD106;
constexpr unsigned int mmPA_SU_PERFCOUNTER3_LO__SI                      = 0x2292;
constexpr unsigned int mmPA_SU_PERFCOUNTER3_SELECT__CI__VI              = 0xD905;
constexpr unsigned int mmPA_SU_PERFCOUNTER3_SELECT__SI                  = 0x228B;
constexpr unsigned int mmPA_SU_POINT_MINMAX                             = 0xA281;
constexpr unsigned int mmPA_SU_POINT_SIZE                               = 0xA280;
constexpr unsigned int mmPA_SU_POLY_OFFSET_BACK_OFFSET                  = 0xA2E3;
constexpr unsigned int mmPA_SU_POLY_OFFSET_BACK_SCALE                   = 0xA2E2;
constexpr unsigned int mmPA_SU_POLY_OFFSET_CLAMP                        = 0xA2DF;
constexpr unsigned int mmPA_SU_POLY_OFFSET_DB_FMT_CNTL                  = 0xA2DE;
constexpr unsigned int mmPA_SU_POLY_OFFSET_FRONT_OFFSET                 = 0xA2E1;
constexpr unsigned int mmPA_SU_POLY_OFFSET_FRONT_SCALE                  = 0xA2E0;
constexpr unsigned int mmPA_SU_PRIM_FILTER_CNTL                         = 0xA20B;
constexpr unsigned int mmPA_SU_SC_MODE_CNTL                             = 0xA205;
constexpr unsigned int mmPA_SU_VTX_CNTL                                 = 0xA2F9;
constexpr unsigned int mmPCIE_DATA_2__CI__VI                            = 0x000D;
constexpr unsigned int mmPCIE_DATA__CI__VI                              = 0x000F;
constexpr unsigned int mmPCIE_DATA__SI                                  = 0x000D;
constexpr unsigned int mmPCIE_INDEX_2__CI__VI                           = 0x000C;
constexpr unsigned int mmPCIE_INDEX__CI__VI                             = 0x000E;
constexpr unsigned int mmPCIE_INDEX__SI                                 = 0x000C;
constexpr unsigned int mmPEER0_FB_OFFSET_HI__CI__VI                     = 0x14F3;
constexpr unsigned int mmPEER0_FB_OFFSET_LO__CI__VI                     = 0x14F2;
constexpr unsigned int mmPEER1_FB_OFFSET_HI__CI__VI                     = 0x14F1;
constexpr unsigned int mmPEER1_FB_OFFSET_LO__CI__VI                     = 0x14F0;
constexpr unsigned int mmPEER2_FB_OFFSET_HI__CI__VI                     = 0x14EF;
constexpr unsigned int mmPEER2_FB_OFFSET_LO__CI__VI                     = 0x14EE;
constexpr unsigned int mmPEER3_FB_OFFSET_HI__CI__VI                     = 0x14ED;
constexpr unsigned int mmPEER3_FB_OFFSET_LO__CI__VI                     = 0x14EC;
constexpr unsigned int mmPEER_REG_RANGE0                                = 0x153E;
constexpr unsigned int mmPEER_REG_RANGE1                                = 0x153F;
constexpr unsigned int mmPHY_AUX_CNTL__SI                               = 0x1953;
constexpr unsigned int mmPIPE0_ARBITRATION_CONTROL3__SI                 = 0x02FC;
constexpr unsigned int mmPIPE1_ARBITRATION_CONTROL3__SI                 = 0x0300;
constexpr unsigned int mmPIPE2_ARBITRATION_CONTROL3__SI                 = 0x0304;
constexpr unsigned int mmPIPE3_ARBITRATION_CONTROL3__SI                 = 0x0308;
constexpr unsigned int mmPIPE4_ARBITRATION_CONTROL3__SI                 = 0x030C;
constexpr unsigned int mmPIPE5_ARBITRATION_CONTROL3__SI                 = 0x0310;
constexpr unsigned int mmPIXCLK1_RESYNC_CNTL__SI                        = 0x0126;
constexpr unsigned int mmPIXCLK2_RESYNC_CNTL__SI                        = 0x0127;
constexpr unsigned int mmPLL_TEST_CNTL__SI                              = 0x0199;
constexpr unsigned int mmRAS_BCI_SIGNATURE0                             = 0x339E;
constexpr unsigned int mmRAS_BCI_SIGNATURE1                             = 0x339F;
constexpr unsigned int mmRAS_CB_SIGNATURE0                              = 0x339D;
constexpr unsigned int mmRAS_DB_SIGNATURE0                              = 0x338B;
constexpr unsigned int mmRAS_IA_SIGNATURE0                              = 0x3397;
constexpr unsigned int mmRAS_IA_SIGNATURE1                              = 0x3398;
constexpr unsigned int mmRAS_PA_SIGNATURE0                              = 0x338C;
constexpr unsigned int mmRAS_SC_SIGNATURE0                              = 0x338F;
constexpr unsigned int mmRAS_SC_SIGNATURE1                              = 0x3390;
constexpr unsigned int mmRAS_SC_SIGNATURE2                              = 0x3391;
constexpr unsigned int mmRAS_SC_SIGNATURE3                              = 0x3392;
constexpr unsigned int mmRAS_SC_SIGNATURE4                              = 0x3393;
constexpr unsigned int mmRAS_SC_SIGNATURE5                              = 0x3394;
constexpr unsigned int mmRAS_SC_SIGNATURE6                              = 0x3395;
constexpr unsigned int mmRAS_SC_SIGNATURE7                              = 0x3396;
constexpr unsigned int mmRAS_SIGNATURE_CONTROL                          = 0x3380;
constexpr unsigned int mmRAS_SIGNATURE_MASK                             = 0x3381;
constexpr unsigned int mmRAS_SPI_SIGNATURE0                             = 0x3399;
constexpr unsigned int mmRAS_SPI_SIGNATURE1                             = 0x339A;
constexpr unsigned int mmRAS_SQ_SIGNATURE0                              = 0x338E;
constexpr unsigned int mmRAS_SX_SIGNATURE0                              = 0x3382;
constexpr unsigned int mmRAS_SX_SIGNATURE1                              = 0x3383;
constexpr unsigned int mmRAS_SX_SIGNATURE2                              = 0x3384;
constexpr unsigned int mmRAS_SX_SIGNATURE3                              = 0x3385;
constexpr unsigned int mmRAS_TA_SIGNATURE0                              = 0x339B;
constexpr unsigned int mmRAS_TD_SIGNATURE0                              = 0x339C;
constexpr unsigned int mmRAS_VGT_SIGNATURE0                             = 0x338D;
constexpr unsigned int mmRCU_MISC_CTRL__SI                              = 0x0043;
constexpr unsigned int mmRCU_UC_EVENTS__SI                              = 0x0045;
constexpr unsigned int mmRLC_AUTO_PG_CTRL__CI                           = 0x3115;
constexpr unsigned int mmRLC_AUTO_PG_CTRL__SI                           = 0x310D;
constexpr unsigned int mmRLC_CAPTURE_GPU_CLOCK_COUNT__CI                = 0x30E6;
constexpr unsigned int mmRLC_CAPTURE_GPU_CLOCK_COUNT__SI                = 0x30D0;
constexpr unsigned int mmRLC_CGCG_CGLS_CTRL__CI                         = 0x3109;
constexpr unsigned int mmRLC_CGCG_CGLS_CTRL__SI                         = 0x3101;
constexpr unsigned int mmRLC_CGCG_RAMP_CTRL__CI                         = 0x310A;
constexpr unsigned int mmRLC_CGCG_RAMP_CTRL__SI                         = 0x3102;
constexpr unsigned int mmRLC_CGTT_MGCG_OVERRIDE__CI                     = 0x3108;
constexpr unsigned int mmRLC_CGTT_MGCG_OVERRIDE__SI                     = 0x3100;
constexpr unsigned int mmRLC_CU_STATUS__CI                              = 0x310E;
constexpr unsigned int mmRLC_CU_STATUS__SI                              = 0x3106;
constexpr unsigned int mmRLC_DEBUG_SELECT__CI                           = 0x30C1;
constexpr unsigned int mmRLC_DEBUG_SELECT__SI                           = 0x30C9;
constexpr unsigned int mmRLC_DEBUG__CI                                  = 0x30C2;
constexpr unsigned int mmRLC_DEBUG__SI                                  = 0x30CA;
constexpr unsigned int mmRLC_DRIVER_CPDMA_STATUS__CI                    = 0x30DE;
constexpr unsigned int mmRLC_DRIVER_CPDMA_STATUS__SI                    = 0x30C7;
constexpr unsigned int mmRLC_DYN_PG_REQUEST__CI                         = 0x310C;
constexpr unsigned int mmRLC_DYN_PG_REQUEST__SI                         = 0x3104;
constexpr unsigned int mmRLC_DYN_PG_STATUS__CI                          = 0x310B;
constexpr unsigned int mmRLC_DYN_PG_STATUS__SI                          = 0x3103;
constexpr unsigned int mmRLC_GPM_CU_PD_TIMEOUT__CI                      = 0x312B;
constexpr unsigned int mmRLC_GPM_DEBUG_SELECT__CI                       = 0x30E0;
constexpr unsigned int mmRLC_GPM_DEBUG__CI                              = 0x30E1;
constexpr unsigned int mmRLC_GPM_GENERAL_0__CI                          = 0x3123;
constexpr unsigned int mmRLC_GPM_GENERAL_1__CI                          = 0x3124;
constexpr unsigned int mmRLC_GPM_GENERAL_2__CI                          = 0x3125;
constexpr unsigned int mmRLC_GPM_GENERAL_3__CI                          = 0x3126;
constexpr unsigned int mmRLC_GPM_GENERAL_4__CI                          = 0x3127;
constexpr unsigned int mmRLC_GPM_GENERAL_5__CI                          = 0x3128;
constexpr unsigned int mmRLC_GPM_GENERAL_6__CI                          = 0x3129;
constexpr unsigned int mmRLC_GPM_GENERAL_7__CI                          = 0x312A;
constexpr unsigned int mmRLC_GPM_LOG_ADDR__CI                           = 0x3136;
constexpr unsigned int mmRLC_GPM_LOG_CONT__CI                           = 0x3138;
constexpr unsigned int mmRLC_GPM_LOG_SIZE__CI                           = 0x3137;
constexpr unsigned int mmRLC_GPM_PERF_COUNT_0__CI                       = 0x312F;
constexpr unsigned int mmRLC_GPM_PERF_COUNT_1__CI                       = 0x3130;
constexpr unsigned int mmRLC_GPM_SCRATCH_ADDR__CI                       = 0x312C;
constexpr unsigned int mmRLC_GPM_SCRATCH_DATA__CI                       = 0x312D;
constexpr unsigned int mmRLC_GPM_STAT__CI                               = 0x3100;
constexpr unsigned int mmRLC_GPM_THREAD_ENABLE__CI                      = 0x3105;
constexpr unsigned int mmRLC_GPM_THREAD_PRIORITY__CI                    = 0x3104;
constexpr unsigned int mmRLC_GPM_UCODE_ADDR__CI                         = 0x30E2;
constexpr unsigned int mmRLC_GPM_UCODE_DATA__CI                         = 0x30E3;
constexpr unsigned int mmRLC_GPM_VMID_THREAD0__CI                       = 0x3106;
constexpr unsigned int mmRLC_GPM_VMID_THREAD1__CI                       = 0x3107;
constexpr unsigned int mmRLC_GPR_REG1__CI                               = 0x3139;
constexpr unsigned int mmRLC_GPR_REG2__CI                               = 0x313A;
constexpr unsigned int mmRLC_GPU_CLOCK_32_RES_SEL__CI                   = 0x3101;
constexpr unsigned int mmRLC_GPU_CLOCK_32_RES_SEL__SI                   = 0x30D4;
constexpr unsigned int mmRLC_GPU_CLOCK_32__CI                           = 0x3102;
constexpr unsigned int mmRLC_GPU_CLOCK_32__SI                           = 0x30D5;
constexpr unsigned int mmRLC_GPU_CLOCK_COUNT_LSB__CI                    = 0x30E4;
constexpr unsigned int mmRLC_GPU_CLOCK_COUNT_LSB__SI                    = 0x30CE;
constexpr unsigned int mmRLC_GPU_CLOCK_COUNT_MSB__CI                    = 0x30E5;
constexpr unsigned int mmRLC_GPU_CLOCK_COUNT_MSB__SI                    = 0x30CF;
constexpr unsigned int mmRLC_JUMP_TABLE_RESTORE__CI                     = 0x30DE;
constexpr unsigned int mmRLC_LB_ALWAYS_ACTIVE_CU_MASK__CI               = 0x3110;
constexpr unsigned int mmRLC_LB_ALWAYS_ACTIVE_CU_MASK__SI               = 0x3108;
constexpr unsigned int mmRLC_LB_CNTL__CI                                = 0x30D9;
constexpr unsigned int mmRLC_LB_CNTL__SI                                = 0x30C3;
constexpr unsigned int mmRLC_LB_CNTR_INIT__CI                           = 0x30DB;
constexpr unsigned int mmRLC_LB_CNTR_INIT__SI                           = 0x30C6;
constexpr unsigned int mmRLC_LB_CNTR_MAX__CI                            = 0x30D2;
constexpr unsigned int mmRLC_LB_CNTR_MAX__SI                            = 0x30C5;
constexpr unsigned int mmRLC_LB_INIT_CU_MASK__CI                        = 0x310F;
constexpr unsigned int mmRLC_LB_INIT_CU_MASK__SI                        = 0x3107;
constexpr unsigned int mmRLC_LB_PARAMS__CI                              = 0x3111;
constexpr unsigned int mmRLC_LB_PARAMS__SI                              = 0x3109;
constexpr unsigned int mmRLC_LOAD_BALANCE_CNTR__CI                      = 0x30DC;
constexpr unsigned int mmRLC_LOAD_BALANCE_CNTR__SI                      = 0x30F6;
constexpr unsigned int mmRLC_MAX_PG_CU__CI                              = 0x3114;
constexpr unsigned int mmRLC_MAX_PG_CU__SI                              = 0x310C;
constexpr unsigned int mmRLC_MC_CNTL__CI                                = 0x30C3;
constexpr unsigned int mmRLC_MC_CNTL__SI                                = 0x30D1;
constexpr unsigned int mmRLC_MEM_SLP_CNTL__CI                           = 0x30C6;
constexpr unsigned int mmRLC_MEM_SLP_CNTL__SI                           = 0x30D8;
constexpr unsigned int mmRLC_PERFCOUNTER0_HI__CI__VI                    = 0xD481;
constexpr unsigned int mmRLC_PERFCOUNTER0_HI__SI                        = 0x30DC;
constexpr unsigned int mmRLC_PERFCOUNTER0_LO__CI__VI                    = 0xD480;
constexpr unsigned int mmRLC_PERFCOUNTER0_LO__SI                        = 0x30DB;
constexpr unsigned int mmRLC_PERFCOUNTER0_SELECT__CI__VI                = 0xDCC1;
constexpr unsigned int mmRLC_PERFCOUNTER0_SELECT__SI                    = 0x30DA;
constexpr unsigned int mmRLC_PERFCOUNTER1_HI__CI__VI                    = 0xD483;
constexpr unsigned int mmRLC_PERFCOUNTER1_HI__SI                        = 0x30DF;
constexpr unsigned int mmRLC_PERFCOUNTER1_LO__CI__VI                    = 0xD482;
constexpr unsigned int mmRLC_PERFCOUNTER1_LO__SI                        = 0x30DE;
constexpr unsigned int mmRLC_PERFCOUNTER1_SELECT__CI__VI                = 0xDCC2;
constexpr unsigned int mmRLC_PERFCOUNTER1_SELECT__SI                    = 0x30DD;
constexpr unsigned int mmRLC_PERFMON_CNTL__CI__VI                       = 0xDCC0;
constexpr unsigned int mmRLC_PERFMON_CNTL__SI                           = 0x30D9;
constexpr unsigned int mmRLC_PG_ALWAYS_ON_CU_MASK__CI                   = 0x3113;
constexpr unsigned int mmRLC_PG_ALWAYS_ON_CU_MASK__SI                   = 0x310B;
constexpr unsigned int mmRLC_PG_CNTL__CI                                = 0x3103;
constexpr unsigned int mmRLC_PG_CNTL__SI                                = 0x30D7;
constexpr unsigned int mmRLC_PG_DELAY_2__CI                             = 0x30DF;
constexpr unsigned int mmRLC_PG_DELAY__CI                               = 0x310D;
constexpr unsigned int mmRLC_SAFE_MODE__CI                              = 0x313A;
constexpr unsigned int mmRLC_SAVE_AND_RESTORE_BASE__CI                  = 0x30DD;
constexpr unsigned int mmRLC_SAVE_AND_RESTORE_BASE__SI                  = 0x30C4;
constexpr unsigned int mmRLC_SERDES_CU_MASTER_BUSY__CI                  = 0x3121;
constexpr unsigned int mmRLC_SERDES_NONCU_MASTER_BUSY__CI               = 0x3122;
constexpr unsigned int mmRLC_SERDES_RD_DATA_0__CI                       = 0x311A;
constexpr unsigned int mmRLC_SERDES_RD_DATA_0__SI                       = 0x3112;
constexpr unsigned int mmRLC_SERDES_RD_DATA_1__CI                       = 0x311B;
constexpr unsigned int mmRLC_SERDES_RD_DATA_1__SI                       = 0x3113;
constexpr unsigned int mmRLC_SERDES_RD_DATA_2__CI                       = 0x311C;
constexpr unsigned int mmRLC_SERDES_RD_DATA_2__SI                       = 0x3114;
constexpr unsigned int mmRLC_SERDES_RD_MASTER_INDEX__CI                 = 0x3119;
constexpr unsigned int mmRLC_SERDES_RD_MASTER_INDEX__SI                 = 0x3111;
constexpr unsigned int mmRLC_SERDES_WR_CTRL__CI                         = 0x311F;
constexpr unsigned int mmRLC_SERDES_WR_CTRL__SI                         = 0x3117;
constexpr unsigned int mmRLC_SERDES_WR_CU_MASTER_MASK__CI               = 0x311D;
constexpr unsigned int mmRLC_SERDES_WR_DATA__CI                         = 0x3120;
constexpr unsigned int mmRLC_SERDES_WR_DATA__SI                         = 0x3118;
constexpr unsigned int mmRLC_SERDES_WR_NONCU_MASTER_MASK__CI            = 0x311E;
constexpr unsigned int mmRLC_SMU_GRBM_REG_SAVE_CTRL__CI                 = 0x3116;
constexpr unsigned int mmRLC_SMU_GRBM_REG_SAVE_CTRL__SI                 = 0x310E;
constexpr unsigned int mmRLC_SMU_PG_CTRL__CI                            = 0x3117;
constexpr unsigned int mmRLC_SMU_PG_CTRL__SI                            = 0x310F;
constexpr unsigned int mmRLC_SMU_PG_WAKE_UP_CTRL__CI                    = 0x3118;
constexpr unsigned int mmRLC_SMU_PG_WAKE_UP_CTRL__SI                    = 0x3110;
constexpr unsigned int mmRLC_SOFT_RESET_GPU__CI                         = 0x30C5;
constexpr unsigned int mmRLC_SOFT_RESET_GPU__SI                         = 0x30D6;
constexpr unsigned int mmRLC_SPM_CB_PERFMON_SAMPLE_DELAY__CI__VI        = 0xDC8A;
constexpr unsigned int mmRLC_SPM_CPC_PERFMON_SAMPLE_DELAY__CI__VI       = 0xDC88;
constexpr unsigned int mmRLC_SPM_CPF_PERFMON_SAMPLE_DELAY__CI__VI       = 0xDC89;
constexpr unsigned int mmRLC_SPM_CPG_PERFMON_SAMPLE_DELAY__CI__VI       = 0xDC87;
constexpr unsigned int mmRLC_SPM_DB_PERFMON_SAMPLE_DELAY__CI__VI        = 0xDC8B;
constexpr unsigned int mmRLC_SPM_DEBUG_SELECT__CI                       = 0x3134;
constexpr unsigned int mmRLC_SPM_DEBUG__CI                              = 0x3135;
constexpr unsigned int mmRLC_SPM_GDS_PERFMON_SAMPLE_DELAY__CI__VI       = 0xDC8D;
constexpr unsigned int mmRLC_SPM_GLOBAL_MUXSEL_ADDR__CI__VI             = 0xDC9B;
constexpr unsigned int mmRLC_SPM_GLOBAL_MUXSEL_DATA__CI__VI             = 0xDC9C;
constexpr unsigned int mmRLC_SPM_IA_PERFMON_SAMPLE_DELAY__CI__VI        = 0xDC8E;
constexpr unsigned int mmRLC_SPM_INT_CNTL__CI                           = 0x3132;
constexpr unsigned int mmRLC_SPM_INT_STATUS__CI                         = 0x3133;
constexpr unsigned int mmRLC_SPM_PA_PERFMON_SAMPLE_DELAY__CI__VI        = 0xDC8C;
constexpr unsigned int mmRLC_SPM_PERFMON_CNTL__CI__VI                   = 0xDC80;
constexpr unsigned int mmRLC_SPM_PERFMON_RING_BASE_HI__CI__VI           = 0xDC82;
constexpr unsigned int mmRLC_SPM_PERFMON_RING_BASE_LO__CI__VI           = 0xDC81;
constexpr unsigned int mmRLC_SPM_PERFMON_RING_SIZE__CI__VI              = 0xDC83;
constexpr unsigned int mmRLC_SPM_PERFMON_SEGMENT_SIZE__CI__VI           = 0xDC84;
constexpr unsigned int mmRLC_SPM_RING_RDPTR__CI__VI                     = 0xDC9D;
constexpr unsigned int mmRLC_SPM_SC_PERFMON_SAMPLE_DELAY__CI__VI        = 0xDC90;
constexpr unsigned int mmRLC_SPM_SEGMENT_THRESHOLD__CI__VI              = 0xDC9E;
constexpr unsigned int mmRLC_SPM_SE_MUXSEL_ADDR__CI__VI                 = 0xDC85;
constexpr unsigned int mmRLC_SPM_SE_MUXSEL_DATA__CI__VI                 = 0xDC86;
constexpr unsigned int mmRLC_SPM_SPI_PERFMON_SAMPLE_DELAY__CI__VI       = 0xDC97;
constexpr unsigned int mmRLC_SPM_SQG_PERFMON_SAMPLE_DELAY__CI__VI       = 0xDC98;
constexpr unsigned int mmRLC_SPM_SX_PERFMON_SAMPLE_DELAY__CI__VI        = 0xDC9A;
constexpr unsigned int mmRLC_SPM_TA_PERFMON_SAMPLE_DELAY__CI__VI        = 0xDC94;
constexpr unsigned int mmRLC_SPM_TCA_PERFMON_SAMPLE_DELAY__CI__VI       = 0xDC92;
constexpr unsigned int mmRLC_SPM_TCC_PERFMON_SAMPLE_DELAY__CI__VI       = 0xDC91;
constexpr unsigned int mmRLC_SPM_TCP_PERFMON_SAMPLE_DELAY__CI__VI       = 0xDC93;
constexpr unsigned int mmRLC_SPM_TCS_PERFMON_SAMPLE_DELAY__CI           = 0xDC99;
constexpr unsigned int mmRLC_SPM_TD_PERFMON_SAMPLE_DELAY__CI__VI        = 0xDC95;
constexpr unsigned int mmRLC_SPM_VGT_PERFMON_SAMPLE_DELAY__CI__VI       = 0xDC96;
constexpr unsigned int mmRLC_SPM_VMID__CI                               = 0x3131;
constexpr unsigned int mmRLC_STATIC_PG_STATUS__CI                       = 0x312E;
constexpr unsigned int mmRLC_STAT__CI                                   = 0x30C4;
constexpr unsigned int mmRLC_STAT__SI                                   = 0x30D3;
constexpr unsigned int mmRLC_THREAD1_DELAY__CI                          = 0x3112;
constexpr unsigned int mmRLC_THREAD1_DELAY__SI                          = 0x310A;
constexpr unsigned int mmRLC_UCODE_CNTL__CI                             = 0x30E7;
constexpr unsigned int mmRLC_UCODE_CNTL__SI                             = 0x30D2;
constexpr unsigned int mmROM_CNTL__SI                                   = 0x0580;
constexpr unsigned int mmROM_DATA__SI                                   = 0x002B;
constexpr unsigned int mmROM_INDEX__SI                                  = 0x002A;
constexpr unsigned int mmROM_SMC_IND_DATA__CI__VI                       = 0x0081;
constexpr unsigned int mmROM_SMC_IND_INDEX__CI__VI                      = 0x0080;
constexpr unsigned int mmROM_START__SI                                  = 0x0585;
constexpr unsigned int mmROM_STATUS__SI                                 = 0x0582;
constexpr unsigned int mmROM_SW_CNTL__SI                                = 0x0586;
constexpr unsigned int mmROM_SW_COMMAND__SI                             = 0x0588;
constexpr unsigned int mmROM_SW_DATA_10__SI                             = 0x0592;
constexpr unsigned int mmROM_SW_DATA_11__SI                             = 0x0593;
constexpr unsigned int mmROM_SW_DATA_12__SI                             = 0x0594;
constexpr unsigned int mmROM_SW_DATA_13__SI                             = 0x0595;
constexpr unsigned int mmROM_SW_DATA_14__SI                             = 0x0596;
constexpr unsigned int mmROM_SW_DATA_15__SI                             = 0x0597;
constexpr unsigned int mmROM_SW_DATA_16__SI                             = 0x0598;
constexpr unsigned int mmROM_SW_DATA_17__SI                             = 0x0599;
constexpr unsigned int mmROM_SW_DATA_18__SI                             = 0x059A;
constexpr unsigned int mmROM_SW_DATA_19__SI                             = 0x059B;
constexpr unsigned int mmROM_SW_DATA_1__SI                              = 0x0589;
constexpr unsigned int mmROM_SW_DATA_20__SI                             = 0x059C;
constexpr unsigned int mmROM_SW_DATA_21__SI                             = 0x059D;
constexpr unsigned int mmROM_SW_DATA_22__SI                             = 0x059E;
constexpr unsigned int mmROM_SW_DATA_23__SI                             = 0x059F;
constexpr unsigned int mmROM_SW_DATA_24__SI                             = 0x05A0;
constexpr unsigned int mmROM_SW_DATA_25__SI                             = 0x05A1;
constexpr unsigned int mmROM_SW_DATA_26__SI                             = 0x05A2;
constexpr unsigned int mmROM_SW_DATA_27__SI                             = 0x05A3;
constexpr unsigned int mmROM_SW_DATA_28__SI                             = 0x05A4;
constexpr unsigned int mmROM_SW_DATA_29__SI                             = 0x05A5;
constexpr unsigned int mmROM_SW_DATA_2__SI                              = 0x058A;
constexpr unsigned int mmROM_SW_DATA_30__SI                             = 0x05A6;
constexpr unsigned int mmROM_SW_DATA_31__SI                             = 0x05A7;
constexpr unsigned int mmROM_SW_DATA_32__SI                             = 0x05A8;
constexpr unsigned int mmROM_SW_DATA_33__SI                             = 0x05A9;
constexpr unsigned int mmROM_SW_DATA_34__SI                             = 0x05AA;
constexpr unsigned int mmROM_SW_DATA_35__SI                             = 0x05AB;
constexpr unsigned int mmROM_SW_DATA_36__SI                             = 0x05AC;
constexpr unsigned int mmROM_SW_DATA_37__SI                             = 0x05AD;
constexpr unsigned int mmROM_SW_DATA_38__SI                             = 0x05AE;
constexpr unsigned int mmROM_SW_DATA_39__SI                             = 0x05AF;
constexpr unsigned int mmROM_SW_DATA_3__SI                              = 0x058B;
constexpr unsigned int mmROM_SW_DATA_40__SI                             = 0x05B0;
constexpr unsigned int mmROM_SW_DATA_41__SI                             = 0x05B1;
constexpr unsigned int mmROM_SW_DATA_42__SI                             = 0x05B2;
constexpr unsigned int mmROM_SW_DATA_43__SI                             = 0x05B3;
constexpr unsigned int mmROM_SW_DATA_44__SI                             = 0x05B4;
constexpr unsigned int mmROM_SW_DATA_45__SI                             = 0x05B5;
constexpr unsigned int mmROM_SW_DATA_46__SI                             = 0x05B6;
constexpr unsigned int mmROM_SW_DATA_47__SI                             = 0x05B7;
constexpr unsigned int mmROM_SW_DATA_48__SI                             = 0x05B8;
constexpr unsigned int mmROM_SW_DATA_49__SI                             = 0x05B9;
constexpr unsigned int mmROM_SW_DATA_4__SI                              = 0x058C;
constexpr unsigned int mmROM_SW_DATA_50__SI                             = 0x05BA;
constexpr unsigned int mmROM_SW_DATA_51__SI                             = 0x05BB;
constexpr unsigned int mmROM_SW_DATA_52__SI                             = 0x05BC;
constexpr unsigned int mmROM_SW_DATA_53__SI                             = 0x05BD;
constexpr unsigned int mmROM_SW_DATA_54__SI                             = 0x05BE;
constexpr unsigned int mmROM_SW_DATA_55__SI                             = 0x05BF;
constexpr unsigned int mmROM_SW_DATA_56__SI                             = 0x05C0;
constexpr unsigned int mmROM_SW_DATA_57__SI                             = 0x05C1;
constexpr unsigned int mmROM_SW_DATA_58__SI                             = 0x05C2;
constexpr unsigned int mmROM_SW_DATA_59__SI                             = 0x05C3;
constexpr unsigned int mmROM_SW_DATA_5__SI                              = 0x058D;
constexpr unsigned int mmROM_SW_DATA_60__SI                             = 0x05C4;
constexpr unsigned int mmROM_SW_DATA_61__SI                             = 0x05C5;
constexpr unsigned int mmROM_SW_DATA_62__SI                             = 0x05C6;
constexpr unsigned int mmROM_SW_DATA_63__SI                             = 0x05C7;
constexpr unsigned int mmROM_SW_DATA_64__SI                             = 0x05C8;
constexpr unsigned int mmROM_SW_DATA_6__SI                              = 0x058E;
constexpr unsigned int mmROM_SW_DATA_7__SI                              = 0x058F;
constexpr unsigned int mmROM_SW_DATA_8__SI                              = 0x0590;
constexpr unsigned int mmROM_SW_DATA_9__SI                              = 0x0591;
constexpr unsigned int mmROM_SW_STATUS__SI                              = 0x0587;
constexpr unsigned int mmSCL0_EXT_OVERSCAN_LEFT_RIGHT__SI__VI           = 0x1B5E;
constexpr unsigned int mmSCL0_EXT_OVERSCAN_TOP_BOTTOM__SI__VI           = 0x1B5F;
constexpr unsigned int mmSCL0_SCL_ALU_CONTROL__SI__VI                   = 0x1B54;
constexpr unsigned int mmSCL0_SCL_AUTOMATIC_MODE_CONTROL__SI__VI        = 0x1B47;
constexpr unsigned int mmSCL0_SCL_BYPASS_CONTROL__SI__VI                = 0x1B45;
constexpr unsigned int mmSCL0_SCL_COEF_RAM_CONFLICT_STATUS__SI__VI      = 0x1B55;
constexpr unsigned int mmSCL0_SCL_COEF_RAM_SELECT__SI__VI               = 0x1B40;
constexpr unsigned int mmSCL0_SCL_COEF_RAM_TAP_DATA__SI__VI             = 0x1B41;
constexpr unsigned int mmSCL0_SCL_CONTROL__SI__VI                       = 0x1B44;
constexpr unsigned int mmSCL0_SCL_DEBUG__SI__VI                         = 0x1B6A;
constexpr unsigned int mmSCL0_SCL_F_SHARP_CONTROL__SI__VI               = 0x1B53;
constexpr unsigned int mmSCL0_SCL_HORZ_FILTER_CONTROL__SI               = 0x1B4A;
constexpr unsigned int mmSCL0_SCL_HORZ_FILTER_SCALE_RATIO__SI           = 0x1B4B;
constexpr unsigned int mmSCL0_SCL_MANUAL_REPLICATE_CONTROL__SI__VI      = 0x1B46;
constexpr unsigned int mmSCL0_SCL_MODE_CHANGE_DET1__SI__VI              = 0x1B60;
constexpr unsigned int mmSCL0_SCL_MODE_CHANGE_DET2__SI__VI              = 0x1B61;
constexpr unsigned int mmSCL0_SCL_MODE_CHANGE_DET3__SI__VI              = 0x1B62;
constexpr unsigned int mmSCL0_SCL_MODE_CHANGE_MASK__SI__VI              = 0x1B63;
constexpr unsigned int mmSCL0_SCL_TAP_CONTROL__SI__VI                   = 0x1B43;
constexpr unsigned int mmSCL0_SCL_TEST_DEBUG_DATA__SI__VI               = 0x1B6C;
constexpr unsigned int mmSCL0_SCL_TEST_DEBUG_INDEX__SI__VI              = 0x1B6B;
constexpr unsigned int mmSCL0_SCL_UPDATE__SI__VI                        = 0x1B51;
constexpr unsigned int mmSCL0_SCL_VERT_FILTER_CONTROL__SI               = 0x1B4E;
constexpr unsigned int mmSCL0_SCL_VERT_FILTER_INIT_BOT__SI              = 0x1B57;
constexpr unsigned int mmSCL0_SCL_VERT_FILTER_INIT__SI                  = 0x1B50;
constexpr unsigned int mmSCL0_SCL_VERT_FILTER_SCALE_RATIO__SI           = 0x1B4F;
constexpr unsigned int mmSCL0_VIEWPORT_SIZE__SI__VI                     = 0x1B5D;
constexpr unsigned int mmSCL0_VIEWPORT_START__SI__VI                    = 0x1B5C;
constexpr unsigned int mmSCL1_EXT_OVERSCAN_LEFT_RIGHT__SI               = 0x1E5E;
constexpr unsigned int mmSCL1_EXT_OVERSCAN_TOP_BOTTOM__SI               = 0x1E5F;
constexpr unsigned int mmSCL1_SCL_ALU_CONTROL__SI                       = 0x1E54;
constexpr unsigned int mmSCL1_SCL_AUTOMATIC_MODE_CONTROL__SI            = 0x1E47;
constexpr unsigned int mmSCL1_SCL_BYPASS_CONTROL__SI                    = 0x1E45;
constexpr unsigned int mmSCL1_SCL_COEF_RAM_CONFLICT_STATUS__SI          = 0x1E55;
constexpr unsigned int mmSCL1_SCL_COEF_RAM_SELECT__SI                   = 0x1E40;
constexpr unsigned int mmSCL1_SCL_COEF_RAM_TAP_DATA__SI                 = 0x1E41;
constexpr unsigned int mmSCL1_SCL_CONTROL__SI                           = 0x1E44;
constexpr unsigned int mmSCL1_SCL_DEBUG__SI                             = 0x1E6A;
constexpr unsigned int mmSCL1_SCL_F_SHARP_CONTROL__SI                   = 0x1E53;
constexpr unsigned int mmSCL1_SCL_HORZ_FILTER_CONTROL__SI               = 0x1E4A;
constexpr unsigned int mmSCL1_SCL_HORZ_FILTER_SCALE_RATIO__SI           = 0x1E4B;
constexpr unsigned int mmSCL1_SCL_MANUAL_REPLICATE_CONTROL__SI          = 0x1E46;
constexpr unsigned int mmSCL1_SCL_MODE_CHANGE_DET1__SI                  = 0x1E60;
constexpr unsigned int mmSCL1_SCL_MODE_CHANGE_DET2__SI                  = 0x1E61;
constexpr unsigned int mmSCL1_SCL_MODE_CHANGE_DET3__SI                  = 0x1E62;
constexpr unsigned int mmSCL1_SCL_MODE_CHANGE_MASK__SI                  = 0x1E63;
constexpr unsigned int mmSCL1_SCL_TAP_CONTROL__SI                       = 0x1E43;
constexpr unsigned int mmSCL1_SCL_TEST_DEBUG_DATA__SI                   = 0x1E6C;
constexpr unsigned int mmSCL1_SCL_TEST_DEBUG_INDEX__SI                  = 0x1E6B;
constexpr unsigned int mmSCL1_SCL_UPDATE__SI                            = 0x1E51;
constexpr unsigned int mmSCL1_SCL_VERT_FILTER_CONTROL__SI               = 0x1E4E;
constexpr unsigned int mmSCL1_SCL_VERT_FILTER_INIT_BOT__SI              = 0x1E57;
constexpr unsigned int mmSCL1_SCL_VERT_FILTER_INIT__SI                  = 0x1E50;
constexpr unsigned int mmSCL1_SCL_VERT_FILTER_SCALE_RATIO__SI           = 0x1E4F;
constexpr unsigned int mmSCL1_VIEWPORT_SIZE__SI                         = 0x1E5D;
constexpr unsigned int mmSCL1_VIEWPORT_START__SI                        = 0x1E5C;
constexpr unsigned int mmSCL2_EXT_OVERSCAN_LEFT_RIGHT__SI               = 0x415E;
constexpr unsigned int mmSCL2_EXT_OVERSCAN_TOP_BOTTOM__SI               = 0x415F;
constexpr unsigned int mmSCL2_SCL_ALU_CONTROL__SI                       = 0x4154;
constexpr unsigned int mmSCL2_SCL_AUTOMATIC_MODE_CONTROL__SI            = 0x4147;
constexpr unsigned int mmSCL2_SCL_BYPASS_CONTROL__SI                    = 0x4145;
constexpr unsigned int mmSCL2_SCL_COEF_RAM_CONFLICT_STATUS__SI          = 0x4155;
constexpr unsigned int mmSCL2_SCL_COEF_RAM_SELECT__SI                   = 0x4140;
constexpr unsigned int mmSCL2_SCL_COEF_RAM_TAP_DATA__SI                 = 0x4141;
constexpr unsigned int mmSCL2_SCL_CONTROL__SI                           = 0x4144;
constexpr unsigned int mmSCL2_SCL_DEBUG__SI                             = 0x416A;
constexpr unsigned int mmSCL2_SCL_F_SHARP_CONTROL__SI                   = 0x4153;
constexpr unsigned int mmSCL2_SCL_HORZ_FILTER_CONTROL__SI               = 0x414A;
constexpr unsigned int mmSCL2_SCL_HORZ_FILTER_SCALE_RATIO__SI           = 0x414B;
constexpr unsigned int mmSCL2_SCL_MANUAL_REPLICATE_CONTROL__SI          = 0x4146;
constexpr unsigned int mmSCL2_SCL_MODE_CHANGE_DET1__SI                  = 0x4160;
constexpr unsigned int mmSCL2_SCL_MODE_CHANGE_DET2__SI                  = 0x4161;
constexpr unsigned int mmSCL2_SCL_MODE_CHANGE_DET3__SI                  = 0x4162;
constexpr unsigned int mmSCL2_SCL_MODE_CHANGE_MASK__SI                  = 0x4163;
constexpr unsigned int mmSCL2_SCL_TAP_CONTROL__SI                       = 0x4143;
constexpr unsigned int mmSCL2_SCL_TEST_DEBUG_DATA__SI                   = 0x416C;
constexpr unsigned int mmSCL2_SCL_TEST_DEBUG_INDEX__SI                  = 0x416B;
constexpr unsigned int mmSCL2_SCL_UPDATE__SI                            = 0x4151;
constexpr unsigned int mmSCL2_SCL_VERT_FILTER_CONTROL__SI               = 0x414E;
constexpr unsigned int mmSCL2_SCL_VERT_FILTER_INIT_BOT__SI              = 0x4157;
constexpr unsigned int mmSCL2_SCL_VERT_FILTER_INIT__SI                  = 0x4150;
constexpr unsigned int mmSCL2_SCL_VERT_FILTER_SCALE_RATIO__SI           = 0x414F;
constexpr unsigned int mmSCL2_VIEWPORT_SIZE__SI                         = 0x415D;
constexpr unsigned int mmSCL2_VIEWPORT_START__SI                        = 0x415C;
constexpr unsigned int mmSCL3_EXT_OVERSCAN_LEFT_RIGHT__SI               = 0x445E;
constexpr unsigned int mmSCL3_EXT_OVERSCAN_TOP_BOTTOM__SI               = 0x445F;
constexpr unsigned int mmSCL3_SCL_ALU_CONTROL__SI                       = 0x4454;
constexpr unsigned int mmSCL3_SCL_AUTOMATIC_MODE_CONTROL__SI            = 0x4447;
constexpr unsigned int mmSCL3_SCL_BYPASS_CONTROL__SI                    = 0x4445;
constexpr unsigned int mmSCL3_SCL_COEF_RAM_CONFLICT_STATUS__SI          = 0x4455;
constexpr unsigned int mmSCL3_SCL_COEF_RAM_SELECT__SI                   = 0x4440;
constexpr unsigned int mmSCL3_SCL_COEF_RAM_TAP_DATA__SI                 = 0x4441;
constexpr unsigned int mmSCL3_SCL_CONTROL__SI                           = 0x4444;
constexpr unsigned int mmSCL3_SCL_DEBUG__SI                             = 0x446A;
constexpr unsigned int mmSCL3_SCL_F_SHARP_CONTROL__SI                   = 0x4453;
constexpr unsigned int mmSCL3_SCL_HORZ_FILTER_CONTROL__SI               = 0x444A;
constexpr unsigned int mmSCL3_SCL_HORZ_FILTER_SCALE_RATIO__SI           = 0x444B;
constexpr unsigned int mmSCL3_SCL_MANUAL_REPLICATE_CONTROL__SI          = 0x4446;
constexpr unsigned int mmSCL3_SCL_MODE_CHANGE_DET1__SI                  = 0x4460;
constexpr unsigned int mmSCL3_SCL_MODE_CHANGE_DET2__SI                  = 0x4461;
constexpr unsigned int mmSCL3_SCL_MODE_CHANGE_DET3__SI                  = 0x4462;
constexpr unsigned int mmSCL3_SCL_MODE_CHANGE_MASK__SI                  = 0x4463;
constexpr unsigned int mmSCL3_SCL_TAP_CONTROL__SI                       = 0x4443;
constexpr unsigned int mmSCL3_SCL_TEST_DEBUG_DATA__SI                   = 0x446C;
constexpr unsigned int mmSCL3_SCL_TEST_DEBUG_INDEX__SI                  = 0x446B;
constexpr unsigned int mmSCL3_SCL_UPDATE__SI                            = 0x4451;
constexpr unsigned int mmSCL3_SCL_VERT_FILTER_CONTROL__SI               = 0x444E;
constexpr unsigned int mmSCL3_SCL_VERT_FILTER_INIT_BOT__SI              = 0x4457;
constexpr unsigned int mmSCL3_SCL_VERT_FILTER_INIT__SI                  = 0x4450;
constexpr unsigned int mmSCL3_SCL_VERT_FILTER_SCALE_RATIO__SI           = 0x444F;
constexpr unsigned int mmSCL3_VIEWPORT_SIZE__SI                         = 0x445D;
constexpr unsigned int mmSCL3_VIEWPORT_START__SI                        = 0x445C;
constexpr unsigned int mmSCL4_EXT_OVERSCAN_LEFT_RIGHT__SI               = 0x475E;
constexpr unsigned int mmSCL4_EXT_OVERSCAN_TOP_BOTTOM__SI               = 0x475F;
constexpr unsigned int mmSCL4_SCL_ALU_CONTROL__SI                       = 0x4754;
constexpr unsigned int mmSCL4_SCL_AUTOMATIC_MODE_CONTROL__SI            = 0x4747;
constexpr unsigned int mmSCL4_SCL_BYPASS_CONTROL__SI                    = 0x4745;
constexpr unsigned int mmSCL4_SCL_COEF_RAM_CONFLICT_STATUS__SI          = 0x4755;
constexpr unsigned int mmSCL4_SCL_COEF_RAM_SELECT__SI                   = 0x4740;
constexpr unsigned int mmSCL4_SCL_COEF_RAM_TAP_DATA__SI                 = 0x4741;
constexpr unsigned int mmSCL4_SCL_CONTROL__SI                           = 0x4744;
constexpr unsigned int mmSCL4_SCL_DEBUG__SI                             = 0x476A;
constexpr unsigned int mmSCL4_SCL_F_SHARP_CONTROL__SI                   = 0x4753;
constexpr unsigned int mmSCL4_SCL_HORZ_FILTER_CONTROL__SI               = 0x474A;
constexpr unsigned int mmSCL4_SCL_HORZ_FILTER_SCALE_RATIO__SI           = 0x474B;
constexpr unsigned int mmSCL4_SCL_MANUAL_REPLICATE_CONTROL__SI          = 0x4746;
constexpr unsigned int mmSCL4_SCL_MODE_CHANGE_DET1__SI                  = 0x4760;
constexpr unsigned int mmSCL4_SCL_MODE_CHANGE_DET2__SI                  = 0x4761;
constexpr unsigned int mmSCL4_SCL_MODE_CHANGE_DET3__SI                  = 0x4762;
constexpr unsigned int mmSCL4_SCL_MODE_CHANGE_MASK__SI                  = 0x4763;
constexpr unsigned int mmSCL4_SCL_TAP_CONTROL__SI                       = 0x4743;
constexpr unsigned int mmSCL4_SCL_TEST_DEBUG_DATA__SI                   = 0x476C;
constexpr unsigned int mmSCL4_SCL_TEST_DEBUG_INDEX__SI                  = 0x476B;
constexpr unsigned int mmSCL4_SCL_UPDATE__SI                            = 0x4751;
constexpr unsigned int mmSCL4_SCL_VERT_FILTER_CONTROL__SI               = 0x474E;
constexpr unsigned int mmSCL4_SCL_VERT_FILTER_INIT_BOT__SI              = 0x4757;
constexpr unsigned int mmSCL4_SCL_VERT_FILTER_INIT__SI                  = 0x4750;
constexpr unsigned int mmSCL4_SCL_VERT_FILTER_SCALE_RATIO__SI           = 0x474F;
constexpr unsigned int mmSCL4_VIEWPORT_SIZE__SI                         = 0x475D;
constexpr unsigned int mmSCL4_VIEWPORT_START__SI                        = 0x475C;
constexpr unsigned int mmSCL5_EXT_OVERSCAN_LEFT_RIGHT__SI               = 0x4A5E;
constexpr unsigned int mmSCL5_EXT_OVERSCAN_TOP_BOTTOM__SI               = 0x4A5F;
constexpr unsigned int mmSCL5_SCL_ALU_CONTROL__SI                       = 0x4A54;
constexpr unsigned int mmSCL5_SCL_AUTOMATIC_MODE_CONTROL__SI            = 0x4A47;
constexpr unsigned int mmSCL5_SCL_BYPASS_CONTROL__SI                    = 0x4A45;
constexpr unsigned int mmSCL5_SCL_COEF_RAM_CONFLICT_STATUS__SI          = 0x4A55;
constexpr unsigned int mmSCL5_SCL_COEF_RAM_SELECT__SI                   = 0x4A40;
constexpr unsigned int mmSCL5_SCL_COEF_RAM_TAP_DATA__SI                 = 0x4A41;
constexpr unsigned int mmSCL5_SCL_CONTROL__SI                           = 0x4A44;
constexpr unsigned int mmSCL5_SCL_DEBUG__SI                             = 0x4A6A;
constexpr unsigned int mmSCL5_SCL_F_SHARP_CONTROL__SI                   = 0x4A53;
constexpr unsigned int mmSCL5_SCL_HORZ_FILTER_CONTROL__SI               = 0x4A4A;
constexpr unsigned int mmSCL5_SCL_HORZ_FILTER_SCALE_RATIO__SI           = 0x4A4B;
constexpr unsigned int mmSCL5_SCL_MANUAL_REPLICATE_CONTROL__SI          = 0x4A46;
constexpr unsigned int mmSCL5_SCL_MODE_CHANGE_DET1__SI                  = 0x4A60;
constexpr unsigned int mmSCL5_SCL_MODE_CHANGE_DET2__SI                  = 0x4A61;
constexpr unsigned int mmSCL5_SCL_MODE_CHANGE_DET3__SI                  = 0x4A62;
constexpr unsigned int mmSCL5_SCL_MODE_CHANGE_MASK__SI                  = 0x4A63;
constexpr unsigned int mmSCL5_SCL_TAP_CONTROL__SI                       = 0x4A43;
constexpr unsigned int mmSCL5_SCL_TEST_DEBUG_DATA__SI                   = 0x4A6C;
constexpr unsigned int mmSCL5_SCL_TEST_DEBUG_INDEX__SI                  = 0x4A6B;
constexpr unsigned int mmSCL5_SCL_UPDATE__SI                            = 0x4A51;
constexpr unsigned int mmSCL5_SCL_VERT_FILTER_CONTROL__SI               = 0x4A4E;
constexpr unsigned int mmSCL5_SCL_VERT_FILTER_INIT_BOT__SI              = 0x4A57;
constexpr unsigned int mmSCL5_SCL_VERT_FILTER_INIT__SI                  = 0x4A50;
constexpr unsigned int mmSCL5_SCL_VERT_FILTER_SCALE_RATIO__SI           = 0x4A4F;
constexpr unsigned int mmSCL5_VIEWPORT_SIZE__SI                         = 0x4A5D;
constexpr unsigned int mmSCL5_VIEWPORT_START__SI                        = 0x4A5C;
constexpr unsigned int mmSCLK_CGTT_BLK_CTRL_REG__SI                     = 0x0129;
constexpr unsigned int mmSCLK_PWRMGT_CNTL__SI                           = 0x01E2;
constexpr unsigned int mmSCL_ALU_CONTROL__SI__VI                        = 0x1B54;
constexpr unsigned int mmSCL_AUTOMATIC_MODE_CONTROL__SI__VI             = 0x1B47;
constexpr unsigned int mmSCL_BYPASS_CONTROL__SI__VI                     = 0x1B45;
constexpr unsigned int mmSCL_COEF_RAM_CONFLICT_STATUS__SI__VI           = 0x1B55;
constexpr unsigned int mmSCL_COEF_RAM_SELECT__SI__VI                    = 0x1B40;
constexpr unsigned int mmSCL_COEF_RAM_TAP_DATA__SI__VI                  = 0x1B41;
constexpr unsigned int mmSCL_CONTROL__SI__VI                            = 0x1B44;
constexpr unsigned int mmSCL_DEBUG__SI__VI                              = 0x1B6A;
constexpr unsigned int mmSCL_F_SHARP_CONTROL__SI__VI                    = 0x1B53;
constexpr unsigned int mmSCL_HORZ_FILTER_CONTROL__SI                    = 0x1B4A;
constexpr unsigned int mmSCL_HORZ_FILTER_SCALE_RATIO__SI                = 0x1B4B;
constexpr unsigned int mmSCL_MANUAL_REPLICATE_CONTROL__SI__VI           = 0x1B46;
constexpr unsigned int mmSCL_MODE_CHANGE_DET1__SI__VI                   = 0x1B60;
constexpr unsigned int mmSCL_MODE_CHANGE_DET2__SI__VI                   = 0x1B61;
constexpr unsigned int mmSCL_MODE_CHANGE_DET3__SI__VI                   = 0x1B62;
constexpr unsigned int mmSCL_MODE_CHANGE_MASK__SI__VI                   = 0x1B63;
constexpr unsigned int mmSCL_TAP_CONTROL__SI__VI                        = 0x1B43;
constexpr unsigned int mmSCL_TEST_DEBUG_DATA__SI__VI                    = 0x1B6C;
constexpr unsigned int mmSCL_TEST_DEBUG_INDEX__SI__VI                   = 0x1B6B;
constexpr unsigned int mmSCL_UPDATE__SI__VI                             = 0x1B51;
constexpr unsigned int mmSCL_VERT_FILTER_CONTROL__SI                    = 0x1B4E;
constexpr unsigned int mmSCL_VERT_FILTER_INIT_BOT__SI                   = 0x1B57;
constexpr unsigned int mmSCL_VERT_FILTER_INIT__SI                       = 0x1B50;
constexpr unsigned int mmSCL_VERT_FILTER_SCALE_RATIO__SI                = 0x1B4F;
constexpr unsigned int mmSCRATCH_ADDR__CI__VI                           = 0xC051;
constexpr unsigned int mmSCRATCH_ADDR__SI                               = 0x2151;
constexpr unsigned int mmSCRATCH_REG0__CI__VI                           = 0xC040;
constexpr unsigned int mmSCRATCH_REG0__SI                               = 0x2140;
constexpr unsigned int mmSCRATCH_REG1__CI__VI                           = 0xC041;
constexpr unsigned int mmSCRATCH_REG1__SI                               = 0x2141;
constexpr unsigned int mmSCRATCH_REG2__CI__VI                           = 0xC042;
constexpr unsigned int mmSCRATCH_REG2__SI                               = 0x2142;
constexpr unsigned int mmSCRATCH_REG3__CI__VI                           = 0xC043;
constexpr unsigned int mmSCRATCH_REG3__SI                               = 0x2143;
constexpr unsigned int mmSCRATCH_REG4__CI__VI                           = 0xC044;
constexpr unsigned int mmSCRATCH_REG4__SI                               = 0x2144;
constexpr unsigned int mmSCRATCH_REG5__CI__VI                           = 0xC045;
constexpr unsigned int mmSCRATCH_REG5__SI                               = 0x2145;
constexpr unsigned int mmSCRATCH_REG6__CI__VI                           = 0xC046;
constexpr unsigned int mmSCRATCH_REG6__SI                               = 0x2146;
constexpr unsigned int mmSCRATCH_REG7__CI__VI                           = 0xC047;
constexpr unsigned int mmSCRATCH_REG7__SI                               = 0x2147;
constexpr unsigned int mmSCRATCH_UMSK__CI__VI                           = 0xC050;
constexpr unsigned int mmSCRATCH_UMSK__SI                               = 0x2150;
constexpr unsigned int mmSDMA0_CHICKEN_BITS__CI__VI                     = 0x3405;
constexpr unsigned int mmSDMA0_CLK_CTRL__CI__VI                         = 0x3403;
constexpr unsigned int mmSDMA0_CNTL__CI__VI                             = 0x3404;
constexpr unsigned int mmSDMA0_F32_CNTL__CI__VI                         = 0x3412;
constexpr unsigned int mmSDMA0_FREEZE__CI__VI                           = 0x3413;
constexpr unsigned int mmSDMA0_GFX_APE1_CNTL__CI__VI                    = 0x34A8;
constexpr unsigned int mmSDMA0_GFX_CONTEXT_CNTL__CI__VI                 = 0x3493;
constexpr unsigned int mmSDMA0_GFX_CONTEXT_STATUS__CI__VI               = 0x3491;
constexpr unsigned int mmSDMA0_GFX_IB_BASE_HI__CI__VI                   = 0x348E;
constexpr unsigned int mmSDMA0_GFX_IB_BASE_LO__CI__VI                   = 0x348D;
constexpr unsigned int mmSDMA0_GFX_IB_CNTL__CI__VI                      = 0x348A;
constexpr unsigned int mmSDMA0_GFX_IB_OFFSET__CI__VI                    = 0x348C;
constexpr unsigned int mmSDMA0_GFX_IB_RPTR__CI__VI                      = 0x348B;
constexpr unsigned int mmSDMA0_GFX_IB_SIZE__CI__VI                      = 0x348F;
constexpr unsigned int mmSDMA0_GFX_RB_BASE_HI__CI__VI                   = 0x3482;
constexpr unsigned int mmSDMA0_GFX_RB_BASE__CI__VI                      = 0x3481;
constexpr unsigned int mmSDMA0_GFX_RB_CNTL__CI__VI                      = 0x3480;
constexpr unsigned int mmSDMA0_GFX_RB_RPTR_ADDR_HI__CI__VI              = 0x3488;
constexpr unsigned int mmSDMA0_GFX_RB_RPTR_ADDR_LO__CI__VI              = 0x3489;
constexpr unsigned int mmSDMA0_GFX_RB_RPTR__CI__VI                      = 0x3483;
constexpr unsigned int mmSDMA0_GFX_RB_WPTR_POLL_ADDR_HI__CI__VI         = 0x3486;
constexpr unsigned int mmSDMA0_GFX_RB_WPTR_POLL_ADDR_LO__CI__VI         = 0x3487;
constexpr unsigned int mmSDMA0_GFX_RB_WPTR_POLL_CNTL__CI__VI            = 0x3485;
constexpr unsigned int mmSDMA0_GFX_RB_WPTR__CI__VI                      = 0x3484;
constexpr unsigned int mmSDMA0_GFX_SKIP_CNTL__CI__VI                    = 0x3490;
constexpr unsigned int mmSDMA0_GFX_VIRTUAL_ADDR__CI__VI                 = 0x34A7;
constexpr unsigned int mmSDMA0_HASH__CI__VI                             = 0x3407;
constexpr unsigned int mmSDMA0_IB_OFFSET_FETCH__CI__VI                  = 0x340B;
constexpr unsigned int mmSDMA0_PERFCOUNTER0_RESULT__CI                  = 0x3410;
constexpr unsigned int mmSDMA0_PERFCOUNTER1_RESULT__CI                  = 0x3411;
constexpr unsigned int mmSDMA0_PERFMON_CNTL__CI                         = 0x340F;
constexpr unsigned int mmSDMA0_PHASE0_QUANTUM__CI__VI                   = 0x3414;
constexpr unsigned int mmSDMA0_PHASE1_QUANTUM__CI__VI                   = 0x3415;
constexpr unsigned int mmSDMA0_POWER_CNTL__CI__VI                       = 0x3402;
constexpr unsigned int mmSDMA0_PROGRAM__CI__VI                          = 0x340C;
constexpr unsigned int mmSDMA0_RB_RPTR_FETCH__CI__VI                    = 0x340A;
constexpr unsigned int mmSDMA0_RLC0_APE1_CNTL__CI__VI                   = 0x3528;
constexpr unsigned int mmSDMA0_RLC0_CONTEXT_STATUS__CI__VI              = 0x3511;
constexpr unsigned int mmSDMA0_RLC0_DOORBELL_LOG__CI__VI                = 0x3529;
constexpr unsigned int mmSDMA0_RLC0_DOORBELL__CI__VI                    = 0x3512;
constexpr unsigned int mmSDMA0_RLC0_IB_BASE_HI__CI__VI                  = 0x350E;
constexpr unsigned int mmSDMA0_RLC0_IB_BASE_LO__CI__VI                  = 0x350D;
constexpr unsigned int mmSDMA0_RLC0_IB_CNTL__CI__VI                     = 0x350A;
constexpr unsigned int mmSDMA0_RLC0_IB_OFFSET__CI__VI                   = 0x350C;
constexpr unsigned int mmSDMA0_RLC0_IB_RPTR__CI__VI                     = 0x350B;
constexpr unsigned int mmSDMA0_RLC0_IB_SIZE__CI__VI                     = 0x350F;
constexpr unsigned int mmSDMA0_RLC0_RB_BASE_HI__CI__VI                  = 0x3502;
constexpr unsigned int mmSDMA0_RLC0_RB_BASE__CI__VI                     = 0x3501;
constexpr unsigned int mmSDMA0_RLC0_RB_CNTL__CI__VI                     = 0x3500;
constexpr unsigned int mmSDMA0_RLC0_RB_RPTR_ADDR_HI__CI__VI             = 0x3508;
constexpr unsigned int mmSDMA0_RLC0_RB_RPTR_ADDR_LO__CI__VI             = 0x3509;
constexpr unsigned int mmSDMA0_RLC0_RB_RPTR__CI__VI                     = 0x3503;
constexpr unsigned int mmSDMA0_RLC0_RB_WPTR_POLL_ADDR_HI__CI__VI        = 0x3506;
constexpr unsigned int mmSDMA0_RLC0_RB_WPTR_POLL_ADDR_LO__CI__VI        = 0x3507;
constexpr unsigned int mmSDMA0_RLC0_RB_WPTR_POLL_CNTL__CI__VI           = 0x3505;
constexpr unsigned int mmSDMA0_RLC0_RB_WPTR__CI__VI                     = 0x3504;
constexpr unsigned int mmSDMA0_RLC0_SKIP_CNTL__CI__VI                   = 0x3510;
constexpr unsigned int mmSDMA0_RLC0_VIRTUAL_ADDR__CI__VI                = 0x3527;
constexpr unsigned int mmSDMA0_RLC1_APE1_CNTL__CI__VI                   = 0x35A8;
constexpr unsigned int mmSDMA0_RLC1_CONTEXT_STATUS__CI__VI              = 0x3591;
constexpr unsigned int mmSDMA0_RLC1_DOORBELL_LOG__CI__VI                = 0x35A9;
constexpr unsigned int mmSDMA0_RLC1_DOORBELL__CI__VI                    = 0x3592;
constexpr unsigned int mmSDMA0_RLC1_IB_BASE_HI__CI__VI                  = 0x358E;
constexpr unsigned int mmSDMA0_RLC1_IB_BASE_LO__CI__VI                  = 0x358D;
constexpr unsigned int mmSDMA0_RLC1_IB_CNTL__CI__VI                     = 0x358A;
constexpr unsigned int mmSDMA0_RLC1_IB_OFFSET__CI__VI                   = 0x358C;
constexpr unsigned int mmSDMA0_RLC1_IB_RPTR__CI__VI                     = 0x358B;
constexpr unsigned int mmSDMA0_RLC1_IB_SIZE__CI__VI                     = 0x358F;
constexpr unsigned int mmSDMA0_RLC1_RB_BASE_HI__CI__VI                  = 0x3582;
constexpr unsigned int mmSDMA0_RLC1_RB_BASE__CI__VI                     = 0x3581;
constexpr unsigned int mmSDMA0_RLC1_RB_CNTL__CI__VI                     = 0x3580;
constexpr unsigned int mmSDMA0_RLC1_RB_RPTR_ADDR_HI__CI__VI             = 0x3588;
constexpr unsigned int mmSDMA0_RLC1_RB_RPTR_ADDR_LO__CI__VI             = 0x3589;
constexpr unsigned int mmSDMA0_RLC1_RB_RPTR__CI__VI                     = 0x3583;
constexpr unsigned int mmSDMA0_RLC1_RB_WPTR_POLL_ADDR_HI__CI__VI        = 0x3586;
constexpr unsigned int mmSDMA0_RLC1_RB_WPTR_POLL_ADDR_LO__CI__VI        = 0x3587;
constexpr unsigned int mmSDMA0_RLC1_RB_WPTR_POLL_CNTL__CI__VI           = 0x3585;
constexpr unsigned int mmSDMA0_RLC1_RB_WPTR__CI__VI                     = 0x3584;
constexpr unsigned int mmSDMA0_RLC1_SKIP_CNTL__CI__VI                   = 0x3590;
constexpr unsigned int mmSDMA0_RLC1_VIRTUAL_ADDR__CI__VI                = 0x35A7;
constexpr unsigned int mmSDMA0_SEM_INCOMPLETE_TIMER_CNTL__CI            = 0x3408;
constexpr unsigned int mmSDMA0_SEM_WAIT_FAIL_TIMER_CNTL__CI__VI         = 0x3409;
constexpr unsigned int mmSDMA0_STATUS1_REG__CI__VI                      = 0x340E;
constexpr unsigned int mmSDMA0_STATUS_REG__CI__VI                       = 0x340D;
constexpr unsigned int mmSDMA0_TILING_CONFIG__CI__VI                    = 0x3406;
constexpr unsigned int mmSDMA0_UCODE_ADDR__CI__VI                       = 0x3400;
constexpr unsigned int mmSDMA0_UCODE_DATA__CI__VI                       = 0x3401;
constexpr unsigned int mmSDMA1_CHICKEN_BITS__CI__VI                     = 0x3605;
constexpr unsigned int mmSDMA1_CLK_CTRL__CI__VI                         = 0x3603;
constexpr unsigned int mmSDMA1_CNTL__CI__VI                             = 0x3604;
constexpr unsigned int mmSDMA1_CONFIG__CI__VI                           = 0x0F92;
constexpr unsigned int mmSDMA1_F32_CNTL__CI__VI                         = 0x3612;
constexpr unsigned int mmSDMA1_FREEZE__CI__VI                           = 0x3613;
constexpr unsigned int mmSDMA1_GFX_APE1_CNTL__CI__VI                    = 0x36A8;
constexpr unsigned int mmSDMA1_GFX_CONTEXT_CNTL__CI__VI                 = 0x3693;
constexpr unsigned int mmSDMA1_GFX_CONTEXT_STATUS__CI__VI               = 0x3691;
constexpr unsigned int mmSDMA1_GFX_IB_BASE_HI__CI__VI                   = 0x368E;
constexpr unsigned int mmSDMA1_GFX_IB_BASE_LO__CI__VI                   = 0x368D;
constexpr unsigned int mmSDMA1_GFX_IB_CNTL__CI__VI                      = 0x368A;
constexpr unsigned int mmSDMA1_GFX_IB_OFFSET__CI__VI                    = 0x368C;
constexpr unsigned int mmSDMA1_GFX_IB_RPTR__CI__VI                      = 0x368B;
constexpr unsigned int mmSDMA1_GFX_IB_SIZE__CI__VI                      = 0x368F;
constexpr unsigned int mmSDMA1_GFX_RB_BASE_HI__CI__VI                   = 0x3682;
constexpr unsigned int mmSDMA1_GFX_RB_BASE__CI__VI                      = 0x3681;
constexpr unsigned int mmSDMA1_GFX_RB_CNTL__CI__VI                      = 0x3680;
constexpr unsigned int mmSDMA1_GFX_RB_RPTR_ADDR_HI__CI__VI              = 0x3688;
constexpr unsigned int mmSDMA1_GFX_RB_RPTR_ADDR_LO__CI__VI              = 0x3689;
constexpr unsigned int mmSDMA1_GFX_RB_RPTR__CI__VI                      = 0x3683;
constexpr unsigned int mmSDMA1_GFX_RB_WPTR_POLL_ADDR_HI__CI__VI         = 0x3686;
constexpr unsigned int mmSDMA1_GFX_RB_WPTR_POLL_ADDR_LO__CI__VI         = 0x3687;
constexpr unsigned int mmSDMA1_GFX_RB_WPTR_POLL_CNTL__CI__VI            = 0x3685;
constexpr unsigned int mmSDMA1_GFX_RB_WPTR__CI__VI                      = 0x3684;
constexpr unsigned int mmSDMA1_GFX_SKIP_CNTL__CI__VI                    = 0x3690;
constexpr unsigned int mmSDMA1_GFX_VIRTUAL_ADDR__CI__VI                 = 0x36A7;
constexpr unsigned int mmSDMA1_HASH__CI__VI                             = 0x3607;
constexpr unsigned int mmSDMA1_IB_OFFSET_FETCH__CI__VI                  = 0x360B;
constexpr unsigned int mmSDMA1_PERFCOUNTER0_RESULT__CI                  = 0x3610;
constexpr unsigned int mmSDMA1_PERFCOUNTER1_RESULT__CI                  = 0x3611;
constexpr unsigned int mmSDMA1_PERFMON_CNTL__CI                         = 0x360F;
constexpr unsigned int mmSDMA1_PHASE0_QUANTUM__CI__VI                   = 0x3614;
constexpr unsigned int mmSDMA1_PHASE1_QUANTUM__CI__VI                   = 0x3615;
constexpr unsigned int mmSDMA1_POWER_CNTL__CI__VI                       = 0x3602;
constexpr unsigned int mmSDMA1_PROGRAM__CI__VI                          = 0x360C;
constexpr unsigned int mmSDMA1_RB_RPTR_FETCH__CI__VI                    = 0x360A;
constexpr unsigned int mmSDMA1_RLC0_APE1_CNTL__CI__VI                   = 0x3728;
constexpr unsigned int mmSDMA1_RLC0_CONTEXT_STATUS__CI__VI              = 0x3711;
constexpr unsigned int mmSDMA1_RLC0_DOORBELL_LOG__CI__VI                = 0x3729;
constexpr unsigned int mmSDMA1_RLC0_DOORBELL__CI__VI                    = 0x3712;
constexpr unsigned int mmSDMA1_RLC0_IB_BASE_HI__CI__VI                  = 0x370E;
constexpr unsigned int mmSDMA1_RLC0_IB_BASE_LO__CI__VI                  = 0x370D;
constexpr unsigned int mmSDMA1_RLC0_IB_CNTL__CI__VI                     = 0x370A;
constexpr unsigned int mmSDMA1_RLC0_IB_OFFSET__CI__VI                   = 0x370C;
constexpr unsigned int mmSDMA1_RLC0_IB_RPTR__CI__VI                     = 0x370B;
constexpr unsigned int mmSDMA1_RLC0_IB_SIZE__CI__VI                     = 0x370F;
constexpr unsigned int mmSDMA1_RLC0_RB_BASE_HI__CI__VI                  = 0x3702;
constexpr unsigned int mmSDMA1_RLC0_RB_BASE__CI__VI                     = 0x3701;
constexpr unsigned int mmSDMA1_RLC0_RB_CNTL__CI__VI                     = 0x3700;
constexpr unsigned int mmSDMA1_RLC0_RB_RPTR_ADDR_HI__CI__VI             = 0x3708;
constexpr unsigned int mmSDMA1_RLC0_RB_RPTR_ADDR_LO__CI__VI             = 0x3709;
constexpr unsigned int mmSDMA1_RLC0_RB_RPTR__CI__VI                     = 0x3703;
constexpr unsigned int mmSDMA1_RLC0_RB_WPTR_POLL_ADDR_HI__CI__VI        = 0x3706;
constexpr unsigned int mmSDMA1_RLC0_RB_WPTR_POLL_ADDR_LO__CI__VI        = 0x3707;
constexpr unsigned int mmSDMA1_RLC0_RB_WPTR_POLL_CNTL__CI__VI           = 0x3705;
constexpr unsigned int mmSDMA1_RLC0_RB_WPTR__CI__VI                     = 0x3704;
constexpr unsigned int mmSDMA1_RLC0_SKIP_CNTL__CI__VI                   = 0x3710;
constexpr unsigned int mmSDMA1_RLC0_VIRTUAL_ADDR__CI__VI                = 0x3727;
constexpr unsigned int mmSDMA1_RLC1_APE1_CNTL__CI__VI                   = 0x37A8;
constexpr unsigned int mmSDMA1_RLC1_CONTEXT_STATUS__CI__VI              = 0x3791;
constexpr unsigned int mmSDMA1_RLC1_DOORBELL_LOG__CI__VI                = 0x37A9;
constexpr unsigned int mmSDMA1_RLC1_DOORBELL__CI__VI                    = 0x3792;
constexpr unsigned int mmSDMA1_RLC1_IB_BASE_HI__CI__VI                  = 0x378E;
constexpr unsigned int mmSDMA1_RLC1_IB_BASE_LO__CI__VI                  = 0x378D;
constexpr unsigned int mmSDMA1_RLC1_IB_CNTL__CI__VI                     = 0x378A;
constexpr unsigned int mmSDMA1_RLC1_IB_OFFSET__CI__VI                   = 0x378C;
constexpr unsigned int mmSDMA1_RLC1_IB_RPTR__CI__VI                     = 0x378B;
constexpr unsigned int mmSDMA1_RLC1_IB_SIZE__CI__VI                     = 0x378F;
constexpr unsigned int mmSDMA1_RLC1_RB_BASE_HI__CI__VI                  = 0x3782;
constexpr unsigned int mmSDMA1_RLC1_RB_BASE__CI__VI                     = 0x3781;
constexpr unsigned int mmSDMA1_RLC1_RB_CNTL__CI__VI                     = 0x3780;
constexpr unsigned int mmSDMA1_RLC1_RB_RPTR_ADDR_HI__CI__VI             = 0x3788;
constexpr unsigned int mmSDMA1_RLC1_RB_RPTR_ADDR_LO__CI__VI             = 0x3789;
constexpr unsigned int mmSDMA1_RLC1_RB_RPTR__CI__VI                     = 0x3783;
constexpr unsigned int mmSDMA1_RLC1_RB_WPTR_POLL_ADDR_HI__CI__VI        = 0x3786;
constexpr unsigned int mmSDMA1_RLC1_RB_WPTR_POLL_ADDR_LO__CI__VI        = 0x3787;
constexpr unsigned int mmSDMA1_RLC1_RB_WPTR_POLL_CNTL__CI__VI           = 0x3785;
constexpr unsigned int mmSDMA1_RLC1_RB_WPTR__CI__VI                     = 0x3784;
constexpr unsigned int mmSDMA1_RLC1_SKIP_CNTL__CI__VI                   = 0x3790;
constexpr unsigned int mmSDMA1_RLC1_VIRTUAL_ADDR__CI__VI                = 0x37A7;
constexpr unsigned int mmSDMA1_SEM_INCOMPLETE_TIMER_CNTL__CI            = 0x3608;
constexpr unsigned int mmSDMA1_SEM_WAIT_FAIL_TIMER_CNTL__CI__VI         = 0x3609;
constexpr unsigned int mmSDMA1_STATUS1_REG__CI__VI                      = 0x360E;
constexpr unsigned int mmSDMA1_STATUS_REG__CI__VI                       = 0x360D;
constexpr unsigned int mmSDMA1_TILING_CONFIG__CI__VI                    = 0x3606;
constexpr unsigned int mmSDMA1_UCODE_ADDR__CI__VI                       = 0x3600;
constexpr unsigned int mmSDMA1_UCODE_DATA__CI__VI                       = 0x3601;
constexpr unsigned int mmSDMA_CONFIG__CI__VI                            = 0x0F91;
constexpr unsigned int mmSDMA_PGFSM_CONFIG__CI__VI                      = 0x3417;
constexpr unsigned int mmSDMA_PGFSM_READ__CI__VI                        = 0x3419;
constexpr unsigned int mmSDMA_PGFSM_WRITE__CI__VI                       = 0x3418;
constexpr unsigned int mmSDMA_POWER_GATING__CI__VI                      = 0x3416;
constexpr unsigned int mmSEM_CHICKEN_BITS__CI__VI                       = 0x0F9E;
constexpr unsigned int mmSEM_EDC_CONFIG__CI__VI                         = 0x0F9A;
constexpr unsigned int mmSEM_MAILBOX_CLIENTCONFIG__CI__VI               = 0x0F9B;
constexpr unsigned int mmSEM_MAILBOX_CLIENTCONFIG__SI                   = 0x0F9A;
constexpr unsigned int mmSEM_MAILBOX_CONTROL__CI__VI                    = 0x0F9D;
constexpr unsigned int mmSEM_MAILBOX_CONTROL__SI                        = 0x0F9C;
constexpr unsigned int mmSEM_MAILBOX__CI__VI                            = 0x0F9C;
constexpr unsigned int mmSEM_MAILBOX__SI                                = 0x0F9B;
constexpr unsigned int mmSEM_MCIF_CONFIG                                = 0x0F90;
constexpr unsigned int mmSEM_STATUS__CI__VI                             = 0x0F99;
constexpr unsigned int mmSEQ8_DATA__SI__VI                              = 0x00F1;
constexpr unsigned int mmSEQ8_IDX__SI__VI                               = 0x00F1;
constexpr unsigned int mmSH_HIDDEN_PRIVATE_BASE_VMID__CI__VI            = 0x2580;
constexpr unsigned int mmSH_MEM_APE1_BASE__CI__VI                       = 0x230B;
constexpr unsigned int mmSH_MEM_APE1_LIMIT__CI__VI                      = 0x230C;
constexpr unsigned int mmSH_MEM_BASES__CI__VI                           = 0x230A;
constexpr unsigned int mmSH_MEM_CONFIG__CI__VI                          = 0x230D;
constexpr unsigned int mmSH_STATIC_MEM_CONFIG__CI__VI                   = 0x2581;
constexpr unsigned int mmSLAVE_COMM_CMD_REG__SI__VI                     = 0x1624;
constexpr unsigned int mmSLAVE_COMM_CNTL_REG__SI__VI                    = 0x1625;
constexpr unsigned int mmSLAVE_COMM_DATA_REG1__SI__VI                   = 0x1621;
constexpr unsigned int mmSLAVE_COMM_DATA_REG2__SI__VI                   = 0x1622;
constexpr unsigned int mmSLAVE_COMM_DATA_REG3__SI__VI                   = 0x1623;
constexpr unsigned int mmSLAVE_HANG_ERROR                               = 0x153B;
constexpr unsigned int mmSLAVE_HANG_PROTECTION_CNTL                     = 0x1536;
constexpr unsigned int mmSLAVE_REQ_CREDIT_CNTL                          = 0x1517;
constexpr unsigned int mmSMBCLK_PAD_CNTL__CI                            = 0x1523;
constexpr unsigned int mmSMBDAT_PAD_CNTL__CI                            = 0x1522;
constexpr unsigned int mmSMBUS_SLV_CNTL__CI                             = 0x14FD;
constexpr unsigned int mmSMC_IND_ACCESS_CNTL__CI__VI                    = 0x0090;
constexpr unsigned int mmSMC_IND_ACCESS_CNTL__SI                        = 0x008A;
constexpr unsigned int mmSMC_IND_DATA                                   = 0x0081;
constexpr unsigned int mmSMC_IND_DATA_0__CI__VI                         = 0x0081;
constexpr unsigned int mmSMC_IND_DATA_1__CI__VI                         = 0x0083;
constexpr unsigned int mmSMC_IND_DATA_2__CI__VI                         = 0x0085;
constexpr unsigned int mmSMC_IND_DATA_3__CI__VI                         = 0x0087;
constexpr unsigned int mmSMC_IND_DATA_4__CI__VI                         = 0x0089;
constexpr unsigned int mmSMC_IND_DATA_5__CI__VI                         = 0x008B;
constexpr unsigned int mmSMC_IND_DATA_6__CI__VI                         = 0x008D;
constexpr unsigned int mmSMC_IND_DATA_7__CI__VI                         = 0x008F;
constexpr unsigned int mmSMC_IND_INDEX                                  = 0x0080;
constexpr unsigned int mmSMC_IND_INDEX_0__CI__VI                        = 0x0080;
constexpr unsigned int mmSMC_IND_INDEX_1__CI__VI                        = 0x0082;
constexpr unsigned int mmSMC_IND_INDEX_2__CI__VI                        = 0x0084;
constexpr unsigned int mmSMC_IND_INDEX_3__CI__VI                        = 0x0086;
constexpr unsigned int mmSMC_IND_INDEX_4__CI__VI                        = 0x0088;
constexpr unsigned int mmSMC_IND_INDEX_5__CI__VI                        = 0x008A;
constexpr unsigned int mmSMC_IND_INDEX_6__CI__VI                        = 0x008C;
constexpr unsigned int mmSMC_IND_INDEX_7__CI__VI                        = 0x008E;
constexpr unsigned int mmSMC_MESSAGE_0__CI__VI                          = 0x0094;
constexpr unsigned int mmSMC_MESSAGE_0__SI                              = 0x008B;
constexpr unsigned int mmSMC_MESSAGE_10__CI__VI                         = 0x00B9;
constexpr unsigned int mmSMC_MESSAGE_11__CI__VI                         = 0x00BB;
constexpr unsigned int mmSMC_MESSAGE_1__CI__VI                          = 0x0096;
constexpr unsigned int mmSMC_MESSAGE_1__SI                              = 0x008D;
constexpr unsigned int mmSMC_MESSAGE_2__CI__VI                          = 0x0098;
constexpr unsigned int mmSMC_MESSAGE_3__CI__VI                          = 0x009A;
constexpr unsigned int mmSMC_MESSAGE_4__CI__VI                          = 0x009C;
constexpr unsigned int mmSMC_MESSAGE_5__CI__VI                          = 0x009E;
constexpr unsigned int mmSMC_MESSAGE_6__CI__VI                          = 0x00A0;
constexpr unsigned int mmSMC_MESSAGE_7__CI__VI                          = 0x00A2;
constexpr unsigned int mmSMC_MESSAGE_8__CI__VI                          = 0x00B5;
constexpr unsigned int mmSMC_MESSAGE_9__CI__VI                          = 0x00B7;
constexpr unsigned int mmSMC_MSG_ARG_0__CI__VI                          = 0x00A4;
constexpr unsigned int mmSMC_MSG_ARG_10__CI__VI                         = 0x00BF;
constexpr unsigned int mmSMC_MSG_ARG_11__CI                             = 0x0091;
constexpr unsigned int mmSMC_MSG_ARG_1__CI__VI                          = 0x00A5;
constexpr unsigned int mmSMC_MSG_ARG_2__CI__VI                          = 0x00A6;
constexpr unsigned int mmSMC_MSG_ARG_3__CI__VI                          = 0x00A7;
constexpr unsigned int mmSMC_MSG_ARG_4__CI__VI                          = 0x00A8;
constexpr unsigned int mmSMC_MSG_ARG_5__CI__VI                          = 0x00A9;
constexpr unsigned int mmSMC_MSG_ARG_6__CI__VI                          = 0x00AA;
constexpr unsigned int mmSMC_MSG_ARG_7__CI__VI                          = 0x00AB;
constexpr unsigned int mmSMC_MSG_ARG_8__CI__VI                          = 0x00BD;
constexpr unsigned int mmSMC_MSG_ARG_9__CI__VI                          = 0x00BE;
constexpr unsigned int mmSMC_RESP_0__CI__VI                             = 0x0095;
constexpr unsigned int mmSMC_RESP_0__SI                                 = 0x008C;
constexpr unsigned int mmSMC_RESP_10__CI__VI                            = 0x00BA;
constexpr unsigned int mmSMC_RESP_11__CI__VI                            = 0x00BC;
constexpr unsigned int mmSMC_RESP_1__CI__VI                             = 0x0097;
constexpr unsigned int mmSMC_RESP_1__SI                                 = 0x008E;
constexpr unsigned int mmSMC_RESP_2__CI__VI                             = 0x0099;
constexpr unsigned int mmSMC_RESP_3__CI__VI                             = 0x009B;
constexpr unsigned int mmSMC_RESP_4__CI__VI                             = 0x009D;
constexpr unsigned int mmSMC_RESP_5__CI__VI                             = 0x009F;
constexpr unsigned int mmSMC_RESP_6__CI__VI                             = 0x00A1;
constexpr unsigned int mmSMC_RESP_7__CI__VI                             = 0x00A3;
constexpr unsigned int mmSMC_RESP_8__CI__VI                             = 0x00B6;
constexpr unsigned int mmSMC_RESP_9__CI__VI                             = 0x00B8;
constexpr unsigned int mmSMC_SCRATCH9__SI                               = 0x022A;
constexpr unsigned int mmSMU_SMC_IND_DATA__CI__VI                       = 0x0081;
constexpr unsigned int mmSMU_SMC_IND_INDEX__CI__VI                      = 0x0080;
constexpr unsigned int mmSPI_ARB_CYCLES_0__CI__VI                       = 0x31C1;
constexpr unsigned int mmSPI_ARB_CYCLES_0__SI                           = 0x243D;
constexpr unsigned int mmSPI_ARB_CYCLES_1__CI__VI                       = 0x31C2;
constexpr unsigned int mmSPI_ARB_CYCLES_1__SI                           = 0x243E;
constexpr unsigned int mmSPI_ARB_PRIORITY__CI__VI                       = 0x31C0;
constexpr unsigned int mmSPI_ARB_PRIORITY__SI                           = 0x243C;
constexpr unsigned int mmSPI_BARYC_CNTL                                 = 0xA1B8;
constexpr unsigned int mmSPI_CDBG_SYS_CS0__CI__VI                       = 0x31C5;
constexpr unsigned int mmSPI_CDBG_SYS_CS1__CI__VI                       = 0x31C6;
constexpr unsigned int mmSPI_CDBG_SYS_GFX__CI__VI                       = 0x31C3;
constexpr unsigned int mmSPI_CDBG_SYS_HP3D__CI__VI                      = 0x31C4;
constexpr unsigned int mmSPI_COMPUTE_QUEUE_RESET__CI__VI                = 0x31DB;
constexpr unsigned int mmSPI_CONFIG_CNTL                                = 0x2440;
constexpr unsigned int mmSPI_CONFIG_CNTL_1                              = 0x244F;
constexpr unsigned int mmSPI_CSQ_WF_ACTIVE_COUNT_0__CI__VI              = 0x24DC;
constexpr unsigned int mmSPI_CSQ_WF_ACTIVE_COUNT_1__CI__VI              = 0x24DD;
constexpr unsigned int mmSPI_CSQ_WF_ACTIVE_COUNT_2__CI__VI              = 0x24DE;
constexpr unsigned int mmSPI_CSQ_WF_ACTIVE_COUNT_3__CI__VI              = 0x24DF;
constexpr unsigned int mmSPI_CSQ_WF_ACTIVE_COUNT_4__CI__VI              = 0x24E0;
constexpr unsigned int mmSPI_CSQ_WF_ACTIVE_COUNT_5__CI__VI              = 0x24E1;
constexpr unsigned int mmSPI_CSQ_WF_ACTIVE_COUNT_6__CI__VI              = 0x24E2;
constexpr unsigned int mmSPI_CSQ_WF_ACTIVE_COUNT_7__CI__VI              = 0x24E3;
constexpr unsigned int mmSPI_CSQ_WF_ACTIVE_STATUS__CI__VI               = 0x24DB;
constexpr unsigned int mmSPI_DEBUG_BUSY                                 = 0x2450;
constexpr unsigned int mmSPI_DEBUG_CNTL                                 = 0x2441;
constexpr unsigned int mmSPI_DEBUG_READ                                 = 0x2442;
constexpr unsigned int mmSPI_GDBG_TBA_HI__CI__VI                        = 0x31D5;
constexpr unsigned int mmSPI_GDBG_TBA_LO__CI__VI                        = 0x31D4;
constexpr unsigned int mmSPI_GDBG_TMA_HI__CI__VI                        = 0x31D7;
constexpr unsigned int mmSPI_GDBG_TMA_LO__CI__VI                        = 0x31D6;
constexpr unsigned int mmSPI_GDBG_TRAP_CONFIG__CI__VI                   = 0x31D2;
constexpr unsigned int mmSPI_GDBG_TRAP_DATA0__CI__VI                    = 0x31D8;
constexpr unsigned int mmSPI_GDBG_TRAP_DATA1__CI__VI                    = 0x31D9;
constexpr unsigned int mmSPI_GDBG_TRAP_MASK__CI__VI                     = 0x31D3;
constexpr unsigned int mmSPI_GDBG_WAVE_CNTL__CI__VI                     = 0x31D1;
constexpr unsigned int mmSPI_GDS_CREDITS                                = 0x24D8;
constexpr unsigned int mmSPI_INTERP_CONTROL_0                           = 0xA1B5;
constexpr unsigned int mmSPI_LB_CTR_CTRL                                = 0x24D4;
constexpr unsigned int mmSPI_LB_CU_MASK                                 = 0x24D5;
constexpr unsigned int mmSPI_LB_DATA_REG                                = 0x24D6;
constexpr unsigned int mmSPI_P0_TRAP_SCREEN_GPR_MIN__CI__VI             = 0x24F0;
constexpr unsigned int mmSPI_P0_TRAP_SCREEN_PSBA_HI__CI__VI             = 0x24ED;
constexpr unsigned int mmSPI_P0_TRAP_SCREEN_PSBA_LO__CI__VI             = 0x24EC;
constexpr unsigned int mmSPI_P0_TRAP_SCREEN_PSMA_HI__CI__VI             = 0x24EF;
constexpr unsigned int mmSPI_P0_TRAP_SCREEN_PSMA_LO__CI__VI             = 0x24EE;
constexpr unsigned int mmSPI_P1_TRAP_SCREEN_GPR_MIN__CI__VI             = 0x24F5;
constexpr unsigned int mmSPI_P1_TRAP_SCREEN_PSBA_HI__CI__VI             = 0x24F2;
constexpr unsigned int mmSPI_P1_TRAP_SCREEN_PSBA_LO__CI__VI             = 0x24F1;
constexpr unsigned int mmSPI_P1_TRAP_SCREEN_PSMA_HI__CI__VI             = 0x24F4;
constexpr unsigned int mmSPI_P1_TRAP_SCREEN_PSMA_LO__CI__VI             = 0x24F3;
constexpr unsigned int mmSPI_PERFCOUNTER0_HI__CI__VI                    = 0xD180;
constexpr unsigned int mmSPI_PERFCOUNTER0_HI__SI                        = 0x2447;
constexpr unsigned int mmSPI_PERFCOUNTER0_LO__CI__VI                    = 0xD181;
constexpr unsigned int mmSPI_PERFCOUNTER0_LO__SI                        = 0x2448;
constexpr unsigned int mmSPI_PERFCOUNTER0_SELECT1__CI__VI               = 0xD984;
constexpr unsigned int mmSPI_PERFCOUNTER0_SELECT__CI__VI                = 0xD980;
constexpr unsigned int mmSPI_PERFCOUNTER0_SELECT__SI                    = 0x2443;
constexpr unsigned int mmSPI_PERFCOUNTER1_HI__CI__VI                    = 0xD182;
constexpr unsigned int mmSPI_PERFCOUNTER1_HI__SI                        = 0x2449;
constexpr unsigned int mmSPI_PERFCOUNTER1_LO__CI__VI                    = 0xD183;
constexpr unsigned int mmSPI_PERFCOUNTER1_LO__SI                        = 0x244A;
constexpr unsigned int mmSPI_PERFCOUNTER1_SELECT1__CI__VI               = 0xD985;
constexpr unsigned int mmSPI_PERFCOUNTER1_SELECT__CI__VI                = 0xD981;
constexpr unsigned int mmSPI_PERFCOUNTER1_SELECT__SI                    = 0x2444;
constexpr unsigned int mmSPI_PERFCOUNTER2_HI__CI__VI                    = 0xD184;
constexpr unsigned int mmSPI_PERFCOUNTER2_HI__SI                        = 0x244B;
constexpr unsigned int mmSPI_PERFCOUNTER2_LO__CI__VI                    = 0xD185;
constexpr unsigned int mmSPI_PERFCOUNTER2_LO__SI                        = 0x244C;
constexpr unsigned int mmSPI_PERFCOUNTER2_SELECT1__CI__VI               = 0xD986;
constexpr unsigned int mmSPI_PERFCOUNTER2_SELECT__CI__VI                = 0xD982;
constexpr unsigned int mmSPI_PERFCOUNTER2_SELECT__SI                    = 0x2445;
constexpr unsigned int mmSPI_PERFCOUNTER3_HI__CI__VI                    = 0xD186;
constexpr unsigned int mmSPI_PERFCOUNTER3_HI__SI                        = 0x244D;
constexpr unsigned int mmSPI_PERFCOUNTER3_LO__CI__VI                    = 0xD187;
constexpr unsigned int mmSPI_PERFCOUNTER3_LO__SI                        = 0x244E;
constexpr unsigned int mmSPI_PERFCOUNTER3_SELECT1__CI__VI               = 0xD987;
constexpr unsigned int mmSPI_PERFCOUNTER3_SELECT__CI__VI                = 0xD983;
constexpr unsigned int mmSPI_PERFCOUNTER3_SELECT__SI                    = 0x2446;
constexpr unsigned int mmSPI_PERFCOUNTER4_HI__CI__VI                    = 0xD188;
constexpr unsigned int mmSPI_PERFCOUNTER4_LO__CI__VI                    = 0xD189;
constexpr unsigned int mmSPI_PERFCOUNTER4_SELECT__CI__VI                = 0xD988;
constexpr unsigned int mmSPI_PERFCOUNTER5_HI__CI__VI                    = 0xD18A;
constexpr unsigned int mmSPI_PERFCOUNTER5_LO__CI__VI                    = 0xD18B;
constexpr unsigned int mmSPI_PERFCOUNTER5_SELECT__CI__VI                = 0xD989;
constexpr unsigned int mmSPI_PERFCOUNTER_BINS__CI__VI                   = 0xD98A;
constexpr unsigned int mmSPI_PERFCOUNTER_BINS__SI                       = 0x243F;
constexpr unsigned int mmSPI_PG_ENABLE_STATIC_CU_MASK                   = 0x24D7;
constexpr unsigned int mmSPI_PS_INPUT_ADDR                              = 0xA1B4;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_0                            = 0xA191;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_1                            = 0xA192;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_10                           = 0xA19B;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_11                           = 0xA19C;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_12                           = 0xA19D;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_13                           = 0xA19E;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_14                           = 0xA19F;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_15                           = 0xA1A0;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_16                           = 0xA1A1;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_17                           = 0xA1A2;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_18                           = 0xA1A3;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_19                           = 0xA1A4;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_2                            = 0xA193;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_20                           = 0xA1A5;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_21                           = 0xA1A6;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_22                           = 0xA1A7;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_23                           = 0xA1A8;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_24                           = 0xA1A9;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_25                           = 0xA1AA;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_26                           = 0xA1AB;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_27                           = 0xA1AC;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_28                           = 0xA1AD;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_29                           = 0xA1AE;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_3                            = 0xA194;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_30                           = 0xA1AF;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_31                           = 0xA1B0;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_4                            = 0xA195;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_5                            = 0xA196;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_6                            = 0xA197;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_7                            = 0xA198;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_8                            = 0xA199;
constexpr unsigned int mmSPI_PS_INPUT_CNTL_9                            = 0xA19A;
constexpr unsigned int mmSPI_PS_INPUT_ENA                               = 0xA1B3;
constexpr unsigned int mmSPI_PS_IN_CONTROL                              = 0xA1B6;
constexpr unsigned int mmSPI_PS_MAX_WAVE_ID__CI__VI                     = 0x243A;
constexpr unsigned int mmSPI_PS_MAX_WAVE_ID__SI                         = 0x243B;
constexpr unsigned int mmSPI_RESET_DEBUG__CI__VI                        = 0x31DA;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_CU_0__CI__VI              = 0x31DC;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_CU_10__CI__VI             = 0x31F0;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_CU_11__CI__VI             = 0x31F1;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_CU_1__CI__VI              = 0x31DD;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_CU_2__CI__VI              = 0x31DE;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_CU_3__CI__VI              = 0x31DF;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_CU_4__CI__VI              = 0x31E0;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_CU_5__CI__VI              = 0x31E1;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_CU_6__CI__VI              = 0x31E2;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_CU_7__CI__VI              = 0x31E3;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_CU_8__CI__VI              = 0x31E4;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_CU_9__CI__VI              = 0x31E5;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_EN_CU_0__CI__VI           = 0x31E6;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_EN_CU_10__CI__VI          = 0x31F2;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_EN_CU_11__CI__VI          = 0x31F3;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_EN_CU_1__CI__VI           = 0x31E7;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_EN_CU_2__CI__VI           = 0x31E8;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_EN_CU_3__CI__VI           = 0x31E9;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_EN_CU_4__CI__VI           = 0x31EA;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_EN_CU_5__CI__VI           = 0x31EB;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_EN_CU_6__CI__VI           = 0x31EC;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_EN_CU_7__CI__VI           = 0x31ED;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_EN_CU_8__CI__VI           = 0x31EE;
constexpr unsigned int mmSPI_RESOURCE_RESERVE_EN_CU_9__CI__VI           = 0x31EF;
constexpr unsigned int mmSPI_SHADER_COL_FORMAT                          = 0xA1C5;
constexpr unsigned int mmSPI_SHADER_LATE_ALLOC_VS__CI__VI               = 0x2C47;
constexpr unsigned int mmSPI_SHADER_PGM_HI_ES                           = 0x2CC9;
constexpr unsigned int mmSPI_SHADER_PGM_HI_GS                           = 0x2C89;
constexpr unsigned int mmSPI_SHADER_PGM_HI_HS                           = 0x2D09;
constexpr unsigned int mmSPI_SHADER_PGM_HI_LS                           = 0x2D49;
constexpr unsigned int mmSPI_SHADER_PGM_HI_PS                           = 0x2C09;
constexpr unsigned int mmSPI_SHADER_PGM_HI_VS                           = 0x2C49;
constexpr unsigned int mmSPI_SHADER_PGM_LO_ES                           = 0x2CC8;
constexpr unsigned int mmSPI_SHADER_PGM_LO_GS                           = 0x2C88;
constexpr unsigned int mmSPI_SHADER_PGM_LO_HS                           = 0x2D08;
constexpr unsigned int mmSPI_SHADER_PGM_LO_LS                           = 0x2D48;
constexpr unsigned int mmSPI_SHADER_PGM_LO_PS                           = 0x2C08;
constexpr unsigned int mmSPI_SHADER_PGM_LO_VS                           = 0x2C48;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC1_ES                        = 0x2CCA;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC1_GS                        = 0x2C8A;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC1_HS                        = 0x2D0A;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC1_LS                        = 0x2D4A;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC1_PS                        = 0x2C0A;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC1_VS                        = 0x2C4A;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC2_ES                        = 0x2CCB;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC2_ES_GS__CI__VI             = 0x2CBC;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC2_ES_VS__CI__VI             = 0x2C7C;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC2_GS                        = 0x2C8B;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC2_HS                        = 0x2D0B;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC2_LS                        = 0x2D4B;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC2_LS_ES__CI__VI             = 0x2CFD;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC2_LS_HS__CI__VI             = 0x2D3D;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC2_LS_VS__CI__VI             = 0x2C7D;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC2_PS                        = 0x2C0B;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC2_VS                        = 0x2C4B;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC3_ES__CI__VI                = 0x2CC7;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC3_GS__CI__VI                = 0x2C87;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC3_HS__CI__VI                = 0x2D07;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC3_LS__CI__VI                = 0x2D47;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC3_PS__CI__VI                = 0x2C07;
constexpr unsigned int mmSPI_SHADER_PGM_RSRC3_VS__CI__VI                = 0x2C46;
constexpr unsigned int mmSPI_SHADER_POS_FORMAT                          = 0xA1C3;
constexpr unsigned int mmSPI_SHADER_TBA_HI_ES                           = 0x2CC1;
constexpr unsigned int mmSPI_SHADER_TBA_HI_GS                           = 0x2C81;
constexpr unsigned int mmSPI_SHADER_TBA_HI_HS                           = 0x2D01;
constexpr unsigned int mmSPI_SHADER_TBA_HI_LS                           = 0x2D41;
constexpr unsigned int mmSPI_SHADER_TBA_HI_PS                           = 0x2C01;
constexpr unsigned int mmSPI_SHADER_TBA_HI_VS                           = 0x2C41;
constexpr unsigned int mmSPI_SHADER_TBA_LO_ES                           = 0x2CC0;
constexpr unsigned int mmSPI_SHADER_TBA_LO_GS                           = 0x2C80;
constexpr unsigned int mmSPI_SHADER_TBA_LO_HS                           = 0x2D00;
constexpr unsigned int mmSPI_SHADER_TBA_LO_LS                           = 0x2D40;
constexpr unsigned int mmSPI_SHADER_TBA_LO_PS                           = 0x2C00;
constexpr unsigned int mmSPI_SHADER_TBA_LO_VS                           = 0x2C40;
constexpr unsigned int mmSPI_SHADER_TMA_HI_ES                           = 0x2CC3;
constexpr unsigned int mmSPI_SHADER_TMA_HI_GS                           = 0x2C83;
constexpr unsigned int mmSPI_SHADER_TMA_HI_HS                           = 0x2D03;
constexpr unsigned int mmSPI_SHADER_TMA_HI_LS                           = 0x2D43;
constexpr unsigned int mmSPI_SHADER_TMA_HI_PS                           = 0x2C03;
constexpr unsigned int mmSPI_SHADER_TMA_HI_VS                           = 0x2C43;
constexpr unsigned int mmSPI_SHADER_TMA_LO_ES                           = 0x2CC2;
constexpr unsigned int mmSPI_SHADER_TMA_LO_GS                           = 0x2C82;
constexpr unsigned int mmSPI_SHADER_TMA_LO_HS                           = 0x2D02;
constexpr unsigned int mmSPI_SHADER_TMA_LO_LS                           = 0x2D42;
constexpr unsigned int mmSPI_SHADER_TMA_LO_PS                           = 0x2C02;
constexpr unsigned int mmSPI_SHADER_TMA_LO_VS                           = 0x2C42;
constexpr unsigned int mmSPI_SHADER_USER_DATA_ES_0                      = 0x2CCC;
constexpr unsigned int mmSPI_SHADER_USER_DATA_ES_1                      = 0x2CCD;
constexpr unsigned int mmSPI_SHADER_USER_DATA_ES_10                     = 0x2CD6;
constexpr unsigned int mmSPI_SHADER_USER_DATA_ES_11                     = 0x2CD7;
constexpr unsigned int mmSPI_SHADER_USER_DATA_ES_12                     = 0x2CD8;
constexpr unsigned int mmSPI_SHADER_USER_DATA_ES_13                     = 0x2CD9;
constexpr unsigned int mmSPI_SHADER_USER_DATA_ES_14                     = 0x2CDA;
constexpr unsigned int mmSPI_SHADER_USER_DATA_ES_15                     = 0x2CDB;
constexpr unsigned int mmSPI_SHADER_USER_DATA_ES_2                      = 0x2CCE;
constexpr unsigned int mmSPI_SHADER_USER_DATA_ES_3                      = 0x2CCF;
constexpr unsigned int mmSPI_SHADER_USER_DATA_ES_4                      = 0x2CD0;
constexpr unsigned int mmSPI_SHADER_USER_DATA_ES_5                      = 0x2CD1;
constexpr unsigned int mmSPI_SHADER_USER_DATA_ES_6                      = 0x2CD2;
constexpr unsigned int mmSPI_SHADER_USER_DATA_ES_7                      = 0x2CD3;
constexpr unsigned int mmSPI_SHADER_USER_DATA_ES_8                      = 0x2CD4;
constexpr unsigned int mmSPI_SHADER_USER_DATA_ES_9                      = 0x2CD5;
constexpr unsigned int mmSPI_SHADER_USER_DATA_GS_0                      = 0x2C8C;
constexpr unsigned int mmSPI_SHADER_USER_DATA_GS_1                      = 0x2C8D;
constexpr unsigned int mmSPI_SHADER_USER_DATA_GS_10                     = 0x2C96;
constexpr unsigned int mmSPI_SHADER_USER_DATA_GS_11                     = 0x2C97;
constexpr unsigned int mmSPI_SHADER_USER_DATA_GS_12                     = 0x2C98;
constexpr unsigned int mmSPI_SHADER_USER_DATA_GS_13                     = 0x2C99;
constexpr unsigned int mmSPI_SHADER_USER_DATA_GS_14                     = 0x2C9A;
constexpr unsigned int mmSPI_SHADER_USER_DATA_GS_15                     = 0x2C9B;
constexpr unsigned int mmSPI_SHADER_USER_DATA_GS_2                      = 0x2C8E;
constexpr unsigned int mmSPI_SHADER_USER_DATA_GS_3                      = 0x2C8F;
constexpr unsigned int mmSPI_SHADER_USER_DATA_GS_4                      = 0x2C90;
constexpr unsigned int mmSPI_SHADER_USER_DATA_GS_5                      = 0x2C91;
constexpr unsigned int mmSPI_SHADER_USER_DATA_GS_6                      = 0x2C92;
constexpr unsigned int mmSPI_SHADER_USER_DATA_GS_7                      = 0x2C93;
constexpr unsigned int mmSPI_SHADER_USER_DATA_GS_8                      = 0x2C94;
constexpr unsigned int mmSPI_SHADER_USER_DATA_GS_9                      = 0x2C95;
constexpr unsigned int mmSPI_SHADER_USER_DATA_HS_0                      = 0x2D0C;
constexpr unsigned int mmSPI_SHADER_USER_DATA_HS_1                      = 0x2D0D;
constexpr unsigned int mmSPI_SHADER_USER_DATA_HS_10                     = 0x2D16;
constexpr unsigned int mmSPI_SHADER_USER_DATA_HS_11                     = 0x2D17;
constexpr unsigned int mmSPI_SHADER_USER_DATA_HS_12                     = 0x2D18;
constexpr unsigned int mmSPI_SHADER_USER_DATA_HS_13                     = 0x2D19;
constexpr unsigned int mmSPI_SHADER_USER_DATA_HS_14                     = 0x2D1A;
constexpr unsigned int mmSPI_SHADER_USER_DATA_HS_15                     = 0x2D1B;
constexpr unsigned int mmSPI_SHADER_USER_DATA_HS_2                      = 0x2D0E;
constexpr unsigned int mmSPI_SHADER_USER_DATA_HS_3                      = 0x2D0F;
constexpr unsigned int mmSPI_SHADER_USER_DATA_HS_4                      = 0x2D10;
constexpr unsigned int mmSPI_SHADER_USER_DATA_HS_5                      = 0x2D11;
constexpr unsigned int mmSPI_SHADER_USER_DATA_HS_6                      = 0x2D12;
constexpr unsigned int mmSPI_SHADER_USER_DATA_HS_7                      = 0x2D13;
constexpr unsigned int mmSPI_SHADER_USER_DATA_HS_8                      = 0x2D14;
constexpr unsigned int mmSPI_SHADER_USER_DATA_HS_9                      = 0x2D15;
constexpr unsigned int mmSPI_SHADER_USER_DATA_LS_0                      = 0x2D4C;
constexpr unsigned int mmSPI_SHADER_USER_DATA_LS_1                      = 0x2D4D;
constexpr unsigned int mmSPI_SHADER_USER_DATA_LS_10                     = 0x2D56;
constexpr unsigned int mmSPI_SHADER_USER_DATA_LS_11                     = 0x2D57;
constexpr unsigned int mmSPI_SHADER_USER_DATA_LS_12                     = 0x2D58;
constexpr unsigned int mmSPI_SHADER_USER_DATA_LS_13                     = 0x2D59;
constexpr unsigned int mmSPI_SHADER_USER_DATA_LS_14                     = 0x2D5A;
constexpr unsigned int mmSPI_SHADER_USER_DATA_LS_15                     = 0x2D5B;
constexpr unsigned int mmSPI_SHADER_USER_DATA_LS_2                      = 0x2D4E;
constexpr unsigned int mmSPI_SHADER_USER_DATA_LS_3                      = 0x2D4F;
constexpr unsigned int mmSPI_SHADER_USER_DATA_LS_4                      = 0x2D50;
constexpr unsigned int mmSPI_SHADER_USER_DATA_LS_5                      = 0x2D51;
constexpr unsigned int mmSPI_SHADER_USER_DATA_LS_6                      = 0x2D52;
constexpr unsigned int mmSPI_SHADER_USER_DATA_LS_7                      = 0x2D53;
constexpr unsigned int mmSPI_SHADER_USER_DATA_LS_8                      = 0x2D54;
constexpr unsigned int mmSPI_SHADER_USER_DATA_LS_9                      = 0x2D55;
constexpr unsigned int mmSPI_SHADER_USER_DATA_PS_0                      = 0x2C0C;
constexpr unsigned int mmSPI_SHADER_USER_DATA_PS_1                      = 0x2C0D;
constexpr unsigned int mmSPI_SHADER_USER_DATA_PS_10                     = 0x2C16;
constexpr unsigned int mmSPI_SHADER_USER_DATA_PS_11                     = 0x2C17;
constexpr unsigned int mmSPI_SHADER_USER_DATA_PS_12                     = 0x2C18;
constexpr unsigned int mmSPI_SHADER_USER_DATA_PS_13                     = 0x2C19;
constexpr unsigned int mmSPI_SHADER_USER_DATA_PS_14                     = 0x2C1A;
constexpr unsigned int mmSPI_SHADER_USER_DATA_PS_15                     = 0x2C1B;
constexpr unsigned int mmSPI_SHADER_USER_DATA_PS_2                      = 0x2C0E;
constexpr unsigned int mmSPI_SHADER_USER_DATA_PS_3                      = 0x2C0F;
constexpr unsigned int mmSPI_SHADER_USER_DATA_PS_4                      = 0x2C10;
constexpr unsigned int mmSPI_SHADER_USER_DATA_PS_5                      = 0x2C11;
constexpr unsigned int mmSPI_SHADER_USER_DATA_PS_6                      = 0x2C12;
constexpr unsigned int mmSPI_SHADER_USER_DATA_PS_7                      = 0x2C13;
constexpr unsigned int mmSPI_SHADER_USER_DATA_PS_8                      = 0x2C14;
constexpr unsigned int mmSPI_SHADER_USER_DATA_PS_9                      = 0x2C15;
constexpr unsigned int mmSPI_SHADER_USER_DATA_VS_0                      = 0x2C4C;
constexpr unsigned int mmSPI_SHADER_USER_DATA_VS_1                      = 0x2C4D;
constexpr unsigned int mmSPI_SHADER_USER_DATA_VS_10                     = 0x2C56;
constexpr unsigned int mmSPI_SHADER_USER_DATA_VS_11                     = 0x2C57;
constexpr unsigned int mmSPI_SHADER_USER_DATA_VS_12                     = 0x2C58;
constexpr unsigned int mmSPI_SHADER_USER_DATA_VS_13                     = 0x2C59;
constexpr unsigned int mmSPI_SHADER_USER_DATA_VS_14                     = 0x2C5A;
constexpr unsigned int mmSPI_SHADER_USER_DATA_VS_15                     = 0x2C5B;
constexpr unsigned int mmSPI_SHADER_USER_DATA_VS_2                      = 0x2C4E;
constexpr unsigned int mmSPI_SHADER_USER_DATA_VS_3                      = 0x2C4F;
constexpr unsigned int mmSPI_SHADER_USER_DATA_VS_4                      = 0x2C50;
constexpr unsigned int mmSPI_SHADER_USER_DATA_VS_5                      = 0x2C51;
constexpr unsigned int mmSPI_SHADER_USER_DATA_VS_6                      = 0x2C52;
constexpr unsigned int mmSPI_SHADER_USER_DATA_VS_7                      = 0x2C53;
constexpr unsigned int mmSPI_SHADER_USER_DATA_VS_8                      = 0x2C54;
constexpr unsigned int mmSPI_SHADER_USER_DATA_VS_9                      = 0x2C55;
constexpr unsigned int mmSPI_SHADER_Z_FORMAT                            = 0xA1C4;
constexpr unsigned int mmSPI_SLAVE_DEBUG_BUSY                           = 0x24D3;
constexpr unsigned int mmSPI_STATIC_THREAD_MGMT_3__SI                   = 0x243A;
constexpr unsigned int mmSPI_SX_EXPORT_BUFFER_SIZES                     = 0x24D9;
constexpr unsigned int mmSPI_SX_SCOREBOARD_BUFFER_SIZES                 = 0x24DA;
constexpr unsigned int mmSPI_TMPRING_SIZE                               = 0xA1BA;
constexpr unsigned int mmSPI_VS_OUT_CONFIG                              = 0xA1B1;
constexpr unsigned int mmSPI_WCL_PIPE_PERCENT_CS0__CI__VI               = 0x31C9;
constexpr unsigned int mmSPI_WCL_PIPE_PERCENT_CS1__CI__VI               = 0x31CA;
constexpr unsigned int mmSPI_WCL_PIPE_PERCENT_CS2__CI__VI               = 0x31CB;
constexpr unsigned int mmSPI_WCL_PIPE_PERCENT_CS3__CI__VI               = 0x31CC;
constexpr unsigned int mmSPI_WCL_PIPE_PERCENT_CS4__CI__VI               = 0x31CD;
constexpr unsigned int mmSPI_WCL_PIPE_PERCENT_CS5__CI__VI               = 0x31CE;
constexpr unsigned int mmSPI_WCL_PIPE_PERCENT_CS6__CI__VI               = 0x31CF;
constexpr unsigned int mmSPI_WCL_PIPE_PERCENT_CS7__CI__VI               = 0x31D0;
constexpr unsigned int mmSPI_WCL_PIPE_PERCENT_GFX__CI__VI               = 0x31C7;
constexpr unsigned int mmSPI_WCL_PIPE_PERCENT_HP3D__CI__VI              = 0x31C8;
constexpr unsigned int mmSPI_WF_LIFETIME_CNTL__CI__VI                   = 0x24AA;
constexpr unsigned int mmSPI_WF_LIFETIME_DEBUG__CI__VI                  = 0x24CA;
constexpr unsigned int mmSPI_WF_LIFETIME_LIMIT_0__CI__VI                = 0x24AB;
constexpr unsigned int mmSPI_WF_LIFETIME_LIMIT_1__CI__VI                = 0x24AC;
constexpr unsigned int mmSPI_WF_LIFETIME_LIMIT_2__CI__VI                = 0x24AD;
constexpr unsigned int mmSPI_WF_LIFETIME_LIMIT_3__CI__VI                = 0x24AE;
constexpr unsigned int mmSPI_WF_LIFETIME_LIMIT_4__CI__VI                = 0x24AF;
constexpr unsigned int mmSPI_WF_LIFETIME_LIMIT_5__CI__VI                = 0x24B0;
constexpr unsigned int mmSPI_WF_LIFETIME_LIMIT_6__CI__VI                = 0x24B1;
constexpr unsigned int mmSPI_WF_LIFETIME_LIMIT_7__CI__VI                = 0x24B2;
constexpr unsigned int mmSPI_WF_LIFETIME_LIMIT_8__CI__VI                = 0x24B3;
constexpr unsigned int mmSPI_WF_LIFETIME_LIMIT_9__CI__VI                = 0x24B4;
constexpr unsigned int mmSPI_WF_LIFETIME_STATUS_0__CI__VI               = 0x24B5;
constexpr unsigned int mmSPI_WF_LIFETIME_STATUS_10__CI__VI              = 0x24BF;
constexpr unsigned int mmSPI_WF_LIFETIME_STATUS_11__CI__VI              = 0x24C0;
constexpr unsigned int mmSPI_WF_LIFETIME_STATUS_12__CI__VI              = 0x24C1;
constexpr unsigned int mmSPI_WF_LIFETIME_STATUS_13__CI__VI              = 0x24C2;
constexpr unsigned int mmSPI_WF_LIFETIME_STATUS_14__CI__VI              = 0x24C3;
constexpr unsigned int mmSPI_WF_LIFETIME_STATUS_15__CI__VI              = 0x24C4;
constexpr unsigned int mmSPI_WF_LIFETIME_STATUS_16__CI__VI              = 0x24C5;
constexpr unsigned int mmSPI_WF_LIFETIME_STATUS_17__CI__VI              = 0x24C6;
constexpr unsigned int mmSPI_WF_LIFETIME_STATUS_18__CI__VI              = 0x24C7;
constexpr unsigned int mmSPI_WF_LIFETIME_STATUS_19__CI__VI              = 0x24C8;
constexpr unsigned int mmSPI_WF_LIFETIME_STATUS_1__CI__VI               = 0x24B6;
constexpr unsigned int mmSPI_WF_LIFETIME_STATUS_20__CI__VI              = 0x24C9;
constexpr unsigned int mmSPI_WF_LIFETIME_STATUS_2__CI__VI               = 0x24B7;
constexpr unsigned int mmSPI_WF_LIFETIME_STATUS_3__CI__VI               = 0x24B8;
constexpr unsigned int mmSPI_WF_LIFETIME_STATUS_4__CI__VI               = 0x24B9;
constexpr unsigned int mmSPI_WF_LIFETIME_STATUS_5__CI__VI               = 0x24BA;
constexpr unsigned int mmSPI_WF_LIFETIME_STATUS_6__CI__VI               = 0x24BB;
constexpr unsigned int mmSPI_WF_LIFETIME_STATUS_7__CI__VI               = 0x24BC;
constexpr unsigned int mmSPI_WF_LIFETIME_STATUS_8__CI__VI               = 0x24BD;
constexpr unsigned int mmSPI_WF_LIFETIME_STATUS_9__CI__VI               = 0x24BE;
constexpr unsigned int mmSPLL_CNTL_MODE__SI                             = 0x0186;
constexpr unsigned int mmSQC_CACHES__CI__VI                             = 0xC348;
constexpr unsigned int mmSQC_CACHES__SI                                 = 0x2302;
constexpr unsigned int mmSQC_CONFIG                                     = 0x2301;
constexpr unsigned int mmSQC_POLICY__CI                                 = 0x230E;
constexpr unsigned int mmSQC_SECDED_CNT__SI__CI                         = 0x23A0;
constexpr unsigned int mmSQC_VOLATILE__CI                               = 0x230F;
constexpr unsigned int mmSQ_ALU_CLK_CTRL__CI__VI                        = 0xF08E;
constexpr unsigned int mmSQ_ALU_CLK_CTRL__SI                            = 0x2360;
constexpr unsigned int mmSQ_BUF_RSRC_WORD0                              = 0x23C0;
constexpr unsigned int mmSQ_BUF_RSRC_WORD1                              = 0x23C1;
constexpr unsigned int mmSQ_BUF_RSRC_WORD2                              = 0x23C2;
constexpr unsigned int mmSQ_BUF_RSRC_WORD3                              = 0x23C3;
constexpr unsigned int mmSQ_CMD_TIMESTAMP__CI__VI                       = 0x2375;
constexpr unsigned int mmSQ_CMD__CI__VI                                 = 0x237B;
constexpr unsigned int mmSQ_CONFIG                                      = 0x2300;
constexpr unsigned int mmSQ_DEBUG_STS_GLOBAL                            = 0x2309;
constexpr unsigned int mmSQ_DEBUG_STS_GLOBAL2__CI__VI                   = 0x2310;
constexpr unsigned int mmSQ_DEBUG_STS_GLOBAL3__CI__VI                   = 0x2311;
constexpr unsigned int mmSQ_DED_CNT__SI__CI                             = 0x23A2;
constexpr unsigned int mmSQ_DED_INFO__SI__CI                            = 0x23A3;
constexpr unsigned int mmSQ_DS_0                                        = 0x237F;
constexpr unsigned int mmSQ_DS_1                                        = 0x237F;
constexpr unsigned int mmSQ_EXP_0                                       = 0x237F;
constexpr unsigned int mmSQ_EXP_1                                       = 0x237F;
constexpr unsigned int mmSQ_FIFO_SIZES                                  = 0x2305;
constexpr unsigned int mmSQ_FLAT_0__CI__VI                              = 0x237F;
constexpr unsigned int mmSQ_FLAT_1__CI__VI                              = 0x237F;
constexpr unsigned int mmSQ_FLAT_SCRATCH_WORD0__CI__VI                  = 0x23D0;
constexpr unsigned int mmSQ_FLAT_SCRATCH_WORD1__CI__VI                  = 0x23D1;
constexpr unsigned int mmSQ_HV_VMID_CTRL__CI__VI                        = 0xF840;
constexpr unsigned int mmSQ_IMG_RSRC_WORD0                              = 0x23C4;
constexpr unsigned int mmSQ_IMG_RSRC_WORD1                              = 0x23C5;
constexpr unsigned int mmSQ_IMG_RSRC_WORD2                              = 0x23C6;
constexpr unsigned int mmSQ_IMG_RSRC_WORD3                              = 0x23C7;
constexpr unsigned int mmSQ_IMG_RSRC_WORD4                              = 0x23C8;
constexpr unsigned int mmSQ_IMG_RSRC_WORD5                              = 0x23C9;
constexpr unsigned int mmSQ_IMG_RSRC_WORD6                              = 0x23CA;
constexpr unsigned int mmSQ_IMG_RSRC_WORD7                              = 0x23CB;
constexpr unsigned int mmSQ_IMG_SAMP_WORD0                              = 0x23CC;
constexpr unsigned int mmSQ_IMG_SAMP_WORD1                              = 0x23CD;
constexpr unsigned int mmSQ_IMG_SAMP_WORD2                              = 0x23CE;
constexpr unsigned int mmSQ_IMG_SAMP_WORD3                              = 0x23CF;
constexpr unsigned int mmSQ_IND_DATA                                    = 0x2379;
constexpr unsigned int mmSQ_IND_INDEX                                   = 0x2378;
constexpr unsigned int mmSQ_INST                                        = 0x237F;
constexpr unsigned int mmSQ_INTERRUPT_AUTO_MASK__CI__VI                 = 0x2314;
constexpr unsigned int mmSQ_INTERRUPT_MSG_CTRL__CI__VI                  = 0x2315;
constexpr unsigned int mmSQ_LB_CTR_CTRL                                 = 0x2398;
constexpr unsigned int mmSQ_LB_DATA_ALU_CYCLES                          = 0x2399;
constexpr unsigned int mmSQ_LB_DATA_ALU_STALLS                          = 0x239B;
constexpr unsigned int mmSQ_LB_DATA_TEX_CYCLES                          = 0x239A;
constexpr unsigned int mmSQ_LB_DATA_TEX_STALLS                          = 0x239C;
constexpr unsigned int mmSQ_LDS_CLK_CTRL__CI__VI                        = 0xF090;
constexpr unsigned int mmSQ_MIMG_0                                      = 0x237F;
constexpr unsigned int mmSQ_MIMG_1                                      = 0x237F;
constexpr unsigned int mmSQ_MTBUF_0                                     = 0x237F;
constexpr unsigned int mmSQ_MTBUF_1                                     = 0x237F;
constexpr unsigned int mmSQ_MUBUF_0                                     = 0x237F;
constexpr unsigned int mmSQ_MUBUF_1                                     = 0x237F;
constexpr unsigned int mmSQ_PERFCOUNTER0_HI__CI__VI                     = 0xD1C1;
constexpr unsigned int mmSQ_PERFCOUNTER0_HI__SI                         = 0x2321;
constexpr unsigned int mmSQ_PERFCOUNTER0_LO__CI__VI                     = 0xD1C0;
constexpr unsigned int mmSQ_PERFCOUNTER0_LO__SI                         = 0x2320;
constexpr unsigned int mmSQ_PERFCOUNTER0_SELECT__CI__VI                 = 0xD9C0;
constexpr unsigned int mmSQ_PERFCOUNTER0_SELECT__SI                     = 0x2340;
constexpr unsigned int mmSQ_PERFCOUNTER10_HI__CI__VI                    = 0xD1D5;
constexpr unsigned int mmSQ_PERFCOUNTER10_HI__SI                        = 0x2335;
constexpr unsigned int mmSQ_PERFCOUNTER10_LO__CI__VI                    = 0xD1D4;
constexpr unsigned int mmSQ_PERFCOUNTER10_LO__SI                        = 0x2334;
constexpr unsigned int mmSQ_PERFCOUNTER10_SELECT__CI__VI                = 0xD9CA;
constexpr unsigned int mmSQ_PERFCOUNTER10_SELECT__SI                    = 0x234A;
constexpr unsigned int mmSQ_PERFCOUNTER11_HI__CI__VI                    = 0xD1D7;
constexpr unsigned int mmSQ_PERFCOUNTER11_HI__SI                        = 0x2337;
constexpr unsigned int mmSQ_PERFCOUNTER11_LO__CI__VI                    = 0xD1D6;
constexpr unsigned int mmSQ_PERFCOUNTER11_LO__SI                        = 0x2336;
constexpr unsigned int mmSQ_PERFCOUNTER11_SELECT__CI__VI                = 0xD9CB;
constexpr unsigned int mmSQ_PERFCOUNTER11_SELECT__SI                    = 0x234B;
constexpr unsigned int mmSQ_PERFCOUNTER12_HI__CI__VI                    = 0xD1D9;
constexpr unsigned int mmSQ_PERFCOUNTER12_HI__SI                        = 0x2339;
constexpr unsigned int mmSQ_PERFCOUNTER12_LO__CI__VI                    = 0xD1D8;
constexpr unsigned int mmSQ_PERFCOUNTER12_LO__SI                        = 0x2338;
constexpr unsigned int mmSQ_PERFCOUNTER12_SELECT__CI__VI                = 0xD9CC;
constexpr unsigned int mmSQ_PERFCOUNTER12_SELECT__SI                    = 0x234C;
constexpr unsigned int mmSQ_PERFCOUNTER13_HI__CI__VI                    = 0xD1DB;
constexpr unsigned int mmSQ_PERFCOUNTER13_HI__SI                        = 0x233B;
constexpr unsigned int mmSQ_PERFCOUNTER13_LO__CI__VI                    = 0xD1DA;
constexpr unsigned int mmSQ_PERFCOUNTER13_LO__SI                        = 0x233A;
constexpr unsigned int mmSQ_PERFCOUNTER13_SELECT__CI__VI                = 0xD9CD;
constexpr unsigned int mmSQ_PERFCOUNTER13_SELECT__SI                    = 0x234D;
constexpr unsigned int mmSQ_PERFCOUNTER14_HI__CI__VI                    = 0xD1DD;
constexpr unsigned int mmSQ_PERFCOUNTER14_HI__SI                        = 0x233D;
constexpr unsigned int mmSQ_PERFCOUNTER14_LO__CI__VI                    = 0xD1DC;
constexpr unsigned int mmSQ_PERFCOUNTER14_LO__SI                        = 0x233C;
constexpr unsigned int mmSQ_PERFCOUNTER14_SELECT__CI__VI                = 0xD9CE;
constexpr unsigned int mmSQ_PERFCOUNTER14_SELECT__SI                    = 0x234E;
constexpr unsigned int mmSQ_PERFCOUNTER15_HI__CI__VI                    = 0xD1DF;
constexpr unsigned int mmSQ_PERFCOUNTER15_HI__SI                        = 0x233F;
constexpr unsigned int mmSQ_PERFCOUNTER15_LO__CI__VI                    = 0xD1DE;
constexpr unsigned int mmSQ_PERFCOUNTER15_LO__SI                        = 0x233E;
constexpr unsigned int mmSQ_PERFCOUNTER15_SELECT__CI__VI                = 0xD9CF;
constexpr unsigned int mmSQ_PERFCOUNTER15_SELECT__SI                    = 0x234F;
constexpr unsigned int mmSQ_PERFCOUNTER1_HI__CI__VI                     = 0xD1C3;
constexpr unsigned int mmSQ_PERFCOUNTER1_HI__SI                         = 0x2323;
constexpr unsigned int mmSQ_PERFCOUNTER1_LO__CI__VI                     = 0xD1C2;
constexpr unsigned int mmSQ_PERFCOUNTER1_LO__SI                         = 0x2322;
constexpr unsigned int mmSQ_PERFCOUNTER1_SELECT__CI__VI                 = 0xD9C1;
constexpr unsigned int mmSQ_PERFCOUNTER1_SELECT__SI                     = 0x2341;
constexpr unsigned int mmSQ_PERFCOUNTER2_HI__CI__VI                     = 0xD1C5;
constexpr unsigned int mmSQ_PERFCOUNTER2_HI__SI                         = 0x2325;
constexpr unsigned int mmSQ_PERFCOUNTER2_LO__CI__VI                     = 0xD1C4;
constexpr unsigned int mmSQ_PERFCOUNTER2_LO__SI                         = 0x2324;
constexpr unsigned int mmSQ_PERFCOUNTER2_SELECT__CI__VI                 = 0xD9C2;
constexpr unsigned int mmSQ_PERFCOUNTER2_SELECT__SI                     = 0x2342;
constexpr unsigned int mmSQ_PERFCOUNTER3_HI__CI__VI                     = 0xD1C7;
constexpr unsigned int mmSQ_PERFCOUNTER3_HI__SI                         = 0x2327;
constexpr unsigned int mmSQ_PERFCOUNTER3_LO__CI__VI                     = 0xD1C6;
constexpr unsigned int mmSQ_PERFCOUNTER3_LO__SI                         = 0x2326;
constexpr unsigned int mmSQ_PERFCOUNTER3_SELECT__CI__VI                 = 0xD9C3;
constexpr unsigned int mmSQ_PERFCOUNTER3_SELECT__SI                     = 0x2343;
constexpr unsigned int mmSQ_PERFCOUNTER4_HI__CI__VI                     = 0xD1C9;
constexpr unsigned int mmSQ_PERFCOUNTER4_HI__SI                         = 0x2329;
constexpr unsigned int mmSQ_PERFCOUNTER4_LO__CI__VI                     = 0xD1C8;
constexpr unsigned int mmSQ_PERFCOUNTER4_LO__SI                         = 0x2328;
constexpr unsigned int mmSQ_PERFCOUNTER4_SELECT__CI__VI                 = 0xD9C4;
constexpr unsigned int mmSQ_PERFCOUNTER4_SELECT__SI                     = 0x2344;
constexpr unsigned int mmSQ_PERFCOUNTER5_HI__CI__VI                     = 0xD1CB;
constexpr unsigned int mmSQ_PERFCOUNTER5_HI__SI                         = 0x232B;
constexpr unsigned int mmSQ_PERFCOUNTER5_LO__CI__VI                     = 0xD1CA;
constexpr unsigned int mmSQ_PERFCOUNTER5_LO__SI                         = 0x232A;
constexpr unsigned int mmSQ_PERFCOUNTER5_SELECT__CI__VI                 = 0xD9C5;
constexpr unsigned int mmSQ_PERFCOUNTER5_SELECT__SI                     = 0x2345;
constexpr unsigned int mmSQ_PERFCOUNTER6_HI__CI__VI                     = 0xD1CD;
constexpr unsigned int mmSQ_PERFCOUNTER6_HI__SI                         = 0x232D;
constexpr unsigned int mmSQ_PERFCOUNTER6_LO__CI__VI                     = 0xD1CC;
constexpr unsigned int mmSQ_PERFCOUNTER6_LO__SI                         = 0x232C;
constexpr unsigned int mmSQ_PERFCOUNTER6_SELECT__CI__VI                 = 0xD9C6;
constexpr unsigned int mmSQ_PERFCOUNTER6_SELECT__SI                     = 0x2346;
constexpr unsigned int mmSQ_PERFCOUNTER7_HI__CI__VI                     = 0xD1CF;
constexpr unsigned int mmSQ_PERFCOUNTER7_HI__SI                         = 0x232F;
constexpr unsigned int mmSQ_PERFCOUNTER7_LO__CI__VI                     = 0xD1CE;
constexpr unsigned int mmSQ_PERFCOUNTER7_LO__SI                         = 0x232E;
constexpr unsigned int mmSQ_PERFCOUNTER7_SELECT__CI__VI                 = 0xD9C7;
constexpr unsigned int mmSQ_PERFCOUNTER7_SELECT__SI                     = 0x2347;
constexpr unsigned int mmSQ_PERFCOUNTER8_HI__CI__VI                     = 0xD1D1;
constexpr unsigned int mmSQ_PERFCOUNTER8_HI__SI                         = 0x2331;
constexpr unsigned int mmSQ_PERFCOUNTER8_LO__CI__VI                     = 0xD1D0;
constexpr unsigned int mmSQ_PERFCOUNTER8_LO__SI                         = 0x2330;
constexpr unsigned int mmSQ_PERFCOUNTER8_SELECT__CI__VI                 = 0xD9C8;
constexpr unsigned int mmSQ_PERFCOUNTER8_SELECT__SI                     = 0x2348;
constexpr unsigned int mmSQ_PERFCOUNTER9_HI__CI__VI                     = 0xD1D3;
constexpr unsigned int mmSQ_PERFCOUNTER9_HI__SI                         = 0x2333;
constexpr unsigned int mmSQ_PERFCOUNTER9_LO__CI__VI                     = 0xD1D2;
constexpr unsigned int mmSQ_PERFCOUNTER9_LO__SI                         = 0x2332;
constexpr unsigned int mmSQ_PERFCOUNTER9_SELECT__CI__VI                 = 0xD9C9;
constexpr unsigned int mmSQ_PERFCOUNTER9_SELECT__SI                     = 0x2349;
constexpr unsigned int mmSQ_PERFCOUNTER_CTRL2__CI__VI                   = 0xD9E2;
constexpr unsigned int mmSQ_PERFCOUNTER_CTRL__CI__VI                    = 0xD9E0;
constexpr unsigned int mmSQ_PERFCOUNTER_CTRL__SI                        = 0x2306;
constexpr unsigned int mmSQ_PERFCOUNTER_MASK__CI__VI                    = 0xD9E1;
constexpr unsigned int mmSQ_POWER_THROTTLE2__CI__VI                     = 0xF092;
constexpr unsigned int mmSQ_POWER_THROTTLE2__SI                         = 0x2397;
constexpr unsigned int mmSQ_POWER_THROTTLE__CI__VI                      = 0xF091;
constexpr unsigned int mmSQ_POWER_THROTTLE__SI                          = 0x2396;
constexpr unsigned int mmSQ_RANDOM_WAVE_PRI                             = 0x2303;
constexpr unsigned int mmSQ_REG_CREDITS                                 = 0x2304;
constexpr unsigned int mmSQ_REG_TIMESTAMP__CI__VI                       = 0x2374;
constexpr unsigned int mmSQ_SEC_CNT__SI__CI                             = 0x23A1;
constexpr unsigned int mmSQ_SMRD__SI__CI                                = 0x237F;
constexpr unsigned int mmSQ_SOP1                                        = 0x237F;
constexpr unsigned int mmSQ_SOP2                                        = 0x237F;
constexpr unsigned int mmSQ_SOPC                                        = 0x237F;
constexpr unsigned int mmSQ_SOPK                                        = 0x237F;
constexpr unsigned int mmSQ_SOPP                                        = 0x237F;
constexpr unsigned int mmSQ_TEX_CLK_CTRL__CI__VI                        = 0xF08F;
constexpr unsigned int mmSQ_TEX_CLK_CTRL__SI                            = 0x2361;
constexpr unsigned int mmSQ_THREAD_TRACE_BASE2__CI                      = 0x2385;
constexpr unsigned int mmSQ_THREAD_TRACE_CNTR                           = 0x2390;
constexpr unsigned int mmSQ_THREAD_TRACE_TOKEN_MASK2__CI                = 0x2386;
constexpr unsigned int mmSQ_THREAD_TRACE_USERDATA_0__CI__VI             = 0xC340;
constexpr unsigned int mmSQ_THREAD_TRACE_USERDATA_0__SI                 = 0x2388;
constexpr unsigned int mmSQ_THREAD_TRACE_USERDATA_1__CI__VI             = 0xC341;
constexpr unsigned int mmSQ_THREAD_TRACE_USERDATA_1__SI                 = 0x2389;
constexpr unsigned int mmSQ_THREAD_TRACE_USERDATA_2__CI__VI             = 0xC342;
constexpr unsigned int mmSQ_THREAD_TRACE_USERDATA_2__SI                 = 0x238A;
constexpr unsigned int mmSQ_THREAD_TRACE_USERDATA_3__CI__VI             = 0xC343;
constexpr unsigned int mmSQ_THREAD_TRACE_USERDATA_3__SI                 = 0x238B;
constexpr unsigned int mmSQ_THREAD_TRACE_WORD_CMN                       = 0x23B0;
constexpr unsigned int mmSQ_THREAD_TRACE_WORD_EVENT                     = 0x23B0;
constexpr unsigned int mmSQ_THREAD_TRACE_WORD_INST                      = 0x23B0;
constexpr unsigned int mmSQ_THREAD_TRACE_WORD_INST_PC_1_OF_2            = 0x23B0;
constexpr unsigned int mmSQ_THREAD_TRACE_WORD_INST_PC_2_OF_2            = 0x23B1;
constexpr unsigned int mmSQ_THREAD_TRACE_WORD_INST_USERDATA_1_OF_2      = 0x23B0;
constexpr unsigned int mmSQ_THREAD_TRACE_WORD_INST_USERDATA_2_OF_2      = 0x23B1;
constexpr unsigned int mmSQ_THREAD_TRACE_WORD_ISSUE                     = 0x23B0;
constexpr unsigned int mmSQ_THREAD_TRACE_WORD_MISC                      = 0x23B0;
constexpr unsigned int mmSQ_THREAD_TRACE_WORD_PERF_1_OF_2               = 0x23B0;
constexpr unsigned int mmSQ_THREAD_TRACE_WORD_PERF_2_OF_2               = 0x23B1;
constexpr unsigned int mmSQ_THREAD_TRACE_WORD_REG_1_OF_2                = 0x23B0;
constexpr unsigned int mmSQ_THREAD_TRACE_WORD_REG_2_OF_2                = 0x23B0;
constexpr unsigned int mmSQ_THREAD_TRACE_WORD_REG_CS_1_OF_2__CI__VI     = 0x23B0;
constexpr unsigned int mmSQ_THREAD_TRACE_WORD_REG_CS_2_OF_2__CI__VI     = 0x23B0;
constexpr unsigned int mmSQ_THREAD_TRACE_WORD_TIMESTAMP_1_OF_2          = 0x23B0;
constexpr unsigned int mmSQ_THREAD_TRACE_WORD_TIMESTAMP_2_OF_2          = 0x23B1;
constexpr unsigned int mmSQ_THREAD_TRACE_WORD_TIME__SI                  = 0x23B0;
constexpr unsigned int mmSQ_THREAD_TRACE_WORD_WAVE                      = 0x23B0;
constexpr unsigned int mmSQ_THREAD_TRACE_WORD_WAVE_START                = 0x23B0;
constexpr unsigned int mmSQ_TIME_HI                                     = 0x237C;
constexpr unsigned int mmSQ_TIME_LO                                     = 0x237D;
constexpr unsigned int mmSQ_VINTRP                                      = 0x237F;
constexpr unsigned int mmSQ_VOP1                                        = 0x237F;
constexpr unsigned int mmSQ_VOP2                                        = 0x237F;
constexpr unsigned int mmSQ_VOP3_0                                      = 0x237F;
constexpr unsigned int mmSQ_VOP3_0_SDST_ENC                             = 0x237F;
constexpr unsigned int mmSQ_VOP3_1                                      = 0x237F;
constexpr unsigned int mmSQ_VOPC                                        = 0x237F;
constexpr unsigned int mmSRBM_CHIP_REVISION                             = 0x039B;
constexpr unsigned int mmSRBM_CNTL                                      = 0x0390;
constexpr unsigned int mmSRBM_DEBUG                                     = 0x03A4;
constexpr unsigned int mmSRBM_DEBUG_CNTL                                = 0x0399;
constexpr unsigned int mmSRBM_DEBUG_DATA                                = 0x039A;
constexpr unsigned int mmSRBM_DEBUG_SNAPSHOT                            = 0x03A5;
constexpr unsigned int mmSRBM_GFX_CNTL                                  = 0x0391;
constexpr unsigned int mmSRBM_INT_ACK                                   = 0x03AA;
constexpr unsigned int mmSRBM_INT_CNTL                                  = 0x03A8;
constexpr unsigned int mmSRBM_INT_STATUS                                = 0x03A9;
constexpr unsigned int mmSRBM_MC_CLKEN_CNTL__CI__VI                     = 0x03B3;
constexpr unsigned int mmSRBM_READ_ERROR                                = 0x03A6;
constexpr unsigned int mmSRBM_SAM_CLKEN_CNTL__CI__VI                    = 0x03B8;
constexpr unsigned int mmSRBM_SDMA_CLKEN_CNTL__CI__VI                   = 0x03B7;
constexpr unsigned int mmSRBM_SOFT_RESET                                = 0x0398;
constexpr unsigned int mmSRBM_STATUS                                    = 0x0394;
constexpr unsigned int mmSRBM_STATUS2                                   = 0x0393;
constexpr unsigned int mmSRBM_SYS_CLKEN_CNTL                            = 0x03B4;
constexpr unsigned int mmSRBM_UVD_CLKEN_CNTL                            = 0x03B6;
constexpr unsigned int mmSRBM_VCE_CLKEN_CNTL                            = 0x03B5;
constexpr unsigned int mmSX_DEBUG_1                                     = 0x2418;
constexpr unsigned int mmSX_DEBUG_BUSY                                  = 0x2414;
constexpr unsigned int mmSX_DEBUG_BUSY_2                                = 0x2415;
constexpr unsigned int mmSX_DEBUG_BUSY_3                                = 0x2416;
constexpr unsigned int mmSX_DEBUG_BUSY_4                                = 0x2417;
constexpr unsigned int mmSX_PERFCOUNTER0_HI__CI__VI                     = 0xD241;
constexpr unsigned int mmSX_PERFCOUNTER0_HI__SI                         = 0x2421;
constexpr unsigned int mmSX_PERFCOUNTER0_LO__CI__VI                     = 0xD240;
constexpr unsigned int mmSX_PERFCOUNTER0_LO__SI                         = 0x2420;
constexpr unsigned int mmSX_PERFCOUNTER0_SELECT1__CI__VI                = 0xDA44;
constexpr unsigned int mmSX_PERFCOUNTER0_SELECT__CI__VI                 = 0xDA40;
constexpr unsigned int mmSX_PERFCOUNTER0_SELECT__SI                     = 0x241C;
constexpr unsigned int mmSX_PERFCOUNTER1_HI__CI__VI                     = 0xD243;
constexpr unsigned int mmSX_PERFCOUNTER1_HI__SI                         = 0x2423;
constexpr unsigned int mmSX_PERFCOUNTER1_LO__CI__VI                     = 0xD242;
constexpr unsigned int mmSX_PERFCOUNTER1_LO__SI                         = 0x2422;
constexpr unsigned int mmSX_PERFCOUNTER1_SELECT1__CI__VI                = 0xDA45;
constexpr unsigned int mmSX_PERFCOUNTER1_SELECT__CI__VI                 = 0xDA41;
constexpr unsigned int mmSX_PERFCOUNTER1_SELECT__SI                     = 0x241D;
constexpr unsigned int mmSX_PERFCOUNTER2_HI__CI__VI                     = 0xD245;
constexpr unsigned int mmSX_PERFCOUNTER2_HI__SI                         = 0x2425;
constexpr unsigned int mmSX_PERFCOUNTER2_LO__CI__VI                     = 0xD244;
constexpr unsigned int mmSX_PERFCOUNTER2_LO__SI                         = 0x2424;
constexpr unsigned int mmSX_PERFCOUNTER2_SELECT__CI__VI                 = 0xDA42;
constexpr unsigned int mmSX_PERFCOUNTER2_SELECT__SI                     = 0x241E;
constexpr unsigned int mmSX_PERFCOUNTER3_HI__CI__VI                     = 0xD247;
constexpr unsigned int mmSX_PERFCOUNTER3_HI__SI                         = 0x2427;
constexpr unsigned int mmSX_PERFCOUNTER3_LO__CI__VI                     = 0xD246;
constexpr unsigned int mmSX_PERFCOUNTER3_LO__SI                         = 0x2426;
constexpr unsigned int mmSX_PERFCOUNTER3_SELECT__CI__VI                 = 0xDA43;
constexpr unsigned int mmSX_PERFCOUNTER3_SELECT__SI                     = 0x241F;
constexpr unsigned int mmTARGET_AND_CURRENT_PROFILE_INDEX_1__SI         = 0x021D;
constexpr unsigned int mmTARGET_AND_CURRENT_PROFILE_INDEX__SI           = 0x01E6;
constexpr unsigned int mmTA_BC_BASE_ADDR                                = 0xA020;
constexpr unsigned int mmTA_BC_BASE_ADDR_HI__CI__VI                     = 0xA021;
constexpr unsigned int mmTA_CGTT_CTRL__CI__VI                           = 0xF09D;
constexpr unsigned int mmTA_CGTT_CTRL__SI                               = 0x2544;
constexpr unsigned int mmTA_CNTL                                        = 0x2541;
constexpr unsigned int mmTA_CNTL_AUX                                    = 0x2542;
constexpr unsigned int mmTA_CS_BC_BASE_ADDR_HI__CI__VI                  = 0xC381;
constexpr unsigned int mmTA_CS_BC_BASE_ADDR__CI__VI                     = 0xC380;
constexpr unsigned int mmTA_CS_BC_BASE_ADDR__SI                         = 0x2543;
constexpr unsigned int mmTA_DEBUG_DATA                                  = 0x254D;
constexpr unsigned int mmTA_DEBUG_INDEX                                 = 0x254C;
constexpr unsigned int mmTA_PERFCOUNTER0_HI__CI__VI                     = 0xD2C1;
constexpr unsigned int mmTA_PERFCOUNTER0_HI__SI                         = 0x2556;
constexpr unsigned int mmTA_PERFCOUNTER0_LO__CI__VI                     = 0xD2C0;
constexpr unsigned int mmTA_PERFCOUNTER0_LO__SI                         = 0x2555;
constexpr unsigned int mmTA_PERFCOUNTER0_SELECT1__CI__VI                = 0xDAC1;
constexpr unsigned int mmTA_PERFCOUNTER0_SELECT__CI__VI                 = 0xDAC0;
constexpr unsigned int mmTA_PERFCOUNTER0_SELECT__SI                     = 0x2554;
constexpr unsigned int mmTA_PERFCOUNTER1_HI__CI__VI                     = 0xD2C3;
constexpr unsigned int mmTA_PERFCOUNTER1_HI__SI                         = 0x2562;
constexpr unsigned int mmTA_PERFCOUNTER1_LO__CI__VI                     = 0xD2C2;
constexpr unsigned int mmTA_PERFCOUNTER1_LO__SI                         = 0x2561;
constexpr unsigned int mmTA_PERFCOUNTER1_SELECT__CI__VI                 = 0xDAC2;
constexpr unsigned int mmTA_PERFCOUNTER1_SELECT__SI                     = 0x2560;
constexpr unsigned int mmTA_RESERVED_010C__CI__VI                       = 0x2543;
constexpr unsigned int mmTA_SCRATCH                                     = 0x2564;
constexpr unsigned int mmTA_STATUS                                      = 0x2548;
constexpr unsigned int mmTCA_CGTT_SCLK_CTRL__CI__VI                     = 0xF0AD;
constexpr unsigned int mmTCA_CGTT_SCLK_CTRL__SI                         = 0x2BC1;
constexpr unsigned int mmTCA_CTRL                                       = 0x2BC0;
constexpr unsigned int mmTCA_PERFCOUNTER0_HI__CI__VI                    = 0xD391;
constexpr unsigned int mmTCA_PERFCOUNTER0_HI__SI                        = 0x2BD2;
constexpr unsigned int mmTCA_PERFCOUNTER0_LO__CI__VI                    = 0xD390;
constexpr unsigned int mmTCA_PERFCOUNTER0_LO__SI                        = 0x2BD1;
constexpr unsigned int mmTCA_PERFCOUNTER0_SELECT1__CI__VI               = 0xDB91;
constexpr unsigned int mmTCA_PERFCOUNTER0_SELECT__CI__VI                = 0xDB90;
constexpr unsigned int mmTCA_PERFCOUNTER0_SELECT__SI                    = 0x2BD0;
constexpr unsigned int mmTCA_PERFCOUNTER1_HI__CI__VI                    = 0xD393;
constexpr unsigned int mmTCA_PERFCOUNTER1_HI__SI                        = 0x2BD5;
constexpr unsigned int mmTCA_PERFCOUNTER1_LO__CI__VI                    = 0xD392;
constexpr unsigned int mmTCA_PERFCOUNTER1_LO__SI                        = 0x2BD4;
constexpr unsigned int mmTCA_PERFCOUNTER1_SELECT1__CI__VI               = 0xDB93;
constexpr unsigned int mmTCA_PERFCOUNTER1_SELECT__CI__VI                = 0xDB92;
constexpr unsigned int mmTCA_PERFCOUNTER1_SELECT__SI                    = 0x2BD3;
constexpr unsigned int mmTCA_PERFCOUNTER2_HI__CI__VI                    = 0xD395;
constexpr unsigned int mmTCA_PERFCOUNTER2_HI__SI                        = 0x2BD8;
constexpr unsigned int mmTCA_PERFCOUNTER2_LO__CI__VI                    = 0xD394;
constexpr unsigned int mmTCA_PERFCOUNTER2_LO__SI                        = 0x2BD7;
constexpr unsigned int mmTCA_PERFCOUNTER2_SELECT__CI__VI                = 0xDB94;
constexpr unsigned int mmTCA_PERFCOUNTER2_SELECT__SI                    = 0x2BD6;
constexpr unsigned int mmTCA_PERFCOUNTER3_HI__CI__VI                    = 0xD397;
constexpr unsigned int mmTCA_PERFCOUNTER3_HI__SI                        = 0x2BDB;
constexpr unsigned int mmTCA_PERFCOUNTER3_LO__CI__VI                    = 0xD396;
constexpr unsigned int mmTCA_PERFCOUNTER3_LO__SI                        = 0x2BDA;
constexpr unsigned int mmTCA_PERFCOUNTER3_SELECT__CI__VI                = 0xDB95;
constexpr unsigned int mmTCA_PERFCOUNTER3_SELECT__SI                    = 0x2BD9;
constexpr unsigned int mmTCC_CGTT_SCLK_CTRL__CI__VI                     = 0xF0AC;
constexpr unsigned int mmTCC_CGTT_SCLK_CTRL__SI                         = 0x2B81;
constexpr unsigned int mmTCC_CTRL                                       = 0x2B80;
constexpr unsigned int mmTCC_EDC_COUNTER__SI__CI                        = 0x2B82;
constexpr unsigned int mmTCC_PERFCOUNTER0_HI__CI__VI                    = 0xD381;
constexpr unsigned int mmTCC_PERFCOUNTER0_HI__SI                        = 0x2B92;
constexpr unsigned int mmTCC_PERFCOUNTER0_LO__CI__VI                    = 0xD380;
constexpr unsigned int mmTCC_PERFCOUNTER0_LO__SI                        = 0x2B91;
constexpr unsigned int mmTCC_PERFCOUNTER0_SELECT1__CI__VI               = 0xDB81;
constexpr unsigned int mmTCC_PERFCOUNTER0_SELECT__CI__VI                = 0xDB80;
constexpr unsigned int mmTCC_PERFCOUNTER0_SELECT__SI                    = 0x2B90;
constexpr unsigned int mmTCC_PERFCOUNTER1_HI__CI__VI                    = 0xD383;
constexpr unsigned int mmTCC_PERFCOUNTER1_HI__SI                        = 0x2B95;
constexpr unsigned int mmTCC_PERFCOUNTER1_LO__CI__VI                    = 0xD382;
constexpr unsigned int mmTCC_PERFCOUNTER1_LO__SI                        = 0x2B94;
constexpr unsigned int mmTCC_PERFCOUNTER1_SELECT1__CI__VI               = 0xDB83;
constexpr unsigned int mmTCC_PERFCOUNTER1_SELECT__CI__VI                = 0xDB82;
constexpr unsigned int mmTCC_PERFCOUNTER1_SELECT__SI                    = 0x2B93;
constexpr unsigned int mmTCC_PERFCOUNTER2_HI__CI__VI                    = 0xD385;
constexpr unsigned int mmTCC_PERFCOUNTER2_HI__SI                        = 0x2B98;
constexpr unsigned int mmTCC_PERFCOUNTER2_LO__CI__VI                    = 0xD384;
constexpr unsigned int mmTCC_PERFCOUNTER2_LO__SI                        = 0x2B97;
constexpr unsigned int mmTCC_PERFCOUNTER2_SELECT__CI__VI                = 0xDB84;
constexpr unsigned int mmTCC_PERFCOUNTER2_SELECT__SI                    = 0x2B96;
constexpr unsigned int mmTCC_PERFCOUNTER3_HI__CI__VI                    = 0xD387;
constexpr unsigned int mmTCC_PERFCOUNTER3_HI__SI                        = 0x2B9B;
constexpr unsigned int mmTCC_PERFCOUNTER3_LO__CI__VI                    = 0xD386;
constexpr unsigned int mmTCC_PERFCOUNTER3_LO__SI                        = 0x2B9A;
constexpr unsigned int mmTCC_PERFCOUNTER3_SELECT__CI__VI                = 0xDB85;
constexpr unsigned int mmTCC_PERFCOUNTER3_SELECT__SI                    = 0x2B99;
constexpr unsigned int mmTCC_REDUNDANCY__CI__VI                         = 0x2B83;
constexpr unsigned int mmTCI_CNTL_1                                     = 0x2B62;
constexpr unsigned int mmTCI_CNTL_2                                     = 0x2B63;
constexpr unsigned int mmTCI_STATUS                                     = 0x2B61;
constexpr unsigned int mmTCP_ADDR_CONFIG                                = 0x2B05;
constexpr unsigned int mmTCP_BUFFER_ADDR_HASH_CNTL                      = 0x2B16;
constexpr unsigned int mmTCP_CHAN_STEER_HI                              = 0x2B04;
constexpr unsigned int mmTCP_CHAN_STEER_LO                              = 0x2B03;
constexpr unsigned int mmTCP_CNTL                                       = 0x2B02;
constexpr unsigned int mmTCP_CREDIT                                     = 0x2B06;
constexpr unsigned int mmTCP_EDC_COUNTER__SI__CI                        = 0x2B17;
constexpr unsigned int mmTCP_INVALIDATE                                 = 0x2B00;
constexpr unsigned int mmTCP_PERFCOUNTER0_HI__CI__VI                    = 0xD341;
constexpr unsigned int mmTCP_PERFCOUNTER0_HI__SI                        = 0x2B0A;
constexpr unsigned int mmTCP_PERFCOUNTER0_LO__CI__VI                    = 0xD340;
constexpr unsigned int mmTCP_PERFCOUNTER0_LO__SI                        = 0x2B0B;
constexpr unsigned int mmTCP_PERFCOUNTER0_SELECT1__CI__VI               = 0xDB41;
constexpr unsigned int mmTCP_PERFCOUNTER0_SELECT__CI__VI                = 0xDB40;
constexpr unsigned int mmTCP_PERFCOUNTER0_SELECT__SI                    = 0x2B09;
constexpr unsigned int mmTCP_PERFCOUNTER1_HI__CI__VI                    = 0xD343;
constexpr unsigned int mmTCP_PERFCOUNTER1_HI__SI                        = 0x2B0D;
constexpr unsigned int mmTCP_PERFCOUNTER1_LO__CI__VI                    = 0xD342;
constexpr unsigned int mmTCP_PERFCOUNTER1_LO__SI                        = 0x2B0E;
constexpr unsigned int mmTCP_PERFCOUNTER1_SELECT1__CI__VI               = 0xDB43;
constexpr unsigned int mmTCP_PERFCOUNTER1_SELECT__CI__VI                = 0xDB42;
constexpr unsigned int mmTCP_PERFCOUNTER1_SELECT__SI                    = 0x2B0C;
constexpr unsigned int mmTCP_PERFCOUNTER2_HI__CI__VI                    = 0xD345;
constexpr unsigned int mmTCP_PERFCOUNTER2_HI__SI                        = 0x2B10;
constexpr unsigned int mmTCP_PERFCOUNTER2_LO__CI__VI                    = 0xD344;
constexpr unsigned int mmTCP_PERFCOUNTER2_LO__SI                        = 0x2B11;
constexpr unsigned int mmTCP_PERFCOUNTER2_SELECT__CI__VI                = 0xDB44;
constexpr unsigned int mmTCP_PERFCOUNTER2_SELECT__SI                    = 0x2B0F;
constexpr unsigned int mmTCP_PERFCOUNTER3_HI__CI__VI                    = 0xD347;
constexpr unsigned int mmTCP_PERFCOUNTER3_HI__SI                        = 0x2B13;
constexpr unsigned int mmTCP_PERFCOUNTER3_LO__CI__VI                    = 0xD346;
constexpr unsigned int mmTCP_PERFCOUNTER3_LO__SI                        = 0x2B14;
constexpr unsigned int mmTCP_PERFCOUNTER3_SELECT__CI__VI                = 0xDB45;
constexpr unsigned int mmTCP_PERFCOUNTER3_SELECT__SI                    = 0x2B12;
constexpr unsigned int mmTCP_STATUS                                     = 0x2B01;
constexpr unsigned int mmTCP_WATCH0_ADDR_H__CI__VI                      = 0x32A0;
constexpr unsigned int mmTCP_WATCH0_ADDR_L__CI__VI                      = 0x32A1;
constexpr unsigned int mmTCP_WATCH0_CNTL__CI__VI                        = 0x32A2;
constexpr unsigned int mmTCP_WATCH1_ADDR_H__CI__VI                      = 0x32A3;
constexpr unsigned int mmTCP_WATCH1_ADDR_L__CI__VI                      = 0x32A4;
constexpr unsigned int mmTCP_WATCH1_CNTL__CI__VI                        = 0x32A5;
constexpr unsigned int mmTCP_WATCH2_ADDR_H__CI__VI                      = 0x32A6;
constexpr unsigned int mmTCP_WATCH2_ADDR_L__CI__VI                      = 0x32A7;
constexpr unsigned int mmTCP_WATCH2_CNTL__CI__VI                        = 0x32A8;
constexpr unsigned int mmTCP_WATCH3_ADDR_H__CI__VI                      = 0x32A9;
constexpr unsigned int mmTCP_WATCH3_ADDR_L__CI__VI                      = 0x32AA;
constexpr unsigned int mmTCP_WATCH3_CNTL__CI__VI                        = 0x32AB;
constexpr unsigned int mmTCS_CGTT_SCLK_CTRL__CI                         = 0xF0AE;
constexpr unsigned int mmTCS_CTRL__CI                                   = 0x2BE0;
constexpr unsigned int mmTCS_PERFCOUNTER0_HI__CI                        = 0xD3A1;
constexpr unsigned int mmTCS_PERFCOUNTER0_LO__CI                        = 0xD3A0;
constexpr unsigned int mmTCS_PERFCOUNTER0_SELECT1__CI                   = 0xDBA1;
constexpr unsigned int mmTCS_PERFCOUNTER0_SELECT__CI                    = 0xDBA0;
constexpr unsigned int mmTCS_PERFCOUNTER1_HI__CI                        = 0xD3A3;
constexpr unsigned int mmTCS_PERFCOUNTER1_LO__CI                        = 0xD3A2;
constexpr unsigned int mmTCS_PERFCOUNTER1_SELECT__CI                    = 0xDBA2;
constexpr unsigned int mmTCS_PERFCOUNTER2_HI__CI                        = 0xD3A5;
constexpr unsigned int mmTCS_PERFCOUNTER2_LO__CI                        = 0xD3A4;
constexpr unsigned int mmTCS_PERFCOUNTER2_SELECT__CI                    = 0xDBA3;
constexpr unsigned int mmTCS_PERFCOUNTER3_HI__CI                        = 0xD3A7;
constexpr unsigned int mmTCS_PERFCOUNTER3_LO__CI                        = 0xD3A6;
constexpr unsigned int mmTCS_PERFCOUNTER3_SELECT__CI                    = 0xDBA4;
constexpr unsigned int mmTC_CFG_L1_LOAD_POLICY0__CI__VI                 = 0x2B1A;
constexpr unsigned int mmTC_CFG_L1_LOAD_POLICY1__CI__VI                 = 0x2B1B;
constexpr unsigned int mmTC_CFG_L1_STORE_POLICY__CI__VI                 = 0x2B1C;
constexpr unsigned int mmTC_CFG_L1_VOLATILE__CI__VI                     = 0x2B22;
constexpr unsigned int mmTC_CFG_L2_ATOMIC_POLICY__CI__VI                = 0x2B21;
constexpr unsigned int mmTC_CFG_L2_LOAD_POLICY0__CI__VI                 = 0x2B1D;
constexpr unsigned int mmTC_CFG_L2_LOAD_POLICY1__CI__VI                 = 0x2B1E;
constexpr unsigned int mmTC_CFG_L2_STORE_POLICY0__CI__VI                = 0x2B1F;
constexpr unsigned int mmTC_CFG_L2_STORE_POLICY1__CI__VI                = 0x2B20;
constexpr unsigned int mmTC_CFG_L2_VOLATILE__CI__VI                     = 0x2B23;
constexpr unsigned int mmTD_CGTT_CTRL__CI__VI                           = 0xF09C;
constexpr unsigned int mmTD_CGTT_CTRL__SI                               = 0x2527;
constexpr unsigned int mmTD_CNTL                                        = 0x2525;
constexpr unsigned int mmTD_DEBUG_DATA                                  = 0x2529;
constexpr unsigned int mmTD_DEBUG_INDEX                                 = 0x2528;
constexpr unsigned int mmTD_PERFCOUNTER0_HI__CI__VI                     = 0xD301;
constexpr unsigned int mmTD_PERFCOUNTER0_HI__SI                         = 0x252E;
constexpr unsigned int mmTD_PERFCOUNTER0_LO__CI__VI                     = 0xD300;
constexpr unsigned int mmTD_PERFCOUNTER0_LO__SI                         = 0x252D;
constexpr unsigned int mmTD_PERFCOUNTER0_SELECT1__CI__VI                = 0xDB01;
constexpr unsigned int mmTD_PERFCOUNTER0_SELECT__CI__VI                 = 0xDB00;
constexpr unsigned int mmTD_PERFCOUNTER0_SELECT__SI                     = 0x252C;
constexpr unsigned int mmTD_PERFCOUNTER1_HI__CI__VI                     = 0xD303;
constexpr unsigned int mmTD_PERFCOUNTER1_LO__CI__VI                     = 0xD302;
constexpr unsigned int mmTD_PERFCOUNTER1_SELECT__CI__VI                 = 0xDB02;
constexpr unsigned int mmTD_SCRATCH__CI__VI                             = 0x2533;
constexpr unsigned int mmTD_SCRATCH__SI                                 = 0x2530;
constexpr unsigned int mmTD_STATUS                                      = 0x2526;
constexpr unsigned int mmTHM_CLK_CNTL__SI                               = 0x019A;
constexpr unsigned int mmTMDS_CNTL__SI                                  = 0x1C7C;
constexpr unsigned int mmTMDS_CONTROL0_FEEDBACK__SI                     = 0x1C7E;
constexpr unsigned int mmTMDS_CONTROL_CHAR__SI                          = 0x1C7D;
constexpr unsigned int mmTMDS_CTL0_1_GEN_CNTL__SI                       = 0x1C86;
constexpr unsigned int mmTMDS_CTL2_3_GEN_CNTL__SI                       = 0x1C87;
constexpr unsigned int mmTMDS_CTL_BITS__SI                              = 0x1C83;
constexpr unsigned int mmTMDS_DCBALANCER_CONTROL__SI                    = 0x1C84;
constexpr unsigned int mmTMDS_DEBUG__SI                                 = 0x1C82;
constexpr unsigned int mmTMDS_STEREOSYNC_CTL_SEL__SI                    = 0x1C7F;
constexpr unsigned int mmTMDS_SYNC_CHAR_PATTERN_0_1__SI                 = 0x1C80;
constexpr unsigned int mmTMDS_SYNC_CHAR_PATTERN_2_3__SI                 = 0x1C81;
constexpr unsigned int mmUNIPHY_DATA_SYNCHRONIZATION__SI                = 0x1984;
constexpr unsigned int mmUNIPHY_IMPCAL_LINKA__SI                        = 0x1947;
constexpr unsigned int mmUNIPHY_IMPCAL_LINKB__SI                        = 0x1948;
constexpr unsigned int mmUNIPHY_IMPCAL_LINKC__SI                        = 0x194D;
constexpr unsigned int mmUNIPHY_IMPCAL_LINKD__SI                        = 0x194E;
constexpr unsigned int mmUNIPHY_IMPCAL_LINKE__SI                        = 0x1950;
constexpr unsigned int mmUNIPHY_IMPCAL_LINKF__SI                        = 0x1951;
constexpr unsigned int mmUNIPHY_IMPCAL_PERIOD__SI                       = 0x1949;
constexpr unsigned int mmUNIPHY_REG_TEST_OUTPUT__SI                     = 0x1986;
constexpr unsigned int mmUSER_SQC_BANK_DISABLE                          = 0x2308;
constexpr unsigned int mmUVD_CGC_CTRL__SI__VI                           = 0x3D2C;
constexpr unsigned int mmUVD_CGC_GATE__SI__VI                           = 0x3D2A;
constexpr unsigned int mmUVD_CGC_STATUS__SI__VI                         = 0x3D2B;
constexpr unsigned int mmUVD_CONFIG__CI__VI                             = 0x0F93;
constexpr unsigned int mmUVD_CONFIG__SI                                 = 0x0F98;
constexpr unsigned int mmUVD_CONTEXT_ID__SI__VI                         = 0x3DBD;
constexpr unsigned int mmUVD_CTX_DATA__SI__VI                           = 0x3D29;
constexpr unsigned int mmUVD_CTX_INDEX__SI__VI                          = 0x3D28;
constexpr unsigned int mmUVD_ENGINE_CNTL__SI__VI                        = 0x3BC6;
constexpr unsigned int mmUVD_GPCOM_VCPU_CMD__SI__VI                     = 0x3BC3;
constexpr unsigned int mmUVD_GPCOM_VCPU_DATA0__SI__VI                   = 0x3BC4;
constexpr unsigned int mmUVD_GPCOM_VCPU_DATA1__SI__VI                   = 0x3BC5;
constexpr unsigned int mmUVD_LMI_ADDR_EXT__SI__VI                       = 0x3D65;
constexpr unsigned int mmUVD_LMI_CTRL2__SI__VI                          = 0x3D3D;
constexpr unsigned int mmUVD_LMI_CTRL__SI__VI                           = 0x3D66;
constexpr unsigned int mmUVD_LMI_EXT40_ADDR__SI__VI                     = 0x3D26;
constexpr unsigned int mmUVD_LMI_STATUS__SI__VI                         = 0x3D67;
constexpr unsigned int mmUVD_LMI_SWAP_CNTL__SI__VI                      = 0x3D6D;
constexpr unsigned int mmUVD_MASTINT_EN__SI__VI                         = 0x3D40;
constexpr unsigned int mmUVD_MPC_CNTL__SI__VI                           = 0x3D77;
constexpr unsigned int mmUVD_MPC_SET_ALU__SI__VI                        = 0x3D7E;
constexpr unsigned int mmUVD_MPC_SET_MUXA0__SI__VI                      = 0x3D79;
constexpr unsigned int mmUVD_MPC_SET_MUXA1__SI__VI                      = 0x3D7A;
constexpr unsigned int mmUVD_MPC_SET_MUXB0__SI__VI                      = 0x3D7B;
constexpr unsigned int mmUVD_MPC_SET_MUXB1__SI__VI                      = 0x3D7C;
constexpr unsigned int mmUVD_MPC_SET_MUX__SI__VI                        = 0x3D7D;
constexpr unsigned int mmUVD_MP_SWAP_CNTL__SI__VI                       = 0x3D6F;
constexpr unsigned int mmUVD_RBC_IB_BASE__SI                            = 0x3DA1;
constexpr unsigned int mmUVD_RBC_IB_SIZE__SI__VI                        = 0x3DA2;
constexpr unsigned int mmUVD_RBC_RB_BASE__SI                            = 0x3DA3;
constexpr unsigned int mmUVD_RBC_RB_CNTL__SI__VI                        = 0x3DA9;
constexpr unsigned int mmUVD_RBC_RB_RPTR_ADDR__SI__VI                   = 0x3DAA;
constexpr unsigned int mmUVD_RBC_RB_RPTR__SI__VI                        = 0x3DA4;
constexpr unsigned int mmUVD_RBC_RB_WPTR__SI__VI                        = 0x3DA5;
constexpr unsigned int mmUVD_SEMA_ADDR_HIGH__SI__VI                     = 0x3BC1;
constexpr unsigned int mmUVD_SEMA_ADDR_LOW__SI__VI                      = 0x3BC0;
constexpr unsigned int mmUVD_SEMA_CMD__SI__VI                           = 0x3BC2;
constexpr unsigned int mmUVD_SEMA_CNTL__SI__VI                          = 0x3D00;
constexpr unsigned int mmUVD_SEMA_SIGNAL_INCOMPLETE_TIMEOUT_CNTL__SI__VI  = 0x3DB3;
constexpr unsigned int mmUVD_SEMA_TIMEOUT_STATUS__SI__VI                = 0x3DB0;
constexpr unsigned int mmUVD_SEMA_WAIT_FAULT_TIMEOUT_CNTL__SI__VI       = 0x3DB2;
constexpr unsigned int mmUVD_SEMA_WAIT_INCOMPLETE_TIMEOUT_CNTL__SI__VI  = 0x3DB1;
constexpr unsigned int mmUVD_SOFT_RESET__SI__VI                         = 0x3DA0;
constexpr unsigned int mmUVD_STATUS__SI__VI                             = 0x3DAF;
constexpr unsigned int mmUVD_VCPU_CACHE_OFFSET0__SI__VI                 = 0x3D82;
constexpr unsigned int mmUVD_VCPU_CACHE_OFFSET1__SI__VI                 = 0x3D84;
constexpr unsigned int mmUVD_VCPU_CACHE_OFFSET2__SI__VI                 = 0x3D86;
constexpr unsigned int mmUVD_VCPU_CACHE_SIZE0__SI__VI                   = 0x3D83;
constexpr unsigned int mmUVD_VCPU_CACHE_SIZE1__SI__VI                   = 0x3D85;
constexpr unsigned int mmUVD_VCPU_CACHE_SIZE2__SI__VI                   = 0x3D87;
constexpr unsigned int mmUVD_VCPU_CNTL__SI__VI                          = 0x3D98;
constexpr unsigned int mmVBLANK_STATUS__SI                              = 0x1AEF;
constexpr unsigned int mmVCE_CONFIG__CI__VI                             = 0x0F94;
constexpr unsigned int mmVGA25_PPLL_FB_DIV__SI                          = 0x00DE;
constexpr unsigned int mmVGA25_PPLL_POST_DIV__SI                        = 0x00E2;
constexpr unsigned int mmVGA25_PPLL_REF_DIV__SI                         = 0x00D9;
constexpr unsigned int mmVGA28_PPLL_FB_DIV__SI                          = 0x00DF;
constexpr unsigned int mmVGA28_PPLL_POST_DIV__SI                        = 0x00E4;
constexpr unsigned int mmVGA28_PPLL_REF_DIV__SI                         = 0x00DB;
constexpr unsigned int mmVGA41_PPLL_FB_DIV__SI                          = 0x00E0;
constexpr unsigned int mmVGA41_PPLL_POST_DIV__SI                        = 0x00E6;
constexpr unsigned int mmVGA41_PPLL_REF_DIV__SI                         = 0x00DD;
constexpr unsigned int mmVGA_CACHE_CONTROL__SI__VI                      = 0x00CB;
constexpr unsigned int mmVGA_DEBUG_READBACK_DATA__SI__VI                = 0x00D7;
constexpr unsigned int mmVGA_DEBUG_READBACK_INDEX__SI__VI               = 0x00D6;
constexpr unsigned int mmVGA_DISPBUF1_SURFACE_ADDR__SI__VI              = 0x00C6;
constexpr unsigned int mmVGA_DISPBUF2_SURFACE_ADDR__SI__VI              = 0x00C8;
constexpr unsigned int mmVGA_HDP_CONTROL__SI__VI                        = 0x00CA;
constexpr unsigned int mmVGA_HW_DEBUG__SI__VI                           = 0x00CF;
constexpr unsigned int mmVGA_INTERRUPT_CONTROL__SI__VI                  = 0x00D1;
constexpr unsigned int mmVGA_INTERRUPT_STATUS__SI__VI                   = 0x00D3;
constexpr unsigned int mmVGA_MAIN_CONTROL__SI__VI                       = 0x00D4;
constexpr unsigned int mmVGA_MEMORY_BASE_ADDRESS_HIGH__SI__VI           = 0x00C9;
constexpr unsigned int mmVGA_MEMORY_BASE_ADDRESS__SI__VI                = 0x00C4;
constexpr unsigned int mmVGA_MEM_READ_PAGE_ADDR__SI__VI                 = 0x0013;
constexpr unsigned int mmVGA_MEM_WRITE_PAGE_ADDR__SI__VI                = 0x0012;
constexpr unsigned int mmVGA_MODE_CONTROL__SI__VI                       = 0x00C2;
constexpr unsigned int mmVGA_RENDER_CONTROL__SI__VI                     = 0x00C0;
constexpr unsigned int mmVGA_SEQUENCER_RESET_CONTROL__SI__VI            = 0x00C1;
constexpr unsigned int mmVGA_SOURCE_SELECT__SI__VI                      = 0x00FC;
constexpr unsigned int mmVGA_STATUS_CLEAR__SI__VI                       = 0x00D2;
constexpr unsigned int mmVGA_STATUS__SI__VI                             = 0x00D0;
constexpr unsigned int mmVGA_SURFACE_PITCH_SELECT__SI__VI               = 0x00C3;
constexpr unsigned int mmVGA_TEST_CONTROL__SI__VI                       = 0x00D5;
constexpr unsigned int mmVGA_TEST_DEBUG_DATA__SI__VI                    = 0x00C7;
constexpr unsigned int mmVGA_TEST_DEBUG_INDEX__SI__VI                   = 0x00C5;
constexpr unsigned int mmVGT_CACHE_INVALIDATION                         = 0x2231;
constexpr unsigned int mmVGT_CNTL_STATUS                                = 0x223C;
constexpr unsigned int mmVGT_DEBUG_CNTL                                 = 0x2238;
constexpr unsigned int mmVGT_DEBUG_DATA                                 = 0x2239;
constexpr unsigned int mmVGT_DMA_BASE                                   = 0xA1FA;
constexpr unsigned int mmVGT_DMA_BASE_HI                                = 0xA1F9;
constexpr unsigned int mmVGT_DMA_CONTROL__CI__VI                        = 0x2272;
constexpr unsigned int mmVGT_DMA_DATA_FIFO_DEPTH                        = 0x222D;
constexpr unsigned int mmVGT_DMA_INDEX_TYPE                             = 0xA29F;
constexpr unsigned int mmVGT_DMA_LS_HS_CONFIG__CI__VI                   = 0x2273;
constexpr unsigned int mmVGT_DMA_MAX_SIZE                               = 0xA29E;
constexpr unsigned int mmVGT_DMA_NUM_INSTANCES                          = 0xA2A2;
constexpr unsigned int mmVGT_DMA_PRIMITIVE_TYPE__CI__VI                 = 0x2271;
constexpr unsigned int mmVGT_DMA_REQ_FIFO_DEPTH                         = 0x222E;
constexpr unsigned int mmVGT_DMA_SIZE                                   = 0xA29D;
constexpr unsigned int mmVGT_DRAW_INITIATOR                             = 0xA1FC;
constexpr unsigned int mmVGT_DRAW_INIT_FIFO_DEPTH                       = 0x222F;
constexpr unsigned int mmVGT_ENHANCE                                    = 0xA294;
constexpr unsigned int mmVGT_ESGS_RING_ITEMSIZE                         = 0xA2AB;
constexpr unsigned int mmVGT_ESGS_RING_SIZE__CI__VI                     = 0xC240;
constexpr unsigned int mmVGT_ESGS_RING_SIZE__SI                         = 0x2232;
constexpr unsigned int mmVGT_ES_PER_GS                                  = 0xA296;
constexpr unsigned int mmVGT_EVENT_ADDRESS_REG                          = 0xA1FE;
constexpr unsigned int mmVGT_EVENT_INITIATOR                            = 0xA2A4;
constexpr unsigned int mmVGT_FIFO_DEPTHS                                = 0x2234;
constexpr unsigned int mmVGT_GROUP_DECR                                 = 0xA28B;
constexpr unsigned int mmVGT_GROUP_FIRST_DECR                           = 0xA28A;
constexpr unsigned int mmVGT_GROUP_PRIM_TYPE                            = 0xA289;
constexpr unsigned int mmVGT_GROUP_VECT_0_CNTL                          = 0xA28C;
constexpr unsigned int mmVGT_GROUP_VECT_0_FMT_CNTL                      = 0xA28E;
constexpr unsigned int mmVGT_GROUP_VECT_1_CNTL                          = 0xA28D;
constexpr unsigned int mmVGT_GROUP_VECT_1_FMT_CNTL                      = 0xA28F;
constexpr unsigned int mmVGT_GSVS_RING_ITEMSIZE                         = 0xA2AC;
constexpr unsigned int mmVGT_GSVS_RING_OFFSET_1                         = 0xA298;
constexpr unsigned int mmVGT_GSVS_RING_OFFSET_2                         = 0xA299;
constexpr unsigned int mmVGT_GSVS_RING_OFFSET_3                         = 0xA29A;
constexpr unsigned int mmVGT_GSVS_RING_SIZE__CI__VI                     = 0xC241;
constexpr unsigned int mmVGT_GSVS_RING_SIZE__SI                         = 0x2233;
constexpr unsigned int mmVGT_GS_INSTANCE_CNT                            = 0xA2E4;
constexpr unsigned int mmVGT_GS_MAX_VERT_OUT                            = 0xA2CE;
constexpr unsigned int mmVGT_GS_MODE                                    = 0xA290;
constexpr unsigned int mmVGT_GS_ONCHIP_CNTL__CI__VI                     = 0xA291;
constexpr unsigned int mmVGT_GS_OUT_PRIM_TYPE                           = 0xA29B;
constexpr unsigned int mmVGT_GS_PER_ES                                  = 0xA295;
constexpr unsigned int mmVGT_GS_PER_VS                                  = 0xA297;
constexpr unsigned int mmVGT_GS_VERTEX_REUSE                            = 0x2235;
constexpr unsigned int mmVGT_GS_VERT_ITEMSIZE                           = 0xA2D7;
constexpr unsigned int mmVGT_GS_VERT_ITEMSIZE_1                         = 0xA2D8;
constexpr unsigned int mmVGT_GS_VERT_ITEMSIZE_2                         = 0xA2D9;
constexpr unsigned int mmVGT_GS_VERT_ITEMSIZE_3                         = 0xA2DA;
constexpr unsigned int mmVGT_HOS_CNTL                                   = 0xA285;
constexpr unsigned int mmVGT_HOS_MAX_TESS_LEVEL                         = 0xA286;
constexpr unsigned int mmVGT_HOS_MIN_TESS_LEVEL                         = 0xA287;
constexpr unsigned int mmVGT_HOS_REUSE_DEPTH                            = 0xA288;
constexpr unsigned int mmVGT_HS_OFFCHIP_PARAM__CI__VI                   = 0xC24F;
constexpr unsigned int mmVGT_HS_OFFCHIP_PARAM__SI                       = 0x226C;
constexpr unsigned int mmVGT_IMMED_DATA                                 = 0xA1FD;
constexpr unsigned int mmVGT_INDEX_TYPE__CI__VI                         = 0xC243;
constexpr unsigned int mmVGT_INDEX_TYPE__SI                             = 0x2257;
constexpr unsigned int mmVGT_INDX_OFFSET                                = 0xA102;
constexpr unsigned int mmVGT_INSTANCE_STEP_RATE_0                       = 0xA2A8;
constexpr unsigned int mmVGT_INSTANCE_STEP_RATE_1                       = 0xA2A9;
constexpr unsigned int mmVGT_LAST_COPY_STATE                            = 0x2230;
constexpr unsigned int mmVGT_LS_HS_CONFIG                               = 0xA2D6;
constexpr unsigned int mmVGT_MAX_VTX_INDX                               = 0xA100;
constexpr unsigned int mmVGT_MC_LAT_CNTL                                = 0x2236;
constexpr unsigned int mmVGT_MIN_VTX_INDX                               = 0xA101;
constexpr unsigned int mmVGT_MULTI_PRIM_IB_RESET_EN                     = 0xA2A5;
constexpr unsigned int mmVGT_MULTI_PRIM_IB_RESET_INDX                   = 0xA103;
constexpr unsigned int mmVGT_NUM_INDICES__CI__VI                        = 0xC24C;
constexpr unsigned int mmVGT_NUM_INDICES__SI                            = 0x225C;
constexpr unsigned int mmVGT_NUM_INSTANCES__CI__VI                      = 0xC24D;
constexpr unsigned int mmVGT_NUM_INSTANCES__SI                          = 0x225D;
constexpr unsigned int mmVGT_OUTPUT_PATH_CNTL                           = 0xA284;
constexpr unsigned int mmVGT_OUT_DEALLOC_CNTL                           = 0xA317;
constexpr unsigned int mmVGT_PERFCOUNTER0_HI__CI__VI                    = 0xD091;
constexpr unsigned int mmVGT_PERFCOUNTER0_HI__SI                        = 0x224D;
constexpr unsigned int mmVGT_PERFCOUNTER0_LO__CI__VI                    = 0xD090;
constexpr unsigned int mmVGT_PERFCOUNTER0_LO__SI                        = 0x224C;
constexpr unsigned int mmVGT_PERFCOUNTER0_SELECT1__CI__VI               = 0xD890;
constexpr unsigned int mmVGT_PERFCOUNTER0_SELECT__CI__VI                = 0xD88C;
constexpr unsigned int mmVGT_PERFCOUNTER0_SELECT__SI                    = 0x2248;
constexpr unsigned int mmVGT_PERFCOUNTER1_HI__CI__VI                    = 0xD093;
constexpr unsigned int mmVGT_PERFCOUNTER1_HI__SI                        = 0x224F;
constexpr unsigned int mmVGT_PERFCOUNTER1_LO__CI__VI                    = 0xD092;
constexpr unsigned int mmVGT_PERFCOUNTER1_LO__SI                        = 0x224E;
constexpr unsigned int mmVGT_PERFCOUNTER1_SELECT1__CI__VI               = 0xD891;
constexpr unsigned int mmVGT_PERFCOUNTER1_SELECT__CI__VI                = 0xD88D;
constexpr unsigned int mmVGT_PERFCOUNTER1_SELECT__SI                    = 0x2249;
constexpr unsigned int mmVGT_PERFCOUNTER2_HI__CI__VI                    = 0xD095;
constexpr unsigned int mmVGT_PERFCOUNTER2_HI__SI                        = 0x2251;
constexpr unsigned int mmVGT_PERFCOUNTER2_LO__CI__VI                    = 0xD094;
constexpr unsigned int mmVGT_PERFCOUNTER2_LO__SI                        = 0x2250;
constexpr unsigned int mmVGT_PERFCOUNTER2_SELECT__CI__VI                = 0xD88E;
constexpr unsigned int mmVGT_PERFCOUNTER2_SELECT__SI                    = 0x224A;
constexpr unsigned int mmVGT_PERFCOUNTER3_HI__CI__VI                    = 0xD097;
constexpr unsigned int mmVGT_PERFCOUNTER3_HI__SI                        = 0x2253;
constexpr unsigned int mmVGT_PERFCOUNTER3_LO__CI__VI                    = 0xD096;
constexpr unsigned int mmVGT_PERFCOUNTER3_LO__SI                        = 0x2252;
constexpr unsigned int mmVGT_PERFCOUNTER3_SELECT__CI__VI                = 0xD88F;
constexpr unsigned int mmVGT_PERFCOUNTER3_SELECT__SI                    = 0x224B;
constexpr unsigned int mmVGT_PERFCOUNTER_SEID_MASK__CI__VI              = 0xD894;
constexpr unsigned int mmVGT_PERFCOUNTER_SEID_MASK__SI                  = 0x2247;
constexpr unsigned int mmVGT_PRIMITIVEID_EN                             = 0xA2A1;
constexpr unsigned int mmVGT_PRIMITIVEID_RESET                          = 0xA2A3;
constexpr unsigned int mmVGT_PRIMITIVE_TYPE__CI__VI                     = 0xC242;
constexpr unsigned int mmVGT_PRIMITIVE_TYPE__SI                         = 0x2256;
constexpr unsigned int mmVGT_RESET_DEBUG__CI__VI                        = 0x2232;
constexpr unsigned int mmVGT_REUSE_OFF                                  = 0xA2AD;
constexpr unsigned int mmVGT_SHADER_STAGES_EN                           = 0xA2D5;
constexpr unsigned int mmVGT_STRMOUT_BUFFER_CONFIG                      = 0xA2E6;
constexpr unsigned int mmVGT_STRMOUT_BUFFER_FILLED_SIZE_0__CI__VI       = 0xC244;
constexpr unsigned int mmVGT_STRMOUT_BUFFER_FILLED_SIZE_0__SI           = 0x2258;
constexpr unsigned int mmVGT_STRMOUT_BUFFER_FILLED_SIZE_1__CI__VI       = 0xC245;
constexpr unsigned int mmVGT_STRMOUT_BUFFER_FILLED_SIZE_1__SI           = 0x2259;
constexpr unsigned int mmVGT_STRMOUT_BUFFER_FILLED_SIZE_2__CI__VI       = 0xC246;
constexpr unsigned int mmVGT_STRMOUT_BUFFER_FILLED_SIZE_2__SI           = 0x225A;
constexpr unsigned int mmVGT_STRMOUT_BUFFER_FILLED_SIZE_3__CI__VI       = 0xC247;
constexpr unsigned int mmVGT_STRMOUT_BUFFER_FILLED_SIZE_3__SI           = 0x225B;
constexpr unsigned int mmVGT_STRMOUT_BUFFER_OFFSET_0                    = 0xA2B7;
constexpr unsigned int mmVGT_STRMOUT_BUFFER_OFFSET_1                    = 0xA2BB;
constexpr unsigned int mmVGT_STRMOUT_BUFFER_OFFSET_2                    = 0xA2BF;
constexpr unsigned int mmVGT_STRMOUT_BUFFER_OFFSET_3                    = 0xA2C3;
constexpr unsigned int mmVGT_STRMOUT_BUFFER_SIZE_0                      = 0xA2B4;
constexpr unsigned int mmVGT_STRMOUT_BUFFER_SIZE_1                      = 0xA2B8;
constexpr unsigned int mmVGT_STRMOUT_BUFFER_SIZE_2                      = 0xA2BC;
constexpr unsigned int mmVGT_STRMOUT_BUFFER_SIZE_3                      = 0xA2C0;
constexpr unsigned int mmVGT_STRMOUT_CONFIG                             = 0xA2E5;
constexpr unsigned int mmVGT_STRMOUT_DELAY__CI__VI                      = 0x2233;
constexpr unsigned int mmVGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE     = 0xA2CB;
constexpr unsigned int mmVGT_STRMOUT_DRAW_OPAQUE_OFFSET                 = 0xA2CA;
constexpr unsigned int mmVGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE          = 0xA2CC;
constexpr unsigned int mmVGT_STRMOUT_VTX_STRIDE_0                       = 0xA2B5;
constexpr unsigned int mmVGT_STRMOUT_VTX_STRIDE_1                       = 0xA2B9;
constexpr unsigned int mmVGT_STRMOUT_VTX_STRIDE_2                       = 0xA2BD;
constexpr unsigned int mmVGT_STRMOUT_VTX_STRIDE_3                       = 0xA2C1;
constexpr unsigned int mmVGT_SYS_CONFIG                                 = 0x2263;
constexpr unsigned int mmVGT_TF_MEMORY_BASE__CI__VI                     = 0xC250;
constexpr unsigned int mmVGT_TF_MEMORY_BASE__SI                         = 0x226E;
constexpr unsigned int mmVGT_TF_PARAM                                   = 0xA2DB;
constexpr unsigned int mmVGT_TF_RING_SIZE__CI__VI                       = 0xC24E;
constexpr unsigned int mmVGT_TF_RING_SIZE__SI                           = 0x2262;
constexpr unsigned int mmVGT_VERTEX_REUSE_BLOCK_CNTL                    = 0xA316;
constexpr unsigned int mmVGT_VS_MAX_WAVE_ID__CI__VI                     = 0x2268;
constexpr unsigned int mmVGT_VTX_CNT_EN                                 = 0xA2AE;
constexpr unsigned int mmVGT_VTX_VECT_EJECT_REG                         = 0x222C;
constexpr unsigned int mmVIEWPORT_SIZE__SI__VI                          = 0x1B5D;
constexpr unsigned int mmVIEWPORT_START__SI__VI                         = 0x1B5C;
constexpr unsigned int mmVLINE_STATUS__SI                               = 0x1AEE;
constexpr unsigned int mmVM_CONTEXT0_CNTL                               = 0x0504;
constexpr unsigned int mmVM_CONTEXT0_CNTL2                              = 0x050C;
constexpr unsigned int mmVM_CONTEXT0_PAGE_TABLE_BASE_ADDR               = 0x054F;
constexpr unsigned int mmVM_CONTEXT0_PAGE_TABLE_END_ADDR                = 0x055F;
constexpr unsigned int mmVM_CONTEXT0_PAGE_TABLE_START_ADDR              = 0x0557;
constexpr unsigned int mmVM_CONTEXT0_PROTECTION_FAULT_ADDR              = 0x053E;
constexpr unsigned int mmVM_CONTEXT0_PROTECTION_FAULT_DEFAULT_ADDR      = 0x0546;
constexpr unsigned int mmVM_CONTEXT0_PROTECTION_FAULT_MCCLIENT__CI__VI  = 0x0538;
constexpr unsigned int mmVM_CONTEXT0_PROTECTION_FAULT_STATUS            = 0x0536;
constexpr unsigned int mmVM_CONTEXT10_PAGE_TABLE_BASE_ADDR              = 0x0510;
constexpr unsigned int mmVM_CONTEXT11_PAGE_TABLE_BASE_ADDR              = 0x0511;
constexpr unsigned int mmVM_CONTEXT12_PAGE_TABLE_BASE_ADDR              = 0x0512;
constexpr unsigned int mmVM_CONTEXT13_PAGE_TABLE_BASE_ADDR              = 0x0513;
constexpr unsigned int mmVM_CONTEXT14_PAGE_TABLE_BASE_ADDR              = 0x0514;
constexpr unsigned int mmVM_CONTEXT15_PAGE_TABLE_BASE_ADDR              = 0x0515;
constexpr unsigned int mmVM_CONTEXT1_CNTL                               = 0x0505;
constexpr unsigned int mmVM_CONTEXT1_CNTL2                              = 0x050D;
constexpr unsigned int mmVM_CONTEXT1_PAGE_TABLE_BASE_ADDR               = 0x0550;
constexpr unsigned int mmVM_CONTEXT1_PAGE_TABLE_END_ADDR                = 0x0560;
constexpr unsigned int mmVM_CONTEXT1_PAGE_TABLE_START_ADDR              = 0x0558;
constexpr unsigned int mmVM_CONTEXT1_PROTECTION_FAULT_ADDR              = 0x053F;
constexpr unsigned int mmVM_CONTEXT1_PROTECTION_FAULT_DEFAULT_ADDR      = 0x0547;
constexpr unsigned int mmVM_CONTEXT1_PROTECTION_FAULT_MCCLIENT__CI__VI  = 0x0539;
constexpr unsigned int mmVM_CONTEXT1_PROTECTION_FAULT_STATUS            = 0x0537;
constexpr unsigned int mmVM_CONTEXT2_PAGE_TABLE_BASE_ADDR               = 0x0551;
constexpr unsigned int mmVM_CONTEXT3_PAGE_TABLE_BASE_ADDR               = 0x0552;
constexpr unsigned int mmVM_CONTEXT4_PAGE_TABLE_BASE_ADDR               = 0x0553;
constexpr unsigned int mmVM_CONTEXT5_PAGE_TABLE_BASE_ADDR               = 0x0554;
constexpr unsigned int mmVM_CONTEXT6_PAGE_TABLE_BASE_ADDR               = 0x0555;
constexpr unsigned int mmVM_CONTEXT7_PAGE_TABLE_BASE_ADDR               = 0x0556;
constexpr unsigned int mmVM_CONTEXT8_PAGE_TABLE_BASE_ADDR               = 0x050E;
constexpr unsigned int mmVM_CONTEXT9_PAGE_TABLE_BASE_ADDR               = 0x050F;
constexpr unsigned int mmVM_CONTEXTS_DISABLE                            = 0x0535;
constexpr unsigned int mmVM_DEBUG                                       = 0x056F;
constexpr unsigned int mmVM_DUMMY_PAGE_FAULT_ADDR                       = 0x0507;
constexpr unsigned int mmVM_DUMMY_PAGE_FAULT_CNTL                       = 0x0506;
constexpr unsigned int mmVM_FAULT_CLIENT_ID                             = 0x054E;
constexpr unsigned int mmVM_INVALIDATE_REQUEST                          = 0x051E;
constexpr unsigned int mmVM_INVALIDATE_RESPONSE                         = 0x051F;
constexpr unsigned int mmVM_L2_BANK_SELECT_MASKA                        = 0x0572;
constexpr unsigned int mmVM_L2_BANK_SELECT_MASKB                        = 0x0573;
constexpr unsigned int mmVM_L2_CG                                       = 0x0570;
constexpr unsigned int mmVM_L2_CNTL                                     = 0x0500;
constexpr unsigned int mmVM_L2_CNTL2                                    = 0x0501;
constexpr unsigned int mmVM_L2_CNTL3                                    = 0x0502;
constexpr unsigned int mmVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR     = 0x0576;
constexpr unsigned int mmVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR      = 0x0575;
constexpr unsigned int mmVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET         = 0x0577;
constexpr unsigned int mmVM_L2_STATUS                                   = 0x0503;
constexpr unsigned int mmVM_PRT_APERTURE0_HIGH_ADDR                     = 0x0530;
constexpr unsigned int mmVM_PRT_APERTURE0_LOW_ADDR                      = 0x052C;
constexpr unsigned int mmVM_PRT_APERTURE1_HIGH_ADDR                     = 0x0531;
constexpr unsigned int mmVM_PRT_APERTURE1_LOW_ADDR                      = 0x052D;
constexpr unsigned int mmVM_PRT_APERTURE2_HIGH_ADDR                     = 0x0532;
constexpr unsigned int mmVM_PRT_APERTURE2_LOW_ADDR                      = 0x052E;
constexpr unsigned int mmVM_PRT_APERTURE3_HIGH_ADDR                     = 0x0533;
constexpr unsigned int mmVM_PRT_APERTURE3_LOW_ADDR                      = 0x052F;
constexpr unsigned int mmVM_PRT_CNTL                                    = 0x0534;
constexpr unsigned int mmWD_CNTL_STATUS__CI__VI                         = 0x223F;
constexpr unsigned int mmWD_DEBUG_CNTL__CI__VI                          = 0x223D;
constexpr unsigned int mmWD_DEBUG_DATA__CI__VI                          = 0x223E;
constexpr unsigned int mmWD_ENHANCE__CI__VI                             = 0xA2A0;
constexpr unsigned int mmWD_PERFCOUNTER0_HI__CI__VI                     = 0xD081;
constexpr unsigned int mmWD_PERFCOUNTER0_LO__CI__VI                     = 0xD080;
constexpr unsigned int mmWD_PERFCOUNTER0_SELECT__CI__VI                 = 0xD880;
constexpr unsigned int mmWD_PERFCOUNTER1_HI__CI__VI                     = 0xD083;
constexpr unsigned int mmWD_PERFCOUNTER1_LO__CI__VI                     = 0xD082;
constexpr unsigned int mmWD_PERFCOUNTER1_SELECT__CI__VI                 = 0xD881;
constexpr unsigned int mmWD_PERFCOUNTER2_HI__CI__VI                     = 0xD085;
constexpr unsigned int mmWD_PERFCOUNTER2_LO__CI__VI                     = 0xD084;
constexpr unsigned int mmWD_PERFCOUNTER2_SELECT__CI__VI                 = 0xD882;
constexpr unsigned int mmWD_PERFCOUNTER3_HI__CI__VI                     = 0xD087;
constexpr unsigned int mmWD_PERFCOUNTER3_LO__CI__VI                     = 0xD086;
constexpr unsigned int mmWD_PERFCOUNTER3_SELECT__CI__VI                 = 0xD883;
constexpr unsigned int mmXDMA_SLV_FLIP_PENDING__CI__VI                  = 0x046C;
constexpr unsigned int mmXDMA_SLV_FLIP_PENDING__SI                      = 0x0407;
constexpr unsigned int pciADAPTER_ID                                    = 0x000B;
constexpr unsigned int pciADAPTER_ID_W                                  = 0x0013;
constexpr unsigned int pciBASE_ADDR_1                                   = 0x0004;
constexpr unsigned int pciBASE_ADDR_2                                   = 0x0005;
constexpr unsigned int pciBASE_ADDR_3                                   = 0x0006;
constexpr unsigned int pciBASE_ADDR_4                                   = 0x0007;
constexpr unsigned int pciBASE_ADDR_5                                   = 0x0008;
constexpr unsigned int pciBASE_ADDR_6                                   = 0x0009;
constexpr unsigned int pciBASE_CLASS                                    = 0x0002;
constexpr unsigned int pciBIST                                          = 0x0003;
constexpr unsigned int pciCACHE_LINE                                    = 0x0003;
constexpr unsigned int pciCAP_PTR                                       = 0x000D;
constexpr unsigned int pciCOMMAND                                       = 0x0001;
constexpr unsigned int pciDEVICE_CAP                                    = 0x0017;
constexpr unsigned int pciDEVICE_CAP2                                   = 0x001F;
constexpr unsigned int pciDEVICE_CNTL                                   = 0x0018;
constexpr unsigned int pciDEVICE_CNTL2                                  = 0x0020;
constexpr unsigned int pciDEVICE_ID                                     = 0x0000;
constexpr unsigned int pciDEVICE_STATUS                                 = 0x0018;
constexpr unsigned int pciDEVICE_STATUS2                                = 0x0020;
constexpr unsigned int pciHEADER                                        = 0x0003;
constexpr unsigned int pciINTERRUPT_LINE                                = 0x000F;
constexpr unsigned int pciINTERRUPT_PIN                                 = 0x000F;
constexpr unsigned int pciLATENCY                                       = 0x0003;
constexpr unsigned int pciLINK_CAP                                      = 0x0019;
constexpr unsigned int pciLINK_CAP2                                     = 0x0021;
constexpr unsigned int pciLINK_CNTL                                     = 0x001A;
constexpr unsigned int pciLINK_CNTL2                                    = 0x0022;
constexpr unsigned int pciLINK_STATUS                                   = 0x001A;
constexpr unsigned int pciLINK_STATUS2                                  = 0x0022;
constexpr unsigned int pciMAX_LATENCY                                   = 0x000F;
constexpr unsigned int pciMIN_GRANT                                     = 0x000F;
constexpr unsigned int pciMSI_CAP_LIST                                  = 0x0028;
constexpr unsigned int pciMSI_MSG_ADDR_HI                               = 0x002A;
constexpr unsigned int pciMSI_MSG_ADDR_LO                               = 0x0029;
constexpr unsigned int pciMSI_MSG_CNTL                                  = 0x0028;
constexpr unsigned int pciMSI_MSG_DATA                                  = 0x002A;
constexpr unsigned int pciMSI_MSG_DATA_64                               = 0x002B;
constexpr unsigned int pciPCIE_ACS_CAP__CI__VI                          = 0x00A9;
constexpr unsigned int pciPCIE_ACS_CNTL__CI__VI                         = 0x00A9;
constexpr unsigned int pciPCIE_ACS_ENH_CAP_LIST__CI__VI                 = 0x00A8;
constexpr unsigned int pciPCIE_ADV_ERR_CAP_CNTL                         = 0x005A;
constexpr unsigned int pciPCIE_ADV_ERR_RPT_ENH_CAP_LIST                 = 0x0054;
constexpr unsigned int pciPCIE_ATS_CAP__CI__VI                          = 0x00AD;
constexpr unsigned int pciPCIE_ATS_CNTL__CI__VI                         = 0x00AD;
constexpr unsigned int pciPCIE_ATS_ENH_CAP_LIST__CI__VI                 = 0x00AC;
constexpr unsigned int pciPCIE_BAR1_CAP__CI__VI                         = 0x0081;
constexpr unsigned int pciPCIE_BAR1_CNTL__CI__VI                        = 0x0082;
constexpr unsigned int pciPCIE_BAR2_CAP__CI__VI                         = 0x0083;
constexpr unsigned int pciPCIE_BAR2_CNTL__CI__VI                        = 0x0084;
constexpr unsigned int pciPCIE_BAR3_CAP__CI__VI                         = 0x0085;
constexpr unsigned int pciPCIE_BAR3_CNTL__CI__VI                        = 0x0086;
constexpr unsigned int pciPCIE_BAR4_CAP__CI__VI                         = 0x0087;
constexpr unsigned int pciPCIE_BAR4_CNTL__CI__VI                        = 0x0088;
constexpr unsigned int pciPCIE_BAR5_CAP__CI__VI                         = 0x0089;
constexpr unsigned int pciPCIE_BAR5_CNTL__CI__VI                        = 0x008A;
constexpr unsigned int pciPCIE_BAR6_CAP__CI__VI                         = 0x008B;
constexpr unsigned int pciPCIE_BAR6_CNTL__CI__VI                        = 0x008C;
constexpr unsigned int pciPCIE_BAR_ENH_CAP_LIST__CI__VI                 = 0x0080;
constexpr unsigned int pciPCIE_CAP                                      = 0x0016;
constexpr unsigned int pciPCIE_CAP_LIST                                 = 0x0016;
constexpr unsigned int pciPCIE_CORR_ERR_MASK                            = 0x0059;
constexpr unsigned int pciPCIE_CORR_ERR_STATUS                          = 0x0058;
constexpr unsigned int pciPCIE_DEV_SERIAL_NUM_DW1                       = 0x0051;
constexpr unsigned int pciPCIE_DEV_SERIAL_NUM_DW2                       = 0x0052;
constexpr unsigned int pciPCIE_DEV_SERIAL_NUM_ENH_CAP_LIST              = 0x0050;
constexpr unsigned int pciPCIE_DPA_CAP__CI__VI                          = 0x0095;
constexpr unsigned int pciPCIE_DPA_CNTL__CI__VI                         = 0x0097;
constexpr unsigned int pciPCIE_DPA_ENH_CAP_LIST__CI__VI                 = 0x0094;
constexpr unsigned int pciPCIE_DPA_LATENCY_INDICATOR__CI__VI            = 0x0096;
constexpr unsigned int pciPCIE_DPA_STATUS__CI__VI                       = 0x0097;
constexpr unsigned int pciPCIE_DPA_SUBSTATE_PWR_ALLOC_0__CI__VI         = 0x0098;
constexpr unsigned int pciPCIE_DPA_SUBSTATE_PWR_ALLOC_1__CI__VI         = 0x0098;
constexpr unsigned int pciPCIE_DPA_SUBSTATE_PWR_ALLOC_2__CI__VI         = 0x0098;
constexpr unsigned int pciPCIE_DPA_SUBSTATE_PWR_ALLOC_3__CI__VI         = 0x0098;
constexpr unsigned int pciPCIE_DPA_SUBSTATE_PWR_ALLOC_4__CI__VI         = 0x0099;
constexpr unsigned int pciPCIE_DPA_SUBSTATE_PWR_ALLOC_5__CI__VI         = 0x0099;
constexpr unsigned int pciPCIE_DPA_SUBSTATE_PWR_ALLOC_6__CI__VI         = 0x0099;
constexpr unsigned int pciPCIE_DPA_SUBSTATE_PWR_ALLOC_7__CI__VI         = 0x0099;
constexpr unsigned int pciPCIE_HDR_LOG0                                 = 0x005B;
constexpr unsigned int pciPCIE_HDR_LOG1                                 = 0x005C;
constexpr unsigned int pciPCIE_HDR_LOG2                                 = 0x005D;
constexpr unsigned int pciPCIE_HDR_LOG3                                 = 0x005E;
constexpr unsigned int pciPCIE_LANE_0_EQUALIZATION_CNTL__CI__VI         = 0x009F;
constexpr unsigned int pciPCIE_LANE_10_EQUALIZATION_CNTL__CI__VI        = 0x00A4;
constexpr unsigned int pciPCIE_LANE_11_EQUALIZATION_CNTL__CI__VI        = 0x00A4;
constexpr unsigned int pciPCIE_LANE_12_EQUALIZATION_CNTL__CI__VI        = 0x00A5;
constexpr unsigned int pciPCIE_LANE_13_EQUALIZATION_CNTL__CI__VI        = 0x00A5;
constexpr unsigned int pciPCIE_LANE_14_EQUALIZATION_CNTL__CI__VI        = 0x00A6;
constexpr unsigned int pciPCIE_LANE_15_EQUALIZATION_CNTL__CI__VI        = 0x00A6;
constexpr unsigned int pciPCIE_LANE_1_EQUALIZATION_CNTL__CI__VI         = 0x009F;
constexpr unsigned int pciPCIE_LANE_2_EQUALIZATION_CNTL__CI__VI         = 0x00A0;
constexpr unsigned int pciPCIE_LANE_3_EQUALIZATION_CNTL__CI__VI         = 0x00A0;
constexpr unsigned int pciPCIE_LANE_4_EQUALIZATION_CNTL__CI__VI         = 0x00A1;
constexpr unsigned int pciPCIE_LANE_5_EQUALIZATION_CNTL__CI__VI         = 0x00A1;
constexpr unsigned int pciPCIE_LANE_6_EQUALIZATION_CNTL__CI__VI         = 0x00A2;
constexpr unsigned int pciPCIE_LANE_7_EQUALIZATION_CNTL__CI__VI         = 0x00A2;
constexpr unsigned int pciPCIE_LANE_8_EQUALIZATION_CNTL__CI__VI         = 0x00A3;
constexpr unsigned int pciPCIE_LANE_9_EQUALIZATION_CNTL__CI__VI         = 0x00A3;
constexpr unsigned int pciPCIE_LANE_ERROR_STATUS__CI__VI                = 0x009E;
constexpr unsigned int pciPCIE_LINK_CNTL3__CI__VI                       = 0x009D;
constexpr unsigned int pciPCIE_OUTSTAND_PAGE_REQ_ALLOC__CI__VI          = 0x00B3;
constexpr unsigned int pciPCIE_OUTSTAND_PAGE_REQ_CAPACITY__CI__VI       = 0x00B2;
constexpr unsigned int pciPCIE_PAGE_REQ_CNTL__CI__VI                    = 0x00B1;
constexpr unsigned int pciPCIE_PAGE_REQ_ENH_CAP_LIST__CI__VI            = 0x00B0;
constexpr unsigned int pciPCIE_PAGE_REQ_STATUS__CI__VI                  = 0x00B1;
constexpr unsigned int pciPCIE_PASID_CAP__CI__VI                        = 0x00B5;
constexpr unsigned int pciPCIE_PASID_CNTL__CI__VI                       = 0x00B5;
constexpr unsigned int pciPCIE_PASID_ENH_CAP_LIST__CI__VI               = 0x00B4;
constexpr unsigned int pciPCIE_PORT_VC_CAP_REG1                         = 0x0045;
constexpr unsigned int pciPCIE_PORT_VC_CAP_REG2                         = 0x0046;
constexpr unsigned int pciPCIE_PORT_VC_CNTL                             = 0x0047;
constexpr unsigned int pciPCIE_PORT_VC_STATUS                           = 0x0047;
constexpr unsigned int pciPCIE_PWR_BUDGET_CAP__CI__VI                   = 0x0093;
constexpr unsigned int pciPCIE_PWR_BUDGET_DATA_SELECT__CI__VI           = 0x0091;
constexpr unsigned int pciPCIE_PWR_BUDGET_DATA__CI__VI                  = 0x0092;
constexpr unsigned int pciPCIE_PWR_BUDGET_ENH_CAP_LIST__CI__VI          = 0x0090;
constexpr unsigned int pciPCIE_SECONDARY_ENH_CAP_LIST__CI__VI           = 0x009C;
constexpr unsigned int pciPCIE_TLP_PREFIX_LOG0__CI__VI                  = 0x0062;
constexpr unsigned int pciPCIE_TLP_PREFIX_LOG1__CI__VI                  = 0x0063;
constexpr unsigned int pciPCIE_TLP_PREFIX_LOG2__CI__VI                  = 0x0064;
constexpr unsigned int pciPCIE_TLP_PREFIX_LOG3__CI__VI                  = 0x0065;
constexpr unsigned int pciPCIE_UNCORR_ERR_MASK                          = 0x0056;
constexpr unsigned int pciPCIE_UNCORR_ERR_SEVERITY                      = 0x0057;
constexpr unsigned int pciPCIE_UNCORR_ERR_STATUS                        = 0x0055;
constexpr unsigned int pciPCIE_VC0_RESOURCE_CAP                         = 0x0048;
constexpr unsigned int pciPCIE_VC0_RESOURCE_CNTL                        = 0x0049;
constexpr unsigned int pciPCIE_VC0_RESOURCE_STATUS                      = 0x004A;
constexpr unsigned int pciPCIE_VC1_RESOURCE_CAP                         = 0x004B;
constexpr unsigned int pciPCIE_VC1_RESOURCE_CNTL                        = 0x004C;
constexpr unsigned int pciPCIE_VC1_RESOURCE_STATUS                      = 0x004D;
constexpr unsigned int pciPCIE_VC_ENH_CAP_LIST                          = 0x0044;
constexpr unsigned int pciPCIE_VENDOR_SPECIFIC1                         = 0x0042;
constexpr unsigned int pciPCIE_VENDOR_SPECIFIC2                         = 0x0043;
constexpr unsigned int pciPCIE_VENDOR_SPECIFIC_ENH_CAP_LIST             = 0x0040;
constexpr unsigned int pciPCIE_VENDOR_SPECIFIC_HDR                      = 0x0041;
constexpr unsigned int pciPMI_CAP                                       = 0x0014;
constexpr unsigned int pciPMI_CAP_LIST                                  = 0x0014;
constexpr unsigned int pciPMI_STATUS_CNTL                               = 0x0015;
constexpr unsigned int pciPROG_INTERFACE                                = 0x0002;
constexpr unsigned int pciREVISION_ID                                   = 0x0002;
constexpr unsigned int pciROM_BASE_ADDR                                 = 0x000C;
constexpr unsigned int pciSTATUS                                        = 0x0001;
constexpr unsigned int pciSUB_CLASS                                     = 0x0002;
constexpr unsigned int pciVENDOR_CAP_LIST__CI__VI                       = 0x0012;
constexpr unsigned int pciVENDOR_ID                                     = 0x0000;

//Merged Defines

constexpr unsigned int cfgMSI_MASK__VI                                  = 0x002B;
constexpr unsigned int cfgMSI_MASK_64__VI                               = 0x002C;
constexpr unsigned int cfgMSI_PENDING__VI                               = 0x002C;
constexpr unsigned int cfgMSI_PENDING_64__VI                            = 0x002D;
constexpr unsigned int cfgPCIE_ARI_CAP__VI                              = 0x00CB;
constexpr unsigned int cfgPCIE_ARI_CNTL__VI                             = 0x00CB;
constexpr unsigned int cfgPCIE_ARI_ENH_CAP_LIST__VI                     = 0x00CA;
constexpr unsigned int cfgPCIE_LTR_CAP__VI                              = 0x00C9;
constexpr unsigned int cfgPCIE_LTR_ENH_CAP_LIST__VI                     = 0x00C8;
constexpr unsigned int cfgPCIE_MC_ADDR0__VI                             = 0x00BE;
constexpr unsigned int cfgPCIE_MC_ADDR1__VI                             = 0x00BF;
constexpr unsigned int cfgPCIE_MC_BLOCK_ALL0__VI                        = 0x00C2;
constexpr unsigned int cfgPCIE_MC_BLOCK_ALL1__VI                        = 0x00C3;
constexpr unsigned int cfgPCIE_MC_BLOCK_UNTRANSLATED_0__VI              = 0x00C4;
constexpr unsigned int cfgPCIE_MC_BLOCK_UNTRANSLATED_1__VI              = 0x00C5;
constexpr unsigned int cfgPCIE_MC_CAP__VI                               = 0x00BD;
constexpr unsigned int cfgPCIE_MC_CNTL__VI                              = 0x00BD;
constexpr unsigned int cfgPCIE_MC_ENH_CAP_LIST__VI                      = 0x00BC;
constexpr unsigned int cfgPCIE_MC_RCV0__VI                              = 0x00C0;
constexpr unsigned int cfgPCIE_MC_RCV1__VI                              = 0x00C1;
constexpr unsigned int cfgPCIE_SRIOV_CAP__VI                            = 0x00CD;
constexpr unsigned int cfgPCIE_SRIOV_CONTROL__VI                        = 0x00CE;
constexpr unsigned int cfgPCIE_SRIOV_ENH_CAP_LIST__VI                   = 0x00CC;
constexpr unsigned int cfgPCIE_SRIOV_FIRST_VF_OFFSET__VI                = 0x00D1;
constexpr unsigned int cfgPCIE_SRIOV_FUNC_DEP_LINK__VI                  = 0x00D0;
constexpr unsigned int cfgPCIE_SRIOV_INITIAL_VFS__VI                    = 0x00CF;
constexpr unsigned int cfgPCIE_SRIOV_NUM_VFS__VI                        = 0x00D0;
constexpr unsigned int cfgPCIE_SRIOV_STATUS__VI                         = 0x00CE;
constexpr unsigned int cfgPCIE_SRIOV_SUPPORTED_PAGE_SIZE__VI            = 0x00D3;
constexpr unsigned int cfgPCIE_SRIOV_SYSTEM_PAGE_SIZE__VI               = 0x00D4;
constexpr unsigned int cfgPCIE_SRIOV_TOTAL_VFS__VI                      = 0x00CF;
constexpr unsigned int cfgPCIE_SRIOV_VF_BASE_ADDR_0__VI                 = 0x00D5;
constexpr unsigned int cfgPCIE_SRIOV_VF_BASE_ADDR_1__VI                 = 0x00D6;
constexpr unsigned int cfgPCIE_SRIOV_VF_BASE_ADDR_2__VI                 = 0x00D7;
constexpr unsigned int cfgPCIE_SRIOV_VF_BASE_ADDR_3__VI                 = 0x00D8;
constexpr unsigned int cfgPCIE_SRIOV_VF_BASE_ADDR_4__VI                 = 0x00D9;
constexpr unsigned int cfgPCIE_SRIOV_VF_BASE_ADDR_5__VI                 = 0x00DA;
constexpr unsigned int cfgPCIE_SRIOV_VF_DEVICE_ID__VI                   = 0x00D2;
constexpr unsigned int cfgPCIE_SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET__VI  = 0x00DB;
constexpr unsigned int cfgPCIE_SRIOV_VF_STRIDE__VI                      = 0x00D1;
constexpr unsigned int cfgPCIE_TPH_REQR_CAP__VI                         = 0x00B9;
constexpr unsigned int cfgPCIE_TPH_REQR_CNTL__VI                        = 0x00BA;
constexpr unsigned int cfgPCIE_TPH_REQR_ENH_CAP_LIST__VI                = 0x00B8;
constexpr unsigned int cfgPCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__VI  = 0x0100;
constexpr unsigned int cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV__VI           = 0x0101;
constexpr unsigned int cfgPCIE_VENDOR_SPECIFIC_HDR_GPUIOV_RESET_CONTROL__VI  = 0x0105;
constexpr unsigned int mmAFMT_60958_0__VI                               = 0x4A38;
constexpr unsigned int mmAFMT_60958_1__VI                               = 0x4A39;
constexpr unsigned int mmAFMT_60958_2__VI                               = 0x4A3F;
constexpr unsigned int mmAFMT_AUDIO_CRC_CONTROL__VI                     = 0x4A3A;
constexpr unsigned int mmAFMT_AUDIO_CRC_RESULT__VI                      = 0x4A40;
constexpr unsigned int mmAFMT_AUDIO_DBG_DTO_CNTL__VI                    = 0x4A46;
constexpr unsigned int mmAFMT_AUDIO_INFO0__VI                           = 0x4A36;
constexpr unsigned int mmAFMT_AUDIO_INFO1__VI                           = 0x4A37;
constexpr unsigned int mmAFMT_AUDIO_PACKET_CONTROL__VI                  = 0x4A42;
constexpr unsigned int mmAFMT_AUDIO_PACKET_CONTROL2__VI                 = 0x4A14;
constexpr unsigned int mmAFMT_AUDIO_SRC_CONTROL__VI                     = 0x4A45;
constexpr unsigned int mmAFMT_AVI_INFO0__VI                             = 0x4A1E;
constexpr unsigned int mmAFMT_AVI_INFO1__VI                             = 0x4A1F;
constexpr unsigned int mmAFMT_AVI_INFO2__VI                             = 0x4A20;
constexpr unsigned int mmAFMT_AVI_INFO3__VI                             = 0x4A21;
constexpr unsigned int mmAFMT_GENERIC_0__VI                             = 0x4A25;
constexpr unsigned int mmAFMT_GENERIC_1__VI                             = 0x4A26;
constexpr unsigned int mmAFMT_GENERIC_2__VI                             = 0x4A27;
constexpr unsigned int mmAFMT_GENERIC_3__VI                             = 0x4A28;
constexpr unsigned int mmAFMT_GENERIC_4__VI                             = 0x4A29;
constexpr unsigned int mmAFMT_GENERIC_5__VI                             = 0x4A2A;
constexpr unsigned int mmAFMT_GENERIC_6__VI                             = 0x4A2B;
constexpr unsigned int mmAFMT_GENERIC_7__VI                             = 0x4A2C;
constexpr unsigned int mmAFMT_GENERIC_HDR__VI                           = 0x4A24;
constexpr unsigned int mmAFMT_INFOFRAME_CONTROL0__VI                    = 0x4A44;
constexpr unsigned int mmAFMT_ISRC1_0__VI                               = 0x4A15;
constexpr unsigned int mmAFMT_ISRC1_1__VI                               = 0x4A16;
constexpr unsigned int mmAFMT_ISRC1_2__VI                               = 0x4A17;
constexpr unsigned int mmAFMT_ISRC1_3__VI                               = 0x4A18;
constexpr unsigned int mmAFMT_ISRC1_4__VI                               = 0x4A19;
constexpr unsigned int mmAFMT_ISRC2_0__VI                               = 0x4A1A;
constexpr unsigned int mmAFMT_ISRC2_1__VI                               = 0x4A1B;
constexpr unsigned int mmAFMT_ISRC2_2__VI                               = 0x4A1C;
constexpr unsigned int mmAFMT_ISRC2_3__VI                               = 0x4A1D;
constexpr unsigned int mmAFMT_MPEG_INFO0__VI                            = 0x4A22;
constexpr unsigned int mmAFMT_MPEG_INFO1__VI                            = 0x4A23;
constexpr unsigned int mmAFMT_RAMP_CONTROL0__VI                         = 0x4A3B;
constexpr unsigned int mmAFMT_RAMP_CONTROL1__VI                         = 0x4A3C;
constexpr unsigned int mmAFMT_RAMP_CONTROL2__VI                         = 0x4A3D;
constexpr unsigned int mmAFMT_RAMP_CONTROL3__VI                         = 0x4A3E;
constexpr unsigned int mmAFMT_STATUS__VI                                = 0x4A41;
constexpr unsigned int mmAFMT_VBI_PACKET_CONTROL__VI                    = 0x4A43;
constexpr unsigned int mmALPHA_CONTROL__VI                              = 0x1ABC;
constexpr unsigned int mmATC_ATS_FAULT_STATUS_INFO2__VI                 = 0x0CD2;
constexpr unsigned int mmATC_ATS_SMU_STATUS__VI                         = 0x0D08;
constexpr unsigned int mmATC_ATS_VMID_STATUS__VI                        = 0x0D07;
constexpr unsigned int mmATC_L1RD_DEBUG2_TLB__VI                        = 0x0CE2;
constexpr unsigned int mmATC_L1WR_DEBUG2_TLB__VI                        = 0x0CE3;
constexpr unsigned int mmATC_L2_CACHE_DATA0__VI                         = 0x0CD9;
constexpr unsigned int mmATC_L2_CACHE_DATA1__VI                         = 0x0CDA;
constexpr unsigned int mmATC_L2_CACHE_DATA2__VI                         = 0x0CDB;
constexpr unsigned int mmATC_L2_CNTL3__VI                               = 0x0D08;
constexpr unsigned int mmATC_L2_STATUS__VI                              = 0x0D09;
constexpr unsigned int mmATC_L2_STATUS2__VI                             = 0x0D0A;
constexpr unsigned int mmAUXN_IMPCAL__VI                                = 0x483C;
constexpr unsigned int mmAUXP_IMPCAL__VI                                = 0x483B;
constexpr unsigned int mmAUX_ARB_CONTROL__VI                            = 0x5C02;
constexpr unsigned int mmAUX_CONTROL__VI                                = 0x5C00;
constexpr unsigned int mmAUX_DPHY_RX_CONTROL0__VI                       = 0x5C0A;
constexpr unsigned int mmAUX_DPHY_RX_CONTROL1__VI                       = 0x5C0B;
constexpr unsigned int mmAUX_DPHY_RX_STATUS__VI                         = 0x5C0D;
constexpr unsigned int mmAUX_DPHY_TX_CONTROL__VI                        = 0x5C09;
constexpr unsigned int mmAUX_DPHY_TX_REF_CONTROL__VI                    = 0x5C08;
constexpr unsigned int mmAUX_DPHY_TX_STATUS__VI                         = 0x5C0C;
constexpr unsigned int mmAUX_GTC_SYNC_CONTROL__VI                       = 0x5C0E;
constexpr unsigned int mmAUX_GTC_SYNC_CONTROLLER_STATUS__VI             = 0x5C10;
constexpr unsigned int mmAUX_GTC_SYNC_DATA__VI                          = 0x5C12;
constexpr unsigned int mmAUX_GTC_SYNC_ERROR_CONTROL__VI                 = 0x5C0F;
constexpr unsigned int mmAUX_GTC_SYNC_PHASE_OFFSET_OVERRIDE__VI         = 0x5C13;
constexpr unsigned int mmAUX_GTC_SYNC_STATUS__VI                        = 0x5C11;
constexpr unsigned int mmAUX_INTERRUPT_CONTROL__VI                      = 0x5C03;
constexpr unsigned int mmAUX_LS_DATA__VI                                = 0x5C07;
constexpr unsigned int mmAUX_LS_STATUS__VI                              = 0x5C05;
constexpr unsigned int mmAUX_SW_CONTROL__VI                             = 0x5C01;
constexpr unsigned int mmAUX_SW_DATA__VI                                = 0x5C06;
constexpr unsigned int mmAUX_SW_STATUS__VI                              = 0x5C04;
constexpr unsigned int mmAUX_TEST_DEBUG_DATA__VI                        = 0x5C15;
constexpr unsigned int mmAUX_TEST_DEBUG_INDEX__VI                       = 0x5C14;
constexpr unsigned int mmAVSYNC_COUNTER_CONTROL__VI                     = 0x012B;
constexpr unsigned int mmAVSYNC_COUNTER_READ__VI                        = 0x012F;
constexpr unsigned int mmAVSYNC_COUNTER_WRITE__VI                       = 0x012A;
constexpr unsigned int mmAZALIA_APPLICATION_POSITION_IN_CYCLIC_BUFFER__VI  = 0x17F3;
constexpr unsigned int mmAZALIA_AUDIO_DTO__VI                           = 0x17E5;
constexpr unsigned int mmAZALIA_AUDIO_DTO_CONTROL__VI                   = 0x17E6;
constexpr unsigned int mmAZALIA_BDL_DMA_CONTROL__VI                     = 0x17EA;
constexpr unsigned int mmAZALIA_CONTROLLER_CLOCK_GATING__VI             = 0x17E4;
constexpr unsigned int mmAZALIA_CONTROLLER_DEBUG__VI                    = 0x17F9;
constexpr unsigned int mmAZALIA_CORB_DMA_CONTROL__VI                    = 0x17EC;
constexpr unsigned int mmAZALIA_CRC0_CONTROL0__VI                       = 0x1805;
constexpr unsigned int mmAZALIA_CRC0_CONTROL1__VI                       = 0x1806;
constexpr unsigned int mmAZALIA_CRC0_CONTROL2__VI                       = 0x1807;
constexpr unsigned int mmAZALIA_CRC0_CONTROL3__VI                       = 0x1808;
constexpr unsigned int mmAZALIA_CRC0_RESULT__VI                         = 0x1809;
constexpr unsigned int mmAZALIA_CRC1_CONTROL0__VI                       = 0x180A;
constexpr unsigned int mmAZALIA_CRC1_CONTROL1__VI                       = 0x180B;
constexpr unsigned int mmAZALIA_CRC1_CONTROL2__VI                       = 0x180C;
constexpr unsigned int mmAZALIA_CRC1_CONTROL3__VI                       = 0x180D;
constexpr unsigned int mmAZALIA_CRC1_RESULT__VI                         = 0x180E;
constexpr unsigned int mmAZALIA_CYCLIC_BUFFER_SYNC__VI                  = 0x17F4;
constexpr unsigned int mmAZALIA_DATA_DMA_CONTROL__VI                    = 0x17E9;
constexpr unsigned int mmAZALIA_F0_CODEC_CHANNEL_COUNT_CONTROL__VI      = 0x182A;
constexpr unsigned int mmAZALIA_F0_CODEC_DEBUG__VI                      = 0x1836;
constexpr unsigned int mmAZALIA_F0_CODEC_ENDPOINT_DATA__VI              = 0x17A9;
constexpr unsigned int mmAZALIA_F0_CODEC_ENDPOINT_INDEX__VI             = 0x17A8;
constexpr unsigned int mmAZALIA_F0_CODEC_FUNCTION_CONTROL_CONVERTER_SYNCHRONIZATION__VI  = 0x1833;
constexpr unsigned int mmAZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE__VI  = 0x1830;
constexpr unsigned int mmAZALIA_F0_CODEC_FUNCTION_CONTROL_RESET__VI     = 0x1831;
constexpr unsigned int mmAZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID__VI  = 0x1832;
constexpr unsigned int mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_GROUP_TYPE__VI  = 0x182C;
constexpr unsigned int mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES__VI  = 0x182F;
constexpr unsigned int mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS__VI  = 0x182E;
constexpr unsigned int mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES__VI  = 0x182D;
constexpr unsigned int mmAZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__VI        = 0x59D5;
constexpr unsigned int mmAZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__VI       = 0x59D4;
constexpr unsigned int mmAZALIA_F0_CODEC_RESYNC_FIFO_CONTROL__VI        = 0x182B;
constexpr unsigned int mmAZALIA_F0_CODEC_ROOT_PARAMETER_REVISION_ID__VI  = 0x1829;
constexpr unsigned int mmAZALIA_F0_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID__VI  = 0x1828;
constexpr unsigned int mmAZALIA_F0_GTC_GROUP_OFFSET0__VI                = 0x1837;
constexpr unsigned int mmAZALIA_F0_GTC_GROUP_OFFSET1__VI                = 0x1838;
constexpr unsigned int mmAZALIA_F0_GTC_GROUP_OFFSET2__VI                = 0x1839;
constexpr unsigned int mmAZALIA_F0_GTC_GROUP_OFFSET3__VI                = 0x183A;
constexpr unsigned int mmAZALIA_F0_GTC_GROUP_OFFSET4__VI                = 0x183B;
constexpr unsigned int mmAZALIA_F0_GTC_GROUP_OFFSET5__VI                = 0x183C;
constexpr unsigned int mmAZALIA_F0_GTC_GROUP_OFFSET6__VI                = 0x183D;
constexpr unsigned int mmAZALIA_GLOBAL_CAPABILITIES__VI                 = 0x17F5;
constexpr unsigned int mmAZALIA_INPUT_CRC0_CONTROL0__VI                 = 0x17FB;
constexpr unsigned int mmAZALIA_INPUT_CRC0_CONTROL1__VI                 = 0x17FC;
constexpr unsigned int mmAZALIA_INPUT_CRC0_CONTROL2__VI                 = 0x17FD;
constexpr unsigned int mmAZALIA_INPUT_CRC0_CONTROL3__VI                 = 0x17FE;
constexpr unsigned int mmAZALIA_INPUT_CRC0_RESULT__VI                   = 0x17FF;
constexpr unsigned int mmAZALIA_INPUT_CRC1_CONTROL0__VI                 = 0x1800;
constexpr unsigned int mmAZALIA_INPUT_CRC1_CONTROL1__VI                 = 0x1801;
constexpr unsigned int mmAZALIA_INPUT_CRC1_CONTROL2__VI                 = 0x1802;
constexpr unsigned int mmAZALIA_INPUT_CRC1_CONTROL3__VI                 = 0x1803;
constexpr unsigned int mmAZALIA_INPUT_CRC1_RESULT__VI                   = 0x1804;
constexpr unsigned int mmAZALIA_INPUT_PAYLOAD_CAPABILITY__VI            = 0x17F8;
constexpr unsigned int mmAZALIA_MEM_PWR_CTRL__VI                        = 0x1810;
constexpr unsigned int mmAZALIA_MEM_PWR_STATUS__VI                      = 0x1811;
constexpr unsigned int mmAZALIA_OUTPUT_PAYLOAD_CAPABILITY__VI           = 0x17F6;
constexpr unsigned int mmAZALIA_OUTPUT_STREAM_ARBITER_CONTROL__VI       = 0x17F7;
constexpr unsigned int mmAZALIA_RIRB_AND_DP_CONTROL__VI                 = 0x17EB;
constexpr unsigned int mmAZALIA_SCLK_CONTROL__VI                        = 0x17E7;
constexpr unsigned int mmAZALIA_STREAM_DATA__VI                         = 0x1781;
constexpr unsigned int mmAZALIA_STREAM_INDEX__VI                        = 0x1780;
constexpr unsigned int mmAZALIA_UNDERFLOW_FILLER_SAMPLE__VI             = 0x17E8;
constexpr unsigned int mmAZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_DATA__VI  = 0x17A9;
constexpr unsigned int mmAZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_INDEX__VI  = 0x17A8;
constexpr unsigned int mmAZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_DATA__VI  = 0x17AD;
constexpr unsigned int mmAZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_INDEX__VI  = 0x17AC;
constexpr unsigned int mmAZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_DATA__VI  = 0x17B1;
constexpr unsigned int mmAZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_INDEX__VI  = 0x17B0;
constexpr unsigned int mmAZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_DATA__VI  = 0x17B5;
constexpr unsigned int mmAZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_INDEX__VI  = 0x17B4;
constexpr unsigned int mmAZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_DATA__VI  = 0x17B9;
constexpr unsigned int mmAZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_INDEX__VI  = 0x17B8;
constexpr unsigned int mmAZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_DATA__VI  = 0x17BD;
constexpr unsigned int mmAZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_INDEX__VI  = 0x17BC;
constexpr unsigned int mmAZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_DATA__VI  = 0x17C1;
constexpr unsigned int mmAZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_INDEX__VI  = 0x17C0;
constexpr unsigned int mmAZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_DATA__VI  = 0x17C5;
constexpr unsigned int mmAZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_INDEX__VI  = 0x17C4;
constexpr unsigned int mmAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__VI  = 0x59D5;
constexpr unsigned int mmAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__VI  = 0x59D4;
constexpr unsigned int mmAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__VI  = 0x59D9;
constexpr unsigned int mmAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__VI  = 0x59D8;
constexpr unsigned int mmAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__VI  = 0x59DD;
constexpr unsigned int mmAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__VI  = 0x59DC;
constexpr unsigned int mmAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__VI  = 0x59E1;
constexpr unsigned int mmAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__VI  = 0x59E0;
constexpr unsigned int mmAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__VI  = 0x59E5;
constexpr unsigned int mmAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__VI  = 0x59E4;
constexpr unsigned int mmAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__VI  = 0x59E9;
constexpr unsigned int mmAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__VI  = 0x59E8;
constexpr unsigned int mmAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__VI  = 0x59ED;
constexpr unsigned int mmAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__VI  = 0x59EC;
constexpr unsigned int mmAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__VI  = 0x59F1;
constexpr unsigned int mmAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__VI  = 0x59F0;
constexpr unsigned int mmAZF0STREAM0_AZALIA_STREAM_DATA__VI             = 0x1781;
constexpr unsigned int mmAZF0STREAM0_AZALIA_STREAM_INDEX__VI            = 0x1780;
constexpr unsigned int mmAZF0STREAM10_AZALIA_STREAM_DATA__VI            = 0x59C5;
constexpr unsigned int mmAZF0STREAM10_AZALIA_STREAM_INDEX__VI           = 0x59C4;
constexpr unsigned int mmAZF0STREAM11_AZALIA_STREAM_DATA__VI            = 0x59C7;
constexpr unsigned int mmAZF0STREAM11_AZALIA_STREAM_INDEX__VI           = 0x59C6;
constexpr unsigned int mmAZF0STREAM12_AZALIA_STREAM_DATA__VI            = 0x59C9;
constexpr unsigned int mmAZF0STREAM12_AZALIA_STREAM_INDEX__VI           = 0x59C8;
constexpr unsigned int mmAZF0STREAM13_AZALIA_STREAM_DATA__VI            = 0x59CB;
constexpr unsigned int mmAZF0STREAM13_AZALIA_STREAM_INDEX__VI           = 0x59CA;
constexpr unsigned int mmAZF0STREAM14_AZALIA_STREAM_DATA__VI            = 0x59CD;
constexpr unsigned int mmAZF0STREAM14_AZALIA_STREAM_INDEX__VI           = 0x59CC;
constexpr unsigned int mmAZF0STREAM15_AZALIA_STREAM_DATA__VI            = 0x59CF;
constexpr unsigned int mmAZF0STREAM15_AZALIA_STREAM_INDEX__VI           = 0x59CE;
constexpr unsigned int mmAZF0STREAM1_AZALIA_STREAM_DATA__VI             = 0x1783;
constexpr unsigned int mmAZF0STREAM1_AZALIA_STREAM_INDEX__VI            = 0x1782;
constexpr unsigned int mmAZF0STREAM2_AZALIA_STREAM_DATA__VI             = 0x1785;
constexpr unsigned int mmAZF0STREAM2_AZALIA_STREAM_INDEX__VI            = 0x1784;
constexpr unsigned int mmAZF0STREAM3_AZALIA_STREAM_DATA__VI             = 0x1787;
constexpr unsigned int mmAZF0STREAM3_AZALIA_STREAM_INDEX__VI            = 0x1786;
constexpr unsigned int mmAZF0STREAM4_AZALIA_STREAM_DATA__VI             = 0x1789;
constexpr unsigned int mmAZF0STREAM4_AZALIA_STREAM_INDEX__VI            = 0x1788;
constexpr unsigned int mmAZF0STREAM5_AZALIA_STREAM_DATA__VI             = 0x178B;
constexpr unsigned int mmAZF0STREAM5_AZALIA_STREAM_INDEX__VI            = 0x178A;
constexpr unsigned int mmAZF0STREAM6_AZALIA_STREAM_DATA__VI             = 0x178D;
constexpr unsigned int mmAZF0STREAM6_AZALIA_STREAM_INDEX__VI            = 0x178C;
constexpr unsigned int mmAZF0STREAM7_AZALIA_STREAM_DATA__VI             = 0x178F;
constexpr unsigned int mmAZF0STREAM7_AZALIA_STREAM_INDEX__VI            = 0x178E;
constexpr unsigned int mmAZF0STREAM8_AZALIA_STREAM_DATA__VI             = 0x59C1;
constexpr unsigned int mmAZF0STREAM8_AZALIA_STREAM_INDEX__VI            = 0x59C0;
constexpr unsigned int mmAZF0STREAM9_AZALIA_STREAM_DATA__VI             = 0x59C3;
constexpr unsigned int mmAZF0STREAM9_AZALIA_STREAM_INDEX__VI            = 0x59C2;
constexpr unsigned int mmAZ_TEST_DEBUG_DATA__VI                         = 0x1820;
constexpr unsigned int mmAZ_TEST_DEBUG_INDEX__VI                        = 0x181F;
constexpr unsigned int mmBF_ANA_ISO_CNTL__VI                            = 0x14C7;
constexpr unsigned int mmBIF_ATOMIC_ERR_LOG__VI                         = 0x1512;
constexpr unsigned int mmBIF_BME_STATUS__VI                             = 0x1511;
constexpr unsigned int mmBIF_CLK_CTRL__VI                               = 0x14C5;
constexpr unsigned int mmBIF_DOORBELL_APER_EN__VI                       = 0x1501;
constexpr unsigned int mmBIF_DOORBELL_GBLAPER1_LOWER__VI                = 0x14FC;
constexpr unsigned int mmBIF_DOORBELL_GBLAPER1_UPPER__VI                = 0x14FD;
constexpr unsigned int mmBIF_DOORBELL_GBLAPER2_LOWER__VI                = 0x14FE;
constexpr unsigned int mmBIF_DOORBELL_GBLAPER2_UPPER__VI                = 0x14FF;
constexpr unsigned int mmBIF_GPUIOV_FB_TOTAL_FB_INFO__VI                = 0x14D8;
constexpr unsigned int mmBIF_GPUIOV_RESET_NOTIFICATION__VI              = 0x14D5;
constexpr unsigned int mmBIF_GPUIOV_VM_INIT_STATUS__VI                  = 0x14D6;
constexpr unsigned int mmBIF_IOV_FUNC_IDENTIFIER__VI                    = 0x1503;
constexpr unsigned int mmBIF_MM_INDACCESS_CNTL__VI                      = 0x1500;
constexpr unsigned int mmBIF_MST_TRANS_PENDING__VI                      = 0x14EA;
constexpr unsigned int mmBIF_RB_BASE__VI                                = 0x1531;
constexpr unsigned int mmBIF_RB_CNTL__VI                                = 0x1530;
constexpr unsigned int mmBIF_RB_RPTR__VI                                = 0x1532;
constexpr unsigned int mmBIF_RB_WPTR__VI                                = 0x1533;
constexpr unsigned int mmBIF_RB_WPTR_ADDR_HI__VI                        = 0x1534;
constexpr unsigned int mmBIF_RB_WPTR_ADDR_LO__VI                        = 0x1535;
constexpr unsigned int mmBIF_RFE_MST_BX_CMDSTATUS__VI                   = 0x1449;
constexpr unsigned int mmBIF_RFE_MST_SMBUS_CMDSTATUS__VI                = 0x1448;
constexpr unsigned int mmBIF_RFE_WARMRST_CNTL__VI                       = 0x1459;
constexpr unsigned int mmBIF_RLC_INTR_CNTL__VI                          = 0x1510;
constexpr unsigned int mmBIF_SLV_TRANS_PENDING__VI                      = 0x14E9;
constexpr unsigned int mmBIF_SMU_DATA__VI                               = 0x143E;
constexpr unsigned int mmBIF_SMU_INDEX__VI                              = 0x143D;
constexpr unsigned int mmBIF_VDDGFX_FB_CMP__VI                          = 0x143C;
constexpr unsigned int mmBIF_VDDGFX_GFX0_LOWER__VI                      = 0x1428;
constexpr unsigned int mmBIF_VDDGFX_GFX0_UPPER__VI                      = 0x1429;
constexpr unsigned int mmBIF_VDDGFX_GFX1_LOWER__VI                      = 0x142A;
constexpr unsigned int mmBIF_VDDGFX_GFX1_UPPER__VI                      = 0x142B;
constexpr unsigned int mmBIF_VDDGFX_GFX2_LOWER__VI                      = 0x142C;
constexpr unsigned int mmBIF_VDDGFX_GFX2_UPPER__VI                      = 0x142D;
constexpr unsigned int mmBIF_VDDGFX_GFX3_LOWER__VI                      = 0x142E;
constexpr unsigned int mmBIF_VDDGFX_GFX3_UPPER__VI                      = 0x142F;
constexpr unsigned int mmBIF_VDDGFX_GFX4_LOWER__VI                      = 0x1430;
constexpr unsigned int mmBIF_VDDGFX_GFX4_UPPER__VI                      = 0x1431;
constexpr unsigned int mmBIF_VDDGFX_GFX5_LOWER__VI                      = 0x1432;
constexpr unsigned int mmBIF_VDDGFX_GFX5_UPPER__VI                      = 0x1433;
constexpr unsigned int mmBIF_VDDGFX_RSV1_LOWER__VI                      = 0x1434;
constexpr unsigned int mmBIF_VDDGFX_RSV1_UPPER__VI                      = 0x1435;
constexpr unsigned int mmBIF_VDDGFX_RSV2_LOWER__VI                      = 0x1436;
constexpr unsigned int mmBIF_VDDGFX_RSV2_UPPER__VI                      = 0x1437;
constexpr unsigned int mmBIF_VDDGFX_RSV3_LOWER__VI                      = 0x1438;
constexpr unsigned int mmBIF_VDDGFX_RSV3_UPPER__VI                      = 0x1439;
constexpr unsigned int mmBIF_VDDGFX_RSV4_LOWER__VI                      = 0x143A;
constexpr unsigned int mmBIF_VDDGFX_RSV4_UPPER__VI                      = 0x143B;
constexpr unsigned int mmBIF_VIRT_RESET_REQ__VI                         = 0x14D2;
constexpr unsigned int mmBLND0_BLND_CONTROL__VI                         = 0x1B6D;
constexpr unsigned int mmBLND0_BLND_CONTROL2__VI                        = 0x1B6F;
constexpr unsigned int mmBLND0_BLND_DEBUG__VI                           = 0x1B74;
constexpr unsigned int mmBLND0_BLND_REG_UPDATE_STATUS__VI               = 0x1B77;
constexpr unsigned int mmBLND0_BLND_TEST_DEBUG_DATA__VI                 = 0x1B76;
constexpr unsigned int mmBLND0_BLND_TEST_DEBUG_INDEX__VI                = 0x1B75;
constexpr unsigned int mmBLND0_BLND_UNDERFLOW_INTERRUPT__VI             = 0x1B71;
constexpr unsigned int mmBLND0_BLND_UPDATE__VI                          = 0x1B70;
constexpr unsigned int mmBLND0_BLND_V_UPDATE_LOCK__VI                   = 0x1B73;
constexpr unsigned int mmBLND0_SM_CONTROL2__VI                          = 0x1B6E;
constexpr unsigned int mmBLND1_BLND_CONTROL__VI                         = 0x1D6D;
constexpr unsigned int mmBLND1_BLND_CONTROL2__VI                        = 0x1D6F;
constexpr unsigned int mmBLND1_BLND_DEBUG__VI                           = 0x1D74;
constexpr unsigned int mmBLND1_BLND_REG_UPDATE_STATUS__VI               = 0x1D77;
constexpr unsigned int mmBLND1_BLND_TEST_DEBUG_DATA__VI                 = 0x1D76;
constexpr unsigned int mmBLND1_BLND_TEST_DEBUG_INDEX__VI                = 0x1D75;
constexpr unsigned int mmBLND1_BLND_UNDERFLOW_INTERRUPT__VI             = 0x1D71;
constexpr unsigned int mmBLND1_BLND_UPDATE__VI                          = 0x1D70;
constexpr unsigned int mmBLND1_BLND_V_UPDATE_LOCK__VI                   = 0x1D73;
constexpr unsigned int mmBLND1_SM_CONTROL2__VI                          = 0x1D6E;
constexpr unsigned int mmBLND2_BLND_CONTROL__VI                         = 0x1F6D;
constexpr unsigned int mmBLND2_BLND_CONTROL2__VI                        = 0x1F6F;
constexpr unsigned int mmBLND2_BLND_DEBUG__VI                           = 0x1F74;
constexpr unsigned int mmBLND2_BLND_REG_UPDATE_STATUS__VI               = 0x1F77;
constexpr unsigned int mmBLND2_BLND_TEST_DEBUG_DATA__VI                 = 0x1F76;
constexpr unsigned int mmBLND2_BLND_TEST_DEBUG_INDEX__VI                = 0x1F75;
constexpr unsigned int mmBLND2_BLND_UNDERFLOW_INTERRUPT__VI             = 0x1F71;
constexpr unsigned int mmBLND2_BLND_UPDATE__VI                          = 0x1F70;
constexpr unsigned int mmBLND2_BLND_V_UPDATE_LOCK__VI                   = 0x1F73;
constexpr unsigned int mmBLND2_SM_CONTROL2__VI                          = 0x1F6E;
constexpr unsigned int mmBLND3_BLND_CONTROL__VI                         = 0x416D;
constexpr unsigned int mmBLND3_BLND_CONTROL2__VI                        = 0x416F;
constexpr unsigned int mmBLND3_BLND_DEBUG__VI                           = 0x4174;
constexpr unsigned int mmBLND3_BLND_REG_UPDATE_STATUS__VI               = 0x4177;
constexpr unsigned int mmBLND3_BLND_TEST_DEBUG_DATA__VI                 = 0x4176;
constexpr unsigned int mmBLND3_BLND_TEST_DEBUG_INDEX__VI                = 0x4175;
constexpr unsigned int mmBLND3_BLND_UNDERFLOW_INTERRUPT__VI             = 0x4171;
constexpr unsigned int mmBLND3_BLND_UPDATE__VI                          = 0x4170;
constexpr unsigned int mmBLND3_BLND_V_UPDATE_LOCK__VI                   = 0x4173;
constexpr unsigned int mmBLND3_SM_CONTROL2__VI                          = 0x416E;
constexpr unsigned int mmBLND4_BLND_CONTROL__VI                         = 0x436D;
constexpr unsigned int mmBLND4_BLND_CONTROL2__VI                        = 0x436F;
constexpr unsigned int mmBLND4_BLND_DEBUG__VI                           = 0x4374;
constexpr unsigned int mmBLND4_BLND_REG_UPDATE_STATUS__VI               = 0x4377;
constexpr unsigned int mmBLND4_BLND_TEST_DEBUG_DATA__VI                 = 0x4376;
constexpr unsigned int mmBLND4_BLND_TEST_DEBUG_INDEX__VI                = 0x4375;
constexpr unsigned int mmBLND4_BLND_UNDERFLOW_INTERRUPT__VI             = 0x4371;
constexpr unsigned int mmBLND4_BLND_UPDATE__VI                          = 0x4370;
constexpr unsigned int mmBLND4_BLND_V_UPDATE_LOCK__VI                   = 0x4373;
constexpr unsigned int mmBLND4_SM_CONTROL2__VI                          = 0x436E;
constexpr unsigned int mmBLND5_BLND_CONTROL__VI                         = 0x456D;
constexpr unsigned int mmBLND5_BLND_CONTROL2__VI                        = 0x456F;
constexpr unsigned int mmBLND5_BLND_DEBUG__VI                           = 0x4574;
constexpr unsigned int mmBLND5_BLND_REG_UPDATE_STATUS__VI               = 0x4577;
constexpr unsigned int mmBLND5_BLND_TEST_DEBUG_DATA__VI                 = 0x4576;
constexpr unsigned int mmBLND5_BLND_TEST_DEBUG_INDEX__VI                = 0x4575;
constexpr unsigned int mmBLND5_BLND_UNDERFLOW_INTERRUPT__VI             = 0x4571;
constexpr unsigned int mmBLND5_BLND_UPDATE__VI                          = 0x4570;
constexpr unsigned int mmBLND5_BLND_V_UPDATE_LOCK__VI                   = 0x4573;
constexpr unsigned int mmBLND5_SM_CONTROL2__VI                          = 0x456E;
constexpr unsigned int mmBLND6_BLND_CONTROL__VI                         = 0x476D;
constexpr unsigned int mmBLND6_BLND_CONTROL2__VI                        = 0x476F;
constexpr unsigned int mmBLND6_BLND_DEBUG__VI                           = 0x4774;
constexpr unsigned int mmBLND6_BLND_REG_UPDATE_STATUS__VI               = 0x4777;
constexpr unsigned int mmBLND6_BLND_TEST_DEBUG_DATA__VI                 = 0x4776;
constexpr unsigned int mmBLND6_BLND_TEST_DEBUG_INDEX__VI                = 0x4775;
constexpr unsigned int mmBLND6_BLND_UNDERFLOW_INTERRUPT__VI             = 0x4771;
constexpr unsigned int mmBLND6_BLND_UPDATE__VI                          = 0x4770;
constexpr unsigned int mmBLND6_BLND_V_UPDATE_LOCK__VI                   = 0x4773;
constexpr unsigned int mmBLND6_SM_CONTROL2__VI                          = 0x476E;
constexpr unsigned int mmBLND_CONTROL__VI                               = 0x1B6D;
constexpr unsigned int mmBLND_CONTROL2__VI                              = 0x1B6F;
constexpr unsigned int mmBLND_DEBUG__VI                                 = 0x1B74;
constexpr unsigned int mmBLND_REG_UPDATE_STATUS__VI                     = 0x1B77;
constexpr unsigned int mmBLND_TEST_DEBUG_DATA__VI                       = 0x1B76;
constexpr unsigned int mmBLND_TEST_DEBUG_INDEX__VI                      = 0x1B75;
constexpr unsigned int mmBLND_UNDERFLOW_INTERRUPT__VI                   = 0x1B71;
constexpr unsigned int mmBLND_UPDATE__VI                                = 0x1B70;
constexpr unsigned int mmBLND_V_UPDATE_LOCK__VI                         = 0x1B73;
constexpr unsigned int mmBL_PWM_CNTL__VI                                = 0x4820;
constexpr unsigned int mmBL_PWM_CNTL2__VI                               = 0x4821;
constexpr unsigned int mmBL_PWM_GRP1_REG_LOCK__VI                       = 0x4823;
constexpr unsigned int mmBL_PWM_PERIOD_CNTL__VI                         = 0x4822;
constexpr unsigned int mmBPHYC_DAC_AUTO_CALIB_CONTROL__VI               = 0x48BA;
constexpr unsigned int mmBPHYC_DAC_MACRO_CNTL__VI                       = 0x48B9;
constexpr unsigned int mmBPHYC_PLL0_DISPPLL_BG_CNTL__VI                 = 0x171E;
constexpr unsigned int mmBPHYC_PLL0_PLL_ANALOG__VI                      = 0x1708;
constexpr unsigned int mmBPHYC_PLL0_PLL_ANALOG_CNTL__VI                 = 0x1711;
constexpr unsigned int mmBPHYC_PLL0_PLL_CNTL__VI                        = 0x1707;
constexpr unsigned int mmBPHYC_PLL0_PLL_DEBUG_CNTL__VI                  = 0x170B;
constexpr unsigned int mmBPHYC_PLL0_PLL_DS_CNTL__VI                     = 0x1705;
constexpr unsigned int mmBPHYC_PLL0_PLL_FB_DIV__VI                      = 0x1701;
constexpr unsigned int mmBPHYC_PLL0_PLL_IDCLK_CNTL__VI                  = 0x1706;
constexpr unsigned int mmBPHYC_PLL0_PLL_POST_DIV__VI                    = 0x1702;
constexpr unsigned int mmBPHYC_PLL0_PLL_REF_DIV__VI                     = 0x1700;
constexpr unsigned int mmBPHYC_PLL0_PLL_SS_AMOUNT_DSFRAC__VI            = 0x1703;
constexpr unsigned int mmBPHYC_PLL0_PLL_SS_CNTL__VI                     = 0x1704;
constexpr unsigned int mmBPHYC_PLL0_PLL_UNLOCK_DETECT_CNTL__VI          = 0x170A;
constexpr unsigned int mmBPHYC_PLL0_PLL_UPDATE_CNTL__VI                 = 0x170D;
constexpr unsigned int mmBPHYC_PLL0_PLL_UPDATE_LOCK__VI                 = 0x170C;
constexpr unsigned int mmBPHYC_PLL0_PLL_VREG_CNTL__VI                   = 0x1709;
constexpr unsigned int mmBPHYC_PLL0_PLL_XOR_LOCK__VI                    = 0x1710;
constexpr unsigned int mmBPHYC_PLL0_PPLL_DEBUG_MUX_CNTL__VI             = 0x1721;
constexpr unsigned int mmBPHYC_PLL0_PPLL_DIV_UPDATE_DEBUG__VI           = 0x171F;
constexpr unsigned int mmBPHYC_PLL0_PPLL_SPARE0__VI                     = 0x1722;
constexpr unsigned int mmBPHYC_PLL0_PPLL_SPARE1__VI                     = 0x1723;
constexpr unsigned int mmBPHYC_PLL0_PPLL_STATUS_DEBUG__VI               = 0x1720;
constexpr unsigned int mmBPHYC_PLL0_VGA25_PPLL_ANALOG__VI               = 0x171B;
constexpr unsigned int mmBPHYC_PLL0_VGA25_PPLL_FB_DIV__VI               = 0x1715;
constexpr unsigned int mmBPHYC_PLL0_VGA25_PPLL_POST_DIV__VI             = 0x1718;
constexpr unsigned int mmBPHYC_PLL0_VGA25_PPLL_REF_DIV__VI              = 0x1712;
constexpr unsigned int mmBPHYC_PLL0_VGA28_PPLL_ANALOG__VI               = 0x171C;
constexpr unsigned int mmBPHYC_PLL0_VGA28_PPLL_FB_DIV__VI               = 0x1716;
constexpr unsigned int mmBPHYC_PLL0_VGA28_PPLL_POST_DIV__VI             = 0x1719;
constexpr unsigned int mmBPHYC_PLL0_VGA28_PPLL_REF_DIV__VI              = 0x1713;
constexpr unsigned int mmBPHYC_PLL0_VGA41_PPLL_ANALOG__VI               = 0x171D;
constexpr unsigned int mmBPHYC_PLL0_VGA41_PPLL_FB_DIV__VI               = 0x1717;
constexpr unsigned int mmBPHYC_PLL0_VGA41_PPLL_POST_DIV__VI             = 0x171A;
constexpr unsigned int mmBPHYC_PLL0_VGA41_PPLL_REF_DIV__VI              = 0x1714;
constexpr unsigned int mmBPHYC_PLL1_DISPPLL_BG_CNTL__VI                 = 0x1748;
constexpr unsigned int mmBPHYC_PLL1_PLL_ANALOG__VI                      = 0x1732;
constexpr unsigned int mmBPHYC_PLL1_PLL_ANALOG_CNTL__VI                 = 0x173B;
constexpr unsigned int mmBPHYC_PLL1_PLL_CNTL__VI                        = 0x1731;
constexpr unsigned int mmBPHYC_PLL1_PLL_DEBUG_CNTL__VI                  = 0x1735;
constexpr unsigned int mmBPHYC_PLL1_PLL_DS_CNTL__VI                     = 0x172F;
constexpr unsigned int mmBPHYC_PLL1_PLL_FB_DIV__VI                      = 0x172B;
constexpr unsigned int mmBPHYC_PLL1_PLL_IDCLK_CNTL__VI                  = 0x1730;
constexpr unsigned int mmBPHYC_PLL1_PLL_POST_DIV__VI                    = 0x172C;
constexpr unsigned int mmBPHYC_PLL1_PLL_REF_DIV__VI                     = 0x172A;
constexpr unsigned int mmBPHYC_PLL1_PLL_SS_AMOUNT_DSFRAC__VI            = 0x172D;
constexpr unsigned int mmBPHYC_PLL1_PLL_SS_CNTL__VI                     = 0x172E;
constexpr unsigned int mmBPHYC_PLL1_PLL_UNLOCK_DETECT_CNTL__VI          = 0x1734;
constexpr unsigned int mmBPHYC_PLL1_PLL_UPDATE_CNTL__VI                 = 0x1737;
constexpr unsigned int mmBPHYC_PLL1_PLL_UPDATE_LOCK__VI                 = 0x1736;
constexpr unsigned int mmBPHYC_PLL1_PLL_VREG_CNTL__VI                   = 0x1733;
constexpr unsigned int mmBPHYC_PLL1_PLL_XOR_LOCK__VI                    = 0x173A;
constexpr unsigned int mmBPHYC_PLL1_PPLL_DEBUG_MUX_CNTL__VI             = 0x174B;
constexpr unsigned int mmBPHYC_PLL1_PPLL_DIV_UPDATE_DEBUG__VI           = 0x1749;
constexpr unsigned int mmBPHYC_PLL1_PPLL_SPARE0__VI                     = 0x174C;
constexpr unsigned int mmBPHYC_PLL1_PPLL_SPARE1__VI                     = 0x174D;
constexpr unsigned int mmBPHYC_PLL1_PPLL_STATUS_DEBUG__VI               = 0x174A;
constexpr unsigned int mmBPHYC_PLL1_VGA25_PPLL_ANALOG__VI               = 0x1745;
constexpr unsigned int mmBPHYC_PLL1_VGA25_PPLL_FB_DIV__VI               = 0x173F;
constexpr unsigned int mmBPHYC_PLL1_VGA25_PPLL_POST_DIV__VI             = 0x1742;
constexpr unsigned int mmBPHYC_PLL1_VGA25_PPLL_REF_DIV__VI              = 0x173C;
constexpr unsigned int mmBPHYC_PLL1_VGA28_PPLL_ANALOG__VI               = 0x1746;
constexpr unsigned int mmBPHYC_PLL1_VGA28_PPLL_FB_DIV__VI               = 0x1740;
constexpr unsigned int mmBPHYC_PLL1_VGA28_PPLL_POST_DIV__VI             = 0x1743;
constexpr unsigned int mmBPHYC_PLL1_VGA28_PPLL_REF_DIV__VI              = 0x173D;
constexpr unsigned int mmBPHYC_PLL1_VGA41_PPLL_ANALOG__VI               = 0x1747;
constexpr unsigned int mmBPHYC_PLL1_VGA41_PPLL_FB_DIV__VI               = 0x1741;
constexpr unsigned int mmBPHYC_PLL1_VGA41_PPLL_POST_DIV__VI             = 0x1744;
constexpr unsigned int mmBPHYC_PLL1_VGA41_PPLL_REF_DIV__VI              = 0x173E;
constexpr unsigned int mmBPHYC_PLL2_DISPPLL_BG_CNTL__VI                 = 0x1772;
constexpr unsigned int mmBPHYC_PLL2_PLL_ANALOG__VI                      = 0x175C;
constexpr unsigned int mmBPHYC_PLL2_PLL_ANALOG_CNTL__VI                 = 0x1765;
constexpr unsigned int mmBPHYC_PLL2_PLL_CNTL__VI                        = 0x175B;
constexpr unsigned int mmBPHYC_PLL2_PLL_DEBUG_CNTL__VI                  = 0x175F;
constexpr unsigned int mmBPHYC_PLL2_PLL_DS_CNTL__VI                     = 0x1759;
constexpr unsigned int mmBPHYC_PLL2_PLL_FB_DIV__VI                      = 0x1755;
constexpr unsigned int mmBPHYC_PLL2_PLL_IDCLK_CNTL__VI                  = 0x175A;
constexpr unsigned int mmBPHYC_PLL2_PLL_POST_DIV__VI                    = 0x1756;
constexpr unsigned int mmBPHYC_PLL2_PLL_REF_DIV__VI                     = 0x1754;
constexpr unsigned int mmBPHYC_PLL2_PLL_SS_AMOUNT_DSFRAC__VI            = 0x1757;
constexpr unsigned int mmBPHYC_PLL2_PLL_SS_CNTL__VI                     = 0x1758;
constexpr unsigned int mmBPHYC_PLL2_PLL_UNLOCK_DETECT_CNTL__VI          = 0x175E;
constexpr unsigned int mmBPHYC_PLL2_PLL_UPDATE_CNTL__VI                 = 0x1761;
constexpr unsigned int mmBPHYC_PLL2_PLL_UPDATE_LOCK__VI                 = 0x1760;
constexpr unsigned int mmBPHYC_PLL2_PLL_VREG_CNTL__VI                   = 0x175D;
constexpr unsigned int mmBPHYC_PLL2_PLL_XOR_LOCK__VI                    = 0x1764;
constexpr unsigned int mmBPHYC_PLL2_PPLL_DEBUG_MUX_CNTL__VI             = 0x1775;
constexpr unsigned int mmBPHYC_PLL2_PPLL_DIV_UPDATE_DEBUG__VI           = 0x1773;
constexpr unsigned int mmBPHYC_PLL2_PPLL_SPARE0__VI                     = 0x1776;
constexpr unsigned int mmBPHYC_PLL2_PPLL_SPARE1__VI                     = 0x1777;
constexpr unsigned int mmBPHYC_PLL2_PPLL_STATUS_DEBUG__VI               = 0x1774;
constexpr unsigned int mmBPHYC_PLL2_VGA25_PPLL_ANALOG__VI               = 0x176F;
constexpr unsigned int mmBPHYC_PLL2_VGA25_PPLL_FB_DIV__VI               = 0x1769;
constexpr unsigned int mmBPHYC_PLL2_VGA25_PPLL_POST_DIV__VI             = 0x176C;
constexpr unsigned int mmBPHYC_PLL2_VGA25_PPLL_REF_DIV__VI              = 0x1766;
constexpr unsigned int mmBPHYC_PLL2_VGA28_PPLL_ANALOG__VI               = 0x1770;
constexpr unsigned int mmBPHYC_PLL2_VGA28_PPLL_FB_DIV__VI               = 0x176A;
constexpr unsigned int mmBPHYC_PLL2_VGA28_PPLL_POST_DIV__VI             = 0x176D;
constexpr unsigned int mmBPHYC_PLL2_VGA28_PPLL_REF_DIV__VI              = 0x1767;
constexpr unsigned int mmBPHYC_PLL2_VGA41_PPLL_ANALOG__VI               = 0x1771;
constexpr unsigned int mmBPHYC_PLL2_VGA41_PPLL_FB_DIV__VI               = 0x176B;
constexpr unsigned int mmBPHYC_PLL2_VGA41_PPLL_POST_DIV__VI             = 0x176E;
constexpr unsigned int mmBPHYC_PLL2_VGA41_PPLL_REF_DIV__VI              = 0x1768;
constexpr unsigned int mmBPHYC_UNIPHY0_UNIPHY_ANG_BIST_CNTL__VI         = 0x48CC;
constexpr unsigned int mmBPHYC_UNIPHY0_UNIPHY_DATA_SYNCHRONIZATION__VI  = 0x48CA;
constexpr unsigned int mmBPHYC_UNIPHY0_UNIPHY_DEBUG__VI                 = 0x48D6;
constexpr unsigned int mmBPHYC_UNIPHY0_UNIPHY_PLL_CONTROL1__VI          = 0x48C6;
constexpr unsigned int mmBPHYC_UNIPHY0_UNIPHY_PLL_CONTROL2__VI          = 0x48C7;
constexpr unsigned int mmBPHYC_UNIPHY0_UNIPHY_PLL_FBDIV__VI             = 0x48C5;
constexpr unsigned int mmBPHYC_UNIPHY0_UNIPHY_PLL_SS_CNTL__VI           = 0x48C9;
constexpr unsigned int mmBPHYC_UNIPHY0_UNIPHY_PLL_SS_STEP_SIZE__VI      = 0x48C8;
constexpr unsigned int mmBPHYC_UNIPHY0_UNIPHY_POWER_CONTROL__VI         = 0x48C4;
constexpr unsigned int mmBPHYC_UNIPHY0_UNIPHY_REG_TEST_OUTPUT__VI       = 0x48CB;
constexpr unsigned int mmBPHYC_UNIPHY0_UNIPHY_REG_TEST_OUTPUT2__VI      = 0x48CD;
constexpr unsigned int mmBPHYC_UNIPHY0_UNIPHY_TPG_CONTROL__VI           = 0x48D4;
constexpr unsigned int mmBPHYC_UNIPHY0_UNIPHY_TPG_SEED__VI              = 0x48D5;
constexpr unsigned int mmBPHYC_UNIPHY0_UNIPHY_TX_CONTROL1__VI           = 0x48C0;
constexpr unsigned int mmBPHYC_UNIPHY0_UNIPHY_TX_CONTROL2__VI           = 0x48C1;
constexpr unsigned int mmBPHYC_UNIPHY0_UNIPHY_TX_CONTROL3__VI           = 0x48C2;
constexpr unsigned int mmBPHYC_UNIPHY0_UNIPHY_TX_CONTROL4__VI           = 0x48C3;
constexpr unsigned int mmBPHYC_UNIPHY1_UNIPHY_ANG_BIST_CNTL__VI         = 0x48EC;
constexpr unsigned int mmBPHYC_UNIPHY1_UNIPHY_DATA_SYNCHRONIZATION__VI  = 0x48EA;
constexpr unsigned int mmBPHYC_UNIPHY1_UNIPHY_DEBUG__VI                 = 0x48F6;
constexpr unsigned int mmBPHYC_UNIPHY1_UNIPHY_PLL_CONTROL1__VI          = 0x48E6;
constexpr unsigned int mmBPHYC_UNIPHY1_UNIPHY_PLL_CONTROL2__VI          = 0x48E7;
constexpr unsigned int mmBPHYC_UNIPHY1_UNIPHY_PLL_FBDIV__VI             = 0x48E5;
constexpr unsigned int mmBPHYC_UNIPHY1_UNIPHY_PLL_SS_CNTL__VI           = 0x48E9;
constexpr unsigned int mmBPHYC_UNIPHY1_UNIPHY_PLL_SS_STEP_SIZE__VI      = 0x48E8;
constexpr unsigned int mmBPHYC_UNIPHY1_UNIPHY_POWER_CONTROL__VI         = 0x48E4;
constexpr unsigned int mmBPHYC_UNIPHY1_UNIPHY_REG_TEST_OUTPUT__VI       = 0x48EB;
constexpr unsigned int mmBPHYC_UNIPHY1_UNIPHY_REG_TEST_OUTPUT2__VI      = 0x48ED;
constexpr unsigned int mmBPHYC_UNIPHY1_UNIPHY_TPG_CONTROL__VI           = 0x48F4;
constexpr unsigned int mmBPHYC_UNIPHY1_UNIPHY_TPG_SEED__VI              = 0x48F5;
constexpr unsigned int mmBPHYC_UNIPHY1_UNIPHY_TX_CONTROL1__VI           = 0x48E0;
constexpr unsigned int mmBPHYC_UNIPHY1_UNIPHY_TX_CONTROL2__VI           = 0x48E1;
constexpr unsigned int mmBPHYC_UNIPHY1_UNIPHY_TX_CONTROL3__VI           = 0x48E2;
constexpr unsigned int mmBPHYC_UNIPHY1_UNIPHY_TX_CONTROL4__VI           = 0x48E3;
constexpr unsigned int mmBPHYC_UNIPHY2_UNIPHY_ANG_BIST_CNTL__VI         = 0x490C;
constexpr unsigned int mmBPHYC_UNIPHY2_UNIPHY_DATA_SYNCHRONIZATION__VI  = 0x490A;
constexpr unsigned int mmBPHYC_UNIPHY2_UNIPHY_DEBUG__VI                 = 0x4916;
constexpr unsigned int mmBPHYC_UNIPHY2_UNIPHY_PLL_CONTROL1__VI          = 0x4906;
constexpr unsigned int mmBPHYC_UNIPHY2_UNIPHY_PLL_CONTROL2__VI          = 0x4907;
constexpr unsigned int mmBPHYC_UNIPHY2_UNIPHY_PLL_FBDIV__VI             = 0x4905;
constexpr unsigned int mmBPHYC_UNIPHY2_UNIPHY_PLL_SS_CNTL__VI           = 0x4909;
constexpr unsigned int mmBPHYC_UNIPHY2_UNIPHY_PLL_SS_STEP_SIZE__VI      = 0x4908;
constexpr unsigned int mmBPHYC_UNIPHY2_UNIPHY_POWER_CONTROL__VI         = 0x4904;
constexpr unsigned int mmBPHYC_UNIPHY2_UNIPHY_REG_TEST_OUTPUT__VI       = 0x490B;
constexpr unsigned int mmBPHYC_UNIPHY2_UNIPHY_REG_TEST_OUTPUT2__VI      = 0x490D;
constexpr unsigned int mmBPHYC_UNIPHY2_UNIPHY_TPG_CONTROL__VI           = 0x4914;
constexpr unsigned int mmBPHYC_UNIPHY2_UNIPHY_TPG_SEED__VI              = 0x4915;
constexpr unsigned int mmBPHYC_UNIPHY2_UNIPHY_TX_CONTROL1__VI           = 0x4900;
constexpr unsigned int mmBPHYC_UNIPHY2_UNIPHY_TX_CONTROL2__VI           = 0x4901;
constexpr unsigned int mmBPHYC_UNIPHY2_UNIPHY_TX_CONTROL3__VI           = 0x4902;
constexpr unsigned int mmBPHYC_UNIPHY2_UNIPHY_TX_CONTROL4__VI           = 0x4903;
constexpr unsigned int mmBPHYC_UNIPHY3_UNIPHY_ANG_BIST_CNTL__VI         = 0x492C;
constexpr unsigned int mmBPHYC_UNIPHY3_UNIPHY_DATA_SYNCHRONIZATION__VI  = 0x492A;
constexpr unsigned int mmBPHYC_UNIPHY3_UNIPHY_DEBUG__VI                 = 0x4936;
constexpr unsigned int mmBPHYC_UNIPHY3_UNIPHY_PLL_CONTROL1__VI          = 0x4926;
constexpr unsigned int mmBPHYC_UNIPHY3_UNIPHY_PLL_CONTROL2__VI          = 0x4927;
constexpr unsigned int mmBPHYC_UNIPHY3_UNIPHY_PLL_FBDIV__VI             = 0x4925;
constexpr unsigned int mmBPHYC_UNIPHY3_UNIPHY_PLL_SS_CNTL__VI           = 0x4929;
constexpr unsigned int mmBPHYC_UNIPHY3_UNIPHY_PLL_SS_STEP_SIZE__VI      = 0x4928;
constexpr unsigned int mmBPHYC_UNIPHY3_UNIPHY_POWER_CONTROL__VI         = 0x4924;
constexpr unsigned int mmBPHYC_UNIPHY3_UNIPHY_REG_TEST_OUTPUT__VI       = 0x492B;
constexpr unsigned int mmBPHYC_UNIPHY3_UNIPHY_REG_TEST_OUTPUT2__VI      = 0x492D;
constexpr unsigned int mmBPHYC_UNIPHY3_UNIPHY_TPG_CONTROL__VI           = 0x4934;
constexpr unsigned int mmBPHYC_UNIPHY3_UNIPHY_TPG_SEED__VI              = 0x4935;
constexpr unsigned int mmBPHYC_UNIPHY3_UNIPHY_TX_CONTROL1__VI           = 0x4920;
constexpr unsigned int mmBPHYC_UNIPHY3_UNIPHY_TX_CONTROL2__VI           = 0x4921;
constexpr unsigned int mmBPHYC_UNIPHY3_UNIPHY_TX_CONTROL3__VI           = 0x4922;
constexpr unsigned int mmBPHYC_UNIPHY3_UNIPHY_TX_CONTROL4__VI           = 0x4923;
constexpr unsigned int mmBPHYC_UNIPHY4_UNIPHY_ANG_BIST_CNTL__VI         = 0x494C;
constexpr unsigned int mmBPHYC_UNIPHY4_UNIPHY_DATA_SYNCHRONIZATION__VI  = 0x494A;
constexpr unsigned int mmBPHYC_UNIPHY4_UNIPHY_DEBUG__VI                 = 0x4956;
constexpr unsigned int mmBPHYC_UNIPHY4_UNIPHY_PLL_CONTROL1__VI          = 0x4946;
constexpr unsigned int mmBPHYC_UNIPHY4_UNIPHY_PLL_CONTROL2__VI          = 0x4947;
constexpr unsigned int mmBPHYC_UNIPHY4_UNIPHY_PLL_FBDIV__VI             = 0x4945;
constexpr unsigned int mmBPHYC_UNIPHY4_UNIPHY_PLL_SS_CNTL__VI           = 0x4949;
constexpr unsigned int mmBPHYC_UNIPHY4_UNIPHY_PLL_SS_STEP_SIZE__VI      = 0x4948;
constexpr unsigned int mmBPHYC_UNIPHY4_UNIPHY_POWER_CONTROL__VI         = 0x4944;
constexpr unsigned int mmBPHYC_UNIPHY4_UNIPHY_REG_TEST_OUTPUT__VI       = 0x494B;
constexpr unsigned int mmBPHYC_UNIPHY4_UNIPHY_REG_TEST_OUTPUT2__VI      = 0x494D;
constexpr unsigned int mmBPHYC_UNIPHY4_UNIPHY_TPG_CONTROL__VI           = 0x4954;
constexpr unsigned int mmBPHYC_UNIPHY4_UNIPHY_TPG_SEED__VI              = 0x4955;
constexpr unsigned int mmBPHYC_UNIPHY4_UNIPHY_TX_CONTROL1__VI           = 0x4940;
constexpr unsigned int mmBPHYC_UNIPHY4_UNIPHY_TX_CONTROL2__VI           = 0x4941;
constexpr unsigned int mmBPHYC_UNIPHY4_UNIPHY_TX_CONTROL3__VI           = 0x4942;
constexpr unsigned int mmBPHYC_UNIPHY4_UNIPHY_TX_CONTROL4__VI           = 0x4943;
constexpr unsigned int mmBPHYC_UNIPHY5_UNIPHY_ANG_BIST_CNTL__VI         = 0x496C;
constexpr unsigned int mmBPHYC_UNIPHY5_UNIPHY_DATA_SYNCHRONIZATION__VI  = 0x496A;
constexpr unsigned int mmBPHYC_UNIPHY5_UNIPHY_DEBUG__VI                 = 0x4976;
constexpr unsigned int mmBPHYC_UNIPHY5_UNIPHY_PLL_CONTROL1__VI          = 0x4966;
constexpr unsigned int mmBPHYC_UNIPHY5_UNIPHY_PLL_CONTROL2__VI          = 0x4967;
constexpr unsigned int mmBPHYC_UNIPHY5_UNIPHY_PLL_FBDIV__VI             = 0x4965;
constexpr unsigned int mmBPHYC_UNIPHY5_UNIPHY_PLL_SS_CNTL__VI           = 0x4969;
constexpr unsigned int mmBPHYC_UNIPHY5_UNIPHY_PLL_SS_STEP_SIZE__VI      = 0x4968;
constexpr unsigned int mmBPHYC_UNIPHY5_UNIPHY_POWER_CONTROL__VI         = 0x4964;
constexpr unsigned int mmBPHYC_UNIPHY5_UNIPHY_REG_TEST_OUTPUT__VI       = 0x496B;
constexpr unsigned int mmBPHYC_UNIPHY5_UNIPHY_REG_TEST_OUTPUT2__VI      = 0x496D;
constexpr unsigned int mmBPHYC_UNIPHY5_UNIPHY_TPG_CONTROL__VI           = 0x4974;
constexpr unsigned int mmBPHYC_UNIPHY5_UNIPHY_TPG_SEED__VI              = 0x4975;
constexpr unsigned int mmBPHYC_UNIPHY5_UNIPHY_TX_CONTROL1__VI           = 0x4960;
constexpr unsigned int mmBPHYC_UNIPHY5_UNIPHY_TX_CONTROL2__VI           = 0x4961;
constexpr unsigned int mmBPHYC_UNIPHY5_UNIPHY_TX_CONTROL3__VI           = 0x4962;
constexpr unsigned int mmBPHYC_UNIPHY5_UNIPHY_TX_CONTROL4__VI           = 0x4963;
constexpr unsigned int mmBPHYC_UNIPHY6_UNIPHY_ANG_BIST_CNTL__VI         = 0x498C;
constexpr unsigned int mmBPHYC_UNIPHY6_UNIPHY_DATA_SYNCHRONIZATION__VI  = 0x498A;
constexpr unsigned int mmBPHYC_UNIPHY6_UNIPHY_DEBUG__VI                 = 0x4996;
constexpr unsigned int mmBPHYC_UNIPHY6_UNIPHY_PLL_CONTROL1__VI          = 0x4986;
constexpr unsigned int mmBPHYC_UNIPHY6_UNIPHY_PLL_CONTROL2__VI          = 0x4987;
constexpr unsigned int mmBPHYC_UNIPHY6_UNIPHY_PLL_FBDIV__VI             = 0x4985;
constexpr unsigned int mmBPHYC_UNIPHY6_UNIPHY_PLL_SS_CNTL__VI           = 0x4989;
constexpr unsigned int mmBPHYC_UNIPHY6_UNIPHY_PLL_SS_STEP_SIZE__VI      = 0x4988;
constexpr unsigned int mmBPHYC_UNIPHY6_UNIPHY_POWER_CONTROL__VI         = 0x4984;
constexpr unsigned int mmBPHYC_UNIPHY6_UNIPHY_REG_TEST_OUTPUT__VI       = 0x498B;
constexpr unsigned int mmBPHYC_UNIPHY6_UNIPHY_REG_TEST_OUTPUT2__VI      = 0x498D;
constexpr unsigned int mmBPHYC_UNIPHY6_UNIPHY_TPG_CONTROL__VI           = 0x4994;
constexpr unsigned int mmBPHYC_UNIPHY6_UNIPHY_TPG_SEED__VI              = 0x4995;
constexpr unsigned int mmBPHYC_UNIPHY6_UNIPHY_TX_CONTROL1__VI           = 0x4980;
constexpr unsigned int mmBPHYC_UNIPHY6_UNIPHY_TX_CONTROL2__VI           = 0x4981;
constexpr unsigned int mmBPHYC_UNIPHY6_UNIPHY_TX_CONTROL3__VI           = 0x4982;
constexpr unsigned int mmBPHYC_UNIPHY6_UNIPHY_TX_CONTROL4__VI           = 0x4983;
constexpr unsigned int mmBX_RESET_CNTL__VI                              = 0x1518;
constexpr unsigned int mmCB_COLOR0_DCC_BASE__VI                         = 0xA325;
constexpr unsigned int mmCB_COLOR0_DCC_CONTROL__VI                      = 0xA31E;
constexpr unsigned int mmCB_COLOR1_DCC_BASE__VI                         = 0xA334;
constexpr unsigned int mmCB_COLOR1_DCC_CONTROL__VI                      = 0xA32D;
constexpr unsigned int mmCB_COLOR2_DCC_BASE__VI                         = 0xA343;
constexpr unsigned int mmCB_COLOR2_DCC_CONTROL__VI                      = 0xA33C;
constexpr unsigned int mmCB_COLOR3_DCC_BASE__VI                         = 0xA352;
constexpr unsigned int mmCB_COLOR3_DCC_CONTROL__VI                      = 0xA34B;
constexpr unsigned int mmCB_COLOR4_DCC_BASE__VI                         = 0xA361;
constexpr unsigned int mmCB_COLOR4_DCC_CONTROL__VI                      = 0xA35A;
constexpr unsigned int mmCB_COLOR5_DCC_BASE__VI                         = 0xA370;
constexpr unsigned int mmCB_COLOR5_DCC_CONTROL__VI                      = 0xA369;
constexpr unsigned int mmCB_COLOR6_DCC_BASE__VI                         = 0xA37F;
constexpr unsigned int mmCB_COLOR6_DCC_CONTROL__VI                      = 0xA378;
constexpr unsigned int mmCB_COLOR7_DCC_BASE__VI                         = 0xA38E;
constexpr unsigned int mmCB_COLOR7_DCC_CONTROL__VI                      = 0xA387;
constexpr unsigned int mmCB_DCC_CONFIG__VI                              = 0x2687;
constexpr unsigned int mmCB_DCC_CONTROL__VI                             = 0xA109;
constexpr unsigned int mmCB_DEBUG_BUS_19__VI                            = 0x26AB;
constexpr unsigned int mmCB_DEBUG_BUS_20__VI                            = 0x26AC;
constexpr unsigned int mmCB_DEBUG_BUS_21__VI                            = 0x26AD;
constexpr unsigned int mmCB_DEBUG_BUS_22__VI                            = 0x26AE;
constexpr unsigned int mmCC_DC_PIPE_DIS__VI                             = 0x0312;
constexpr unsigned int mmCC_GC_SHADER_RATE_CONFIG__VI                   = 0x2312;
constexpr unsigned int mmCC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY__VI    = 0x1835;
constexpr unsigned int mmCC_RCU_DC_AUDIO_PORT_CONNECTIVITY__VI          = 0x1834;
constexpr unsigned int mmCG_FPS_CNT__VI                                 = 0x01B6;
constexpr unsigned int mmCLKREQB_PERF_COUNTER__VI                       = 0x1522;
constexpr unsigned int mmCNV_CSC_C11_C12__VI                            = 0x5E20;
constexpr unsigned int mmCNV_CSC_C13_C14__VI                            = 0x5E21;
constexpr unsigned int mmCNV_CSC_C21_C22__VI                            = 0x5E22;
constexpr unsigned int mmCNV_CSC_C23_C24__VI                            = 0x5E23;
constexpr unsigned int mmCNV_CSC_C31_C32__VI                            = 0x5E24;
constexpr unsigned int mmCNV_CSC_C33_C34__VI                            = 0x5E25;
constexpr unsigned int mmCNV_CSC_CLAMP_B__VI                            = 0x5E2B;
constexpr unsigned int mmCNV_CSC_CLAMP_G__VI                            = 0x5E2A;
constexpr unsigned int mmCNV_CSC_CLAMP_R__VI                            = 0x5E29;
constexpr unsigned int mmCNV_CSC_CONTROL__VI                            = 0x5E1F;
constexpr unsigned int mmCNV_CSC_ROUND_OFFSET_B__VI                     = 0x5E28;
constexpr unsigned int mmCNV_CSC_ROUND_OFFSET_G__VI                     = 0x5E27;
constexpr unsigned int mmCNV_CSC_ROUND_OFFSET_R__VI                     = 0x5E26;
constexpr unsigned int mmCNV_INPUT_SELECT__VI                           = 0x5E33;
constexpr unsigned int mmCNV_MODE__VI                                   = 0x5E1A;
constexpr unsigned int mmCNV_SOURCE_SIZE__VI                            = 0x5E1E;
constexpr unsigned int mmCNV_TEST_CNTL__VI                              = 0x5E2C;
constexpr unsigned int mmCNV_TEST_CRC_BLUE__VI                          = 0x5E2F;
constexpr unsigned int mmCNV_TEST_CRC_GREEN__VI                         = 0x5E2E;
constexpr unsigned int mmCNV_TEST_CRC_RED__VI                           = 0x5E2D;
constexpr unsigned int mmCNV_TEST_DEBUG_DATA__VI                        = 0x5E35;
constexpr unsigned int mmCNV_TEST_DEBUG_INDEX__VI                       = 0x5E34;
constexpr unsigned int mmCNV_UPDATE__VI                                 = 0x5E1D;
constexpr unsigned int mmCNV_WINDOW_SIZE__VI                            = 0x5E1C;
constexpr unsigned int mmCNV_WINDOW_START__VI                           = 0x5E1B;
constexpr unsigned int mmCOL_MAN_DEBUG_CONTROL__VI                      = 0x46E6;
constexpr unsigned int mmCOL_MAN_FP_CONVERTED_FIELD__VI                 = 0x46C7;
constexpr unsigned int mmCOL_MAN_INPUT_CSC_CONTROL__VI                  = 0x46A5;
constexpr unsigned int mmCOL_MAN_OUTPUT_CSC_CONTROL__VI                 = 0x46B6;
constexpr unsigned int mmCOL_MAN_TEST_DEBUG_DATA__VI                    = 0x46E5;
constexpr unsigned int mmCOL_MAN_TEST_DEBUG_INDEX__VI                   = 0x46E4;
constexpr unsigned int mmCOL_MAN_UPDATE__VI                             = 0x46A4;
constexpr unsigned int mmCOMM_MATRIXA_TRANS_C11_C12__VI                 = 0x1A43;
constexpr unsigned int mmCOMM_MATRIXA_TRANS_C13_C14__VI                 = 0x1A44;
constexpr unsigned int mmCOMM_MATRIXA_TRANS_C21_C22__VI                 = 0x1A45;
constexpr unsigned int mmCOMM_MATRIXA_TRANS_C23_C24__VI                 = 0x1A46;
constexpr unsigned int mmCOMM_MATRIXA_TRANS_C31_C32__VI                 = 0x1A47;
constexpr unsigned int mmCOMM_MATRIXA_TRANS_C33_C34__VI                 = 0x1A48;
constexpr unsigned int mmCOMM_MATRIXB_TRANS_C11_C12__VI                 = 0x1A49;
constexpr unsigned int mmCOMM_MATRIXB_TRANS_C13_C14__VI                 = 0x1A4A;
constexpr unsigned int mmCOMM_MATRIXB_TRANS_C21_C22__VI                 = 0x1A4B;
constexpr unsigned int mmCOMM_MATRIXB_TRANS_C23_C24__VI                 = 0x1A4C;
constexpr unsigned int mmCOMM_MATRIXB_TRANS_C31_C32__VI                 = 0x1A4D;
constexpr unsigned int mmCOMM_MATRIXB_TRANS_C33_C34__VI                 = 0x1A4E;
constexpr unsigned int mmCOMPUTE_DISPATCH_ID__VI                        = 0x2E20;
constexpr unsigned int mmCOMPUTE_NOWHERE__VI                            = 0x2E7F;
constexpr unsigned int mmCOMPUTE_RELAUNCH__VI                           = 0x2E22;
constexpr unsigned int mmCOMPUTE_THREADGROUP_ID__VI                     = 0x2E21;
constexpr unsigned int mmCOMPUTE_WAVE_RESTORE_ADDR_HI__VI               = 0x2E24;
constexpr unsigned int mmCOMPUTE_WAVE_RESTORE_ADDR_LO__VI               = 0x2E23;
constexpr unsigned int mmCOMPUTE_WAVE_RESTORE_CONTROL__VI               = 0x2E25;
constexpr unsigned int mmCONFIG_RESERVED__VI                            = 0x1502;
constexpr unsigned int mmCPLL_MACRO_CNTL_RESERVED0__VI                  = 0x5FD0;
constexpr unsigned int mmCPLL_MACRO_CNTL_RESERVED1__VI                  = 0x5FD1;
constexpr unsigned int mmCPLL_MACRO_CNTL_RESERVED10__VI                 = 0x5FDA;
constexpr unsigned int mmCPLL_MACRO_CNTL_RESERVED11__VI                 = 0x5FDB;
constexpr unsigned int mmCPLL_MACRO_CNTL_RESERVED2__VI                  = 0x5FD2;
constexpr unsigned int mmCPLL_MACRO_CNTL_RESERVED3__VI                  = 0x5FD3;
constexpr unsigned int mmCPLL_MACRO_CNTL_RESERVED4__VI                  = 0x5FD4;
constexpr unsigned int mmCPLL_MACRO_CNTL_RESERVED5__VI                  = 0x5FD5;
constexpr unsigned int mmCPLL_MACRO_CNTL_RESERVED6__VI                  = 0x5FD6;
constexpr unsigned int mmCPLL_MACRO_CNTL_RESERVED7__VI                  = 0x5FD7;
constexpr unsigned int mmCPLL_MACRO_CNTL_RESERVED8__VI                  = 0x5FD8;
constexpr unsigned int mmCPLL_MACRO_CNTL_RESERVED9__VI                  = 0x5FD9;
constexpr unsigned int mmCPM_CONTROL__VI                                = 0x14B8;
constexpr unsigned int mmCP_CE_COMPLETION_STATUS__VI                    = 0xC0ED;
constexpr unsigned int mmCP_CE_METADATA_BASE_ADDR__VI                   = 0xC0F2;
constexpr unsigned int mmCP_CE_METADATA_BASE_ADDR_HI__VI                = 0xC0F3;
constexpr unsigned int mmCP_CE_RB_OFFSET__VI                            = 0xC09B;
constexpr unsigned int mmCP_CE_UCODE_ADDR__SI__CI                       = 0x305A;
constexpr unsigned int mmCP_CE_UCODE_ADDR__VI                           = 0xF818;
constexpr unsigned int mmCP_CE_UCODE_DATA__SI__CI                       = 0x305B;
constexpr unsigned int mmCP_CE_UCODE_DATA__VI                           = 0xF819;
constexpr unsigned int mmCP_CONFIG__VI                                  = 0x0F96;
constexpr unsigned int mmCP_CPC_IC_BASE_CNTL__VI                        = 0x30BB;
constexpr unsigned int mmCP_CPC_IC_BASE_HI__VI                          = 0x30BA;
constexpr unsigned int mmCP_CPC_IC_BASE_LO__VI                          = 0x30B9;
constexpr unsigned int mmCP_CPC_IC_OP_CNTL__VI                          = 0x30BC;
constexpr unsigned int mmCP_CPC_MGCG_SYNC_CNTL__VI                      = 0x3036;
constexpr unsigned int mmCP_DFY_CMD__VI                                 = 0x3034;
constexpr unsigned int mmCP_DISPATCH_INDR_ADDR__VI                      = 0xC0F6;
constexpr unsigned int mmCP_DISPATCH_INDR_ADDR_HI__VI                   = 0xC0F7;
constexpr unsigned int mmCP_DRAW_INDX_INDR_ADDR__VI                     = 0xC0F4;
constexpr unsigned int mmCP_DRAW_INDX_INDR_ADDR_HI__VI                  = 0xC0F5;
constexpr unsigned int mmCP_DRAW_OBJECT__VI                             = 0xD810;
constexpr unsigned int mmCP_DRAW_OBJECT_COUNTER__VI                     = 0xD811;
constexpr unsigned int mmCP_DRAW_WINDOW_CNTL__VI                        = 0xD815;
constexpr unsigned int mmCP_DRAW_WINDOW_HI__VI                          = 0xD813;
constexpr unsigned int mmCP_DRAW_WINDOW_LO__VI                          = 0xD814;
constexpr unsigned int mmCP_DRAW_WINDOW_MASK_HI__VI                     = 0xD812;
constexpr unsigned int mmCP_EOP_DONE_CNTX_ID__VI                        = 0xC0D7;
constexpr unsigned int mmCP_GDS_BKUP_ADDR__VI                           = 0xC0FB;
constexpr unsigned int mmCP_GDS_BKUP_ADDR_HI__VI                        = 0xC0FC;
constexpr unsigned int mmCP_HPD_STATUS0__VI                             = 0x3241;
constexpr unsigned int mmCP_HQD_CNTL_STACK_OFFSET__VI                   = 0x3273;
constexpr unsigned int mmCP_HQD_CNTL_STACK_SIZE__VI                     = 0x3274;
constexpr unsigned int mmCP_HQD_CTX_SAVE_BASE_ADDR_HI__VI               = 0x3271;
constexpr unsigned int mmCP_HQD_CTX_SAVE_BASE_ADDR_LO__VI               = 0x3270;
constexpr unsigned int mmCP_HQD_CTX_SAVE_CONTROL__VI                    = 0x3272;
constexpr unsigned int mmCP_HQD_CTX_SAVE_SIZE__VI                       = 0x3276;
constexpr unsigned int mmCP_HQD_EOP_BASE_ADDR__VI                       = 0x326A;
constexpr unsigned int mmCP_HQD_EOP_BASE_ADDR_HI__VI                    = 0x326B;
constexpr unsigned int mmCP_HQD_EOP_CONTROL__VI                         = 0x326C;
constexpr unsigned int mmCP_HQD_EOP_DONES__VI                           = 0x327A;
constexpr unsigned int mmCP_HQD_EOP_EVENTS__VI                          = 0x326F;
constexpr unsigned int mmCP_HQD_EOP_RPTR__VI                            = 0x326D;
constexpr unsigned int mmCP_HQD_EOP_WPTR__VI                            = 0x326E;
constexpr unsigned int mmCP_HQD_EOP_WPTR_MEM__VI                        = 0x3279;
constexpr unsigned int mmCP_HQD_ERROR__VI                               = 0x3278;
constexpr unsigned int mmCP_HQD_GDS_RESOURCE_STATE__VI                  = 0x3277;
constexpr unsigned int mmCP_HQD_HQ_CONTROL0__VI                         = 0x3266;
constexpr unsigned int mmCP_HQD_HQ_CONTROL1__VI                         = 0x3269;
constexpr unsigned int mmCP_HQD_HQ_STATUS0__VI                          = 0x3265;
constexpr unsigned int mmCP_HQD_HQ_STATUS1__VI                          = 0x3268;
constexpr unsigned int mmCP_HQD_OFFLOAD__VI                             = 0x325E;
constexpr unsigned int mmCP_HQD_WG_STATE_OFFSET__VI                     = 0x3275;
constexpr unsigned int mmCP_INDEX_BASE_ADDR__VI                         = 0xC0F8;
constexpr unsigned int mmCP_INDEX_BASE_ADDR_HI__VI                      = 0xC0F9;
constexpr unsigned int mmCP_INDEX_TYPE__VI                              = 0xC0FA;
constexpr unsigned int mmCP_MEC1_F32_INT_DIS__VI                        = 0x30BD;
constexpr unsigned int mmCP_MEC2_F32_INT_DIS__VI                        = 0x30BE;
constexpr unsigned int mmCP_MEC_DOORBELL_RANGE_LOWER__VI                = 0x305C;
constexpr unsigned int mmCP_MEC_DOORBELL_RANGE_UPPER__VI                = 0x305D;
constexpr unsigned int mmCP_MEC_ME1_UCODE_ADDR__VI                      = 0xF81A;
constexpr unsigned int mmCP_MEC_ME1_UCODE_DATA__VI                      = 0xF81B;
constexpr unsigned int mmCP_MEC_ME2_UCODE_ADDR__VI                      = 0xF81C;
constexpr unsigned int mmCP_MEC_ME2_UCODE_DATA__VI                      = 0xF81D;
constexpr unsigned int mmCP_ME_RAM_DATA__SI__CI                         = 0x3058;
constexpr unsigned int mmCP_ME_RAM_DATA__VI                             = 0xF817;
constexpr unsigned int mmCP_ME_RAM_RADDR__SI__CI                        = 0x3056;
constexpr unsigned int mmCP_ME_RAM_RADDR__VI                            = 0xF816;
constexpr unsigned int mmCP_ME_RAM_WADDR__SI__CI                        = 0x3057;
constexpr unsigned int mmCP_ME_RAM_WADDR__VI                            = 0xF816;
constexpr unsigned int mmCP_PFP_COMPLETION_STATUS__VI                   = 0xC0EC;
constexpr unsigned int mmCP_PFP_METADATA_BASE_ADDR__VI                  = 0xC0F0;
constexpr unsigned int mmCP_PFP_METADATA_BASE_ADDR_HI__VI               = 0xC0F1;
constexpr unsigned int mmCP_PFP_UCODE_ADDR__SI__CI                      = 0x3054;
constexpr unsigned int mmCP_PFP_UCODE_ADDR__VI                          = 0xF814;
constexpr unsigned int mmCP_PFP_UCODE_DATA__SI__CI                      = 0x3055;
constexpr unsigned int mmCP_PFP_UCODE_DATA__VI                          = 0xF815;
constexpr unsigned int mmCP_PIPE_STATS_CONTROL__VI                      = 0xC03D;
constexpr unsigned int mmCP_PQ_STATUS__VI                               = 0x30B8;
constexpr unsigned int mmCP_PRED_NOT_VISIBLE__VI                        = 0xC0EE;
constexpr unsigned int mmCP_RB_DOORBELL_CONTROL__VI                     = 0x3059;
constexpr unsigned int mmCP_RB_DOORBELL_RANGE_LOWER__VI                 = 0x305A;
constexpr unsigned int mmCP_RB_DOORBELL_RANGE_UPPER__VI                 = 0x305B;
constexpr unsigned int mmCP_SAMPLE_STATUS__VI                           = 0xC0FD;
constexpr unsigned int mmCP_STREAM_OUT_CONTROL__VI                      = 0xC03E;
constexpr unsigned int mmCP_VIRT_STATUS__VI                             = 0x3038;
constexpr unsigned int mmCP_VMID_STATUS__VI                             = 0x30BF;
constexpr unsigned int mmCRTC0_CRTC_3D_STRUCTURE_CONTROL__VI            = 0x1B78;
constexpr unsigned int mmCRTC0_CRTC_AVSYNC_COUNTER__VI                  = 0x1B9B;
constexpr unsigned int mmCRTC0_CRTC_BLACK_COLOR__VI                     = 0x1BCC;
constexpr unsigned int mmCRTC0_CRTC_BLACK_COLOR_EXT__VI                 = 0x1BCD;
constexpr unsigned int mmCRTC0_CRTC_BLANK_DATA_COLOR__VI                = 0x1BCA;
constexpr unsigned int mmCRTC0_CRTC_BLANK_DATA_COLOR_EXT__VI            = 0x1BCB;
constexpr unsigned int mmCRTC0_CRTC_CRC0_DATA_B__VI                     = 0x1BDA;
constexpr unsigned int mmCRTC0_CRTC_CRC0_DATA_RG__VI                    = 0x1BD9;
constexpr unsigned int mmCRTC0_CRTC_CRC0_WINDOWA_X_CONTROL__VI          = 0x1BD5;
constexpr unsigned int mmCRTC0_CRTC_CRC0_WINDOWA_Y_CONTROL__VI          = 0x1BD6;
constexpr unsigned int mmCRTC0_CRTC_CRC0_WINDOWB_X_CONTROL__VI          = 0x1BD7;
constexpr unsigned int mmCRTC0_CRTC_CRC0_WINDOWB_Y_CONTROL__VI          = 0x1BD8;
constexpr unsigned int mmCRTC0_CRTC_CRC1_DATA_B__VI                     = 0x1BE0;
constexpr unsigned int mmCRTC0_CRTC_CRC1_DATA_RG__VI                    = 0x1BDF;
constexpr unsigned int mmCRTC0_CRTC_CRC1_WINDOWA_X_CONTROL__VI          = 0x1BDB;
constexpr unsigned int mmCRTC0_CRTC_CRC1_WINDOWA_Y_CONTROL__VI          = 0x1BDC;
constexpr unsigned int mmCRTC0_CRTC_CRC1_WINDOWB_X_CONTROL__VI          = 0x1BDD;
constexpr unsigned int mmCRTC0_CRTC_CRC1_WINDOWB_Y_CONTROL__VI          = 0x1BDE;
constexpr unsigned int mmCRTC0_CRTC_CRC_CNTL__VI                        = 0x1BD4;
constexpr unsigned int mmCRTC0_CRTC_DCFE_CLOCK_CONTROL__VI              = 0x1B7C;
constexpr unsigned int mmCRTC0_CRTC_EXT_TIMING_SYNC_CONTROL__VI         = 0x1BE1;
constexpr unsigned int mmCRTC0_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL__VI  = 0x1BE5;
constexpr unsigned int mmCRTC0_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL__VI  = 0x1BE4;
constexpr unsigned int mmCRTC0_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL__VI  = 0x1BE6;
constexpr unsigned int mmCRTC0_CRTC_EXT_TIMING_SYNC_WINDOW_END__VI      = 0x1BE3;
constexpr unsigned int mmCRTC0_CRTC_EXT_TIMING_SYNC_WINDOW_START__VI    = 0x1BE2;
constexpr unsigned int mmCRTC0_CRTC_FIELD_INDICATION_CONTROL__VI        = 0x1BA0;
constexpr unsigned int mmCRTC0_CRTC_GSL_CONTROL__VI                     = 0x1B7B;
constexpr unsigned int mmCRTC0_CRTC_GSL_VSYNC_GAP__VI                   = 0x1B79;
constexpr unsigned int mmCRTC0_CRTC_GSL_WINDOW__VI                      = 0x1B7A;
constexpr unsigned int mmCRTC0_CRTC_H_BLANK_EARLY_NUM__VI               = 0x1B7D;
constexpr unsigned int mmCRTC0_CRTC_OVERSCAN_COLOR__VI                  = 0x1BC8;
constexpr unsigned int mmCRTC0_CRTC_OVERSCAN_COLOR_EXT__VI              = 0x1BC9;
constexpr unsigned int mmCRTC0_CRTC_PIXEL_DATA_READBACK0__VI            = 0x1BA1;
constexpr unsigned int mmCRTC0_CRTC_PIXEL_DATA_READBACK1__VI            = 0x1BA2;
constexpr unsigned int mmCRTC0_CRTC_STATIC_SCREEN_CONTROL__VI           = 0x1BE7;
constexpr unsigned int mmCRTC0_CRTC_STEREO_FORCE_NEXT_EYE__VI           = 0x1B9A;
constexpr unsigned int mmCRTC0_CRTC_VERTICAL_INTERRUPT0_CONTROL__VI     = 0x1BCF;
constexpr unsigned int mmCRTC0_CRTC_VERTICAL_INTERRUPT0_POSITION__VI    = 0x1BCE;
constexpr unsigned int mmCRTC0_CRTC_VERTICAL_INTERRUPT1_CONTROL__VI     = 0x1BD1;
constexpr unsigned int mmCRTC0_CRTC_VERTICAL_INTERRUPT1_POSITION__VI    = 0x1BD0;
constexpr unsigned int mmCRTC0_CRTC_VERTICAL_INTERRUPT2_CONTROL__VI     = 0x1BD3;
constexpr unsigned int mmCRTC0_CRTC_VERTICAL_INTERRUPT2_POSITION__VI    = 0x1BD2;
constexpr unsigned int mmCRTC0_DCFE_DBG_SEL__VI                         = 0x1B7E;
constexpr unsigned int mmCRTC0_DCFE_MEM_PWR_CTRL__VI                    = 0x1B7F;
constexpr unsigned int mmCRTC0_DCFE_MEM_PWR_CTRL2__VI                   = 0x1BB8;
constexpr unsigned int mmCRTC0_DCFE_MEM_PWR_STATUS__VI                  = 0x1BB9;
constexpr unsigned int mmCRTC0_PIXEL_RATE_CNTL__VI                      = 0x0140;
constexpr unsigned int mmCRTC1_CRTC_3D_STRUCTURE_CONTROL__VI            = 0x1D78;
constexpr unsigned int mmCRTC1_CRTC_ALLOW_STOP_OFF_V_CNT__VI            = 0x1DC3;
constexpr unsigned int mmCRTC1_CRTC_AVSYNC_COUNTER__VI                  = 0x1D9B;
constexpr unsigned int mmCRTC1_CRTC_BLACK_COLOR__VI                     = 0x1DCC;
constexpr unsigned int mmCRTC1_CRTC_BLACK_COLOR_EXT__VI                 = 0x1DCD;
constexpr unsigned int mmCRTC1_CRTC_BLANK_CONTROL__SI__CI               = 0x1E9D;
constexpr unsigned int mmCRTC1_CRTC_BLANK_CONTROL__VI                   = 0x1D9D;
constexpr unsigned int mmCRTC1_CRTC_BLANK_DATA_COLOR__VI                = 0x1DCA;
constexpr unsigned int mmCRTC1_CRTC_BLANK_DATA_COLOR_EXT__VI            = 0x1DCB;
constexpr unsigned int mmCRTC1_CRTC_CONTROL__VI                         = 0x1D9C;
constexpr unsigned int mmCRTC1_CRTC_COUNT_CONTROL__VI                   = 0x1DA9;
constexpr unsigned int mmCRTC1_CRTC_COUNT_RESET__VI                     = 0x1DAA;
constexpr unsigned int mmCRTC1_CRTC_CRC0_DATA_B__VI                     = 0x1DDA;
constexpr unsigned int mmCRTC1_CRTC_CRC0_DATA_RG__VI                    = 0x1DD9;
constexpr unsigned int mmCRTC1_CRTC_CRC0_WINDOWA_X_CONTROL__VI          = 0x1DD5;
constexpr unsigned int mmCRTC1_CRTC_CRC0_WINDOWA_Y_CONTROL__VI          = 0x1DD6;
constexpr unsigned int mmCRTC1_CRTC_CRC0_WINDOWB_X_CONTROL__VI          = 0x1DD7;
constexpr unsigned int mmCRTC1_CRTC_CRC0_WINDOWB_Y_CONTROL__VI          = 0x1DD8;
constexpr unsigned int mmCRTC1_CRTC_CRC1_DATA_B__VI                     = 0x1DE0;
constexpr unsigned int mmCRTC1_CRTC_CRC1_DATA_RG__VI                    = 0x1DDF;
constexpr unsigned int mmCRTC1_CRTC_CRC1_WINDOWA_X_CONTROL__VI          = 0x1DDB;
constexpr unsigned int mmCRTC1_CRTC_CRC1_WINDOWA_Y_CONTROL__VI          = 0x1DDC;
constexpr unsigned int mmCRTC1_CRTC_CRC1_WINDOWB_X_CONTROL__VI          = 0x1DDD;
constexpr unsigned int mmCRTC1_CRTC_CRC1_WINDOWB_Y_CONTROL__VI          = 0x1DDE;
constexpr unsigned int mmCRTC1_CRTC_CRC_CNTL__VI                        = 0x1DD4;
constexpr unsigned int mmCRTC1_CRTC_DCFE_CLOCK_CONTROL__VI              = 0x1D7C;
constexpr unsigned int mmCRTC1_CRTC_DOUBLE_BUFFER_CONTROL__VI           = 0x1DB6;
constexpr unsigned int mmCRTC1_CRTC_DTMTEST_CNTL__VI                    = 0x1D92;
constexpr unsigned int mmCRTC1_CRTC_DTMTEST_STATUS_POSITION__VI         = 0x1D93;
constexpr unsigned int mmCRTC1_CRTC_EXT_TIMING_SYNC_CONTROL__VI         = 0x1DE1;
constexpr unsigned int mmCRTC1_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL__VI  = 0x1DE5;
constexpr unsigned int mmCRTC1_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL__VI  = 0x1DE4;
constexpr unsigned int mmCRTC1_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL__VI  = 0x1DE6;
constexpr unsigned int mmCRTC1_CRTC_EXT_TIMING_SYNC_WINDOW_END__VI      = 0x1DE3;
constexpr unsigned int mmCRTC1_CRTC_EXT_TIMING_SYNC_WINDOW_START__VI    = 0x1DE2;
constexpr unsigned int mmCRTC1_CRTC_FIELD_INDICATION_CONTROL__VI        = 0x1DA0;
constexpr unsigned int mmCRTC1_CRTC_FLOW_CONTROL__VI                    = 0x1D99;
constexpr unsigned int mmCRTC1_CRTC_FORCE_COUNT_NOW_CNTL__VI            = 0x1D98;
constexpr unsigned int mmCRTC1_CRTC_GSL_CONTROL__VI                     = 0x1D7B;
constexpr unsigned int mmCRTC1_CRTC_GSL_VSYNC_GAP__VI                   = 0x1D79;
constexpr unsigned int mmCRTC1_CRTC_GSL_WINDOW__VI                      = 0x1D7A;
constexpr unsigned int mmCRTC1_CRTC_H_BLANK_EARLY_NUM__VI               = 0x1D7D;
constexpr unsigned int mmCRTC1_CRTC_H_BLANK_START_END__VI               = 0x1D81;
constexpr unsigned int mmCRTC1_CRTC_H_SYNC_A__VI                        = 0x1D82;
constexpr unsigned int mmCRTC1_CRTC_H_SYNC_A_CNTL__VI                   = 0x1D83;
constexpr unsigned int mmCRTC1_CRTC_H_SYNC_B__VI                        = 0x1D84;
constexpr unsigned int mmCRTC1_CRTC_H_SYNC_B_CNTL__VI                   = 0x1D85;
constexpr unsigned int mmCRTC1_CRTC_H_TOTAL__VI                         = 0x1D80;
constexpr unsigned int mmCRTC1_CRTC_INTERLACE_CONTROL__VI               = 0x1D9E;
constexpr unsigned int mmCRTC1_CRTC_INTERLACE_STATUS__VI                = 0x1D9F;
constexpr unsigned int mmCRTC1_CRTC_INTERRUPT_CONTROL__VI               = 0x1DB4;
constexpr unsigned int mmCRTC1_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE__VI    = 0x1DAB;
constexpr unsigned int mmCRTC1_CRTC_MASTER_EN__VI                       = 0x1DC2;
constexpr unsigned int mmCRTC1_CRTC_MVP_INBAND_CNTL_INSERT__VI          = 0x1DBF;
constexpr unsigned int mmCRTC1_CRTC_MVP_INBAND_CNTL_INSERT_TIMER__VI    = 0x1DC0;
constexpr unsigned int mmCRTC1_CRTC_MVP_STATUS__VI                      = 0x1DC1;
constexpr unsigned int mmCRTC1_CRTC_NOM_VERT_POSITION__VI               = 0x1DA5;
constexpr unsigned int mmCRTC1_CRTC_OVERSCAN_COLOR__VI                  = 0x1DC8;
constexpr unsigned int mmCRTC1_CRTC_OVERSCAN_COLOR_EXT__VI              = 0x1DC9;
constexpr unsigned int mmCRTC1_CRTC_PIXEL_DATA_READBACK0__VI            = 0x1DA1;
constexpr unsigned int mmCRTC1_CRTC_PIXEL_DATA_READBACK1__VI            = 0x1DA2;
constexpr unsigned int mmCRTC1_CRTC_SNAPSHOT_CONTROL__VI                = 0x1DB0;
constexpr unsigned int mmCRTC1_CRTC_SNAPSHOT_FRAME__VI                  = 0x1DB2;
constexpr unsigned int mmCRTC1_CRTC_SNAPSHOT_POSITION__VI               = 0x1DB1;
constexpr unsigned int mmCRTC1_CRTC_SNAPSHOT_STATUS__VI                 = 0x1DAF;
constexpr unsigned int mmCRTC1_CRTC_START_LINE_CONTROL__VI              = 0x1DB3;
constexpr unsigned int mmCRTC1_CRTC_STATIC_SCREEN_CONTROL__VI           = 0x1DE7;
constexpr unsigned int mmCRTC1_CRTC_STATUS__SI__CI                      = 0x1EA3;
constexpr unsigned int mmCRTC1_CRTC_STATUS__VI                          = 0x1DA3;
constexpr unsigned int mmCRTC1_CRTC_STATUS_FRAME_COUNT__VI              = 0x1DA6;
constexpr unsigned int mmCRTC1_CRTC_STATUS_HV_COUNT__VI                 = 0x1DA8;
constexpr unsigned int mmCRTC1_CRTC_STATUS_POSITION__SI__CI             = 0x1EA4;
constexpr unsigned int mmCRTC1_CRTC_STATUS_POSITION__VI                 = 0x1DA4;
constexpr unsigned int mmCRTC1_CRTC_STATUS_VF_COUNT__VI                 = 0x1DA7;
constexpr unsigned int mmCRTC1_CRTC_STEREO_CONTROL__VI                  = 0x1DAE;
constexpr unsigned int mmCRTC1_CRTC_STEREO_FORCE_NEXT_EYE__VI           = 0x1D9A;
constexpr unsigned int mmCRTC1_CRTC_STEREO_STATUS__VI                   = 0x1DAD;
constexpr unsigned int mmCRTC1_CRTC_TEST_DEBUG_DATA__VI                 = 0x1DC7;
constexpr unsigned int mmCRTC1_CRTC_TEST_DEBUG_INDEX__VI                = 0x1DC6;
constexpr unsigned int mmCRTC1_CRTC_TEST_PATTERN_COLOR__VI              = 0x1DBC;
constexpr unsigned int mmCRTC1_CRTC_TEST_PATTERN_CONTROL__VI            = 0x1DBA;
constexpr unsigned int mmCRTC1_CRTC_TEST_PATTERN_PARAMETERS__VI         = 0x1DBB;
constexpr unsigned int mmCRTC1_CRTC_TRIGA_CNTL__VI                      = 0x1D94;
constexpr unsigned int mmCRTC1_CRTC_TRIGA_MANUAL_TRIG__VI               = 0x1D95;
constexpr unsigned int mmCRTC1_CRTC_TRIGB_CNTL__VI                      = 0x1D96;
constexpr unsigned int mmCRTC1_CRTC_TRIGB_MANUAL_TRIG__VI               = 0x1D97;
constexpr unsigned int mmCRTC1_CRTC_UPDATE_LOCK__VI                     = 0x1DB5;
constexpr unsigned int mmCRTC1_CRTC_VBI_END__VI                         = 0x1D86;
constexpr unsigned int mmCRTC1_CRTC_VERTICAL_INTERRUPT0_CONTROL__VI     = 0x1DCF;
constexpr unsigned int mmCRTC1_CRTC_VERTICAL_INTERRUPT0_POSITION__VI    = 0x1DCE;
constexpr unsigned int mmCRTC1_CRTC_VERTICAL_INTERRUPT1_CONTROL__VI     = 0x1DD1;
constexpr unsigned int mmCRTC1_CRTC_VERTICAL_INTERRUPT1_POSITION__VI    = 0x1DD0;
constexpr unsigned int mmCRTC1_CRTC_VERTICAL_INTERRUPT2_CONTROL__VI     = 0x1DD3;
constexpr unsigned int mmCRTC1_CRTC_VERTICAL_INTERRUPT2_POSITION__VI    = 0x1DD2;
constexpr unsigned int mmCRTC1_CRTC_VERT_SYNC_CONTROL__VI               = 0x1DAC;
constexpr unsigned int mmCRTC1_CRTC_VGA_PARAMETER_CAPTURE_MODE__VI      = 0x1DB7;
constexpr unsigned int mmCRTC1_CRTC_VSYNC_NOM_INT_STATUS__VI            = 0x1D8C;
constexpr unsigned int mmCRTC1_CRTC_V_BLANK_START_END__VI               = 0x1D8D;
constexpr unsigned int mmCRTC1_CRTC_V_SYNC_A__VI                        = 0x1D8E;
constexpr unsigned int mmCRTC1_CRTC_V_SYNC_A_CNTL__VI                   = 0x1D8F;
constexpr unsigned int mmCRTC1_CRTC_V_SYNC_B__VI                        = 0x1D90;
constexpr unsigned int mmCRTC1_CRTC_V_SYNC_B_CNTL__VI                   = 0x1D91;
constexpr unsigned int mmCRTC1_CRTC_V_TOTAL__VI                         = 0x1D87;
constexpr unsigned int mmCRTC1_CRTC_V_TOTAL_CONTROL__VI                 = 0x1D8A;
constexpr unsigned int mmCRTC1_CRTC_V_TOTAL_INT_STATUS__VI              = 0x1D8B;
constexpr unsigned int mmCRTC1_CRTC_V_TOTAL_MAX__VI                     = 0x1D89;
constexpr unsigned int mmCRTC1_CRTC_V_TOTAL_MIN__VI                     = 0x1D88;
constexpr unsigned int mmCRTC1_CRTC_V_UPDATE_INT_STATUS__VI             = 0x1DC4;
constexpr unsigned int mmCRTC1_DCFE_DBG_SEL__VI                         = 0x1D7E;
constexpr unsigned int mmCRTC1_DCFE_MEM_PWR_CTRL__VI                    = 0x1D7F;
constexpr unsigned int mmCRTC1_DCFE_MEM_PWR_CTRL2__VI                   = 0x1DB8;
constexpr unsigned int mmCRTC1_DCFE_MEM_PWR_STATUS__VI                  = 0x1DB9;
constexpr unsigned int mmCRTC1_MASTER_UPDATE_LOCK__VI                   = 0x1DBD;
constexpr unsigned int mmCRTC1_MASTER_UPDATE_MODE__SI__CI               = 0x1EBE;
constexpr unsigned int mmCRTC1_MASTER_UPDATE_MODE__VI                   = 0x1DBE;
constexpr unsigned int mmCRTC1_PIXEL_RATE_CNTL__VI                      = 0x0144;
constexpr unsigned int mmCRTC2_CRTC_3D_STRUCTURE_CONTROL__VI            = 0x1F78;
constexpr unsigned int mmCRTC2_CRTC_ALLOW_STOP_OFF_V_CNT__VI            = 0x1FC3;
constexpr unsigned int mmCRTC2_CRTC_AVSYNC_COUNTER__VI                  = 0x1F9B;
constexpr unsigned int mmCRTC2_CRTC_BLACK_COLOR__VI                     = 0x1FCC;
constexpr unsigned int mmCRTC2_CRTC_BLACK_COLOR_EXT__VI                 = 0x1FCD;
constexpr unsigned int mmCRTC2_CRTC_BLANK_CONTROL__SI__CI               = 0x419D;
constexpr unsigned int mmCRTC2_CRTC_BLANK_CONTROL__VI                   = 0x1F9D;
constexpr unsigned int mmCRTC2_CRTC_BLANK_DATA_COLOR__VI                = 0x1FCA;
constexpr unsigned int mmCRTC2_CRTC_BLANK_DATA_COLOR_EXT__VI            = 0x1FCB;
constexpr unsigned int mmCRTC2_CRTC_CONTROL__VI                         = 0x1F9C;
constexpr unsigned int mmCRTC2_CRTC_COUNT_CONTROL__VI                   = 0x1FA9;
constexpr unsigned int mmCRTC2_CRTC_COUNT_RESET__VI                     = 0x1FAA;
constexpr unsigned int mmCRTC2_CRTC_CRC0_DATA_B__VI                     = 0x1FDA;
constexpr unsigned int mmCRTC2_CRTC_CRC0_DATA_RG__VI                    = 0x1FD9;
constexpr unsigned int mmCRTC2_CRTC_CRC0_WINDOWA_X_CONTROL__VI          = 0x1FD5;
constexpr unsigned int mmCRTC2_CRTC_CRC0_WINDOWA_Y_CONTROL__VI          = 0x1FD6;
constexpr unsigned int mmCRTC2_CRTC_CRC0_WINDOWB_X_CONTROL__VI          = 0x1FD7;
constexpr unsigned int mmCRTC2_CRTC_CRC0_WINDOWB_Y_CONTROL__VI          = 0x1FD8;
constexpr unsigned int mmCRTC2_CRTC_CRC1_DATA_B__VI                     = 0x1FE0;
constexpr unsigned int mmCRTC2_CRTC_CRC1_DATA_RG__VI                    = 0x1FDF;
constexpr unsigned int mmCRTC2_CRTC_CRC1_WINDOWA_X_CONTROL__VI          = 0x1FDB;
constexpr unsigned int mmCRTC2_CRTC_CRC1_WINDOWA_Y_CONTROL__VI          = 0x1FDC;
constexpr unsigned int mmCRTC2_CRTC_CRC1_WINDOWB_X_CONTROL__VI          = 0x1FDD;
constexpr unsigned int mmCRTC2_CRTC_CRC1_WINDOWB_Y_CONTROL__VI          = 0x1FDE;
constexpr unsigned int mmCRTC2_CRTC_CRC_CNTL__VI                        = 0x1FD4;
constexpr unsigned int mmCRTC2_CRTC_DCFE_CLOCK_CONTROL__VI              = 0x1F7C;
constexpr unsigned int mmCRTC2_CRTC_DOUBLE_BUFFER_CONTROL__VI           = 0x1FB6;
constexpr unsigned int mmCRTC2_CRTC_DTMTEST_CNTL__VI                    = 0x1F92;
constexpr unsigned int mmCRTC2_CRTC_DTMTEST_STATUS_POSITION__VI         = 0x1F93;
constexpr unsigned int mmCRTC2_CRTC_EXT_TIMING_SYNC_CONTROL__VI         = 0x1FE1;
constexpr unsigned int mmCRTC2_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL__VI  = 0x1FE5;
constexpr unsigned int mmCRTC2_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL__VI  = 0x1FE4;
constexpr unsigned int mmCRTC2_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL__VI  = 0x1FE6;
constexpr unsigned int mmCRTC2_CRTC_EXT_TIMING_SYNC_WINDOW_END__VI      = 0x1FE3;
constexpr unsigned int mmCRTC2_CRTC_EXT_TIMING_SYNC_WINDOW_START__VI    = 0x1FE2;
constexpr unsigned int mmCRTC2_CRTC_FIELD_INDICATION_CONTROL__VI        = 0x1FA0;
constexpr unsigned int mmCRTC2_CRTC_FLOW_CONTROL__VI                    = 0x1F99;
constexpr unsigned int mmCRTC2_CRTC_FORCE_COUNT_NOW_CNTL__VI            = 0x1F98;
constexpr unsigned int mmCRTC2_CRTC_GSL_CONTROL__VI                     = 0x1F7B;
constexpr unsigned int mmCRTC2_CRTC_GSL_VSYNC_GAP__VI                   = 0x1F79;
constexpr unsigned int mmCRTC2_CRTC_GSL_WINDOW__VI                      = 0x1F7A;
constexpr unsigned int mmCRTC2_CRTC_H_BLANK_EARLY_NUM__VI               = 0x1F7D;
constexpr unsigned int mmCRTC2_CRTC_H_BLANK_START_END__VI               = 0x1F81;
constexpr unsigned int mmCRTC2_CRTC_H_SYNC_A__VI                        = 0x1F82;
constexpr unsigned int mmCRTC2_CRTC_H_SYNC_A_CNTL__VI                   = 0x1F83;
constexpr unsigned int mmCRTC2_CRTC_H_SYNC_B__VI                        = 0x1F84;
constexpr unsigned int mmCRTC2_CRTC_H_SYNC_B_CNTL__VI                   = 0x1F85;
constexpr unsigned int mmCRTC2_CRTC_H_TOTAL__VI                         = 0x1F80;
constexpr unsigned int mmCRTC2_CRTC_INTERLACE_CONTROL__VI               = 0x1F9E;
constexpr unsigned int mmCRTC2_CRTC_INTERLACE_STATUS__VI                = 0x1F9F;
constexpr unsigned int mmCRTC2_CRTC_INTERRUPT_CONTROL__VI               = 0x1FB4;
constexpr unsigned int mmCRTC2_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE__VI    = 0x1FAB;
constexpr unsigned int mmCRTC2_CRTC_MASTER_EN__VI                       = 0x1FC2;
constexpr unsigned int mmCRTC2_CRTC_MVP_INBAND_CNTL_INSERT__VI          = 0x1FBF;
constexpr unsigned int mmCRTC2_CRTC_MVP_INBAND_CNTL_INSERT_TIMER__VI    = 0x1FC0;
constexpr unsigned int mmCRTC2_CRTC_MVP_STATUS__VI                      = 0x1FC1;
constexpr unsigned int mmCRTC2_CRTC_NOM_VERT_POSITION__VI               = 0x1FA5;
constexpr unsigned int mmCRTC2_CRTC_OVERSCAN_COLOR__VI                  = 0x1FC8;
constexpr unsigned int mmCRTC2_CRTC_OVERSCAN_COLOR_EXT__VI              = 0x1FC9;
constexpr unsigned int mmCRTC2_CRTC_PIXEL_DATA_READBACK0__VI            = 0x1FA1;
constexpr unsigned int mmCRTC2_CRTC_PIXEL_DATA_READBACK1__VI            = 0x1FA2;
constexpr unsigned int mmCRTC2_CRTC_SNAPSHOT_CONTROL__VI                = 0x1FB0;
constexpr unsigned int mmCRTC2_CRTC_SNAPSHOT_FRAME__VI                  = 0x1FB2;
constexpr unsigned int mmCRTC2_CRTC_SNAPSHOT_POSITION__VI               = 0x1FB1;
constexpr unsigned int mmCRTC2_CRTC_SNAPSHOT_STATUS__VI                 = 0x1FAF;
constexpr unsigned int mmCRTC2_CRTC_START_LINE_CONTROL__VI              = 0x1FB3;
constexpr unsigned int mmCRTC2_CRTC_STATIC_SCREEN_CONTROL__VI           = 0x1FE7;
constexpr unsigned int mmCRTC2_CRTC_STATUS__SI__CI                      = 0x41A3;
constexpr unsigned int mmCRTC2_CRTC_STATUS__VI                          = 0x1FA3;
constexpr unsigned int mmCRTC2_CRTC_STATUS_FRAME_COUNT__VI              = 0x1FA6;
constexpr unsigned int mmCRTC2_CRTC_STATUS_HV_COUNT__VI                 = 0x1FA8;
constexpr unsigned int mmCRTC2_CRTC_STATUS_POSITION__SI__CI             = 0x41A4;
constexpr unsigned int mmCRTC2_CRTC_STATUS_POSITION__VI                 = 0x1FA4;
constexpr unsigned int mmCRTC2_CRTC_STATUS_VF_COUNT__VI                 = 0x1FA7;
constexpr unsigned int mmCRTC2_CRTC_STEREO_CONTROL__VI                  = 0x1FAE;
constexpr unsigned int mmCRTC2_CRTC_STEREO_FORCE_NEXT_EYE__VI           = 0x1F9A;
constexpr unsigned int mmCRTC2_CRTC_STEREO_STATUS__VI                   = 0x1FAD;
constexpr unsigned int mmCRTC2_CRTC_TEST_DEBUG_DATA__VI                 = 0x1FC7;
constexpr unsigned int mmCRTC2_CRTC_TEST_DEBUG_INDEX__VI                = 0x1FC6;
constexpr unsigned int mmCRTC2_CRTC_TEST_PATTERN_COLOR__VI              = 0x1FBC;
constexpr unsigned int mmCRTC2_CRTC_TEST_PATTERN_CONTROL__VI            = 0x1FBA;
constexpr unsigned int mmCRTC2_CRTC_TEST_PATTERN_PARAMETERS__VI         = 0x1FBB;
constexpr unsigned int mmCRTC2_CRTC_TRIGA_CNTL__VI                      = 0x1F94;
constexpr unsigned int mmCRTC2_CRTC_TRIGA_MANUAL_TRIG__VI               = 0x1F95;
constexpr unsigned int mmCRTC2_CRTC_TRIGB_CNTL__VI                      = 0x1F96;
constexpr unsigned int mmCRTC2_CRTC_TRIGB_MANUAL_TRIG__VI               = 0x1F97;
constexpr unsigned int mmCRTC2_CRTC_UPDATE_LOCK__VI                     = 0x1FB5;
constexpr unsigned int mmCRTC2_CRTC_VBI_END__VI                         = 0x1F86;
constexpr unsigned int mmCRTC2_CRTC_VERTICAL_INTERRUPT0_CONTROL__VI     = 0x1FCF;
constexpr unsigned int mmCRTC2_CRTC_VERTICAL_INTERRUPT0_POSITION__VI    = 0x1FCE;
constexpr unsigned int mmCRTC2_CRTC_VERTICAL_INTERRUPT1_CONTROL__VI     = 0x1FD1;
constexpr unsigned int mmCRTC2_CRTC_VERTICAL_INTERRUPT1_POSITION__VI    = 0x1FD0;
constexpr unsigned int mmCRTC2_CRTC_VERTICAL_INTERRUPT2_CONTROL__VI     = 0x1FD3;
constexpr unsigned int mmCRTC2_CRTC_VERTICAL_INTERRUPT2_POSITION__VI    = 0x1FD2;
constexpr unsigned int mmCRTC2_CRTC_VERT_SYNC_CONTROL__VI               = 0x1FAC;
constexpr unsigned int mmCRTC2_CRTC_VGA_PARAMETER_CAPTURE_MODE__VI      = 0x1FB7;
constexpr unsigned int mmCRTC2_CRTC_VSYNC_NOM_INT_STATUS__VI            = 0x1F8C;
constexpr unsigned int mmCRTC2_CRTC_V_BLANK_START_END__VI               = 0x1F8D;
constexpr unsigned int mmCRTC2_CRTC_V_SYNC_A__VI                        = 0x1F8E;
constexpr unsigned int mmCRTC2_CRTC_V_SYNC_A_CNTL__VI                   = 0x1F8F;
constexpr unsigned int mmCRTC2_CRTC_V_SYNC_B__VI                        = 0x1F90;
constexpr unsigned int mmCRTC2_CRTC_V_SYNC_B_CNTL__VI                   = 0x1F91;
constexpr unsigned int mmCRTC2_CRTC_V_TOTAL__VI                         = 0x1F87;
constexpr unsigned int mmCRTC2_CRTC_V_TOTAL_CONTROL__VI                 = 0x1F8A;
constexpr unsigned int mmCRTC2_CRTC_V_TOTAL_INT_STATUS__VI              = 0x1F8B;
constexpr unsigned int mmCRTC2_CRTC_V_TOTAL_MAX__VI                     = 0x1F89;
constexpr unsigned int mmCRTC2_CRTC_V_TOTAL_MIN__VI                     = 0x1F88;
constexpr unsigned int mmCRTC2_CRTC_V_UPDATE_INT_STATUS__VI             = 0x1FC4;
constexpr unsigned int mmCRTC2_DCFE_DBG_SEL__VI                         = 0x1F7E;
constexpr unsigned int mmCRTC2_DCFE_MEM_PWR_CTRL__VI                    = 0x1F7F;
constexpr unsigned int mmCRTC2_DCFE_MEM_PWR_CTRL2__VI                   = 0x1FB8;
constexpr unsigned int mmCRTC2_DCFE_MEM_PWR_STATUS__VI                  = 0x1FB9;
constexpr unsigned int mmCRTC2_MASTER_UPDATE_LOCK__VI                   = 0x1FBD;
constexpr unsigned int mmCRTC2_MASTER_UPDATE_MODE__SI__CI               = 0x41BE;
constexpr unsigned int mmCRTC2_MASTER_UPDATE_MODE__VI                   = 0x1FBE;
constexpr unsigned int mmCRTC2_PIXEL_RATE_CNTL__VI                      = 0x0148;
constexpr unsigned int mmCRTC3_CRTC_3D_STRUCTURE_CONTROL__VI            = 0x4178;
constexpr unsigned int mmCRTC3_CRTC_ALLOW_STOP_OFF_V_CNT__VI            = 0x41C3;
constexpr unsigned int mmCRTC3_CRTC_AVSYNC_COUNTER__VI                  = 0x419B;
constexpr unsigned int mmCRTC3_CRTC_BLACK_COLOR__VI                     = 0x41CC;
constexpr unsigned int mmCRTC3_CRTC_BLACK_COLOR_EXT__VI                 = 0x41CD;
constexpr unsigned int mmCRTC3_CRTC_BLANK_CONTROL__SI__CI               = 0x449D;
constexpr unsigned int mmCRTC3_CRTC_BLANK_CONTROL__VI                   = 0x419D;
constexpr unsigned int mmCRTC3_CRTC_BLANK_DATA_COLOR__VI                = 0x41CA;
constexpr unsigned int mmCRTC3_CRTC_BLANK_DATA_COLOR_EXT__VI            = 0x41CB;
constexpr unsigned int mmCRTC3_CRTC_CONTROL__VI                         = 0x419C;
constexpr unsigned int mmCRTC3_CRTC_COUNT_CONTROL__VI                   = 0x41A9;
constexpr unsigned int mmCRTC3_CRTC_COUNT_RESET__VI                     = 0x41AA;
constexpr unsigned int mmCRTC3_CRTC_CRC0_DATA_B__VI                     = 0x41DA;
constexpr unsigned int mmCRTC3_CRTC_CRC0_DATA_RG__VI                    = 0x41D9;
constexpr unsigned int mmCRTC3_CRTC_CRC0_WINDOWA_X_CONTROL__VI          = 0x41D5;
constexpr unsigned int mmCRTC3_CRTC_CRC0_WINDOWA_Y_CONTROL__VI          = 0x41D6;
constexpr unsigned int mmCRTC3_CRTC_CRC0_WINDOWB_X_CONTROL__VI          = 0x41D7;
constexpr unsigned int mmCRTC3_CRTC_CRC0_WINDOWB_Y_CONTROL__VI          = 0x41D8;
constexpr unsigned int mmCRTC3_CRTC_CRC1_DATA_B__VI                     = 0x41E0;
constexpr unsigned int mmCRTC3_CRTC_CRC1_DATA_RG__VI                    = 0x41DF;
constexpr unsigned int mmCRTC3_CRTC_CRC1_WINDOWA_X_CONTROL__VI          = 0x41DB;
constexpr unsigned int mmCRTC3_CRTC_CRC1_WINDOWA_Y_CONTROL__VI          = 0x41DC;
constexpr unsigned int mmCRTC3_CRTC_CRC1_WINDOWB_X_CONTROL__VI          = 0x41DD;
constexpr unsigned int mmCRTC3_CRTC_CRC1_WINDOWB_Y_CONTROL__VI          = 0x41DE;
constexpr unsigned int mmCRTC3_CRTC_CRC_CNTL__VI                        = 0x41D4;
constexpr unsigned int mmCRTC3_CRTC_DCFE_CLOCK_CONTROL__VI              = 0x417C;
constexpr unsigned int mmCRTC3_CRTC_DOUBLE_BUFFER_CONTROL__VI           = 0x41B6;
constexpr unsigned int mmCRTC3_CRTC_DTMTEST_CNTL__VI                    = 0x4192;
constexpr unsigned int mmCRTC3_CRTC_DTMTEST_STATUS_POSITION__VI         = 0x4193;
constexpr unsigned int mmCRTC3_CRTC_EXT_TIMING_SYNC_CONTROL__VI         = 0x41E1;
constexpr unsigned int mmCRTC3_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL__VI  = 0x41E5;
constexpr unsigned int mmCRTC3_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL__VI  = 0x41E4;
constexpr unsigned int mmCRTC3_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL__VI  = 0x41E6;
constexpr unsigned int mmCRTC3_CRTC_EXT_TIMING_SYNC_WINDOW_END__VI      = 0x41E3;
constexpr unsigned int mmCRTC3_CRTC_EXT_TIMING_SYNC_WINDOW_START__VI    = 0x41E2;
constexpr unsigned int mmCRTC3_CRTC_FIELD_INDICATION_CONTROL__VI        = 0x41A0;
constexpr unsigned int mmCRTC3_CRTC_FLOW_CONTROL__VI                    = 0x4199;
constexpr unsigned int mmCRTC3_CRTC_FORCE_COUNT_NOW_CNTL__VI            = 0x4198;
constexpr unsigned int mmCRTC3_CRTC_GSL_CONTROL__VI                     = 0x417B;
constexpr unsigned int mmCRTC3_CRTC_GSL_VSYNC_GAP__VI                   = 0x4179;
constexpr unsigned int mmCRTC3_CRTC_GSL_WINDOW__VI                      = 0x417A;
constexpr unsigned int mmCRTC3_CRTC_H_BLANK_EARLY_NUM__VI               = 0x417D;
constexpr unsigned int mmCRTC3_CRTC_H_BLANK_START_END__VI               = 0x4181;
constexpr unsigned int mmCRTC3_CRTC_H_SYNC_A__VI                        = 0x4182;
constexpr unsigned int mmCRTC3_CRTC_H_SYNC_A_CNTL__VI                   = 0x4183;
constexpr unsigned int mmCRTC3_CRTC_H_SYNC_B__VI                        = 0x4184;
constexpr unsigned int mmCRTC3_CRTC_H_SYNC_B_CNTL__VI                   = 0x4185;
constexpr unsigned int mmCRTC3_CRTC_H_TOTAL__VI                         = 0x4180;
constexpr unsigned int mmCRTC3_CRTC_INTERLACE_CONTROL__VI               = 0x419E;
constexpr unsigned int mmCRTC3_CRTC_INTERLACE_STATUS__VI                = 0x419F;
constexpr unsigned int mmCRTC3_CRTC_INTERRUPT_CONTROL__VI               = 0x41B4;
constexpr unsigned int mmCRTC3_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE__VI    = 0x41AB;
constexpr unsigned int mmCRTC3_CRTC_MASTER_EN__VI                       = 0x41C2;
constexpr unsigned int mmCRTC3_CRTC_MVP_INBAND_CNTL_INSERT__VI          = 0x41BF;
constexpr unsigned int mmCRTC3_CRTC_MVP_INBAND_CNTL_INSERT_TIMER__VI    = 0x41C0;
constexpr unsigned int mmCRTC3_CRTC_MVP_STATUS__VI                      = 0x41C1;
constexpr unsigned int mmCRTC3_CRTC_NOM_VERT_POSITION__VI               = 0x41A5;
constexpr unsigned int mmCRTC3_CRTC_OVERSCAN_COLOR__VI                  = 0x41C8;
constexpr unsigned int mmCRTC3_CRTC_OVERSCAN_COLOR_EXT__VI              = 0x41C9;
constexpr unsigned int mmCRTC3_CRTC_PIXEL_DATA_READBACK0__VI            = 0x41A1;
constexpr unsigned int mmCRTC3_CRTC_PIXEL_DATA_READBACK1__VI            = 0x41A2;
constexpr unsigned int mmCRTC3_CRTC_SNAPSHOT_CONTROL__VI                = 0x41B0;
constexpr unsigned int mmCRTC3_CRTC_SNAPSHOT_FRAME__VI                  = 0x41B2;
constexpr unsigned int mmCRTC3_CRTC_SNAPSHOT_POSITION__VI               = 0x41B1;
constexpr unsigned int mmCRTC3_CRTC_SNAPSHOT_STATUS__VI                 = 0x41AF;
constexpr unsigned int mmCRTC3_CRTC_START_LINE_CONTROL__VI              = 0x41B3;
constexpr unsigned int mmCRTC3_CRTC_STATIC_SCREEN_CONTROL__VI           = 0x41E7;
constexpr unsigned int mmCRTC3_CRTC_STATUS__SI__CI                      = 0x44A3;
constexpr unsigned int mmCRTC3_CRTC_STATUS__VI                          = 0x41A3;
constexpr unsigned int mmCRTC3_CRTC_STATUS_FRAME_COUNT__VI              = 0x41A6;
constexpr unsigned int mmCRTC3_CRTC_STATUS_HV_COUNT__VI                 = 0x41A8;
constexpr unsigned int mmCRTC3_CRTC_STATUS_POSITION__SI__CI             = 0x44A4;
constexpr unsigned int mmCRTC3_CRTC_STATUS_POSITION__VI                 = 0x41A4;
constexpr unsigned int mmCRTC3_CRTC_STATUS_VF_COUNT__VI                 = 0x41A7;
constexpr unsigned int mmCRTC3_CRTC_STEREO_CONTROL__VI                  = 0x41AE;
constexpr unsigned int mmCRTC3_CRTC_STEREO_FORCE_NEXT_EYE__VI           = 0x419A;
constexpr unsigned int mmCRTC3_CRTC_STEREO_STATUS__VI                   = 0x41AD;
constexpr unsigned int mmCRTC3_CRTC_TEST_DEBUG_DATA__VI                 = 0x41C7;
constexpr unsigned int mmCRTC3_CRTC_TEST_DEBUG_INDEX__VI                = 0x41C6;
constexpr unsigned int mmCRTC3_CRTC_TEST_PATTERN_COLOR__VI              = 0x41BC;
constexpr unsigned int mmCRTC3_CRTC_TEST_PATTERN_CONTROL__VI            = 0x41BA;
constexpr unsigned int mmCRTC3_CRTC_TEST_PATTERN_PARAMETERS__VI         = 0x41BB;
constexpr unsigned int mmCRTC3_CRTC_TRIGA_CNTL__VI                      = 0x4194;
constexpr unsigned int mmCRTC3_CRTC_TRIGA_MANUAL_TRIG__VI               = 0x4195;
constexpr unsigned int mmCRTC3_CRTC_TRIGB_CNTL__VI                      = 0x4196;
constexpr unsigned int mmCRTC3_CRTC_TRIGB_MANUAL_TRIG__VI               = 0x4197;
constexpr unsigned int mmCRTC3_CRTC_UPDATE_LOCK__VI                     = 0x41B5;
constexpr unsigned int mmCRTC3_CRTC_VBI_END__VI                         = 0x4186;
constexpr unsigned int mmCRTC3_CRTC_VERTICAL_INTERRUPT0_CONTROL__VI     = 0x41CF;
constexpr unsigned int mmCRTC3_CRTC_VERTICAL_INTERRUPT0_POSITION__VI    = 0x41CE;
constexpr unsigned int mmCRTC3_CRTC_VERTICAL_INTERRUPT1_CONTROL__VI     = 0x41D1;
constexpr unsigned int mmCRTC3_CRTC_VERTICAL_INTERRUPT1_POSITION__VI    = 0x41D0;
constexpr unsigned int mmCRTC3_CRTC_VERTICAL_INTERRUPT2_CONTROL__VI     = 0x41D3;
constexpr unsigned int mmCRTC3_CRTC_VERTICAL_INTERRUPT2_POSITION__VI    = 0x41D2;
constexpr unsigned int mmCRTC3_CRTC_VERT_SYNC_CONTROL__VI               = 0x41AC;
constexpr unsigned int mmCRTC3_CRTC_VGA_PARAMETER_CAPTURE_MODE__VI      = 0x41B7;
constexpr unsigned int mmCRTC3_CRTC_VSYNC_NOM_INT_STATUS__VI            = 0x418C;
constexpr unsigned int mmCRTC3_CRTC_V_BLANK_START_END__VI               = 0x418D;
constexpr unsigned int mmCRTC3_CRTC_V_SYNC_A__VI                        = 0x418E;
constexpr unsigned int mmCRTC3_CRTC_V_SYNC_A_CNTL__VI                   = 0x418F;
constexpr unsigned int mmCRTC3_CRTC_V_SYNC_B__VI                        = 0x4190;
constexpr unsigned int mmCRTC3_CRTC_V_SYNC_B_CNTL__VI                   = 0x4191;
constexpr unsigned int mmCRTC3_CRTC_V_TOTAL__VI                         = 0x4187;
constexpr unsigned int mmCRTC3_CRTC_V_TOTAL_CONTROL__VI                 = 0x418A;
constexpr unsigned int mmCRTC3_CRTC_V_TOTAL_INT_STATUS__VI              = 0x418B;
constexpr unsigned int mmCRTC3_CRTC_V_TOTAL_MAX__VI                     = 0x4189;
constexpr unsigned int mmCRTC3_CRTC_V_TOTAL_MIN__VI                     = 0x4188;
constexpr unsigned int mmCRTC3_CRTC_V_UPDATE_INT_STATUS__VI             = 0x41C4;
constexpr unsigned int mmCRTC3_DCFE_DBG_SEL__VI                         = 0x417E;
constexpr unsigned int mmCRTC3_DCFE_MEM_PWR_CTRL__VI                    = 0x417F;
constexpr unsigned int mmCRTC3_DCFE_MEM_PWR_CTRL2__VI                   = 0x41B8;
constexpr unsigned int mmCRTC3_DCFE_MEM_PWR_STATUS__VI                  = 0x41B9;
constexpr unsigned int mmCRTC3_MASTER_UPDATE_LOCK__VI                   = 0x41BD;
constexpr unsigned int mmCRTC3_MASTER_UPDATE_MODE__SI__CI               = 0x44BE;
constexpr unsigned int mmCRTC3_MASTER_UPDATE_MODE__VI                   = 0x41BE;
constexpr unsigned int mmCRTC3_PIXEL_RATE_CNTL__VI                      = 0x014C;
constexpr unsigned int mmCRTC4_CRTC_3D_STRUCTURE_CONTROL__VI            = 0x4378;
constexpr unsigned int mmCRTC4_CRTC_ALLOW_STOP_OFF_V_CNT__VI            = 0x43C3;
constexpr unsigned int mmCRTC4_CRTC_AVSYNC_COUNTER__VI                  = 0x439B;
constexpr unsigned int mmCRTC4_CRTC_BLACK_COLOR__VI                     = 0x43CC;
constexpr unsigned int mmCRTC4_CRTC_BLACK_COLOR_EXT__VI                 = 0x43CD;
constexpr unsigned int mmCRTC4_CRTC_BLANK_CONTROL__SI__CI               = 0x479D;
constexpr unsigned int mmCRTC4_CRTC_BLANK_CONTROL__VI                   = 0x439D;
constexpr unsigned int mmCRTC4_CRTC_BLANK_DATA_COLOR__VI                = 0x43CA;
constexpr unsigned int mmCRTC4_CRTC_BLANK_DATA_COLOR_EXT__VI            = 0x43CB;
constexpr unsigned int mmCRTC4_CRTC_CONTROL__VI                         = 0x439C;
constexpr unsigned int mmCRTC4_CRTC_COUNT_CONTROL__VI                   = 0x43A9;
constexpr unsigned int mmCRTC4_CRTC_COUNT_RESET__VI                     = 0x43AA;
constexpr unsigned int mmCRTC4_CRTC_CRC0_DATA_B__VI                     = 0x43DA;
constexpr unsigned int mmCRTC4_CRTC_CRC0_DATA_RG__VI                    = 0x43D9;
constexpr unsigned int mmCRTC4_CRTC_CRC0_WINDOWA_X_CONTROL__VI          = 0x43D5;
constexpr unsigned int mmCRTC4_CRTC_CRC0_WINDOWA_Y_CONTROL__VI          = 0x43D6;
constexpr unsigned int mmCRTC4_CRTC_CRC0_WINDOWB_X_CONTROL__VI          = 0x43D7;
constexpr unsigned int mmCRTC4_CRTC_CRC0_WINDOWB_Y_CONTROL__VI          = 0x43D8;
constexpr unsigned int mmCRTC4_CRTC_CRC1_DATA_B__VI                     = 0x43E0;
constexpr unsigned int mmCRTC4_CRTC_CRC1_DATA_RG__VI                    = 0x43DF;
constexpr unsigned int mmCRTC4_CRTC_CRC1_WINDOWA_X_CONTROL__VI          = 0x43DB;
constexpr unsigned int mmCRTC4_CRTC_CRC1_WINDOWA_Y_CONTROL__VI          = 0x43DC;
constexpr unsigned int mmCRTC4_CRTC_CRC1_WINDOWB_X_CONTROL__VI          = 0x43DD;
constexpr unsigned int mmCRTC4_CRTC_CRC1_WINDOWB_Y_CONTROL__VI          = 0x43DE;
constexpr unsigned int mmCRTC4_CRTC_CRC_CNTL__VI                        = 0x43D4;
constexpr unsigned int mmCRTC4_CRTC_DCFE_CLOCK_CONTROL__VI              = 0x437C;
constexpr unsigned int mmCRTC4_CRTC_DOUBLE_BUFFER_CONTROL__VI           = 0x43B6;
constexpr unsigned int mmCRTC4_CRTC_DTMTEST_CNTL__VI                    = 0x4392;
constexpr unsigned int mmCRTC4_CRTC_DTMTEST_STATUS_POSITION__VI         = 0x4393;
constexpr unsigned int mmCRTC4_CRTC_EXT_TIMING_SYNC_CONTROL__VI         = 0x43E1;
constexpr unsigned int mmCRTC4_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL__VI  = 0x43E5;
constexpr unsigned int mmCRTC4_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL__VI  = 0x43E4;
constexpr unsigned int mmCRTC4_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL__VI  = 0x43E6;
constexpr unsigned int mmCRTC4_CRTC_EXT_TIMING_SYNC_WINDOW_END__VI      = 0x43E3;
constexpr unsigned int mmCRTC4_CRTC_EXT_TIMING_SYNC_WINDOW_START__VI    = 0x43E2;
constexpr unsigned int mmCRTC4_CRTC_FIELD_INDICATION_CONTROL__VI        = 0x43A0;
constexpr unsigned int mmCRTC4_CRTC_FLOW_CONTROL__VI                    = 0x4399;
constexpr unsigned int mmCRTC4_CRTC_FORCE_COUNT_NOW_CNTL__VI            = 0x4398;
constexpr unsigned int mmCRTC4_CRTC_GSL_CONTROL__VI                     = 0x437B;
constexpr unsigned int mmCRTC4_CRTC_GSL_VSYNC_GAP__VI                   = 0x4379;
constexpr unsigned int mmCRTC4_CRTC_GSL_WINDOW__VI                      = 0x437A;
constexpr unsigned int mmCRTC4_CRTC_H_BLANK_EARLY_NUM__VI               = 0x437D;
constexpr unsigned int mmCRTC4_CRTC_H_BLANK_START_END__VI               = 0x4381;
constexpr unsigned int mmCRTC4_CRTC_H_SYNC_A__VI                        = 0x4382;
constexpr unsigned int mmCRTC4_CRTC_H_SYNC_A_CNTL__VI                   = 0x4383;
constexpr unsigned int mmCRTC4_CRTC_H_SYNC_B__VI                        = 0x4384;
constexpr unsigned int mmCRTC4_CRTC_H_SYNC_B_CNTL__VI                   = 0x4385;
constexpr unsigned int mmCRTC4_CRTC_H_TOTAL__VI                         = 0x4380;
constexpr unsigned int mmCRTC4_CRTC_INTERLACE_CONTROL__VI               = 0x439E;
constexpr unsigned int mmCRTC4_CRTC_INTERLACE_STATUS__VI                = 0x439F;
constexpr unsigned int mmCRTC4_CRTC_INTERRUPT_CONTROL__VI               = 0x43B4;
constexpr unsigned int mmCRTC4_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE__VI    = 0x43AB;
constexpr unsigned int mmCRTC4_CRTC_MASTER_EN__VI                       = 0x43C2;
constexpr unsigned int mmCRTC4_CRTC_MVP_INBAND_CNTL_INSERT__VI          = 0x43BF;
constexpr unsigned int mmCRTC4_CRTC_MVP_INBAND_CNTL_INSERT_TIMER__VI    = 0x43C0;
constexpr unsigned int mmCRTC4_CRTC_MVP_STATUS__VI                      = 0x43C1;
constexpr unsigned int mmCRTC4_CRTC_NOM_VERT_POSITION__VI               = 0x43A5;
constexpr unsigned int mmCRTC4_CRTC_OVERSCAN_COLOR__VI                  = 0x43C8;
constexpr unsigned int mmCRTC4_CRTC_OVERSCAN_COLOR_EXT__VI              = 0x43C9;
constexpr unsigned int mmCRTC4_CRTC_PIXEL_DATA_READBACK0__VI            = 0x43A1;
constexpr unsigned int mmCRTC4_CRTC_PIXEL_DATA_READBACK1__VI            = 0x43A2;
constexpr unsigned int mmCRTC4_CRTC_SNAPSHOT_CONTROL__VI                = 0x43B0;
constexpr unsigned int mmCRTC4_CRTC_SNAPSHOT_FRAME__VI                  = 0x43B2;
constexpr unsigned int mmCRTC4_CRTC_SNAPSHOT_POSITION__VI               = 0x43B1;
constexpr unsigned int mmCRTC4_CRTC_SNAPSHOT_STATUS__VI                 = 0x43AF;
constexpr unsigned int mmCRTC4_CRTC_START_LINE_CONTROL__VI              = 0x43B3;
constexpr unsigned int mmCRTC4_CRTC_STATIC_SCREEN_CONTROL__VI           = 0x43E7;
constexpr unsigned int mmCRTC4_CRTC_STATUS__SI__CI                      = 0x47A3;
constexpr unsigned int mmCRTC4_CRTC_STATUS__VI                          = 0x43A3;
constexpr unsigned int mmCRTC4_CRTC_STATUS_FRAME_COUNT__VI              = 0x43A6;
constexpr unsigned int mmCRTC4_CRTC_STATUS_HV_COUNT__VI                 = 0x43A8;
constexpr unsigned int mmCRTC4_CRTC_STATUS_POSITION__SI__CI             = 0x47A4;
constexpr unsigned int mmCRTC4_CRTC_STATUS_POSITION__VI                 = 0x43A4;
constexpr unsigned int mmCRTC4_CRTC_STATUS_VF_COUNT__VI                 = 0x43A7;
constexpr unsigned int mmCRTC4_CRTC_STEREO_CONTROL__VI                  = 0x43AE;
constexpr unsigned int mmCRTC4_CRTC_STEREO_FORCE_NEXT_EYE__VI           = 0x439A;
constexpr unsigned int mmCRTC4_CRTC_STEREO_STATUS__VI                   = 0x43AD;
constexpr unsigned int mmCRTC4_CRTC_TEST_DEBUG_DATA__VI                 = 0x43C7;
constexpr unsigned int mmCRTC4_CRTC_TEST_DEBUG_INDEX__VI                = 0x43C6;
constexpr unsigned int mmCRTC4_CRTC_TEST_PATTERN_COLOR__VI              = 0x43BC;
constexpr unsigned int mmCRTC4_CRTC_TEST_PATTERN_CONTROL__VI            = 0x43BA;
constexpr unsigned int mmCRTC4_CRTC_TEST_PATTERN_PARAMETERS__VI         = 0x43BB;
constexpr unsigned int mmCRTC4_CRTC_TRIGA_CNTL__VI                      = 0x4394;
constexpr unsigned int mmCRTC4_CRTC_TRIGA_MANUAL_TRIG__VI               = 0x4395;
constexpr unsigned int mmCRTC4_CRTC_TRIGB_CNTL__VI                      = 0x4396;
constexpr unsigned int mmCRTC4_CRTC_TRIGB_MANUAL_TRIG__VI               = 0x4397;
constexpr unsigned int mmCRTC4_CRTC_UPDATE_LOCK__VI                     = 0x43B5;
constexpr unsigned int mmCRTC4_CRTC_VBI_END__VI                         = 0x4386;
constexpr unsigned int mmCRTC4_CRTC_VERTICAL_INTERRUPT0_CONTROL__VI     = 0x43CF;
constexpr unsigned int mmCRTC4_CRTC_VERTICAL_INTERRUPT0_POSITION__VI    = 0x43CE;
constexpr unsigned int mmCRTC4_CRTC_VERTICAL_INTERRUPT1_CONTROL__VI     = 0x43D1;
constexpr unsigned int mmCRTC4_CRTC_VERTICAL_INTERRUPT1_POSITION__VI    = 0x43D0;
constexpr unsigned int mmCRTC4_CRTC_VERTICAL_INTERRUPT2_CONTROL__VI     = 0x43D3;
constexpr unsigned int mmCRTC4_CRTC_VERTICAL_INTERRUPT2_POSITION__VI    = 0x43D2;
constexpr unsigned int mmCRTC4_CRTC_VERT_SYNC_CONTROL__VI               = 0x43AC;
constexpr unsigned int mmCRTC4_CRTC_VGA_PARAMETER_CAPTURE_MODE__VI      = 0x43B7;
constexpr unsigned int mmCRTC4_CRTC_VSYNC_NOM_INT_STATUS__VI            = 0x438C;
constexpr unsigned int mmCRTC4_CRTC_V_BLANK_START_END__VI               = 0x438D;
constexpr unsigned int mmCRTC4_CRTC_V_SYNC_A__VI                        = 0x438E;
constexpr unsigned int mmCRTC4_CRTC_V_SYNC_A_CNTL__VI                   = 0x438F;
constexpr unsigned int mmCRTC4_CRTC_V_SYNC_B__VI                        = 0x4390;
constexpr unsigned int mmCRTC4_CRTC_V_SYNC_B_CNTL__VI                   = 0x4391;
constexpr unsigned int mmCRTC4_CRTC_V_TOTAL__VI                         = 0x4387;
constexpr unsigned int mmCRTC4_CRTC_V_TOTAL_CONTROL__VI                 = 0x438A;
constexpr unsigned int mmCRTC4_CRTC_V_TOTAL_INT_STATUS__VI              = 0x438B;
constexpr unsigned int mmCRTC4_CRTC_V_TOTAL_MAX__VI                     = 0x4389;
constexpr unsigned int mmCRTC4_CRTC_V_TOTAL_MIN__VI                     = 0x4388;
constexpr unsigned int mmCRTC4_CRTC_V_UPDATE_INT_STATUS__VI             = 0x43C4;
constexpr unsigned int mmCRTC4_DCFE_DBG_SEL__VI                         = 0x437E;
constexpr unsigned int mmCRTC4_DCFE_MEM_PWR_CTRL__VI                    = 0x437F;
constexpr unsigned int mmCRTC4_DCFE_MEM_PWR_CTRL2__VI                   = 0x43B8;
constexpr unsigned int mmCRTC4_DCFE_MEM_PWR_STATUS__VI                  = 0x43B9;
constexpr unsigned int mmCRTC4_MASTER_UPDATE_LOCK__VI                   = 0x43BD;
constexpr unsigned int mmCRTC4_MASTER_UPDATE_MODE__SI__CI               = 0x47BE;
constexpr unsigned int mmCRTC4_MASTER_UPDATE_MODE__VI                   = 0x43BE;
constexpr unsigned int mmCRTC4_PIXEL_RATE_CNTL__VI                      = 0x0150;
constexpr unsigned int mmCRTC5_CRTC_3D_STRUCTURE_CONTROL__VI            = 0x4578;
constexpr unsigned int mmCRTC5_CRTC_ALLOW_STOP_OFF_V_CNT__VI            = 0x45C3;
constexpr unsigned int mmCRTC5_CRTC_AVSYNC_COUNTER__VI                  = 0x459B;
constexpr unsigned int mmCRTC5_CRTC_BLACK_COLOR__VI                     = 0x45CC;
constexpr unsigned int mmCRTC5_CRTC_BLACK_COLOR_EXT__VI                 = 0x45CD;
constexpr unsigned int mmCRTC5_CRTC_BLANK_CONTROL__SI__CI               = 0x4A9D;
constexpr unsigned int mmCRTC5_CRTC_BLANK_CONTROL__VI                   = 0x459D;
constexpr unsigned int mmCRTC5_CRTC_BLANK_DATA_COLOR__VI                = 0x45CA;
constexpr unsigned int mmCRTC5_CRTC_BLANK_DATA_COLOR_EXT__VI            = 0x45CB;
constexpr unsigned int mmCRTC5_CRTC_CONTROL__VI                         = 0x459C;
constexpr unsigned int mmCRTC5_CRTC_COUNT_CONTROL__VI                   = 0x45A9;
constexpr unsigned int mmCRTC5_CRTC_COUNT_RESET__VI                     = 0x45AA;
constexpr unsigned int mmCRTC5_CRTC_CRC0_DATA_B__VI                     = 0x45DA;
constexpr unsigned int mmCRTC5_CRTC_CRC0_DATA_RG__VI                    = 0x45D9;
constexpr unsigned int mmCRTC5_CRTC_CRC0_WINDOWA_X_CONTROL__VI          = 0x45D5;
constexpr unsigned int mmCRTC5_CRTC_CRC0_WINDOWA_Y_CONTROL__VI          = 0x45D6;
constexpr unsigned int mmCRTC5_CRTC_CRC0_WINDOWB_X_CONTROL__VI          = 0x45D7;
constexpr unsigned int mmCRTC5_CRTC_CRC0_WINDOWB_Y_CONTROL__VI          = 0x45D8;
constexpr unsigned int mmCRTC5_CRTC_CRC1_DATA_B__VI                     = 0x45E0;
constexpr unsigned int mmCRTC5_CRTC_CRC1_DATA_RG__VI                    = 0x45DF;
constexpr unsigned int mmCRTC5_CRTC_CRC1_WINDOWA_X_CONTROL__VI          = 0x45DB;
constexpr unsigned int mmCRTC5_CRTC_CRC1_WINDOWA_Y_CONTROL__VI          = 0x45DC;
constexpr unsigned int mmCRTC5_CRTC_CRC1_WINDOWB_X_CONTROL__VI          = 0x45DD;
constexpr unsigned int mmCRTC5_CRTC_CRC1_WINDOWB_Y_CONTROL__VI          = 0x45DE;
constexpr unsigned int mmCRTC5_CRTC_CRC_CNTL__VI                        = 0x45D4;
constexpr unsigned int mmCRTC5_CRTC_DCFE_CLOCK_CONTROL__VI              = 0x457C;
constexpr unsigned int mmCRTC5_CRTC_DOUBLE_BUFFER_CONTROL__VI           = 0x45B6;
constexpr unsigned int mmCRTC5_CRTC_DTMTEST_CNTL__VI                    = 0x4592;
constexpr unsigned int mmCRTC5_CRTC_DTMTEST_STATUS_POSITION__VI         = 0x4593;
constexpr unsigned int mmCRTC5_CRTC_EXT_TIMING_SYNC_CONTROL__VI         = 0x45E1;
constexpr unsigned int mmCRTC5_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL__VI  = 0x45E5;
constexpr unsigned int mmCRTC5_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL__VI  = 0x45E4;
constexpr unsigned int mmCRTC5_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL__VI  = 0x45E6;
constexpr unsigned int mmCRTC5_CRTC_EXT_TIMING_SYNC_WINDOW_END__VI      = 0x45E3;
constexpr unsigned int mmCRTC5_CRTC_EXT_TIMING_SYNC_WINDOW_START__VI    = 0x45E2;
constexpr unsigned int mmCRTC5_CRTC_FIELD_INDICATION_CONTROL__VI        = 0x45A0;
constexpr unsigned int mmCRTC5_CRTC_FLOW_CONTROL__VI                    = 0x4599;
constexpr unsigned int mmCRTC5_CRTC_FORCE_COUNT_NOW_CNTL__VI            = 0x4598;
constexpr unsigned int mmCRTC5_CRTC_GSL_CONTROL__VI                     = 0x457B;
constexpr unsigned int mmCRTC5_CRTC_GSL_VSYNC_GAP__VI                   = 0x4579;
constexpr unsigned int mmCRTC5_CRTC_GSL_WINDOW__VI                      = 0x457A;
constexpr unsigned int mmCRTC5_CRTC_H_BLANK_EARLY_NUM__VI               = 0x457D;
constexpr unsigned int mmCRTC5_CRTC_H_BLANK_START_END__VI               = 0x4581;
constexpr unsigned int mmCRTC5_CRTC_H_SYNC_A__VI                        = 0x4582;
constexpr unsigned int mmCRTC5_CRTC_H_SYNC_A_CNTL__VI                   = 0x4583;
constexpr unsigned int mmCRTC5_CRTC_H_SYNC_B__VI                        = 0x4584;
constexpr unsigned int mmCRTC5_CRTC_H_SYNC_B_CNTL__VI                   = 0x4585;
constexpr unsigned int mmCRTC5_CRTC_H_TOTAL__VI                         = 0x4580;
constexpr unsigned int mmCRTC5_CRTC_INTERLACE_CONTROL__VI               = 0x459E;
constexpr unsigned int mmCRTC5_CRTC_INTERLACE_STATUS__VI                = 0x459F;
constexpr unsigned int mmCRTC5_CRTC_INTERRUPT_CONTROL__VI               = 0x45B4;
constexpr unsigned int mmCRTC5_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE__VI    = 0x45AB;
constexpr unsigned int mmCRTC5_CRTC_MASTER_EN__VI                       = 0x45C2;
constexpr unsigned int mmCRTC5_CRTC_MVP_INBAND_CNTL_INSERT__VI          = 0x45BF;
constexpr unsigned int mmCRTC5_CRTC_MVP_INBAND_CNTL_INSERT_TIMER__VI    = 0x45C0;
constexpr unsigned int mmCRTC5_CRTC_MVP_STATUS__VI                      = 0x45C1;
constexpr unsigned int mmCRTC5_CRTC_NOM_VERT_POSITION__VI               = 0x45A5;
constexpr unsigned int mmCRTC5_CRTC_OVERSCAN_COLOR__VI                  = 0x45C8;
constexpr unsigned int mmCRTC5_CRTC_OVERSCAN_COLOR_EXT__VI              = 0x45C9;
constexpr unsigned int mmCRTC5_CRTC_PIXEL_DATA_READBACK0__VI            = 0x45A1;
constexpr unsigned int mmCRTC5_CRTC_PIXEL_DATA_READBACK1__VI            = 0x45A2;
constexpr unsigned int mmCRTC5_CRTC_SNAPSHOT_CONTROL__VI                = 0x45B0;
constexpr unsigned int mmCRTC5_CRTC_SNAPSHOT_FRAME__VI                  = 0x45B2;
constexpr unsigned int mmCRTC5_CRTC_SNAPSHOT_POSITION__VI               = 0x45B1;
constexpr unsigned int mmCRTC5_CRTC_SNAPSHOT_STATUS__VI                 = 0x45AF;
constexpr unsigned int mmCRTC5_CRTC_START_LINE_CONTROL__VI              = 0x45B3;
constexpr unsigned int mmCRTC5_CRTC_STATIC_SCREEN_CONTROL__VI           = 0x45E7;
constexpr unsigned int mmCRTC5_CRTC_STATUS__SI__CI                      = 0x4AA3;
constexpr unsigned int mmCRTC5_CRTC_STATUS__VI                          = 0x45A3;
constexpr unsigned int mmCRTC5_CRTC_STATUS_FRAME_COUNT__VI              = 0x45A6;
constexpr unsigned int mmCRTC5_CRTC_STATUS_HV_COUNT__VI                 = 0x45A8;
constexpr unsigned int mmCRTC5_CRTC_STATUS_POSITION__SI__CI             = 0x4AA4;
constexpr unsigned int mmCRTC5_CRTC_STATUS_POSITION__VI                 = 0x45A4;
constexpr unsigned int mmCRTC5_CRTC_STATUS_VF_COUNT__VI                 = 0x45A7;
constexpr unsigned int mmCRTC5_CRTC_STEREO_CONTROL__VI                  = 0x45AE;
constexpr unsigned int mmCRTC5_CRTC_STEREO_FORCE_NEXT_EYE__VI           = 0x459A;
constexpr unsigned int mmCRTC5_CRTC_STEREO_STATUS__VI                   = 0x45AD;
constexpr unsigned int mmCRTC5_CRTC_TEST_DEBUG_DATA__VI                 = 0x45C7;
constexpr unsigned int mmCRTC5_CRTC_TEST_DEBUG_INDEX__VI                = 0x45C6;
constexpr unsigned int mmCRTC5_CRTC_TEST_PATTERN_COLOR__VI              = 0x45BC;
constexpr unsigned int mmCRTC5_CRTC_TEST_PATTERN_CONTROL__VI            = 0x45BA;
constexpr unsigned int mmCRTC5_CRTC_TEST_PATTERN_PARAMETERS__VI         = 0x45BB;
constexpr unsigned int mmCRTC5_CRTC_TRIGA_CNTL__VI                      = 0x4594;
constexpr unsigned int mmCRTC5_CRTC_TRIGA_MANUAL_TRIG__VI               = 0x4595;
constexpr unsigned int mmCRTC5_CRTC_TRIGB_CNTL__VI                      = 0x4596;
constexpr unsigned int mmCRTC5_CRTC_TRIGB_MANUAL_TRIG__VI               = 0x4597;
constexpr unsigned int mmCRTC5_CRTC_UPDATE_LOCK__VI                     = 0x45B5;
constexpr unsigned int mmCRTC5_CRTC_VBI_END__VI                         = 0x4586;
constexpr unsigned int mmCRTC5_CRTC_VERTICAL_INTERRUPT0_CONTROL__VI     = 0x45CF;
constexpr unsigned int mmCRTC5_CRTC_VERTICAL_INTERRUPT0_POSITION__VI    = 0x45CE;
constexpr unsigned int mmCRTC5_CRTC_VERTICAL_INTERRUPT1_CONTROL__VI     = 0x45D1;
constexpr unsigned int mmCRTC5_CRTC_VERTICAL_INTERRUPT1_POSITION__VI    = 0x45D0;
constexpr unsigned int mmCRTC5_CRTC_VERTICAL_INTERRUPT2_CONTROL__VI     = 0x45D3;
constexpr unsigned int mmCRTC5_CRTC_VERTICAL_INTERRUPT2_POSITION__VI    = 0x45D2;
constexpr unsigned int mmCRTC5_CRTC_VERT_SYNC_CONTROL__VI               = 0x45AC;
constexpr unsigned int mmCRTC5_CRTC_VGA_PARAMETER_CAPTURE_MODE__VI      = 0x45B7;
constexpr unsigned int mmCRTC5_CRTC_VSYNC_NOM_INT_STATUS__VI            = 0x458C;
constexpr unsigned int mmCRTC5_CRTC_V_BLANK_START_END__VI               = 0x458D;
constexpr unsigned int mmCRTC5_CRTC_V_SYNC_A__VI                        = 0x458E;
constexpr unsigned int mmCRTC5_CRTC_V_SYNC_A_CNTL__VI                   = 0x458F;
constexpr unsigned int mmCRTC5_CRTC_V_SYNC_B__VI                        = 0x4590;
constexpr unsigned int mmCRTC5_CRTC_V_SYNC_B_CNTL__VI                   = 0x4591;
constexpr unsigned int mmCRTC5_CRTC_V_TOTAL__VI                         = 0x4587;
constexpr unsigned int mmCRTC5_CRTC_V_TOTAL_CONTROL__VI                 = 0x458A;
constexpr unsigned int mmCRTC5_CRTC_V_TOTAL_INT_STATUS__VI              = 0x458B;
constexpr unsigned int mmCRTC5_CRTC_V_TOTAL_MAX__VI                     = 0x4589;
constexpr unsigned int mmCRTC5_CRTC_V_TOTAL_MIN__VI                     = 0x4588;
constexpr unsigned int mmCRTC5_CRTC_V_UPDATE_INT_STATUS__VI             = 0x45C4;
constexpr unsigned int mmCRTC5_DCFE_DBG_SEL__VI                         = 0x457E;
constexpr unsigned int mmCRTC5_DCFE_MEM_PWR_CTRL__VI                    = 0x457F;
constexpr unsigned int mmCRTC5_DCFE_MEM_PWR_CTRL2__VI                   = 0x45B8;
constexpr unsigned int mmCRTC5_DCFE_MEM_PWR_STATUS__VI                  = 0x45B9;
constexpr unsigned int mmCRTC5_MASTER_UPDATE_LOCK__VI                   = 0x45BD;
constexpr unsigned int mmCRTC5_MASTER_UPDATE_MODE__SI__CI               = 0x4ABE;
constexpr unsigned int mmCRTC5_MASTER_UPDATE_MODE__VI                   = 0x45BE;
constexpr unsigned int mmCRTC5_PIXEL_RATE_CNTL__VI                      = 0x0154;
constexpr unsigned int mmCRTC6_CRTC_3D_STRUCTURE_CONTROL__VI            = 0x4778;
constexpr unsigned int mmCRTC6_CRTC_ALLOW_STOP_OFF_V_CNT__VI            = 0x47C3;
constexpr unsigned int mmCRTC6_CRTC_AVSYNC_COUNTER__VI                  = 0x479B;
constexpr unsigned int mmCRTC6_CRTC_BLACK_COLOR__VI                     = 0x47CC;
constexpr unsigned int mmCRTC6_CRTC_BLACK_COLOR_EXT__VI                 = 0x47CD;
constexpr unsigned int mmCRTC6_CRTC_BLANK_CONTROL__VI                   = 0x479D;
constexpr unsigned int mmCRTC6_CRTC_BLANK_DATA_COLOR__VI                = 0x47CA;
constexpr unsigned int mmCRTC6_CRTC_BLANK_DATA_COLOR_EXT__VI            = 0x47CB;
constexpr unsigned int mmCRTC6_CRTC_CONTROL__VI                         = 0x479C;
constexpr unsigned int mmCRTC6_CRTC_COUNT_CONTROL__VI                   = 0x47A9;
constexpr unsigned int mmCRTC6_CRTC_COUNT_RESET__VI                     = 0x47AA;
constexpr unsigned int mmCRTC6_CRTC_CRC0_DATA_B__VI                     = 0x47DA;
constexpr unsigned int mmCRTC6_CRTC_CRC0_DATA_RG__VI                    = 0x47D9;
constexpr unsigned int mmCRTC6_CRTC_CRC0_WINDOWA_X_CONTROL__VI          = 0x47D5;
constexpr unsigned int mmCRTC6_CRTC_CRC0_WINDOWA_Y_CONTROL__VI          = 0x47D6;
constexpr unsigned int mmCRTC6_CRTC_CRC0_WINDOWB_X_CONTROL__VI          = 0x47D7;
constexpr unsigned int mmCRTC6_CRTC_CRC0_WINDOWB_Y_CONTROL__VI          = 0x47D8;
constexpr unsigned int mmCRTC6_CRTC_CRC1_DATA_B__VI                     = 0x47E0;
constexpr unsigned int mmCRTC6_CRTC_CRC1_DATA_RG__VI                    = 0x47DF;
constexpr unsigned int mmCRTC6_CRTC_CRC1_WINDOWA_X_CONTROL__VI          = 0x47DB;
constexpr unsigned int mmCRTC6_CRTC_CRC1_WINDOWA_Y_CONTROL__VI          = 0x47DC;
constexpr unsigned int mmCRTC6_CRTC_CRC1_WINDOWB_X_CONTROL__VI          = 0x47DD;
constexpr unsigned int mmCRTC6_CRTC_CRC1_WINDOWB_Y_CONTROL__VI          = 0x47DE;
constexpr unsigned int mmCRTC6_CRTC_CRC_CNTL__VI                        = 0x47D4;
constexpr unsigned int mmCRTC6_CRTC_DCFE_CLOCK_CONTROL__VI              = 0x477C;
constexpr unsigned int mmCRTC6_CRTC_DOUBLE_BUFFER_CONTROL__VI           = 0x47B6;
constexpr unsigned int mmCRTC6_CRTC_DTMTEST_CNTL__VI                    = 0x4792;
constexpr unsigned int mmCRTC6_CRTC_DTMTEST_STATUS_POSITION__VI         = 0x4793;
constexpr unsigned int mmCRTC6_CRTC_EXT_TIMING_SYNC_CONTROL__VI         = 0x47E1;
constexpr unsigned int mmCRTC6_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL__VI  = 0x47E5;
constexpr unsigned int mmCRTC6_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL__VI  = 0x47E4;
constexpr unsigned int mmCRTC6_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL__VI  = 0x47E6;
constexpr unsigned int mmCRTC6_CRTC_EXT_TIMING_SYNC_WINDOW_END__VI      = 0x47E3;
constexpr unsigned int mmCRTC6_CRTC_EXT_TIMING_SYNC_WINDOW_START__VI    = 0x47E2;
constexpr unsigned int mmCRTC6_CRTC_FIELD_INDICATION_CONTROL__VI        = 0x47A0;
constexpr unsigned int mmCRTC6_CRTC_FLOW_CONTROL__VI                    = 0x4799;
constexpr unsigned int mmCRTC6_CRTC_FORCE_COUNT_NOW_CNTL__VI            = 0x4798;
constexpr unsigned int mmCRTC6_CRTC_GSL_CONTROL__VI                     = 0x477B;
constexpr unsigned int mmCRTC6_CRTC_GSL_VSYNC_GAP__VI                   = 0x4779;
constexpr unsigned int mmCRTC6_CRTC_GSL_WINDOW__VI                      = 0x477A;
constexpr unsigned int mmCRTC6_CRTC_H_BLANK_EARLY_NUM__VI               = 0x477D;
constexpr unsigned int mmCRTC6_CRTC_H_BLANK_START_END__VI               = 0x4781;
constexpr unsigned int mmCRTC6_CRTC_H_SYNC_A__VI                        = 0x4782;
constexpr unsigned int mmCRTC6_CRTC_H_SYNC_A_CNTL__VI                   = 0x4783;
constexpr unsigned int mmCRTC6_CRTC_H_SYNC_B__VI                        = 0x4784;
constexpr unsigned int mmCRTC6_CRTC_H_SYNC_B_CNTL__VI                   = 0x4785;
constexpr unsigned int mmCRTC6_CRTC_H_TOTAL__VI                         = 0x4780;
constexpr unsigned int mmCRTC6_CRTC_INTERLACE_CONTROL__VI               = 0x479E;
constexpr unsigned int mmCRTC6_CRTC_INTERLACE_STATUS__VI                = 0x479F;
constexpr unsigned int mmCRTC6_CRTC_INTERRUPT_CONTROL__VI               = 0x47B4;
constexpr unsigned int mmCRTC6_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE__VI    = 0x47AB;
constexpr unsigned int mmCRTC6_CRTC_MASTER_EN__VI                       = 0x47C2;
constexpr unsigned int mmCRTC6_CRTC_MVP_INBAND_CNTL_INSERT__VI          = 0x47BF;
constexpr unsigned int mmCRTC6_CRTC_MVP_INBAND_CNTL_INSERT_TIMER__VI    = 0x47C0;
constexpr unsigned int mmCRTC6_CRTC_MVP_STATUS__VI                      = 0x47C1;
constexpr unsigned int mmCRTC6_CRTC_NOM_VERT_POSITION__VI               = 0x47A5;
constexpr unsigned int mmCRTC6_CRTC_OVERSCAN_COLOR__VI                  = 0x47C8;
constexpr unsigned int mmCRTC6_CRTC_OVERSCAN_COLOR_EXT__VI              = 0x47C9;
constexpr unsigned int mmCRTC6_CRTC_PIXEL_DATA_READBACK0__VI            = 0x47A1;
constexpr unsigned int mmCRTC6_CRTC_PIXEL_DATA_READBACK1__VI            = 0x47A2;
constexpr unsigned int mmCRTC6_CRTC_SNAPSHOT_CONTROL__VI                = 0x47B0;
constexpr unsigned int mmCRTC6_CRTC_SNAPSHOT_FRAME__VI                  = 0x47B2;
constexpr unsigned int mmCRTC6_CRTC_SNAPSHOT_POSITION__VI               = 0x47B1;
constexpr unsigned int mmCRTC6_CRTC_SNAPSHOT_STATUS__VI                 = 0x47AF;
constexpr unsigned int mmCRTC6_CRTC_START_LINE_CONTROL__VI              = 0x47B3;
constexpr unsigned int mmCRTC6_CRTC_STATIC_SCREEN_CONTROL__VI           = 0x47E7;
constexpr unsigned int mmCRTC6_CRTC_STATUS__VI                          = 0x47A3;
constexpr unsigned int mmCRTC6_CRTC_STATUS_FRAME_COUNT__VI              = 0x47A6;
constexpr unsigned int mmCRTC6_CRTC_STATUS_HV_COUNT__VI                 = 0x47A8;
constexpr unsigned int mmCRTC6_CRTC_STATUS_POSITION__VI                 = 0x47A4;
constexpr unsigned int mmCRTC6_CRTC_STATUS_VF_COUNT__VI                 = 0x47A7;
constexpr unsigned int mmCRTC6_CRTC_STEREO_CONTROL__VI                  = 0x47AE;
constexpr unsigned int mmCRTC6_CRTC_STEREO_FORCE_NEXT_EYE__VI           = 0x479A;
constexpr unsigned int mmCRTC6_CRTC_STEREO_STATUS__VI                   = 0x47AD;
constexpr unsigned int mmCRTC6_CRTC_TEST_DEBUG_DATA__VI                 = 0x47C7;
constexpr unsigned int mmCRTC6_CRTC_TEST_DEBUG_INDEX__VI                = 0x47C6;
constexpr unsigned int mmCRTC6_CRTC_TEST_PATTERN_COLOR__VI              = 0x47BC;
constexpr unsigned int mmCRTC6_CRTC_TEST_PATTERN_CONTROL__VI            = 0x47BA;
constexpr unsigned int mmCRTC6_CRTC_TEST_PATTERN_PARAMETERS__VI         = 0x47BB;
constexpr unsigned int mmCRTC6_CRTC_TRIGA_CNTL__VI                      = 0x4794;
constexpr unsigned int mmCRTC6_CRTC_TRIGA_MANUAL_TRIG__VI               = 0x4795;
constexpr unsigned int mmCRTC6_CRTC_TRIGB_CNTL__VI                      = 0x4796;
constexpr unsigned int mmCRTC6_CRTC_TRIGB_MANUAL_TRIG__VI               = 0x4797;
constexpr unsigned int mmCRTC6_CRTC_UPDATE_LOCK__VI                     = 0x47B5;
constexpr unsigned int mmCRTC6_CRTC_VBI_END__VI                         = 0x4786;
constexpr unsigned int mmCRTC6_CRTC_VERTICAL_INTERRUPT0_CONTROL__VI     = 0x47CF;
constexpr unsigned int mmCRTC6_CRTC_VERTICAL_INTERRUPT0_POSITION__VI    = 0x47CE;
constexpr unsigned int mmCRTC6_CRTC_VERTICAL_INTERRUPT1_CONTROL__VI     = 0x47D1;
constexpr unsigned int mmCRTC6_CRTC_VERTICAL_INTERRUPT1_POSITION__VI    = 0x47D0;
constexpr unsigned int mmCRTC6_CRTC_VERTICAL_INTERRUPT2_CONTROL__VI     = 0x47D3;
constexpr unsigned int mmCRTC6_CRTC_VERTICAL_INTERRUPT2_POSITION__VI    = 0x47D2;
constexpr unsigned int mmCRTC6_CRTC_VERT_SYNC_CONTROL__VI               = 0x47AC;
constexpr unsigned int mmCRTC6_CRTC_VGA_PARAMETER_CAPTURE_MODE__VI      = 0x47B7;
constexpr unsigned int mmCRTC6_CRTC_VSYNC_NOM_INT_STATUS__VI            = 0x478C;
constexpr unsigned int mmCRTC6_CRTC_V_BLANK_START_END__VI               = 0x478D;
constexpr unsigned int mmCRTC6_CRTC_V_SYNC_A__VI                        = 0x478E;
constexpr unsigned int mmCRTC6_CRTC_V_SYNC_A_CNTL__VI                   = 0x478F;
constexpr unsigned int mmCRTC6_CRTC_V_SYNC_B__VI                        = 0x4790;
constexpr unsigned int mmCRTC6_CRTC_V_SYNC_B_CNTL__VI                   = 0x4791;
constexpr unsigned int mmCRTC6_CRTC_V_TOTAL__VI                         = 0x4787;
constexpr unsigned int mmCRTC6_CRTC_V_TOTAL_CONTROL__VI                 = 0x478A;
constexpr unsigned int mmCRTC6_CRTC_V_TOTAL_INT_STATUS__VI              = 0x478B;
constexpr unsigned int mmCRTC6_CRTC_V_TOTAL_MAX__VI                     = 0x4789;
constexpr unsigned int mmCRTC6_CRTC_V_TOTAL_MIN__VI                     = 0x4788;
constexpr unsigned int mmCRTC6_CRTC_V_UPDATE_INT_STATUS__VI             = 0x47C4;
constexpr unsigned int mmCRTC6_DCFE_DBG_SEL__VI                         = 0x477E;
constexpr unsigned int mmCRTC6_DCFE_MEM_PWR_CTRL__VI                    = 0x477F;
constexpr unsigned int mmCRTC6_DCFE_MEM_PWR_CTRL2__VI                   = 0x47B8;
constexpr unsigned int mmCRTC6_DCFE_MEM_PWR_STATUS__VI                  = 0x47B9;
constexpr unsigned int mmCRTC6_MASTER_UPDATE_LOCK__VI                   = 0x47BD;
constexpr unsigned int mmCRTC6_MASTER_UPDATE_MODE__VI                   = 0x47BE;
constexpr unsigned int mmCRTC_3D_STRUCTURE_CONTROL__VI                  = 0x1B78;
constexpr unsigned int mmCRTC_AVSYNC_COUNTER__VI                        = 0x1B9B;
constexpr unsigned int mmCRTC_BLACK_COLOR__VI                           = 0x1BCC;
constexpr unsigned int mmCRTC_BLACK_COLOR_EXT__VI                       = 0x1BCD;
constexpr unsigned int mmCRTC_BLANK_DATA_COLOR__VI                      = 0x1BCA;
constexpr unsigned int mmCRTC_BLANK_DATA_COLOR_EXT__VI                  = 0x1BCB;
constexpr unsigned int mmCRTC_CRC0_DATA_B__VI                           = 0x1BDA;
constexpr unsigned int mmCRTC_CRC0_DATA_RG__VI                          = 0x1BD9;
constexpr unsigned int mmCRTC_CRC0_WINDOWA_X_CONTROL__VI                = 0x1BD5;
constexpr unsigned int mmCRTC_CRC0_WINDOWA_Y_CONTROL__VI                = 0x1BD6;
constexpr unsigned int mmCRTC_CRC0_WINDOWB_X_CONTROL__VI                = 0x1BD7;
constexpr unsigned int mmCRTC_CRC0_WINDOWB_Y_CONTROL__VI                = 0x1BD8;
constexpr unsigned int mmCRTC_CRC1_DATA_B__VI                           = 0x1BE0;
constexpr unsigned int mmCRTC_CRC1_DATA_RG__VI                          = 0x1BDF;
constexpr unsigned int mmCRTC_CRC1_WINDOWA_X_CONTROL__VI                = 0x1BDB;
constexpr unsigned int mmCRTC_CRC1_WINDOWA_Y_CONTROL__VI                = 0x1BDC;
constexpr unsigned int mmCRTC_CRC1_WINDOWB_X_CONTROL__VI                = 0x1BDD;
constexpr unsigned int mmCRTC_CRC1_WINDOWB_Y_CONTROL__VI                = 0x1BDE;
constexpr unsigned int mmCRTC_CRC_CNTL__VI                              = 0x1BD4;
constexpr unsigned int mmCRTC_DCFE_CLOCK_CONTROL__VI                    = 0x1B7C;
constexpr unsigned int mmCRTC_EXT_TIMING_SYNC_CONTROL__VI               = 0x1BE1;
constexpr unsigned int mmCRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL__VI     = 0x1BE5;
constexpr unsigned int mmCRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL__VI  = 0x1BE4;
constexpr unsigned int mmCRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL__VI  = 0x1BE6;
constexpr unsigned int mmCRTC_EXT_TIMING_SYNC_WINDOW_END__VI            = 0x1BE3;
constexpr unsigned int mmCRTC_EXT_TIMING_SYNC_WINDOW_START__VI          = 0x1BE2;
constexpr unsigned int mmCRTC_FIELD_INDICATION_CONTROL__VI              = 0x1BA0;
constexpr unsigned int mmCRTC_GSL_CONTROL__VI                           = 0x1B7B;
constexpr unsigned int mmCRTC_GSL_VSYNC_GAP__VI                         = 0x1B79;
constexpr unsigned int mmCRTC_GSL_WINDOW__VI                            = 0x1B7A;
constexpr unsigned int mmCRTC_H_BLANK_EARLY_NUM__VI                     = 0x1B7D;
constexpr unsigned int mmCRTC_OVERSCAN_COLOR__VI                        = 0x1BC8;
constexpr unsigned int mmCRTC_OVERSCAN_COLOR_EXT__VI                    = 0x1BC9;
constexpr unsigned int mmCRTC_PIXEL_DATA_READBACK0__VI                  = 0x1BA1;
constexpr unsigned int mmCRTC_PIXEL_DATA_READBACK1__VI                  = 0x1BA2;
constexpr unsigned int mmCRTC_STATIC_SCREEN_CONTROL__VI                 = 0x1BE7;
constexpr unsigned int mmCRTC_STEREO_FORCE_NEXT_EYE__VI                 = 0x1B9A;
constexpr unsigned int mmCRTC_VERTICAL_INTERRUPT0_CONTROL__VI           = 0x1BCF;
constexpr unsigned int mmCRTC_VERTICAL_INTERRUPT0_POSITION__VI          = 0x1BCE;
constexpr unsigned int mmCRTC_VERTICAL_INTERRUPT1_CONTROL__VI           = 0x1BD1;
constexpr unsigned int mmCRTC_VERTICAL_INTERRUPT1_POSITION__VI          = 0x1BD0;
constexpr unsigned int mmCRTC_VERTICAL_INTERRUPT2_CONTROL__VI           = 0x1BD3;
constexpr unsigned int mmCRTC_VERTICAL_INTERRUPT2_POSITION__VI          = 0x1BD2;
constexpr unsigned int mmCUR2_COLOR1__VI                                = 0x1A75;
constexpr unsigned int mmCUR2_COLOR2__VI                                = 0x1A76;
constexpr unsigned int mmCUR2_CONTROL__VI                               = 0x1A6F;
constexpr unsigned int mmCUR2_HOT_SPOT__VI                              = 0x1A74;
constexpr unsigned int mmCUR2_POSITION__VI                              = 0x1A73;
constexpr unsigned int mmCUR2_SIZE__VI                                  = 0x1A71;
constexpr unsigned int mmCUR2_STEREO_CONTROL__VI                        = 0x1A9B;
constexpr unsigned int mmCUR2_SURFACE_ADDRESS__VI                       = 0x1A70;
constexpr unsigned int mmCUR2_SURFACE_ADDRESS_HIGH__VI                  = 0x1A72;
constexpr unsigned int mmCUR2_UPDATE__VI                                = 0x1A77;
constexpr unsigned int mmCUR_REQUEST_FILTER_CNTL__VI                    = 0x1A99;
constexpr unsigned int mmCUR_STEREO_CONTROL__VI                         = 0x1A9A;
constexpr unsigned int mmDAC_AUTODETECT_CONTROL__VI                     = 0x16B4;
constexpr unsigned int mmDAC_AUTODETECT_CONTROL2__VI                    = 0x16B5;
constexpr unsigned int mmDAC_AUTODETECT_CONTROL3__VI                    = 0x16B6;
constexpr unsigned int mmDAC_AUTODETECT_INT_CONTROL__VI                 = 0x16B8;
constexpr unsigned int mmDAC_AUTODETECT_STATUS__VI                      = 0x16B7;
constexpr unsigned int mmDAC_CLK_ENABLE__VI                             = 0x0128;
constexpr unsigned int mmDAC_COMPARATOR_ENABLE__VI                      = 0x16BD;
constexpr unsigned int mmDAC_COMPARATOR_OUTPUT__VI                      = 0x16BE;
constexpr unsigned int mmDAC_CONTROL__VI                                = 0x16BC;
constexpr unsigned int mmDAC_CRC_CONTROL__VI                            = 0x16AD;
constexpr unsigned int mmDAC_CRC_EN__VI                                 = 0x16AC;
constexpr unsigned int mmDAC_CRC_SIG_CONTROL__VI                        = 0x16B1;
constexpr unsigned int mmDAC_CRC_SIG_CONTROL_MASK__VI                   = 0x16AF;
constexpr unsigned int mmDAC_CRC_SIG_RGB__VI                            = 0x16B0;
constexpr unsigned int mmDAC_CRC_SIG_RGB_MASK__VI                       = 0x16AE;
constexpr unsigned int mmDAC_DFT_CONFIG__VI                             = 0x16C0;
constexpr unsigned int mmDAC_ENABLE__VI                                 = 0x16AA;
constexpr unsigned int mmDAC_FIFO_STATUS__VI                            = 0x16C1;
constexpr unsigned int mmDAC_FORCE_DATA__VI                             = 0x16BA;
constexpr unsigned int mmDAC_FORCE_OUTPUT_CNTL__VI                      = 0x16B9;
constexpr unsigned int mmDAC_MACRO_CNTL_RESERVED0__VI                   = 0x48B8;
constexpr unsigned int mmDAC_MACRO_CNTL_RESERVED1__VI                   = 0x48B9;
constexpr unsigned int mmDAC_MACRO_CNTL_RESERVED2__VI                   = 0x48BA;
constexpr unsigned int mmDAC_MACRO_CNTL_RESERVED3__VI                   = 0x48BB;
constexpr unsigned int mmDAC_POWERDOWN__VI                              = 0x16BB;
constexpr unsigned int mmDAC_PWR_CNTL__VI                               = 0x16BF;
constexpr unsigned int mmDAC_SOURCE_SELECT__VI                          = 0x16AB;
constexpr unsigned int mmDAC_STEREOSYNC_SELECT__VI                      = 0x16B3;
constexpr unsigned int mmDAC_SYNC_TRISTATE_CONTROL__VI                  = 0x16B2;
constexpr unsigned int mmDAC_TEST_DEBUG_DATA__VI                        = 0x16C3;
constexpr unsigned int mmDAC_TEST_DEBUG_INDEX__VI                       = 0x16C2;
constexpr unsigned int mmDBG_OUT_CNTL__VI                               = 0x4834;
constexpr unsigned int mmDBG_SMB_BYPASS_SRBM_ACCESS__VI                 = 0x14EB;
constexpr unsigned int mmDCCG_AUDIO_DTO0_MODULE__VI                     = 0x016D;
constexpr unsigned int mmDCCG_AUDIO_DTO0_PHASE__VI                      = 0x016C;
constexpr unsigned int mmDCCG_AUDIO_DTO1_MODULE__VI                     = 0x016F;
constexpr unsigned int mmDCCG_AUDIO_DTO1_PHASE__VI                      = 0x016E;
constexpr unsigned int mmDCCG_AUDIO_DTO_SOURCE__VI                      = 0x016B;
constexpr unsigned int mmDCCG_CAC_STATUS__VI                            = 0x0137;
constexpr unsigned int mmDCCG_CBUS_WRCMD_DELAY__VI                      = 0x0110;
constexpr unsigned int mmDCCG_CPLL0_CPLL_MACRO_CNTL_RESERVED0__VI       = 0x5FD0;
constexpr unsigned int mmDCCG_CPLL0_CPLL_MACRO_CNTL_RESERVED1__VI       = 0x5FD1;
constexpr unsigned int mmDCCG_CPLL0_CPLL_MACRO_CNTL_RESERVED10__VI      = 0x5FDA;
constexpr unsigned int mmDCCG_CPLL0_CPLL_MACRO_CNTL_RESERVED11__VI      = 0x5FDB;
constexpr unsigned int mmDCCG_CPLL0_CPLL_MACRO_CNTL_RESERVED2__VI       = 0x5FD2;
constexpr unsigned int mmDCCG_CPLL0_CPLL_MACRO_CNTL_RESERVED3__VI       = 0x5FD3;
constexpr unsigned int mmDCCG_CPLL0_CPLL_MACRO_CNTL_RESERVED4__VI       = 0x5FD4;
constexpr unsigned int mmDCCG_CPLL0_CPLL_MACRO_CNTL_RESERVED5__VI       = 0x5FD5;
constexpr unsigned int mmDCCG_CPLL0_CPLL_MACRO_CNTL_RESERVED6__VI       = 0x5FD6;
constexpr unsigned int mmDCCG_CPLL0_CPLL_MACRO_CNTL_RESERVED7__VI       = 0x5FD7;
constexpr unsigned int mmDCCG_CPLL0_CPLL_MACRO_CNTL_RESERVED8__VI       = 0x5FD8;
constexpr unsigned int mmDCCG_CPLL0_CPLL_MACRO_CNTL_RESERVED9__VI       = 0x5FD9;
constexpr unsigned int mmDCCG_CPLL1_CPLL_MACRO_CNTL_RESERVED0__VI       = 0x5FDC;
constexpr unsigned int mmDCCG_CPLL1_CPLL_MACRO_CNTL_RESERVED1__VI       = 0x5FDD;
constexpr unsigned int mmDCCG_CPLL1_CPLL_MACRO_CNTL_RESERVED10__VI      = 0x5FE6;
constexpr unsigned int mmDCCG_CPLL1_CPLL_MACRO_CNTL_RESERVED11__VI      = 0x5FE7;
constexpr unsigned int mmDCCG_CPLL1_CPLL_MACRO_CNTL_RESERVED2__VI       = 0x5FDE;
constexpr unsigned int mmDCCG_CPLL1_CPLL_MACRO_CNTL_RESERVED3__VI       = 0x5FDF;
constexpr unsigned int mmDCCG_CPLL1_CPLL_MACRO_CNTL_RESERVED4__VI       = 0x5FE0;
constexpr unsigned int mmDCCG_CPLL1_CPLL_MACRO_CNTL_RESERVED5__VI       = 0x5FE1;
constexpr unsigned int mmDCCG_CPLL1_CPLL_MACRO_CNTL_RESERVED6__VI       = 0x5FE2;
constexpr unsigned int mmDCCG_CPLL1_CPLL_MACRO_CNTL_RESERVED7__VI       = 0x5FE3;
constexpr unsigned int mmDCCG_CPLL1_CPLL_MACRO_CNTL_RESERVED8__VI       = 0x5FE4;
constexpr unsigned int mmDCCG_CPLL1_CPLL_MACRO_CNTL_RESERVED9__VI       = 0x5FE5;
constexpr unsigned int mmDCCG_CPLL2_CPLL_MACRO_CNTL_RESERVED0__VI       = 0x5FE8;
constexpr unsigned int mmDCCG_CPLL2_CPLL_MACRO_CNTL_RESERVED1__VI       = 0x5FE9;
constexpr unsigned int mmDCCG_CPLL2_CPLL_MACRO_CNTL_RESERVED10__VI      = 0x5FF2;
constexpr unsigned int mmDCCG_CPLL2_CPLL_MACRO_CNTL_RESERVED11__VI      = 0x5FF3;
constexpr unsigned int mmDCCG_CPLL2_CPLL_MACRO_CNTL_RESERVED2__VI       = 0x5FEA;
constexpr unsigned int mmDCCG_CPLL2_CPLL_MACRO_CNTL_RESERVED3__VI       = 0x5FEB;
constexpr unsigned int mmDCCG_CPLL2_CPLL_MACRO_CNTL_RESERVED4__VI       = 0x5FEC;
constexpr unsigned int mmDCCG_CPLL2_CPLL_MACRO_CNTL_RESERVED5__VI       = 0x5FED;
constexpr unsigned int mmDCCG_CPLL2_CPLL_MACRO_CNTL_RESERVED6__VI       = 0x5FEE;
constexpr unsigned int mmDCCG_CPLL2_CPLL_MACRO_CNTL_RESERVED7__VI       = 0x5FEF;
constexpr unsigned int mmDCCG_CPLL2_CPLL_MACRO_CNTL_RESERVED8__VI       = 0x5FF0;
constexpr unsigned int mmDCCG_CPLL2_CPLL_MACRO_CNTL_RESERVED9__VI       = 0x5FF1;
constexpr unsigned int mmDCCG_CPLL3_CPLL_MACRO_CNTL_RESERVED0__VI       = 0x5FF4;
constexpr unsigned int mmDCCG_CPLL3_CPLL_MACRO_CNTL_RESERVED1__VI       = 0x5FF5;
constexpr unsigned int mmDCCG_CPLL3_CPLL_MACRO_CNTL_RESERVED10__VI      = 0x5FFE;
constexpr unsigned int mmDCCG_CPLL3_CPLL_MACRO_CNTL_RESERVED11__VI      = 0x5FFF;
constexpr unsigned int mmDCCG_CPLL3_CPLL_MACRO_CNTL_RESERVED2__VI       = 0x5FF6;
constexpr unsigned int mmDCCG_CPLL3_CPLL_MACRO_CNTL_RESERVED3__VI       = 0x5FF7;
constexpr unsigned int mmDCCG_CPLL3_CPLL_MACRO_CNTL_RESERVED4__VI       = 0x5FF8;
constexpr unsigned int mmDCCG_CPLL3_CPLL_MACRO_CNTL_RESERVED5__VI       = 0x5FF9;
constexpr unsigned int mmDCCG_CPLL3_CPLL_MACRO_CNTL_RESERVED6__VI       = 0x5FFA;
constexpr unsigned int mmDCCG_CPLL3_CPLL_MACRO_CNTL_RESERVED7__VI       = 0x5FFB;
constexpr unsigned int mmDCCG_CPLL3_CPLL_MACRO_CNTL_RESERVED8__VI       = 0x5FFC;
constexpr unsigned int mmDCCG_CPLL3_CPLL_MACRO_CNTL_RESERVED9__VI       = 0x5FFD;
constexpr unsigned int mmDCCG_DISP_CNTL_REG__VI                         = 0x013F;
constexpr unsigned int mmDCCG_DS_CNTL__VI                               = 0x0115;
constexpr unsigned int mmDCCG_DS_DEBUG_CNTL__VI                         = 0x0112;
constexpr unsigned int mmDCCG_DS_DTO_INCR__VI                           = 0x0113;
constexpr unsigned int mmDCCG_DS_DTO_MODULO__VI                         = 0x0114;
constexpr unsigned int mmDCCG_DS_HW_CAL_INTERVAL__VI                    = 0x0116;
constexpr unsigned int mmDCCG_GATE_DISABLE_CNTL__VI                     = 0x0134;
constexpr unsigned int mmDCCG_GTC_CNTL__VI                              = 0x0120;
constexpr unsigned int mmDCCG_GTC_CURRENT__VI                           = 0x0123;
constexpr unsigned int mmDCCG_GTC_DTO_INCR__VI                          = 0x0121;
constexpr unsigned int mmDCCG_GTC_DTO_MODULO__VI                        = 0x0122;
constexpr unsigned int mmDCCG_PERFMON_CNTL__VI                          = 0x0133;
constexpr unsigned int mmDCCG_PERFMON_CNTL2__VI                         = 0x010E;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED0__VI         = 0x1700;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED1__VI         = 0x1701;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED10__VI        = 0x170A;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED11__VI        = 0x170B;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED12__VI        = 0x170C;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED13__VI        = 0x170D;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED14__VI        = 0x170E;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED15__VI        = 0x170F;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED16__VI        = 0x1710;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED17__VI        = 0x1711;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED18__VI        = 0x1712;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED19__VI        = 0x1713;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED2__VI         = 0x1702;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED20__VI        = 0x1714;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED21__VI        = 0x1715;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED22__VI        = 0x1716;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED23__VI        = 0x1717;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED24__VI        = 0x1718;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED25__VI        = 0x1719;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED26__VI        = 0x171A;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED27__VI        = 0x171B;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED28__VI        = 0x171C;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED29__VI        = 0x171D;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED3__VI         = 0x1703;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED30__VI        = 0x171E;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED31__VI        = 0x171F;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED32__VI        = 0x1720;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED33__VI        = 0x1721;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED34__VI        = 0x1722;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED35__VI        = 0x1723;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED36__VI        = 0x1724;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED37__VI        = 0x1725;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED38__VI        = 0x1726;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED39__VI        = 0x1727;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED4__VI         = 0x1704;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED40__VI        = 0x1728;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED41__VI        = 0x1729;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED5__VI         = 0x1705;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED6__VI         = 0x1706;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED7__VI         = 0x1707;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED8__VI         = 0x1708;
constexpr unsigned int mmDCCG_PLL0_PLL_MACRO_CNTL_RESERVED9__VI         = 0x1709;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED0__VI         = 0x172A;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED1__VI         = 0x172B;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED10__VI        = 0x1734;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED11__VI        = 0x1735;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED12__VI        = 0x1736;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED13__VI        = 0x1737;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED14__VI        = 0x1738;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED15__VI        = 0x1739;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED16__VI        = 0x173A;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED17__VI        = 0x173B;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED18__VI        = 0x173C;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED19__VI        = 0x173D;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED2__VI         = 0x172C;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED20__VI        = 0x173E;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED21__VI        = 0x173F;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED22__VI        = 0x1740;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED23__VI        = 0x1741;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED24__VI        = 0x1742;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED25__VI        = 0x1743;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED26__VI        = 0x1744;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED27__VI        = 0x1745;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED28__VI        = 0x1746;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED29__VI        = 0x1747;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED3__VI         = 0x172D;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED30__VI        = 0x1748;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED31__VI        = 0x1749;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED32__VI        = 0x174A;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED33__VI        = 0x174B;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED34__VI        = 0x174C;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED35__VI        = 0x174D;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED36__VI        = 0x174E;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED37__VI        = 0x174F;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED38__VI        = 0x1750;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED39__VI        = 0x1751;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED4__VI         = 0x172E;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED40__VI        = 0x1752;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED41__VI        = 0x1753;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED5__VI         = 0x172F;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED6__VI         = 0x1730;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED7__VI         = 0x1731;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED8__VI         = 0x1732;
constexpr unsigned int mmDCCG_PLL1_PLL_MACRO_CNTL_RESERVED9__VI         = 0x1733;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED0__VI         = 0x1754;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED1__VI         = 0x1755;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED10__VI        = 0x175E;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED11__VI        = 0x175F;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED12__VI        = 0x1760;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED13__VI        = 0x1761;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED14__VI        = 0x1762;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED15__VI        = 0x1763;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED16__VI        = 0x1764;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED17__VI        = 0x1765;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED18__VI        = 0x1766;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED19__VI        = 0x1767;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED2__VI         = 0x1756;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED20__VI        = 0x1768;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED21__VI        = 0x1769;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED22__VI        = 0x176A;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED23__VI        = 0x176B;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED24__VI        = 0x176C;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED25__VI        = 0x176D;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED26__VI        = 0x176E;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED27__VI        = 0x176F;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED28__VI        = 0x1770;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED29__VI        = 0x1771;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED3__VI         = 0x1757;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED30__VI        = 0x1772;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED31__VI        = 0x1773;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED32__VI        = 0x1774;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED33__VI        = 0x1775;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED34__VI        = 0x1776;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED35__VI        = 0x1777;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED36__VI        = 0x1778;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED37__VI        = 0x1779;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED38__VI        = 0x177A;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED39__VI        = 0x177B;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED4__VI         = 0x1758;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED40__VI        = 0x177C;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED41__VI        = 0x177D;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED5__VI         = 0x1759;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED6__VI         = 0x175A;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED7__VI         = 0x175B;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED8__VI         = 0x175C;
constexpr unsigned int mmDCCG_PLL2_PLL_MACRO_CNTL_RESERVED9__VI         = 0x175D;
constexpr unsigned int mmDCCG_SOFT_RESET__VI                            = 0x015F;
constexpr unsigned int mmDCCG_TEST_CLK_SEL__VI                          = 0x017E;
constexpr unsigned int mmDCCG_TEST_DEBUG_DATA__VI                       = 0x017D;
constexpr unsigned int mmDCCG_TEST_DEBUG_INDEX__VI                      = 0x017C;
constexpr unsigned int mmDCDEBUG_BUS_CLK1_SEL__VI                       = 0x16C4;
constexpr unsigned int mmDCDEBUG_BUS_CLK2_SEL__VI                       = 0x16C5;
constexpr unsigned int mmDCDEBUG_BUS_CLK3_SEL__VI                       = 0x16C6;
constexpr unsigned int mmDCDEBUG_BUS_CLK4_SEL__VI                       = 0x16C7;
constexpr unsigned int mmDCDEBUG_BUS_CLK5_SEL__VI                       = 0x16C8;
constexpr unsigned int mmDCDEBUG_OUT_CNTL__VI                           = 0x16CA;
constexpr unsigned int mmDCDEBUG_OUT_DATA__VI                           = 0x16CB;
constexpr unsigned int mmDCDEBUG_OUT_PIN_OVERRIDE__VI                   = 0x16C9;
constexpr unsigned int mmDCE_VCE_CONTROL__VI                            = 0x1856;
constexpr unsigned int mmDCFE0_DCFE_CLOCK_CONTROL__VI                   = 0x1B00;
constexpr unsigned int mmDCFE0_DCFE_DBG_CONFIG__VI                      = 0x1B02;
constexpr unsigned int mmDCFE0_DCFE_SOFT_RESET__VI                      = 0x1B01;
constexpr unsigned int mmDCFE1_DCFE_CLOCK_CONTROL__VI                   = 0x1D00;
constexpr unsigned int mmDCFE1_DCFE_DBG_CONFIG__VI                      = 0x1D02;
constexpr unsigned int mmDCFE1_DCFE_SOFT_RESET__VI                      = 0x1D01;
constexpr unsigned int mmDCFE2_DCFE_CLOCK_CONTROL__VI                   = 0x1F00;
constexpr unsigned int mmDCFE2_DCFE_DBG_CONFIG__VI                      = 0x1F02;
constexpr unsigned int mmDCFE2_DCFE_SOFT_RESET__VI                      = 0x1F01;
constexpr unsigned int mmDCFE3_DCFE_CLOCK_CONTROL__VI                   = 0x4100;
constexpr unsigned int mmDCFE3_DCFE_DBG_CONFIG__VI                      = 0x4102;
constexpr unsigned int mmDCFE3_DCFE_SOFT_RESET__VI                      = 0x4101;
constexpr unsigned int mmDCFE4_DCFE_CLOCK_CONTROL__VI                   = 0x4300;
constexpr unsigned int mmDCFE4_DCFE_DBG_CONFIG__VI                      = 0x4302;
constexpr unsigned int mmDCFE4_DCFE_SOFT_RESET__VI                      = 0x4301;
constexpr unsigned int mmDCFE5_DCFE_CLOCK_CONTROL__VI                   = 0x4500;
constexpr unsigned int mmDCFE5_DCFE_DBG_CONFIG__VI                      = 0x4502;
constexpr unsigned int mmDCFE5_DCFE_SOFT_RESET__VI                      = 0x4501;
constexpr unsigned int mmDCFEV0_CRTC_PIXEL_RATE_CNTL__VI                = 0x0104;
constexpr unsigned int mmDCFEV0_PG_CONFIG__VI                           = 0x02DB;
constexpr unsigned int mmDCFEV0_PG_ENABLE__VI                           = 0x02DC;
constexpr unsigned int mmDCFEV0_PG_STATUS__VI                           = 0x02DD;
constexpr unsigned int mmDCFEV_CLOCK_CONTROL__VI                        = 0x46F4;
constexpr unsigned int mmDCFEV_DBG_CONFIG__VI                           = 0x46F7;
constexpr unsigned int mmDCFEV_DMIFV_CLOCK_CONTROL__VI                  = 0x46F6;
constexpr unsigned int mmDCFEV_DMIFV_MEM_PWR_CTRL__VI                   = 0x46F8;
constexpr unsigned int mmDCFEV_DMIFV_MEM_PWR_STATUS__VI                 = 0x46F9;
constexpr unsigned int mmDCFEV_SOFT_RESET__VI                           = 0x46F5;
constexpr unsigned int mmDCFE_CLOCK_CONTROL__VI                         = 0x1B00;
constexpr unsigned int mmDCFE_DBG_CONFIG__VI                            = 0x1B02;
constexpr unsigned int mmDCFE_DBG_SEL__VI                               = 0x1B7E;
constexpr unsigned int mmDCFE_MEM_PWR_CTRL__VI                          = 0x1B7F;
constexpr unsigned int mmDCFE_MEM_PWR_CTRL2__VI                         = 0x1BB8;
constexpr unsigned int mmDCFE_MEM_PWR_STATUS__VI                        = 0x1BB9;
constexpr unsigned int mmDCFE_SOFT_RESET__VI                            = 0x1B01;
constexpr unsigned int mmDCIO_CLOCK_CNTL__VI                            = 0x482D;
constexpr unsigned int mmDCIO_DEBUG__VI                                 = 0x482F;
constexpr unsigned int mmDCIO_DEBUG_CONFIG__VI                          = 0x4835;
constexpr unsigned int mmDCIO_DPHY_SEL__VI                              = 0x4837;
constexpr unsigned int mmDCIO_GSL0_CNTL__VI                             = 0x4826;
constexpr unsigned int mmDCIO_GSL1_CNTL__VI                             = 0x4827;
constexpr unsigned int mmDCIO_GSL2_CNTL__VI                             = 0x4828;
constexpr unsigned int mmDCIO_GSL_GENLK_PAD_CNTL__VI                    = 0x4824;
constexpr unsigned int mmDCIO_GSL_SWAPLOCK_PAD_CNTL__VI                 = 0x4825;
constexpr unsigned int mmDCIO_IMPCAL_CNTL__VI                           = 0x483D;
constexpr unsigned int mmDCIO_IMPCAL_CNTL_CD__VI                        = 0x4841;
constexpr unsigned int mmDCIO_IMPCAL_CNTL_EF__VI                        = 0x4845;
constexpr unsigned int mmDCIO_SOFT_RESET__VI                            = 0x4836;
constexpr unsigned int mmDCIO_TEST_DEBUG_DATA__VI                       = 0x4832;
constexpr unsigned int mmDCIO_TEST_DEBUG_INDEX__VI                      = 0x4831;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED0__VI   = 0x48C0;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED1__VI   = 0x48C1;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED10__VI  = 0x48CA;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED11__VI  = 0x48CB;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED12__VI  = 0x48CC;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED13__VI  = 0x48CD;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED14__VI  = 0x48CE;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED15__VI  = 0x48CF;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED16__VI  = 0x48D0;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED17__VI  = 0x48D1;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED18__VI  = 0x48D2;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED19__VI  = 0x48D3;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED2__VI   = 0x48C2;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED20__VI  = 0x48D4;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED21__VI  = 0x48D5;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED22__VI  = 0x48D6;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED23__VI  = 0x48D7;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED24__VI  = 0x48D8;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED25__VI  = 0x48D9;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED26__VI  = 0x48DA;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED27__VI  = 0x48DB;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED28__VI  = 0x48DC;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED29__VI  = 0x48DD;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED3__VI   = 0x48C3;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED30__VI  = 0x48DE;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED31__VI  = 0x48DF;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED4__VI   = 0x48C4;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED5__VI   = 0x48C5;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED6__VI   = 0x48C6;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED7__VI   = 0x48C7;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED8__VI   = 0x48C8;
constexpr unsigned int mmDCIO_UNIPHY0_UNIPHY_MACRO_CNTL_RESERVED9__VI   = 0x48C9;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED0__VI   = 0x48E0;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED1__VI   = 0x48E1;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED10__VI  = 0x48EA;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED11__VI  = 0x48EB;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED12__VI  = 0x48EC;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED13__VI  = 0x48ED;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED14__VI  = 0x48EE;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED15__VI  = 0x48EF;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED16__VI  = 0x48F0;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED17__VI  = 0x48F1;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED18__VI  = 0x48F2;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED19__VI  = 0x48F3;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED2__VI   = 0x48E2;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED20__VI  = 0x48F4;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED21__VI  = 0x48F5;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED22__VI  = 0x48F6;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED23__VI  = 0x48F7;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED24__VI  = 0x48F8;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED25__VI  = 0x48F9;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED26__VI  = 0x48FA;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED27__VI  = 0x48FB;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED28__VI  = 0x48FC;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED29__VI  = 0x48FD;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED3__VI   = 0x48E3;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED30__VI  = 0x48FE;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED31__VI  = 0x48FF;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED4__VI   = 0x48E4;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED5__VI   = 0x48E5;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED6__VI   = 0x48E6;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED7__VI   = 0x48E7;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED8__VI   = 0x48E8;
constexpr unsigned int mmDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED9__VI   = 0x48E9;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED0__VI   = 0x4900;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED1__VI   = 0x4901;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED10__VI  = 0x490A;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED11__VI  = 0x490B;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED12__VI  = 0x490C;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED13__VI  = 0x490D;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED14__VI  = 0x490E;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED15__VI  = 0x490F;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED16__VI  = 0x4910;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED17__VI  = 0x4911;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED18__VI  = 0x4912;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED19__VI  = 0x4913;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED2__VI   = 0x4902;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED20__VI  = 0x4914;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED21__VI  = 0x4915;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED22__VI  = 0x4916;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED23__VI  = 0x4917;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED24__VI  = 0x4918;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED25__VI  = 0x4919;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED26__VI  = 0x491A;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED27__VI  = 0x491B;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED28__VI  = 0x491C;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED29__VI  = 0x491D;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED3__VI   = 0x4903;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED30__VI  = 0x491E;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED31__VI  = 0x491F;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED4__VI   = 0x4904;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED5__VI   = 0x4905;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED6__VI   = 0x4906;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED7__VI   = 0x4907;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED8__VI   = 0x4908;
constexpr unsigned int mmDCIO_UNIPHY2_UNIPHY_MACRO_CNTL_RESERVED9__VI   = 0x4909;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED0__VI   = 0x4920;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED1__VI   = 0x4921;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED10__VI  = 0x492A;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED11__VI  = 0x492B;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED12__VI  = 0x492C;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED13__VI  = 0x492D;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED14__VI  = 0x492E;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED15__VI  = 0x492F;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED16__VI  = 0x4930;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED17__VI  = 0x4931;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED18__VI  = 0x4932;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED19__VI  = 0x4933;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED2__VI   = 0x4922;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED20__VI  = 0x4934;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED21__VI  = 0x4935;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED22__VI  = 0x4936;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED23__VI  = 0x4937;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED24__VI  = 0x4938;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED25__VI  = 0x4939;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED26__VI  = 0x493A;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED27__VI  = 0x493B;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED28__VI  = 0x493C;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED29__VI  = 0x493D;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED3__VI   = 0x4923;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED30__VI  = 0x493E;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED31__VI  = 0x493F;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED4__VI   = 0x4924;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED5__VI   = 0x4925;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED6__VI   = 0x4926;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED7__VI   = 0x4927;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED8__VI   = 0x4928;
constexpr unsigned int mmDCIO_UNIPHY3_UNIPHY_MACRO_CNTL_RESERVED9__VI   = 0x4929;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED0__VI   = 0x4940;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED1__VI   = 0x4941;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED10__VI  = 0x494A;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED11__VI  = 0x494B;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED12__VI  = 0x494C;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED13__VI  = 0x494D;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED14__VI  = 0x494E;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED15__VI  = 0x494F;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED16__VI  = 0x4950;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED17__VI  = 0x4951;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED18__VI  = 0x4952;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED19__VI  = 0x4953;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED2__VI   = 0x4942;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED20__VI  = 0x4954;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED21__VI  = 0x4955;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED22__VI  = 0x4956;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED23__VI  = 0x4957;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED24__VI  = 0x4958;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED25__VI  = 0x4959;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED26__VI  = 0x495A;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED27__VI  = 0x495B;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED28__VI  = 0x495C;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED29__VI  = 0x495D;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED3__VI   = 0x4943;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED30__VI  = 0x495E;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED31__VI  = 0x495F;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED4__VI   = 0x4944;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED5__VI   = 0x4945;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED6__VI   = 0x4946;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED7__VI   = 0x4947;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED8__VI   = 0x4948;
constexpr unsigned int mmDCIO_UNIPHY4_UNIPHY_MACRO_CNTL_RESERVED9__VI   = 0x4949;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED0__VI   = 0x4960;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED1__VI   = 0x4961;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED10__VI  = 0x496A;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED11__VI  = 0x496B;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED12__VI  = 0x496C;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED13__VI  = 0x496D;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED14__VI  = 0x496E;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED15__VI  = 0x496F;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED16__VI  = 0x4970;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED17__VI  = 0x4971;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED18__VI  = 0x4972;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED19__VI  = 0x4973;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED2__VI   = 0x4962;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED20__VI  = 0x4974;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED21__VI  = 0x4975;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED22__VI  = 0x4976;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED23__VI  = 0x4977;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED24__VI  = 0x4978;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED25__VI  = 0x4979;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED26__VI  = 0x497A;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED27__VI  = 0x497B;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED28__VI  = 0x497C;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED29__VI  = 0x497D;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED3__VI   = 0x4963;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED30__VI  = 0x497E;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED31__VI  = 0x497F;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED4__VI   = 0x4964;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED5__VI   = 0x4965;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED6__VI   = 0x4966;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED7__VI   = 0x4967;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED8__VI   = 0x4968;
constexpr unsigned int mmDCIO_UNIPHY5_UNIPHY_MACRO_CNTL_RESERVED9__VI   = 0x4969;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED0__VI   = 0x4980;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED1__VI   = 0x4981;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED10__VI  = 0x498A;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED11__VI  = 0x498B;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED12__VI  = 0x498C;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED13__VI  = 0x498D;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED14__VI  = 0x498E;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED15__VI  = 0x498F;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED16__VI  = 0x4990;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED17__VI  = 0x4991;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED18__VI  = 0x4992;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED19__VI  = 0x4993;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED2__VI   = 0x4982;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED20__VI  = 0x4994;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED21__VI  = 0x4995;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED22__VI  = 0x4996;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED23__VI  = 0x4997;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED24__VI  = 0x4998;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED25__VI  = 0x4999;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED26__VI  = 0x499A;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED27__VI  = 0x499B;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED28__VI  = 0x499C;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED29__VI  = 0x499D;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED3__VI   = 0x4983;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED30__VI  = 0x499E;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED31__VI  = 0x499F;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED4__VI   = 0x4984;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED5__VI   = 0x4985;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED6__VI   = 0x4986;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED7__VI   = 0x4987;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED8__VI   = 0x4988;
constexpr unsigned int mmDCIO_UNIPHY6_UNIPHY_MACRO_CNTL_RESERVED9__VI   = 0x4989;
constexpr unsigned int mmDCIO_WRCMD_DELAY__VI                           = 0x4816;
constexpr unsigned int mmDCI_CLK_CNTL__VI                               = 0x0319;
constexpr unsigned int mmDCI_CLK_RAMP_CNTL__VI                          = 0x031A;
constexpr unsigned int mmDCI_DEBUG_CONFIG__VI                           = 0x0320;
constexpr unsigned int mmDCI_MEM_PWR_CNTL__VI                           = 0x031B;
constexpr unsigned int mmDCI_MEM_PWR_CNTL2__VI                          = 0x031C;
constexpr unsigned int mmDCI_MEM_PWR_CNTL3__VI                          = 0x031D;
constexpr unsigned int mmDCI_MEM_PWR_STATUS__VI                         = 0x0317;
constexpr unsigned int mmDCI_MEM_PWR_STATUS2__VI                        = 0x0318;
constexpr unsigned int mmDCI_PG_DEBUG_CONFIG__VI                        = 0x1812;
constexpr unsigned int mmDCI_SOFT_RESET__VI                             = 0x0328;
constexpr unsigned int mmDCI_TEST_DEBUG_DATA__VI                        = 0x031F;
constexpr unsigned int mmDCI_TEST_DEBUG_INDEX__VI                       = 0x031E;
constexpr unsigned int mmDCO_CLK_CNTL__VI                               = 0x1864;
constexpr unsigned int mmDCO_CLK_RAMP_CNTL__VI                          = 0x1865;
constexpr unsigned int mmDCO_DCFE_EXT_VSYNC_CNTL__VI                    = 0x4830;
constexpr unsigned int mmDCO_MEM_PWR_CTRL__VI                           = 0x1862;
constexpr unsigned int mmDCO_MEM_PWR_CTRL2__VI                          = 0x1863;
constexpr unsigned int mmDCO_MEM_PWR_STATUS__VI                         = 0x1861;
constexpr unsigned int mmDCO_POWER_MANAGEMENT_CNTL__VI                  = 0x1868;
constexpr unsigned int mmDCO_SCRATCH0__VI                               = 0x184E;
constexpr unsigned int mmDCO_SCRATCH1__VI                               = 0x184F;
constexpr unsigned int mmDCO_SCRATCH2__VI                               = 0x1850;
constexpr unsigned int mmDCO_SCRATCH3__VI                               = 0x1851;
constexpr unsigned int mmDCO_SCRATCH4__VI                               = 0x1852;
constexpr unsigned int mmDCO_SCRATCH5__VI                               = 0x1853;
constexpr unsigned int mmDCO_SCRATCH6__VI                               = 0x1854;
constexpr unsigned int mmDCO_SCRATCH7__VI                               = 0x1855;
constexpr unsigned int mmDCO_SOFT_RESET__VI                             = 0x1871;
constexpr unsigned int mmDCO_STEREOSYNC_SEL__VI                         = 0x186E;
constexpr unsigned int mmDCO_TEST_DEBUG_DATA__VI                        = 0x1870;
constexpr unsigned int mmDCO_TEST_DEBUG_INDEX__VI                       = 0x186F;
constexpr unsigned int mmDCP0_ALPHA_CONTROL__VI                         = 0x1ABC;
constexpr unsigned int mmDCP0_COMM_MATRIXA_TRANS_C11_C12__VI            = 0x1A43;
constexpr unsigned int mmDCP0_COMM_MATRIXA_TRANS_C13_C14__VI            = 0x1A44;
constexpr unsigned int mmDCP0_COMM_MATRIXA_TRANS_C21_C22__VI            = 0x1A45;
constexpr unsigned int mmDCP0_COMM_MATRIXA_TRANS_C23_C24__VI            = 0x1A46;
constexpr unsigned int mmDCP0_COMM_MATRIXA_TRANS_C31_C32__VI            = 0x1A47;
constexpr unsigned int mmDCP0_COMM_MATRIXA_TRANS_C33_C34__VI            = 0x1A48;
constexpr unsigned int mmDCP0_COMM_MATRIXB_TRANS_C11_C12__VI            = 0x1A49;
constexpr unsigned int mmDCP0_COMM_MATRIXB_TRANS_C13_C14__VI            = 0x1A4A;
constexpr unsigned int mmDCP0_COMM_MATRIXB_TRANS_C21_C22__VI            = 0x1A4B;
constexpr unsigned int mmDCP0_COMM_MATRIXB_TRANS_C23_C24__VI            = 0x1A4C;
constexpr unsigned int mmDCP0_COMM_MATRIXB_TRANS_C31_C32__VI            = 0x1A4D;
constexpr unsigned int mmDCP0_COMM_MATRIXB_TRANS_C33_C34__VI            = 0x1A4E;
constexpr unsigned int mmDCP0_CUR2_COLOR1__VI                           = 0x1A75;
constexpr unsigned int mmDCP0_CUR2_COLOR2__VI                           = 0x1A76;
constexpr unsigned int mmDCP0_CUR2_CONTROL__VI                          = 0x1A6F;
constexpr unsigned int mmDCP0_CUR2_HOT_SPOT__VI                         = 0x1A74;
constexpr unsigned int mmDCP0_CUR2_POSITION__VI                         = 0x1A73;
constexpr unsigned int mmDCP0_CUR2_SIZE__VI                             = 0x1A71;
constexpr unsigned int mmDCP0_CUR2_STEREO_CONTROL__VI                   = 0x1A9B;
constexpr unsigned int mmDCP0_CUR2_SURFACE_ADDRESS__VI                  = 0x1A70;
constexpr unsigned int mmDCP0_CUR2_SURFACE_ADDRESS_HIGH__VI             = 0x1A72;
constexpr unsigned int mmDCP0_CUR2_UPDATE__VI                           = 0x1A77;
constexpr unsigned int mmDCP0_CUR_REQUEST_FILTER_CNTL__VI               = 0x1A99;
constexpr unsigned int mmDCP0_CUR_STEREO_CONTROL__VI                    = 0x1A9A;
constexpr unsigned int mmDCP0_DCP_DEBUG2__VI                            = 0x1A98;
constexpr unsigned int mmDCP0_DCP_FP_CONVERTED_FIELD__VI                = 0x1A65;
constexpr unsigned int mmDCP0_DCP_GSL_CONTROL__VI                       = 0x1A90;
constexpr unsigned int mmDCP0_DCP_RANDOM_SEEDS__VI                      = 0x1A61;
constexpr unsigned int mmDCP0_DCP_SPATIAL_DITHER_CNTL__VI               = 0x1A60;
constexpr unsigned int mmDCP0_DC_LUT_VGA_ACCESS_ENABLE__VI              = 0x1A7D;
constexpr unsigned int mmDCP0_DEGAMMA_CONTROL__VI                       = 0x1A58;
constexpr unsigned int mmDCP0_DENORM_CONTROL__VI                        = 0x1A50;
constexpr unsigned int mmDCP0_GAMUT_REMAP_C11_C12__VI                   = 0x1A5A;
constexpr unsigned int mmDCP0_GAMUT_REMAP_C13_C14__VI                   = 0x1A5B;
constexpr unsigned int mmDCP0_GAMUT_REMAP_C21_C22__VI                   = 0x1A5C;
constexpr unsigned int mmDCP0_GAMUT_REMAP_C23_C24__VI                   = 0x1A5D;
constexpr unsigned int mmDCP0_GAMUT_REMAP_C31_C32__VI                   = 0x1A5E;
constexpr unsigned int mmDCP0_GAMUT_REMAP_C33_C34__VI                   = 0x1A5F;
constexpr unsigned int mmDCP0_GAMUT_REMAP_CONTROL__VI                   = 0x1A59;
constexpr unsigned int mmDCP0_GRPH_FLIP_RATE_CNTL__VI                   = 0x1A8E;
constexpr unsigned int mmDCP0_GRPH_STEREOSYNC_FLIP__VI                  = 0x1A97;
constexpr unsigned int mmDCP0_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL__VI    = 0x1A9F;
constexpr unsigned int mmDCP0_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS__VI  = 0x1ABF;
constexpr unsigned int mmDCP0_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS__VI    = 0x1ABD;
constexpr unsigned int mmDCP0_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH__VI  = 0x1ABE;
constexpr unsigned int mmDCP0_HW_ROTATION__VI                           = 0x1A9E;
constexpr unsigned int mmDCP0_INPUT_CSC_C11_C12__VI                     = 0x1A36;
constexpr unsigned int mmDCP0_INPUT_CSC_C13_C14__VI                     = 0x1A37;
constexpr unsigned int mmDCP0_INPUT_CSC_C21_C22__VI                     = 0x1A38;
constexpr unsigned int mmDCP0_INPUT_CSC_C23_C24__VI                     = 0x1A39;
constexpr unsigned int mmDCP0_INPUT_CSC_C31_C32__VI                     = 0x1A3A;
constexpr unsigned int mmDCP0_INPUT_CSC_C33_C34__VI                     = 0x1A3B;
constexpr unsigned int mmDCP0_INPUT_CSC_CONTROL__VI                     = 0x1A35;
constexpr unsigned int mmDCP0_INPUT_GAMMA_CONTROL__VI                   = 0x1A10;
constexpr unsigned int mmDCP0_KEY_CONTROL__VI                           = 0x1A53;
constexpr unsigned int mmDCP0_KEY_RANGE_ALPHA__VI                       = 0x1A54;
constexpr unsigned int mmDCP0_KEY_RANGE_BLUE__VI                        = 0x1A57;
constexpr unsigned int mmDCP0_KEY_RANGE_GREEN__VI                       = 0x1A56;
constexpr unsigned int mmDCP0_KEY_RANGE_RED__VI                         = 0x1A55;
constexpr unsigned int mmDCP0_OUTPUT_CSC_C11_C12__VI                    = 0x1A3D;
constexpr unsigned int mmDCP0_OUTPUT_CSC_C13_C14__VI                    = 0x1A3E;
constexpr unsigned int mmDCP0_OUTPUT_CSC_C21_C22__VI                    = 0x1A3F;
constexpr unsigned int mmDCP0_OUTPUT_CSC_C23_C24__VI                    = 0x1A40;
constexpr unsigned int mmDCP0_OUTPUT_CSC_C31_C32__VI                    = 0x1A41;
constexpr unsigned int mmDCP0_OUTPUT_CSC_C33_C34__VI                    = 0x1A42;
constexpr unsigned int mmDCP0_OUTPUT_CSC_CONTROL__VI                    = 0x1A3C;
constexpr unsigned int mmDCP0_OUT_CLAMP_CONTROL_B_CB__VI                = 0x1A9D;
constexpr unsigned int mmDCP0_OUT_CLAMP_CONTROL_G_Y__VI                 = 0x1A9C;
constexpr unsigned int mmDCP0_OUT_CLAMP_CONTROL_R_CR__VI                = 0x1A52;
constexpr unsigned int mmDCP0_OUT_ROUND_CONTROL__VI                     = 0x1A51;
constexpr unsigned int mmDCP0_OVL_SECONDARY_SURFACE_ADDRESS__VI         = 0x1A92;
constexpr unsigned int mmDCP0_OVL_SECONDARY_SURFACE_ADDRESS_HIGH__VI    = 0x1A94;
constexpr unsigned int mmDCP0_OVL_STEREOSYNC_FLIP__VI                   = 0x1A93;
constexpr unsigned int mmDCP0_PRESCALE_GRPH_CONTROL__VI                 = 0x1A2D;
constexpr unsigned int mmDCP0_PRESCALE_OVL_CONTROL__VI                  = 0x1A31;
constexpr unsigned int mmDCP0_PRESCALE_VALUES_GRPH_B__VI                = 0x1A30;
constexpr unsigned int mmDCP0_PRESCALE_VALUES_GRPH_G__VI                = 0x1A2F;
constexpr unsigned int mmDCP0_PRESCALE_VALUES_GRPH_R__VI                = 0x1A2E;
constexpr unsigned int mmDCP0_PRESCALE_VALUES_OVL_CB__VI                = 0x1A32;
constexpr unsigned int mmDCP0_PRESCALE_VALUES_OVL_CR__VI                = 0x1A34;
constexpr unsigned int mmDCP0_PRESCALE_VALUES_OVL_Y__VI                 = 0x1A33;
constexpr unsigned int mmDCP0_REGAMMA_CNTLA_END_CNTL1__VI               = 0x1AA6;
constexpr unsigned int mmDCP0_REGAMMA_CNTLA_END_CNTL2__VI               = 0x1AA7;
constexpr unsigned int mmDCP0_REGAMMA_CNTLA_REGION_0_1__VI              = 0x1AA8;
constexpr unsigned int mmDCP0_REGAMMA_CNTLA_REGION_10_11__VI            = 0x1AAD;
constexpr unsigned int mmDCP0_REGAMMA_CNTLA_REGION_12_13__VI            = 0x1AAE;
constexpr unsigned int mmDCP0_REGAMMA_CNTLA_REGION_14_15__VI            = 0x1AAF;
constexpr unsigned int mmDCP0_REGAMMA_CNTLA_REGION_2_3__VI              = 0x1AA9;
constexpr unsigned int mmDCP0_REGAMMA_CNTLA_REGION_4_5__VI              = 0x1AAA;
constexpr unsigned int mmDCP0_REGAMMA_CNTLA_REGION_6_7__VI              = 0x1AAB;
constexpr unsigned int mmDCP0_REGAMMA_CNTLA_REGION_8_9__VI              = 0x1AAC;
constexpr unsigned int mmDCP0_REGAMMA_CNTLA_SLOPE_CNTL__VI              = 0x1AA5;
constexpr unsigned int mmDCP0_REGAMMA_CNTLA_START_CNTL__VI              = 0x1AA4;
constexpr unsigned int mmDCP0_REGAMMA_CNTLB_END_CNTL1__VI               = 0x1AB2;
constexpr unsigned int mmDCP0_REGAMMA_CNTLB_END_CNTL2__VI               = 0x1AB3;
constexpr unsigned int mmDCP0_REGAMMA_CNTLB_REGION_0_1__VI              = 0x1AB4;
constexpr unsigned int mmDCP0_REGAMMA_CNTLB_REGION_10_11__VI            = 0x1AB9;
constexpr unsigned int mmDCP0_REGAMMA_CNTLB_REGION_12_13__VI            = 0x1ABA;
constexpr unsigned int mmDCP0_REGAMMA_CNTLB_REGION_14_15__VI            = 0x1ABB;
constexpr unsigned int mmDCP0_REGAMMA_CNTLB_REGION_2_3__VI              = 0x1AB5;
constexpr unsigned int mmDCP0_REGAMMA_CNTLB_REGION_4_5__VI              = 0x1AB6;
constexpr unsigned int mmDCP0_REGAMMA_CNTLB_REGION_6_7__VI              = 0x1AB7;
constexpr unsigned int mmDCP0_REGAMMA_CNTLB_REGION_8_9__VI              = 0x1AB8;
constexpr unsigned int mmDCP0_REGAMMA_CNTLB_SLOPE_CNTL__VI              = 0x1AB1;
constexpr unsigned int mmDCP0_REGAMMA_CNTLB_START_CNTL__VI              = 0x1AB0;
constexpr unsigned int mmDCP0_REGAMMA_CONTROL__VI                       = 0x1AA0;
constexpr unsigned int mmDCP0_REGAMMA_LUT_DATA__VI                      = 0x1AA2;
constexpr unsigned int mmDCP0_REGAMMA_LUT_INDEX__VI                     = 0x1AA1;
constexpr unsigned int mmDCP0_REGAMMA_LUT_WRITE_EN_MASK__VI             = 0x1AA3;
constexpr unsigned int mmDCP1_ALPHA_CONTROL__VI                         = 0x1CBC;
constexpr unsigned int mmDCP1_COMM_MATRIXA_TRANS_C11_C12__VI            = 0x1C43;
constexpr unsigned int mmDCP1_COMM_MATRIXA_TRANS_C13_C14__VI            = 0x1C44;
constexpr unsigned int mmDCP1_COMM_MATRIXA_TRANS_C21_C22__VI            = 0x1C45;
constexpr unsigned int mmDCP1_COMM_MATRIXA_TRANS_C23_C24__VI            = 0x1C46;
constexpr unsigned int mmDCP1_COMM_MATRIXA_TRANS_C31_C32__VI            = 0x1C47;
constexpr unsigned int mmDCP1_COMM_MATRIXA_TRANS_C33_C34__VI            = 0x1C48;
constexpr unsigned int mmDCP1_COMM_MATRIXB_TRANS_C11_C12__VI            = 0x1C49;
constexpr unsigned int mmDCP1_COMM_MATRIXB_TRANS_C13_C14__VI            = 0x1C4A;
constexpr unsigned int mmDCP1_COMM_MATRIXB_TRANS_C21_C22__VI            = 0x1C4B;
constexpr unsigned int mmDCP1_COMM_MATRIXB_TRANS_C23_C24__VI            = 0x1C4C;
constexpr unsigned int mmDCP1_COMM_MATRIXB_TRANS_C31_C32__VI            = 0x1C4D;
constexpr unsigned int mmDCP1_COMM_MATRIXB_TRANS_C33_C34__VI            = 0x1C4E;
constexpr unsigned int mmDCP1_CUR2_COLOR1__VI                           = 0x1C75;
constexpr unsigned int mmDCP1_CUR2_COLOR2__VI                           = 0x1C76;
constexpr unsigned int mmDCP1_CUR2_CONTROL__VI                          = 0x1C6F;
constexpr unsigned int mmDCP1_CUR2_HOT_SPOT__VI                         = 0x1C74;
constexpr unsigned int mmDCP1_CUR2_POSITION__VI                         = 0x1C73;
constexpr unsigned int mmDCP1_CUR2_SIZE__VI                             = 0x1C71;
constexpr unsigned int mmDCP1_CUR2_STEREO_CONTROL__VI                   = 0x1C9B;
constexpr unsigned int mmDCP1_CUR2_SURFACE_ADDRESS__VI                  = 0x1C70;
constexpr unsigned int mmDCP1_CUR2_SURFACE_ADDRESS_HIGH__VI             = 0x1C72;
constexpr unsigned int mmDCP1_CUR2_UPDATE__VI                           = 0x1C77;
constexpr unsigned int mmDCP1_CUR_COLOR1__VI                            = 0x1C6C;
constexpr unsigned int mmDCP1_CUR_COLOR2__VI                            = 0x1C6D;
constexpr unsigned int mmDCP1_CUR_CONTROL__VI                           = 0x1C66;
constexpr unsigned int mmDCP1_CUR_HOT_SPOT__VI                          = 0x1C6B;
constexpr unsigned int mmDCP1_CUR_POSITION__VI                          = 0x1C6A;
constexpr unsigned int mmDCP1_CUR_REQUEST_FILTER_CNTL__VI               = 0x1C99;
constexpr unsigned int mmDCP1_CUR_SIZE__VI                              = 0x1C68;
constexpr unsigned int mmDCP1_CUR_STEREO_CONTROL__VI                    = 0x1C9A;
constexpr unsigned int mmDCP1_CUR_SURFACE_ADDRESS__VI                   = 0x1C67;
constexpr unsigned int mmDCP1_CUR_SURFACE_ADDRESS_HIGH__VI              = 0x1C69;
constexpr unsigned int mmDCP1_CUR_UPDATE__VI                            = 0x1C6E;
constexpr unsigned int mmDCP1_DCP_CRC_CONTROL__VI                       = 0x1C87;
constexpr unsigned int mmDCP1_DCP_CRC_CURRENT__VI                       = 0x1C89;
constexpr unsigned int mmDCP1_DCP_CRC_LAST__VI                          = 0x1C8B;
constexpr unsigned int mmDCP1_DCP_CRC_MASK__VI                          = 0x1C88;
constexpr unsigned int mmDCP1_DCP_DEBUG__VI                             = 0x1C8D;
constexpr unsigned int mmDCP1_DCP_DEBUG2__VI                            = 0x1C98;
constexpr unsigned int mmDCP1_DCP_FP_CONVERTED_FIELD__VI                = 0x1C65;
constexpr unsigned int mmDCP1_DCP_GSL_CONTROL__VI                       = 0x1C90;
constexpr unsigned int mmDCP1_DCP_LB_DATA_GAP_BETWEEN_CHUNK__VI         = 0x1C91;
constexpr unsigned int mmDCP1_DCP_RANDOM_SEEDS__VI                      = 0x1C61;
constexpr unsigned int mmDCP1_DCP_SPATIAL_DITHER_CNTL__VI               = 0x1C60;
constexpr unsigned int mmDCP1_DCP_TEST_DEBUG_DATA__VI                   = 0x1C96;
constexpr unsigned int mmDCP1_DCP_TEST_DEBUG_INDEX__VI                  = 0x1C95;
constexpr unsigned int mmDCP1_DC_LUT_30_COLOR__VI                       = 0x1C7C;
constexpr unsigned int mmDCP1_DC_LUT_AUTOFILL__VI                       = 0x1C7F;
constexpr unsigned int mmDCP1_DC_LUT_BLACK_OFFSET_BLUE__VI              = 0x1C81;
constexpr unsigned int mmDCP1_DC_LUT_BLACK_OFFSET_GREEN__VI             = 0x1C82;
constexpr unsigned int mmDCP1_DC_LUT_BLACK_OFFSET_RED__VI               = 0x1C83;
constexpr unsigned int mmDCP1_DC_LUT_CONTROL__VI                        = 0x1C80;
constexpr unsigned int mmDCP1_DC_LUT_PWL_DATA__VI                       = 0x1C7B;
constexpr unsigned int mmDCP1_DC_LUT_RW_INDEX__VI                       = 0x1C79;
constexpr unsigned int mmDCP1_DC_LUT_RW_MODE__VI                        = 0x1C78;
constexpr unsigned int mmDCP1_DC_LUT_SEQ_COLOR__VI                      = 0x1C7A;
constexpr unsigned int mmDCP1_DC_LUT_VGA_ACCESS_ENABLE__VI              = 0x1C7D;
constexpr unsigned int mmDCP1_DC_LUT_WHITE_OFFSET_BLUE__VI              = 0x1C84;
constexpr unsigned int mmDCP1_DC_LUT_WHITE_OFFSET_GREEN__VI             = 0x1C85;
constexpr unsigned int mmDCP1_DC_LUT_WHITE_OFFSET_RED__VI               = 0x1C86;
constexpr unsigned int mmDCP1_DC_LUT_WRITE_EN_MASK__VI                  = 0x1C7E;
constexpr unsigned int mmDCP1_DEGAMMA_CONTROL__VI                       = 0x1C58;
constexpr unsigned int mmDCP1_DENORM_CONTROL__VI                        = 0x1C50;
constexpr unsigned int mmDCP1_GAMUT_REMAP_C11_C12__VI                   = 0x1C5A;
constexpr unsigned int mmDCP1_GAMUT_REMAP_C13_C14__VI                   = 0x1C5B;
constexpr unsigned int mmDCP1_GAMUT_REMAP_C21_C22__VI                   = 0x1C5C;
constexpr unsigned int mmDCP1_GAMUT_REMAP_C23_C24__VI                   = 0x1C5D;
constexpr unsigned int mmDCP1_GAMUT_REMAP_C31_C32__VI                   = 0x1C5E;
constexpr unsigned int mmDCP1_GAMUT_REMAP_C33_C34__VI                   = 0x1C5F;
constexpr unsigned int mmDCP1_GAMUT_REMAP_CONTROL__VI                   = 0x1C59;
constexpr unsigned int mmDCP1_GRPH_COMPRESS_PITCH__VI                   = 0x1C1A;
constexpr unsigned int mmDCP1_GRPH_COMPRESS_SURFACE_ADDRESS__VI         = 0x1C19;
constexpr unsigned int mmDCP1_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH__VI    = 0x1C1B;
constexpr unsigned int mmDCP1_GRPH_CONTROL__SI__CI                      = 0x1D01;
constexpr unsigned int mmDCP1_GRPH_CONTROL__VI                          = 0x1C01;
constexpr unsigned int mmDCP1_GRPH_DFQ_CONTROL__VI                      = 0x1C14;
constexpr unsigned int mmDCP1_GRPH_DFQ_STATUS__VI                       = 0x1C15;
constexpr unsigned int mmDCP1_GRPH_ENABLE__VI                           = 0x1C00;
constexpr unsigned int mmDCP1_GRPH_FLIP_CONTROL__SI__CI                 = 0x1D12;
constexpr unsigned int mmDCP1_GRPH_FLIP_CONTROL__VI                     = 0x1C12;
constexpr unsigned int mmDCP1_GRPH_FLIP_RATE_CNTL__VI                   = 0x1C8E;
constexpr unsigned int mmDCP1_GRPH_INTERRUPT_CONTROL__VI                = 0x1C17;
constexpr unsigned int mmDCP1_GRPH_INTERRUPT_STATUS__VI                 = 0x1C16;
constexpr unsigned int mmDCP1_GRPH_LUT_10BIT_BYPASS__VI                 = 0x1C02;
constexpr unsigned int mmDCP1_GRPH_PITCH__SI__CI                        = 0x1D06;
constexpr unsigned int mmDCP1_GRPH_PITCH__VI                            = 0x1C06;
constexpr unsigned int mmDCP1_GRPH_PRIMARY_SURFACE_ADDRESS__SI__CI      = 0x1D04;
constexpr unsigned int mmDCP1_GRPH_PRIMARY_SURFACE_ADDRESS__VI          = 0x1C04;
constexpr unsigned int mmDCP1_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH__VI     = 0x1C07;
constexpr unsigned int mmDCP1_GRPH_SECONDARY_SURFACE_ADDRESS__VI        = 0x1C05;
constexpr unsigned int mmDCP1_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH__VI   = 0x1C08;
constexpr unsigned int mmDCP1_GRPH_STEREOSYNC_FLIP__VI                  = 0x1C97;
constexpr unsigned int mmDCP1_GRPH_SURFACE_ADDRESS_HIGH_INUSE__VI       = 0x1C18;
constexpr unsigned int mmDCP1_GRPH_SURFACE_ADDRESS_INUSE__VI            = 0x1C13;
constexpr unsigned int mmDCP1_GRPH_SURFACE_OFFSET_X__VI                 = 0x1C09;
constexpr unsigned int mmDCP1_GRPH_SURFACE_OFFSET_Y__VI                 = 0x1C0A;
constexpr unsigned int mmDCP1_GRPH_SWAP_CNTL__VI                        = 0x1C03;
constexpr unsigned int mmDCP1_GRPH_UPDATE__SI__CI                       = 0x1D11;
constexpr unsigned int mmDCP1_GRPH_UPDATE__VI                           = 0x1C11;
constexpr unsigned int mmDCP1_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL__VI    = 0x1C9F;
constexpr unsigned int mmDCP1_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS__VI  = 0x1CBF;
constexpr unsigned int mmDCP1_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS__VI    = 0x1CBD;
constexpr unsigned int mmDCP1_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH__VI  = 0x1CBE;
constexpr unsigned int mmDCP1_GRPH_X_END__VI                            = 0x1C0D;
constexpr unsigned int mmDCP1_GRPH_X_START__VI                          = 0x1C0B;
constexpr unsigned int mmDCP1_GRPH_Y_END__VI                            = 0x1C0E;
constexpr unsigned int mmDCP1_GRPH_Y_START__VI                          = 0x1C0C;
constexpr unsigned int mmDCP1_HW_ROTATION__VI                           = 0x1C9E;
constexpr unsigned int mmDCP1_INPUT_CSC_C11_C12__VI                     = 0x1C36;
constexpr unsigned int mmDCP1_INPUT_CSC_C13_C14__VI                     = 0x1C37;
constexpr unsigned int mmDCP1_INPUT_CSC_C21_C22__VI                     = 0x1C38;
constexpr unsigned int mmDCP1_INPUT_CSC_C23_C24__VI                     = 0x1C39;
constexpr unsigned int mmDCP1_INPUT_CSC_C31_C32__VI                     = 0x1C3A;
constexpr unsigned int mmDCP1_INPUT_CSC_C33_C34__VI                     = 0x1C3B;
constexpr unsigned int mmDCP1_INPUT_CSC_CONTROL__VI                     = 0x1C35;
constexpr unsigned int mmDCP1_INPUT_GAMMA_CONTROL__VI                   = 0x1C10;
constexpr unsigned int mmDCP1_KEY_CONTROL__VI                           = 0x1C53;
constexpr unsigned int mmDCP1_KEY_RANGE_ALPHA__VI                       = 0x1C54;
constexpr unsigned int mmDCP1_KEY_RANGE_BLUE__VI                        = 0x1C57;
constexpr unsigned int mmDCP1_KEY_RANGE_GREEN__VI                       = 0x1C56;
constexpr unsigned int mmDCP1_KEY_RANGE_RED__VI                         = 0x1C55;
constexpr unsigned int mmDCP1_OUTPUT_CSC_C11_C12__VI                    = 0x1C3D;
constexpr unsigned int mmDCP1_OUTPUT_CSC_C13_C14__VI                    = 0x1C3E;
constexpr unsigned int mmDCP1_OUTPUT_CSC_C21_C22__VI                    = 0x1C3F;
constexpr unsigned int mmDCP1_OUTPUT_CSC_C23_C24__VI                    = 0x1C40;
constexpr unsigned int mmDCP1_OUTPUT_CSC_C31_C32__VI                    = 0x1C41;
constexpr unsigned int mmDCP1_OUTPUT_CSC_C33_C34__VI                    = 0x1C42;
constexpr unsigned int mmDCP1_OUTPUT_CSC_CONTROL__VI                    = 0x1C3C;
constexpr unsigned int mmDCP1_OUT_CLAMP_CONTROL_B_CB__VI                = 0x1C9D;
constexpr unsigned int mmDCP1_OUT_CLAMP_CONTROL_G_Y__VI                 = 0x1C9C;
constexpr unsigned int mmDCP1_OUT_CLAMP_CONTROL_R_CR__VI                = 0x1C52;
constexpr unsigned int mmDCP1_OUT_ROUND_CONTROL__VI                     = 0x1C51;
constexpr unsigned int mmDCP1_OVLSCL_EDGE_PIXEL_CNTL__VI                = 0x1C2C;
constexpr unsigned int mmDCP1_OVL_CONTROL1__VI                          = 0x1C1D;
constexpr unsigned int mmDCP1_OVL_CONTROL2__VI                          = 0x1C1E;
constexpr unsigned int mmDCP1_OVL_DFQ_CONTROL__VI                       = 0x1C29;
constexpr unsigned int mmDCP1_OVL_DFQ_STATUS__VI                        = 0x1C2A;
constexpr unsigned int mmDCP1_OVL_ENABLE__VI                            = 0x1C1C;
constexpr unsigned int mmDCP1_OVL_END__VI                               = 0x1C26;
constexpr unsigned int mmDCP1_OVL_PITCH__VI                             = 0x1C21;
constexpr unsigned int mmDCP1_OVL_SECONDARY_SURFACE_ADDRESS__VI         = 0x1C92;
constexpr unsigned int mmDCP1_OVL_SECONDARY_SURFACE_ADDRESS_HIGH__VI    = 0x1C94;
constexpr unsigned int mmDCP1_OVL_START__VI                             = 0x1C25;
constexpr unsigned int mmDCP1_OVL_STEREOSYNC_FLIP__VI                   = 0x1C93;
constexpr unsigned int mmDCP1_OVL_SURFACE_ADDRESS__SI__CI               = 0x1D20;
constexpr unsigned int mmDCP1_OVL_SURFACE_ADDRESS__VI                   = 0x1C20;
constexpr unsigned int mmDCP1_OVL_SURFACE_ADDRESS_HIGH__VI              = 0x1C22;
constexpr unsigned int mmDCP1_OVL_SURFACE_ADDRESS_HIGH_INUSE__VI        = 0x1C2B;
constexpr unsigned int mmDCP1_OVL_SURFACE_ADDRESS_INUSE__VI             = 0x1C28;
constexpr unsigned int mmDCP1_OVL_SURFACE_OFFSET_X__VI                  = 0x1C23;
constexpr unsigned int mmDCP1_OVL_SURFACE_OFFSET_Y__VI                  = 0x1C24;
constexpr unsigned int mmDCP1_OVL_SWAP_CNTL__VI                         = 0x1C1F;
constexpr unsigned int mmDCP1_OVL_UPDATE__VI                            = 0x1C27;
constexpr unsigned int mmDCP1_PRESCALE_GRPH_CONTROL__VI                 = 0x1C2D;
constexpr unsigned int mmDCP1_PRESCALE_OVL_CONTROL__VI                  = 0x1C31;
constexpr unsigned int mmDCP1_PRESCALE_VALUES_GRPH_B__VI                = 0x1C30;
constexpr unsigned int mmDCP1_PRESCALE_VALUES_GRPH_G__VI                = 0x1C2F;
constexpr unsigned int mmDCP1_PRESCALE_VALUES_GRPH_R__VI                = 0x1C2E;
constexpr unsigned int mmDCP1_PRESCALE_VALUES_OVL_CB__VI                = 0x1C32;
constexpr unsigned int mmDCP1_PRESCALE_VALUES_OVL_CR__VI                = 0x1C34;
constexpr unsigned int mmDCP1_PRESCALE_VALUES_OVL_Y__VI                 = 0x1C33;
constexpr unsigned int mmDCP1_REGAMMA_CNTLA_END_CNTL1__VI               = 0x1CA6;
constexpr unsigned int mmDCP1_REGAMMA_CNTLA_END_CNTL2__VI               = 0x1CA7;
constexpr unsigned int mmDCP1_REGAMMA_CNTLA_REGION_0_1__VI              = 0x1CA8;
constexpr unsigned int mmDCP1_REGAMMA_CNTLA_REGION_10_11__VI            = 0x1CAD;
constexpr unsigned int mmDCP1_REGAMMA_CNTLA_REGION_12_13__VI            = 0x1CAE;
constexpr unsigned int mmDCP1_REGAMMA_CNTLA_REGION_14_15__VI            = 0x1CAF;
constexpr unsigned int mmDCP1_REGAMMA_CNTLA_REGION_2_3__VI              = 0x1CA9;
constexpr unsigned int mmDCP1_REGAMMA_CNTLA_REGION_4_5__VI              = 0x1CAA;
constexpr unsigned int mmDCP1_REGAMMA_CNTLA_REGION_6_7__VI              = 0x1CAB;
constexpr unsigned int mmDCP1_REGAMMA_CNTLA_REGION_8_9__VI              = 0x1CAC;
constexpr unsigned int mmDCP1_REGAMMA_CNTLA_SLOPE_CNTL__VI              = 0x1CA5;
constexpr unsigned int mmDCP1_REGAMMA_CNTLA_START_CNTL__VI              = 0x1CA4;
constexpr unsigned int mmDCP1_REGAMMA_CNTLB_END_CNTL1__VI               = 0x1CB2;
constexpr unsigned int mmDCP1_REGAMMA_CNTLB_END_CNTL2__VI               = 0x1CB3;
constexpr unsigned int mmDCP1_REGAMMA_CNTLB_REGION_0_1__VI              = 0x1CB4;
constexpr unsigned int mmDCP1_REGAMMA_CNTLB_REGION_10_11__VI            = 0x1CB9;
constexpr unsigned int mmDCP1_REGAMMA_CNTLB_REGION_12_13__VI            = 0x1CBA;
constexpr unsigned int mmDCP1_REGAMMA_CNTLB_REGION_14_15__VI            = 0x1CBB;
constexpr unsigned int mmDCP1_REGAMMA_CNTLB_REGION_2_3__VI              = 0x1CB5;
constexpr unsigned int mmDCP1_REGAMMA_CNTLB_REGION_4_5__VI              = 0x1CB6;
constexpr unsigned int mmDCP1_REGAMMA_CNTLB_REGION_6_7__VI              = 0x1CB7;
constexpr unsigned int mmDCP1_REGAMMA_CNTLB_REGION_8_9__VI              = 0x1CB8;
constexpr unsigned int mmDCP1_REGAMMA_CNTLB_SLOPE_CNTL__VI              = 0x1CB1;
constexpr unsigned int mmDCP1_REGAMMA_CNTLB_START_CNTL__VI              = 0x1CB0;
constexpr unsigned int mmDCP1_REGAMMA_CONTROL__VI                       = 0x1CA0;
constexpr unsigned int mmDCP1_REGAMMA_LUT_DATA__VI                      = 0x1CA2;
constexpr unsigned int mmDCP1_REGAMMA_LUT_INDEX__VI                     = 0x1CA1;
constexpr unsigned int mmDCP1_REGAMMA_LUT_WRITE_EN_MASK__VI             = 0x1CA3;
constexpr unsigned int mmDCP2_ALPHA_CONTROL__VI                         = 0x1EBC;
constexpr unsigned int mmDCP2_COMM_MATRIXA_TRANS_C11_C12__VI            = 0x1E43;
constexpr unsigned int mmDCP2_COMM_MATRIXA_TRANS_C13_C14__VI            = 0x1E44;
constexpr unsigned int mmDCP2_COMM_MATRIXA_TRANS_C21_C22__VI            = 0x1E45;
constexpr unsigned int mmDCP2_COMM_MATRIXA_TRANS_C23_C24__VI            = 0x1E46;
constexpr unsigned int mmDCP2_COMM_MATRIXA_TRANS_C31_C32__VI            = 0x1E47;
constexpr unsigned int mmDCP2_COMM_MATRIXA_TRANS_C33_C34__VI            = 0x1E48;
constexpr unsigned int mmDCP2_COMM_MATRIXB_TRANS_C11_C12__VI            = 0x1E49;
constexpr unsigned int mmDCP2_COMM_MATRIXB_TRANS_C13_C14__VI            = 0x1E4A;
constexpr unsigned int mmDCP2_COMM_MATRIXB_TRANS_C21_C22__VI            = 0x1E4B;
constexpr unsigned int mmDCP2_COMM_MATRIXB_TRANS_C23_C24__VI            = 0x1E4C;
constexpr unsigned int mmDCP2_COMM_MATRIXB_TRANS_C31_C32__VI            = 0x1E4D;
constexpr unsigned int mmDCP2_COMM_MATRIXB_TRANS_C33_C34__VI            = 0x1E4E;
constexpr unsigned int mmDCP2_CUR2_COLOR1__VI                           = 0x1E75;
constexpr unsigned int mmDCP2_CUR2_COLOR2__VI                           = 0x1E76;
constexpr unsigned int mmDCP2_CUR2_CONTROL__VI                          = 0x1E6F;
constexpr unsigned int mmDCP2_CUR2_HOT_SPOT__VI                         = 0x1E74;
constexpr unsigned int mmDCP2_CUR2_POSITION__VI                         = 0x1E73;
constexpr unsigned int mmDCP2_CUR2_SIZE__VI                             = 0x1E71;
constexpr unsigned int mmDCP2_CUR2_STEREO_CONTROL__VI                   = 0x1E9B;
constexpr unsigned int mmDCP2_CUR2_SURFACE_ADDRESS__VI                  = 0x1E70;
constexpr unsigned int mmDCP2_CUR2_SURFACE_ADDRESS_HIGH__VI             = 0x1E72;
constexpr unsigned int mmDCP2_CUR2_UPDATE__VI                           = 0x1E77;
constexpr unsigned int mmDCP2_CUR_COLOR1__VI                            = 0x1E6C;
constexpr unsigned int mmDCP2_CUR_COLOR2__VI                            = 0x1E6D;
constexpr unsigned int mmDCP2_CUR_CONTROL__VI                           = 0x1E66;
constexpr unsigned int mmDCP2_CUR_HOT_SPOT__VI                          = 0x1E6B;
constexpr unsigned int mmDCP2_CUR_POSITION__VI                          = 0x1E6A;
constexpr unsigned int mmDCP2_CUR_REQUEST_FILTER_CNTL__VI               = 0x1E99;
constexpr unsigned int mmDCP2_CUR_SIZE__VI                              = 0x1E68;
constexpr unsigned int mmDCP2_CUR_STEREO_CONTROL__VI                    = 0x1E9A;
constexpr unsigned int mmDCP2_CUR_SURFACE_ADDRESS__VI                   = 0x1E67;
constexpr unsigned int mmDCP2_CUR_SURFACE_ADDRESS_HIGH__VI              = 0x1E69;
constexpr unsigned int mmDCP2_CUR_UPDATE__VI                            = 0x1E6E;
constexpr unsigned int mmDCP2_DCP_CRC_CONTROL__VI                       = 0x1E87;
constexpr unsigned int mmDCP2_DCP_CRC_CURRENT__VI                       = 0x1E89;
constexpr unsigned int mmDCP2_DCP_CRC_LAST__VI                          = 0x1E8B;
constexpr unsigned int mmDCP2_DCP_CRC_MASK__VI                          = 0x1E88;
constexpr unsigned int mmDCP2_DCP_DEBUG__VI                             = 0x1E8D;
constexpr unsigned int mmDCP2_DCP_DEBUG2__VI                            = 0x1E98;
constexpr unsigned int mmDCP2_DCP_FP_CONVERTED_FIELD__VI                = 0x1E65;
constexpr unsigned int mmDCP2_DCP_GSL_CONTROL__VI                       = 0x1E90;
constexpr unsigned int mmDCP2_DCP_LB_DATA_GAP_BETWEEN_CHUNK__VI         = 0x1E91;
constexpr unsigned int mmDCP2_DCP_RANDOM_SEEDS__VI                      = 0x1E61;
constexpr unsigned int mmDCP2_DCP_SPATIAL_DITHER_CNTL__VI               = 0x1E60;
constexpr unsigned int mmDCP2_DCP_TEST_DEBUG_DATA__VI                   = 0x1E96;
constexpr unsigned int mmDCP2_DCP_TEST_DEBUG_INDEX__VI                  = 0x1E95;
constexpr unsigned int mmDCP2_DC_LUT_30_COLOR__VI                       = 0x1E7C;
constexpr unsigned int mmDCP2_DC_LUT_AUTOFILL__VI                       = 0x1E7F;
constexpr unsigned int mmDCP2_DC_LUT_BLACK_OFFSET_BLUE__VI              = 0x1E81;
constexpr unsigned int mmDCP2_DC_LUT_BLACK_OFFSET_GREEN__VI             = 0x1E82;
constexpr unsigned int mmDCP2_DC_LUT_BLACK_OFFSET_RED__VI               = 0x1E83;
constexpr unsigned int mmDCP2_DC_LUT_CONTROL__VI                        = 0x1E80;
constexpr unsigned int mmDCP2_DC_LUT_PWL_DATA__VI                       = 0x1E7B;
constexpr unsigned int mmDCP2_DC_LUT_RW_INDEX__VI                       = 0x1E79;
constexpr unsigned int mmDCP2_DC_LUT_RW_MODE__VI                        = 0x1E78;
constexpr unsigned int mmDCP2_DC_LUT_SEQ_COLOR__VI                      = 0x1E7A;
constexpr unsigned int mmDCP2_DC_LUT_VGA_ACCESS_ENABLE__VI              = 0x1E7D;
constexpr unsigned int mmDCP2_DC_LUT_WHITE_OFFSET_BLUE__VI              = 0x1E84;
constexpr unsigned int mmDCP2_DC_LUT_WHITE_OFFSET_GREEN__VI             = 0x1E85;
constexpr unsigned int mmDCP2_DC_LUT_WHITE_OFFSET_RED__VI               = 0x1E86;
constexpr unsigned int mmDCP2_DC_LUT_WRITE_EN_MASK__VI                  = 0x1E7E;
constexpr unsigned int mmDCP2_DEGAMMA_CONTROL__VI                       = 0x1E58;
constexpr unsigned int mmDCP2_DENORM_CONTROL__VI                        = 0x1E50;
constexpr unsigned int mmDCP2_GAMUT_REMAP_C11_C12__VI                   = 0x1E5A;
constexpr unsigned int mmDCP2_GAMUT_REMAP_C13_C14__VI                   = 0x1E5B;
constexpr unsigned int mmDCP2_GAMUT_REMAP_C21_C22__VI                   = 0x1E5C;
constexpr unsigned int mmDCP2_GAMUT_REMAP_C23_C24__VI                   = 0x1E5D;
constexpr unsigned int mmDCP2_GAMUT_REMAP_C31_C32__VI                   = 0x1E5E;
constexpr unsigned int mmDCP2_GAMUT_REMAP_C33_C34__VI                   = 0x1E5F;
constexpr unsigned int mmDCP2_GAMUT_REMAP_CONTROL__VI                   = 0x1E59;
constexpr unsigned int mmDCP2_GRPH_COMPRESS_PITCH__VI                   = 0x1E1A;
constexpr unsigned int mmDCP2_GRPH_COMPRESS_SURFACE_ADDRESS__VI         = 0x1E19;
constexpr unsigned int mmDCP2_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH__VI    = 0x1E1B;
constexpr unsigned int mmDCP2_GRPH_CONTROL__SI__CI                      = 0x4001;
constexpr unsigned int mmDCP2_GRPH_CONTROL__VI                          = 0x1E01;
constexpr unsigned int mmDCP2_GRPH_DFQ_CONTROL__VI                      = 0x1E14;
constexpr unsigned int mmDCP2_GRPH_DFQ_STATUS__VI                       = 0x1E15;
constexpr unsigned int mmDCP2_GRPH_ENABLE__VI                           = 0x1E00;
constexpr unsigned int mmDCP2_GRPH_FLIP_CONTROL__SI__CI                 = 0x4012;
constexpr unsigned int mmDCP2_GRPH_FLIP_CONTROL__VI                     = 0x1E12;
constexpr unsigned int mmDCP2_GRPH_FLIP_RATE_CNTL__VI                   = 0x1E8E;
constexpr unsigned int mmDCP2_GRPH_INTERRUPT_CONTROL__VI                = 0x1E17;
constexpr unsigned int mmDCP2_GRPH_INTERRUPT_STATUS__VI                 = 0x1E16;
constexpr unsigned int mmDCP2_GRPH_LUT_10BIT_BYPASS__VI                 = 0x1E02;
constexpr unsigned int mmDCP2_GRPH_PITCH__SI__CI                        = 0x4006;
constexpr unsigned int mmDCP2_GRPH_PITCH__VI                            = 0x1E06;
constexpr unsigned int mmDCP2_GRPH_PRIMARY_SURFACE_ADDRESS__SI__CI      = 0x4004;
constexpr unsigned int mmDCP2_GRPH_PRIMARY_SURFACE_ADDRESS__VI          = 0x1E04;
constexpr unsigned int mmDCP2_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH__VI     = 0x1E07;
constexpr unsigned int mmDCP2_GRPH_SECONDARY_SURFACE_ADDRESS__VI        = 0x1E05;
constexpr unsigned int mmDCP2_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH__VI   = 0x1E08;
constexpr unsigned int mmDCP2_GRPH_STEREOSYNC_FLIP__VI                  = 0x1E97;
constexpr unsigned int mmDCP2_GRPH_SURFACE_ADDRESS_HIGH_INUSE__VI       = 0x1E18;
constexpr unsigned int mmDCP2_GRPH_SURFACE_ADDRESS_INUSE__VI            = 0x1E13;
constexpr unsigned int mmDCP2_GRPH_SURFACE_OFFSET_X__VI                 = 0x1E09;
constexpr unsigned int mmDCP2_GRPH_SURFACE_OFFSET_Y__VI                 = 0x1E0A;
constexpr unsigned int mmDCP2_GRPH_SWAP_CNTL__VI                        = 0x1E03;
constexpr unsigned int mmDCP2_GRPH_UPDATE__SI__CI                       = 0x4011;
constexpr unsigned int mmDCP2_GRPH_UPDATE__VI                           = 0x1E11;
constexpr unsigned int mmDCP2_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL__VI    = 0x1E9F;
constexpr unsigned int mmDCP2_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS__VI  = 0x1EBF;
constexpr unsigned int mmDCP2_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS__VI    = 0x1EBD;
constexpr unsigned int mmDCP2_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH__VI  = 0x1EBE;
constexpr unsigned int mmDCP2_GRPH_X_END__VI                            = 0x1E0D;
constexpr unsigned int mmDCP2_GRPH_X_START__VI                          = 0x1E0B;
constexpr unsigned int mmDCP2_GRPH_Y_END__VI                            = 0x1E0E;
constexpr unsigned int mmDCP2_GRPH_Y_START__VI                          = 0x1E0C;
constexpr unsigned int mmDCP2_HW_ROTATION__VI                           = 0x1E9E;
constexpr unsigned int mmDCP2_INPUT_CSC_C11_C12__VI                     = 0x1E36;
constexpr unsigned int mmDCP2_INPUT_CSC_C13_C14__VI                     = 0x1E37;
constexpr unsigned int mmDCP2_INPUT_CSC_C21_C22__VI                     = 0x1E38;
constexpr unsigned int mmDCP2_INPUT_CSC_C23_C24__VI                     = 0x1E39;
constexpr unsigned int mmDCP2_INPUT_CSC_C31_C32__VI                     = 0x1E3A;
constexpr unsigned int mmDCP2_INPUT_CSC_C33_C34__VI                     = 0x1E3B;
constexpr unsigned int mmDCP2_INPUT_CSC_CONTROL__VI                     = 0x1E35;
constexpr unsigned int mmDCP2_INPUT_GAMMA_CONTROL__VI                   = 0x1E10;
constexpr unsigned int mmDCP2_KEY_CONTROL__VI                           = 0x1E53;
constexpr unsigned int mmDCP2_KEY_RANGE_ALPHA__VI                       = 0x1E54;
constexpr unsigned int mmDCP2_KEY_RANGE_BLUE__VI                        = 0x1E57;
constexpr unsigned int mmDCP2_KEY_RANGE_GREEN__VI                       = 0x1E56;
constexpr unsigned int mmDCP2_KEY_RANGE_RED__VI                         = 0x1E55;
constexpr unsigned int mmDCP2_OUTPUT_CSC_C11_C12__VI                    = 0x1E3D;
constexpr unsigned int mmDCP2_OUTPUT_CSC_C13_C14__VI                    = 0x1E3E;
constexpr unsigned int mmDCP2_OUTPUT_CSC_C21_C22__VI                    = 0x1E3F;
constexpr unsigned int mmDCP2_OUTPUT_CSC_C23_C24__VI                    = 0x1E40;
constexpr unsigned int mmDCP2_OUTPUT_CSC_C31_C32__VI                    = 0x1E41;
constexpr unsigned int mmDCP2_OUTPUT_CSC_C33_C34__VI                    = 0x1E42;
constexpr unsigned int mmDCP2_OUTPUT_CSC_CONTROL__VI                    = 0x1E3C;
constexpr unsigned int mmDCP2_OUT_CLAMP_CONTROL_B_CB__VI                = 0x1E9D;
constexpr unsigned int mmDCP2_OUT_CLAMP_CONTROL_G_Y__VI                 = 0x1E9C;
constexpr unsigned int mmDCP2_OUT_CLAMP_CONTROL_R_CR__VI                = 0x1E52;
constexpr unsigned int mmDCP2_OUT_ROUND_CONTROL__VI                     = 0x1E51;
constexpr unsigned int mmDCP2_OVLSCL_EDGE_PIXEL_CNTL__VI                = 0x1E2C;
constexpr unsigned int mmDCP2_OVL_CONTROL1__VI                          = 0x1E1D;
constexpr unsigned int mmDCP2_OVL_CONTROL2__VI                          = 0x1E1E;
constexpr unsigned int mmDCP2_OVL_DFQ_CONTROL__VI                       = 0x1E29;
constexpr unsigned int mmDCP2_OVL_DFQ_STATUS__VI                        = 0x1E2A;
constexpr unsigned int mmDCP2_OVL_ENABLE__VI                            = 0x1E1C;
constexpr unsigned int mmDCP2_OVL_END__VI                               = 0x1E26;
constexpr unsigned int mmDCP2_OVL_PITCH__VI                             = 0x1E21;
constexpr unsigned int mmDCP2_OVL_SECONDARY_SURFACE_ADDRESS__VI         = 0x1E92;
constexpr unsigned int mmDCP2_OVL_SECONDARY_SURFACE_ADDRESS_HIGH__VI    = 0x1E94;
constexpr unsigned int mmDCP2_OVL_START__VI                             = 0x1E25;
constexpr unsigned int mmDCP2_OVL_STEREOSYNC_FLIP__VI                   = 0x1E93;
constexpr unsigned int mmDCP2_OVL_SURFACE_ADDRESS__SI__CI               = 0x4020;
constexpr unsigned int mmDCP2_OVL_SURFACE_ADDRESS__VI                   = 0x1E20;
constexpr unsigned int mmDCP2_OVL_SURFACE_ADDRESS_HIGH__VI              = 0x1E22;
constexpr unsigned int mmDCP2_OVL_SURFACE_ADDRESS_HIGH_INUSE__VI        = 0x1E2B;
constexpr unsigned int mmDCP2_OVL_SURFACE_ADDRESS_INUSE__VI             = 0x1E28;
constexpr unsigned int mmDCP2_OVL_SURFACE_OFFSET_X__VI                  = 0x1E23;
constexpr unsigned int mmDCP2_OVL_SURFACE_OFFSET_Y__VI                  = 0x1E24;
constexpr unsigned int mmDCP2_OVL_SWAP_CNTL__VI                         = 0x1E1F;
constexpr unsigned int mmDCP2_OVL_UPDATE__VI                            = 0x1E27;
constexpr unsigned int mmDCP2_PRESCALE_GRPH_CONTROL__VI                 = 0x1E2D;
constexpr unsigned int mmDCP2_PRESCALE_OVL_CONTROL__VI                  = 0x1E31;
constexpr unsigned int mmDCP2_PRESCALE_VALUES_GRPH_B__VI                = 0x1E30;
constexpr unsigned int mmDCP2_PRESCALE_VALUES_GRPH_G__VI                = 0x1E2F;
constexpr unsigned int mmDCP2_PRESCALE_VALUES_GRPH_R__VI                = 0x1E2E;
constexpr unsigned int mmDCP2_PRESCALE_VALUES_OVL_CB__VI                = 0x1E32;
constexpr unsigned int mmDCP2_PRESCALE_VALUES_OVL_CR__VI                = 0x1E34;
constexpr unsigned int mmDCP2_PRESCALE_VALUES_OVL_Y__VI                 = 0x1E33;
constexpr unsigned int mmDCP2_REGAMMA_CNTLA_END_CNTL1__VI               = 0x1EA6;
constexpr unsigned int mmDCP2_REGAMMA_CNTLA_END_CNTL2__VI               = 0x1EA7;
constexpr unsigned int mmDCP2_REGAMMA_CNTLA_REGION_0_1__VI              = 0x1EA8;
constexpr unsigned int mmDCP2_REGAMMA_CNTLA_REGION_10_11__VI            = 0x1EAD;
constexpr unsigned int mmDCP2_REGAMMA_CNTLA_REGION_12_13__VI            = 0x1EAE;
constexpr unsigned int mmDCP2_REGAMMA_CNTLA_REGION_14_15__VI            = 0x1EAF;
constexpr unsigned int mmDCP2_REGAMMA_CNTLA_REGION_2_3__VI              = 0x1EA9;
constexpr unsigned int mmDCP2_REGAMMA_CNTLA_REGION_4_5__VI              = 0x1EAA;
constexpr unsigned int mmDCP2_REGAMMA_CNTLA_REGION_6_7__VI              = 0x1EAB;
constexpr unsigned int mmDCP2_REGAMMA_CNTLA_REGION_8_9__VI              = 0x1EAC;
constexpr unsigned int mmDCP2_REGAMMA_CNTLA_SLOPE_CNTL__VI              = 0x1EA5;
constexpr unsigned int mmDCP2_REGAMMA_CNTLA_START_CNTL__VI              = 0x1EA4;
constexpr unsigned int mmDCP2_REGAMMA_CNTLB_END_CNTL1__VI               = 0x1EB2;
constexpr unsigned int mmDCP2_REGAMMA_CNTLB_END_CNTL2__VI               = 0x1EB3;
constexpr unsigned int mmDCP2_REGAMMA_CNTLB_REGION_0_1__VI              = 0x1EB4;
constexpr unsigned int mmDCP2_REGAMMA_CNTLB_REGION_10_11__VI            = 0x1EB9;
constexpr unsigned int mmDCP2_REGAMMA_CNTLB_REGION_12_13__VI            = 0x1EBA;
constexpr unsigned int mmDCP2_REGAMMA_CNTLB_REGION_14_15__VI            = 0x1EBB;
constexpr unsigned int mmDCP2_REGAMMA_CNTLB_REGION_2_3__VI              = 0x1EB5;
constexpr unsigned int mmDCP2_REGAMMA_CNTLB_REGION_4_5__VI              = 0x1EB6;
constexpr unsigned int mmDCP2_REGAMMA_CNTLB_REGION_6_7__VI              = 0x1EB7;
constexpr unsigned int mmDCP2_REGAMMA_CNTLB_REGION_8_9__VI              = 0x1EB8;
constexpr unsigned int mmDCP2_REGAMMA_CNTLB_SLOPE_CNTL__VI              = 0x1EB1;
constexpr unsigned int mmDCP2_REGAMMA_CNTLB_START_CNTL__VI              = 0x1EB0;
constexpr unsigned int mmDCP2_REGAMMA_CONTROL__VI                       = 0x1EA0;
constexpr unsigned int mmDCP2_REGAMMA_LUT_DATA__VI                      = 0x1EA2;
constexpr unsigned int mmDCP2_REGAMMA_LUT_INDEX__VI                     = 0x1EA1;
constexpr unsigned int mmDCP2_REGAMMA_LUT_WRITE_EN_MASK__VI             = 0x1EA3;
constexpr unsigned int mmDCP3_ALPHA_CONTROL__VI                         = 0x40BC;
constexpr unsigned int mmDCP3_COMM_MATRIXA_TRANS_C11_C12__VI            = 0x4043;
constexpr unsigned int mmDCP3_COMM_MATRIXA_TRANS_C13_C14__VI            = 0x4044;
constexpr unsigned int mmDCP3_COMM_MATRIXA_TRANS_C21_C22__VI            = 0x4045;
constexpr unsigned int mmDCP3_COMM_MATRIXA_TRANS_C23_C24__VI            = 0x4046;
constexpr unsigned int mmDCP3_COMM_MATRIXA_TRANS_C31_C32__VI            = 0x4047;
constexpr unsigned int mmDCP3_COMM_MATRIXA_TRANS_C33_C34__VI            = 0x4048;
constexpr unsigned int mmDCP3_COMM_MATRIXB_TRANS_C11_C12__VI            = 0x4049;
constexpr unsigned int mmDCP3_COMM_MATRIXB_TRANS_C13_C14__VI            = 0x404A;
constexpr unsigned int mmDCP3_COMM_MATRIXB_TRANS_C21_C22__VI            = 0x404B;
constexpr unsigned int mmDCP3_COMM_MATRIXB_TRANS_C23_C24__VI            = 0x404C;
constexpr unsigned int mmDCP3_COMM_MATRIXB_TRANS_C31_C32__VI            = 0x404D;
constexpr unsigned int mmDCP3_COMM_MATRIXB_TRANS_C33_C34__VI            = 0x404E;
constexpr unsigned int mmDCP3_CUR2_COLOR1__VI                           = 0x4075;
constexpr unsigned int mmDCP3_CUR2_COLOR2__VI                           = 0x4076;
constexpr unsigned int mmDCP3_CUR2_CONTROL__VI                          = 0x406F;
constexpr unsigned int mmDCP3_CUR2_HOT_SPOT__VI                         = 0x4074;
constexpr unsigned int mmDCP3_CUR2_POSITION__VI                         = 0x4073;
constexpr unsigned int mmDCP3_CUR2_SIZE__VI                             = 0x4071;
constexpr unsigned int mmDCP3_CUR2_STEREO_CONTROL__VI                   = 0x409B;
constexpr unsigned int mmDCP3_CUR2_SURFACE_ADDRESS__VI                  = 0x4070;
constexpr unsigned int mmDCP3_CUR2_SURFACE_ADDRESS_HIGH__VI             = 0x4072;
constexpr unsigned int mmDCP3_CUR2_UPDATE__VI                           = 0x4077;
constexpr unsigned int mmDCP3_CUR_COLOR1__VI                            = 0x406C;
constexpr unsigned int mmDCP3_CUR_COLOR2__VI                            = 0x406D;
constexpr unsigned int mmDCP3_CUR_CONTROL__VI                           = 0x4066;
constexpr unsigned int mmDCP3_CUR_HOT_SPOT__VI                          = 0x406B;
constexpr unsigned int mmDCP3_CUR_POSITION__VI                          = 0x406A;
constexpr unsigned int mmDCP3_CUR_REQUEST_FILTER_CNTL__VI               = 0x4099;
constexpr unsigned int mmDCP3_CUR_SIZE__VI                              = 0x4068;
constexpr unsigned int mmDCP3_CUR_STEREO_CONTROL__VI                    = 0x409A;
constexpr unsigned int mmDCP3_CUR_SURFACE_ADDRESS__VI                   = 0x4067;
constexpr unsigned int mmDCP3_CUR_SURFACE_ADDRESS_HIGH__VI              = 0x4069;
constexpr unsigned int mmDCP3_CUR_UPDATE__VI                            = 0x406E;
constexpr unsigned int mmDCP3_DCP_CRC_CONTROL__VI                       = 0x4087;
constexpr unsigned int mmDCP3_DCP_CRC_CURRENT__VI                       = 0x4089;
constexpr unsigned int mmDCP3_DCP_CRC_LAST__VI                          = 0x408B;
constexpr unsigned int mmDCP3_DCP_CRC_MASK__VI                          = 0x4088;
constexpr unsigned int mmDCP3_DCP_DEBUG__VI                             = 0x408D;
constexpr unsigned int mmDCP3_DCP_DEBUG2__VI                            = 0x4098;
constexpr unsigned int mmDCP3_DCP_FP_CONVERTED_FIELD__VI                = 0x4065;
constexpr unsigned int mmDCP3_DCP_GSL_CONTROL__VI                       = 0x4090;
constexpr unsigned int mmDCP3_DCP_LB_DATA_GAP_BETWEEN_CHUNK__VI         = 0x4091;
constexpr unsigned int mmDCP3_DCP_RANDOM_SEEDS__VI                      = 0x4061;
constexpr unsigned int mmDCP3_DCP_SPATIAL_DITHER_CNTL__VI               = 0x4060;
constexpr unsigned int mmDCP3_DCP_TEST_DEBUG_DATA__VI                   = 0x4096;
constexpr unsigned int mmDCP3_DCP_TEST_DEBUG_INDEX__VI                  = 0x4095;
constexpr unsigned int mmDCP3_DC_LUT_30_COLOR__VI                       = 0x407C;
constexpr unsigned int mmDCP3_DC_LUT_AUTOFILL__VI                       = 0x407F;
constexpr unsigned int mmDCP3_DC_LUT_BLACK_OFFSET_BLUE__VI              = 0x4081;
constexpr unsigned int mmDCP3_DC_LUT_BLACK_OFFSET_GREEN__VI             = 0x4082;
constexpr unsigned int mmDCP3_DC_LUT_BLACK_OFFSET_RED__VI               = 0x4083;
constexpr unsigned int mmDCP3_DC_LUT_CONTROL__VI                        = 0x4080;
constexpr unsigned int mmDCP3_DC_LUT_PWL_DATA__VI                       = 0x407B;
constexpr unsigned int mmDCP3_DC_LUT_RW_INDEX__VI                       = 0x4079;
constexpr unsigned int mmDCP3_DC_LUT_RW_MODE__VI                        = 0x4078;
constexpr unsigned int mmDCP3_DC_LUT_SEQ_COLOR__VI                      = 0x407A;
constexpr unsigned int mmDCP3_DC_LUT_VGA_ACCESS_ENABLE__VI              = 0x407D;
constexpr unsigned int mmDCP3_DC_LUT_WHITE_OFFSET_BLUE__VI              = 0x4084;
constexpr unsigned int mmDCP3_DC_LUT_WHITE_OFFSET_GREEN__VI             = 0x4085;
constexpr unsigned int mmDCP3_DC_LUT_WHITE_OFFSET_RED__VI               = 0x4086;
constexpr unsigned int mmDCP3_DC_LUT_WRITE_EN_MASK__VI                  = 0x407E;
constexpr unsigned int mmDCP3_DEGAMMA_CONTROL__VI                       = 0x4058;
constexpr unsigned int mmDCP3_DENORM_CONTROL__VI                        = 0x4050;
constexpr unsigned int mmDCP3_GAMUT_REMAP_C11_C12__VI                   = 0x405A;
constexpr unsigned int mmDCP3_GAMUT_REMAP_C13_C14__VI                   = 0x405B;
constexpr unsigned int mmDCP3_GAMUT_REMAP_C21_C22__VI                   = 0x405C;
constexpr unsigned int mmDCP3_GAMUT_REMAP_C23_C24__VI                   = 0x405D;
constexpr unsigned int mmDCP3_GAMUT_REMAP_C31_C32__VI                   = 0x405E;
constexpr unsigned int mmDCP3_GAMUT_REMAP_C33_C34__VI                   = 0x405F;
constexpr unsigned int mmDCP3_GAMUT_REMAP_CONTROL__VI                   = 0x4059;
constexpr unsigned int mmDCP3_GRPH_COMPRESS_PITCH__VI                   = 0x401A;
constexpr unsigned int mmDCP3_GRPH_COMPRESS_SURFACE_ADDRESS__VI         = 0x4019;
constexpr unsigned int mmDCP3_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH__VI    = 0x401B;
constexpr unsigned int mmDCP3_GRPH_CONTROL__SI__CI                      = 0x4301;
constexpr unsigned int mmDCP3_GRPH_CONTROL__VI                          = 0x4001;
constexpr unsigned int mmDCP3_GRPH_DFQ_CONTROL__VI                      = 0x4014;
constexpr unsigned int mmDCP3_GRPH_DFQ_STATUS__VI                       = 0x4015;
constexpr unsigned int mmDCP3_GRPH_ENABLE__VI                           = 0x4000;
constexpr unsigned int mmDCP3_GRPH_FLIP_CONTROL__SI__CI                 = 0x4312;
constexpr unsigned int mmDCP3_GRPH_FLIP_CONTROL__VI                     = 0x4012;
constexpr unsigned int mmDCP3_GRPH_FLIP_RATE_CNTL__VI                   = 0x408E;
constexpr unsigned int mmDCP3_GRPH_INTERRUPT_CONTROL__VI                = 0x4017;
constexpr unsigned int mmDCP3_GRPH_INTERRUPT_STATUS__VI                 = 0x4016;
constexpr unsigned int mmDCP3_GRPH_LUT_10BIT_BYPASS__VI                 = 0x4002;
constexpr unsigned int mmDCP3_GRPH_PITCH__SI__CI                        = 0x4306;
constexpr unsigned int mmDCP3_GRPH_PITCH__VI                            = 0x4006;
constexpr unsigned int mmDCP3_GRPH_PRIMARY_SURFACE_ADDRESS__SI__CI      = 0x4304;
constexpr unsigned int mmDCP3_GRPH_PRIMARY_SURFACE_ADDRESS__VI          = 0x4004;
constexpr unsigned int mmDCP3_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH__VI     = 0x4007;
constexpr unsigned int mmDCP3_GRPH_SECONDARY_SURFACE_ADDRESS__VI        = 0x4005;
constexpr unsigned int mmDCP3_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH__VI   = 0x4008;
constexpr unsigned int mmDCP3_GRPH_STEREOSYNC_FLIP__VI                  = 0x4097;
constexpr unsigned int mmDCP3_GRPH_SURFACE_ADDRESS_HIGH_INUSE__VI       = 0x4018;
constexpr unsigned int mmDCP3_GRPH_SURFACE_ADDRESS_INUSE__VI            = 0x4013;
constexpr unsigned int mmDCP3_GRPH_SURFACE_OFFSET_X__VI                 = 0x4009;
constexpr unsigned int mmDCP3_GRPH_SURFACE_OFFSET_Y__VI                 = 0x400A;
constexpr unsigned int mmDCP3_GRPH_SWAP_CNTL__VI                        = 0x4003;
constexpr unsigned int mmDCP3_GRPH_UPDATE__SI__CI                       = 0x4311;
constexpr unsigned int mmDCP3_GRPH_UPDATE__VI                           = 0x4011;
constexpr unsigned int mmDCP3_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL__VI    = 0x409F;
constexpr unsigned int mmDCP3_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS__VI  = 0x40BF;
constexpr unsigned int mmDCP3_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS__VI    = 0x40BD;
constexpr unsigned int mmDCP3_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH__VI  = 0x40BE;
constexpr unsigned int mmDCP3_GRPH_X_END__VI                            = 0x400D;
constexpr unsigned int mmDCP3_GRPH_X_START__VI                          = 0x400B;
constexpr unsigned int mmDCP3_GRPH_Y_END__VI                            = 0x400E;
constexpr unsigned int mmDCP3_GRPH_Y_START__VI                          = 0x400C;
constexpr unsigned int mmDCP3_HW_ROTATION__VI                           = 0x409E;
constexpr unsigned int mmDCP3_INPUT_CSC_C11_C12__VI                     = 0x4036;
constexpr unsigned int mmDCP3_INPUT_CSC_C13_C14__VI                     = 0x4037;
constexpr unsigned int mmDCP3_INPUT_CSC_C21_C22__VI                     = 0x4038;
constexpr unsigned int mmDCP3_INPUT_CSC_C23_C24__VI                     = 0x4039;
constexpr unsigned int mmDCP3_INPUT_CSC_C31_C32__VI                     = 0x403A;
constexpr unsigned int mmDCP3_INPUT_CSC_C33_C34__VI                     = 0x403B;
constexpr unsigned int mmDCP3_INPUT_CSC_CONTROL__VI                     = 0x4035;
constexpr unsigned int mmDCP3_INPUT_GAMMA_CONTROL__VI                   = 0x4010;
constexpr unsigned int mmDCP3_KEY_CONTROL__VI                           = 0x4053;
constexpr unsigned int mmDCP3_KEY_RANGE_ALPHA__VI                       = 0x4054;
constexpr unsigned int mmDCP3_KEY_RANGE_BLUE__VI                        = 0x4057;
constexpr unsigned int mmDCP3_KEY_RANGE_GREEN__VI                       = 0x4056;
constexpr unsigned int mmDCP3_KEY_RANGE_RED__VI                         = 0x4055;
constexpr unsigned int mmDCP3_OUTPUT_CSC_C11_C12__VI                    = 0x403D;
constexpr unsigned int mmDCP3_OUTPUT_CSC_C13_C14__VI                    = 0x403E;
constexpr unsigned int mmDCP3_OUTPUT_CSC_C21_C22__VI                    = 0x403F;
constexpr unsigned int mmDCP3_OUTPUT_CSC_C23_C24__VI                    = 0x4040;
constexpr unsigned int mmDCP3_OUTPUT_CSC_C31_C32__VI                    = 0x4041;
constexpr unsigned int mmDCP3_OUTPUT_CSC_C33_C34__VI                    = 0x4042;
constexpr unsigned int mmDCP3_OUTPUT_CSC_CONTROL__VI                    = 0x403C;
constexpr unsigned int mmDCP3_OUT_CLAMP_CONTROL_B_CB__VI                = 0x409D;
constexpr unsigned int mmDCP3_OUT_CLAMP_CONTROL_G_Y__VI                 = 0x409C;
constexpr unsigned int mmDCP3_OUT_CLAMP_CONTROL_R_CR__VI                = 0x4052;
constexpr unsigned int mmDCP3_OUT_ROUND_CONTROL__VI                     = 0x4051;
constexpr unsigned int mmDCP3_OVLSCL_EDGE_PIXEL_CNTL__VI                = 0x402C;
constexpr unsigned int mmDCP3_OVL_CONTROL1__VI                          = 0x401D;
constexpr unsigned int mmDCP3_OVL_CONTROL2__VI                          = 0x401E;
constexpr unsigned int mmDCP3_OVL_DFQ_CONTROL__VI                       = 0x4029;
constexpr unsigned int mmDCP3_OVL_DFQ_STATUS__VI                        = 0x402A;
constexpr unsigned int mmDCP3_OVL_ENABLE__VI                            = 0x401C;
constexpr unsigned int mmDCP3_OVL_END__VI                               = 0x4026;
constexpr unsigned int mmDCP3_OVL_PITCH__VI                             = 0x4021;
constexpr unsigned int mmDCP3_OVL_SECONDARY_SURFACE_ADDRESS__VI         = 0x4092;
constexpr unsigned int mmDCP3_OVL_SECONDARY_SURFACE_ADDRESS_HIGH__VI    = 0x4094;
constexpr unsigned int mmDCP3_OVL_START__VI                             = 0x4025;
constexpr unsigned int mmDCP3_OVL_STEREOSYNC_FLIP__VI                   = 0x4093;
constexpr unsigned int mmDCP3_OVL_SURFACE_ADDRESS__SI__CI               = 0x4320;
constexpr unsigned int mmDCP3_OVL_SURFACE_ADDRESS__VI                   = 0x4020;
constexpr unsigned int mmDCP3_OVL_SURFACE_ADDRESS_HIGH__VI              = 0x4022;
constexpr unsigned int mmDCP3_OVL_SURFACE_ADDRESS_HIGH_INUSE__VI        = 0x402B;
constexpr unsigned int mmDCP3_OVL_SURFACE_ADDRESS_INUSE__VI             = 0x4028;
constexpr unsigned int mmDCP3_OVL_SURFACE_OFFSET_X__VI                  = 0x4023;
constexpr unsigned int mmDCP3_OVL_SURFACE_OFFSET_Y__VI                  = 0x4024;
constexpr unsigned int mmDCP3_OVL_SWAP_CNTL__VI                         = 0x401F;
constexpr unsigned int mmDCP3_OVL_UPDATE__VI                            = 0x4027;
constexpr unsigned int mmDCP3_PRESCALE_GRPH_CONTROL__VI                 = 0x402D;
constexpr unsigned int mmDCP3_PRESCALE_OVL_CONTROL__VI                  = 0x4031;
constexpr unsigned int mmDCP3_PRESCALE_VALUES_GRPH_B__VI                = 0x4030;
constexpr unsigned int mmDCP3_PRESCALE_VALUES_GRPH_G__VI                = 0x402F;
constexpr unsigned int mmDCP3_PRESCALE_VALUES_GRPH_R__VI                = 0x402E;
constexpr unsigned int mmDCP3_PRESCALE_VALUES_OVL_CB__VI                = 0x4032;
constexpr unsigned int mmDCP3_PRESCALE_VALUES_OVL_CR__VI                = 0x4034;
constexpr unsigned int mmDCP3_PRESCALE_VALUES_OVL_Y__VI                 = 0x4033;
constexpr unsigned int mmDCP3_REGAMMA_CNTLA_END_CNTL1__VI               = 0x40A6;
constexpr unsigned int mmDCP3_REGAMMA_CNTLA_END_CNTL2__VI               = 0x40A7;
constexpr unsigned int mmDCP3_REGAMMA_CNTLA_REGION_0_1__VI              = 0x40A8;
constexpr unsigned int mmDCP3_REGAMMA_CNTLA_REGION_10_11__VI            = 0x40AD;
constexpr unsigned int mmDCP3_REGAMMA_CNTLA_REGION_12_13__VI            = 0x40AE;
constexpr unsigned int mmDCP3_REGAMMA_CNTLA_REGION_14_15__VI            = 0x40AF;
constexpr unsigned int mmDCP3_REGAMMA_CNTLA_REGION_2_3__VI              = 0x40A9;
constexpr unsigned int mmDCP3_REGAMMA_CNTLA_REGION_4_5__VI              = 0x40AA;
constexpr unsigned int mmDCP3_REGAMMA_CNTLA_REGION_6_7__VI              = 0x40AB;
constexpr unsigned int mmDCP3_REGAMMA_CNTLA_REGION_8_9__VI              = 0x40AC;
constexpr unsigned int mmDCP3_REGAMMA_CNTLA_SLOPE_CNTL__VI              = 0x40A5;
constexpr unsigned int mmDCP3_REGAMMA_CNTLA_START_CNTL__VI              = 0x40A4;
constexpr unsigned int mmDCP3_REGAMMA_CNTLB_END_CNTL1__VI               = 0x40B2;
constexpr unsigned int mmDCP3_REGAMMA_CNTLB_END_CNTL2__VI               = 0x40B3;
constexpr unsigned int mmDCP3_REGAMMA_CNTLB_REGION_0_1__VI              = 0x40B4;
constexpr unsigned int mmDCP3_REGAMMA_CNTLB_REGION_10_11__VI            = 0x40B9;
constexpr unsigned int mmDCP3_REGAMMA_CNTLB_REGION_12_13__VI            = 0x40BA;
constexpr unsigned int mmDCP3_REGAMMA_CNTLB_REGION_14_15__VI            = 0x40BB;
constexpr unsigned int mmDCP3_REGAMMA_CNTLB_REGION_2_3__VI              = 0x40B5;
constexpr unsigned int mmDCP3_REGAMMA_CNTLB_REGION_4_5__VI              = 0x40B6;
constexpr unsigned int mmDCP3_REGAMMA_CNTLB_REGION_6_7__VI              = 0x40B7;
constexpr unsigned int mmDCP3_REGAMMA_CNTLB_REGION_8_9__VI              = 0x40B8;
constexpr unsigned int mmDCP3_REGAMMA_CNTLB_SLOPE_CNTL__VI              = 0x40B1;
constexpr unsigned int mmDCP3_REGAMMA_CNTLB_START_CNTL__VI              = 0x40B0;
constexpr unsigned int mmDCP3_REGAMMA_CONTROL__VI                       = 0x40A0;
constexpr unsigned int mmDCP3_REGAMMA_LUT_DATA__VI                      = 0x40A2;
constexpr unsigned int mmDCP3_REGAMMA_LUT_INDEX__VI                     = 0x40A1;
constexpr unsigned int mmDCP3_REGAMMA_LUT_WRITE_EN_MASK__VI             = 0x40A3;
constexpr unsigned int mmDCP4_ALPHA_CONTROL__VI                         = 0x42BC;
constexpr unsigned int mmDCP4_COMM_MATRIXA_TRANS_C11_C12__VI            = 0x4243;
constexpr unsigned int mmDCP4_COMM_MATRIXA_TRANS_C13_C14__VI            = 0x4244;
constexpr unsigned int mmDCP4_COMM_MATRIXA_TRANS_C21_C22__VI            = 0x4245;
constexpr unsigned int mmDCP4_COMM_MATRIXA_TRANS_C23_C24__VI            = 0x4246;
constexpr unsigned int mmDCP4_COMM_MATRIXA_TRANS_C31_C32__VI            = 0x4247;
constexpr unsigned int mmDCP4_COMM_MATRIXA_TRANS_C33_C34__VI            = 0x4248;
constexpr unsigned int mmDCP4_COMM_MATRIXB_TRANS_C11_C12__VI            = 0x4249;
constexpr unsigned int mmDCP4_COMM_MATRIXB_TRANS_C13_C14__VI            = 0x424A;
constexpr unsigned int mmDCP4_COMM_MATRIXB_TRANS_C21_C22__VI            = 0x424B;
constexpr unsigned int mmDCP4_COMM_MATRIXB_TRANS_C23_C24__VI            = 0x424C;
constexpr unsigned int mmDCP4_COMM_MATRIXB_TRANS_C31_C32__VI            = 0x424D;
constexpr unsigned int mmDCP4_COMM_MATRIXB_TRANS_C33_C34__VI            = 0x424E;
constexpr unsigned int mmDCP4_CUR2_COLOR1__VI                           = 0x4275;
constexpr unsigned int mmDCP4_CUR2_COLOR2__VI                           = 0x4276;
constexpr unsigned int mmDCP4_CUR2_CONTROL__VI                          = 0x426F;
constexpr unsigned int mmDCP4_CUR2_HOT_SPOT__VI                         = 0x4274;
constexpr unsigned int mmDCP4_CUR2_POSITION__VI                         = 0x4273;
constexpr unsigned int mmDCP4_CUR2_SIZE__VI                             = 0x4271;
constexpr unsigned int mmDCP4_CUR2_STEREO_CONTROL__VI                   = 0x429B;
constexpr unsigned int mmDCP4_CUR2_SURFACE_ADDRESS__VI                  = 0x4270;
constexpr unsigned int mmDCP4_CUR2_SURFACE_ADDRESS_HIGH__VI             = 0x4272;
constexpr unsigned int mmDCP4_CUR2_UPDATE__VI                           = 0x4277;
constexpr unsigned int mmDCP4_CUR_COLOR1__VI                            = 0x426C;
constexpr unsigned int mmDCP4_CUR_COLOR2__VI                            = 0x426D;
constexpr unsigned int mmDCP4_CUR_CONTROL__VI                           = 0x4266;
constexpr unsigned int mmDCP4_CUR_HOT_SPOT__VI                          = 0x426B;
constexpr unsigned int mmDCP4_CUR_POSITION__VI                          = 0x426A;
constexpr unsigned int mmDCP4_CUR_REQUEST_FILTER_CNTL__VI               = 0x4299;
constexpr unsigned int mmDCP4_CUR_SIZE__VI                              = 0x4268;
constexpr unsigned int mmDCP4_CUR_STEREO_CONTROL__VI                    = 0x429A;
constexpr unsigned int mmDCP4_CUR_SURFACE_ADDRESS__VI                   = 0x4267;
constexpr unsigned int mmDCP4_CUR_SURFACE_ADDRESS_HIGH__VI              = 0x4269;
constexpr unsigned int mmDCP4_CUR_UPDATE__VI                            = 0x426E;
constexpr unsigned int mmDCP4_DCP_CRC_CONTROL__VI                       = 0x4287;
constexpr unsigned int mmDCP4_DCP_CRC_CURRENT__VI                       = 0x4289;
constexpr unsigned int mmDCP4_DCP_CRC_LAST__VI                          = 0x428B;
constexpr unsigned int mmDCP4_DCP_CRC_MASK__VI                          = 0x4288;
constexpr unsigned int mmDCP4_DCP_DEBUG__VI                             = 0x428D;
constexpr unsigned int mmDCP4_DCP_DEBUG2__VI                            = 0x4298;
constexpr unsigned int mmDCP4_DCP_FP_CONVERTED_FIELD__VI                = 0x4265;
constexpr unsigned int mmDCP4_DCP_GSL_CONTROL__VI                       = 0x4290;
constexpr unsigned int mmDCP4_DCP_LB_DATA_GAP_BETWEEN_CHUNK__VI         = 0x4291;
constexpr unsigned int mmDCP4_DCP_RANDOM_SEEDS__VI                      = 0x4261;
constexpr unsigned int mmDCP4_DCP_SPATIAL_DITHER_CNTL__VI               = 0x4260;
constexpr unsigned int mmDCP4_DCP_TEST_DEBUG_DATA__VI                   = 0x4296;
constexpr unsigned int mmDCP4_DCP_TEST_DEBUG_INDEX__VI                  = 0x4295;
constexpr unsigned int mmDCP4_DC_LUT_30_COLOR__VI                       = 0x427C;
constexpr unsigned int mmDCP4_DC_LUT_AUTOFILL__VI                       = 0x427F;
constexpr unsigned int mmDCP4_DC_LUT_BLACK_OFFSET_BLUE__VI              = 0x4281;
constexpr unsigned int mmDCP4_DC_LUT_BLACK_OFFSET_GREEN__VI             = 0x4282;
constexpr unsigned int mmDCP4_DC_LUT_BLACK_OFFSET_RED__VI               = 0x4283;
constexpr unsigned int mmDCP4_DC_LUT_CONTROL__VI                        = 0x4280;
constexpr unsigned int mmDCP4_DC_LUT_PWL_DATA__VI                       = 0x427B;
constexpr unsigned int mmDCP4_DC_LUT_RW_INDEX__VI                       = 0x4279;
constexpr unsigned int mmDCP4_DC_LUT_RW_MODE__VI                        = 0x4278;
constexpr unsigned int mmDCP4_DC_LUT_SEQ_COLOR__VI                      = 0x427A;
constexpr unsigned int mmDCP4_DC_LUT_VGA_ACCESS_ENABLE__VI              = 0x427D;
constexpr unsigned int mmDCP4_DC_LUT_WHITE_OFFSET_BLUE__VI              = 0x4284;
constexpr unsigned int mmDCP4_DC_LUT_WHITE_OFFSET_GREEN__VI             = 0x4285;
constexpr unsigned int mmDCP4_DC_LUT_WHITE_OFFSET_RED__VI               = 0x4286;
constexpr unsigned int mmDCP4_DC_LUT_WRITE_EN_MASK__VI                  = 0x427E;
constexpr unsigned int mmDCP4_DEGAMMA_CONTROL__VI                       = 0x4258;
constexpr unsigned int mmDCP4_DENORM_CONTROL__VI                        = 0x4250;
constexpr unsigned int mmDCP4_GAMUT_REMAP_C11_C12__VI                   = 0x425A;
constexpr unsigned int mmDCP4_GAMUT_REMAP_C13_C14__VI                   = 0x425B;
constexpr unsigned int mmDCP4_GAMUT_REMAP_C21_C22__VI                   = 0x425C;
constexpr unsigned int mmDCP4_GAMUT_REMAP_C23_C24__VI                   = 0x425D;
constexpr unsigned int mmDCP4_GAMUT_REMAP_C31_C32__VI                   = 0x425E;
constexpr unsigned int mmDCP4_GAMUT_REMAP_C33_C34__VI                   = 0x425F;
constexpr unsigned int mmDCP4_GAMUT_REMAP_CONTROL__VI                   = 0x4259;
constexpr unsigned int mmDCP4_GRPH_COMPRESS_PITCH__VI                   = 0x421A;
constexpr unsigned int mmDCP4_GRPH_COMPRESS_SURFACE_ADDRESS__VI         = 0x4219;
constexpr unsigned int mmDCP4_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH__VI    = 0x421B;
constexpr unsigned int mmDCP4_GRPH_CONTROL__SI__CI                      = 0x4601;
constexpr unsigned int mmDCP4_GRPH_CONTROL__VI                          = 0x4201;
constexpr unsigned int mmDCP4_GRPH_DFQ_CONTROL__VI                      = 0x4214;
constexpr unsigned int mmDCP4_GRPH_DFQ_STATUS__VI                       = 0x4215;
constexpr unsigned int mmDCP4_GRPH_ENABLE__VI                           = 0x4200;
constexpr unsigned int mmDCP4_GRPH_FLIP_CONTROL__SI__CI                 = 0x4612;
constexpr unsigned int mmDCP4_GRPH_FLIP_CONTROL__VI                     = 0x4212;
constexpr unsigned int mmDCP4_GRPH_FLIP_RATE_CNTL__VI                   = 0x428E;
constexpr unsigned int mmDCP4_GRPH_INTERRUPT_CONTROL__VI                = 0x4217;
constexpr unsigned int mmDCP4_GRPH_INTERRUPT_STATUS__VI                 = 0x4216;
constexpr unsigned int mmDCP4_GRPH_LUT_10BIT_BYPASS__VI                 = 0x4202;
constexpr unsigned int mmDCP4_GRPH_PITCH__SI__CI                        = 0x4606;
constexpr unsigned int mmDCP4_GRPH_PITCH__VI                            = 0x4206;
constexpr unsigned int mmDCP4_GRPH_PRIMARY_SURFACE_ADDRESS__SI__CI      = 0x4604;
constexpr unsigned int mmDCP4_GRPH_PRIMARY_SURFACE_ADDRESS__VI          = 0x4204;
constexpr unsigned int mmDCP4_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH__VI     = 0x4207;
constexpr unsigned int mmDCP4_GRPH_SECONDARY_SURFACE_ADDRESS__VI        = 0x4205;
constexpr unsigned int mmDCP4_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH__VI   = 0x4208;
constexpr unsigned int mmDCP4_GRPH_STEREOSYNC_FLIP__VI                  = 0x4297;
constexpr unsigned int mmDCP4_GRPH_SURFACE_ADDRESS_HIGH_INUSE__VI       = 0x4218;
constexpr unsigned int mmDCP4_GRPH_SURFACE_ADDRESS_INUSE__VI            = 0x4213;
constexpr unsigned int mmDCP4_GRPH_SURFACE_OFFSET_X__VI                 = 0x4209;
constexpr unsigned int mmDCP4_GRPH_SURFACE_OFFSET_Y__VI                 = 0x420A;
constexpr unsigned int mmDCP4_GRPH_SWAP_CNTL__VI                        = 0x4203;
constexpr unsigned int mmDCP4_GRPH_UPDATE__SI__CI                       = 0x4611;
constexpr unsigned int mmDCP4_GRPH_UPDATE__VI                           = 0x4211;
constexpr unsigned int mmDCP4_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL__VI    = 0x429F;
constexpr unsigned int mmDCP4_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS__VI  = 0x42BF;
constexpr unsigned int mmDCP4_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS__VI    = 0x42BD;
constexpr unsigned int mmDCP4_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH__VI  = 0x42BE;
constexpr unsigned int mmDCP4_GRPH_X_END__VI                            = 0x420D;
constexpr unsigned int mmDCP4_GRPH_X_START__VI                          = 0x420B;
constexpr unsigned int mmDCP4_GRPH_Y_END__VI                            = 0x420E;
constexpr unsigned int mmDCP4_GRPH_Y_START__VI                          = 0x420C;
constexpr unsigned int mmDCP4_HW_ROTATION__VI                           = 0x429E;
constexpr unsigned int mmDCP4_INPUT_CSC_C11_C12__VI                     = 0x4236;
constexpr unsigned int mmDCP4_INPUT_CSC_C13_C14__VI                     = 0x4237;
constexpr unsigned int mmDCP4_INPUT_CSC_C21_C22__VI                     = 0x4238;
constexpr unsigned int mmDCP4_INPUT_CSC_C23_C24__VI                     = 0x4239;
constexpr unsigned int mmDCP4_INPUT_CSC_C31_C32__VI                     = 0x423A;
constexpr unsigned int mmDCP4_INPUT_CSC_C33_C34__VI                     = 0x423B;
constexpr unsigned int mmDCP4_INPUT_CSC_CONTROL__VI                     = 0x4235;
constexpr unsigned int mmDCP4_INPUT_GAMMA_CONTROL__VI                   = 0x4210;
constexpr unsigned int mmDCP4_KEY_CONTROL__VI                           = 0x4253;
constexpr unsigned int mmDCP4_KEY_RANGE_ALPHA__VI                       = 0x4254;
constexpr unsigned int mmDCP4_KEY_RANGE_BLUE__VI                        = 0x4257;
constexpr unsigned int mmDCP4_KEY_RANGE_GREEN__VI                       = 0x4256;
constexpr unsigned int mmDCP4_KEY_RANGE_RED__VI                         = 0x4255;
constexpr unsigned int mmDCP4_OUTPUT_CSC_C11_C12__VI                    = 0x423D;
constexpr unsigned int mmDCP4_OUTPUT_CSC_C13_C14__VI                    = 0x423E;
constexpr unsigned int mmDCP4_OUTPUT_CSC_C21_C22__VI                    = 0x423F;
constexpr unsigned int mmDCP4_OUTPUT_CSC_C23_C24__VI                    = 0x4240;
constexpr unsigned int mmDCP4_OUTPUT_CSC_C31_C32__VI                    = 0x4241;
constexpr unsigned int mmDCP4_OUTPUT_CSC_C33_C34__VI                    = 0x4242;
constexpr unsigned int mmDCP4_OUTPUT_CSC_CONTROL__VI                    = 0x423C;
constexpr unsigned int mmDCP4_OUT_CLAMP_CONTROL_B_CB__VI                = 0x429D;
constexpr unsigned int mmDCP4_OUT_CLAMP_CONTROL_G_Y__VI                 = 0x429C;
constexpr unsigned int mmDCP4_OUT_CLAMP_CONTROL_R_CR__VI                = 0x4252;
constexpr unsigned int mmDCP4_OUT_ROUND_CONTROL__VI                     = 0x4251;
constexpr unsigned int mmDCP4_OVLSCL_EDGE_PIXEL_CNTL__VI                = 0x422C;
constexpr unsigned int mmDCP4_OVL_CONTROL1__VI                          = 0x421D;
constexpr unsigned int mmDCP4_OVL_CONTROL2__VI                          = 0x421E;
constexpr unsigned int mmDCP4_OVL_DFQ_CONTROL__VI                       = 0x4229;
constexpr unsigned int mmDCP4_OVL_DFQ_STATUS__VI                        = 0x422A;
constexpr unsigned int mmDCP4_OVL_ENABLE__VI                            = 0x421C;
constexpr unsigned int mmDCP4_OVL_END__VI                               = 0x4226;
constexpr unsigned int mmDCP4_OVL_PITCH__VI                             = 0x4221;
constexpr unsigned int mmDCP4_OVL_SECONDARY_SURFACE_ADDRESS__VI         = 0x4292;
constexpr unsigned int mmDCP4_OVL_SECONDARY_SURFACE_ADDRESS_HIGH__VI    = 0x4294;
constexpr unsigned int mmDCP4_OVL_START__VI                             = 0x4225;
constexpr unsigned int mmDCP4_OVL_STEREOSYNC_FLIP__VI                   = 0x4293;
constexpr unsigned int mmDCP4_OVL_SURFACE_ADDRESS__SI__CI               = 0x4620;
constexpr unsigned int mmDCP4_OVL_SURFACE_ADDRESS__VI                   = 0x4220;
constexpr unsigned int mmDCP4_OVL_SURFACE_ADDRESS_HIGH__VI              = 0x4222;
constexpr unsigned int mmDCP4_OVL_SURFACE_ADDRESS_HIGH_INUSE__VI        = 0x422B;
constexpr unsigned int mmDCP4_OVL_SURFACE_ADDRESS_INUSE__VI             = 0x4228;
constexpr unsigned int mmDCP4_OVL_SURFACE_OFFSET_X__VI                  = 0x4223;
constexpr unsigned int mmDCP4_OVL_SURFACE_OFFSET_Y__VI                  = 0x4224;
constexpr unsigned int mmDCP4_OVL_SWAP_CNTL__VI                         = 0x421F;
constexpr unsigned int mmDCP4_OVL_UPDATE__VI                            = 0x4227;
constexpr unsigned int mmDCP4_PRESCALE_GRPH_CONTROL__VI                 = 0x422D;
constexpr unsigned int mmDCP4_PRESCALE_OVL_CONTROL__VI                  = 0x4231;
constexpr unsigned int mmDCP4_PRESCALE_VALUES_GRPH_B__VI                = 0x4230;
constexpr unsigned int mmDCP4_PRESCALE_VALUES_GRPH_G__VI                = 0x422F;
constexpr unsigned int mmDCP4_PRESCALE_VALUES_GRPH_R__VI                = 0x422E;
constexpr unsigned int mmDCP4_PRESCALE_VALUES_OVL_CB__VI                = 0x4232;
constexpr unsigned int mmDCP4_PRESCALE_VALUES_OVL_CR__VI                = 0x4234;
constexpr unsigned int mmDCP4_PRESCALE_VALUES_OVL_Y__VI                 = 0x4233;
constexpr unsigned int mmDCP4_REGAMMA_CNTLA_END_CNTL1__VI               = 0x42A6;
constexpr unsigned int mmDCP4_REGAMMA_CNTLA_END_CNTL2__VI               = 0x42A7;
constexpr unsigned int mmDCP4_REGAMMA_CNTLA_REGION_0_1__VI              = 0x42A8;
constexpr unsigned int mmDCP4_REGAMMA_CNTLA_REGION_10_11__VI            = 0x42AD;
constexpr unsigned int mmDCP4_REGAMMA_CNTLA_REGION_12_13__VI            = 0x42AE;
constexpr unsigned int mmDCP4_REGAMMA_CNTLA_REGION_14_15__VI            = 0x42AF;
constexpr unsigned int mmDCP4_REGAMMA_CNTLA_REGION_2_3__VI              = 0x42A9;
constexpr unsigned int mmDCP4_REGAMMA_CNTLA_REGION_4_5__VI              = 0x42AA;
constexpr unsigned int mmDCP4_REGAMMA_CNTLA_REGION_6_7__VI              = 0x42AB;
constexpr unsigned int mmDCP4_REGAMMA_CNTLA_REGION_8_9__VI              = 0x42AC;
constexpr unsigned int mmDCP4_REGAMMA_CNTLA_SLOPE_CNTL__VI              = 0x42A5;
constexpr unsigned int mmDCP4_REGAMMA_CNTLA_START_CNTL__VI              = 0x42A4;
constexpr unsigned int mmDCP4_REGAMMA_CNTLB_END_CNTL1__VI               = 0x42B2;
constexpr unsigned int mmDCP4_REGAMMA_CNTLB_END_CNTL2__VI               = 0x42B3;
constexpr unsigned int mmDCP4_REGAMMA_CNTLB_REGION_0_1__VI              = 0x42B4;
constexpr unsigned int mmDCP4_REGAMMA_CNTLB_REGION_10_11__VI            = 0x42B9;
constexpr unsigned int mmDCP4_REGAMMA_CNTLB_REGION_12_13__VI            = 0x42BA;
constexpr unsigned int mmDCP4_REGAMMA_CNTLB_REGION_14_15__VI            = 0x42BB;
constexpr unsigned int mmDCP4_REGAMMA_CNTLB_REGION_2_3__VI              = 0x42B5;
constexpr unsigned int mmDCP4_REGAMMA_CNTLB_REGION_4_5__VI              = 0x42B6;
constexpr unsigned int mmDCP4_REGAMMA_CNTLB_REGION_6_7__VI              = 0x42B7;
constexpr unsigned int mmDCP4_REGAMMA_CNTLB_REGION_8_9__VI              = 0x42B8;
constexpr unsigned int mmDCP4_REGAMMA_CNTLB_SLOPE_CNTL__VI              = 0x42B1;
constexpr unsigned int mmDCP4_REGAMMA_CNTLB_START_CNTL__VI              = 0x42B0;
constexpr unsigned int mmDCP4_REGAMMA_CONTROL__VI                       = 0x42A0;
constexpr unsigned int mmDCP4_REGAMMA_LUT_DATA__VI                      = 0x42A2;
constexpr unsigned int mmDCP4_REGAMMA_LUT_INDEX__VI                     = 0x42A1;
constexpr unsigned int mmDCP4_REGAMMA_LUT_WRITE_EN_MASK__VI             = 0x42A3;
constexpr unsigned int mmDCP5_ALPHA_CONTROL__VI                         = 0x44BC;
constexpr unsigned int mmDCP5_COMM_MATRIXA_TRANS_C11_C12__VI            = 0x4443;
constexpr unsigned int mmDCP5_COMM_MATRIXA_TRANS_C13_C14__VI            = 0x4444;
constexpr unsigned int mmDCP5_COMM_MATRIXA_TRANS_C21_C22__VI            = 0x4445;
constexpr unsigned int mmDCP5_COMM_MATRIXA_TRANS_C23_C24__VI            = 0x4446;
constexpr unsigned int mmDCP5_COMM_MATRIXA_TRANS_C31_C32__VI            = 0x4447;
constexpr unsigned int mmDCP5_COMM_MATRIXA_TRANS_C33_C34__VI            = 0x4448;
constexpr unsigned int mmDCP5_COMM_MATRIXB_TRANS_C11_C12__VI            = 0x4449;
constexpr unsigned int mmDCP5_COMM_MATRIXB_TRANS_C13_C14__VI            = 0x444A;
constexpr unsigned int mmDCP5_COMM_MATRIXB_TRANS_C21_C22__VI            = 0x444B;
constexpr unsigned int mmDCP5_COMM_MATRIXB_TRANS_C23_C24__VI            = 0x444C;
constexpr unsigned int mmDCP5_COMM_MATRIXB_TRANS_C31_C32__VI            = 0x444D;
constexpr unsigned int mmDCP5_COMM_MATRIXB_TRANS_C33_C34__VI            = 0x444E;
constexpr unsigned int mmDCP5_CUR2_COLOR1__VI                           = 0x4475;
constexpr unsigned int mmDCP5_CUR2_COLOR2__VI                           = 0x4476;
constexpr unsigned int mmDCP5_CUR2_CONTROL__VI                          = 0x446F;
constexpr unsigned int mmDCP5_CUR2_HOT_SPOT__VI                         = 0x4474;
constexpr unsigned int mmDCP5_CUR2_POSITION__VI                         = 0x4473;
constexpr unsigned int mmDCP5_CUR2_SIZE__VI                             = 0x4471;
constexpr unsigned int mmDCP5_CUR2_STEREO_CONTROL__VI                   = 0x449B;
constexpr unsigned int mmDCP5_CUR2_SURFACE_ADDRESS__VI                  = 0x4470;
constexpr unsigned int mmDCP5_CUR2_SURFACE_ADDRESS_HIGH__VI             = 0x4472;
constexpr unsigned int mmDCP5_CUR2_UPDATE__VI                           = 0x4477;
constexpr unsigned int mmDCP5_CUR_COLOR1__VI                            = 0x446C;
constexpr unsigned int mmDCP5_CUR_COLOR2__VI                            = 0x446D;
constexpr unsigned int mmDCP5_CUR_CONTROL__VI                           = 0x4466;
constexpr unsigned int mmDCP5_CUR_HOT_SPOT__VI                          = 0x446B;
constexpr unsigned int mmDCP5_CUR_POSITION__VI                          = 0x446A;
constexpr unsigned int mmDCP5_CUR_REQUEST_FILTER_CNTL__VI               = 0x4499;
constexpr unsigned int mmDCP5_CUR_SIZE__VI                              = 0x4468;
constexpr unsigned int mmDCP5_CUR_STEREO_CONTROL__VI                    = 0x449A;
constexpr unsigned int mmDCP5_CUR_SURFACE_ADDRESS__VI                   = 0x4467;
constexpr unsigned int mmDCP5_CUR_SURFACE_ADDRESS_HIGH__VI              = 0x4469;
constexpr unsigned int mmDCP5_CUR_UPDATE__VI                            = 0x446E;
constexpr unsigned int mmDCP5_DCP_CRC_CONTROL__VI                       = 0x4487;
constexpr unsigned int mmDCP5_DCP_CRC_CURRENT__VI                       = 0x4489;
constexpr unsigned int mmDCP5_DCP_CRC_LAST__VI                          = 0x448B;
constexpr unsigned int mmDCP5_DCP_CRC_MASK__VI                          = 0x4488;
constexpr unsigned int mmDCP5_DCP_DEBUG__VI                             = 0x448D;
constexpr unsigned int mmDCP5_DCP_DEBUG2__VI                            = 0x4498;
constexpr unsigned int mmDCP5_DCP_FP_CONVERTED_FIELD__VI                = 0x4465;
constexpr unsigned int mmDCP5_DCP_GSL_CONTROL__VI                       = 0x4490;
constexpr unsigned int mmDCP5_DCP_LB_DATA_GAP_BETWEEN_CHUNK__VI         = 0x4491;
constexpr unsigned int mmDCP5_DCP_RANDOM_SEEDS__VI                      = 0x4461;
constexpr unsigned int mmDCP5_DCP_SPATIAL_DITHER_CNTL__VI               = 0x4460;
constexpr unsigned int mmDCP5_DCP_TEST_DEBUG_DATA__VI                   = 0x4496;
constexpr unsigned int mmDCP5_DCP_TEST_DEBUG_INDEX__VI                  = 0x4495;
constexpr unsigned int mmDCP5_DC_LUT_30_COLOR__VI                       = 0x447C;
constexpr unsigned int mmDCP5_DC_LUT_AUTOFILL__VI                       = 0x447F;
constexpr unsigned int mmDCP5_DC_LUT_BLACK_OFFSET_BLUE__VI              = 0x4481;
constexpr unsigned int mmDCP5_DC_LUT_BLACK_OFFSET_GREEN__VI             = 0x4482;
constexpr unsigned int mmDCP5_DC_LUT_BLACK_OFFSET_RED__VI               = 0x4483;
constexpr unsigned int mmDCP5_DC_LUT_CONTROL__VI                        = 0x4480;
constexpr unsigned int mmDCP5_DC_LUT_PWL_DATA__VI                       = 0x447B;
constexpr unsigned int mmDCP5_DC_LUT_RW_INDEX__VI                       = 0x4479;
constexpr unsigned int mmDCP5_DC_LUT_RW_MODE__VI                        = 0x4478;
constexpr unsigned int mmDCP5_DC_LUT_SEQ_COLOR__VI                      = 0x447A;
constexpr unsigned int mmDCP5_DC_LUT_VGA_ACCESS_ENABLE__VI              = 0x447D;
constexpr unsigned int mmDCP5_DC_LUT_WHITE_OFFSET_BLUE__VI              = 0x4484;
constexpr unsigned int mmDCP5_DC_LUT_WHITE_OFFSET_GREEN__VI             = 0x4485;
constexpr unsigned int mmDCP5_DC_LUT_WHITE_OFFSET_RED__VI               = 0x4486;
constexpr unsigned int mmDCP5_DC_LUT_WRITE_EN_MASK__VI                  = 0x447E;
constexpr unsigned int mmDCP5_DEGAMMA_CONTROL__VI                       = 0x4458;
constexpr unsigned int mmDCP5_DENORM_CONTROL__VI                        = 0x4450;
constexpr unsigned int mmDCP5_GAMUT_REMAP_C11_C12__VI                   = 0x445A;
constexpr unsigned int mmDCP5_GAMUT_REMAP_C13_C14__VI                   = 0x445B;
constexpr unsigned int mmDCP5_GAMUT_REMAP_C21_C22__VI                   = 0x445C;
constexpr unsigned int mmDCP5_GAMUT_REMAP_C23_C24__VI                   = 0x445D;
constexpr unsigned int mmDCP5_GAMUT_REMAP_C31_C32__VI                   = 0x445E;
constexpr unsigned int mmDCP5_GAMUT_REMAP_C33_C34__VI                   = 0x445F;
constexpr unsigned int mmDCP5_GAMUT_REMAP_CONTROL__VI                   = 0x4459;
constexpr unsigned int mmDCP5_GRPH_COMPRESS_PITCH__VI                   = 0x441A;
constexpr unsigned int mmDCP5_GRPH_COMPRESS_SURFACE_ADDRESS__VI         = 0x4419;
constexpr unsigned int mmDCP5_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH__VI    = 0x441B;
constexpr unsigned int mmDCP5_GRPH_CONTROL__SI__CI                      = 0x4901;
constexpr unsigned int mmDCP5_GRPH_CONTROL__VI                          = 0x4401;
constexpr unsigned int mmDCP5_GRPH_DFQ_CONTROL__VI                      = 0x4414;
constexpr unsigned int mmDCP5_GRPH_DFQ_STATUS__VI                       = 0x4415;
constexpr unsigned int mmDCP5_GRPH_ENABLE__VI                           = 0x4400;
constexpr unsigned int mmDCP5_GRPH_FLIP_CONTROL__SI__CI                 = 0x4912;
constexpr unsigned int mmDCP5_GRPH_FLIP_CONTROL__VI                     = 0x4412;
constexpr unsigned int mmDCP5_GRPH_FLIP_RATE_CNTL__VI                   = 0x448E;
constexpr unsigned int mmDCP5_GRPH_INTERRUPT_CONTROL__VI                = 0x4417;
constexpr unsigned int mmDCP5_GRPH_INTERRUPT_STATUS__VI                 = 0x4416;
constexpr unsigned int mmDCP5_GRPH_LUT_10BIT_BYPASS__VI                 = 0x4402;
constexpr unsigned int mmDCP5_GRPH_PITCH__SI__CI                        = 0x4906;
constexpr unsigned int mmDCP5_GRPH_PITCH__VI                            = 0x4406;
constexpr unsigned int mmDCP5_GRPH_PRIMARY_SURFACE_ADDRESS__SI__CI      = 0x4904;
constexpr unsigned int mmDCP5_GRPH_PRIMARY_SURFACE_ADDRESS__VI          = 0x4404;
constexpr unsigned int mmDCP5_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH__VI     = 0x4407;
constexpr unsigned int mmDCP5_GRPH_SECONDARY_SURFACE_ADDRESS__VI        = 0x4405;
constexpr unsigned int mmDCP5_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH__VI   = 0x4408;
constexpr unsigned int mmDCP5_GRPH_STEREOSYNC_FLIP__VI                  = 0x4497;
constexpr unsigned int mmDCP5_GRPH_SURFACE_ADDRESS_HIGH_INUSE__VI       = 0x4418;
constexpr unsigned int mmDCP5_GRPH_SURFACE_ADDRESS_INUSE__VI            = 0x4413;
constexpr unsigned int mmDCP5_GRPH_SURFACE_OFFSET_X__VI                 = 0x4409;
constexpr unsigned int mmDCP5_GRPH_SURFACE_OFFSET_Y__VI                 = 0x440A;
constexpr unsigned int mmDCP5_GRPH_SWAP_CNTL__VI                        = 0x4403;
constexpr unsigned int mmDCP5_GRPH_UPDATE__SI__CI                       = 0x4911;
constexpr unsigned int mmDCP5_GRPH_UPDATE__VI                           = 0x4411;
constexpr unsigned int mmDCP5_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL__VI    = 0x449F;
constexpr unsigned int mmDCP5_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS__VI  = 0x44BF;
constexpr unsigned int mmDCP5_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS__VI    = 0x44BD;
constexpr unsigned int mmDCP5_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH__VI  = 0x44BE;
constexpr unsigned int mmDCP5_GRPH_X_END__VI                            = 0x440D;
constexpr unsigned int mmDCP5_GRPH_X_START__VI                          = 0x440B;
constexpr unsigned int mmDCP5_GRPH_Y_END__VI                            = 0x440E;
constexpr unsigned int mmDCP5_GRPH_Y_START__VI                          = 0x440C;
constexpr unsigned int mmDCP5_HW_ROTATION__VI                           = 0x449E;
constexpr unsigned int mmDCP5_INPUT_CSC_C11_C12__VI                     = 0x4436;
constexpr unsigned int mmDCP5_INPUT_CSC_C13_C14__VI                     = 0x4437;
constexpr unsigned int mmDCP5_INPUT_CSC_C21_C22__VI                     = 0x4438;
constexpr unsigned int mmDCP5_INPUT_CSC_C23_C24__VI                     = 0x4439;
constexpr unsigned int mmDCP5_INPUT_CSC_C31_C32__VI                     = 0x443A;
constexpr unsigned int mmDCP5_INPUT_CSC_C33_C34__VI                     = 0x443B;
constexpr unsigned int mmDCP5_INPUT_CSC_CONTROL__VI                     = 0x4435;
constexpr unsigned int mmDCP5_INPUT_GAMMA_CONTROL__VI                   = 0x4410;
constexpr unsigned int mmDCP5_KEY_CONTROL__VI                           = 0x4453;
constexpr unsigned int mmDCP5_KEY_RANGE_ALPHA__VI                       = 0x4454;
constexpr unsigned int mmDCP5_KEY_RANGE_BLUE__VI                        = 0x4457;
constexpr unsigned int mmDCP5_KEY_RANGE_GREEN__VI                       = 0x4456;
constexpr unsigned int mmDCP5_KEY_RANGE_RED__VI                         = 0x4455;
constexpr unsigned int mmDCP5_OUTPUT_CSC_C11_C12__VI                    = 0x443D;
constexpr unsigned int mmDCP5_OUTPUT_CSC_C13_C14__VI                    = 0x443E;
constexpr unsigned int mmDCP5_OUTPUT_CSC_C21_C22__VI                    = 0x443F;
constexpr unsigned int mmDCP5_OUTPUT_CSC_C23_C24__VI                    = 0x4440;
constexpr unsigned int mmDCP5_OUTPUT_CSC_C31_C32__VI                    = 0x4441;
constexpr unsigned int mmDCP5_OUTPUT_CSC_C33_C34__VI                    = 0x4442;
constexpr unsigned int mmDCP5_OUTPUT_CSC_CONTROL__VI                    = 0x443C;
constexpr unsigned int mmDCP5_OUT_CLAMP_CONTROL_B_CB__VI                = 0x449D;
constexpr unsigned int mmDCP5_OUT_CLAMP_CONTROL_G_Y__VI                 = 0x449C;
constexpr unsigned int mmDCP5_OUT_CLAMP_CONTROL_R_CR__VI                = 0x4452;
constexpr unsigned int mmDCP5_OUT_ROUND_CONTROL__VI                     = 0x4451;
constexpr unsigned int mmDCP5_OVLSCL_EDGE_PIXEL_CNTL__VI                = 0x442C;
constexpr unsigned int mmDCP5_OVL_CONTROL1__VI                          = 0x441D;
constexpr unsigned int mmDCP5_OVL_CONTROL2__VI                          = 0x441E;
constexpr unsigned int mmDCP5_OVL_DFQ_CONTROL__VI                       = 0x4429;
constexpr unsigned int mmDCP5_OVL_DFQ_STATUS__VI                        = 0x442A;
constexpr unsigned int mmDCP5_OVL_ENABLE__VI                            = 0x441C;
constexpr unsigned int mmDCP5_OVL_END__VI                               = 0x4426;
constexpr unsigned int mmDCP5_OVL_PITCH__VI                             = 0x4421;
constexpr unsigned int mmDCP5_OVL_SECONDARY_SURFACE_ADDRESS__VI         = 0x4492;
constexpr unsigned int mmDCP5_OVL_SECONDARY_SURFACE_ADDRESS_HIGH__VI    = 0x4494;
constexpr unsigned int mmDCP5_OVL_START__VI                             = 0x4425;
constexpr unsigned int mmDCP5_OVL_STEREOSYNC_FLIP__VI                   = 0x4493;
constexpr unsigned int mmDCP5_OVL_SURFACE_ADDRESS__SI__CI               = 0x4920;
constexpr unsigned int mmDCP5_OVL_SURFACE_ADDRESS__VI                   = 0x4420;
constexpr unsigned int mmDCP5_OVL_SURFACE_ADDRESS_HIGH__VI              = 0x4422;
constexpr unsigned int mmDCP5_OVL_SURFACE_ADDRESS_HIGH_INUSE__VI        = 0x442B;
constexpr unsigned int mmDCP5_OVL_SURFACE_ADDRESS_INUSE__VI             = 0x4428;
constexpr unsigned int mmDCP5_OVL_SURFACE_OFFSET_X__VI                  = 0x4423;
constexpr unsigned int mmDCP5_OVL_SURFACE_OFFSET_Y__VI                  = 0x4424;
constexpr unsigned int mmDCP5_OVL_SWAP_CNTL__VI                         = 0x441F;
constexpr unsigned int mmDCP5_OVL_UPDATE__VI                            = 0x4427;
constexpr unsigned int mmDCP5_PRESCALE_GRPH_CONTROL__VI                 = 0x442D;
constexpr unsigned int mmDCP5_PRESCALE_OVL_CONTROL__VI                  = 0x4431;
constexpr unsigned int mmDCP5_PRESCALE_VALUES_GRPH_B__VI                = 0x4430;
constexpr unsigned int mmDCP5_PRESCALE_VALUES_GRPH_G__VI                = 0x442F;
constexpr unsigned int mmDCP5_PRESCALE_VALUES_GRPH_R__VI                = 0x442E;
constexpr unsigned int mmDCP5_PRESCALE_VALUES_OVL_CB__VI                = 0x4432;
constexpr unsigned int mmDCP5_PRESCALE_VALUES_OVL_CR__VI                = 0x4434;
constexpr unsigned int mmDCP5_PRESCALE_VALUES_OVL_Y__VI                 = 0x4433;
constexpr unsigned int mmDCP5_REGAMMA_CNTLA_END_CNTL1__VI               = 0x44A6;
constexpr unsigned int mmDCP5_REGAMMA_CNTLA_END_CNTL2__VI               = 0x44A7;
constexpr unsigned int mmDCP5_REGAMMA_CNTLA_REGION_0_1__VI              = 0x44A8;
constexpr unsigned int mmDCP5_REGAMMA_CNTLA_REGION_10_11__VI            = 0x44AD;
constexpr unsigned int mmDCP5_REGAMMA_CNTLA_REGION_12_13__VI            = 0x44AE;
constexpr unsigned int mmDCP5_REGAMMA_CNTLA_REGION_14_15__VI            = 0x44AF;
constexpr unsigned int mmDCP5_REGAMMA_CNTLA_REGION_2_3__VI              = 0x44A9;
constexpr unsigned int mmDCP5_REGAMMA_CNTLA_REGION_4_5__VI              = 0x44AA;
constexpr unsigned int mmDCP5_REGAMMA_CNTLA_REGION_6_7__VI              = 0x44AB;
constexpr unsigned int mmDCP5_REGAMMA_CNTLA_REGION_8_9__VI              = 0x44AC;
constexpr unsigned int mmDCP5_REGAMMA_CNTLA_SLOPE_CNTL__VI              = 0x44A5;
constexpr unsigned int mmDCP5_REGAMMA_CNTLA_START_CNTL__VI              = 0x44A4;
constexpr unsigned int mmDCP5_REGAMMA_CNTLB_END_CNTL1__VI               = 0x44B2;
constexpr unsigned int mmDCP5_REGAMMA_CNTLB_END_CNTL2__VI               = 0x44B3;
constexpr unsigned int mmDCP5_REGAMMA_CNTLB_REGION_0_1__VI              = 0x44B4;
constexpr unsigned int mmDCP5_REGAMMA_CNTLB_REGION_10_11__VI            = 0x44B9;
constexpr unsigned int mmDCP5_REGAMMA_CNTLB_REGION_12_13__VI            = 0x44BA;
constexpr unsigned int mmDCP5_REGAMMA_CNTLB_REGION_14_15__VI            = 0x44BB;
constexpr unsigned int mmDCP5_REGAMMA_CNTLB_REGION_2_3__VI              = 0x44B5;
constexpr unsigned int mmDCP5_REGAMMA_CNTLB_REGION_4_5__VI              = 0x44B6;
constexpr unsigned int mmDCP5_REGAMMA_CNTLB_REGION_6_7__VI              = 0x44B7;
constexpr unsigned int mmDCP5_REGAMMA_CNTLB_REGION_8_9__VI              = 0x44B8;
constexpr unsigned int mmDCP5_REGAMMA_CNTLB_SLOPE_CNTL__VI              = 0x44B1;
constexpr unsigned int mmDCP5_REGAMMA_CNTLB_START_CNTL__VI              = 0x44B0;
constexpr unsigned int mmDCP5_REGAMMA_CONTROL__VI                       = 0x44A0;
constexpr unsigned int mmDCP5_REGAMMA_LUT_DATA__VI                      = 0x44A2;
constexpr unsigned int mmDCP5_REGAMMA_LUT_INDEX__VI                     = 0x44A1;
constexpr unsigned int mmDCP5_REGAMMA_LUT_WRITE_EN_MASK__VI             = 0x44A3;
constexpr unsigned int mmDCPG_TEST_DEBUG_DATA__VI                       = 0x02D7;
constexpr unsigned int mmDCPG_TEST_DEBUG_INDEX__VI                      = 0x02D6;
constexpr unsigned int mmDCP_DEBUG2__VI                                 = 0x1A98;
constexpr unsigned int mmDCP_FP_CONVERTED_FIELD__VI                     = 0x1A65;
constexpr unsigned int mmDCP_GSL_CONTROL__VI                            = 0x1A90;
constexpr unsigned int mmDCP_RANDOM_SEEDS__VI                           = 0x1A61;
constexpr unsigned int mmDCP_SPATIAL_DITHER_CNTL__VI                    = 0x1A60;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED0__VI              = 0x5A84;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED1__VI              = 0x5A85;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED10__VI             = 0x5A8E;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED100__VI            = 0x5AE8;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED101__VI            = 0x5AE9;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED102__VI            = 0x5AEA;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED103__VI            = 0x5AEB;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED104__VI            = 0x5AEC;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED105__VI            = 0x5AED;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED106__VI            = 0x5AEE;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED107__VI            = 0x5AEF;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED108__VI            = 0x5AF0;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED109__VI            = 0x5AF1;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED11__VI             = 0x5A8F;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED110__VI            = 0x5AF2;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED111__VI            = 0x5AF3;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED112__VI            = 0x5AF4;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED113__VI            = 0x5AF5;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED114__VI            = 0x5AF6;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED115__VI            = 0x5AF7;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED116__VI            = 0x5AF8;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED117__VI            = 0x5AF9;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED118__VI            = 0x5AFA;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED119__VI            = 0x5AFB;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED12__VI             = 0x5A90;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED120__VI            = 0x5AFC;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED121__VI            = 0x5AFD;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED122__VI            = 0x5AFE;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED123__VI            = 0x5AFF;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED124__VI            = 0x5B00;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED125__VI            = 0x5B01;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED126__VI            = 0x5B02;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED127__VI            = 0x5B03;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED128__VI            = 0x5B04;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED129__VI            = 0x5B05;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED13__VI             = 0x5A91;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED130__VI            = 0x5B06;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED131__VI            = 0x5B07;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED132__VI            = 0x5B08;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED133__VI            = 0x5B09;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED134__VI            = 0x5B0A;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED135__VI            = 0x5B0B;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED136__VI            = 0x5B0C;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED137__VI            = 0x5B0D;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED138__VI            = 0x5B0E;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED139__VI            = 0x5B0F;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED14__VI             = 0x5A92;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED140__VI            = 0x5B10;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED141__VI            = 0x5B11;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED142__VI            = 0x5B12;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED143__VI            = 0x5B13;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED144__VI            = 0x5B14;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED145__VI            = 0x5B15;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED146__VI            = 0x5B16;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED147__VI            = 0x5B17;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED148__VI            = 0x5B18;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED149__VI            = 0x5B19;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED15__VI             = 0x5A93;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED150__VI            = 0x5B1A;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED151__VI            = 0x5B1B;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED152__VI            = 0x5B1C;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED153__VI            = 0x5B1D;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED154__VI            = 0x5B1E;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED155__VI            = 0x5B1F;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED156__VI            = 0x5B20;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED157__VI            = 0x5B21;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED158__VI            = 0x5B22;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED159__VI            = 0x5B23;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED16__VI             = 0x5A94;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED160__VI            = 0x5B24;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED161__VI            = 0x5B25;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED162__VI            = 0x5B26;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED163__VI            = 0x5B27;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED164__VI            = 0x5B28;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED165__VI            = 0x5B29;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED166__VI            = 0x5B2A;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED167__VI            = 0x5B2B;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED168__VI            = 0x5B2C;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED169__VI            = 0x5B2D;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED17__VI             = 0x5A95;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED170__VI            = 0x5B2E;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED171__VI            = 0x5B2F;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED172__VI            = 0x5B30;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED173__VI            = 0x5B31;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED174__VI            = 0x5B32;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED175__VI            = 0x5B33;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED176__VI            = 0x5B34;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED177__VI            = 0x5B35;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED178__VI            = 0x5B36;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED179__VI            = 0x5B37;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED18__VI             = 0x5A96;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED180__VI            = 0x5B38;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED181__VI            = 0x5B39;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED182__VI            = 0x5B3A;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED183__VI            = 0x5B3B;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED184__VI            = 0x5B3C;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED185__VI            = 0x5B3D;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED186__VI            = 0x5B3E;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED187__VI            = 0x5B3F;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED188__VI            = 0x5B40;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED189__VI            = 0x5B41;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED19__VI             = 0x5A97;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED190__VI            = 0x5B42;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED191__VI            = 0x5B43;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED192__VI            = 0x5B44;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED193__VI            = 0x5B45;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED194__VI            = 0x5B46;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED195__VI            = 0x5B47;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED196__VI            = 0x5B48;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED197__VI            = 0x5B49;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED198__VI            = 0x5B4A;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED199__VI            = 0x5B4B;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED2__VI              = 0x5A86;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED20__VI             = 0x5A98;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED200__VI            = 0x5B4C;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED201__VI            = 0x5B4D;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED202__VI            = 0x5B4E;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED203__VI            = 0x5B4F;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED204__VI            = 0x5B50;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED205__VI            = 0x5B51;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED206__VI            = 0x5B52;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED207__VI            = 0x5B53;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED208__VI            = 0x5B54;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED209__VI            = 0x5B55;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED21__VI             = 0x5A99;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED210__VI            = 0x5B56;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED211__VI            = 0x5B57;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED212__VI            = 0x5B58;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED213__VI            = 0x5B59;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED214__VI            = 0x5B5A;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED215__VI            = 0x5B5B;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED216__VI            = 0x5B5C;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED217__VI            = 0x5B5D;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED218__VI            = 0x5B5E;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED219__VI            = 0x5B5F;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED22__VI             = 0x5A9A;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED220__VI            = 0x5B60;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED221__VI            = 0x5B61;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED222__VI            = 0x5B62;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED223__VI            = 0x5B63;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED224__VI            = 0x5B64;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED225__VI            = 0x5B65;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED226__VI            = 0x5B66;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED227__VI            = 0x5B67;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED228__VI            = 0x5B68;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED229__VI            = 0x5B69;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED23__VI             = 0x5A9B;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED230__VI            = 0x5B6A;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED231__VI            = 0x5B6B;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED232__VI            = 0x5B6C;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED233__VI            = 0x5B6D;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED234__VI            = 0x5B6E;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED235__VI            = 0x5B6F;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED236__VI            = 0x5B70;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED237__VI            = 0x5B71;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED238__VI            = 0x5B72;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED239__VI            = 0x5B73;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED24__VI             = 0x5A9C;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED240__VI            = 0x5B74;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED241__VI            = 0x5B75;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED242__VI            = 0x5B76;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED243__VI            = 0x5B77;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED244__VI            = 0x5B78;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED245__VI            = 0x5B79;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED246__VI            = 0x5B7A;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED247__VI            = 0x5B7B;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED248__VI            = 0x5B7C;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED249__VI            = 0x5B7D;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED25__VI             = 0x5A9D;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED250__VI            = 0x5B7E;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED251__VI            = 0x5B7F;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED252__VI            = 0x5B80;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED253__VI            = 0x5B81;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED254__VI            = 0x5B82;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED255__VI            = 0x5B83;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED256__VI            = 0x5B84;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED257__VI            = 0x5B85;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED258__VI            = 0x5B86;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED259__VI            = 0x5B87;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED26__VI             = 0x5A9E;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED260__VI            = 0x5B88;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED261__VI            = 0x5B89;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED262__VI            = 0x5B8A;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED263__VI            = 0x5B8B;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED264__VI            = 0x5B8C;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED265__VI            = 0x5B8D;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED266__VI            = 0x5B8E;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED267__VI            = 0x5B8F;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED268__VI            = 0x5B90;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED269__VI            = 0x5B91;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED27__VI             = 0x5A9F;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED270__VI            = 0x5B92;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED271__VI            = 0x5B93;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED272__VI            = 0x5B94;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED273__VI            = 0x5B95;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED274__VI            = 0x5B96;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED275__VI            = 0x5B97;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED276__VI            = 0x5B98;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED277__VI            = 0x5B99;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED278__VI            = 0x5B9A;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED279__VI            = 0x5B9B;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED28__VI             = 0x5AA0;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED280__VI            = 0x5B9C;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED281__VI            = 0x5B9D;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED282__VI            = 0x5B9E;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED283__VI            = 0x5B9F;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED284__VI            = 0x5BA0;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED285__VI            = 0x5BA1;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED286__VI            = 0x5BA2;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED287__VI            = 0x5BA3;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED288__VI            = 0x5BA4;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED289__VI            = 0x5BA5;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED29__VI             = 0x5AA1;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED290__VI            = 0x5BA6;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED291__VI            = 0x5BA7;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED292__VI            = 0x5BA8;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED293__VI            = 0x5BA9;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED294__VI            = 0x5BAA;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED295__VI            = 0x5BAB;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED296__VI            = 0x5BAC;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED297__VI            = 0x5BAD;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED298__VI            = 0x5BAE;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED299__VI            = 0x5BAF;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED3__VI              = 0x5A87;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED30__VI             = 0x5AA2;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED300__VI            = 0x5BB0;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED301__VI            = 0x5BB1;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED302__VI            = 0x5BB2;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED303__VI            = 0x5BB3;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED304__VI            = 0x5BB4;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED305__VI            = 0x5BB5;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED306__VI            = 0x5BB6;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED307__VI            = 0x5BB7;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED308__VI            = 0x5BB8;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED309__VI            = 0x5BB9;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED31__VI             = 0x5AA3;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED310__VI            = 0x5BBA;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED311__VI            = 0x5BBB;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED312__VI            = 0x5BBC;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED313__VI            = 0x5BBD;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED314__VI            = 0x5BBE;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED315__VI            = 0x5BBF;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED316__VI            = 0x5BC0;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED317__VI            = 0x5BC1;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED318__VI            = 0x5BC2;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED319__VI            = 0x5BC3;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED32__VI             = 0x5AA4;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED320__VI            = 0x5BC4;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED321__VI            = 0x5BC5;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED322__VI            = 0x5BC6;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED323__VI            = 0x5BC7;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED324__VI            = 0x5BC8;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED325__VI            = 0x5BC9;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED326__VI            = 0x5BCA;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED327__VI            = 0x5BCB;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED328__VI            = 0x5BCC;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED329__VI            = 0x5BCD;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED33__VI             = 0x5AA5;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED330__VI            = 0x5BCE;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED331__VI            = 0x5BCF;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED332__VI            = 0x5BD0;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED333__VI            = 0x5BD1;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED334__VI            = 0x5BD2;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED335__VI            = 0x5BD3;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED336__VI            = 0x5BD4;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED337__VI            = 0x5BD5;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED338__VI            = 0x5BD6;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED339__VI            = 0x5BD7;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED34__VI             = 0x5AA6;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED340__VI            = 0x5BD8;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED341__VI            = 0x5BD9;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED342__VI            = 0x5BDA;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED343__VI            = 0x5BDB;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED344__VI            = 0x5BDC;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED345__VI            = 0x5BDD;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED346__VI            = 0x5BDE;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED347__VI            = 0x5BDF;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED348__VI            = 0x5BE0;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED349__VI            = 0x5BE1;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED35__VI             = 0x5AA7;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED350__VI            = 0x5BE2;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED351__VI            = 0x5BE3;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED352__VI            = 0x5BE4;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED353__VI            = 0x5BE5;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED354__VI            = 0x5BE6;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED355__VI            = 0x5BE7;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED356__VI            = 0x5BE8;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED357__VI            = 0x5BE9;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED358__VI            = 0x5BEA;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED359__VI            = 0x5BEB;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED36__VI             = 0x5AA8;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED360__VI            = 0x5BEC;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED361__VI            = 0x5BED;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED362__VI            = 0x5BEE;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED363__VI            = 0x5BEF;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED364__VI            = 0x5BF0;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED365__VI            = 0x5BF1;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED366__VI            = 0x5BF2;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED367__VI            = 0x5BF3;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED368__VI            = 0x5BF4;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED369__VI            = 0x5BF5;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED37__VI             = 0x5AA9;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED370__VI            = 0x5BF6;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED371__VI            = 0x5BF7;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED372__VI            = 0x5BF8;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED373__VI            = 0x5BF9;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED374__VI            = 0x5BFA;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED375__VI            = 0x5BFB;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED376__VI            = 0x5BFC;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED377__VI            = 0x5BFD;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED378__VI            = 0x5BFE;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED379__VI            = 0x5BFF;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED38__VI             = 0x5AAA;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED39__VI             = 0x5AAB;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED4__VI              = 0x5A88;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED40__VI             = 0x5AAC;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED41__VI             = 0x5AAD;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED42__VI             = 0x5AAE;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED43__VI             = 0x5AAF;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED44__VI             = 0x5AB0;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED45__VI             = 0x5AB1;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED46__VI             = 0x5AB2;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED47__VI             = 0x5AB3;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED48__VI             = 0x5AB4;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED49__VI             = 0x5AB5;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED5__VI              = 0x5A89;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED50__VI             = 0x5AB6;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED51__VI             = 0x5AB7;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED52__VI             = 0x5AB8;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED53__VI             = 0x5AB9;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED54__VI             = 0x5ABA;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED55__VI             = 0x5ABB;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED56__VI             = 0x5ABC;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED57__VI             = 0x5ABD;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED58__VI             = 0x5ABE;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED59__VI             = 0x5ABF;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED6__VI              = 0x5A8A;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED60__VI             = 0x5AC0;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED61__VI             = 0x5AC1;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED62__VI             = 0x5AC2;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED63__VI             = 0x5AC3;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED64__VI             = 0x5AC4;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED65__VI             = 0x5AC5;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED66__VI             = 0x5AC6;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED67__VI             = 0x5AC7;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED68__VI             = 0x5AC8;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED69__VI             = 0x5AC9;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED7__VI              = 0x5A8B;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED70__VI             = 0x5ACA;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED71__VI             = 0x5ACB;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED72__VI             = 0x5ACC;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED73__VI             = 0x5ACD;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED74__VI             = 0x5ACE;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED75__VI             = 0x5ACF;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED76__VI             = 0x5AD0;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED77__VI             = 0x5AD1;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED78__VI             = 0x5AD2;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED79__VI             = 0x5AD3;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED8__VI              = 0x5A8C;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED80__VI             = 0x5AD4;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED81__VI             = 0x5AD5;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED82__VI             = 0x5AD6;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED83__VI             = 0x5AD7;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED84__VI             = 0x5AD8;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED85__VI             = 0x5AD9;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED86__VI             = 0x5ADA;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED87__VI             = 0x5ADB;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED88__VI             = 0x5ADC;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED89__VI             = 0x5ADD;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED9__VI              = 0x5A8D;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED90__VI             = 0x5ADE;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED91__VI             = 0x5ADF;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED92__VI             = 0x5AE0;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED93__VI             = 0x5AE1;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED94__VI             = 0x5AE2;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED95__VI             = 0x5AE3;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED96__VI             = 0x5AE4;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED97__VI             = 0x5AE5;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED98__VI             = 0x5AE6;
constexpr unsigned int mmDCRX_PHY_MACRO_CNTL_RESERVED99__VI             = 0x5AE7;
constexpr unsigned int mmDC_ABM1_OVERSCAN_PIXEL_VALUE__VI               = 0x169B;
constexpr unsigned int mmDC_DVODATA_CONFIG__VI                          = 0x481A;
constexpr unsigned int mmDC_GENERICA__VI                                = 0x4800;
constexpr unsigned int mmDC_GENERICB__VI                                = 0x4801;
constexpr unsigned int mmDC_GPIO_DDC1_A__VI                             = 0x4869;
constexpr unsigned int mmDC_GPIO_DDC1_EN__VI                            = 0x486A;
constexpr unsigned int mmDC_GPIO_DDC1_MASK__VI                          = 0x4868;
constexpr unsigned int mmDC_GPIO_DDC1_Y__VI                             = 0x486B;
constexpr unsigned int mmDC_GPIO_DDC2_A__VI                             = 0x486D;
constexpr unsigned int mmDC_GPIO_DDC2_EN__VI                            = 0x486E;
constexpr unsigned int mmDC_GPIO_DDC2_MASK__VI                          = 0x486C;
constexpr unsigned int mmDC_GPIO_DDC2_Y__VI                             = 0x486F;
constexpr unsigned int mmDC_GPIO_DDC3_A__VI                             = 0x4871;
constexpr unsigned int mmDC_GPIO_DDC3_EN__VI                            = 0x4872;
constexpr unsigned int mmDC_GPIO_DDC3_MASK__VI                          = 0x4870;
constexpr unsigned int mmDC_GPIO_DDC3_Y__VI                             = 0x4873;
constexpr unsigned int mmDC_GPIO_DDC4_A__VI                             = 0x4875;
constexpr unsigned int mmDC_GPIO_DDC4_EN__VI                            = 0x4876;
constexpr unsigned int mmDC_GPIO_DDC4_MASK__VI                          = 0x4874;
constexpr unsigned int mmDC_GPIO_DDC4_Y__VI                             = 0x4877;
constexpr unsigned int mmDC_GPIO_DDC5_A__VI                             = 0x4879;
constexpr unsigned int mmDC_GPIO_DDC5_EN__VI                            = 0x487A;
constexpr unsigned int mmDC_GPIO_DDC5_MASK__VI                          = 0x4878;
constexpr unsigned int mmDC_GPIO_DDC5_Y__VI                             = 0x487B;
constexpr unsigned int mmDC_GPIO_DDC6_A__VI                             = 0x487D;
constexpr unsigned int mmDC_GPIO_DDC6_EN__VI                            = 0x487E;
constexpr unsigned int mmDC_GPIO_DDC6_MASK__VI                          = 0x487C;
constexpr unsigned int mmDC_GPIO_DDC6_Y__VI                             = 0x487F;
constexpr unsigned int mmDC_GPIO_DDCVGA_A__VI                           = 0x4881;
constexpr unsigned int mmDC_GPIO_DDCVGA_EN__VI                          = 0x4882;
constexpr unsigned int mmDC_GPIO_DDCVGA_MASK__VI                        = 0x4880;
constexpr unsigned int mmDC_GPIO_DDCVGA_Y__VI                           = 0x4883;
constexpr unsigned int mmDC_GPIO_DEBUG__VI                              = 0x4804;
constexpr unsigned int mmDC_GPIO_DVODATA_A__VI                          = 0x4865;
constexpr unsigned int mmDC_GPIO_DVODATA_EN__VI                         = 0x4866;
constexpr unsigned int mmDC_GPIO_DVODATA_MASK__VI                       = 0x4864;
constexpr unsigned int mmDC_GPIO_DVODATA_Y__VI                          = 0x4867;
constexpr unsigned int mmDC_GPIO_GENERIC_A__VI                          = 0x4861;
constexpr unsigned int mmDC_GPIO_GENERIC_EN__VI                         = 0x4862;
constexpr unsigned int mmDC_GPIO_GENERIC_MASK__VI                       = 0x4860;
constexpr unsigned int mmDC_GPIO_GENERIC_Y__VI                          = 0x4863;
constexpr unsigned int mmDC_GPIO_GENLK_A__VI                            = 0x4889;
constexpr unsigned int mmDC_GPIO_GENLK_EN__VI                           = 0x488A;
constexpr unsigned int mmDC_GPIO_GENLK_MASK__VI                         = 0x4888;
constexpr unsigned int mmDC_GPIO_GENLK_Y__VI                            = 0x488B;
constexpr unsigned int mmDC_GPIO_HPD_A__VI                              = 0x488D;
constexpr unsigned int mmDC_GPIO_HPD_EN__VI                             = 0x488E;
constexpr unsigned int mmDC_GPIO_HPD_MASK__VI                           = 0x488C;
constexpr unsigned int mmDC_GPIO_HPD_Y__VI                              = 0x488F;
constexpr unsigned int mmDC_GPIO_I2CPAD_A__VI                           = 0x4899;
constexpr unsigned int mmDC_GPIO_I2CPAD_EN__VI                          = 0x489A;
constexpr unsigned int mmDC_GPIO_I2CPAD_MASK__VI                        = 0x4898;
constexpr unsigned int mmDC_GPIO_I2CPAD_STRENGTH__VI                    = 0x489C;
constexpr unsigned int mmDC_GPIO_I2CPAD_Y__VI                           = 0x489B;
constexpr unsigned int mmDC_GPIO_PAD_STRENGTH_1__VI                     = 0x4894;
constexpr unsigned int mmDC_GPIO_PAD_STRENGTH_2__VI                     = 0x4895;
constexpr unsigned int mmDC_GPIO_PWRSEQ_A__VI                           = 0x4891;
constexpr unsigned int mmDC_GPIO_PWRSEQ_EN__VI                          = 0x4892;
constexpr unsigned int mmDC_GPIO_PWRSEQ_MASK__VI                        = 0x4890;
constexpr unsigned int mmDC_GPIO_PWRSEQ_Y__VI                           = 0x4893;
constexpr unsigned int mmDC_GPIO_SYNCA_A__VI                            = 0x4885;
constexpr unsigned int mmDC_GPIO_SYNCA_EN__VI                           = 0x4886;
constexpr unsigned int mmDC_GPIO_SYNCA_MASK__VI                         = 0x4884;
constexpr unsigned int mmDC_GPIO_SYNCA_Y__VI                            = 0x4887;
constexpr unsigned int mmDC_GPU_TIMER_READ__VI                          = 0x482B;
constexpr unsigned int mmDC_GPU_TIMER_READ_CNTL__VI                     = 0x482C;
constexpr unsigned int mmDC_GPU_TIMER_START_POSITION_P_FLIP__VI         = 0x482A;
constexpr unsigned int mmDC_GPU_TIMER_START_POSITION_V_UPDATE__VI       = 0x4829;
constexpr unsigned int mmDC_HPD_CONTROL__VI                             = 0x189A;
constexpr unsigned int mmDC_HPD_FAST_TRAIN_CNTL__VI                     = 0x189B;
constexpr unsigned int mmDC_HPD_INT_CONTROL__VI                         = 0x1899;
constexpr unsigned int mmDC_HPD_INT_STATUS__VI                          = 0x1898;
constexpr unsigned int mmDC_HPD_TOGGLE_FILT_CNTL__VI                    = 0x189C;
constexpr unsigned int mmDC_I2C_ARBITRATION__VI                         = 0x16D5;
constexpr unsigned int mmDC_I2C_CONTROL__VI                             = 0x16D4;
constexpr unsigned int mmDC_I2C_DATA__VI                                = 0x16EE;
constexpr unsigned int mmDC_I2C_DDC1_HW_STATUS__VI                      = 0x16D8;
constexpr unsigned int mmDC_I2C_DDC1_SETUP__VI                          = 0x16DF;
constexpr unsigned int mmDC_I2C_DDC1_SPEED__VI                          = 0x16DE;
constexpr unsigned int mmDC_I2C_DDC2_HW_STATUS__VI                      = 0x16D9;
constexpr unsigned int mmDC_I2C_DDC2_SETUP__VI                          = 0x16E1;
constexpr unsigned int mmDC_I2C_DDC2_SPEED__VI                          = 0x16E0;
constexpr unsigned int mmDC_I2C_DDC3_HW_STATUS__VI                      = 0x16DA;
constexpr unsigned int mmDC_I2C_DDC3_SETUP__VI                          = 0x16E3;
constexpr unsigned int mmDC_I2C_DDC3_SPEED__VI                          = 0x16E2;
constexpr unsigned int mmDC_I2C_DDC4_HW_STATUS__VI                      = 0x16DB;
constexpr unsigned int mmDC_I2C_DDC4_SETUP__VI                          = 0x16E5;
constexpr unsigned int mmDC_I2C_DDC4_SPEED__VI                          = 0x16E4;
constexpr unsigned int mmDC_I2C_DDC5_HW_STATUS__VI                      = 0x16DC;
constexpr unsigned int mmDC_I2C_DDC5_SETUP__VI                          = 0x16E7;
constexpr unsigned int mmDC_I2C_DDC5_SPEED__VI                          = 0x16E6;
constexpr unsigned int mmDC_I2C_DDC6_HW_STATUS__VI                      = 0x16DD;
constexpr unsigned int mmDC_I2C_DDC6_SETUP__VI                          = 0x16E9;
constexpr unsigned int mmDC_I2C_DDC6_SPEED__VI                          = 0x16E8;
constexpr unsigned int mmDC_I2C_DDCVGA_HW_STATUS__VI                    = 0x16EF;
constexpr unsigned int mmDC_I2C_DDCVGA_SETUP__VI                        = 0x16F1;
constexpr unsigned int mmDC_I2C_DDCVGA_SPEED__VI                        = 0x16F0;
constexpr unsigned int mmDC_I2C_EDID_DETECT_CTRL__VI                    = 0x16F2;
constexpr unsigned int mmDC_I2C_INTERRUPT_CONTROL__VI                   = 0x16D6;
constexpr unsigned int mmDC_I2C_SW_STATUS__VI                           = 0x16D7;
constexpr unsigned int mmDC_I2C_TRANSACTION0__VI                        = 0x16EA;
constexpr unsigned int mmDC_I2C_TRANSACTION1__VI                        = 0x16EB;
constexpr unsigned int mmDC_I2C_TRANSACTION2__VI                        = 0x16EC;
constexpr unsigned int mmDC_I2C_TRANSACTION3__VI                        = 0x16ED;
constexpr unsigned int mmDC_IP_REQUEST_CNTL__VI                         = 0x02D2;
constexpr unsigned int mmDC_LUT_VGA_ACCESS_ENABLE__VI                   = 0x1A7D;
constexpr unsigned int mmDC_MEM_GLOBAL_PWR_REQ_CNTL__VI                 = 0x0132;
constexpr unsigned int mmDC_MVP_LB_CONTROL__VI                          = 0x1AE3;
constexpr unsigned int mmDC_PAD_EXTERN_SIG__VI                          = 0x4802;
constexpr unsigned int mmDC_PERFMON0_PERFCOUNTER_CNTL__VI               = 0x0170;
constexpr unsigned int mmDC_PERFMON0_PERFCOUNTER_STATE__VI              = 0x0171;
constexpr unsigned int mmDC_PERFMON0_PERFMON_CNTL__VI                   = 0x0173;
constexpr unsigned int mmDC_PERFMON0_PERFMON_CNTL2__VI                  = 0x017A;
constexpr unsigned int mmDC_PERFMON0_PERFMON_CVALUE_INT_MISC__VI        = 0x0172;
constexpr unsigned int mmDC_PERFMON0_PERFMON_CVALUE_LOW__VI             = 0x0174;
constexpr unsigned int mmDC_PERFMON0_PERFMON_HI__VI                     = 0x0175;
constexpr unsigned int mmDC_PERFMON0_PERFMON_LOW__VI                    = 0x0176;
constexpr unsigned int mmDC_PERFMON0_PERFMON_TEST_DEBUG_DATA__VI        = 0x0178;
constexpr unsigned int mmDC_PERFMON0_PERFMON_TEST_DEBUG_INDEX__VI       = 0x0177;
constexpr unsigned int mmDC_PERFMON10_PERFCOUNTER_CNTL__VI              = 0x59A0;
constexpr unsigned int mmDC_PERFMON10_PERFCOUNTER_STATE__VI             = 0x59A1;
constexpr unsigned int mmDC_PERFMON10_PERFMON_CNTL__VI                  = 0x59A3;
constexpr unsigned int mmDC_PERFMON10_PERFMON_CNTL2__VI                 = 0x59AA;
constexpr unsigned int mmDC_PERFMON10_PERFMON_CVALUE_INT_MISC__VI       = 0x59A2;
constexpr unsigned int mmDC_PERFMON10_PERFMON_CVALUE_LOW__VI            = 0x59A4;
constexpr unsigned int mmDC_PERFMON10_PERFMON_HI__VI                    = 0x59A5;
constexpr unsigned int mmDC_PERFMON10_PERFMON_LOW__VI                   = 0x59A6;
constexpr unsigned int mmDC_PERFMON10_PERFMON_TEST_DEBUG_DATA__VI       = 0x59A8;
constexpr unsigned int mmDC_PERFMON10_PERFMON_TEST_DEBUG_INDEX__VI      = 0x59A7;
constexpr unsigned int mmDC_PERFMON11_PERFCOUNTER_CNTL__VI              = 0x4724;
constexpr unsigned int mmDC_PERFMON11_PERFCOUNTER_STATE__VI             = 0x4725;
constexpr unsigned int mmDC_PERFMON11_PERFMON_CNTL__VI                  = 0x4727;
constexpr unsigned int mmDC_PERFMON11_PERFMON_CNTL2__VI                 = 0x472E;
constexpr unsigned int mmDC_PERFMON11_PERFMON_CVALUE_INT_MISC__VI       = 0x4726;
constexpr unsigned int mmDC_PERFMON11_PERFMON_CVALUE_LOW__VI            = 0x4728;
constexpr unsigned int mmDC_PERFMON11_PERFMON_HI__VI                    = 0x4729;
constexpr unsigned int mmDC_PERFMON11_PERFMON_LOW__VI                   = 0x472A;
constexpr unsigned int mmDC_PERFMON11_PERFMON_TEST_DEBUG_DATA__VI       = 0x472C;
constexpr unsigned int mmDC_PERFMON11_PERFMON_TEST_DEBUG_INDEX__VI      = 0x472B;
constexpr unsigned int mmDC_PERFMON1_PERFCOUNTER_CNTL__VI               = 0x0364;
constexpr unsigned int mmDC_PERFMON1_PERFCOUNTER_STATE__VI              = 0x0365;
constexpr unsigned int mmDC_PERFMON1_PERFMON_CNTL__VI                   = 0x0367;
constexpr unsigned int mmDC_PERFMON1_PERFMON_CNTL2__VI                  = 0x036E;
constexpr unsigned int mmDC_PERFMON1_PERFMON_CVALUE_INT_MISC__VI        = 0x0366;
constexpr unsigned int mmDC_PERFMON1_PERFMON_CVALUE_LOW__VI             = 0x0368;
constexpr unsigned int mmDC_PERFMON1_PERFMON_HI__VI                     = 0x0369;
constexpr unsigned int mmDC_PERFMON1_PERFMON_LOW__VI                    = 0x036A;
constexpr unsigned int mmDC_PERFMON1_PERFMON_TEST_DEBUG_DATA__VI        = 0x036C;
constexpr unsigned int mmDC_PERFMON1_PERFMON_TEST_DEBUG_INDEX__VI       = 0x036B;
constexpr unsigned int mmDC_PERFMON2_PERFCOUNTER_CNTL__VI               = 0x18C8;
constexpr unsigned int mmDC_PERFMON2_PERFCOUNTER_STATE__VI              = 0x18C9;
constexpr unsigned int mmDC_PERFMON2_PERFMON_CNTL__VI                   = 0x18CB;
constexpr unsigned int mmDC_PERFMON2_PERFMON_CNTL2__VI                  = 0x18D2;
constexpr unsigned int mmDC_PERFMON2_PERFMON_CVALUE_INT_MISC__VI        = 0x18CA;
constexpr unsigned int mmDC_PERFMON2_PERFMON_CVALUE_LOW__VI             = 0x18CC;
constexpr unsigned int mmDC_PERFMON2_PERFMON_HI__VI                     = 0x18CD;
constexpr unsigned int mmDC_PERFMON2_PERFMON_LOW__VI                    = 0x18CE;
constexpr unsigned int mmDC_PERFMON2_PERFMON_TEST_DEBUG_DATA__VI        = 0x18D0;
constexpr unsigned int mmDC_PERFMON2_PERFMON_TEST_DEBUG_INDEX__VI       = 0x18CF;
constexpr unsigned int mmDC_PERFMON3_PERFCOUNTER_CNTL__VI               = 0x1B24;
constexpr unsigned int mmDC_PERFMON3_PERFCOUNTER_STATE__VI              = 0x1B25;
constexpr unsigned int mmDC_PERFMON3_PERFMON_CNTL__VI                   = 0x1B27;
constexpr unsigned int mmDC_PERFMON3_PERFMON_CNTL2__VI                  = 0x1B2E;
constexpr unsigned int mmDC_PERFMON3_PERFMON_CVALUE_INT_MISC__VI        = 0x1B26;
constexpr unsigned int mmDC_PERFMON3_PERFMON_CVALUE_LOW__VI             = 0x1B28;
constexpr unsigned int mmDC_PERFMON3_PERFMON_HI__VI                     = 0x1B29;
constexpr unsigned int mmDC_PERFMON3_PERFMON_LOW__VI                    = 0x1B2A;
constexpr unsigned int mmDC_PERFMON3_PERFMON_TEST_DEBUG_DATA__VI        = 0x1B2C;
constexpr unsigned int mmDC_PERFMON3_PERFMON_TEST_DEBUG_INDEX__VI       = 0x1B2B;
constexpr unsigned int mmDC_PERFMON4_PERFCOUNTER_CNTL__VI               = 0x1D24;
constexpr unsigned int mmDC_PERFMON4_PERFCOUNTER_STATE__VI              = 0x1D25;
constexpr unsigned int mmDC_PERFMON4_PERFMON_CNTL__VI                   = 0x1D27;
constexpr unsigned int mmDC_PERFMON4_PERFMON_CNTL2__VI                  = 0x1D2E;
constexpr unsigned int mmDC_PERFMON4_PERFMON_CVALUE_INT_MISC__VI        = 0x1D26;
constexpr unsigned int mmDC_PERFMON4_PERFMON_CVALUE_LOW__VI             = 0x1D28;
constexpr unsigned int mmDC_PERFMON4_PERFMON_HI__VI                     = 0x1D29;
constexpr unsigned int mmDC_PERFMON4_PERFMON_LOW__VI                    = 0x1D2A;
constexpr unsigned int mmDC_PERFMON4_PERFMON_TEST_DEBUG_DATA__VI        = 0x1D2C;
constexpr unsigned int mmDC_PERFMON4_PERFMON_TEST_DEBUG_INDEX__VI       = 0x1D2B;
constexpr unsigned int mmDC_PERFMON5_PERFCOUNTER_CNTL__VI               = 0x1F24;
constexpr unsigned int mmDC_PERFMON5_PERFCOUNTER_STATE__VI              = 0x1F25;
constexpr unsigned int mmDC_PERFMON5_PERFMON_CNTL__VI                   = 0x1F27;
constexpr unsigned int mmDC_PERFMON5_PERFMON_CNTL2__VI                  = 0x1F2E;
constexpr unsigned int mmDC_PERFMON5_PERFMON_CVALUE_INT_MISC__VI        = 0x1F26;
constexpr unsigned int mmDC_PERFMON5_PERFMON_CVALUE_LOW__VI             = 0x1F28;
constexpr unsigned int mmDC_PERFMON5_PERFMON_HI__VI                     = 0x1F29;
constexpr unsigned int mmDC_PERFMON5_PERFMON_LOW__VI                    = 0x1F2A;
constexpr unsigned int mmDC_PERFMON5_PERFMON_TEST_DEBUG_DATA__VI        = 0x1F2C;
constexpr unsigned int mmDC_PERFMON5_PERFMON_TEST_DEBUG_INDEX__VI       = 0x1F2B;
constexpr unsigned int mmDC_PERFMON6_PERFCOUNTER_CNTL__VI               = 0x4124;
constexpr unsigned int mmDC_PERFMON6_PERFCOUNTER_STATE__VI              = 0x4125;
constexpr unsigned int mmDC_PERFMON6_PERFMON_CNTL__VI                   = 0x4127;
constexpr unsigned int mmDC_PERFMON6_PERFMON_CNTL2__VI                  = 0x412E;
constexpr unsigned int mmDC_PERFMON6_PERFMON_CVALUE_INT_MISC__VI        = 0x4126;
constexpr unsigned int mmDC_PERFMON6_PERFMON_CVALUE_LOW__VI             = 0x4128;
constexpr unsigned int mmDC_PERFMON6_PERFMON_HI__VI                     = 0x4129;
constexpr unsigned int mmDC_PERFMON6_PERFMON_LOW__VI                    = 0x412A;
constexpr unsigned int mmDC_PERFMON6_PERFMON_TEST_DEBUG_DATA__VI        = 0x412C;
constexpr unsigned int mmDC_PERFMON6_PERFMON_TEST_DEBUG_INDEX__VI       = 0x412B;
constexpr unsigned int mmDC_PERFMON7_PERFCOUNTER_CNTL__VI               = 0x4324;
constexpr unsigned int mmDC_PERFMON7_PERFCOUNTER_STATE__VI              = 0x4325;
constexpr unsigned int mmDC_PERFMON7_PERFMON_CNTL__VI                   = 0x4327;
constexpr unsigned int mmDC_PERFMON7_PERFMON_CNTL2__VI                  = 0x432E;
constexpr unsigned int mmDC_PERFMON7_PERFMON_CVALUE_INT_MISC__VI        = 0x4326;
constexpr unsigned int mmDC_PERFMON7_PERFMON_CVALUE_LOW__VI             = 0x4328;
constexpr unsigned int mmDC_PERFMON7_PERFMON_HI__VI                     = 0x4329;
constexpr unsigned int mmDC_PERFMON7_PERFMON_LOW__VI                    = 0x432A;
constexpr unsigned int mmDC_PERFMON7_PERFMON_TEST_DEBUG_DATA__VI        = 0x432C;
constexpr unsigned int mmDC_PERFMON7_PERFMON_TEST_DEBUG_INDEX__VI       = 0x432B;
constexpr unsigned int mmDC_PERFMON8_PERFCOUNTER_CNTL__VI               = 0x4524;
constexpr unsigned int mmDC_PERFMON8_PERFCOUNTER_STATE__VI              = 0x4525;
constexpr unsigned int mmDC_PERFMON8_PERFMON_CNTL__VI                   = 0x4527;
constexpr unsigned int mmDC_PERFMON8_PERFMON_CNTL2__VI                  = 0x452E;
constexpr unsigned int mmDC_PERFMON8_PERFMON_CVALUE_INT_MISC__VI        = 0x4526;
constexpr unsigned int mmDC_PERFMON8_PERFMON_CVALUE_LOW__VI             = 0x4528;
constexpr unsigned int mmDC_PERFMON8_PERFMON_HI__VI                     = 0x4529;
constexpr unsigned int mmDC_PERFMON8_PERFMON_LOW__VI                    = 0x452A;
constexpr unsigned int mmDC_PERFMON8_PERFMON_TEST_DEBUG_DATA__VI        = 0x452C;
constexpr unsigned int mmDC_PERFMON8_PERFMON_TEST_DEBUG_INDEX__VI       = 0x452B;
constexpr unsigned int mmDC_PERFMON9_PERFCOUNTER_CNTL__VI               = 0x5F68;
constexpr unsigned int mmDC_PERFMON9_PERFCOUNTER_STATE__VI              = 0x5F69;
constexpr unsigned int mmDC_PERFMON9_PERFMON_CNTL__VI                   = 0x5F6B;
constexpr unsigned int mmDC_PERFMON9_PERFMON_CNTL2__VI                  = 0x5F72;
constexpr unsigned int mmDC_PERFMON9_PERFMON_CVALUE_INT_MISC__VI        = 0x5F6A;
constexpr unsigned int mmDC_PERFMON9_PERFMON_CVALUE_LOW__VI             = 0x5F6C;
constexpr unsigned int mmDC_PERFMON9_PERFMON_HI__VI                     = 0x5F6D;
constexpr unsigned int mmDC_PERFMON9_PERFMON_LOW__VI                    = 0x5F6E;
constexpr unsigned int mmDC_PERFMON9_PERFMON_TEST_DEBUG_DATA__VI        = 0x5F70;
constexpr unsigned int mmDC_PERFMON9_PERFMON_TEST_DEBUG_INDEX__VI       = 0x5F6F;
constexpr unsigned int mmDC_PGCNTL_STATUS_REG__VI                       = 0x02D5;
constexpr unsigned int mmDC_PGFSM_CONFIG_REG__VI                        = 0x02D3;
constexpr unsigned int mmDC_PGFSM_WRITE_REG__VI                         = 0x02D4;
constexpr unsigned int mmDC_PINSTRAPS__VI                               = 0x4818;
constexpr unsigned int mmDC_REF_CLK_CNTL__VI                            = 0x4803;
constexpr unsigned int mmDC_TEST_DEBUG_DATA__VI                         = 0x157D;
constexpr unsigned int mmDC_TEST_DEBUG_INDEX__VI                        = 0x157C;
constexpr unsigned int mmDEGAMMA_CONTROL__VI                            = 0x1A58;
constexpr unsigned int mmDENORM_CLAMP_CONTROL__VI                       = 0x46C3;
constexpr unsigned int mmDENORM_CLAMP_RANGE_B_CB__VI                    = 0x46C6;
constexpr unsigned int mmDENORM_CLAMP_RANGE_G_Y__VI                     = 0x46C5;
constexpr unsigned int mmDENORM_CLAMP_RANGE_R_CR__VI                    = 0x46C4;
constexpr unsigned int mmDENORM_CONTROL__VI                             = 0x1A50;
constexpr unsigned int mmDENTIST_DISPCLK_CNTL__VI                       = 0x0124;
constexpr unsigned int mmDIG0_AFMT_60958_0__VI                          = 0x4A38;
constexpr unsigned int mmDIG0_AFMT_60958_1__VI                          = 0x4A39;
constexpr unsigned int mmDIG0_AFMT_60958_2__VI                          = 0x4A3F;
constexpr unsigned int mmDIG0_AFMT_AUDIO_CRC_CONTROL__VI                = 0x4A3A;
constexpr unsigned int mmDIG0_AFMT_AUDIO_CRC_RESULT__VI                 = 0x4A40;
constexpr unsigned int mmDIG0_AFMT_AUDIO_DBG_DTO_CNTL__VI               = 0x4A46;
constexpr unsigned int mmDIG0_AFMT_AUDIO_INFO0__VI                      = 0x4A36;
constexpr unsigned int mmDIG0_AFMT_AUDIO_INFO1__VI                      = 0x4A37;
constexpr unsigned int mmDIG0_AFMT_AUDIO_PACKET_CONTROL__VI             = 0x4A42;
constexpr unsigned int mmDIG0_AFMT_AUDIO_PACKET_CONTROL2__VI            = 0x4A14;
constexpr unsigned int mmDIG0_AFMT_AUDIO_SRC_CONTROL__VI                = 0x4A45;
constexpr unsigned int mmDIG0_AFMT_AVI_INFO0__VI                        = 0x4A1E;
constexpr unsigned int mmDIG0_AFMT_AVI_INFO1__VI                        = 0x4A1F;
constexpr unsigned int mmDIG0_AFMT_AVI_INFO2__VI                        = 0x4A20;
constexpr unsigned int mmDIG0_AFMT_AVI_INFO3__VI                        = 0x4A21;
constexpr unsigned int mmDIG0_AFMT_GENERIC_0__VI                        = 0x4A25;
constexpr unsigned int mmDIG0_AFMT_GENERIC_1__VI                        = 0x4A26;
constexpr unsigned int mmDIG0_AFMT_GENERIC_2__VI                        = 0x4A27;
constexpr unsigned int mmDIG0_AFMT_GENERIC_3__VI                        = 0x4A28;
constexpr unsigned int mmDIG0_AFMT_GENERIC_4__VI                        = 0x4A29;
constexpr unsigned int mmDIG0_AFMT_GENERIC_5__VI                        = 0x4A2A;
constexpr unsigned int mmDIG0_AFMT_GENERIC_6__VI                        = 0x4A2B;
constexpr unsigned int mmDIG0_AFMT_GENERIC_7__VI                        = 0x4A2C;
constexpr unsigned int mmDIG0_AFMT_GENERIC_HDR__VI                      = 0x4A24;
constexpr unsigned int mmDIG0_AFMT_INFOFRAME_CONTROL0__VI               = 0x4A44;
constexpr unsigned int mmDIG0_AFMT_ISRC1_0__VI                          = 0x4A15;
constexpr unsigned int mmDIG0_AFMT_ISRC1_1__VI                          = 0x4A16;
constexpr unsigned int mmDIG0_AFMT_ISRC1_2__VI                          = 0x4A17;
constexpr unsigned int mmDIG0_AFMT_ISRC1_3__VI                          = 0x4A18;
constexpr unsigned int mmDIG0_AFMT_ISRC1_4__VI                          = 0x4A19;
constexpr unsigned int mmDIG0_AFMT_ISRC2_0__VI                          = 0x4A1A;
constexpr unsigned int mmDIG0_AFMT_ISRC2_1__VI                          = 0x4A1B;
constexpr unsigned int mmDIG0_AFMT_ISRC2_2__VI                          = 0x4A1C;
constexpr unsigned int mmDIG0_AFMT_ISRC2_3__VI                          = 0x4A1D;
constexpr unsigned int mmDIG0_AFMT_MPEG_INFO0__VI                       = 0x4A22;
constexpr unsigned int mmDIG0_AFMT_MPEG_INFO1__VI                       = 0x4A23;
constexpr unsigned int mmDIG0_AFMT_RAMP_CONTROL0__VI                    = 0x4A3B;
constexpr unsigned int mmDIG0_AFMT_RAMP_CONTROL1__VI                    = 0x4A3C;
constexpr unsigned int mmDIG0_AFMT_RAMP_CONTROL2__VI                    = 0x4A3D;
constexpr unsigned int mmDIG0_AFMT_RAMP_CONTROL3__VI                    = 0x4A3E;
constexpr unsigned int mmDIG0_AFMT_STATUS__VI                           = 0x4A41;
constexpr unsigned int mmDIG0_AFMT_VBI_PACKET_CONTROL__VI               = 0x4A43;
constexpr unsigned int mmDIG0_DIG_BE_CNTL__VI                           = 0x4A47;
constexpr unsigned int mmDIG0_DIG_BE_EN_CNTL__VI                        = 0x4A48;
constexpr unsigned int mmDIG0_DIG_CLOCK_PATTERN__VI                     = 0x4A03;
constexpr unsigned int mmDIG0_DIG_DISPCLK_SWITCH_CNTL__VI               = 0x4A07;
constexpr unsigned int mmDIG0_DIG_DISPCLK_SWITCH_STATUS__VI             = 0x4A08;
constexpr unsigned int mmDIG0_DIG_FE_CNTL__VI                           = 0x4A00;
constexpr unsigned int mmDIG0_DIG_FE_TEST_DEBUG_DATA__VI                = 0x4A7D;
constexpr unsigned int mmDIG0_DIG_FE_TEST_DEBUG_INDEX__VI               = 0x4A7C;
constexpr unsigned int mmDIG0_DIG_FIFO_STATUS__VI                       = 0x4A06;
constexpr unsigned int mmDIG0_DIG_LANE_ENABLE__VI                       = 0x4A79;
constexpr unsigned int mmDIG0_DIG_OUTPUT_CRC_CNTL__VI                   = 0x4A01;
constexpr unsigned int mmDIG0_DIG_OUTPUT_CRC_RESULT__VI                 = 0x4A02;
constexpr unsigned int mmDIG0_DIG_RANDOM_PATTERN_SEED__VI               = 0x4A05;
constexpr unsigned int mmDIG0_DIG_TEST_DEBUG_DATA__VI                   = 0x4A7B;
constexpr unsigned int mmDIG0_DIG_TEST_DEBUG_INDEX__VI                  = 0x4A7A;
constexpr unsigned int mmDIG0_DIG_TEST_PATTERN__VI                      = 0x4A04;
constexpr unsigned int mmDIG0_HDMI_ACR_32_0__VI                         = 0x4A2E;
constexpr unsigned int mmDIG0_HDMI_ACR_32_1__VI                         = 0x4A2F;
constexpr unsigned int mmDIG0_HDMI_ACR_44_0__VI                         = 0x4A30;
constexpr unsigned int mmDIG0_HDMI_ACR_44_1__VI                         = 0x4A31;
constexpr unsigned int mmDIG0_HDMI_ACR_48_0__VI                         = 0x4A32;
constexpr unsigned int mmDIG0_HDMI_ACR_48_1__VI                         = 0x4A33;
constexpr unsigned int mmDIG0_HDMI_ACR_PACKET_CONTROL__VI               = 0x4A0C;
constexpr unsigned int mmDIG0_HDMI_ACR_STATUS_0__VI                     = 0x4A34;
constexpr unsigned int mmDIG0_HDMI_ACR_STATUS_1__VI                     = 0x4A35;
constexpr unsigned int mmDIG0_HDMI_AUDIO_PACKET_CONTROL__VI             = 0x4A0B;
constexpr unsigned int mmDIG0_HDMI_CONTROL__VI                          = 0x4A09;
constexpr unsigned int mmDIG0_HDMI_GC__VI                               = 0x4A13;
constexpr unsigned int mmDIG0_HDMI_GENERIC_PACKET_CONTROL0__VI          = 0x4A10;
constexpr unsigned int mmDIG0_HDMI_GENERIC_PACKET_CONTROL1__VI          = 0x4A2D;
constexpr unsigned int mmDIG0_HDMI_INFOFRAME_CONTROL0__VI               = 0x4A0E;
constexpr unsigned int mmDIG0_HDMI_INFOFRAME_CONTROL1__VI               = 0x4A0F;
constexpr unsigned int mmDIG0_HDMI_STATUS__VI                           = 0x4A0A;
constexpr unsigned int mmDIG0_HDMI_VBI_PACKET_CONTROL__VI               = 0x4A0D;
constexpr unsigned int mmDIG0_LVDS_DATA_CNTL__VI                        = 0x4A78;
constexpr unsigned int mmDIG0_TMDS_CNTL__VI                             = 0x4A6B;
constexpr unsigned int mmDIG0_TMDS_CONTROL0_FEEDBACK__VI                = 0x4A6D;
constexpr unsigned int mmDIG0_TMDS_CONTROL_CHAR__VI                     = 0x4A6C;
constexpr unsigned int mmDIG0_TMDS_CTL0_1_GEN_CNTL__VI                  = 0x4A75;
constexpr unsigned int mmDIG0_TMDS_CTL2_3_GEN_CNTL__VI                  = 0x4A76;
constexpr unsigned int mmDIG0_TMDS_CTL_BITS__VI                         = 0x4A72;
constexpr unsigned int mmDIG0_TMDS_DCBALANCER_CONTROL__VI               = 0x4A73;
constexpr unsigned int mmDIG0_TMDS_DEBUG__VI                            = 0x4A71;
constexpr unsigned int mmDIG0_TMDS_STEREOSYNC_CTL_SEL__VI               = 0x4A6E;
constexpr unsigned int mmDIG0_TMDS_SYNC_CHAR_PATTERN_0_1__VI            = 0x4A6F;
constexpr unsigned int mmDIG0_TMDS_SYNC_CHAR_PATTERN_2_3__VI            = 0x4A70;
constexpr unsigned int mmDIG1_AFMT_60958_0__VI                          = 0x4B38;
constexpr unsigned int mmDIG1_AFMT_60958_1__VI                          = 0x4B39;
constexpr unsigned int mmDIG1_AFMT_60958_2__VI                          = 0x4B3F;
constexpr unsigned int mmDIG1_AFMT_AUDIO_CRC_CONTROL__VI                = 0x4B3A;
constexpr unsigned int mmDIG1_AFMT_AUDIO_CRC_RESULT__VI                 = 0x4B40;
constexpr unsigned int mmDIG1_AFMT_AUDIO_DBG_DTO_CNTL__VI               = 0x4B46;
constexpr unsigned int mmDIG1_AFMT_AUDIO_INFO0__VI                      = 0x4B36;
constexpr unsigned int mmDIG1_AFMT_AUDIO_INFO1__VI                      = 0x4B37;
constexpr unsigned int mmDIG1_AFMT_AUDIO_PACKET_CONTROL__VI             = 0x4B42;
constexpr unsigned int mmDIG1_AFMT_AUDIO_PACKET_CONTROL2__VI            = 0x4B14;
constexpr unsigned int mmDIG1_AFMT_AUDIO_SRC_CONTROL__VI                = 0x4B45;
constexpr unsigned int mmDIG1_AFMT_AVI_INFO0__VI                        = 0x4B1E;
constexpr unsigned int mmDIG1_AFMT_AVI_INFO1__VI                        = 0x4B1F;
constexpr unsigned int mmDIG1_AFMT_AVI_INFO2__VI                        = 0x4B20;
constexpr unsigned int mmDIG1_AFMT_AVI_INFO3__VI                        = 0x4B21;
constexpr unsigned int mmDIG1_AFMT_GENERIC_0__VI                        = 0x4B25;
constexpr unsigned int mmDIG1_AFMT_GENERIC_1__VI                        = 0x4B26;
constexpr unsigned int mmDIG1_AFMT_GENERIC_2__VI                        = 0x4B27;
constexpr unsigned int mmDIG1_AFMT_GENERIC_3__VI                        = 0x4B28;
constexpr unsigned int mmDIG1_AFMT_GENERIC_4__VI                        = 0x4B29;
constexpr unsigned int mmDIG1_AFMT_GENERIC_5__VI                        = 0x4B2A;
constexpr unsigned int mmDIG1_AFMT_GENERIC_6__VI                        = 0x4B2B;
constexpr unsigned int mmDIG1_AFMT_GENERIC_7__VI                        = 0x4B2C;
constexpr unsigned int mmDIG1_AFMT_GENERIC_HDR__VI                      = 0x4B24;
constexpr unsigned int mmDIG1_AFMT_INFOFRAME_CONTROL0__VI               = 0x4B44;
constexpr unsigned int mmDIG1_AFMT_ISRC1_0__VI                          = 0x4B15;
constexpr unsigned int mmDIG1_AFMT_ISRC1_1__VI                          = 0x4B16;
constexpr unsigned int mmDIG1_AFMT_ISRC1_2__VI                          = 0x4B17;
constexpr unsigned int mmDIG1_AFMT_ISRC1_3__VI                          = 0x4B18;
constexpr unsigned int mmDIG1_AFMT_ISRC1_4__VI                          = 0x4B19;
constexpr unsigned int mmDIG1_AFMT_ISRC2_0__VI                          = 0x4B1A;
constexpr unsigned int mmDIG1_AFMT_ISRC2_1__VI                          = 0x4B1B;
constexpr unsigned int mmDIG1_AFMT_ISRC2_2__VI                          = 0x4B1C;
constexpr unsigned int mmDIG1_AFMT_ISRC2_3__VI                          = 0x4B1D;
constexpr unsigned int mmDIG1_AFMT_MPEG_INFO0__VI                       = 0x4B22;
constexpr unsigned int mmDIG1_AFMT_MPEG_INFO1__VI                       = 0x4B23;
constexpr unsigned int mmDIG1_AFMT_RAMP_CONTROL0__VI                    = 0x4B3B;
constexpr unsigned int mmDIG1_AFMT_RAMP_CONTROL1__VI                    = 0x4B3C;
constexpr unsigned int mmDIG1_AFMT_RAMP_CONTROL2__VI                    = 0x4B3D;
constexpr unsigned int mmDIG1_AFMT_RAMP_CONTROL3__VI                    = 0x4B3E;
constexpr unsigned int mmDIG1_AFMT_STATUS__VI                           = 0x4B41;
constexpr unsigned int mmDIG1_AFMT_VBI_PACKET_CONTROL__VI               = 0x4B43;
constexpr unsigned int mmDIG1_DIG_BE_CNTL__VI                           = 0x4B47;
constexpr unsigned int mmDIG1_DIG_BE_EN_CNTL__VI                        = 0x4B48;
constexpr unsigned int mmDIG1_DIG_CLOCK_PATTERN__VI                     = 0x4B03;
constexpr unsigned int mmDIG1_DIG_DISPCLK_SWITCH_CNTL__VI               = 0x4B07;
constexpr unsigned int mmDIG1_DIG_DISPCLK_SWITCH_STATUS__VI             = 0x4B08;
constexpr unsigned int mmDIG1_DIG_FE_CNTL__VI                           = 0x4B00;
constexpr unsigned int mmDIG1_DIG_FE_TEST_DEBUG_DATA__VI                = 0x4B7D;
constexpr unsigned int mmDIG1_DIG_FE_TEST_DEBUG_INDEX__VI               = 0x4B7C;
constexpr unsigned int mmDIG1_DIG_FIFO_STATUS__VI                       = 0x4B06;
constexpr unsigned int mmDIG1_DIG_LANE_ENABLE__VI                       = 0x4B79;
constexpr unsigned int mmDIG1_DIG_OUTPUT_CRC_CNTL__VI                   = 0x4B01;
constexpr unsigned int mmDIG1_DIG_OUTPUT_CRC_RESULT__VI                 = 0x4B02;
constexpr unsigned int mmDIG1_DIG_RANDOM_PATTERN_SEED__VI               = 0x4B05;
constexpr unsigned int mmDIG1_DIG_TEST_DEBUG_DATA__VI                   = 0x4B7B;
constexpr unsigned int mmDIG1_DIG_TEST_DEBUG_INDEX__VI                  = 0x4B7A;
constexpr unsigned int mmDIG1_DIG_TEST_PATTERN__VI                      = 0x4B04;
constexpr unsigned int mmDIG1_HDMI_ACR_32_0__VI                         = 0x4B2E;
constexpr unsigned int mmDIG1_HDMI_ACR_32_1__VI                         = 0x4B2F;
constexpr unsigned int mmDIG1_HDMI_ACR_44_0__VI                         = 0x4B30;
constexpr unsigned int mmDIG1_HDMI_ACR_44_1__VI                         = 0x4B31;
constexpr unsigned int mmDIG1_HDMI_ACR_48_0__VI                         = 0x4B32;
constexpr unsigned int mmDIG1_HDMI_ACR_48_1__VI                         = 0x4B33;
constexpr unsigned int mmDIG1_HDMI_ACR_PACKET_CONTROL__VI               = 0x4B0C;
constexpr unsigned int mmDIG1_HDMI_ACR_STATUS_0__VI                     = 0x4B34;
constexpr unsigned int mmDIG1_HDMI_ACR_STATUS_1__VI                     = 0x4B35;
constexpr unsigned int mmDIG1_HDMI_AUDIO_PACKET_CONTROL__VI             = 0x4B0B;
constexpr unsigned int mmDIG1_HDMI_CONTROL__VI                          = 0x4B09;
constexpr unsigned int mmDIG1_HDMI_GC__VI                               = 0x4B13;
constexpr unsigned int mmDIG1_HDMI_GENERIC_PACKET_CONTROL0__VI          = 0x4B10;
constexpr unsigned int mmDIG1_HDMI_GENERIC_PACKET_CONTROL1__VI          = 0x4B2D;
constexpr unsigned int mmDIG1_HDMI_INFOFRAME_CONTROL0__VI               = 0x4B0E;
constexpr unsigned int mmDIG1_HDMI_INFOFRAME_CONTROL1__VI               = 0x4B0F;
constexpr unsigned int mmDIG1_HDMI_STATUS__VI                           = 0x4B0A;
constexpr unsigned int mmDIG1_HDMI_VBI_PACKET_CONTROL__VI               = 0x4B0D;
constexpr unsigned int mmDIG1_LVDS_DATA_CNTL__VI                        = 0x4B78;
constexpr unsigned int mmDIG1_TMDS_CNTL__VI                             = 0x4B6B;
constexpr unsigned int mmDIG1_TMDS_CONTROL0_FEEDBACK__VI                = 0x4B6D;
constexpr unsigned int mmDIG1_TMDS_CONTROL_CHAR__VI                     = 0x4B6C;
constexpr unsigned int mmDIG1_TMDS_CTL0_1_GEN_CNTL__VI                  = 0x4B75;
constexpr unsigned int mmDIG1_TMDS_CTL2_3_GEN_CNTL__VI                  = 0x4B76;
constexpr unsigned int mmDIG1_TMDS_CTL_BITS__VI                         = 0x4B72;
constexpr unsigned int mmDIG1_TMDS_DCBALANCER_CONTROL__VI               = 0x4B73;
constexpr unsigned int mmDIG1_TMDS_DEBUG__VI                            = 0x4B71;
constexpr unsigned int mmDIG1_TMDS_STEREOSYNC_CTL_SEL__VI               = 0x4B6E;
constexpr unsigned int mmDIG1_TMDS_SYNC_CHAR_PATTERN_0_1__VI            = 0x4B6F;
constexpr unsigned int mmDIG1_TMDS_SYNC_CHAR_PATTERN_2_3__VI            = 0x4B70;
constexpr unsigned int mmDIG2_AFMT_60958_0__VI                          = 0x4C38;
constexpr unsigned int mmDIG2_AFMT_60958_1__VI                          = 0x4C39;
constexpr unsigned int mmDIG2_AFMT_60958_2__VI                          = 0x4C3F;
constexpr unsigned int mmDIG2_AFMT_AUDIO_CRC_CONTROL__VI                = 0x4C3A;
constexpr unsigned int mmDIG2_AFMT_AUDIO_CRC_RESULT__VI                 = 0x4C40;
constexpr unsigned int mmDIG2_AFMT_AUDIO_DBG_DTO_CNTL__VI               = 0x4C46;
constexpr unsigned int mmDIG2_AFMT_AUDIO_INFO0__VI                      = 0x4C36;
constexpr unsigned int mmDIG2_AFMT_AUDIO_INFO1__VI                      = 0x4C37;
constexpr unsigned int mmDIG2_AFMT_AUDIO_PACKET_CONTROL__VI             = 0x4C42;
constexpr unsigned int mmDIG2_AFMT_AUDIO_PACKET_CONTROL2__VI            = 0x4C14;
constexpr unsigned int mmDIG2_AFMT_AUDIO_SRC_CONTROL__VI                = 0x4C45;
constexpr unsigned int mmDIG2_AFMT_AVI_INFO0__VI                        = 0x4C1E;
constexpr unsigned int mmDIG2_AFMT_AVI_INFO1__VI                        = 0x4C1F;
constexpr unsigned int mmDIG2_AFMT_AVI_INFO2__VI                        = 0x4C20;
constexpr unsigned int mmDIG2_AFMT_AVI_INFO3__VI                        = 0x4C21;
constexpr unsigned int mmDIG2_AFMT_GENERIC_0__VI                        = 0x4C25;
constexpr unsigned int mmDIG2_AFMT_GENERIC_1__VI                        = 0x4C26;
constexpr unsigned int mmDIG2_AFMT_GENERIC_2__VI                        = 0x4C27;
constexpr unsigned int mmDIG2_AFMT_GENERIC_3__VI                        = 0x4C28;
constexpr unsigned int mmDIG2_AFMT_GENERIC_4__VI                        = 0x4C29;
constexpr unsigned int mmDIG2_AFMT_GENERIC_5__VI                        = 0x4C2A;
constexpr unsigned int mmDIG2_AFMT_GENERIC_6__VI                        = 0x4C2B;
constexpr unsigned int mmDIG2_AFMT_GENERIC_7__VI                        = 0x4C2C;
constexpr unsigned int mmDIG2_AFMT_GENERIC_HDR__VI                      = 0x4C24;
constexpr unsigned int mmDIG2_AFMT_INFOFRAME_CONTROL0__VI               = 0x4C44;
constexpr unsigned int mmDIG2_AFMT_ISRC1_0__VI                          = 0x4C15;
constexpr unsigned int mmDIG2_AFMT_ISRC1_1__VI                          = 0x4C16;
constexpr unsigned int mmDIG2_AFMT_ISRC1_2__VI                          = 0x4C17;
constexpr unsigned int mmDIG2_AFMT_ISRC1_3__VI                          = 0x4C18;
constexpr unsigned int mmDIG2_AFMT_ISRC1_4__VI                          = 0x4C19;
constexpr unsigned int mmDIG2_AFMT_ISRC2_0__VI                          = 0x4C1A;
constexpr unsigned int mmDIG2_AFMT_ISRC2_1__VI                          = 0x4C1B;
constexpr unsigned int mmDIG2_AFMT_ISRC2_2__VI                          = 0x4C1C;
constexpr unsigned int mmDIG2_AFMT_ISRC2_3__VI                          = 0x4C1D;
constexpr unsigned int mmDIG2_AFMT_MPEG_INFO0__VI                       = 0x4C22;
constexpr unsigned int mmDIG2_AFMT_MPEG_INFO1__VI                       = 0x4C23;
constexpr unsigned int mmDIG2_AFMT_RAMP_CONTROL0__VI                    = 0x4C3B;
constexpr unsigned int mmDIG2_AFMT_RAMP_CONTROL1__VI                    = 0x4C3C;
constexpr unsigned int mmDIG2_AFMT_RAMP_CONTROL2__VI                    = 0x4C3D;
constexpr unsigned int mmDIG2_AFMT_RAMP_CONTROL3__VI                    = 0x4C3E;
constexpr unsigned int mmDIG2_AFMT_STATUS__VI                           = 0x4C41;
constexpr unsigned int mmDIG2_AFMT_VBI_PACKET_CONTROL__VI               = 0x4C43;
constexpr unsigned int mmDIG2_DIG_BE_CNTL__VI                           = 0x4C47;
constexpr unsigned int mmDIG2_DIG_BE_EN_CNTL__VI                        = 0x4C48;
constexpr unsigned int mmDIG2_DIG_CLOCK_PATTERN__VI                     = 0x4C03;
constexpr unsigned int mmDIG2_DIG_DISPCLK_SWITCH_CNTL__VI               = 0x4C07;
constexpr unsigned int mmDIG2_DIG_DISPCLK_SWITCH_STATUS__VI             = 0x4C08;
constexpr unsigned int mmDIG2_DIG_FE_CNTL__VI                           = 0x4C00;
constexpr unsigned int mmDIG2_DIG_FE_TEST_DEBUG_DATA__VI                = 0x4C7D;
constexpr unsigned int mmDIG2_DIG_FE_TEST_DEBUG_INDEX__VI               = 0x4C7C;
constexpr unsigned int mmDIG2_DIG_FIFO_STATUS__VI                       = 0x4C06;
constexpr unsigned int mmDIG2_DIG_LANE_ENABLE__VI                       = 0x4C79;
constexpr unsigned int mmDIG2_DIG_OUTPUT_CRC_CNTL__VI                   = 0x4C01;
constexpr unsigned int mmDIG2_DIG_OUTPUT_CRC_RESULT__VI                 = 0x4C02;
constexpr unsigned int mmDIG2_DIG_RANDOM_PATTERN_SEED__VI               = 0x4C05;
constexpr unsigned int mmDIG2_DIG_TEST_DEBUG_DATA__VI                   = 0x4C7B;
constexpr unsigned int mmDIG2_DIG_TEST_DEBUG_INDEX__VI                  = 0x4C7A;
constexpr unsigned int mmDIG2_DIG_TEST_PATTERN__VI                      = 0x4C04;
constexpr unsigned int mmDIG2_HDMI_ACR_32_0__VI                         = 0x4C2E;
constexpr unsigned int mmDIG2_HDMI_ACR_32_1__VI                         = 0x4C2F;
constexpr unsigned int mmDIG2_HDMI_ACR_44_0__VI                         = 0x4C30;
constexpr unsigned int mmDIG2_HDMI_ACR_44_1__VI                         = 0x4C31;
constexpr unsigned int mmDIG2_HDMI_ACR_48_0__VI                         = 0x4C32;
constexpr unsigned int mmDIG2_HDMI_ACR_48_1__VI                         = 0x4C33;
constexpr unsigned int mmDIG2_HDMI_ACR_PACKET_CONTROL__VI               = 0x4C0C;
constexpr unsigned int mmDIG2_HDMI_ACR_STATUS_0__VI                     = 0x4C34;
constexpr unsigned int mmDIG2_HDMI_ACR_STATUS_1__VI                     = 0x4C35;
constexpr unsigned int mmDIG2_HDMI_AUDIO_PACKET_CONTROL__VI             = 0x4C0B;
constexpr unsigned int mmDIG2_HDMI_CONTROL__VI                          = 0x4C09;
constexpr unsigned int mmDIG2_HDMI_GC__VI                               = 0x4C13;
constexpr unsigned int mmDIG2_HDMI_GENERIC_PACKET_CONTROL0__VI          = 0x4C10;
constexpr unsigned int mmDIG2_HDMI_GENERIC_PACKET_CONTROL1__VI          = 0x4C2D;
constexpr unsigned int mmDIG2_HDMI_INFOFRAME_CONTROL0__VI               = 0x4C0E;
constexpr unsigned int mmDIG2_HDMI_INFOFRAME_CONTROL1__VI               = 0x4C0F;
constexpr unsigned int mmDIG2_HDMI_STATUS__VI                           = 0x4C0A;
constexpr unsigned int mmDIG2_HDMI_VBI_PACKET_CONTROL__VI               = 0x4C0D;
constexpr unsigned int mmDIG2_LVDS_DATA_CNTL__VI                        = 0x4C78;
constexpr unsigned int mmDIG2_TMDS_CNTL__VI                             = 0x4C6B;
constexpr unsigned int mmDIG2_TMDS_CONTROL0_FEEDBACK__VI                = 0x4C6D;
constexpr unsigned int mmDIG2_TMDS_CONTROL_CHAR__VI                     = 0x4C6C;
constexpr unsigned int mmDIG2_TMDS_CTL0_1_GEN_CNTL__VI                  = 0x4C75;
constexpr unsigned int mmDIG2_TMDS_CTL2_3_GEN_CNTL__VI                  = 0x4C76;
constexpr unsigned int mmDIG2_TMDS_CTL_BITS__VI                         = 0x4C72;
constexpr unsigned int mmDIG2_TMDS_DCBALANCER_CONTROL__VI               = 0x4C73;
constexpr unsigned int mmDIG2_TMDS_DEBUG__VI                            = 0x4C71;
constexpr unsigned int mmDIG2_TMDS_STEREOSYNC_CTL_SEL__VI               = 0x4C6E;
constexpr unsigned int mmDIG2_TMDS_SYNC_CHAR_PATTERN_0_1__VI            = 0x4C6F;
constexpr unsigned int mmDIG2_TMDS_SYNC_CHAR_PATTERN_2_3__VI            = 0x4C70;
constexpr unsigned int mmDIG3_AFMT_60958_0__VI                          = 0x4D38;
constexpr unsigned int mmDIG3_AFMT_60958_1__VI                          = 0x4D39;
constexpr unsigned int mmDIG3_AFMT_60958_2__VI                          = 0x4D3F;
constexpr unsigned int mmDIG3_AFMT_AUDIO_CRC_CONTROL__VI                = 0x4D3A;
constexpr unsigned int mmDIG3_AFMT_AUDIO_CRC_RESULT__VI                 = 0x4D40;
constexpr unsigned int mmDIG3_AFMT_AUDIO_DBG_DTO_CNTL__VI               = 0x4D46;
constexpr unsigned int mmDIG3_AFMT_AUDIO_INFO0__VI                      = 0x4D36;
constexpr unsigned int mmDIG3_AFMT_AUDIO_INFO1__VI                      = 0x4D37;
constexpr unsigned int mmDIG3_AFMT_AUDIO_PACKET_CONTROL__VI             = 0x4D42;
constexpr unsigned int mmDIG3_AFMT_AUDIO_PACKET_CONTROL2__VI            = 0x4D14;
constexpr unsigned int mmDIG3_AFMT_AUDIO_SRC_CONTROL__VI                = 0x4D45;
constexpr unsigned int mmDIG3_AFMT_AVI_INFO0__VI                        = 0x4D1E;
constexpr unsigned int mmDIG3_AFMT_AVI_INFO1__VI                        = 0x4D1F;
constexpr unsigned int mmDIG3_AFMT_AVI_INFO2__VI                        = 0x4D20;
constexpr unsigned int mmDIG3_AFMT_AVI_INFO3__VI                        = 0x4D21;
constexpr unsigned int mmDIG3_AFMT_GENERIC_0__VI                        = 0x4D25;
constexpr unsigned int mmDIG3_AFMT_GENERIC_1__VI                        = 0x4D26;
constexpr unsigned int mmDIG3_AFMT_GENERIC_2__VI                        = 0x4D27;
constexpr unsigned int mmDIG3_AFMT_GENERIC_3__VI                        = 0x4D28;
constexpr unsigned int mmDIG3_AFMT_GENERIC_4__VI                        = 0x4D29;
constexpr unsigned int mmDIG3_AFMT_GENERIC_5__VI                        = 0x4D2A;
constexpr unsigned int mmDIG3_AFMT_GENERIC_6__VI                        = 0x4D2B;
constexpr unsigned int mmDIG3_AFMT_GENERIC_7__VI                        = 0x4D2C;
constexpr unsigned int mmDIG3_AFMT_GENERIC_HDR__VI                      = 0x4D24;
constexpr unsigned int mmDIG3_AFMT_INFOFRAME_CONTROL0__VI               = 0x4D44;
constexpr unsigned int mmDIG3_AFMT_ISRC1_0__VI                          = 0x4D15;
constexpr unsigned int mmDIG3_AFMT_ISRC1_1__VI                          = 0x4D16;
constexpr unsigned int mmDIG3_AFMT_ISRC1_2__VI                          = 0x4D17;
constexpr unsigned int mmDIG3_AFMT_ISRC1_3__VI                          = 0x4D18;
constexpr unsigned int mmDIG3_AFMT_ISRC1_4__VI                          = 0x4D19;
constexpr unsigned int mmDIG3_AFMT_ISRC2_0__VI                          = 0x4D1A;
constexpr unsigned int mmDIG3_AFMT_ISRC2_1__VI                          = 0x4D1B;
constexpr unsigned int mmDIG3_AFMT_ISRC2_2__VI                          = 0x4D1C;
constexpr unsigned int mmDIG3_AFMT_ISRC2_3__VI                          = 0x4D1D;
constexpr unsigned int mmDIG3_AFMT_MPEG_INFO0__VI                       = 0x4D22;
constexpr unsigned int mmDIG3_AFMT_MPEG_INFO1__VI                       = 0x4D23;
constexpr unsigned int mmDIG3_AFMT_RAMP_CONTROL0__VI                    = 0x4D3B;
constexpr unsigned int mmDIG3_AFMT_RAMP_CONTROL1__VI                    = 0x4D3C;
constexpr unsigned int mmDIG3_AFMT_RAMP_CONTROL2__VI                    = 0x4D3D;
constexpr unsigned int mmDIG3_AFMT_RAMP_CONTROL3__VI                    = 0x4D3E;
constexpr unsigned int mmDIG3_AFMT_STATUS__VI                           = 0x4D41;
constexpr unsigned int mmDIG3_AFMT_VBI_PACKET_CONTROL__VI               = 0x4D43;
constexpr unsigned int mmDIG3_DIG_BE_CNTL__VI                           = 0x4D47;
constexpr unsigned int mmDIG3_DIG_BE_EN_CNTL__VI                        = 0x4D48;
constexpr unsigned int mmDIG3_DIG_CLOCK_PATTERN__VI                     = 0x4D03;
constexpr unsigned int mmDIG3_DIG_DISPCLK_SWITCH_CNTL__VI               = 0x4D07;
constexpr unsigned int mmDIG3_DIG_DISPCLK_SWITCH_STATUS__VI             = 0x4D08;
constexpr unsigned int mmDIG3_DIG_FE_CNTL__VI                           = 0x4D00;
constexpr unsigned int mmDIG3_DIG_FE_TEST_DEBUG_DATA__VI                = 0x4D7D;
constexpr unsigned int mmDIG3_DIG_FE_TEST_DEBUG_INDEX__VI               = 0x4D7C;
constexpr unsigned int mmDIG3_DIG_FIFO_STATUS__VI                       = 0x4D06;
constexpr unsigned int mmDIG3_DIG_LANE_ENABLE__VI                       = 0x4D79;
constexpr unsigned int mmDIG3_DIG_OUTPUT_CRC_CNTL__VI                   = 0x4D01;
constexpr unsigned int mmDIG3_DIG_OUTPUT_CRC_RESULT__VI                 = 0x4D02;
constexpr unsigned int mmDIG3_DIG_RANDOM_PATTERN_SEED__VI               = 0x4D05;
constexpr unsigned int mmDIG3_DIG_TEST_DEBUG_DATA__VI                   = 0x4D7B;
constexpr unsigned int mmDIG3_DIG_TEST_DEBUG_INDEX__VI                  = 0x4D7A;
constexpr unsigned int mmDIG3_DIG_TEST_PATTERN__VI                      = 0x4D04;
constexpr unsigned int mmDIG3_HDMI_ACR_32_0__VI                         = 0x4D2E;
constexpr unsigned int mmDIG3_HDMI_ACR_32_1__VI                         = 0x4D2F;
constexpr unsigned int mmDIG3_HDMI_ACR_44_0__VI                         = 0x4D30;
constexpr unsigned int mmDIG3_HDMI_ACR_44_1__VI                         = 0x4D31;
constexpr unsigned int mmDIG3_HDMI_ACR_48_0__VI                         = 0x4D32;
constexpr unsigned int mmDIG3_HDMI_ACR_48_1__VI                         = 0x4D33;
constexpr unsigned int mmDIG3_HDMI_ACR_PACKET_CONTROL__VI               = 0x4D0C;
constexpr unsigned int mmDIG3_HDMI_ACR_STATUS_0__VI                     = 0x4D34;
constexpr unsigned int mmDIG3_HDMI_ACR_STATUS_1__VI                     = 0x4D35;
constexpr unsigned int mmDIG3_HDMI_AUDIO_PACKET_CONTROL__VI             = 0x4D0B;
constexpr unsigned int mmDIG3_HDMI_CONTROL__VI                          = 0x4D09;
constexpr unsigned int mmDIG3_HDMI_GC__VI                               = 0x4D13;
constexpr unsigned int mmDIG3_HDMI_GENERIC_PACKET_CONTROL0__VI          = 0x4D10;
constexpr unsigned int mmDIG3_HDMI_GENERIC_PACKET_CONTROL1__VI          = 0x4D2D;
constexpr unsigned int mmDIG3_HDMI_INFOFRAME_CONTROL0__VI               = 0x4D0E;
constexpr unsigned int mmDIG3_HDMI_INFOFRAME_CONTROL1__VI               = 0x4D0F;
constexpr unsigned int mmDIG3_HDMI_STATUS__VI                           = 0x4D0A;
constexpr unsigned int mmDIG3_HDMI_VBI_PACKET_CONTROL__VI               = 0x4D0D;
constexpr unsigned int mmDIG3_LVDS_DATA_CNTL__VI                        = 0x4D78;
constexpr unsigned int mmDIG3_TMDS_CNTL__VI                             = 0x4D6B;
constexpr unsigned int mmDIG3_TMDS_CONTROL0_FEEDBACK__VI                = 0x4D6D;
constexpr unsigned int mmDIG3_TMDS_CONTROL_CHAR__VI                     = 0x4D6C;
constexpr unsigned int mmDIG3_TMDS_CTL0_1_GEN_CNTL__VI                  = 0x4D75;
constexpr unsigned int mmDIG3_TMDS_CTL2_3_GEN_CNTL__VI                  = 0x4D76;
constexpr unsigned int mmDIG3_TMDS_CTL_BITS__VI                         = 0x4D72;
constexpr unsigned int mmDIG3_TMDS_DCBALANCER_CONTROL__VI               = 0x4D73;
constexpr unsigned int mmDIG3_TMDS_DEBUG__VI                            = 0x4D71;
constexpr unsigned int mmDIG3_TMDS_STEREOSYNC_CTL_SEL__VI               = 0x4D6E;
constexpr unsigned int mmDIG3_TMDS_SYNC_CHAR_PATTERN_0_1__VI            = 0x4D6F;
constexpr unsigned int mmDIG3_TMDS_SYNC_CHAR_PATTERN_2_3__VI            = 0x4D70;
constexpr unsigned int mmDIG4_AFMT_60958_0__VI                          = 0x4E38;
constexpr unsigned int mmDIG4_AFMT_60958_1__VI                          = 0x4E39;
constexpr unsigned int mmDIG4_AFMT_60958_2__VI                          = 0x4E3F;
constexpr unsigned int mmDIG4_AFMT_AUDIO_CRC_CONTROL__VI                = 0x4E3A;
constexpr unsigned int mmDIG4_AFMT_AUDIO_CRC_RESULT__VI                 = 0x4E40;
constexpr unsigned int mmDIG4_AFMT_AUDIO_DBG_DTO_CNTL__VI               = 0x4E46;
constexpr unsigned int mmDIG4_AFMT_AUDIO_INFO0__VI                      = 0x4E36;
constexpr unsigned int mmDIG4_AFMT_AUDIO_INFO1__VI                      = 0x4E37;
constexpr unsigned int mmDIG4_AFMT_AUDIO_PACKET_CONTROL__VI             = 0x4E42;
constexpr unsigned int mmDIG4_AFMT_AUDIO_PACKET_CONTROL2__VI            = 0x4E14;
constexpr unsigned int mmDIG4_AFMT_AUDIO_SRC_CONTROL__VI                = 0x4E45;
constexpr unsigned int mmDIG4_AFMT_AVI_INFO0__VI                        = 0x4E1E;
constexpr unsigned int mmDIG4_AFMT_AVI_INFO1__VI                        = 0x4E1F;
constexpr unsigned int mmDIG4_AFMT_AVI_INFO2__VI                        = 0x4E20;
constexpr unsigned int mmDIG4_AFMT_AVI_INFO3__VI                        = 0x4E21;
constexpr unsigned int mmDIG4_AFMT_GENERIC_0__VI                        = 0x4E25;
constexpr unsigned int mmDIG4_AFMT_GENERIC_1__VI                        = 0x4E26;
constexpr unsigned int mmDIG4_AFMT_GENERIC_2__VI                        = 0x4E27;
constexpr unsigned int mmDIG4_AFMT_GENERIC_3__VI                        = 0x4E28;
constexpr unsigned int mmDIG4_AFMT_GENERIC_4__VI                        = 0x4E29;
constexpr unsigned int mmDIG4_AFMT_GENERIC_5__VI                        = 0x4E2A;
constexpr unsigned int mmDIG4_AFMT_GENERIC_6__VI                        = 0x4E2B;
constexpr unsigned int mmDIG4_AFMT_GENERIC_7__VI                        = 0x4E2C;
constexpr unsigned int mmDIG4_AFMT_GENERIC_HDR__VI                      = 0x4E24;
constexpr unsigned int mmDIG4_AFMT_INFOFRAME_CONTROL0__VI               = 0x4E44;
constexpr unsigned int mmDIG4_AFMT_ISRC1_0__VI                          = 0x4E15;
constexpr unsigned int mmDIG4_AFMT_ISRC1_1__VI                          = 0x4E16;
constexpr unsigned int mmDIG4_AFMT_ISRC1_2__VI                          = 0x4E17;
constexpr unsigned int mmDIG4_AFMT_ISRC1_3__VI                          = 0x4E18;
constexpr unsigned int mmDIG4_AFMT_ISRC1_4__VI                          = 0x4E19;
constexpr unsigned int mmDIG4_AFMT_ISRC2_0__VI                          = 0x4E1A;
constexpr unsigned int mmDIG4_AFMT_ISRC2_1__VI                          = 0x4E1B;
constexpr unsigned int mmDIG4_AFMT_ISRC2_2__VI                          = 0x4E1C;
constexpr unsigned int mmDIG4_AFMT_ISRC2_3__VI                          = 0x4E1D;
constexpr unsigned int mmDIG4_AFMT_MPEG_INFO0__VI                       = 0x4E22;
constexpr unsigned int mmDIG4_AFMT_MPEG_INFO1__VI                       = 0x4E23;
constexpr unsigned int mmDIG4_AFMT_RAMP_CONTROL0__VI                    = 0x4E3B;
constexpr unsigned int mmDIG4_AFMT_RAMP_CONTROL1__VI                    = 0x4E3C;
constexpr unsigned int mmDIG4_AFMT_RAMP_CONTROL2__VI                    = 0x4E3D;
constexpr unsigned int mmDIG4_AFMT_RAMP_CONTROL3__VI                    = 0x4E3E;
constexpr unsigned int mmDIG4_AFMT_STATUS__VI                           = 0x4E41;
constexpr unsigned int mmDIG4_AFMT_VBI_PACKET_CONTROL__VI               = 0x4E43;
constexpr unsigned int mmDIG4_DIG_BE_CNTL__VI                           = 0x4E47;
constexpr unsigned int mmDIG4_DIG_BE_EN_CNTL__VI                        = 0x4E48;
constexpr unsigned int mmDIG4_DIG_CLOCK_PATTERN__VI                     = 0x4E03;
constexpr unsigned int mmDIG4_DIG_DISPCLK_SWITCH_CNTL__VI               = 0x4E07;
constexpr unsigned int mmDIG4_DIG_DISPCLK_SWITCH_STATUS__VI             = 0x4E08;
constexpr unsigned int mmDIG4_DIG_FE_CNTL__VI                           = 0x4E00;
constexpr unsigned int mmDIG4_DIG_FE_TEST_DEBUG_DATA__VI                = 0x4E7D;
constexpr unsigned int mmDIG4_DIG_FE_TEST_DEBUG_INDEX__VI               = 0x4E7C;
constexpr unsigned int mmDIG4_DIG_FIFO_STATUS__VI                       = 0x4E06;
constexpr unsigned int mmDIG4_DIG_LANE_ENABLE__VI                       = 0x4E79;
constexpr unsigned int mmDIG4_DIG_OUTPUT_CRC_CNTL__VI                   = 0x4E01;
constexpr unsigned int mmDIG4_DIG_OUTPUT_CRC_RESULT__VI                 = 0x4E02;
constexpr unsigned int mmDIG4_DIG_RANDOM_PATTERN_SEED__VI               = 0x4E05;
constexpr unsigned int mmDIG4_DIG_TEST_DEBUG_DATA__VI                   = 0x4E7B;
constexpr unsigned int mmDIG4_DIG_TEST_DEBUG_INDEX__VI                  = 0x4E7A;
constexpr unsigned int mmDIG4_DIG_TEST_PATTERN__VI                      = 0x4E04;
constexpr unsigned int mmDIG4_HDMI_ACR_32_0__VI                         = 0x4E2E;
constexpr unsigned int mmDIG4_HDMI_ACR_32_1__VI                         = 0x4E2F;
constexpr unsigned int mmDIG4_HDMI_ACR_44_0__VI                         = 0x4E30;
constexpr unsigned int mmDIG4_HDMI_ACR_44_1__VI                         = 0x4E31;
constexpr unsigned int mmDIG4_HDMI_ACR_48_0__VI                         = 0x4E32;
constexpr unsigned int mmDIG4_HDMI_ACR_48_1__VI                         = 0x4E33;
constexpr unsigned int mmDIG4_HDMI_ACR_PACKET_CONTROL__VI               = 0x4E0C;
constexpr unsigned int mmDIG4_HDMI_ACR_STATUS_0__VI                     = 0x4E34;
constexpr unsigned int mmDIG4_HDMI_ACR_STATUS_1__VI                     = 0x4E35;
constexpr unsigned int mmDIG4_HDMI_AUDIO_PACKET_CONTROL__VI             = 0x4E0B;
constexpr unsigned int mmDIG4_HDMI_CONTROL__VI                          = 0x4E09;
constexpr unsigned int mmDIG4_HDMI_GC__VI                               = 0x4E13;
constexpr unsigned int mmDIG4_HDMI_GENERIC_PACKET_CONTROL0__VI          = 0x4E10;
constexpr unsigned int mmDIG4_HDMI_GENERIC_PACKET_CONTROL1__VI          = 0x4E2D;
constexpr unsigned int mmDIG4_HDMI_INFOFRAME_CONTROL0__VI               = 0x4E0E;
constexpr unsigned int mmDIG4_HDMI_INFOFRAME_CONTROL1__VI               = 0x4E0F;
constexpr unsigned int mmDIG4_HDMI_STATUS__VI                           = 0x4E0A;
constexpr unsigned int mmDIG4_HDMI_VBI_PACKET_CONTROL__VI               = 0x4E0D;
constexpr unsigned int mmDIG4_LVDS_DATA_CNTL__VI                        = 0x4E78;
constexpr unsigned int mmDIG4_TMDS_CNTL__VI                             = 0x4E6B;
constexpr unsigned int mmDIG4_TMDS_CONTROL0_FEEDBACK__VI                = 0x4E6D;
constexpr unsigned int mmDIG4_TMDS_CONTROL_CHAR__VI                     = 0x4E6C;
constexpr unsigned int mmDIG4_TMDS_CTL0_1_GEN_CNTL__VI                  = 0x4E75;
constexpr unsigned int mmDIG4_TMDS_CTL2_3_GEN_CNTL__VI                  = 0x4E76;
constexpr unsigned int mmDIG4_TMDS_CTL_BITS__VI                         = 0x4E72;
constexpr unsigned int mmDIG4_TMDS_DCBALANCER_CONTROL__VI               = 0x4E73;
constexpr unsigned int mmDIG4_TMDS_DEBUG__VI                            = 0x4E71;
constexpr unsigned int mmDIG4_TMDS_STEREOSYNC_CTL_SEL__VI               = 0x4E6E;
constexpr unsigned int mmDIG4_TMDS_SYNC_CHAR_PATTERN_0_1__VI            = 0x4E6F;
constexpr unsigned int mmDIG4_TMDS_SYNC_CHAR_PATTERN_2_3__VI            = 0x4E70;
constexpr unsigned int mmDIG5_AFMT_60958_0__VI                          = 0x4F38;
constexpr unsigned int mmDIG5_AFMT_60958_1__VI                          = 0x4F39;
constexpr unsigned int mmDIG5_AFMT_60958_2__VI                          = 0x4F3F;
constexpr unsigned int mmDIG5_AFMT_AUDIO_CRC_CONTROL__VI                = 0x4F3A;
constexpr unsigned int mmDIG5_AFMT_AUDIO_CRC_RESULT__VI                 = 0x4F40;
constexpr unsigned int mmDIG5_AFMT_AUDIO_DBG_DTO_CNTL__VI               = 0x4F46;
constexpr unsigned int mmDIG5_AFMT_AUDIO_INFO0__VI                      = 0x4F36;
constexpr unsigned int mmDIG5_AFMT_AUDIO_INFO1__VI                      = 0x4F37;
constexpr unsigned int mmDIG5_AFMT_AUDIO_PACKET_CONTROL__VI             = 0x4F42;
constexpr unsigned int mmDIG5_AFMT_AUDIO_PACKET_CONTROL2__VI            = 0x4F14;
constexpr unsigned int mmDIG5_AFMT_AUDIO_SRC_CONTROL__VI                = 0x4F45;
constexpr unsigned int mmDIG5_AFMT_AVI_INFO0__VI                        = 0x4F1E;
constexpr unsigned int mmDIG5_AFMT_AVI_INFO1__VI                        = 0x4F1F;
constexpr unsigned int mmDIG5_AFMT_AVI_INFO2__VI                        = 0x4F20;
constexpr unsigned int mmDIG5_AFMT_AVI_INFO3__VI                        = 0x4F21;
constexpr unsigned int mmDIG5_AFMT_GENERIC_0__VI                        = 0x4F25;
constexpr unsigned int mmDIG5_AFMT_GENERIC_1__VI                        = 0x4F26;
constexpr unsigned int mmDIG5_AFMT_GENERIC_2__VI                        = 0x4F27;
constexpr unsigned int mmDIG5_AFMT_GENERIC_3__VI                        = 0x4F28;
constexpr unsigned int mmDIG5_AFMT_GENERIC_4__VI                        = 0x4F29;
constexpr unsigned int mmDIG5_AFMT_GENERIC_5__VI                        = 0x4F2A;
constexpr unsigned int mmDIG5_AFMT_GENERIC_6__VI                        = 0x4F2B;
constexpr unsigned int mmDIG5_AFMT_GENERIC_7__VI                        = 0x4F2C;
constexpr unsigned int mmDIG5_AFMT_GENERIC_HDR__VI                      = 0x4F24;
constexpr unsigned int mmDIG5_AFMT_INFOFRAME_CONTROL0__VI               = 0x4F44;
constexpr unsigned int mmDIG5_AFMT_ISRC1_0__VI                          = 0x4F15;
constexpr unsigned int mmDIG5_AFMT_ISRC1_1__VI                          = 0x4F16;
constexpr unsigned int mmDIG5_AFMT_ISRC1_2__VI                          = 0x4F17;
constexpr unsigned int mmDIG5_AFMT_ISRC1_3__VI                          = 0x4F18;
constexpr unsigned int mmDIG5_AFMT_ISRC1_4__VI                          = 0x4F19;
constexpr unsigned int mmDIG5_AFMT_ISRC2_0__VI                          = 0x4F1A;
constexpr unsigned int mmDIG5_AFMT_ISRC2_1__VI                          = 0x4F1B;
constexpr unsigned int mmDIG5_AFMT_ISRC2_2__VI                          = 0x4F1C;
constexpr unsigned int mmDIG5_AFMT_ISRC2_3__VI                          = 0x4F1D;
constexpr unsigned int mmDIG5_AFMT_MPEG_INFO0__VI                       = 0x4F22;
constexpr unsigned int mmDIG5_AFMT_MPEG_INFO1__VI                       = 0x4F23;
constexpr unsigned int mmDIG5_AFMT_RAMP_CONTROL0__VI                    = 0x4F3B;
constexpr unsigned int mmDIG5_AFMT_RAMP_CONTROL1__VI                    = 0x4F3C;
constexpr unsigned int mmDIG5_AFMT_RAMP_CONTROL2__VI                    = 0x4F3D;
constexpr unsigned int mmDIG5_AFMT_RAMP_CONTROL3__VI                    = 0x4F3E;
constexpr unsigned int mmDIG5_AFMT_STATUS__VI                           = 0x4F41;
constexpr unsigned int mmDIG5_AFMT_VBI_PACKET_CONTROL__VI               = 0x4F43;
constexpr unsigned int mmDIG5_DIG_BE_CNTL__VI                           = 0x4F47;
constexpr unsigned int mmDIG5_DIG_BE_EN_CNTL__VI                        = 0x4F48;
constexpr unsigned int mmDIG5_DIG_CLOCK_PATTERN__VI                     = 0x4F03;
constexpr unsigned int mmDIG5_DIG_DISPCLK_SWITCH_CNTL__VI               = 0x4F07;
constexpr unsigned int mmDIG5_DIG_DISPCLK_SWITCH_STATUS__VI             = 0x4F08;
constexpr unsigned int mmDIG5_DIG_FE_CNTL__VI                           = 0x4F00;
constexpr unsigned int mmDIG5_DIG_FE_TEST_DEBUG_DATA__VI                = 0x4F7D;
constexpr unsigned int mmDIG5_DIG_FE_TEST_DEBUG_INDEX__VI               = 0x4F7C;
constexpr unsigned int mmDIG5_DIG_FIFO_STATUS__VI                       = 0x4F06;
constexpr unsigned int mmDIG5_DIG_LANE_ENABLE__VI                       = 0x4F79;
constexpr unsigned int mmDIG5_DIG_OUTPUT_CRC_CNTL__VI                   = 0x4F01;
constexpr unsigned int mmDIG5_DIG_OUTPUT_CRC_RESULT__VI                 = 0x4F02;
constexpr unsigned int mmDIG5_DIG_RANDOM_PATTERN_SEED__VI               = 0x4F05;
constexpr unsigned int mmDIG5_DIG_TEST_DEBUG_DATA__VI                   = 0x4F7B;
constexpr unsigned int mmDIG5_DIG_TEST_DEBUG_INDEX__VI                  = 0x4F7A;
constexpr unsigned int mmDIG5_DIG_TEST_PATTERN__VI                      = 0x4F04;
constexpr unsigned int mmDIG5_HDMI_ACR_32_0__VI                         = 0x4F2E;
constexpr unsigned int mmDIG5_HDMI_ACR_32_1__VI                         = 0x4F2F;
constexpr unsigned int mmDIG5_HDMI_ACR_44_0__VI                         = 0x4F30;
constexpr unsigned int mmDIG5_HDMI_ACR_44_1__VI                         = 0x4F31;
constexpr unsigned int mmDIG5_HDMI_ACR_48_0__VI                         = 0x4F32;
constexpr unsigned int mmDIG5_HDMI_ACR_48_1__VI                         = 0x4F33;
constexpr unsigned int mmDIG5_HDMI_ACR_PACKET_CONTROL__VI               = 0x4F0C;
constexpr unsigned int mmDIG5_HDMI_ACR_STATUS_0__VI                     = 0x4F34;
constexpr unsigned int mmDIG5_HDMI_ACR_STATUS_1__VI                     = 0x4F35;
constexpr unsigned int mmDIG5_HDMI_AUDIO_PACKET_CONTROL__VI             = 0x4F0B;
constexpr unsigned int mmDIG5_HDMI_CONTROL__VI                          = 0x4F09;
constexpr unsigned int mmDIG5_HDMI_GC__VI                               = 0x4F13;
constexpr unsigned int mmDIG5_HDMI_GENERIC_PACKET_CONTROL0__VI          = 0x4F10;
constexpr unsigned int mmDIG5_HDMI_GENERIC_PACKET_CONTROL1__VI          = 0x4F2D;
constexpr unsigned int mmDIG5_HDMI_INFOFRAME_CONTROL0__VI               = 0x4F0E;
constexpr unsigned int mmDIG5_HDMI_INFOFRAME_CONTROL1__VI               = 0x4F0F;
constexpr unsigned int mmDIG5_HDMI_STATUS__VI                           = 0x4F0A;
constexpr unsigned int mmDIG5_HDMI_VBI_PACKET_CONTROL__VI               = 0x4F0D;
constexpr unsigned int mmDIG5_LVDS_DATA_CNTL__VI                        = 0x4F78;
constexpr unsigned int mmDIG5_TMDS_CNTL__VI                             = 0x4F6B;
constexpr unsigned int mmDIG5_TMDS_CONTROL0_FEEDBACK__VI                = 0x4F6D;
constexpr unsigned int mmDIG5_TMDS_CONTROL_CHAR__VI                     = 0x4F6C;
constexpr unsigned int mmDIG5_TMDS_CTL0_1_GEN_CNTL__VI                  = 0x4F75;
constexpr unsigned int mmDIG5_TMDS_CTL2_3_GEN_CNTL__VI                  = 0x4F76;
constexpr unsigned int mmDIG5_TMDS_CTL_BITS__VI                         = 0x4F72;
constexpr unsigned int mmDIG5_TMDS_DCBALANCER_CONTROL__VI               = 0x4F73;
constexpr unsigned int mmDIG5_TMDS_DEBUG__VI                            = 0x4F71;
constexpr unsigned int mmDIG5_TMDS_STEREOSYNC_CTL_SEL__VI               = 0x4F6E;
constexpr unsigned int mmDIG5_TMDS_SYNC_CHAR_PATTERN_0_1__VI            = 0x4F6F;
constexpr unsigned int mmDIG5_TMDS_SYNC_CHAR_PATTERN_2_3__VI            = 0x4F70;
constexpr unsigned int mmDIG6_AFMT_60958_0__VI                          = 0x5438;
constexpr unsigned int mmDIG6_AFMT_60958_1__VI                          = 0x5439;
constexpr unsigned int mmDIG6_AFMT_60958_2__VI                          = 0x543F;
constexpr unsigned int mmDIG6_AFMT_AUDIO_CRC_CONTROL__VI                = 0x543A;
constexpr unsigned int mmDIG6_AFMT_AUDIO_CRC_RESULT__VI                 = 0x5440;
constexpr unsigned int mmDIG6_AFMT_AUDIO_DBG_DTO_CNTL__VI               = 0x5446;
constexpr unsigned int mmDIG6_AFMT_AUDIO_INFO0__VI                      = 0x5436;
constexpr unsigned int mmDIG6_AFMT_AUDIO_INFO1__VI                      = 0x5437;
constexpr unsigned int mmDIG6_AFMT_AUDIO_PACKET_CONTROL__VI             = 0x5442;
constexpr unsigned int mmDIG6_AFMT_AUDIO_PACKET_CONTROL2__VI            = 0x5414;
constexpr unsigned int mmDIG6_AFMT_AUDIO_SRC_CONTROL__VI                = 0x5445;
constexpr unsigned int mmDIG6_AFMT_AVI_INFO0__VI                        = 0x541E;
constexpr unsigned int mmDIG6_AFMT_AVI_INFO1__VI                        = 0x541F;
constexpr unsigned int mmDIG6_AFMT_AVI_INFO2__VI                        = 0x5420;
constexpr unsigned int mmDIG6_AFMT_AVI_INFO3__VI                        = 0x5421;
constexpr unsigned int mmDIG6_AFMT_GENERIC_0__VI                        = 0x5425;
constexpr unsigned int mmDIG6_AFMT_GENERIC_1__VI                        = 0x5426;
constexpr unsigned int mmDIG6_AFMT_GENERIC_2__VI                        = 0x5427;
constexpr unsigned int mmDIG6_AFMT_GENERIC_3__VI                        = 0x5428;
constexpr unsigned int mmDIG6_AFMT_GENERIC_4__VI                        = 0x5429;
constexpr unsigned int mmDIG6_AFMT_GENERIC_5__VI                        = 0x542A;
constexpr unsigned int mmDIG6_AFMT_GENERIC_6__VI                        = 0x542B;
constexpr unsigned int mmDIG6_AFMT_GENERIC_7__VI                        = 0x542C;
constexpr unsigned int mmDIG6_AFMT_GENERIC_HDR__VI                      = 0x5424;
constexpr unsigned int mmDIG6_AFMT_INFOFRAME_CONTROL0__VI               = 0x5444;
constexpr unsigned int mmDIG6_AFMT_ISRC1_0__VI                          = 0x5415;
constexpr unsigned int mmDIG6_AFMT_ISRC1_1__VI                          = 0x5416;
constexpr unsigned int mmDIG6_AFMT_ISRC1_2__VI                          = 0x5417;
constexpr unsigned int mmDIG6_AFMT_ISRC1_3__VI                          = 0x5418;
constexpr unsigned int mmDIG6_AFMT_ISRC1_4__VI                          = 0x5419;
constexpr unsigned int mmDIG6_AFMT_ISRC2_0__VI                          = 0x541A;
constexpr unsigned int mmDIG6_AFMT_ISRC2_1__VI                          = 0x541B;
constexpr unsigned int mmDIG6_AFMT_ISRC2_2__VI                          = 0x541C;
constexpr unsigned int mmDIG6_AFMT_ISRC2_3__VI                          = 0x541D;
constexpr unsigned int mmDIG6_AFMT_MPEG_INFO0__VI                       = 0x5422;
constexpr unsigned int mmDIG6_AFMT_MPEG_INFO1__VI                       = 0x5423;
constexpr unsigned int mmDIG6_AFMT_RAMP_CONTROL0__VI                    = 0x543B;
constexpr unsigned int mmDIG6_AFMT_RAMP_CONTROL1__VI                    = 0x543C;
constexpr unsigned int mmDIG6_AFMT_RAMP_CONTROL2__VI                    = 0x543D;
constexpr unsigned int mmDIG6_AFMT_RAMP_CONTROL3__VI                    = 0x543E;
constexpr unsigned int mmDIG6_AFMT_STATUS__VI                           = 0x5441;
constexpr unsigned int mmDIG6_AFMT_VBI_PACKET_CONTROL__VI               = 0x5443;
constexpr unsigned int mmDIG6_DIG_BE_CNTL__VI                           = 0x5447;
constexpr unsigned int mmDIG6_DIG_BE_EN_CNTL__VI                        = 0x5448;
constexpr unsigned int mmDIG6_DIG_CLOCK_PATTERN__VI                     = 0x5403;
constexpr unsigned int mmDIG6_DIG_DISPCLK_SWITCH_CNTL__VI               = 0x5407;
constexpr unsigned int mmDIG6_DIG_DISPCLK_SWITCH_STATUS__VI             = 0x5408;
constexpr unsigned int mmDIG6_DIG_FE_CNTL__VI                           = 0x5400;
constexpr unsigned int mmDIG6_DIG_FE_TEST_DEBUG_DATA__VI                = 0x547D;
constexpr unsigned int mmDIG6_DIG_FE_TEST_DEBUG_INDEX__VI               = 0x547C;
constexpr unsigned int mmDIG6_DIG_FIFO_STATUS__VI                       = 0x5406;
constexpr unsigned int mmDIG6_DIG_LANE_ENABLE__VI                       = 0x5479;
constexpr unsigned int mmDIG6_DIG_OUTPUT_CRC_CNTL__VI                   = 0x5401;
constexpr unsigned int mmDIG6_DIG_OUTPUT_CRC_RESULT__VI                 = 0x5402;
constexpr unsigned int mmDIG6_DIG_RANDOM_PATTERN_SEED__VI               = 0x5405;
constexpr unsigned int mmDIG6_DIG_TEST_DEBUG_DATA__VI                   = 0x547B;
constexpr unsigned int mmDIG6_DIG_TEST_DEBUG_INDEX__VI                  = 0x547A;
constexpr unsigned int mmDIG6_DIG_TEST_PATTERN__VI                      = 0x5404;
constexpr unsigned int mmDIG6_HDMI_ACR_32_0__VI                         = 0x542E;
constexpr unsigned int mmDIG6_HDMI_ACR_32_1__VI                         = 0x542F;
constexpr unsigned int mmDIG6_HDMI_ACR_44_0__VI                         = 0x5430;
constexpr unsigned int mmDIG6_HDMI_ACR_44_1__VI                         = 0x5431;
constexpr unsigned int mmDIG6_HDMI_ACR_48_0__VI                         = 0x5432;
constexpr unsigned int mmDIG6_HDMI_ACR_48_1__VI                         = 0x5433;
constexpr unsigned int mmDIG6_HDMI_ACR_PACKET_CONTROL__VI               = 0x540C;
constexpr unsigned int mmDIG6_HDMI_ACR_STATUS_0__VI                     = 0x5434;
constexpr unsigned int mmDIG6_HDMI_ACR_STATUS_1__VI                     = 0x5435;
constexpr unsigned int mmDIG6_HDMI_AUDIO_PACKET_CONTROL__VI             = 0x540B;
constexpr unsigned int mmDIG6_HDMI_CONTROL__VI                          = 0x5409;
constexpr unsigned int mmDIG6_HDMI_GC__VI                               = 0x5413;
constexpr unsigned int mmDIG6_HDMI_GENERIC_PACKET_CONTROL0__VI          = 0x5410;
constexpr unsigned int mmDIG6_HDMI_GENERIC_PACKET_CONTROL1__VI          = 0x542D;
constexpr unsigned int mmDIG6_HDMI_INFOFRAME_CONTROL0__VI               = 0x540E;
constexpr unsigned int mmDIG6_HDMI_INFOFRAME_CONTROL1__VI               = 0x540F;
constexpr unsigned int mmDIG6_HDMI_STATUS__VI                           = 0x540A;
constexpr unsigned int mmDIG6_HDMI_VBI_PACKET_CONTROL__VI               = 0x540D;
constexpr unsigned int mmDIG6_LVDS_DATA_CNTL__VI                        = 0x5478;
constexpr unsigned int mmDIG6_TMDS_CNTL__VI                             = 0x546B;
constexpr unsigned int mmDIG6_TMDS_CONTROL0_FEEDBACK__VI                = 0x546D;
constexpr unsigned int mmDIG6_TMDS_CONTROL_CHAR__VI                     = 0x546C;
constexpr unsigned int mmDIG6_TMDS_CTL0_1_GEN_CNTL__VI                  = 0x5475;
constexpr unsigned int mmDIG6_TMDS_CTL2_3_GEN_CNTL__VI                  = 0x5476;
constexpr unsigned int mmDIG6_TMDS_CTL_BITS__VI                         = 0x5472;
constexpr unsigned int mmDIG6_TMDS_DCBALANCER_CONTROL__VI               = 0x5473;
constexpr unsigned int mmDIG6_TMDS_DEBUG__VI                            = 0x5471;
constexpr unsigned int mmDIG6_TMDS_STEREOSYNC_CTL_SEL__VI               = 0x546E;
constexpr unsigned int mmDIG6_TMDS_SYNC_CHAR_PATTERN_0_1__VI            = 0x546F;
constexpr unsigned int mmDIG6_TMDS_SYNC_CHAR_PATTERN_2_3__VI            = 0x5470;
constexpr unsigned int mmDIG_BE_CNTL__VI                                = 0x4A47;
constexpr unsigned int mmDIG_BE_EN_CNTL__VI                             = 0x4A48;
constexpr unsigned int mmDIG_CLOCK_PATTERN__VI                          = 0x4A03;
constexpr unsigned int mmDIG_DISPCLK_SWITCH_CNTL__VI                    = 0x4A07;
constexpr unsigned int mmDIG_DISPCLK_SWITCH_STATUS__VI                  = 0x4A08;
constexpr unsigned int mmDIG_FE_CNTL__VI                                = 0x4A00;
constexpr unsigned int mmDIG_FE_TEST_DEBUG_DATA__VI                     = 0x4A7D;
constexpr unsigned int mmDIG_FE_TEST_DEBUG_INDEX__VI                    = 0x4A7C;
constexpr unsigned int mmDIG_FIFO_STATUS__VI                            = 0x4A06;
constexpr unsigned int mmDIG_LANE_ENABLE__VI                            = 0x4A79;
constexpr unsigned int mmDIG_OUTPUT_CRC_CNTL__VI                        = 0x4A01;
constexpr unsigned int mmDIG_OUTPUT_CRC_RESULT__VI                      = 0x4A02;
constexpr unsigned int mmDIG_RANDOM_PATTERN_SEED__VI                    = 0x4A05;
constexpr unsigned int mmDIG_SOFT_RESET__VI                             = 0x1872;
constexpr unsigned int mmDIG_TEST_DEBUG_DATA__VI                        = 0x4A7B;
constexpr unsigned int mmDIG_TEST_DEBUG_INDEX__VI                       = 0x4A7A;
constexpr unsigned int mmDIG_TEST_PATTERN__VI                           = 0x4A04;
constexpr unsigned int mmDISPCLK_CGTT_BLK_CTRL_REG__VI                  = 0x0135;
constexpr unsigned int mmDISPCLK_FREQ_CHANGE_CNTL__VI                   = 0x0131;
constexpr unsigned int mmDISPPLL_BG_CNTL__VI                            = 0x171E;
constexpr unsigned int mmDISP_INTERRUPT_STATUS__VI                      = 0x1857;
constexpr unsigned int mmDISP_INTERRUPT_STATUS_CONTINUE__VI             = 0x1858;
constexpr unsigned int mmDISP_INTERRUPT_STATUS_CONTINUE2__VI            = 0x1859;
constexpr unsigned int mmDISP_INTERRUPT_STATUS_CONTINUE3__VI            = 0x185A;
constexpr unsigned int mmDISP_INTERRUPT_STATUS_CONTINUE4__VI            = 0x185B;
constexpr unsigned int mmDISP_INTERRUPT_STATUS_CONTINUE5__VI            = 0x185C;
constexpr unsigned int mmDISP_INTERRUPT_STATUS_CONTINUE6__VI            = 0x185D;
constexpr unsigned int mmDISP_INTERRUPT_STATUS_CONTINUE7__VI            = 0x185E;
constexpr unsigned int mmDISP_INTERRUPT_STATUS_CONTINUE8__VI            = 0x185F;
constexpr unsigned int mmDISP_INTERRUPT_STATUS_CONTINUE9__VI            = 0x1860;
constexpr unsigned int mmDMCU_DPRX_INTERRUPT_STATUS1__VI                = 0x1634;
constexpr unsigned int mmDMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__VI         = 0x1635;
constexpr unsigned int mmDMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__VI    = 0x1636;
constexpr unsigned int mmDMCU_PERFMON_INTERRUPT_STATUS1__VI             = 0x1644;
constexpr unsigned int mmDMCU_PERFMON_INTERRUPT_STATUS2__VI             = 0x1645;
constexpr unsigned int mmDMCU_PERFMON_INTERRUPT_STATUS3__VI             = 0x1646;
constexpr unsigned int mmDMCU_PERFMON_INTERRUPT_STATUS4__VI             = 0x1647;
constexpr unsigned int mmDMCU_PERFMON_INTERRUPT_STATUS5__VI             = 0x1642;
constexpr unsigned int mmDMCU_PERFMON_INTERRUPT_TO_HOST_EN_MASK1__VI    = 0x167C;
constexpr unsigned int mmDMCU_PERFMON_INTERRUPT_TO_HOST_EN_MASK2__VI    = 0x167D;
constexpr unsigned int mmDMCU_PERFMON_INTERRUPT_TO_HOST_EN_MASK3__VI    = 0x167E;
constexpr unsigned int mmDMCU_PERFMON_INTERRUPT_TO_HOST_EN_MASK4__VI    = 0x167F;
constexpr unsigned int mmDMCU_PERFMON_INTERRUPT_TO_HOST_EN_MASK5__VI    = 0x1633;
constexpr unsigned int mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__VI      = 0x1674;
constexpr unsigned int mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__VI      = 0x1675;
constexpr unsigned int mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__VI      = 0x1676;
constexpr unsigned int mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__VI      = 0x1677;
constexpr unsigned int mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__VI      = 0x1643;
constexpr unsigned int mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__VI  = 0x1678;
constexpr unsigned int mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__VI  = 0x1679;
constexpr unsigned int mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__VI  = 0x167A;
constexpr unsigned int mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__VI  = 0x167B;
constexpr unsigned int mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__VI  = 0x1673;
constexpr unsigned int mmDMCU_SMU_INTERRUPT_CNTL__VI                    = 0x012C;
constexpr unsigned int mmDMCU_SS_INTERRUPT_CNTL_STATUS__VI              = 0x1613;
constexpr unsigned int mmDMCU_UC_CLK_GATING_CNTL__VI                    = 0x161B;
constexpr unsigned int mmDMIF_ADDR_CALC__VI                             = 0x0303;
constexpr unsigned int mmDMIF_ADDR_CONFIG__VI                           = 0x02F5;
constexpr unsigned int mmDMIF_PG0_DPG_HW_DEBUG_11__VI                   = 0x1B3D;
constexpr unsigned int mmDMIF_PG0_DPG_HW_DEBUG_A__VI                    = 0x1B3B;
constexpr unsigned int mmDMIF_PG0_DPG_HW_DEBUG_B__VI                    = 0x1B3C;
constexpr unsigned int mmDMIF_PG0_DPG_PIPE_ARBITRATION_CONTROL1__VI     = 0x1B30;
constexpr unsigned int mmDMIF_PG0_DPG_PIPE_ARBITRATION_CONTROL2__VI     = 0x1B31;
constexpr unsigned int mmDMIF_PG0_DPG_PIPE_DPM_CONTROL__VI              = 0x1B34;
constexpr unsigned int mmDMIF_PG0_DPG_PIPE_NB_PSTATE_CHANGE_CONTROL__VI  = 0x1B36;
constexpr unsigned int mmDMIF_PG0_DPG_PIPE_STUTTER_CONTROL__VI          = 0x1B35;
constexpr unsigned int mmDMIF_PG0_DPG_PIPE_STUTTER_CONTROL_NONLPTCH__VI  = 0x1B37;
constexpr unsigned int mmDMIF_PG0_DPG_PIPE_URGENCY_CONTROL__VI          = 0x1B33;
constexpr unsigned int mmDMIF_PG0_DPG_REPEATER_PROGRAM__VI              = 0x1B3A;
constexpr unsigned int mmDMIF_PG0_DPG_TEST_DEBUG_DATA__VI               = 0x1B39;
constexpr unsigned int mmDMIF_PG0_DPG_TEST_DEBUG_INDEX__VI              = 0x1B38;
constexpr unsigned int mmDMIF_PG0_DPG_WATERMARK_MASK_CONTROL__VI        = 0x1B32;
constexpr unsigned int mmDMIF_PG1_DPG_HW_DEBUG_11__VI                   = 0x1D3D;
constexpr unsigned int mmDMIF_PG1_DPG_HW_DEBUG_A__VI                    = 0x1D3B;
constexpr unsigned int mmDMIF_PG1_DPG_HW_DEBUG_B__VI                    = 0x1D3C;
constexpr unsigned int mmDMIF_PG1_DPG_PIPE_ARBITRATION_CONTROL1__VI     = 0x1D30;
constexpr unsigned int mmDMIF_PG1_DPG_PIPE_ARBITRATION_CONTROL2__VI     = 0x1D31;
constexpr unsigned int mmDMIF_PG1_DPG_PIPE_DPM_CONTROL__VI              = 0x1D34;
constexpr unsigned int mmDMIF_PG1_DPG_PIPE_NB_PSTATE_CHANGE_CONTROL__VI  = 0x1D36;
constexpr unsigned int mmDMIF_PG1_DPG_PIPE_STUTTER_CONTROL__VI          = 0x1D35;
constexpr unsigned int mmDMIF_PG1_DPG_PIPE_STUTTER_CONTROL_NONLPTCH__VI  = 0x1D37;
constexpr unsigned int mmDMIF_PG1_DPG_PIPE_URGENCY_CONTROL__VI          = 0x1D33;
constexpr unsigned int mmDMIF_PG1_DPG_REPEATER_PROGRAM__VI              = 0x1D3A;
constexpr unsigned int mmDMIF_PG1_DPG_TEST_DEBUG_DATA__VI               = 0x1D39;
constexpr unsigned int mmDMIF_PG1_DPG_TEST_DEBUG_INDEX__VI              = 0x1D38;
constexpr unsigned int mmDMIF_PG1_DPG_WATERMARK_MASK_CONTROL__VI        = 0x1D32;
constexpr unsigned int mmDMIF_PG2_DPG_HW_DEBUG_11__VI                   = 0x1F3D;
constexpr unsigned int mmDMIF_PG2_DPG_HW_DEBUG_A__VI                    = 0x1F3B;
constexpr unsigned int mmDMIF_PG2_DPG_HW_DEBUG_B__VI                    = 0x1F3C;
constexpr unsigned int mmDMIF_PG2_DPG_PIPE_ARBITRATION_CONTROL1__VI     = 0x1F30;
constexpr unsigned int mmDMIF_PG2_DPG_PIPE_ARBITRATION_CONTROL2__VI     = 0x1F31;
constexpr unsigned int mmDMIF_PG2_DPG_PIPE_DPM_CONTROL__VI              = 0x1F34;
constexpr unsigned int mmDMIF_PG2_DPG_PIPE_NB_PSTATE_CHANGE_CONTROL__VI  = 0x1F36;
constexpr unsigned int mmDMIF_PG2_DPG_PIPE_STUTTER_CONTROL__VI          = 0x1F35;
constexpr unsigned int mmDMIF_PG2_DPG_PIPE_STUTTER_CONTROL_NONLPTCH__VI  = 0x1F37;
constexpr unsigned int mmDMIF_PG2_DPG_PIPE_URGENCY_CONTROL__VI          = 0x1F33;
constexpr unsigned int mmDMIF_PG2_DPG_REPEATER_PROGRAM__VI              = 0x1F3A;
constexpr unsigned int mmDMIF_PG2_DPG_TEST_DEBUG_DATA__VI               = 0x1F39;
constexpr unsigned int mmDMIF_PG2_DPG_TEST_DEBUG_INDEX__VI              = 0x1F38;
constexpr unsigned int mmDMIF_PG2_DPG_WATERMARK_MASK_CONTROL__VI        = 0x1F32;
constexpr unsigned int mmDMIF_PG3_DPG_HW_DEBUG_11__VI                   = 0x413D;
constexpr unsigned int mmDMIF_PG3_DPG_HW_DEBUG_A__VI                    = 0x413B;
constexpr unsigned int mmDMIF_PG3_DPG_HW_DEBUG_B__VI                    = 0x413C;
constexpr unsigned int mmDMIF_PG3_DPG_PIPE_ARBITRATION_CONTROL1__VI     = 0x4130;
constexpr unsigned int mmDMIF_PG3_DPG_PIPE_ARBITRATION_CONTROL2__VI     = 0x4131;
constexpr unsigned int mmDMIF_PG3_DPG_PIPE_DPM_CONTROL__VI              = 0x4134;
constexpr unsigned int mmDMIF_PG3_DPG_PIPE_NB_PSTATE_CHANGE_CONTROL__VI  = 0x4136;
constexpr unsigned int mmDMIF_PG3_DPG_PIPE_STUTTER_CONTROL__VI          = 0x4135;
constexpr unsigned int mmDMIF_PG3_DPG_PIPE_STUTTER_CONTROL_NONLPTCH__VI  = 0x4137;
constexpr unsigned int mmDMIF_PG3_DPG_PIPE_URGENCY_CONTROL__VI          = 0x4133;
constexpr unsigned int mmDMIF_PG3_DPG_REPEATER_PROGRAM__VI              = 0x413A;
constexpr unsigned int mmDMIF_PG3_DPG_TEST_DEBUG_DATA__VI               = 0x4139;
constexpr unsigned int mmDMIF_PG3_DPG_TEST_DEBUG_INDEX__VI              = 0x4138;
constexpr unsigned int mmDMIF_PG3_DPG_WATERMARK_MASK_CONTROL__VI        = 0x4132;
constexpr unsigned int mmDMIF_PG4_DPG_HW_DEBUG_11__VI                   = 0x433D;
constexpr unsigned int mmDMIF_PG4_DPG_HW_DEBUG_A__VI                    = 0x433B;
constexpr unsigned int mmDMIF_PG4_DPG_HW_DEBUG_B__VI                    = 0x433C;
constexpr unsigned int mmDMIF_PG4_DPG_PIPE_ARBITRATION_CONTROL1__VI     = 0x4330;
constexpr unsigned int mmDMIF_PG4_DPG_PIPE_ARBITRATION_CONTROL2__VI     = 0x4331;
constexpr unsigned int mmDMIF_PG4_DPG_PIPE_DPM_CONTROL__VI              = 0x4334;
constexpr unsigned int mmDMIF_PG4_DPG_PIPE_NB_PSTATE_CHANGE_CONTROL__VI  = 0x4336;
constexpr unsigned int mmDMIF_PG4_DPG_PIPE_STUTTER_CONTROL__VI          = 0x4335;
constexpr unsigned int mmDMIF_PG4_DPG_PIPE_STUTTER_CONTROL_NONLPTCH__VI  = 0x4337;
constexpr unsigned int mmDMIF_PG4_DPG_PIPE_URGENCY_CONTROL__VI          = 0x4333;
constexpr unsigned int mmDMIF_PG4_DPG_REPEATER_PROGRAM__VI              = 0x433A;
constexpr unsigned int mmDMIF_PG4_DPG_TEST_DEBUG_DATA__VI               = 0x4339;
constexpr unsigned int mmDMIF_PG4_DPG_TEST_DEBUG_INDEX__VI              = 0x4338;
constexpr unsigned int mmDMIF_PG4_DPG_WATERMARK_MASK_CONTROL__VI        = 0x4332;
constexpr unsigned int mmDMIF_PG5_DPG_HW_DEBUG_11__VI                   = 0x453D;
constexpr unsigned int mmDMIF_PG5_DPG_HW_DEBUG_A__VI                    = 0x453B;
constexpr unsigned int mmDMIF_PG5_DPG_HW_DEBUG_B__VI                    = 0x453C;
constexpr unsigned int mmDMIF_PG5_DPG_PIPE_ARBITRATION_CONTROL1__VI     = 0x4530;
constexpr unsigned int mmDMIF_PG5_DPG_PIPE_ARBITRATION_CONTROL2__VI     = 0x4531;
constexpr unsigned int mmDMIF_PG5_DPG_PIPE_DPM_CONTROL__VI              = 0x4534;
constexpr unsigned int mmDMIF_PG5_DPG_PIPE_NB_PSTATE_CHANGE_CONTROL__VI  = 0x4536;
constexpr unsigned int mmDMIF_PG5_DPG_PIPE_STUTTER_CONTROL__VI          = 0x4535;
constexpr unsigned int mmDMIF_PG5_DPG_PIPE_STUTTER_CONTROL_NONLPTCH__VI  = 0x4537;
constexpr unsigned int mmDMIF_PG5_DPG_PIPE_URGENCY_CONTROL__VI          = 0x4533;
constexpr unsigned int mmDMIF_PG5_DPG_REPEATER_PROGRAM__VI              = 0x453A;
constexpr unsigned int mmDMIF_PG5_DPG_TEST_DEBUG_DATA__VI               = 0x4539;
constexpr unsigned int mmDMIF_PG5_DPG_TEST_DEBUG_INDEX__VI              = 0x4538;
constexpr unsigned int mmDMIF_PG5_DPG_WATERMARK_MASK_CONTROL__VI        = 0x4532;
constexpr unsigned int mmDMIF_PG6_DPG_HW_DEBUG_11__VI                   = 0x473D;
constexpr unsigned int mmDMIF_PG6_DPG_HW_DEBUG_A__VI                    = 0x473B;
constexpr unsigned int mmDMIF_PG6_DPG_HW_DEBUG_B__VI                    = 0x473C;
constexpr unsigned int mmDMIF_PG6_DPG_PIPE_ARBITRATION_CONTROL1__VI     = 0x4730;
constexpr unsigned int mmDMIF_PG6_DPG_PIPE_ARBITRATION_CONTROL2__VI     = 0x4731;
constexpr unsigned int mmDMIF_PG6_DPG_PIPE_DPM_CONTROL__VI              = 0x4734;
constexpr unsigned int mmDMIF_PG6_DPG_PIPE_NB_PSTATE_CHANGE_CONTROL__VI  = 0x4736;
constexpr unsigned int mmDMIF_PG6_DPG_PIPE_STUTTER_CONTROL__VI          = 0x4735;
constexpr unsigned int mmDMIF_PG6_DPG_PIPE_STUTTER_CONTROL_NONLPTCH__VI  = 0x4737;
constexpr unsigned int mmDMIF_PG6_DPG_PIPE_URGENCY_CONTROL__VI          = 0x4733;
constexpr unsigned int mmDMIF_PG6_DPG_REPEATER_PROGRAM__VI              = 0x473A;
constexpr unsigned int mmDMIF_PG6_DPG_TEST_DEBUG_DATA__VI               = 0x4739;
constexpr unsigned int mmDMIF_PG6_DPG_TEST_DEBUG_INDEX__VI              = 0x4738;
constexpr unsigned int mmDMIF_PG6_DPG_WATERMARK_MASK_CONTROL__VI        = 0x4732;
constexpr unsigned int mmDMIF_P_VMID__VI                                = 0x0300;
constexpr unsigned int mmDMIF_STATUS2__VI                               = 0x0304;
constexpr unsigned int mmDMIF_TEST_DEBUG_DATA__VI                       = 0x0302;
constexpr unsigned int mmDMIF_TEST_DEBUG_INDEX__VI                      = 0x0301;
constexpr unsigned int mmDMIF_URG_OVERRIDE__VI                          = 0x0329;
constexpr unsigned int mmDP0_DP_CONFIG__VI                              = 0x4AA3;
constexpr unsigned int mmDP0_DP_DPHY_8B10B_CNTL__VI                     = 0x4AB4;
constexpr unsigned int mmDP0_DP_DPHY_CNTL__VI                           = 0x4AAF;
constexpr unsigned int mmDP0_DP_DPHY_CRC_CNTL__VI                       = 0x4AB8;
constexpr unsigned int mmDP0_DP_DPHY_CRC_EN__VI                         = 0x4AB7;
constexpr unsigned int mmDP0_DP_DPHY_CRC_MST_CNTL__VI                   = 0x4ABA;
constexpr unsigned int mmDP0_DP_DPHY_CRC_MST_STATUS__VI                 = 0x4ABB;
constexpr unsigned int mmDP0_DP_DPHY_CRC_RESULT__VI                     = 0x4AB9;
constexpr unsigned int mmDP0_DP_DPHY_FAST_TRAINING__VI                  = 0x4ABC;
constexpr unsigned int mmDP0_DP_DPHY_FAST_TRAINING_STATUS__VI           = 0x4ABD;
constexpr unsigned int mmDP0_DP_DPHY_PRBS_CNTL__VI                      = 0x4AB5;
constexpr unsigned int mmDP0_DP_DPHY_SYM0__VI                           = 0x4AB1;
constexpr unsigned int mmDP0_DP_DPHY_SYM1__VI                           = 0x4AB2;
constexpr unsigned int mmDP0_DP_DPHY_SYM2__VI                           = 0x4AB3;
constexpr unsigned int mmDP0_DP_DPHY_TRAINING_PATTERN_SEL__VI           = 0x4AB0;
constexpr unsigned int mmDP0_DP_FE_TEST_DEBUG_DATA__VI                  = 0x4ADB;
constexpr unsigned int mmDP0_DP_FE_TEST_DEBUG_INDEX__VI                 = 0x4ADA;
constexpr unsigned int mmDP0_DP_HBR2_EYE_PATTERN__VI                    = 0x4AAC;
constexpr unsigned int mmDP0_DP_LINK_CNTL__VI                           = 0x4AA0;
constexpr unsigned int mmDP0_DP_LINK_FRAMING_CNTL__VI                   = 0x4AAB;
constexpr unsigned int mmDP0_DP_MSA_COLORIMETRY__VI                     = 0x4AA2;
constexpr unsigned int mmDP0_DP_MSA_MISC__VI                            = 0x4AA6;
constexpr unsigned int mmDP0_DP_MSA_V_TIMING_OVERRIDE1__VI              = 0x4ABE;
constexpr unsigned int mmDP0_DP_MSA_V_TIMING_OVERRIDE2__VI              = 0x4ABF;
constexpr unsigned int mmDP0_DP_MSE_LINK_TIMING__VI                     = 0x4AD6;
constexpr unsigned int mmDP0_DP_MSE_MISC_CNTL__VI                       = 0x4AD7;
constexpr unsigned int mmDP0_DP_MSE_RATE_CNTL__VI                       = 0x4ACF;
constexpr unsigned int mmDP0_DP_MSE_RATE_UPDATE__VI                     = 0x4AD1;
constexpr unsigned int mmDP0_DP_MSE_SAT0__VI                            = 0x4AD2;
constexpr unsigned int mmDP0_DP_MSE_SAT1__VI                            = 0x4AD3;
constexpr unsigned int mmDP0_DP_MSE_SAT2__VI                            = 0x4AD4;
constexpr unsigned int mmDP0_DP_MSE_SAT_UPDATE__VI                      = 0x4AD5;
constexpr unsigned int mmDP0_DP_PIXEL_FORMAT__VI                        = 0x4AA1;
constexpr unsigned int mmDP0_DP_SEC_AUD_M__VI                           = 0x4ACB;
constexpr unsigned int mmDP0_DP_SEC_AUD_M_READBACK__VI                  = 0x4ACC;
constexpr unsigned int mmDP0_DP_SEC_AUD_N__VI                           = 0x4AC9;
constexpr unsigned int mmDP0_DP_SEC_AUD_N_READBACK__VI                  = 0x4ACA;
constexpr unsigned int mmDP0_DP_SEC_CNTL__VI                            = 0x4AC3;
constexpr unsigned int mmDP0_DP_SEC_CNTL1__VI                           = 0x4AC4;
constexpr unsigned int mmDP0_DP_SEC_FRAMING1__VI                        = 0x4AC5;
constexpr unsigned int mmDP0_DP_SEC_FRAMING2__VI                        = 0x4AC6;
constexpr unsigned int mmDP0_DP_SEC_FRAMING3__VI                        = 0x4AC7;
constexpr unsigned int mmDP0_DP_SEC_FRAMING4__VI                        = 0x4AC8;
constexpr unsigned int mmDP0_DP_SEC_PACKET_CNTL__VI                     = 0x4ACE;
constexpr unsigned int mmDP0_DP_SEC_TIMESTAMP__VI                       = 0x4ACD;
constexpr unsigned int mmDP0_DP_STEER_FIFO__VI                          = 0x4AA5;
constexpr unsigned int mmDP0_DP_TEST_DEBUG_DATA__VI                     = 0x4AD9;
constexpr unsigned int mmDP0_DP_TEST_DEBUG_INDEX__VI                    = 0x4AD8;
constexpr unsigned int mmDP0_DP_VID_INTERRUPT_CNTL__VI                  = 0x4AAE;
constexpr unsigned int mmDP0_DP_VID_M__VI                               = 0x4AAA;
constexpr unsigned int mmDP0_DP_VID_MSA_VBID__VI                        = 0x4AAD;
constexpr unsigned int mmDP0_DP_VID_N__VI                               = 0x4AA9;
constexpr unsigned int mmDP0_DP_VID_STREAM_CNTL__VI                     = 0x4AA4;
constexpr unsigned int mmDP0_DP_VID_TIMING__VI                          = 0x4AA8;
constexpr unsigned int mmDP1_DP_CONFIG__VI                              = 0x4BA3;
constexpr unsigned int mmDP1_DP_DPHY_8B10B_CNTL__VI                     = 0x4BB4;
constexpr unsigned int mmDP1_DP_DPHY_CNTL__VI                           = 0x4BAF;
constexpr unsigned int mmDP1_DP_DPHY_CRC_CNTL__VI                       = 0x4BB8;
constexpr unsigned int mmDP1_DP_DPHY_CRC_EN__VI                         = 0x4BB7;
constexpr unsigned int mmDP1_DP_DPHY_CRC_MST_CNTL__VI                   = 0x4BBA;
constexpr unsigned int mmDP1_DP_DPHY_CRC_MST_STATUS__VI                 = 0x4BBB;
constexpr unsigned int mmDP1_DP_DPHY_CRC_RESULT__VI                     = 0x4BB9;
constexpr unsigned int mmDP1_DP_DPHY_FAST_TRAINING__VI                  = 0x4BBC;
constexpr unsigned int mmDP1_DP_DPHY_FAST_TRAINING_STATUS__VI           = 0x4BBD;
constexpr unsigned int mmDP1_DP_DPHY_PRBS_CNTL__VI                      = 0x4BB5;
constexpr unsigned int mmDP1_DP_DPHY_SYM0__VI                           = 0x4BB1;
constexpr unsigned int mmDP1_DP_DPHY_SYM1__VI                           = 0x4BB2;
constexpr unsigned int mmDP1_DP_DPHY_SYM2__VI                           = 0x4BB3;
constexpr unsigned int mmDP1_DP_DPHY_TRAINING_PATTERN_SEL__VI           = 0x4BB0;
constexpr unsigned int mmDP1_DP_FE_TEST_DEBUG_DATA__VI                  = 0x4BDB;
constexpr unsigned int mmDP1_DP_FE_TEST_DEBUG_INDEX__VI                 = 0x4BDA;
constexpr unsigned int mmDP1_DP_HBR2_EYE_PATTERN__VI                    = 0x4BAC;
constexpr unsigned int mmDP1_DP_LINK_CNTL__VI                           = 0x4BA0;
constexpr unsigned int mmDP1_DP_LINK_FRAMING_CNTL__VI                   = 0x4BAB;
constexpr unsigned int mmDP1_DP_MSA_COLORIMETRY__VI                     = 0x4BA2;
constexpr unsigned int mmDP1_DP_MSA_MISC__VI                            = 0x4BA6;
constexpr unsigned int mmDP1_DP_MSA_V_TIMING_OVERRIDE1__VI              = 0x4BBE;
constexpr unsigned int mmDP1_DP_MSA_V_TIMING_OVERRIDE2__VI              = 0x4BBF;
constexpr unsigned int mmDP1_DP_MSE_LINK_TIMING__VI                     = 0x4BD6;
constexpr unsigned int mmDP1_DP_MSE_MISC_CNTL__VI                       = 0x4BD7;
constexpr unsigned int mmDP1_DP_MSE_RATE_CNTL__VI                       = 0x4BCF;
constexpr unsigned int mmDP1_DP_MSE_RATE_UPDATE__VI                     = 0x4BD1;
constexpr unsigned int mmDP1_DP_MSE_SAT0__VI                            = 0x4BD2;
constexpr unsigned int mmDP1_DP_MSE_SAT1__VI                            = 0x4BD3;
constexpr unsigned int mmDP1_DP_MSE_SAT2__VI                            = 0x4BD4;
constexpr unsigned int mmDP1_DP_MSE_SAT_UPDATE__VI                      = 0x4BD5;
constexpr unsigned int mmDP1_DP_PIXEL_FORMAT__VI                        = 0x4BA1;
constexpr unsigned int mmDP1_DP_SEC_AUD_M__VI                           = 0x4BCB;
constexpr unsigned int mmDP1_DP_SEC_AUD_M_READBACK__VI                  = 0x4BCC;
constexpr unsigned int mmDP1_DP_SEC_AUD_N__VI                           = 0x4BC9;
constexpr unsigned int mmDP1_DP_SEC_AUD_N_READBACK__VI                  = 0x4BCA;
constexpr unsigned int mmDP1_DP_SEC_CNTL__VI                            = 0x4BC3;
constexpr unsigned int mmDP1_DP_SEC_CNTL1__VI                           = 0x4BC4;
constexpr unsigned int mmDP1_DP_SEC_FRAMING1__VI                        = 0x4BC5;
constexpr unsigned int mmDP1_DP_SEC_FRAMING2__VI                        = 0x4BC6;
constexpr unsigned int mmDP1_DP_SEC_FRAMING3__VI                        = 0x4BC7;
constexpr unsigned int mmDP1_DP_SEC_FRAMING4__VI                        = 0x4BC8;
constexpr unsigned int mmDP1_DP_SEC_PACKET_CNTL__VI                     = 0x4BCE;
constexpr unsigned int mmDP1_DP_SEC_TIMESTAMP__VI                       = 0x4BCD;
constexpr unsigned int mmDP1_DP_STEER_FIFO__VI                          = 0x4BA5;
constexpr unsigned int mmDP1_DP_TEST_DEBUG_DATA__VI                     = 0x4BD9;
constexpr unsigned int mmDP1_DP_TEST_DEBUG_INDEX__VI                    = 0x4BD8;
constexpr unsigned int mmDP1_DP_VID_INTERRUPT_CNTL__VI                  = 0x4BAE;
constexpr unsigned int mmDP1_DP_VID_M__VI                               = 0x4BAA;
constexpr unsigned int mmDP1_DP_VID_MSA_VBID__VI                        = 0x4BAD;
constexpr unsigned int mmDP1_DP_VID_N__VI                               = 0x4BA9;
constexpr unsigned int mmDP1_DP_VID_STREAM_CNTL__VI                     = 0x4BA4;
constexpr unsigned int mmDP1_DP_VID_TIMING__VI                          = 0x4BA8;
constexpr unsigned int mmDP2_DP_CONFIG__VI                              = 0x4CA3;
constexpr unsigned int mmDP2_DP_DPHY_8B10B_CNTL__VI                     = 0x4CB4;
constexpr unsigned int mmDP2_DP_DPHY_CNTL__VI                           = 0x4CAF;
constexpr unsigned int mmDP2_DP_DPHY_CRC_CNTL__VI                       = 0x4CB8;
constexpr unsigned int mmDP2_DP_DPHY_CRC_EN__VI                         = 0x4CB7;
constexpr unsigned int mmDP2_DP_DPHY_CRC_MST_CNTL__VI                   = 0x4CBA;
constexpr unsigned int mmDP2_DP_DPHY_CRC_MST_STATUS__VI                 = 0x4CBB;
constexpr unsigned int mmDP2_DP_DPHY_CRC_RESULT__VI                     = 0x4CB9;
constexpr unsigned int mmDP2_DP_DPHY_FAST_TRAINING__VI                  = 0x4CBC;
constexpr unsigned int mmDP2_DP_DPHY_FAST_TRAINING_STATUS__VI           = 0x4CBD;
constexpr unsigned int mmDP2_DP_DPHY_PRBS_CNTL__VI                      = 0x4CB5;
constexpr unsigned int mmDP2_DP_DPHY_SYM0__VI                           = 0x4CB1;
constexpr unsigned int mmDP2_DP_DPHY_SYM1__VI                           = 0x4CB2;
constexpr unsigned int mmDP2_DP_DPHY_SYM2__VI                           = 0x4CB3;
constexpr unsigned int mmDP2_DP_DPHY_TRAINING_PATTERN_SEL__VI           = 0x4CB0;
constexpr unsigned int mmDP2_DP_FE_TEST_DEBUG_DATA__VI                  = 0x4CDB;
constexpr unsigned int mmDP2_DP_FE_TEST_DEBUG_INDEX__VI                 = 0x4CDA;
constexpr unsigned int mmDP2_DP_HBR2_EYE_PATTERN__VI                    = 0x4CAC;
constexpr unsigned int mmDP2_DP_LINK_CNTL__VI                           = 0x4CA0;
constexpr unsigned int mmDP2_DP_LINK_FRAMING_CNTL__VI                   = 0x4CAB;
constexpr unsigned int mmDP2_DP_MSA_COLORIMETRY__VI                     = 0x4CA2;
constexpr unsigned int mmDP2_DP_MSA_MISC__VI                            = 0x4CA6;
constexpr unsigned int mmDP2_DP_MSA_V_TIMING_OVERRIDE1__VI              = 0x4CBE;
constexpr unsigned int mmDP2_DP_MSA_V_TIMING_OVERRIDE2__VI              = 0x4CBF;
constexpr unsigned int mmDP2_DP_MSE_LINK_TIMING__VI                     = 0x4CD6;
constexpr unsigned int mmDP2_DP_MSE_MISC_CNTL__VI                       = 0x4CD7;
constexpr unsigned int mmDP2_DP_MSE_RATE_CNTL__VI                       = 0x4CCF;
constexpr unsigned int mmDP2_DP_MSE_RATE_UPDATE__VI                     = 0x4CD1;
constexpr unsigned int mmDP2_DP_MSE_SAT0__VI                            = 0x4CD2;
constexpr unsigned int mmDP2_DP_MSE_SAT1__VI                            = 0x4CD3;
constexpr unsigned int mmDP2_DP_MSE_SAT2__VI                            = 0x4CD4;
constexpr unsigned int mmDP2_DP_MSE_SAT_UPDATE__VI                      = 0x4CD5;
constexpr unsigned int mmDP2_DP_PIXEL_FORMAT__VI                        = 0x4CA1;
constexpr unsigned int mmDP2_DP_SEC_AUD_M__VI                           = 0x4CCB;
constexpr unsigned int mmDP2_DP_SEC_AUD_M_READBACK__VI                  = 0x4CCC;
constexpr unsigned int mmDP2_DP_SEC_AUD_N__VI                           = 0x4CC9;
constexpr unsigned int mmDP2_DP_SEC_AUD_N_READBACK__VI                  = 0x4CCA;
constexpr unsigned int mmDP2_DP_SEC_CNTL__VI                            = 0x4CC3;
constexpr unsigned int mmDP2_DP_SEC_CNTL1__VI                           = 0x4CC4;
constexpr unsigned int mmDP2_DP_SEC_FRAMING1__VI                        = 0x4CC5;
constexpr unsigned int mmDP2_DP_SEC_FRAMING2__VI                        = 0x4CC6;
constexpr unsigned int mmDP2_DP_SEC_FRAMING3__VI                        = 0x4CC7;
constexpr unsigned int mmDP2_DP_SEC_FRAMING4__VI                        = 0x4CC8;
constexpr unsigned int mmDP2_DP_SEC_PACKET_CNTL__VI                     = 0x4CCE;
constexpr unsigned int mmDP2_DP_SEC_TIMESTAMP__VI                       = 0x4CCD;
constexpr unsigned int mmDP2_DP_STEER_FIFO__VI                          = 0x4CA5;
constexpr unsigned int mmDP2_DP_TEST_DEBUG_DATA__VI                     = 0x4CD9;
constexpr unsigned int mmDP2_DP_TEST_DEBUG_INDEX__VI                    = 0x4CD8;
constexpr unsigned int mmDP2_DP_VID_INTERRUPT_CNTL__VI                  = 0x4CAE;
constexpr unsigned int mmDP2_DP_VID_M__VI                               = 0x4CAA;
constexpr unsigned int mmDP2_DP_VID_MSA_VBID__VI                        = 0x4CAD;
constexpr unsigned int mmDP2_DP_VID_N__VI                               = 0x4CA9;
constexpr unsigned int mmDP2_DP_VID_STREAM_CNTL__VI                     = 0x4CA4;
constexpr unsigned int mmDP2_DP_VID_TIMING__VI                          = 0x4CA8;
constexpr unsigned int mmDP3_DP_CONFIG__VI                              = 0x4DA3;
constexpr unsigned int mmDP3_DP_DPHY_8B10B_CNTL__VI                     = 0x4DB4;
constexpr unsigned int mmDP3_DP_DPHY_CNTL__VI                           = 0x4DAF;
constexpr unsigned int mmDP3_DP_DPHY_CRC_CNTL__VI                       = 0x4DB8;
constexpr unsigned int mmDP3_DP_DPHY_CRC_EN__VI                         = 0x4DB7;
constexpr unsigned int mmDP3_DP_DPHY_CRC_MST_CNTL__VI                   = 0x4DBA;
constexpr unsigned int mmDP3_DP_DPHY_CRC_MST_STATUS__VI                 = 0x4DBB;
constexpr unsigned int mmDP3_DP_DPHY_CRC_RESULT__VI                     = 0x4DB9;
constexpr unsigned int mmDP3_DP_DPHY_FAST_TRAINING__VI                  = 0x4DBC;
constexpr unsigned int mmDP3_DP_DPHY_FAST_TRAINING_STATUS__VI           = 0x4DBD;
constexpr unsigned int mmDP3_DP_DPHY_PRBS_CNTL__VI                      = 0x4DB5;
constexpr unsigned int mmDP3_DP_DPHY_SYM0__VI                           = 0x4DB1;
constexpr unsigned int mmDP3_DP_DPHY_SYM1__VI                           = 0x4DB2;
constexpr unsigned int mmDP3_DP_DPHY_SYM2__VI                           = 0x4DB3;
constexpr unsigned int mmDP3_DP_DPHY_TRAINING_PATTERN_SEL__VI           = 0x4DB0;
constexpr unsigned int mmDP3_DP_FE_TEST_DEBUG_DATA__VI                  = 0x4DDB;
constexpr unsigned int mmDP3_DP_FE_TEST_DEBUG_INDEX__VI                 = 0x4DDA;
constexpr unsigned int mmDP3_DP_HBR2_EYE_PATTERN__VI                    = 0x4DAC;
constexpr unsigned int mmDP3_DP_LINK_CNTL__VI                           = 0x4DA0;
constexpr unsigned int mmDP3_DP_LINK_FRAMING_CNTL__VI                   = 0x4DAB;
constexpr unsigned int mmDP3_DP_MSA_COLORIMETRY__VI                     = 0x4DA2;
constexpr unsigned int mmDP3_DP_MSA_MISC__VI                            = 0x4DA6;
constexpr unsigned int mmDP3_DP_MSA_V_TIMING_OVERRIDE1__VI              = 0x4DBE;
constexpr unsigned int mmDP3_DP_MSA_V_TIMING_OVERRIDE2__VI              = 0x4DBF;
constexpr unsigned int mmDP3_DP_MSE_LINK_TIMING__VI                     = 0x4DD6;
constexpr unsigned int mmDP3_DP_MSE_MISC_CNTL__VI                       = 0x4DD7;
constexpr unsigned int mmDP3_DP_MSE_RATE_CNTL__VI                       = 0x4DCF;
constexpr unsigned int mmDP3_DP_MSE_RATE_UPDATE__VI                     = 0x4DD1;
constexpr unsigned int mmDP3_DP_MSE_SAT0__VI                            = 0x4DD2;
constexpr unsigned int mmDP3_DP_MSE_SAT1__VI                            = 0x4DD3;
constexpr unsigned int mmDP3_DP_MSE_SAT2__VI                            = 0x4DD4;
constexpr unsigned int mmDP3_DP_MSE_SAT_UPDATE__VI                      = 0x4DD5;
constexpr unsigned int mmDP3_DP_PIXEL_FORMAT__VI                        = 0x4DA1;
constexpr unsigned int mmDP3_DP_SEC_AUD_M__VI                           = 0x4DCB;
constexpr unsigned int mmDP3_DP_SEC_AUD_M_READBACK__VI                  = 0x4DCC;
constexpr unsigned int mmDP3_DP_SEC_AUD_N__VI                           = 0x4DC9;
constexpr unsigned int mmDP3_DP_SEC_AUD_N_READBACK__VI                  = 0x4DCA;
constexpr unsigned int mmDP3_DP_SEC_CNTL__VI                            = 0x4DC3;
constexpr unsigned int mmDP3_DP_SEC_CNTL1__VI                           = 0x4DC4;
constexpr unsigned int mmDP3_DP_SEC_FRAMING1__VI                        = 0x4DC5;
constexpr unsigned int mmDP3_DP_SEC_FRAMING2__VI                        = 0x4DC6;
constexpr unsigned int mmDP3_DP_SEC_FRAMING3__VI                        = 0x4DC7;
constexpr unsigned int mmDP3_DP_SEC_FRAMING4__VI                        = 0x4DC8;
constexpr unsigned int mmDP3_DP_SEC_PACKET_CNTL__VI                     = 0x4DCE;
constexpr unsigned int mmDP3_DP_SEC_TIMESTAMP__VI                       = 0x4DCD;
constexpr unsigned int mmDP3_DP_STEER_FIFO__VI                          = 0x4DA5;
constexpr unsigned int mmDP3_DP_TEST_DEBUG_DATA__VI                     = 0x4DD9;
constexpr unsigned int mmDP3_DP_TEST_DEBUG_INDEX__VI                    = 0x4DD8;
constexpr unsigned int mmDP3_DP_VID_INTERRUPT_CNTL__VI                  = 0x4DAE;
constexpr unsigned int mmDP3_DP_VID_M__VI                               = 0x4DAA;
constexpr unsigned int mmDP3_DP_VID_MSA_VBID__VI                        = 0x4DAD;
constexpr unsigned int mmDP3_DP_VID_N__VI                               = 0x4DA9;
constexpr unsigned int mmDP3_DP_VID_STREAM_CNTL__VI                     = 0x4DA4;
constexpr unsigned int mmDP3_DP_VID_TIMING__VI                          = 0x4DA8;
constexpr unsigned int mmDP4_DP_CONFIG__VI                              = 0x4EA3;
constexpr unsigned int mmDP4_DP_DPHY_8B10B_CNTL__VI                     = 0x4EB4;
constexpr unsigned int mmDP4_DP_DPHY_CNTL__VI                           = 0x4EAF;
constexpr unsigned int mmDP4_DP_DPHY_CRC_CNTL__VI                       = 0x4EB8;
constexpr unsigned int mmDP4_DP_DPHY_CRC_EN__VI                         = 0x4EB7;
constexpr unsigned int mmDP4_DP_DPHY_CRC_MST_CNTL__VI                   = 0x4EBA;
constexpr unsigned int mmDP4_DP_DPHY_CRC_MST_STATUS__VI                 = 0x4EBB;
constexpr unsigned int mmDP4_DP_DPHY_CRC_RESULT__VI                     = 0x4EB9;
constexpr unsigned int mmDP4_DP_DPHY_FAST_TRAINING__VI                  = 0x4EBC;
constexpr unsigned int mmDP4_DP_DPHY_FAST_TRAINING_STATUS__VI           = 0x4EBD;
constexpr unsigned int mmDP4_DP_DPHY_PRBS_CNTL