import { formatAmountForDisplay } from "@/lib/utils";

export default function CustomDonationInput({
  name,
  min,
  max,
  currency,
  step,
  onChange,
  value,
  className,
}: {
  name: string;
  min: number;
  max: number;
  currency: string;
  step: number;
  onChange: (e: React.ChangeEvent<HTMLInputElement>) => void;
  value: number;
  className?: string;
}): JSX.Element {
  return (
    <div className="w-full max-w-md">
      <label className="block mb-2">
        Custom donation amount ({formatAmountForDisplay(min, currency)}-
        {formatAmountForDisplay(max, currency)}):
      </label>
      <input
        type="range"
        name={name}
        min={min}
        max={max}
        step={step}
        onChange={onChange}
        value={value}
        className={`w-full `} 
      />
    </div>
  );
}
