import {
    Box,
    List,
    ListItemButton,
    ListItemIcon,
    ListItemText
} from "@mui/material";
import { Run } from "@sematic/common/src/Models";
import { RunTreeNode } from "@sematic/common/src/interfaces/graph";
import { ExtractContextType } from "@sematic/common/src/utils/typings";
import { Fragment, useCallback } from "react";
import RunStateChip from "src/components/RunStateChip";
import { usePipelinePanelsContext } from "src/hooks/pipelineHooks";
import PipelinePanelsContext from "src/pipelines/PipelinePanelsContext";

export default function RunTree(props: {
    runTreeNodes: Array<RunTreeNode>;
}) {
    let { runTreeNodes } = props;

    const { selectedRun, setSelectedPanelItem, setSelectedRunId, setSelectedArtifactName  } 
  = usePipelinePanelsContext() as ExtractContextType<typeof PipelinePanelsContext> & {
      selectedRun: Run
  };

    const onSelectRun = useCallback((runId: string) => {
        setSelectedArtifactName("");
        setSelectedRunId(runId);
        setSelectedPanelItem("run");
    }, [setSelectedArtifactName, setSelectedPanelItem, setSelectedRunId]);

    if (runTreeNodes.length === 0) {
        return <></>;
    }
    return (
        <List
            sx={{
                pt: 0,
            }}
        >
            {runTreeNodes.map(({run, children}) => (
                <Fragment key={`${run!.id}---${run!.future_state}`}>
                    <ListItemButton
                        onClick={() => onSelectRun(run!.id)}
                        key={run!.id}
                        sx={{ height: "30px" }}
                        selected={selectedRun.id === run!.id}
                    >
                        <ListItemIcon sx={{ minWidth: "20px" }}>
                            <RunStateChip run={run!} />
                        </ListItemIcon>
                        <ListItemText primary={run!.name} />
                    </ListItemButton>
                    {children.length > 0 && (
                        <Box marginLeft={3}>
                            <RunTree runTreeNodes={children}/>
                        </Box>
                    )}
                </Fragment>
            ))}
        </List>
    );
}
