# Company Handbook 🦊

Welcome to Sematic's company handbook.

Here you'll find everything about our company: why we started, culture, values, strategy and roadmap.

Transparency and openness are some of our core values. We believe they lead to better outcomes for everyone.
That is why we make our handbook, our processes, and our source code available to the public.

We also like to share ideas early and often with our community, so we can iterate faster to get better results. 

This handbook is not a static document, it will change as we learn more and grow together. We'll keep it up to date as much as possible, and it exists alongside our main code base on Github for that reason. Occasionally you will see that some pages are still in draft, which we will label appropriately.

Feedback on the handbook is encouraged.

## Company
### Our Story

Sematic was founded by Emmanuel and Jai in May 2022. We met in 2018, on our
first day working at Cruise, a self-driving car company based in San Francisco,
CA. At Cruise we worked on ML Infrastructure, and together with a great team,
developed tools that enabled Cruise's [Continuous Learning
Machine](https://medium.com/cruise/cruise-continuous-learning-machine-30d60f4c691b).

Inspired by our learnings, we started Sematic and gathered early support from Y Combinator (S22). Our goal is clear: make it painless to prototype and productionize machine learning models and data science pipelines. 

By speaking with many Data Scientists and ML Engineers across the industry, we made two broad observations:

* Jupyter Notebooks are the tool of choice for early prototyping and tinkering on new ideas, because of their visual and interactive aspects
* Many ML teams are struggling to train or fine-tune new models on their own data, in order to scale their business to new use cases, new regions or cohorts

While we are big fans of Notebooks for exploratory work, the gap between Notebooks and product code is a big leap. What if there was a way to iterate, collaborate, and visualize data directly on a production-ready pipeline? This is where Sematic comes in.

Sematic is building an open-source development toolkit to help Data Scientists and ML Engineers prototype and productionize their work in days instead of weeks.

### June - August 2022 (Alpha / Prototype)

In this period we are focused on two things: building the initial product with barebones functionality and listening to Data Scientists and ML Engineers.

## Culture and Values

## Strategy

We want to help companies prototype and productionize ML more easily: we believe it should be fun, collaborative and easy to scale.

* *Fun and fast:* we believe users should be able to iterate with as close to vanilla Python as possible.

* *Easy to collaborate:* visualize models, datasets, and metrics, and to share those with others for comments and feedback. It's important to keep all these interactions as close to the actual work as possible for documentation.

* *Easier to scale:* a more seamless transition from a working prototype to a reliable production pipeline, that can help users speed up deployments.

## Roadmap
Our roadmap is published on Trello.
