# Configuration

**semantic-release** configuration consists of:

- Git repository ([URL](#repositoryurl) and options [release branches](#branches) and [tag format](#tagformat))
- Plugins [declaration](#plugins) and options
- Run mode ([debug](#debug), [dry run](#dryrun) and [local (no CI)](#ci))

All of these options can be configured through config file, CLI arguments or by extending a [shareable configuration](shareable-configurations.md).

Additionally, metadata of Git tags generated by **semantic-release** can be customized via standard [Git environment variables](#git-environment-variables).

## Configuration file

**semantic-release**’s [options](#options), mode and [plugins](plugins.md) can be set via either:

- A `.releaserc` file, written in YAML or JSON, with optional extensions: `.yaml`/`.yml`/`.json`/`.js`/`.cjs`/`.mjs`
- A `release.config.(js|cjs|.mjs)` file that exports an object
- A `release` key in the project's `package.json` file

Alternatively, some options can be set via CLI arguments.

The following three examples are the same. Use main instead of master if your default branch is main.

- Via `release` key in the project's `package.json` file:

```json
{
  "release": {
    "branches": ["master", "next"]
  }
}
```

- Via `.releaserc` file:

```json
{
  "branches": ["master", "next"]
}
```

- Via `release.config.cjs` file:

```js
/**
 * @type {import('semantic-release').GlobalConfig}
 */
module.exports = {
  branches: ["master", "next"],
};
```

- Via `release.config.mjs` file:

```js
/**
 * @type {import('semantic-release').GlobalConfig}
 */
export default {
  branches: ["master", "next"],
};
```

- Via CLI argument:

```bash
$ semantic-release --branches next
```

**Note**: CLI arguments take precedence over options configured in the configuration file.

**Note**: Plugin options cannot be defined via CLI arguments and must be defined in the configuration file.

**Note**: When configuring via `package.json`, the configuration must be under the `release` property. However, when using a `.releaserc` or a `release.config` file, the configuration must be set without a `release` property.

## Options

### extends

Type: `Array`, `String`<br>
CLI arguments: `-e`, `--extends`

List of modules or file paths containing a [shareable configuration](shareable-configurations.md). If multiple shareable configurations are set, they will be imported in the order defined with each configuration option taking precedence over the options defined in a previous shareable configuration.

**Note**: Options defined via CLI arguments or in the configuration file will take precedence over the ones defined in any shareable configuration.

### branches

Type: `Array`, `String`, `Object`<br>
Default: `['+([0-9])?(.{+([0-9]),x}).x', 'master', 'main', 'next', 'next-major', {name: 'beta', prerelease: true}, {name: 'alpha', prerelease: true}]`<br>
CLI arguments: `--branches`

The branches on which releases should happen. By default **semantic-release** will release:

- regular releases to the default distribution channel from the branch `master` or `main`
- regular releases to a distribution channel matching the branch name from any existing branch with a name matching a maintenance release range (`N.N.x` or `N.x.x` or `N.x` with `N` being a number)
- regular releases to the `next` distribution channel from the branch `next` if it exists
- regular releases to the `next-major` distribution channel from the branch `next-major` if it exists
- pre-releases to the `beta` distribution channel from the branch `beta` if it exists
- pre-releases to the `alpha` distribution channel from the branch `alpha` if it exists

**Note**: Branches configuration key accepts [**micromatch**](https://github.com/micromatch/micromatch?tab=readme-ov-file#matching-features) globs.

**Note**: If your repository does not have a release branch, then **semantic-release** will fail with an `ERELEASEBRANCHES` error message. If you are using the default configuration, you can fix this error by pushing a `master` or `main` branch.

**Note**: Once **semantic-release** is configured, any user with the permission to push commits on one of those branches will be able to publish a release. It is recommended to protect those branches, for example with [GitHub protected branches](https://docs.github.com/github/administering-a-repository/about-protected-branches).

See [Workflow configuration](workflow-configuration.md#workflow-configuration) for more details.

### repositoryUrl

Type: `String`<br>
Default: `repository` property in `package.json` or [git origin url](https://git-scm.com/book/en/v2/Git-Basics-Working-with-Remotes)<br>
CLI arguments: `-r`, `--repository-url`

The git repository URL.

Any valid git url format is supported (See [Git protocols](https://git-scm.com/book/en/v2/Git-on-the-Server-The-Protocols)).

### tagFormat

Type: `String`<br>
Default: `v${version}`<br>
CLI arguments: `-t`, `--tag-format`

The [Git tag](https://git-scm.com/book/en/v2/Git-Basics-Tagging) format used by **semantic-release** to identify releases. The tag name is generated with [Lodash template](https://lodash.com/docs#template) and will be compiled with the `version` variable.

**Note**: The `tagFormat` must contain the `version` variable exactly once and compile to a [valid Git reference](https://git-scm.com/docs/git-check-ref-format#_description).

### plugins

Type: `Array`<br>
Default: `['@semantic-release/commit-analyzer', '@semantic-release/release-notes-generator', '@semantic-release/npm', '@semantic-release/github']`<br>
CLI arguments: `-p`, `--plugins`

Define the list of plugins to use. Plugins will run in series, in the order defined, for each [steps](../../README.md#release-steps) if they implement it.

Plugins configuration can defined by wrapping the name and an options object in an array.

See [Plugins configuration](plugins.md#plugins) for more details.

### dryRun

Type: `Boolean`<br>
Default: `false` if running in a CI environment, `true` otherwise<br>
CLI arguments: `-d`, `--dry-run`

The objective of the dry-run mode is to get a preview of the pending release. Dry-run mode skips the following steps: prepare, publish, addChannel, success and fail. In addition to this it prints the next version and release notes to the console.

**Note**: The Dry-run mode verifies the repository push permission, even though nothing will be pushed. The verification is done to help user to figure out potential configuration issues.

### ci

Type: `Boolean`<br>
Default: `true`<br>
CLI arguments: `--ci` / `--no-ci`

Set to `false` to skip Continuous Integration environment verifications. This allows for making releases from a local machine.

**Note**: The CLI arguments `--no-ci` is equivalent to `--ci false`.

### debug

Type: `Boolean`<br>
Default: `false`<br>
CLI argument: `--debug`

Output debugging information. This can also be enabled by setting the `DEBUG` environment variable to `semantic-release:*`.

**Note**: The `debug` is used only supported via CLI argument. To enable debug mode from the [JS API](../developer-guide/js-api.md#javascript-api) use `require('debug').enable('semantic-release:*')`.

## Git environment variables

| Variable              | Description                                                                                                                                                                                                                    | Default                              |
| --------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------ |
| `GIT_AUTHOR_NAME`     | The author name associated with the [Git release tag](https://git-scm.com/book/en/v2/Git-Basics-Tagging). See [Git environment variables](https://git-scm.com/book/en/v2/Git-Internals-Environment-Variables#_committing).     | @semantic-release-bot.               |
| `GIT_AUTHOR_EMAIL`    | The author email associated with the [Git release tag](https://git-scm.com/book/en/v2/Git-Basics-Tagging). See [Git environment variables](https://git-scm.com/book/en/v2/Git-Internals-Environment-Variables#_committing).    | @semantic-release-bot email address. |
| `GIT_COMMITTER_NAME`  | The committer name associated with the [Git release tag](https://git-scm.com/book/en/v2/Git-Basics-Tagging). See [Git environment variables](https://git-scm.com/book/en/v2/Git-Internals-Environment-Variables#_committing).  | @semantic-release-bot.               |
| `GIT_COMMITTER_EMAIL` | The committer email associated with the [Git release tag](https://git-scm.com/book/en/v2/Git-Basics-Tagging). See [Git environment variables](https://git-scm.com/book/en/v2/Git-Internals-Environment-Variables#_committing). | @semantic-release-bot email address. |

## Existing version tags

**semantic-release** uses [Git tags](https://git-scm.com/book/en/v2/Git-Basics-Tagging) to determine the commits added since the last release.
If a release has been published before setting up **semantic-release** you must make sure the most recent commit included in the last published release is in the [release branches](#branches) history and is tagged with the version released, formatted according to the [tag format](#tagformat) configured (defaults to `vx.y.z`).

If the previous releases were published with [`npm publish`](https://docs.npmjs.com/cli/publish) this should already be the case.

For example, if your release branch is `master`/`main`, the last release published on your project is `1.1.0` and the last commit included has the sha `1234567`, you must make sure this commit is in `master`/`main` history and is tagged with `v1.1.0`.

```bash
# Make sure the commit 1234567 is in the release branch history
$ git branch --contains 1234567

# If the commit is not in the branch history it means that either:
# - you use a different branch than the one your release from before
# - or the commit sha has been rewritten (with git rebase)
# In both cases you need to configure your repository to have the last release commit in the history of the release branch

# List the tags for the commit 1234567
$ git tag --contains 1234567

# If v1.1.0 is not in the list you add it with
$ git tag v1.1.0 1234567
$ git push origin v1.1.0
```
