# Summary

## Usage

- [Getting started](docs/usage/getting-started.md)
- [Installation](docs/usage/installation.md)
- [CI Configuration](docs/usage/ci-configuration.md)
- [Configuration](docs/usage/configuration.md)
- [Plugins](docs/usage/plugins.md)
- [Release Workflow configuration](docs/usage/workflow-configuration.md)
- [Shareable configurations](docs/usage/shareable-configurations.md)

## Extending

- [Plugins](docs/extending/plugins-list.md)
- [Shareable configuration](docs/extending/shareable-configurations-list.md)

## Recipes

- [CI configurations](docs/recipes/ci-configurations/README.md)
  - [CircleCI 2.0](docs/recipes/ci-configurations/circleci-workflows.md)
  - [Travis CI](docs/recipes/ci-configurations/travis.md)
  - [GitLab CI](docs/recipes/ci-configurations/gitlab-ci.md)
  - [GitHub Actions](docs/recipes/ci-configurations/github-actions.md)
  - [Jenkins CI](docs/recipes/ci-configurations/jenkins-ci.md)
- [Git hosted services](docs/recipes/git-hosted-services/README.md)
  - [Git authentication with SSH keys](docs/recipes/git-hosted-services/git-auth-ssh-keys.md)
- [Release Workflow](docs/recipes/release-workflow/README.md)
  - [Publishing on distribution channels](docs/recipes/release-workflow/distribution-channels.md)
  - [Publishing maintenance releases](docs/recipes/release-workflow/maintenance-releases.md)
  - [Publishing pre-releases](docs/recipes/release-workflow/pre-releases.md)

## Developer guide

- [JavaScript API](docs/developer-guide/js-api.md)
- [Plugin development](docs/developer-guide/plugin.md)
- [Shareable configuration development](docs/developer-guide/shareable-configuration.md)

## Support

- [Resources](docs/support/resources.md)
- [Frequently Asked Questions](docs/support/FAQ.md)
- [Troubleshooting](docs/support/troubleshooting.md)
- [Node version requirement](docs/support/node-version.md)
- [Node Support Policy](docs/support/node-support-policy.md)
- [Git version requirement](docs/support/git-version.md)
