# Options

| Option                  | Type   | Description                                                                                                                                                                                                                                                                                |
| ----------------------- | ------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| `--include`             | String | Takes a comma delimited list of glob patterns to include for code blocks.                                                                                                                                                                                                                  |
| `--exclude`             | String | Takes a comma delmited list of glob patterns to exclude for code blocks.                                                                                                                                                                                                                   |
| `--exclude-priority`    | bool   | In case if the include and exclude patterns conflict, this will determine which pattern to prioritize. By default the include patterns are prioritized. If this option is included, the the exclude patterns will be prioritized.                                                          |
| `--exclude-from-tree`   | bool   | Whether to exclude the files/directories from the source tree based on the exclude patterns. By default excluded files are included in the file tree. If this option is included, only explicitly included files will be in the file tree.                                                                                                                                                                                               |
| `--gitignore`           | bool   | Whether to respect the `.gitignore` file. By default, the patterns in the `.gitignore` file will be ignored. If this option is included, files in the `.gitignore` patterns will be included.  |
| `-d`, `--diff-staged`   | bool   | Whether to capture the git diff for staged changes only (equivalent to running `git diff --staged`).                                                                                                                                                                                       |
| `-u`, `--diff-unstaged` | bool   | Whether to capture the git diff for the unstaged changes only (equivalent to running `git diff`).                                                                                                                                                                                          |
| `--no-tokens`              | bool   | Whether to display the approximate token count for the generated prompt. If this option is included, this will toggle the token count off.                                                                                                                                                |
| `c`, `--encoding`       | String | The tokenizer to use for the approximate token count. Defaults to `cl100k`.                                                                                                                                                                                                                |
| `-o`, `--output`        | String | A file path can be passed with this option to dump the generated prompt to an output file.                                                                                                                                                                                                 |
| `-l`, `--no-line-numbers`  | bool   | Whether to include toggle off the line numbers inside the markdown code blocks.                                                                                                                                                  |
| `--no-codeblock`        | bool   | Whether or not to wrap the code blocks inside markdown code blocks. If this option is included, the code will not be wrapped in markdown code blocks.                                                                                                                                      |
| `--relative-paths`      | bool   | Toggle whether to render relative paths or absolute paths in the generated prompt. If this option is included, the absolute paths will be used.                                                                                                                                            |
| `--no-clipboard`        | bool   | Whether to copy the generated prompt to the clipboard. If this option is included, the output will not be automatically copied to the clipboard.                                                                                                                                           |
| `-t`, `--template`      | String | The file path to the template to use for rendering.                                                                                                                                                                                                                                        |
| `--spinner`             | bool   | Whether to render the progress spinner. If this option is included, the spinner will not be rendered.                                                                                                                                                                                      |
| `json`                  | bool   | Whether to print the intermediate JSON. If this option is included, the JSON will be printed.                                                                                                                                                                                              |
| `--issue`               | int    | The github issue number to fetch.                                                                                                                                                                                                                                                          |
| `--verbose`             | bool   | Toggle verbose output for investigating glob pattern matching.                                                                                                                                                                                                                             |
| `-h`, `--help`          | bool   | Print the help message.                                                                                                                                                                                                                                                                    |
| `-V`, `--version`       | bool   | Print the tool version.                                                                                                                                                                                                                                                                    |
