/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.spdy;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.spdy.SpdyDataFrame;
import org.jboss.netty.util.internal.StringUtil;

public class DefaultSpdyDataFrame
implements SpdyDataFrame {
    private int streamId;
    private boolean last;
    private boolean compressed;
    private ChannelBuffer data = ChannelBuffers.EMPTY_BUFFER;

    public DefaultSpdyDataFrame(int streamId) {
        this.setStreamId(streamId);
    }

    @Deprecated
    public int getStreamID() {
        return this.getStreamId();
    }

    public int getStreamId() {
        return this.streamId;
    }

    @Deprecated
    public void setStreamID(int streamId) {
        this.setStreamId(streamId);
    }

    public void setStreamId(int streamId) {
        if (streamId <= 0) {
            throw new IllegalArgumentException("Stream-ID must be positive: " + streamId);
        }
        this.streamId = streamId;
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    @Deprecated
    public boolean isCompressed() {
        return this.compressed;
    }

    @Deprecated
    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public ChannelBuffer getData() {
        return this.data;
    }

    public void setData(ChannelBuffer data) {
        if (data == null) {
            data = ChannelBuffers.EMPTY_BUFFER;
        }
        if (data.readableBytes() > 0xFFFFFF) {
            throw new IllegalArgumentException("data payload cannot exceed 16777215 bytes");
        }
        this.data = data;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("(last: ");
        buf.append(this.isLast());
        buf.append("; compressed: ");
        buf.append(this.isCompressed());
        buf.append(')');
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Stream-ID = ");
        buf.append(this.streamId);
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Size = ");
        buf.append(this.data.readableBytes());
        return buf.toString();
    }
}

